/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Error;
import com.sas.launcher.client.LauncherRuntimeException;
import com.sas.launcher.client.Packet;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ErrorPacket
extends Packet {
    private static final Logger logger = LoggerFactory.getLogger(ErrorPacket.class);
    private final Integer status;
    private final List<String> messages;
    private final ByteBuffer payload;

    private ErrorPacket(InputStream stream) {
        try {
            DataInputStream dataStream = new DataInputStream(stream);
            Integer payloadSize = dataStream.readInt();
            byte[] data = new byte[payloadSize.intValue()];
            dataStream.read(data, 0, payloadSize);
            ByteBuffer buffer = ByteBuffer.wrap(data);
            Integer status = buffer.getInt();
            List<String> messages = this.readList(buffer);
            this.status = status;
            this.messages = messages;
            buffer.clear();
            this.payload = buffer;
        }
        catch (IOException cause) {
            logger.debug("Failed to read error packet: " + cause.getMessage(), (Throwable)cause);
            throw new LauncherRuntimeException(Error.Type.PACKET_READ_ERROR.toError(new Object[0]), (Throwable)cause);
        }
    }

    static ErrorPacket fromPacketPayload(InputStream stream) {
        return new ErrorPacket(stream);
    }

    private static String readString(ByteBuffer buffer) {
        Integer stringSize = buffer.getInt();
        byte[] string = new byte[stringSize.intValue()];
        buffer.get(string, 0, stringSize);
        return new String(string);
    }

    @Override
    ByteBuffer getPayload() {
        return this.payload.asReadOnlyBuffer();
    }

    private List<String> readList(ByteBuffer buffer) {
        Integer listSize = buffer.getInt();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < listSize; ++i) {
            list.add(ErrorPacket.readString(buffer));
        }
        return list;
    }

    Integer getStatus() {
        return this.status;
    }

    String getStatusAsString() {
        return "0x" + Integer.toHexString(this.getStatus()).toUpperCase();
    }

    private List<String> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    String getMessagesAsString() {
        return this.getMessages().toString();
    }

    public String toString() {
        return "ErrorPacket{status=" + this.status + ", messages=" + this.messages + ", payload=" + this.payload + '}';
    }
}

