/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Function;
import com.sas.launcher.client.Objects;
import com.sas.launcher.client.Optional;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class Error {
    private final Type type;
    private final String message;

    private Error(Type type, final Object ... args) {
        this.type = Optional.ofNullable(type).orElse(Type.INTERNAL_SERVER_ERROR);
        this.message = Optional.ofNullable(type).map(new Function<Type, String>(){

            @Override
            public String apply(Type t) {
                return t.getMessage(args);
            }
        }).orElse("");
    }

    public static Error create(Type type, Object ... args) {
        return new Error(type, args);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Error error = (Error)o;
        return Objects.equals((Object)this.type, (Object)error.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type});
    }

    public Integer getCode() {
        return this.type.getCode();
    }

    public String getMessage() {
        return this.message;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return "[code: " + this.getCode() + ", message: \"" + this.getMessage() + "\"]";
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type INVALID_GRID_PROVIDER = new Type(30000, "invalid.grid.provider.error.fmt.txt");
        public static final /* enum */ Type SSL_SOCKET_FACTORY_INIT_ERROR = new Type(30001, "ssl.socket.factory.init.error.txt");
        public static final /* enum */ Type SERVER_PROPERTIES_CREATION_ERROR = new Type(30002, "server.properties.creation.error.txt");
        public static final /* enum */ Type GRID_INFO_REQUEST_CREATION_ERROR = new Type(30003, "grid.info.request.creation.error.txt");
        public static final /* enum */ Type KILL_REQUEST_CREATION_ERROR = new Type(30004, "kill.request.creation.error.txt");
        public static final /* enum */ Type INVALID_UUID = new Type(30005, "invalid.uuid.error.fmt.txt");
        public static final /* enum */ Type INVALID_PACKET_TYPE = new Type(30006, "invalid.packet.type.error.fmt.txt");
        public static final /* enum */ Type PACKET_READ_ERROR = new Type(30007, "packet.read.error.txt");
        public static final /* enum */ Type PROCESS_CREATION_ERROR = new Type(30008, "process.creation.error.txt");
        public static final /* enum */ Type INVALID_LAUNCH_TYPE = new Type(30009, "invalid.launch.type.error.fmt.txt");
        public static final /* enum */ Type INVALID_PROCESS_STATE_ID = new Type(30010, "invalid.process.state.id.error.fmt.txt");
        public static final /* enum */ Type CLIENT_CONNECT_ERROR = new Type(30011, "client.connect.error.txt");
        public static final /* enum */ Type SERVER_ERROR = new Type(30012, "server.error.fmt.txt");
        public static final /* enum */ Type CLIENT_LAUNCH_ERROR = new Type(30013, "client.launch.error.fmt.txt");
        public static final /* enum */ Type CLIENT_PING_ERROR = new Type(30014, "client.ping.error.fmt.txt");
        public static final /* enum */ Type CLIENT_KILL_ERROR = new Type(30015, "client.kill.error.fmt.txt");
        public static final /* enum */ Type CLIENT_STATUS_ERROR = new Type(30016, "client.status.error.fmt.txt");
        public static final /* enum */ Type CLIENT_GRIDINFO_ERROR = new Type(30017, "client.gridinfo.error.fmt.txt");
        public static final /* enum */ Type INVALID_PACKET = new Type(30018, "invalid.packet.error.txt");
        public static final /* enum */ Type INVALID_COMMAND = new Type(30019, "invalid.command.error.fmt.txt");
        public static final /* enum */ Type ILLEGAL_PACKET_PAYLOAD_READ_ERROR = new Type(30020, "illegal.packet.payload.read.error.fmt.txt");
        public static final /* enum */ Type INVALID_SERVER_RESPONSE_ERROR = new Type(30021, "invalid.server.response.error.txt");
        public static final /* enum */ Type INVALID_HOSTNAME = new Type(30022, "invalid.hostname.error.fmt.txt");
        public static final /* enum */ Type INVALID_PORT = new Type(30023, "invalid.port.error.fmt.txt");
        public static final /* enum */ Type CONTEXT_NOT_FOUND_BY_ID = new Type(30024, "context.not.found.by.id.error.fmt.txt");
        public static final /* enum */ Type INVALID_LAUNCH_TYPE_ID = new Type(30025, "invalid.launch.type.id.error.fmt.txt");
        public static final /* enum */ Type LAUNCHER_SERVER_UNAVAILABLE = new Type(30026, "launcher.server.unavailable.error.txt");
        public static final /* enum */ Type FAILED_TO_DETERMINE_LAUNCHER_SERVER_OPERATING_SYSTEM = new Type(30027, "failed.to.determine.launcher.server.operating.system.error.fmt.txt");
        public static final /* enum */ Type UNSUPPORTED_LAUNCHER_SERVER_OPERATING_SYSTEM = new Type(30028, "unsupported.launcher.server.operating.system.error.fmt.txt");
        public static final /* enum */ Type PROCESS_LAUNCH_ERROR = new Type(30029, "process.launch.error.txt");
        public static final /* enum */ Type INVALID_PROCESS_STATE = new Type(30030, "invalid.process.state.error.fmt.txt");
        public static final /* enum */ Type INVALID_IDENTITY_TYPE = new Type(30031, "invalid.identity.type.error.fmt.txt");
        public static final /* enum */ Type INVALID_CONTEXT_ID = new Type(30032, "invalid.context.id.error.fmt.txt");
        public static final /* enum */ Type INVALID_OPERATING_SYSTEM = new Type(30033, "invalid.operating.system.error.fmt.txt");
        public static final /* enum */ Type PROCESS_NOT_FOUND_BY_ID = new Type(30034, "process.not.found.by.id.error.fmt.txt");
        public static final /* enum */ Type PROCESS_NOT_KILLABLE = new Type(30035, "process.not.killable.error.fmt.txt");
        public static final /* enum */ Type PROCESS_KILL_ERROR = new Type(30036, "process.kill.error.fmt.txt");
        public static final /* enum */ Type INVALID_PROCESS_CANCELATION_REQUEST_STATE = new Type(30037, "invalid.process.cancelation.request.state.error.fmt.txt");
        public static final /* enum */ Type INTERNAL_SERVER_ERROR = new Type(30038, "internal.server.error.txt");
        public static final /* enum */ Type INVALID_GRID_OPTIONS = new Type(30039, "invalid.grid.options.error.fmt.txt");
        public static final /* enum */ Type INVALID_GRID_RESOURCES = new Type(30040, "invalid.grid.resources.error.fmt.txt");
        public static final /* enum */ Type INVALID_OPTIONS_SET_ID = new Type(30041, "invalid.options.set.id.error.fmt.txt");
        public static final /* enum */ Type INVALID_OPTIONS_SET_NAME = new Type(30042, "invalid.options.set.name.error.fmt.txt");
        public static final /* enum */ Type INVALID_CLIENT_NAME = new Type(30043, "invalid.oauth.client.name.error.fmt.txt");
        public static final /* enum */ Type INVALID_USER_ID = new Type(30044, "invalid.user.id.error.fmt.txt");
        public static final /* enum */ Type INVALID_GROUP_ID = new Type(30045, "invalid.group.id.error.fmt.txt");
        public static final /* enum */ Type REST_CLIENT_ERROR = new Type(30046, "rest.client.error.fmt.txt");
        public static final /* enum */ Type USER_GROUPS_RETRIEVAL_ERROR = new Type(30047, "user.groups.retrieval.error.fmt.txt");
        public static final /* enum */ Type OPTIONS_SET_NOT_FOUND_BY_ID = new Type(30048, "options.set.not.found.by.id.error.fmt.txt");
        public static final /* enum */ Type UNMAPPED_OPTIONS_SET = new Type(30049, "unmapped.options.set.error.fmt.txt");
        public static final /* enum */ Type OPTIONS_SET_NOT_FOUND_BY_NAME = new Type(30050, "options.set.not.found.by.name.error.fmt.txt");
        public static final /* enum */ Type OAUTH_CLIENT_APPLICATION_LOOKUP_ERROR = new Type(30051, "oauth.client.application.lookup.error.fmt.txt");
        public static final /* enum */ Type OAUTH_CLIENT_APPLICATION_NAME_UNREGISTERED = new Type(30052, "oauth.client.application.name.unregistered.error.fmt.txt");
        public static final /* enum */ Type GRIDINFO_RETRIEVAL_ERROR = new Type(30053, "gridinfo.retrieval.error.txt");
        public static final /* enum */ Type INVALID_SAS_SERVICES_URL = new Type(30054, "invalid.sas.services.url.error.fmt.txt");
        public static final /* enum */ Type INVALID_CONSUL_URL = new Type(30055, "invalid.consul.url.error.fmt.txt");
        public static final /* enum */ Type INVALID_SERVER = new Type(30056, "invalid.server.error.txt");
        public static final /* enum */ Type VALIDATION_ERROR = new Type(30057, "validation.error.txt");
        public static final /* enum */ Type INVALID_PORT_RANGE = new Type(30058, "invalid.port.range.error.fmt.txt");
        public static final /* enum */ Type INVALID_CONTEXT = new Type(30059, "invalid.context.error.fmt.txt");
        public static final /* enum */ Type INVALID_CONTEXT_NAME = new Type(30060, "invalid.context.name.error.fmt.txt");
        public static final /* enum */ Type INVALID_CONTEXT_DEPLOYMENT_INSTALL_BASE_PATH = new Type(30061, "invalid.context.deployment.install.base.path.error.fmt.txt");
        public static final /* enum */ Type INVALID_CONTEXT_DEPLOYMENT_CONFIG_BASE_PATH = new Type(30062, "invalid.context.deployment.config.base.path.error.fmt.txt");
        public static final /* enum */ Type INCONSISTENT_CONTEXT_DEPLOYMENTS_PATHS = new Type(30063, "inconsistent.context.deployment.paths.error.fmt.txt");
        public static final /* enum */ Type INVALID_IDENTITY_NAME = new Type(30064, "invalid.identity.name.error.fmt.txt");
        public static final /* enum */ Type CONTEXT_NOT_FOUND_BY_NAME = new Type(30065, "context.not.found.by.name.error.fmt.txt");
        public static final /* enum */ Type INVALID_OPTIONS_SET_MAPPING_NAME = new Type(30066, "invalid.options.set.mapping.name.error.fmt.txt");
        public static final /* enum */ Type INVALID_CLIENT_ID = new Type(30067, "invalid.client.id.error.fmt.txt");
        public static final /* enum */ Type INVALID_IDENTITY = new Type(30068, "invalid.identity.error.fmt.txt");
        public static final /* enum */ Type OPTIONS_SET_MAPPING_NOT_FOUND_BY_ID = new Type(30069, "options.set.mapping.not.found.by.id.error.fmt.txt");
        public static final /* enum */ Type OPTIONS_SET_MAPPING_NOT_FOUND_BY_NAME = new Type(30070, "options.set.mapping.not.found.by.name.error.fmt.txt");
        public static final /* enum */ Type INVALID_PROCESS_ID = new Type(30071, "invalid.process.id.error.fmt.txt");
        public static final /* enum */ Type PROCESS_UPDATE_EVENT_CREATION_ERROR = new Type(30072, "process.update.event.creation.error.fmt.txt");
        public static final /* enum */ Type INVALID_LAUNCH_REQUEST_LAUNCH_TYPE = new Type(30073, "invalid.launch.request.launch.type.error.fmt.txt");
        public static final /* enum */ Type PROCESS_EXIT_CODE_UNAVAILABLE = new Type(30074, "process.exit.code.unavailable.error.fmt.txt");
        public static final /* enum */ Type INVALID_CONTEXT_GRID_PROPERTIES = new Type(30075, "invalid.context.grid.properties.error.fmt.txt");
        public static final /* enum */ Type OPTIONS_SET_MAPPING_MISSING_CONTEXT = new Type(30076, "options.set.mapping.missing.context.error.txt");
        public static final /* enum */ Type OPTIONS_SET_MAPPING_MISSING_OPTIONS_SET = new Type(30077, "options.set.mapping.missing.options.set.error.txt");
        public static final /* enum */ Type OPTIONS_SET_MAPPING_MISSING_CLIENT_ID = new Type(30078, "options.set.mapping.missing.client.id.error.txt");
        public static final /* enum */ Type OPTIONS_SET_MAPPING_MISSING_IDENTITY = new Type(30079, "options.set.mapping.missing.identity.error.txt");
        public static final /* enum */ Type INVALID_PROCESS_NAME = new Type(30080, "invalid.process.name.error.fmt.txt");
        public static final /* enum */ Type INVALID_USER = new Type(30081, "invalid.user.error.fmt.txt");
        public static final /* enum */ Type INVALID_DEPLOYMENT_ID = new Type(30082, "invalid.deployment.id.error.fmt.txt");
        public static final /* enum */ Type INVALID_DEPLOYMENT_INSTALL_BASE_PATH = new Type(30083, "invalid.deployment.install.base.path.error.fmt.txt");
        public static final /* enum */ Type INVALID_DEPLOYMENT_CONFIG_BASE_PATH = new Type(30084, "invalid.deployment.config.base.path.error.fmt.txt");
        public static final /* enum */ Type INVALID_DEPLOYMENT_INSTALL_DIRECTORY_NAME = new Type(30085, "invalid.deployment.install.directory.name.error.fmt.txt");
        public static final /* enum */ Type INVALID_DEPLOYMENT_CONFIG_DIRECTORY_NAME = new Type(30086, "invalid.deployment.config.directory.name.error.fmt.txt");
        public static final /* enum */ Type INVALID_DEPLOYMENT_CONFIG_INSTANCE_ID = new Type(30087, "invalid.deployment.config.instance.id.error.fmt.txt");
        public static final /* enum */ Type INVALID_DEPLOYMENT = new Type(30088, "invalid.deployment.error.fmt.txt");
        public static final /* enum */ Type LAUNCH_CONTAINER_SERVER_UNASSIGNED_ERROR = new Type(30089, "launch.container.server.unassigned.error.fmt.txt");
        public static final /* enum */ Type PROCESS_SAVE_ERROR = new Type(30090, "process.save.error.fmt.txt");
        public static final /* enum */ Type INVALID_PATH = new Type(30091, "invalid.path.error.fmt.txt");
        public static final /* enum */ Type INVALID_OPTIONS_SET_MAPPING_ID = new Type(30092, "invalid.options.set.mapping.id.error.fmt.txt");
        public static final /* enum */ Type MISSING_IF_MATCH_HEADER = new Type(30093, "missing.if.match.header.error.txt");
        public static final /* enum */ Type URL_REQUEST_BODY_ID_MISMATCH = new Type(30094, "url.request.body.id.mismatch.error.fmt.txt");
        public static final /* enum */ Type OPTIMISTIC_LOCK_ERROR = new Type(30095, "optimistic.lock.error.fmt.txt");
        public static final /* enum */ Type INVALID_ETAG = new Type(30096, "invalid.etag.error.fmt.txt");
        public static final /* enum */ Type OAUTH_CLIENT_APPLICATIONS_RETRIEVAL_ERROR = new Type(30097, "oauth.client.applications.retrieval.error.txt");
        public static final /* enum */ Type INVALID_TENANT_ID = new Type(30098, "invalid.tenant.id.error.fmt.txt");
        public static final /* enum */ Type INVALID_VAULT_URL = new Type(30099, "invalid.vault.url.error.fmt.txt");
        public static final /* enum */ Type VAULT_ERROR = new Type(30100, "vault.error.txt");
        public static final /* enum */ Type INVALID_SERVER_STATE = new Type(30101, "invalid.server.state.error.fmt.txt");
        public static final /* enum */ Type INVALID_SERVER_TYPE = new Type(30102, "invalid.server.type.error.fmt.txt");
        public static final /* enum */ Type INVALID_RABBITMQ_USERNAME = new Type(30103, "invalid.rabbitmq.username.error.fmt.txt");
        public static final /* enum */ Type NULL_PASSWORD_ERROR = new Type(30104, "null.password.error.txt");
        public static final /* enum */ Type PASSWORD_ENCRYPTION_ERROR = new Type(30105, "password.encryption.error.txt");
        public static final /* enum */ Type PASSWORD_DECRYPTION_ERROR = new Type(30106, "password.decryption.error.txt");
        public static final /* enum */ Type KERBEROS_SECURITY_CONTEXT_CREATION_ERROR = new Type(30107, "kerberos.security.context.creation.error.txt");
        public static final /* enum */ Type KERBEROS_HANDSHAKE_ERROR = new Type(30108, "kerberos.handshake.error.txt");
        public static final /* enum */ Type NULL_OAUTH_TOKEN = new Type(30109, "null.oauth.token.error.txt");
        public static final /* enum */ Type UNEXPECTED_PACKET_TYPE = new Type(30110, "unexpected.packet.type.error.fmt.txt");
        public static final /* enum */ Type AUTHENTICATION_KERBEROS_PACKET_WRITE_ERROR = new Type(30111, "authentication.kerberos.packet.write.error.txt");
        public static final /* enum */ Type AUTHENTICATION_KERBEROS_INVALID_PACKET_TYPE_ERROR = new Type(30112, "authentication.kerberos.invalid.packet.type.error.txt");
        public static final /* enum */ Type PACKET_WRITE_ERROR = new Type(30113, "packet.write.error.txt");
        public static final /* enum */ Type AUTHENTICATION_KERBEROS_CREDENTIAL_RETRIEVAL_ERROR = new Type(30114, "authentication.kerberos.credential.retrieval.error.txt");
        public static final /* enum */ Type AUTHENTICATION_CREDENTIAL_UNAVAILABLE = new Type(30115, "authentication.credential.unavailable.error.txt");
        public static final /* enum */ Type AUTHENTICATION_UNSUPPORTED_CREDENTIAL_TYPE = new Type(30116, "authentication.unsupported.credential.type.error.txt");
        public static final /* enum */ Type INVALID_SERVICE_PRINCIPAL_NAME = new Type(30117, "invalid.service.principal.name.error.fmt.txt");
        public static final /* enum */ Type INVALID_SERVICE_PRINCIPAL_NAME_SERVICE_CLASS = new Type(30118, "invalid.service.principal.name.service.class.error.fmt.txt");
        public static final /* enum */ Type INVALID_SERVICE_PRINCIPAL_NAME_HOST = new Type(30119, "invalid.service.principal.name.host.error.fmt.txt");
        public static final /* enum */ Type INVALID_AUTHENTICATION_DOMAIN = new Type(30120, "invalid.authentication.domain.error.fmt.txt");
        public static final /* enum */ Type DOMAIN_SECRETS_RETRIEVAL_ERROR = new Type(30121, "domain.secrets.retrieval.error.fmt.txt");
        public static final /* enum */ Type AUTHENTICATION_DOMAIN_UNDEFINED = new Type(30122, "authentication.domain.undefined.error.txt");
        public static final /* enum */ Type AUTHENTICATION_DOMAIN_CREDENTIAL_UNAVAILABLE = new Type(30123, "authentication.domain.credential.unavailable.error.fmt.txt");
        public static final /* enum */ Type PORT_RANGE_PARSE_ERROR = new Type(30124, "port.range.parse.error.fmt.txt");
        public static final /* enum */ Type PROCESS_DELETE_ERROR = new Type(30125, "process.delete.error.fmt.txt");
        public static final /* enum */ Type CLIENT_DELETE_ERROR = new Type(30126, "client.delete.error.fmt.txt");
        public static final /* enum */ Type CLIENT_SERVERINFO_ERROR = new Type(30127, "client.serverinfo.error.fmt.txt");
        public static final /* enum */ Type CLIENT_DISCONNECTED_ERROR = new Type(30128, "client.disconnected.error.fmt.txt");
        public static final /* enum */ Type INVALID_PRODUCT_CODE = new Type(30129, "invalid.product.code.error.fmt.txt");
        public static final /* enum */ Type CLIENT_PRODUCT_INFO_ERROR = new Type(30130, "client.product.info.error.fmt.txt");
        static final Integer ERROR_RANGE_START;
        static final Integer ERROR_RANGE_END;
        private static final String RESOURCE_BUNDLE_NAME = "com.sas.launcher.L10nMessages";
        private static final ResourceBundle RESOURCE_BUNDLE;
        private final Integer code;
        private final String key;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(Integer code, String key) {
            assert (key != null);
            this.code = code;
            this.key = key;
        }

        public static Type fromCode(Integer code) {
            for (Type launcherError : Type.values()) {
                if (!launcherError.getCode().equals(code)) continue;
                return launcherError;
            }
            return INTERNAL_SERVER_ERROR;
        }

        public String toString() {
            return "LauncherError{code=" + this.code + ", key='" + this.key + '\'' + '}';
        }

        public Integer getCode() {
            return this.code;
        }

        private String getMessage(Object ... args) {
            String message = RESOURCE_BUNDLE.getString(this.key);
            MessageFormat formatter = new MessageFormat("");
            formatter.applyPattern(message);
            return formatter.format(args);
        }

        public Error toError(Object ... args) {
            return Error.create(this, args);
        }

        private static /* synthetic */ Type[] $values() {
            return new Type[]{INVALID_GRID_PROVIDER, SSL_SOCKET_FACTORY_INIT_ERROR, SERVER_PROPERTIES_CREATION_ERROR, GRID_INFO_REQUEST_CREATION_ERROR, KILL_REQUEST_CREATION_ERROR, INVALID_UUID, INVALID_PACKET_TYPE, PACKET_READ_ERROR, PROCESS_CREATION_ERROR, INVALID_LAUNCH_TYPE, INVALID_PROCESS_STATE_ID, CLIENT_CONNECT_ERROR, SERVER_ERROR, CLIENT_LAUNCH_ERROR, CLIENT_PING_ERROR, CLIENT_KILL_ERROR, CLIENT_STATUS_ERROR, CLIENT_GRIDINFO_ERROR, INVALID_PACKET, INVALID_COMMAND, ILLEGAL_PACKET_PAYLOAD_READ_ERROR, INVALID_SERVER_RESPONSE_ERROR, INVALID_HOSTNAME, INVALID_PORT, CONTEXT_NOT_FOUND_BY_ID, INVALID_LAUNCH_TYPE_ID, LAUNCHER_SERVER_UNAVAILABLE, FAILED_TO_DETERMINE_LAUNCHER_SERVER_OPERATING_SYSTEM, UNSUPPORTED_LAUNCHER_SERVER_OPERATING_SYSTEM, PROCESS_LAUNCH_ERROR, INVALID_PROCESS_STATE, INVALID_IDENTITY_TYPE, INVALID_CONTEXT_ID, INVALID_OPERATING_SYSTEM, PROCESS_NOT_FOUND_BY_ID, PROCESS_NOT_KILLABLE, PROCESS_KILL_ERROR, INVALID_PROCESS_CANCELATION_REQUEST_STATE, INTERNAL_SERVER_ERROR, INVALID_GRID_OPTIONS, INVALID_GRID_RESOURCES, INVALID_OPTIONS_SET_ID, INVALID_OPTIONS_SET_NAME, INVALID_CLIENT_NAME, INVALID_USER_ID, INVALID_GROUP_ID, REST_CLIENT_ERROR, USER_GROUPS_RETRIEVAL_ERROR, OPTIONS_SET_NOT_FOUND_BY_ID, UNMAPPED_OPTIONS_SET, OPTIONS_SET_NOT_FOUND_BY_NAME, OAUTH_CLIENT_APPLICATION_LOOKUP_ERROR, OAUTH_CLIENT_APPLICATION_NAME_UNREGISTERED, GRIDINFO_RETRIEVAL_ERROR, INVALID_SAS_SERVICES_URL, INVALID_CONSUL_URL, INVALID_SERVER, VALIDATION_ERROR, INVALID_PORT_RANGE, INVALID_CONTEXT, INVALID_CONTEXT_NAME, INVALID_CONTEXT_DEPLOYMENT_INSTALL_BASE_PATH, INVALID_CONTEXT_DEPLOYMENT_CONFIG_BASE_PATH, INCONSISTENT_CONTEXT_DEPLOYMENTS_PATHS, INVALID_IDENTITY_NAME, CONTEXT_NOT_FOUND_BY_NAME, INVALID_OPTIONS_SET_MAPPING_NAME, INVALID_CLIENT_ID, INVALID_IDENTITY, OPTIONS_SET_MAPPING_NOT_FOUND_BY_ID, OPTIONS_SET_MAPPING_NOT_FOUND_BY_NAME, INVALID_PROCESS_ID, PROCESS_UPDATE_EVENT_CREATION_ERROR, INVALID_LAUNCH_REQUEST_LAUNCH_TYPE, PROCESS_EXIT_CODE_UNAVAILABLE, INVALID_CONTEXT_GRID_PROPERTIES, OPTIONS_SET_MAPPING_MISSING_CONTEXT, OPTIONS_SET_MAPPING_MISSING_OPTIONS_SET, OPTIONS_SET_MAPPING_MISSING_CLIENT_ID, OPTIONS_SET_MAPPING_MISSING_IDENTITY, INVALID_PROCESS_NAME, INVALID_USER, INVALID_DEPLOYMENT_ID, INVALID_DEPLOYMENT_INSTALL_BASE_PATH, INVALID_DEPLOYMENT_CONFIG_BASE_PATH, INVALID_DEPLOYMENT_INSTALL_DIRECTORY_NAME, INVALID_DEPLOYMENT_CONFIG_DIRECTORY_NAME, INVALID_DEPLOYMENT_CONFIG_INSTANCE_ID, INVALID_DEPLOYMENT, LAUNCH_CONTAINER_SERVER_UNASSIGNED_ERROR, PROCESS_SAVE_ERROR, INVALID_PATH, INVALID_OPTIONS_SET_MAPPING_ID, MISSING_IF_MATCH_HEADER, URL_REQUEST_BODY_ID_MISMATCH, OPTIMISTIC_LOCK_ERROR, INVALID_ETAG, OAUTH_CLIENT_APPLICATIONS_RETRIEVAL_ERROR, INVALID_TENANT_ID, INVALID_VAULT_URL, VAULT_ERROR, INVALID_SERVER_STATE, INVALID_SERVER_TYPE, INVALID_RABBITMQ_USERNAME, NULL_PASSWORD_ERROR, PASSWORD_ENCRYPTION_ERROR, PASSWORD_DECRYPTION_ERROR, KERBEROS_SECURITY_CONTEXT_CREATION_ERROR, KERBEROS_HANDSHAKE_ERROR, NULL_OAUTH_TOKEN, UNEXPECTED_PACKET_TYPE, AUTHENTICATION_KERBEROS_PACKET_WRITE_ERROR, AUTHENTICATION_KERBEROS_INVALID_PACKET_TYPE_ERROR, PACKET_WRITE_ERROR, AUTHENTICATION_KERBEROS_CREDENTIAL_RETRIEVAL_ERROR, AUTHENTICATION_CREDENTIAL_UNAVAILABLE, AUTHENTICATION_UNSUPPORTED_CREDENTIAL_TYPE, INVALID_SERVICE_PRINCIPAL_NAME, INVALID_SERVICE_PRINCIPAL_NAME_SERVICE_CLASS, INVALID_SERVICE_PRINCIPAL_NAME_HOST, INVALID_AUTHENTICATION_DOMAIN, DOMAIN_SECRETS_RETRIEVAL_ERROR, AUTHENTICATION_DOMAIN_UNDEFINED, AUTHENTICATION_DOMAIN_CREDENTIAL_UNAVAILABLE, PORT_RANGE_PARSE_ERROR, PROCESS_DELETE_ERROR, CLIENT_DELETE_ERROR, CLIENT_SERVERINFO_ERROR, CLIENT_DISCONNECTED_ERROR, INVALID_PRODUCT_CODE, CLIENT_PRODUCT_INFO_ERROR};
        }

        static {
            $VALUES = Type.$values();
            ERROR_RANGE_START = 30000;
            ERROR_RANGE_END = 30999;
            RESOURCE_BUNDLE = ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME);
        }
    }
}

