/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Error;
import com.sas.launcher.client.LaunchPacket;
import com.sas.launcher.client.LauncherRuntimeException;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AuthKerberosPacket
extends LaunchPacket {
    private static final Logger logger = LoggerFactory.getLogger(AuthKerberosPacket.class);
    private final byte[] token;
    private final ByteBuffer payload;

    private AuthKerberosPacket(byte[] token) {
        this.token = Arrays.copyOf(token, token.length);
        ByteBuffer payload = ByteBuffer.allocate(4 + token.length);
        payload.putInt(token.length);
        payload.put(token, 0, token.length);
        this.payload = payload;
    }

    private AuthKerberosPacket(InputStream stream) {
        try {
            DataInputStream dataStream = new DataInputStream(stream);
            Integer payloadSize = dataStream.readInt();
            byte[] data = new byte[payloadSize.intValue()];
            dataStream.read(data, 0, payloadSize);
            ByteBuffer buffer = ByteBuffer.wrap(data);
            Integer tokenSize = buffer.getInt();
            this.token = new byte[tokenSize.intValue()];
            buffer.get(this.token);
            buffer.clear();
            this.payload = buffer;
        }
        catch (IOException cause) {
            logger.debug("Failed to read Kerberos authentication packet: " + cause.getMessage(), (Throwable)cause);
            throw new LauncherRuntimeException(Error.Type.PACKET_READ_ERROR.toError(new Object[0]), (Throwable)cause);
        }
    }

    static AuthKerberosPacket fromPacketPayload(InputStream stream) {
        return new AuthKerberosPacket(stream);
    }

    static AuthKerberosPacket create(byte[] token) {
        return new AuthKerberosPacket(token);
    }

    byte[] getToken() {
        return Arrays.copyOf(this.token, this.token.length);
    }

    @Override
    public ByteBuffer getPayload() {
        ByteBuffer payload = ByteBuffer.allocate(this.payload.limit());
        payload.put(this.payload.array(), 0, this.payload.limit());
        payload.clear();
        return payload.asReadOnlyBuffer();
    }

    public String toString() {
        return "AuthKerberosPacket{token=" + Arrays.toString(this.token) + ", payload=" + this.payload + '}';
    }
}

