/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.security.AccessControlException;
import java.security.AccessController;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.impl.drda.NetworkServerControlImpl;
import org.apache.derby.mbeans.drda.NetworkServerMBean;
import org.apache.derby.shared.common.security.SystemPermission;

class NetworkServerMBeanImpl
implements NetworkServerMBean {
    private NetworkServerControlImpl server;
    private final long startTime;
    private static final SystemPermission CONTROL = new SystemPermission("server", "control");
    private static final SystemPermission MONITOR = new SystemPermission("server", "monitor");
    private long lastReceiveTime = System.currentTimeMillis();
    private long lastReceiveBytes = 0L;
    private int receiveResult = 0;
    private long lastSentTime = System.currentTimeMillis();
    private long lastSentBytes = 0L;
    private int sentResult = 0;

    NetworkServerMBeanImpl(NetworkServerControlImpl nsc) {
        this.server = nsc;
        this.startTime = System.currentTimeMillis();
    }

    private static void checkControl() {
        NetworkServerMBeanImpl.checkPermission(CONTROL);
    }

    private static void checkMonitor() {
        NetworkServerMBeanImpl.checkPermission(MONITOR);
    }

    private static void checkPermission(SystemPermission permission) {
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(permission);
            }
        }
        catch (AccessControlException e) {
            throw new SecurityException(e.getMessage());
        }
    }

    @Override
    public String getDrdaHost() {
        NetworkServerMBeanImpl.checkControl();
        String host = this.getServerProperty("derby.drda.host");
        return host;
    }

    @Override
    public boolean getDrdaKeepAlive() {
        NetworkServerMBeanImpl.checkMonitor();
        String on = this.getServerProperty("derby.drda.keepAlive");
        return "true".equals(on);
    }

    @Override
    public int getDrdaMaxThreads() {
        NetworkServerMBeanImpl.checkMonitor();
        int maxThreads = 0;
        String maxThreadsStr = this.getServerProperty("derby.drda.maxThreads");
        if (maxThreadsStr != null) {
            try {
                maxThreads = Integer.parseInt(maxThreadsStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return maxThreads;
    }

    @Override
    public int getDrdaPortNumber() {
        NetworkServerMBeanImpl.checkControl();
        int portNumber = 1527;
        String portString = this.getServerProperty("derby.drda.portNumber");
        try {
            portNumber = Integer.parseInt(portString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return portNumber;
    }

    @Override
    public String getDrdaSecurityMechanism() {
        NetworkServerMBeanImpl.checkControl();
        String secmec = this.getServerProperty("derby.drda.securityMechanism");
        if (secmec == null) {
            secmec = "";
        }
        return secmec;
    }

    @Override
    public String getDrdaSslMode() {
        NetworkServerMBeanImpl.checkControl();
        String SSLMode = this.getServerProperty("derby.drda.sslMode");
        return SSLMode;
    }

    @Override
    public int getDrdaStreamOutBufferSize() {
        NetworkServerMBeanImpl.checkMonitor();
        int size = PropertyUtil.getSystemInt("derby.drda.streamOutBufferSize", 0);
        return size;
    }

    @Override
    public int getDrdaTimeSlice() {
        NetworkServerMBeanImpl.checkMonitor();
        return this.server.getTimeSlice();
    }

    @Override
    public boolean getDrdaTraceAll() {
        NetworkServerMBeanImpl.checkMonitor();
        String on = this.getServerProperty("derby.drda.traceAll");
        return "true".equals(on);
    }

    @Override
    public String getDrdaTraceDirectory() {
        NetworkServerMBeanImpl.checkControl();
        String traceDirectory = null;
        traceDirectory = this.getServerProperty("derby.drda.traceDirectory");
        if (traceDirectory == null) {
            traceDirectory = this.getServerProperty("derby.system.home");
        }
        if (traceDirectory == null) {
            traceDirectory = PropertyUtil.getSystemProperty("user.dir");
        }
        return traceDirectory;
    }

    @Override
    public int getConnectionCount() {
        NetworkServerMBeanImpl.checkMonitor();
        return this.getActiveConnectionCount() + this.getWaitingConnectionCount();
    }

    @Override
    public int getActiveConnectionCount() {
        NetworkServerMBeanImpl.checkMonitor();
        return this.server.getActiveSessions();
    }

    @Override
    public int getWaitingConnectionCount() {
        NetworkServerMBeanImpl.checkMonitor();
        return this.server.getRunQueueSize();
    }

    @Override
    public int getConnectionThreadPoolSize() {
        NetworkServerMBeanImpl.checkMonitor();
        return this.server.getThreadListSize();
    }

    @Override
    public int getAccumulatedConnectionCount() {
        NetworkServerMBeanImpl.checkMonitor();
        return this.server.getConnectionNumber();
    }

    @Override
    public long getBytesReceived() {
        NetworkServerMBeanImpl.checkMonitor();
        return this.server.getBytesRead();
    }

    @Override
    public long getBytesSent() {
        NetworkServerMBeanImpl.checkMonitor();
        return this.server.getBytesWritten();
    }

    @Override
    public synchronized int getBytesReceivedPerSecond() {
        NetworkServerMBeanImpl.checkMonitor();
        long now = System.currentTimeMillis();
        if (now - this.lastReceiveTime >= 1000L) {
            long count = this.getBytesReceived();
            this.receiveResult = (int)((count - this.lastReceiveBytes) * 1000L / (now - this.lastReceiveTime));
            this.lastReceiveTime = now;
            this.lastReceiveBytes = count;
        }
        return this.receiveResult;
    }

    @Override
    public synchronized int getBytesSentPerSecond() {
        NetworkServerMBeanImpl.checkMonitor();
        long now = System.currentTimeMillis();
        if (now - this.lastSentTime >= 1000L) {
            long count = this.getBytesSent();
            this.sentResult = (int)((count - this.lastSentBytes) * 1000L / (now - this.lastSentTime));
            this.lastSentTime = now;
            this.lastSentBytes = count;
        }
        return this.sentResult;
    }

    @Override
    public long getStartTime() {
        NetworkServerMBeanImpl.checkMonitor();
        return this.startTime;
    }

    @Override
    public long getUptime() {
        NetworkServerMBeanImpl.checkMonitor();
        return System.currentTimeMillis() - this.startTime;
    }

    @Override
    public void ping() throws Exception {
        NetworkServerMBeanImpl.checkMonitor();
        try {
            this.server.ping();
        }
        catch (Exception ex) {
            Monitor.logThrowable(ex);
            throw ex;
        }
    }

    private String getServerProperty(String property) {
        return this.server.getPropertyValues().getProperty(property);
    }
}

