/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.client;

import java.io.InputStream;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.util.Calendar;
import javax.jcr.Binary;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.rmi.client.ClientItem;
import org.apache.jackrabbit.rmi.client.LocalAdapterFactory;
import org.apache.jackrabbit.rmi.client.RemoteRepositoryException;
import org.apache.jackrabbit.rmi.remote.RemoteProperty;
import org.apache.jackrabbit.rmi.value.SerialValueFactory;

@Deprecated
public class ClientProperty
extends ClientItem
implements Property {
    private RemoteProperty remote;

    public ClientProperty(Session session, RemoteProperty remote, LocalAdapterFactory factory) {
        super(session, remote, factory);
        this.remote = remote;
    }

    @Override
    public void accept(ItemVisitor visitor) throws RepositoryException {
        visitor.visit((Property)this);
    }

    public boolean getBoolean() throws RepositoryException {
        return this.getValue().getBoolean();
    }

    public Calendar getDate() throws RepositoryException {
        return this.getValue().getDate();
    }

    public double getDouble() throws RepositoryException {
        return this.getValue().getDouble();
    }

    public long getLong() throws RepositoryException {
        return this.getValue().getLong();
    }

    public Binary getBinary() throws RepositoryException {
        return this.getValue().getBinary();
    }

    public BigDecimal getDecimal() throws RepositoryException {
        return this.getValue().getDecimal();
    }

    public InputStream getStream() throws RepositoryException {
        return this.getValue().getStream();
    }

    public String getString() throws RepositoryException {
        return this.getValue().getString();
    }

    public Value getValue() throws RepositoryException {
        try {
            return this.remote.getValue();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public Value[] getValues() throws RepositoryException {
        try {
            return this.remote.getValues();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public void setValue(boolean value) throws RepositoryException {
        this.setValue(this.getSession().getValueFactory().createValue(value));
    }

    public void setValue(Calendar value) throws RepositoryException {
        if (value == null) {
            this.setValue((Value)null);
        } else {
            this.setValue(this.getSession().getValueFactory().createValue(value));
        }
    }

    public void setValue(double value) throws RepositoryException {
        this.setValue(this.getSession().getValueFactory().createValue(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(InputStream value) throws RepositoryException {
        if (value == null) {
            this.setValue((Value)null);
        } else {
            ValueFactory factory = this.getSession().getValueFactory();
            Binary binary = factory.createBinary(value);
            try {
                this.setValue(factory.createValue(binary));
            }
            finally {
                binary.dispose();
            }
        }
    }

    public void setValue(long value) throws RepositoryException {
        this.setValue(this.getSession().getValueFactory().createValue(value));
    }

    public void setValue(Binary value) throws RepositoryException {
        this.setValue(this.getSession().getValueFactory().createValue(value));
    }

    public void setValue(BigDecimal value) throws RepositoryException {
        this.setValue(this.getSession().getValueFactory().createValue(value));
    }

    public void setValue(Node value) throws RepositoryException {
        if (value == null) {
            this.setValue((Value)null);
        } else {
            this.setValue(this.getSession().getValueFactory().createValue(value));
        }
    }

    public void setValue(String value) throws RepositoryException {
        if (value == null) {
            this.setValue((Value)null);
        } else {
            this.setValue(this.getSession().getValueFactory().createValue(value));
        }
    }

    public void setValue(String[] strings) throws RepositoryException {
        try {
            Value[] values = null;
            if (strings != null) {
                values = SerialValueFactory.makeSerialValueArray(strings);
            }
            this.remote.setValue(values);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public void setValue(Value value) throws RepositoryException {
        try {
            if (value != null) {
                value = SerialValueFactory.makeSerialValue(value);
            }
            this.remote.setValue(value);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public void setValue(Value[] values) throws RepositoryException {
        try {
            if (values != null) {
                values = SerialValueFactory.makeSerialValueArray(values);
            }
            this.remote.setValue(values);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public Node getNode() throws RepositoryException {
        String value = this.getString();
        switch (this.getType()) {
            case 9: 
            case 10: {
                return this.getSession().getNodeByIdentifier(value);
            }
            case 8: {
                try {
                    if (value.startsWith("/")) {
                        return this.getSession().getNode(value);
                    }
                    return this.getParent().getNode(value);
                }
                catch (PathNotFoundException e) {
                    throw new ItemNotFoundException(value);
                }
            }
            case 7: {
                try {
                    return this.getParent().getNode(value);
                }
                catch (PathNotFoundException e) {
                    throw new ItemNotFoundException(value);
                }
            }
            case 1: {
                try {
                    Value refValue = this.getSession().getValueFactory().createValue(value, 9);
                    return this.getSession().getNodeByIdentifier(refValue.getString());
                }
                catch (ItemNotFoundException e) {
                    throw e;
                }
                catch (RepositoryException e) {
                    Value pathValue = this.getSession().getValueFactory().createValue(value, 8);
                    boolean absolute = value.startsWith("/");
                    try {
                        return absolute ? this.getSession().getNode(pathValue.getString()) : this.getParent().getNode(pathValue.getString());
                    }
                    catch (PathNotFoundException e1) {
                        throw new ItemNotFoundException(pathValue.getString());
                    }
                }
            }
        }
        throw new ValueFormatException("Property value cannot be converted to a PATH, REFERENCE or WEAKREFERENCE: " + value);
    }

    public Property getProperty() throws RepositoryException {
        if (this.getType() != 8 && this.getType() != 7) {
            throw new ValueFormatException("Not a path property");
        }
        String value = this.getString();
        try {
            if (value.startsWith("/")) {
                return this.getSession().getProperty(value);
            }
            return this.getParent().getProperty(value);
        }
        catch (PathNotFoundException e) {
            throw new ItemNotFoundException(value);
        }
    }

    public long getLength() throws RepositoryException {
        try {
            return this.remote.getLength();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public long[] getLengths() throws RepositoryException {
        try {
            return this.remote.getLengths();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public PropertyDefinition getDefinition() throws RepositoryException {
        try {
            return this.getFactory().getPropertyDef(this.remote.getDefinition());
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public int getType() throws RepositoryException {
        try {
            return this.remote.getType();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public boolean isMultiple() throws RepositoryException {
        return this.getDefinition().isMultiple();
    }
}

