/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.render.tile;

import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.LineStyle;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.render.RendererUtil;
import com.sas.graphics.util.gtk.render.tile.Tile;
import java.awt.Color;
import java.awt.Image;
import java.util.HashMap;
import javax.swing.tree.DefaultMutableTreeNode;

public class TileChartRendererModel {
    private transient Variable[] tileVariable;
    private transient NumericVariable sizeVariable;
    private transient Variable colorVariable;
    private transient Variable[] webLinkVariableArray;
    private transient Variable[] dataTipVariableArray;
    private ColorMapper colorMapper;
    private StringToColorMap colorMap;
    private HashMap<Integer, LineStyle> outlineLineStyle = new HashMap();
    private transient TextStyle dataLabelTextStyle;
    private transient boolean dataLabelVisible;
    private transient int dataLabelLevel;
    private transient Color missingColor;
    private transient TextStyle statusLineTextStyle;
    private transient boolean statusLineVisible;
    private int detailLevel;
    private Variable sizeSelectionVariable;
    private Variable colorSelectionVariable;
    private NumericVariable selectedPercentageVariable;
    private Color selectionColor;
    private Color selectionAccentColor;
    private RendererUtil.TileChartLayout chart_layout;
    private DefaultMutableTreeNode tree;
    private transient Variable xVariable;
    private transient Variable yVariable;
    private boolean recreateTree = true;
    private boolean reattachTree = true;
    private boolean discreteColorVariable;
    private double minimumColorValue = Double.NaN;
    private double maximumColorValue = Double.NaN;
    private Color outOfRangeColor;
    private Color fillAttrColor;
    private Tile origRootTile;
    private Tile curRootTile;
    private String[] path;
    private boolean includeMissingValue = true;
    private boolean includeMissingDiscrete = false;
    private boolean isAllMissingRows = false;
    private boolean sizeRoleIsFrequencyRole = false;
    private NumericVariable chPipe = null;
    private Image chImage;
    private boolean addCHMargin = false;
    private int colorStat = 6;
    private int sizeStat = 6;
    private RendererUtil.Skin skin = RendererUtil.Skin.NONE;
    private double dataDPIScaleFactor = 1.0;

    public Variable[] getTileVariable() {
        return this.tileVariable;
    }

    public void setTileVariable(Variable[] tileVar) {
        this.tileVariable = tileVar;
    }

    public NumericVariable getSizeVariable() {
        return this.sizeVariable;
    }

    public void setSizeVariable(NumericVariable sizeVar) {
        this.sizeVariable = sizeVar;
    }

    public Variable getColorVariable() {
        return this.colorVariable;
    }

    public void setColorVariable(Variable colorVar) {
        this.colorVariable = colorVar;
    }

    public DefaultMutableTreeNode getDataTree() {
        return this.tree;
    }

    public void setDataTree(DefaultMutableTreeNode t) {
        this.tree = t;
    }

    public Variable getXVariable() {
        return this.xVariable;
    }

    public void setXVariable(Variable xVar) {
        this.xVariable = xVar;
    }

    public Variable getYVariable() {
        return this.yVariable;
    }

    public void setYVariable(Variable yVar) {
        this.yVariable = yVar;
    }

    public Variable[] getDataTipVariableArray() {
        return this.dataTipVariableArray;
    }

    public void setDataTipVariableArray(Variable[] dataTipVar) {
        this.dataTipVariableArray = dataTipVar;
    }

    public Variable[] getWebLinkVariableArray() {
        return this.webLinkVariableArray;
    }

    public void setWebLinkVariableArray(Variable[] webLinkVar) {
        this.webLinkVariableArray = webLinkVar;
    }

    public RendererUtil.TileChartLayout getLayoutType() {
        return this.chart_layout;
    }

    public void setLayout(RendererUtil.TileChartLayout layout) {
        this.chart_layout = layout;
    }

    public ColorMapper getColorMapper() {
        return this.colorMapper;
    }

    public void setColorMapper(ColorMapper mapper) {
        this.colorMapper = mapper;
    }

    public LineStyle getOutlineLineStyle(int level) {
        LineStyle style = null;
        while (style == null && level >= -1) {
            style = this.outlineLineStyle.get(new Integer(level--));
        }
        return style == null ? new LineStyle() : style;
    }

    public void setOutlineLineStyle(LineStyle ls) {
        int maxLevels = this.getTileVariable().length;
        for (int i = 1; i <= maxLevels; ++i) {
            if (i == 1) {
                LineStyle ls1 = new LineStyle();
                ls1.set(ls);
                this.setOutlineLineStyle(ls1, 1);
                continue;
            }
            if (i == 2) {
                LineStyle ls2 = new LineStyle();
                ls2.set(ls);
                ls2.setWidth(1);
                this.setOutlineLineStyle(ls2, 2);
                continue;
            }
            if (i < 3) continue;
            LineStyle otherls = new LineStyle();
            otherls.set(ls);
            otherls.setColor(this.makeLighter(ls.getColor()));
            otherls.setWidth(1);
            this.setOutlineLineStyle(otherls, i);
        }
    }

    private Color makeLighter(Color outlineColor) {
        float[] hsbValue = Color.RGBtoHSB(outlineColor.getRed(), outlineColor.getGreen(), outlineColor.getBlue(), null);
        if ((double)hsbValue[2] < 0.4) {
            hsbValue[1] = hsbValue[1] / 4.0f;
            hsbValue[2] = (float)((double)hsbValue[2] + 0.3);
        } else {
            hsbValue[1] = hsbValue[1] / 4.0f;
            hsbValue[2] = (float)((double)hsbValue[2] - 0.3);
            hsbValue[2] = Math.max(hsbValue[2], 0.0f);
        }
        int rgbValue = Color.HSBtoRGB(hsbValue[0], hsbValue[1], hsbValue[2]);
        Color lighterColor = new Color((rgbValue & 0xFF0000) >> 16, (rgbValue & 0xFF00) >> 8, rgbValue & 0xFF);
        if (outlineColor.equals(Color.black)) {
            lighterColor = Color.gray;
        }
        return lighterColor;
    }

    public void setOutlineLineStyle(LineStyle ls, int level) {
        this.outlineLineStyle.put(new Integer(level), ls);
    }

    public TextStyle getDataLabelTextStyle() {
        return this.dataLabelTextStyle;
    }

    public void setDataLabelTextStyle(TextStyle ts) {
        this.dataLabelTextStyle = ts;
    }

    public TextStyle getStatusLineTextStyle() {
        return this.statusLineTextStyle;
    }

    public void setStatusLineTextStyle(TextStyle ts) {
        this.statusLineTextStyle = ts;
    }

    public int getDataLabelLevel() {
        return this.dataLabelLevel;
    }

    public void setDataLabelLevel(int level) {
        this.dataLabelLevel = level;
    }

    public boolean isDataLabelVisible() {
        return this.dataLabelVisible;
    }

    public void setDataLabelVisible(boolean v) {
        this.dataLabelVisible = v;
    }

    public boolean isStatusLineVisible() {
        return this.statusLineVisible;
    }

    public void setStatusLineVisible(boolean v) {
        this.statusLineVisible = v;
    }

    public Color getMissingColor() {
        return this.missingColor;
    }

    public void setMissingColor(Color ms) {
        this.missingColor = ms;
    }

    public int getDetailLevel() {
        return this.detailLevel;
    }

    public void setDetailLevel(int level) {
        this.detailLevel = level;
    }

    public Variable getSizeSelectionVariable() {
        return this.sizeSelectionVariable;
    }

    public void setSizeSelectionVariable(Variable sizeSelectionVariable) {
        this.sizeSelectionVariable = sizeSelectionVariable;
    }

    public Variable getColorSelectionVariable() {
        return this.colorSelectionVariable;
    }

    public void setColorSelectionVariable(Variable colorSelectionVariable) {
        this.colorSelectionVariable = colorSelectionVariable;
    }

    public NumericVariable getSelectedPercentageVariable() {
        return this.selectedPercentageVariable;
    }

    public void setSelectedPercentageVariable(NumericVariable selectedPercentageVariable) {
        this.selectedPercentageVariable = selectedPercentageVariable;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color selectionColor) {
        this.selectionColor = selectionColor;
    }

    public Color getSelectionAccentColor() {
        return this.selectionAccentColor;
    }

    public void setSelectionAccentColor(Color selectionAccentColor) {
        this.selectionAccentColor = selectionAccentColor;
    }

    public boolean isTreeToBeRecreated() {
        return this.recreateTree;
    }

    public void setTreeToBeRecreated(boolean recreateTree) {
        this.recreateTree = recreateTree;
    }

    public boolean isTreeToBeReattached() {
        return this.reattachTree;
    }

    public void setTreeToBeReattached(boolean reattachTree) {
        this.reattachTree = reattachTree;
    }

    public Tile getRootTile() {
        return this.origRootTile;
    }

    public void setRootTile(Tile rootTile) {
        this.origRootTile = rootTile;
    }

    public Tile getCurrentRootTile() {
        return this.curRootTile;
    }

    public void setCurrentRootTile(Tile currentRootTile) {
        this.curRootTile = currentRootTile;
    }

    public void setRootPath(String[] path) {
        this.path = path;
    }

    public String[] getRootPath() {
        return this.path;
    }

    public boolean isColorVariableDiscrete() {
        return this.discreteColorVariable;
    }

    public void setColorVariableDiscrete(boolean discreteColorVar) {
        this.discreteColorVariable = discreteColorVar;
    }

    public StringToColorMap getColorMap() {
        return this.colorMap;
    }

    public void setColorMap(StringToColorMap colorMap) {
        this.colorMap = colorMap;
    }

    public double getMinimumColorValue() {
        return this.minimumColorValue;
    }

    public void setMinimumColorValue(double minColorVal) {
        this.minimumColorValue = minColorVal;
    }

    public double getMaximumColorValue() {
        return this.maximumColorValue;
    }

    public void setMaximumColorValue(double maxColorVal) {
        this.maximumColorValue = maxColorVal;
    }

    public Color getOutOfRangeColor() {
        return this.outOfRangeColor;
    }

    public void setOutOfRangeColor(Color outOfRangeColor) {
        this.outOfRangeColor = outOfRangeColor;
    }

    public Color getFillAttrColor() {
        return this.fillAttrColor;
    }

    public void setFillAttrColor(Color fillAttrColor) {
        this.fillAttrColor = fillAttrColor;
    }

    public void setIncludeMissingValue(boolean b) {
        this.includeMissingValue = b;
    }

    public boolean isIncludeMissingValue() {
        return this.includeMissingValue;
    }

    public void setIncludeMissingDiscreteValue(boolean b) {
        this.includeMissingDiscrete = b;
    }

    public boolean isIncludeMissingDiscreteValue() {
        return this.includeMissingDiscrete;
    }

    public void setIsAllMissingRows(boolean b) {
        this.isAllMissingRows = b;
    }

    public boolean getISAllMissingRows() {
        return this.isAllMissingRows;
    }

    public void setSizeRoleIsFrequencyRole(boolean b) {
        this.sizeRoleIsFrequencyRole = b;
    }

    public boolean getSizeRoleIsFrequencyRole() {
        return this.sizeRoleIsFrequencyRole;
    }

    public NumericVariable getCHPipe() {
        return this.chPipe;
    }

    public void setCHPipe(NumericVariable chPipe) {
        this.chPipe = chPipe;
    }

    public void setCHImage(Image img) {
        this.chImage = img;
    }

    public Image getCHImage() {
        return this.chImage;
    }

    public boolean isShowCHMargin() {
        return this.addCHMargin;
    }

    public void setShowCHMargin(boolean addCHMargin) {
        this.addCHMargin = addCHMargin;
    }

    public void setColorStat(int s) {
        this.colorStat = s;
    }

    public int getColorStat() {
        return this.colorStat;
    }

    public void setSizeStat(int s) {
        this.sizeStat = s;
    }

    public int getSizeStat() {
        return this.sizeStat;
    }

    public void setSkin(RendererUtil.Skin s) {
        this.skin = s;
    }

    public RendererUtil.Skin getSkin() {
        return this.skin;
    }

    public int getSkinType() {
        return RendererUtil.getSkinType(this.skin);
    }

    public void setDataDPIScaleFactor(double dataDPIScaleFactor) {
        this.dataDPIScaleFactor = dataDPIScaleFactor;
    }

    public double getDataDPIScaleFactor() {
        return this.dataDPIScaleFactor;
    }
}

