/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.render.tile;

import com.sas.MissingValues;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class Tile {
    public String idValue;
    public double sizeValue;
    public double colorValue;
    public double validColorSize;
    public double xValue;
    public double yValue;
    public MissingValues missingColor;
    public String formattedSize;
    public String formattedColor;
    public String[] formattedDataTip;
    public String[] webLinks;
    public Rectangle2D.Double rect;
    public Color fillColor = Color.BLACK;
    public boolean otherQualify = false;
    public boolean inOther = false;
    public boolean otherTile = false;
    public DefaultMutableTreeNode treeNode;
    public String colorLabel;
    public boolean cHilite = false;

    public Tile(String id) {
        if (id != null) {
            id = id.trim();
        }
        this.idValue = id;
        this.sizeValue = 0.0;
        this.validColorSize = 0.0;
        this.colorValue = 0.0;
        this.xValue = Double.NaN;
        this.yValue = Double.NaN;
        this.missingColor = null;
        this.formattedSize = "";
        this.formattedColor = "";
        this.formattedDataTip = null;
        this.webLinks = null;
        this.rect = null;
        this.fillColor = Color.black;
        this.otherQualify = false;
        this.inOther = false;
        this.otherTile = false;
        this.treeNode = null;
        this.colorLabel = "";
    }

    public Tile(String id, double size, double color) {
        this(id, size, "" + size, color, "" + color);
    }

    public Tile(String id, double size, String fSize, double color, String fColor) {
        if (id != null) {
            id = id.trim();
        }
        this.idValue = id;
        this.sizeValue = size;
        this.validColorSize = size;
        this.missingColor = null;
        this.formattedSize = fSize;
        this.formattedColor = fColor;
        this.formattedDataTip = null;
        this.webLinks = null;
        this.colorValue = color;
        this.rect = null;
        this.fillColor = Color.black;
        this.otherQualify = false;
        this.inOther = false;
        this.otherTile = false;
        this.treeNode = null;
        this.colorLabel = new Double(color).toString();
    }

    public Tile parentTile() {
        Tile parent = null;
        parent = (Tile)((DefaultMutableTreeNode)this.treeNode.getParent()).getUserObject();
        return parent;
    }

    public String toString() {
        String id = this.idValue;
        if (this.treeNode != null) {
            DefaultMutableTreeNode curNode = this.treeNode;
            while (curNode.getParent() != null) {
                if ((curNode = (DefaultMutableTreeNode)curNode.getParent()).getUserObject() == null) continue;
                id = id + "-->" + ((Tile)curNode.getUserObject()).idValue;
            }
        }
        return "id=" + id + " : size=" + this.formattedSize + " : color=" + this.formattedColor;
    }

    public String[] getPath() {
        int levelsToRoot = 0;
        Tile curtt = this;
        levelsToRoot = this.treeNode.getLevel() - 1;
        String[] rootPath = new String[levelsToRoot];
        for (int i = rootPath.length - 1; i >= 0; --i) {
            rootPath[i] = curtt.idValue;
            curtt = (Tile)((DefaultMutableTreeNode)curtt.treeNode.getParent()).getUserObject();
        }
        return rootPath;
    }

    public String idPath() {
        String path = "";
        TreeNode[] nodePath = this.treeNode.getPath();
        for (int ii = 1; ii < nodePath.length; ++ii) {
            path = path + ((Tile)((DefaultMutableTreeNode)nodePath[ii]).getUserObject()).idValue;
            if (ii >= nodePath.length - 1) continue;
            path = path + " > ";
        }
        return path;
    }

    public String idPathMultiLine(String[] labels) {
        String path = "";
        int numOtherLevels = 0;
        TreeNode[] nodePath = this.treeNode.getPath();
        int idLevels = labels.length - 2;
        int ii = 0;
        while (ii + numOtherLevels < idLevels) {
            if (labels[ii] != null) {
                path = path + labels[ii] + ": ";
            }
            if (((Tile)((DefaultMutableTreeNode)nodePath[ii + 2]).getUserObject()).otherTile) {
                ++numOtherLevels;
            }
            String curValue = ((Tile)((DefaultMutableTreeNode)nodePath[nodePath.length - idLevels + ii + numOtherLevels]).getUserObject()).idValue.trim();
            path = path + curValue + "\n";
            ++ii;
        }
        if (labels[labels.length - 2] != null) {
            path = path + labels[labels.length - 2] + ": ";
        }
        path = path + this.formattedSize + "\n";
        if (!labels[labels.length - 2].equals(labels[labels.length - 1])) {
            if (labels[labels.length - 1] != null) {
                path = path + labels[labels.length - 1] + ": ";
            }
            path = path + this.formattedColor;
        }
        if (this.formattedDataTip != null) {
            path = path + "\n----------\n";
            for (ii = 0; ii < this.formattedDataTip.length; ++ii) {
                path = path + this.formattedDataTip[ii] + "\n";
            }
        }
        return path;
    }
}

