/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.render.tile;

import com.sas.MissingValues;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.DiscreteRangeToColorMapper;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.LineStyle;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.OLAPLevelVariable;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.datatree.DataTreeResponseNode;
import com.sas.graphics.util.gtk.gl.SelectableShape;
import com.sas.graphics.util.gtk.render.RendererUtil;
import com.sas.graphics.util.gtk.render.tile.Tile;
import com.sas.graphics.util.gtk.render.tile.TileChartRendererModel;
import com.sas.graphics.util.gtk.render.tile.TileChartRendererSelectResult;
import com.sas.graphics.util.gtk.render.tile.TileSelectDetail;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class BIPTileChartRenderer {
    private TileChartRendererModel model = null;
    private transient NumericVector missingVals = new NumericVector();
    private transient GTKFormat sizeFormatter;
    private transient GTKFormat colorFormatter;
    private static String rootTileName = "root";
    private static final double OTHER_THRESHOLD = 0.0;
    private boolean origToggleDir = true;
    private boolean gutterIt = false;
    private Channel channel;
    private Rectangle globalBounds;
    private ArrayList<Rectangle2D.Double> statusList = new ArrayList();
    private ArrayList<String> variableLabelList = new ArrayList();
    private ArrayList<String> variableNameList = new ArrayList();
    private static final int ROOT_MARGIN = 3;
    private transient ArrayList<HighlightRectangle> highRects = new ArrayList();
    private double lowColorDataValue = Double.POSITIVE_INFINITY;
    private double highColorDataValue = Double.NEGATIVE_INFINITY;
    private double lowColorLegendValue = Double.POSITIVE_INFINITY;
    private double highColorLegendValue = Double.NEGATIVE_INFINITY;

    public BIPTileChartRenderer() {
        this.model = new TileChartRendererModel();
    }

    public TileChartRendererModel getRendererModel() {
        return this.model;
    }

    public void setRendererModel(TileChartRendererModel rendererModel) {
        this.model = rendererModel;
    }

    public void setChannel(Channel ch) {
        this.channel = ch;
    }

    private void setBounds(Rectangle bounds) {
        this.globalBounds = bounds;
    }

    public DefaultMutableTreeNode createDataTree() {
        VariableProcessor vp = new VariableProcessor();
        Variable[] tileVarArr = this.model.getTileVariable();
        if (tileVarArr != null) {
            for (int i = 0; i < tileVarArr.length; ++i) {
                vp.addGroupVariable(tileVarArr[i]);
            }
        }
        if (this.model.getColorVariable() != null) {
            int statistic = this.model.isColorVariableDiscrete() ? 12 : this.model.getColorStat();
            vp.addVariable(this.model.getColorVariable(), statistic);
        }
        if (this.model.getSizeVariable() != null) {
            vp.addVariable(this.model.getSizeVariable(), this.model.getSizeStat());
        }
        DefaultMutableTreeNode tree = new DefaultMutableTreeNode();
        try {
            tree.add(vp.getTree());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (DefaultMutableTreeNode)tree.getChildAt(0);
    }

    public void sizeOrigRootTile(Rectangle bounds, TextStyle ts) {
        this.setBounds(bounds);
        double textHeight = 27.0;
        double widthAdj = 7.0;
        if (this.globalBounds.height <= 0 || this.globalBounds.width <= 0) {
            this.globalBounds.width = 621;
            this.globalBounds.height = 379;
        }
        if (ts.getFont() != null) {
            this.channel.glSelect2DFont(ts.getFont());
            textHeight = this.channel.glGetTextHeight();
        }
        this.channel.glSelect2DFont(new Font("Courier", 1, 12));
        widthAdj = this.channel.glGetTextWidth("a");
        this.model.getRootTile().rect = new Rectangle2D.Double(this.globalBounds.x + 3, this.globalBounds.y + 3, (double)this.globalBounds.width - widthAdj, (double)this.globalBounds.height - (textHeight += Math.ceil(this.channel.glGetTextHeight() * 0.25)));
    }

    public Vector computeSelectableShapes() {
        int numVisibleLevels = 0;
        numVisibleLevels = this.isOLAPData(this.model.getTileVariable()) ? this.model.getCurrentRootTile().treeNode.getDepth() - 1 : Math.min(this.model.getDetailLevel(), this.model.getCurrentRootTile().treeNode.getDepth() - 1);
        Vector<SelectableShape> selectableShapes = new Vector<SelectableShape>();
        DefaultMutableTreeNode root = this.model.getCurrentRootTile().treeNode;
        if (root != null) {
            Enumeration<TreeNode> dEnum = root.depthFirstEnumeration();
            while (dEnum.hasMoreElements()) {
                DataTreeGroupNode groupNode;
                Tile tile;
                DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)dEnum.nextElement();
                if (curNode instanceof DataTreeResponseNode || (tile = (Tile)(groupNode = (DataTreeGroupNode)curNode).getUserObject()) == null || tile.rect == null || tile.rect.width == 0.0 || tile.rect.height == 0.0 || tile.sizeValue <= 0.0 || (!this.isLeafTile(curNode) || curNode.getLevel() - this.model.getCurrentRootTile().treeNode.getLevel() > numVisibleLevels) && (this.isLeafTile(curNode) || curNode.getLevel() - this.model.getCurrentRootTile().treeNode.getLevel() != numVisibleLevels)) continue;
                TileSelectDetail tileDetail = new TileSelectDetail();
                tileDetail.setType(0);
                tileDetail.setTile(tile);
                TileChartRendererSelectResult selectResult = new TileChartRendererSelectResult(groupNode.getFirstValueIndex(), tileDetail);
                Rectangle r = new Rectangle((int)tile.rect.x, this.globalBounds.height - (int)tile.rect.y - (int)tile.rect.height, (int)tile.rect.width, (int)tile.rect.height);
                Polygon p = new Polygon();
                p.addPoint(r.x, r.y);
                p.addPoint(r.x + r.width, r.y);
                p.addPoint(r.x + r.width, r.y + r.height);
                p.addPoint(r.x, r.y + r.height);
                SelectableShape selectShape = new SelectableShape(selectResult, p);
                selectableShapes.add(selectShape);
            }
        }
        for (int i = 0; i < this.statusList.size(); ++i) {
            TileSelectDetail tileDetail = new TileSelectDetail();
            tileDetail.setType(1);
            tileDetail.setVariableLabel(this.variableLabelList.get(i));
            tileDetail.setVariableName(this.variableNameList.get(i));
            TileChartRendererSelectResult selectResult = new TileChartRendererSelectResult(-1, tileDetail);
            Rectangle2D.Double r = this.statusList.get(i);
            Polygon p = new Polygon();
            p.addPoint((int)r.x, (int)r.y);
            p.addPoint((int)(r.x + r.width), (int)r.y);
            p.addPoint((int)(r.x + r.width), (int)(r.y + r.height));
            p.addPoint((int)r.x, (int)(r.y + r.height));
            SelectableShape selectShape = new SelectableShape(selectResult, p);
            selectableShapes.add(selectShape);
        }
        return selectableShapes;
    }

    public Vector select(int x, int y, int apertureWidth, int apertureHeight) {
        Vector<TileChartRendererSelectResult> selectResultVec = new Vector<TileChartRendererSelectResult>();
        ArrayList tiles = this.getTileAtPosition(new Rectangle(x, y, apertureWidth, apertureHeight), false);
        for (int i = 0; i < tiles.size(); ++i) {
            TileSelectDetail tileDetail = new TileSelectDetail();
            tileDetail.setType(0);
            Tile tile = (Tile)tiles.get(i);
            tileDetail.setTile(tile);
            TileChartRendererSelectResult selResult = new TileChartRendererSelectResult(((DataTreeGroupNode)tile.treeNode).getFirstValueIndex(), tileDetail);
            selectResultVec.add(selResult);
        }
        return selectResultVec;
    }

    public void renderTileChart(Graphics2D g, Channel ch, Rectangle bounds) {
        this.setChannel(ch);
        this.setBounds(bounds);
        this.channel.setSingleBufferGraphics((Graphics)g);
        if (this.model.getRootTile() == null) {
            this.model.setRootTile(new Tile(rootTileName));
        }
        if (this.model.getRootTile().rect == null) {
            this.sizeOrigRootTile(this.globalBounds, this.model.getStatusLineTextStyle());
        }
        if (this.model.getDetailLevel() == 0) {
            this.model.setDetailLevel(this.model.getTileVariable().length);
        }
        if (this.model.isTreeToBeReattached()) {
            double[] dataValues = this.attachTilesToDataTree();
            this.lowColorDataValue = dataValues[0];
            this.highColorDataValue = dataValues[1];
            if (this.highColorLegendValue == Double.NEGATIVE_INFINITY) {
                this.highColorLegendValue = this.highColorDataValue;
            }
            if (this.lowColorLegendValue == Double.POSITIVE_INFINITY) {
                this.lowColorLegendValue = this.lowColorDataValue;
            }
            this.model.setTreeToBeReattached(false);
            this.initColorMapper();
        }
        if (this.model.isTreeToBeRecreated()) {
            this.startCreateTree(this.model.getCurrentRootTile().treeNode, this.model.getCurrentRootTile().rect, new Point2D.Double(this.model.getCurrentRootTile().rect.x, this.model.getCurrentRootTile().rect.y));
            this.model.setTreeToBeRecreated(false);
        }
        if (this.model.getRootPath() != null && this.model.getRootPath().length > 0) {
            this.setRootTilePath();
        }
        this.startDrawTree(this.model.getCurrentRootTile().treeNode, this.lowColorLegendValue, this.highColorLegendValue);
        this.drawStatusLine(null, null);
    }

    public double[] attachTilesToDataTree() {
        this.missingVals.removeAllValues();
        DataTreeGroupNode root = (DataTreeGroupNode)this.model.getDataTree();
        Variable xVariable = this.model.getXVariable();
        Variable yVariable = this.model.getYVariable();
        if (this.model.getSizeVariable() != null) {
            this.sizeFormatter = this.model.getSizeVariable().getFormat();
        }
        if (this.model.getColorVariable() != null) {
            this.colorFormatter = this.model.getColorVariable().getFormat();
        }
        if (root != null) {
            Enumeration<TreeNode> depthEnum = root.depthFirstEnumeration();
            while (depthEnum.hasMoreElements()) {
                Variable[] webLinkVariableArray;
                DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)depthEnum.nextElement();
                if (curNode.isLeaf()) continue;
                DataTreeGroupNode curGroupNode = (DataTreeGroupNode)curNode;
                Tile newTile = (Tile)curNode.getUserObject();
                if (newTile == null) {
                    newTile = new Tile(curGroupNode.getFormattedValue());
                }
                double accumSize = 0.0;
                double accumSizeValidColor = 0.0;
                double summarizedColor = 0.0;
                double curSize = 0.0;
                double curColor = 0.0;
                double curX = 0.0;
                double curY = 0.0;
                boolean missingColor = false;
                String curColorLabel = "";
                for (int jj = 0; jj < curGroupNode.getChildCount(); ++jj) {
                    missingColor = false;
                    DefaultMutableTreeNode curChild = (DefaultMutableTreeNode)curGroupNode.getChildAt(jj);
                    if (curChild instanceof DataTreeGroupNode) {
                        curSize = ((Tile)curChild.getUserObject()).sizeValue;
                        curColor = ((Tile)curChild.getUserObject()).colorValue;
                        curColorLabel = ((Tile)curChild.getUserObject()).colorLabel.trim();
                        if (((Tile)curChild.getUserObject()).missingColor != null) {
                            missingColor = true;
                        }
                        curX = ((Tile)curChild.getUserObject()).xValue;
                        curY = ((Tile)curChild.getUserObject()).yValue;
                    } else if (curChild instanceof DataTreeResponseNode) {
                        int sizeIndex = 0;
                        int colorIndex = 0;
                        int xIndex = -1;
                        int yIndex = -1;
                        if (((DataTreeResponseNode)curChild).getResponseCount() > 1) {
                            sizeIndex = 1;
                        }
                        try {
                            curSize = ((DataTreeResponseNode)curChild).getDoubleValue(sizeIndex);
                            if (curSize < 0.0) {
                                curSize = 0.0;
                            }
                        }
                        catch (Exception e) {
                            if (!this.model.isIncludeMissingValue()) continue;
                            curSize = 0.0;
                        }
                        if (!this.model.isColorVariableDiscrete()) {
                            try {
                                curColor = ((DataTreeResponseNode)curChild).getDoubleValue(colorIndex);
                            }
                            catch (Exception e1) {
                                if (!this.model.isIncludeMissingValue()) continue;
                                if (e1 instanceof MissingValueException) {
                                    MissingValueException e2 = (MissingValueException)e1;
                                    newTile.missingColor = e2.getMissingValue();
                                    this.missingVals.addValue(e2.getMissingValue());
                                }
                                newTile.colorValue = Double.NaN;
                                missingColor = true;
                            }
                            if (newTile.missingColor == null && curSize > 0.0) {
                                this.highColorDataValue = Math.max(this.highColorDataValue, curColor);
                                this.lowColorDataValue = Math.min(this.lowColorDataValue, curColor);
                            }
                        } else {
                            try {
                                curColorLabel = ((DataTreeResponseNode)curChild).getStringValue(colorIndex);
                                Variable colorVariable = this.model.getColorVariable();
                                if (colorVariable.isConnected() && colorVariable.getConnection() instanceof NumericVariable) {
                                    curColor = ((DataTreeResponseNode)curChild).getDoubleValue(colorIndex);
                                }
                            }
                            catch (MissingValueException e2) {
                                if (!this.model.isIncludeMissingValue()) continue;
                                newTile.missingColor = e2.getMissingValue();
                                this.missingVals.addValue(e2.getMissingValue());
                                missingColor = true;
                            }
                        }
                        if (xVariable != null) {
                            xIndex = Math.max(colorIndex, sizeIndex) + 1;
                            yIndex = xIndex + 1;
                            try {
                                curX = ((DataTreeResponseNode)curChild).getDoubleValue(xIndex);
                            }
                            catch (MissingValueException e) {
                                if (!this.model.isIncludeMissingValue()) continue;
                                curX = 0.0;
                            }
                        }
                        if (yVariable != null) {
                            try {
                                curY = ((DataTreeResponseNode)curChild).getDoubleValue(yIndex);
                            }
                            catch (MissingValueException e) {
                                if (!this.model.isIncludeMissingValue()) continue;
                                curY = 0.0;
                            }
                        }
                    }
                    accumSize += curSize;
                    if (missingColor) continue;
                    accumSizeValidColor += curSize;
                }
                newTile.sizeValue = accumSize;
                newTile.validColorSize = accumSizeValidColor;
                if (!this.model.isColorVariableDiscrete() && accumSizeValidColor == 0.0) {
                    newTile.missingColor = MissingValues.Dot;
                }
                newTile.colorValue = curColor;
                newTile.colorLabel = curColorLabel;
                newTile.xValue = curX;
                newTile.yValue = curY;
                newTile.treeNode = curNode;
                newTile.formattedSize = this.sizeFormatter != null ? this.sizeFormatter.format(new Double(newTile.sizeValue)) : new Double(newTile.sizeValue).toString().trim();
                newTile.formattedColor = newTile.missingColor != null ? (this.model.isColorVariableDiscrete() ? newTile.colorLabel : ValueMap.getDefaultMissingValueLabel(newTile.missingColor)) : (!this.model.isColorVariableDiscrete() ? (this.colorFormatter != null && !Double.isNaN(newTile.colorValue) && !Double.isInfinite(newTile.colorValue) ? this.colorFormatter.format(new Double(newTile.colorValue)) : newTile.colorLabel.trim()) : (this.colorFormatter != null ? this.colorFormatter.format(newTile.colorLabel) : newTile.colorLabel));
                Variable[] dataTipVariableArray = this.model.getDataTipVariableArray();
                if (dataTipVariableArray != null && dataTipVariableArray.length > 0) {
                    int kk;
                    String[] dataTip = new String[dataTipVariableArray.length];
                    int valueIndex = -1;
                    Iterator it = ((DataTreeGroupNode)curNode).getValueIndexIterator();
                    if (it.hasNext()) {
                        valueIndex = (Integer)it.next();
                    }
                    if (!this.isLeafTile(curGroupNode)) {
                        for (kk = 0; kk < dataTipVariableArray.length; ++kk) {
                            dataTip[kk] = dataTipVariableArray[kk].getLabel() + "=" + this.summarizeDataTip(curGroupNode, kk);
                        }
                    } else {
                        for (kk = 0; kk < dataTipVariableArray.length; ++kk) {
                            try {
                                dataTip[kk] = dataTipVariableArray[kk].getLabel() + "=" + dataTipVariableArray[kk].formattedValue.getValue(valueIndex).trim();
                                continue;
                            }
                            catch (MissingValueException yIndex) {
                                // empty catch block
                            }
                        }
                    }
                    newTile.formattedDataTip = dataTip;
                }
                if ((webLinkVariableArray = this.model.getWebLinkVariableArray()) != null && webLinkVariableArray.length > 0) {
                    String[] webLink = new String[webLinkVariableArray.length];
                    int valueIndex = -1;
                    Iterator it = ((DataTreeGroupNode)curNode).getValueIndexIterator();
                    if (it.hasNext()) {
                        valueIndex = (Integer)it.next();
                    }
                    if (it.hasNext() || valueIndex < 0) {
                        for (int kk = 0; kk < webLinkVariableArray.length; ++kk) {
                            webLink[kk] = "";
                        }
                    } else {
                        for (int kk = 0; kk < webLinkVariableArray.length; ++kk) {
                            try {
                                webLink[kk] = webLinkVariableArray[kk].formattedValue.getValue(valueIndex).trim();
                                continue;
                            }
                            catch (MissingValueException missingValueException) {
                                // empty catch block
                            }
                        }
                        newTile.webLinks = webLink;
                    }
                }
                if (curGroupNode == root) {
                    if (this.model.getRootTile() == null) {
                        this.model.setRootTile(new Tile(rootTileName));
                    }
                    this.model.setCurrentRootTile(new Tile(rootTileName));
                    this.model.getCurrentRootTile().treeNode = root;
                    this.model.getRootTile().treeNode = root;
                    if (this.model.getRootTile().rect != null) {
                        this.model.getCurrentRootTile().rect = (Rectangle2D.Double)this.model.getRootTile().rect.clone();
                    }
                    this.model.getCurrentRootTile().sizeValue = accumSize;
                    curGroupNode.setUserObject(this.model.getCurrentRootTile());
                } else {
                    curGroupNode.setUserObject(newTile);
                }
                if (this.isLeafTile(curGroupNode)) continue;
                Tile groupTile = (Tile)curGroupNode.getUserObject();
                double accumX = 0.0;
                double accumY = 0.0;
                for (int jj = 0; jj < curGroupNode.getChildCount(); ++jj) {
                    DefaultMutableTreeNode curChild = (DefaultMutableTreeNode)curGroupNode.getChildAt(jj);
                    if (curChild instanceof DataTreeGroupNode) {
                        Tile childTile = (Tile)curChild.getUserObject();
                        curSize = childTile.sizeValue;
                        curColor = childTile.colorValue;
                        if (curSize < groupTile.sizeValue * 0.0 / 100.0) {
                            childTile.otherQualify = true;
                        }
                    } else if (curChild instanceof DataTreeResponseNode) {
                        int sizeIndex = 0;
                        int colorIndex = 0;
                        int xIndex = -1;
                        int yIndex = -1;
                        if (((DataTreeResponseNode)curChild).getResponseCount() > 1) {
                            sizeIndex = 1;
                        }
                        if (xVariable != null) {
                            xIndex = Math.max(colorIndex, sizeIndex) + 1;
                            try {
                                curX = ((DataTreeResponseNode)curChild).getDoubleValue(xIndex);
                            }
                            catch (MissingValueException e) {
                                if (!this.model.isIncludeMissingValue()) continue;
                                curX = 0.0;
                            }
                        }
                        if (yVariable != null) {
                            yIndex = Math.max(colorIndex, sizeIndex) + 1 + (xIndex > 0 ? 1 : 0);
                            try {
                                curY = ((DataTreeResponseNode)curChild).getDoubleValue(yIndex);
                            }
                            catch (MissingValueException e) {
                                if (!this.model.isIncludeMissingValue()) continue;
                                curY = 0.0;
                            }
                        }
                        try {
                            curSize = ((DataTreeResponseNode)curChild).getDoubleValue(sizeIndex);
                        }
                        catch (MissingValueException e) {
                            curSize = 0.0;
                        }
                        if (!this.model.isColorVariableDiscrete()) {
                            try {
                                curColor = ((DataTreeResponseNode)curChild).getDoubleValue(colorIndex);
                            }
                            catch (MissingValueException e1) {
                                if (!this.model.isIncludeMissingValue()) continue;
                                groupTile.missingColor = e1.getMissingValue();
                            }
                        }
                    }
                    if (!Double.isNaN(curColor) && !Double.isNaN(summarizedColor)) {
                        summarizedColor += curSize * (curColor / groupTile.validColorSize);
                    } else if (groupTile.sizeValue <= 0.0) {
                        summarizedColor = 0.0;
                    }
                    accumX += curX;
                    accumY += curY;
                }
                if (!this.model.isColorVariableDiscrete()) {
                    groupTile.colorValue = Math.max(summarizedColor, this.lowColorDataValue);
                    groupTile.formattedColor = groupTile.missingColor != null ? ValueMap.getDefaultMissingValueLabel(groupTile.missingColor) : (this.colorFormatter != null && !Double.isNaN(newTile.colorValue) && !Double.isInfinite(newTile.colorValue) ? this.colorFormatter.format(new Double(newTile.colorValue)) : new Double(groupTile.colorValue).toString().trim());
                }
                groupTile.xValue = accumX / (double)curGroupNode.getChildCount();
                groupTile.yValue = accumY / (double)curGroupNode.getChildCount();
            }
        }
        double[] dataValues = new double[]{this.lowColorDataValue, this.highColorDataValue};
        return dataValues;
    }

    private String summarizeDataTip(DataTreeGroupNode n, int index) {
        String dt = "";
        double val = 0.0;
        boolean allMissing = true;
        String missingLabel = "";
        Variable[] dataTipVariableArray = this.model.getDataTipVariableArray();
        if (dataTipVariableArray[index] instanceof NumericVariable) {
            NumericVariable nv = (NumericVariable)dataTipVariableArray[index];
            Iterator it = n.getValueIndexIterator();
            while (it.hasNext()) {
                int valueIndex = (Integer)it.next();
                double doubleValue = 0.0;
                try {
                    doubleValue = nv.value.getValue(valueIndex);
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
                if (!Double.isNaN(doubleValue)) {
                    val += doubleValue;
                    allMissing = false;
                    continue;
                }
                try {
                    missingLabel = nv.formattedValue.getValue(valueIndex).trim();
                }
                catch (MissingValueException missingValueException) {}
            }
            dt = nv.getFormat().format(new Double(val)).trim();
            if (allMissing) {
                dt = missingLabel;
            }
        } else if (dataTipVariableArray[index] instanceof StringVariable) {
            StringVariable sv = (StringVariable)dataTipVariableArray[index];
            String same = null;
            Iterator it = n.getValueIndexIterator();
            while (it.hasNext()) {
                int valueIndex = (Integer)it.next();
                try {
                    if (same == null) {
                        same = sv.formattedValue.getValue(valueIndex).trim();
                        continue;
                    }
                    if (same == sv.formattedValue.getValue(valueIndex).trim()) continue;
                    return "";
                }
                catch (MissingValueException e) {
                    if (!this.model.isIncludeMissingValue()) continue;
                    same = ValueMap.getDefaultMissingValueLabel(e.getMissingValue());
                }
            }
            dt = same;
        }
        return dt;
    }

    public void startCreateTree(DefaultMutableTreeNode curNode, Rectangle2D.Double avail, Point2D.Double origin) {
        this.model.setCurrentRootTile((Tile)curNode.getUserObject());
        this.origToggleDir = this.model.getRootTile().rect.width >= this.model.getRootTile().rect.height;
        this.createTree(curNode, avail, origin, 0);
    }

    private void createTree(DefaultMutableTreeNode curNode, Rectangle2D.Double avail, Point2D.Double origin, int gen) {
        int jj = 0;
        Tile curObs = (Tile)curNode.getUserObject();
        int numChildren = curNode.getChildCount();
        Rectangle2D.Double[] childRect = new Rectangle2D.Double[numChildren];
        Point2D.Double newOrigin = new Point2D.Double(origin.x, origin.y);
        int[] sortedIndex = new int[1];
        if (this.model.getLayoutType() == RendererUtil.TileChartLayout.LAYOUT_STANDARD) {
            double[] sizes = new double[numChildren];
            sortedIndex = new int[numChildren];
            for (jj = 0; jj < numChildren; ++jj) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)curNode.getChildAt(jj);
                if (child instanceof DataTreeResponseNode) continue;
                sizes[jj] = ((Tile)child.getUserObject()).sizeValue;
                sortedIndex[jj] = jj;
            }
            for (jj = 0; jj < numChildren; ++jj) {
                int min = jj;
                for (int kk = jj + 1; kk < numChildren; ++kk) {
                    if (!(sizes[kk] > sizes[min])) continue;
                    min = kk;
                }
                double temp = sizes[min];
                sizes[min] = sizes[jj];
                sizes[jj] = temp;
                int tempI = sortedIndex[min];
                sortedIndex[min] = sortedIndex[jj];
                sortedIndex[jj] = tempI;
            }
        }
        Tile[] ttt = new Tile[numChildren];
        int curIndex = 0;
        DefaultMutableTreeNode child = null;
        for (jj = 0; jj < numChildren; ++jj) {
            int childIndex = 0;
            childIndex = this.model.getLayoutType() == RendererUtil.TileChartLayout.LAYOUT_STANDARD ? sortedIndex[jj] : jj;
            child = (DefaultMutableTreeNode)curNode.getChildAt(childIndex);
            if (child instanceof DataTreeResponseNode) continue;
            ttt[curIndex++] = (Tile)child.getUserObject();
        }
        if (curIndex > 0) {
            if (this.model.getLayoutType() == RendererUtil.TileChartLayout.LAYOUT_STANDARD) {
                this.divvyList(avail, newOrigin, ttt, curObs.sizeValue);
            } else if (this.model.getLayoutType() == RendererUtil.TileChartLayout.LAYOUT_TOGGLE) {
                boolean curToggleDir = this.origToggleDir;
                if (child.getLevel() % 2 == 1) {
                    curToggleDir = !this.origToggleDir;
                }
                this.divvyListDirectional(avail, newOrigin, ttt, curObs.sizeValue, curToggleDir);
            } else if (this.model.getLayoutType() == RendererUtil.TileChartLayout.LAYOUT_GEOGRAPHIC) {
                this.divvyList(avail, newOrigin, ttt, curObs.sizeValue);
            } else if (this.model.getLayoutType() == RendererUtil.TileChartLayout.LAYOUT_FLOW) {
                this.divvyListFlow(avail, newOrigin, ttt, curObs.sizeValue);
            }
        }
        for (jj = 0; jj < numChildren; ++jj) {
            int childIndex = 0;
            childIndex = this.model.getLayoutType() == RendererUtil.TileChartLayout.LAYOUT_STANDARD ? sortedIndex[jj] : jj;
            child = (DefaultMutableTreeNode)curNode.getChildAt(childIndex);
            if (child instanceof DataTreeResponseNode) continue;
            Tile childObs = (Tile)child.getUserObject();
            childObs.treeNode = child;
            Rectangle2D.Double tileRect = childObs.rect;
            if (tileRect == null) {
                return;
            }
            childRect[childIndex] = child.getChildCount() > 0 ? this.getGutteredRectangle(tileRect, gen) : tileRect;
            if (child.getChildCount() <= 0) continue;
            newOrigin.x = childRect[childIndex].x;
            newOrigin.y = childRect[childIndex].y;
            this.createTree(child, childRect[childIndex], newOrigin, gen + 1);
        }
    }

    private void divvyListFlow(Rectangle2D.Double free, Point2D.Double origin, Tile[] tiles, double total) {
        if (tiles.length <= 0) {
            return;
        }
        if (total == 0.0) {
            return;
        }
        int totalNumTiles = tiles.length;
        double aspect = free.height / free.width;
        int numRows = (int)Math.ceil(Math.sqrt(totalNumTiles));
        numRows = (int)Math.ceil((double)numRows * aspect);
        double rowTotal = total / (double)numRows;
        int curRow = 1;
        double curRowTotal = 0.0;
        int rowStartIndex = 0;
        int rowEndIndex = 0;
        double highRectY = free.y + free.height;
        Rectangle2D.Double rowFree = new Rectangle2D.Double(free.x, free.y, free.width, free.height / (double)numRows);
        Point2D.Double rowOrigin = new Point2D.Double(origin.x, origin.y);
        for (int curIndex = 0; curIndex < totalNumTiles; ++curIndex) {
            if (!((curRowTotal += tiles[curIndex].sizeValue) >= rowTotal) && curIndex + 1 != totalNumTiles) continue;
            if (curIndex + 1 != totalNumTiles && curRowTotal - rowTotal > rowTotal - (curRowTotal - tiles[curIndex].sizeValue) && curIndex > 0 && curIndex - rowStartIndex > 1) {
                curRowTotal -= tiles[curIndex].sizeValue;
                --curIndex;
            }
            if (curIndex + 2 == totalNumTiles && tiles[curIndex + 1].sizeValue < rowTotal * 0.4) {
                curRowTotal += tiles[++curIndex].sizeValue;
            } else if (curRow == numRows) {
                double lastRowTotal = 0.0;
                for (int tmpIndex = curIndex + 1; tmpIndex < totalNumTiles; ++tmpIndex) {
                    lastRowTotal += tiles[tmpIndex].sizeValue;
                }
                if (lastRowTotal < rowTotal * 0.25) {
                    curIndex = totalNumTiles - 1;
                    curRowTotal += lastRowTotal;
                }
            }
            rowEndIndex = curIndex;
            Tile[] rowTiles = new Tile[rowEndIndex - rowStartIndex + 1];
            System.arraycopy(tiles, rowStartIndex, rowTiles, 0, rowTiles.length);
            rowFree.height = free.height * curRowTotal / total;
            rowOrigin.y = rowFree.y = highRectY - rowFree.height;
            this.divvyListDirectional(rowFree, rowOrigin, rowTiles, curRowTotal, true);
            curRowTotal = 0.0;
            ++curRow;
            highRectY -= rowFree.height;
            rowStartIndex = rowEndIndex + 1;
        }
    }

    private void divvyList(Rectangle2D.Double free, Point2D.Double origin, Tile[] tiles, double total) {
        int count;
        if (tiles.length <= 0) {
            return;
        }
        if (total == 0.0) {
            for (int iii = 0; iii < tiles.length; ++iii) {
                tiles[iii].rect = new Rectangle2D.Double();
            }
            return;
        }
        double divvyThreshold = 0.5;
        if (this.model.getLayoutType() == RendererUtil.TileChartLayout.LAYOUT_GEOGRAPHIC) {
            int tempI;
            double temp;
            int kk;
            int min;
            int jj;
            divvyThreshold = 0.35;
            boolean widerThanTall = free.width > free.height;
            int len = tiles.length;
            ArrayList usedIndex = new ArrayList(len);
            double[] posX = new double[len];
            double[] posY = new double[len];
            int[] sortedIndexX = new int[len];
            int[] sortedIndexY = new int[len];
            for (jj = 0; jj < len; ++jj) {
                posX[jj] = tiles[jj].xValue;
                posY[jj] = tiles[jj].yValue;
                sortedIndexX[jj] = sortedIndexY[jj] = jj;
            }
            for (jj = 0; jj < len; ++jj) {
                min = jj;
                for (kk = jj + 1; kk < len; ++kk) {
                    if (!(posX[kk] < posX[min])) continue;
                    min = kk;
                }
                temp = posX[min];
                posX[min] = posX[jj];
                posX[jj] = temp;
                tempI = sortedIndexX[min];
                sortedIndexX[min] = sortedIndexX[jj];
                sortedIndexX[jj] = tempI;
            }
            for (jj = 0; jj < len; ++jj) {
                min = jj;
                for (kk = jj + 1; kk < len; ++kk) {
                    if (!(posY[kk] < posY[min])) continue;
                    min = kk;
                }
                temp = posY[min];
                posY[min] = posY[jj];
                posY[jj] = temp;
                tempI = sortedIndexY[min];
                sortedIndexY[min] = sortedIndexY[jj];
                sortedIndexY[jj] = tempI;
            }
            Tile[] tmpTiles = new Tile[tiles.length];
            for (jj = 0; jj < tiles.length; ++jj) {
                int index = this.getFirstUnusedIndex(widerThanTall ? sortedIndexX : sortedIndexY, usedIndex);
                tmpTiles[jj] = tiles[index];
            }
            tiles = tmpTiles;
        }
        Point2D.Double origOrigin = (Point2D.Double)origin.clone();
        Point2D.Double newOrigin = (Point2D.Double)origOrigin.clone();
        double accumSize = 0.0;
        for (count = 0; accumSize < total * divvyThreshold && count < tiles.length; accumSize += tiles[count].sizeValue, ++count) {
        }
        if (count == tiles.length && count > 1) {
            count = tiles.length / 2;
            accumSize = 0.0;
            for (int jj = 0; jj < count; ++jj) {
                accumSize += tiles[jj].sizeValue;
            }
        }
        if (count == 0 || accumSize <= 0.0) {
            return;
        }
        Tile[] newTiles = new Tile[count];
        for (int ii = 0; ii < count; ++ii) {
            newTiles[ii] = tiles[ii];
        }
        Rectangle2D.Double newRect = this.divvy(free, newOrigin, accumSize, total);
        if (count > 1) {
            this.divvyList(newRect, origOrigin, newTiles, accumSize);
        } else {
            newTiles[0].rect = newRect;
        }
        if (tiles.length - count > 0) {
            Tile[] otherTiles = new Tile[tiles.length - count];
            double otherWidth = free.width;
            double otherHeight = free.height;
            if (newRect.width < free.width) {
                otherWidth -= newRect.width;
            }
            if (newRect.height < free.height) {
                otherHeight -= newRect.height;
            }
            Rectangle2D.Double otherRect = new Rectangle2D.Double(newOrigin.x, newOrigin.y, otherWidth, otherHeight);
            for (int ii = count; ii < tiles.length; ++ii) {
                otherTiles[ii - count] = tiles[ii];
            }
            if (tiles.length - count > 1) {
                this.divvyList(otherRect, newOrigin, otherTiles, total - accumSize);
            } else {
                otherTiles[0].rect = otherRect;
            }
        }
    }

    private Rectangle2D.Double divvy(Rectangle2D.Double free, Point2D.Double origin, double value, double total) {
        Rectangle2D.Double used = new Rectangle2D.Double();
        double size = free.height * free.width * value / total;
        if (free.width - (origin.x - free.x) >= free.height - (origin.y - free.y)) {
            used.height = free.height - (origin.y - free.y);
            used.width = size / used.height;
            used.x = origin.x;
            used.y = origin.y;
            origin.x += used.width;
        } else {
            used.width = free.width - (origin.x - free.x);
            used.height = size / used.width;
            used.x = origin.x;
            used.y = origin.y;
            origin.y += used.height;
        }
        return used;
    }

    private void divvyListDirectional(Rectangle2D.Double free, Point2D.Double origin, Tile[] tiles, double total, boolean sideBySide) {
        if (tiles.length <= 0) {
            return;
        }
        if (total == 0.0) {
            for (int iii = 0; iii < tiles.length; ++iii) {
                tiles[iii].rect = new Rectangle2D.Double();
            }
            return;
        }
        Point2D.Double origOrigin = (Point2D.Double)origin.clone();
        Point2D.Double newOrigin = (Point2D.Double)origOrigin.clone();
        for (int iii = 0; iii < tiles.length; ++iii) {
            tiles[iii].rect = this.divvyDirectional(free, newOrigin, tiles[iii].sizeValue, total, sideBySide);
        }
    }

    private Rectangle2D.Double divvyDirectional(Rectangle2D.Double free, Point2D.Double origin, double value, double total, boolean sideBySide) {
        Rectangle2D.Double used = new Rectangle2D.Double();
        double size = free.height * free.width * value / total;
        if (sideBySide) {
            used.height = free.height - (origin.y - free.y);
            used.width = size / used.height;
            used.x = origin.x;
            used.y = origin.y;
            origin.x += used.width;
        } else {
            used.width = free.width - (origin.x - free.x);
            used.height = size / used.width;
            used.x = origin.x;
            used.y = origin.y;
            origin.y += used.height;
        }
        return used;
    }

    public void startDrawTree(DefaultMutableTreeNode curNode, double lowColorLegendValue, double highColorLegendValue) {
        this.startDrawTree(curNode, true, lowColorLegendValue, highColorLegendValue);
    }

    private void startDrawTree(DefaultMutableTreeNode curNode, boolean drawLabelsAndEdges, double lowColorLegendValue, double highColorLegendValue) {
        this.highRects.clear();
        this.drawTree(curNode, 0, drawLabelsAndEdges, lowColorLegendValue, highColorLegendValue);
        this.channel.glPolygonMode(6);
        for (HighlightRectangle hr : this.highRects) {
            this.channel.glColor(hr.color);
            this.channel.glEdgeColor(hr.edgeColor);
            this.channel.glRect(hr.rect.x, hr.rect.y, hr.rect.x + hr.rect.width, hr.rect.y + hr.rect.height);
        }
    }

    private void drawTree(DefaultMutableTreeNode curNode, int gen, boolean drawLabelsAndEdges, double lowColorLegendValue, double highColorLegendValue) {
        int numVisibleLevels = 0;
        numVisibleLevels = this.isOLAPData(this.model.getTileVariable()) ? this.model.getCurrentRootTile().treeNode.getDepth() - 1 : Math.min(this.model.getDetailLevel(), this.model.getCurrentRootTile().treeNode.getDepth() - 1);
        if (gen >= numVisibleLevels) {
            return;
        }
        int jj = 0;
        int numChildren = curNode.getChildCount();
        for (jj = 0; jj < numChildren; ++jj) {
            String labelText;
            double selectedPercentage;
            Color missingColor;
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)curNode.getChildAt(jj);
            if (child instanceof DataTreeResponseNode) continue;
            Tile childObs = (Tile)child.getUserObject();
            if (childObs.rect == null) continue;
            this.channel.glEdgeColor(Color.black);
            this.channel.glTextAlign(1, 1);
            if (!this.isLeafTile(child) && gen < numVisibleLevels - 1) {
                this.drawTree(child, gen + 1, drawLabelsAndEdges, lowColorLegendValue, highColorLegendValue);
                if (drawLabelsAndEdges && childObs.sizeValue > 0.0) {
                    String labelText2;
                    LineStyle curLS = this.model.getOutlineLineStyle(gen + 1);
                    TextStyle curTS = null;
                    if (gen + 1 == this.model.getDataLabelLevel()) {
                        curTS = this.model.getDataLabelTextStyle();
                    }
                    if (curLS != null && curLS.isVisible()) {
                        this.channel.glPolygonMode(2);
                        this.channel.glLineWidth((float)curLS.getWidth());
                        this.channel.glColor(curLS.getColor());
                        this.drawTileShape(this.channel, childObs.rect, null, curLS.getColor());
                    }
                    if (curTS != null && this.model.isDataLabelVisible() && (labelText2 = this.createTileLabel(childObs, RendererUtil.DataLabel.ID)) != "") {
                        this.drawTileLabel(labelText2, childObs, curTS);
                    }
                }
            }
            if ((!this.isLeafTile(child) || gen >= numVisibleLevels) && (this.isLeafTile(child) || gen != numVisibleLevels - 1) || !(childObs.sizeValue > 0.0)) continue;
            Color fillColor = Color.lightGray;
            LineStyle curLS = this.model.getOutlineLineStyle(gen + 1);
            if (curLS == null) {
                curLS = this.model.getOutlineLineStyle(-1);
            }
            TextStyle curTS = null;
            if (gen + 1 == this.model.getDataLabelLevel()) {
                curTS = this.model.getDataLabelTextStyle();
            }
            if (this.model.getDataLabelLevel() > numVisibleLevels) {
                curTS = this.model.getDataLabelTextStyle();
            }
            if ((missingColor = this.model.getMissingColor()) != null && missingColor.getAlpha() < 255) {
                missingColor = new Color(missingColor.getRed(), missingColor.getGreen(), missingColor.getBlue());
            }
            double curColorValue = childObs.colorValue;
            if (this.model.isColorVariableDiscrete()) {
                curColorValue = Math.min(highColorLegendValue, curColorValue);
                curColorValue = Math.max(lowColorLegendValue, curColorValue);
            }
            if (childObs.missingColor == null) {
                if (!this.model.isColorVariableDiscrete()) {
                    ColorMapper discreteColorMapper = this.model.getColorMapper();
                    if (discreteColorMapper != null && discreteColorMapper instanceof DiscreteRangeToColorMapper) {
                        fillColor = ((DiscreteRangeToColorMapper)discreteColorMapper).getValue(curColorValue);
                    } else {
                        double colorInput = 0.0;
                        colorInput = Math.abs(highColorLegendValue - lowColorLegendValue) < 1.0E-7 ? 0.5 : (curColorValue - lowColorLegendValue) / (highColorLegendValue - lowColorLegendValue);
                        if (curColorValue < lowColorLegendValue || curColorValue > highColorLegendValue) {
                            fillColor = this.model.getOutOfRangeColor();
                        } else if (this.model.getColorVariable() != null && this.model.getColorMapper() != null) {
                            if (this.model.getColorMapper().getClass() == ContinuousRangeToColorMapper.class) {
                                fillColor = ((ContinuousRangeToColorMapper)this.model.getColorMapper()).getValue(colorInput);
                            }
                        } else if (this.model.getFillAttrColor() != null) {
                            fillColor = this.model.getFillAttrColor();
                        }
                    }
                } else {
                    fillColor = this.model.getFillAttrColor() != null ? this.model.getFillAttrColor() : this.model.getColorMap().getValue(childObs.formattedColor);
                }
            } else {
                fillColor = this.model.isColorVariableDiscrete() ? (this.model.getFillAttrColor() != null ? this.model.getFillAttrColor() : this.model.getColorMap().getValue(childObs.formattedColor)) : missingColor;
            }
            if (fillColor == null) {
                fillColor = Color.ORANGE;
            }
            this.channel.glColor(fillColor);
            this.channel.glPolygonMode(3);
            if (drawLabelsAndEdges && curLS != null && curLS.isVisible() && childObs.sizeValue > 0.0) {
                this.channel.glPolygonMode(4);
                this.channel.glLineWidth((float)curLS.getWidth());
                Color edgeColor = curLS.getColor();
                if (edgeColor.equals(fillColor)) {
                    edgeColor = edgeColor.darker();
                }
                this.channel.glEdgeColor(edgeColor);
            }
            childObs.fillColor = fillColor;
            if (childObs.sizeValue > 0.0) {
                this.drawTileShape(this.channel, childObs.rect, fillColor, curLS.getColor());
            }
            if (this.model.getSizeSelectionVariable() != null && this.model.getColorSelectionVariable() != null && (selectedPercentage = this.isSelected(childObs)) > 0.0) {
                HighlightRectangle hr = new HighlightRectangle(this.model.getSelectionColor(), this.model.getSelectionAccentColor(), childObs.rect, gen == numVisibleLevels - 1 ? 100.0 : selectedPercentage);
                this.highRects.add(hr);
            }
            if (!drawLabelsAndEdges || curTS == null || !this.model.isDataLabelVisible() || !(childObs.sizeValue > 0.0) || (labelText = this.createTileLabel(childObs, RendererUtil.DataLabel.ID)) == "") continue;
            this.drawTileLabel(labelText, childObs, curTS);
        }
    }

    public String createTileLabel(Tile tt, RendererUtil.DataLabel labelContent) {
        String thisLabel = "";
        if (labelContent == RendererUtil.DataLabel.ID) {
            thisLabel = tt.idValue;
        } else if (labelContent == RendererUtil.DataLabel.SIZE) {
            thisLabel = tt.formattedSize;
        } else if (labelContent == RendererUtil.DataLabel.COLOR) {
            thisLabel = tt.formattedColor;
        }
        return thisLabel;
    }

    public void drawTileLabel(String label, Tile tile, TextStyle ts) {
        Font smallerFont = ts.getFont().getStyle() == 1 && ts.getFont().getSize2D() <= 12.0f ? ts.getFont() : ts.getFont().deriveFont((float)((double)ts.getFont().getSize2D() * 0.7));
        this.channel.glSelect2DFont(ts.getFont());
        int maxLabelWidth = (int)tile.rect.width - 7;
        int maxLabelHeight = (int)tile.rect.height - 7;
        double labelWidth = this.channel.glGetTextWidth(label);
        double labelHeight = this.channel.glGetTextHeight(label);
        int angle = 0;
        if (labelWidth > (double)maxLabelWidth) {
            String newLabel = this.splitLabel(label, ts.getFont(), maxLabelWidth);
            if (this.channel.glGetTextWidth(newLabel) <= (double)maxLabelWidth && this.channel.glGetTextHeight(newLabel) <= (double)maxLabelHeight) {
                label = newLabel;
                labelWidth = this.channel.glGetTextWidth(label);
                labelHeight = this.channel.glGetTextHeight(label);
            } else if (tile.rect.width < tile.rect.height) {
                angle = 90;
                newLabel = this.splitLabel(label, ts.getFont(), maxLabelHeight);
                if (this.channel.glGetTextWidth(newLabel) <= (double)maxLabelHeight && this.channel.glGetTextHeight(newLabel) <= (double)maxLabelWidth) {
                    label = newLabel;
                    labelWidth = this.channel.glGetTextHeight(label);
                    labelHeight = this.channel.glGetTextWidth(label);
                }
                if (labelWidth > (double)maxLabelHeight) {
                    this.channel.glSelect2DFont(smallerFont);
                    newLabel = this.splitLabel(label, ts.getFont(), maxLabelHeight);
                    if (this.channel.glGetTextWidth(newLabel) <= (double)maxLabelHeight && this.channel.glGetTextHeight(newLabel) <= (double)maxLabelWidth) {
                        label = newLabel;
                        labelWidth = this.channel.glGetTextHeight(label);
                        labelHeight = this.channel.glGetTextWidth(label);
                    }
                }
            } else {
                this.channel.glSelect2DFont(smallerFont);
                if (this.channel.glGetTextWidth(newLabel) <= (double)maxLabelWidth && this.channel.glGetTextHeight(newLabel) <= (double)maxLabelHeight) {
                    label = newLabel;
                    labelWidth = this.channel.glGetTextWidth(label);
                    labelHeight = this.channel.glGetTextHeight(label);
                }
            }
        }
        if (ts.isShadowOn()) {
            this.channel.glEnable(11);
            this.channel.setShadowColor(ts.getShadowColor());
            this.channel.setShadowOffset(ts.getShadowOffsetX(), ts.getShadowOffsetY());
            this.channel.setShadowSoftness(ts.getShadowSoftness());
        }
        this.channel.glColor(ts.getColor());
        if (labelWidth <= (double)maxLabelWidth && labelHeight <= (double)maxLabelHeight) {
            this.channel.glAlignment(1, 1);
            this.channel.gl2DText(label, tile.rect.x + tile.rect.width / 2.0, tile.rect.y + tile.rect.height / 2.0, 0.0, angle);
        }
        this.channel.glDisable(11);
    }

    private String splitLabel(String lab, Font f, int limit) {
        String newLab = lab;
        if (this.channel.glGetTextWidth(lab) < (double)limit) {
            return lab;
        }
        int numBreaks = 0;
        int strLen = lab.length();
        String[] bits = lab.split("\\s");
        if (bits.length == 1) {
            return lab;
        }
        while (this.channel.glGetTextWidth(newLab) > (double)limit && numBreaks < bits.length) {
            int nn = 0;
            ++numBreaks;
            newLab = "";
            for (int jj = 0; jj < numBreaks; ++jj) {
                while (newLab.length() < (jj + 1) * (strLen / (numBreaks + 1)) && nn < bits.length) {
                    newLab = newLab + bits[nn++] + " ";
                }
                newLab = newLab.trim() + "\n";
            }
            if (nn < bits.length) {
                for (int ii = nn; ii < bits.length; ++ii) {
                    newLab = newLab + bits[ii] + " ";
                }
            }
            newLab = newLab.trim();
        }
        return newLab;
    }

    private void drawTileShape(Channel c, Rectangle2D.Double r, Color fillColor, Color edgeColor) {
        if (r.x >= this.model.getCurrentRootTile().rect.x + this.model.getCurrentRootTile().rect.width) {
            return;
        }
        c.glRect(r.x, r.y, r.x + r.width, r.y + r.height);
    }

    private int getFirstUnusedIndex(int[] indices, ArrayList used) {
        int ii;
        for (ii = 0; ii < indices.length && used.contains(new Integer(indices[ii])); ++ii) {
        }
        used.add(new Integer(indices[ii]));
        return indices[ii];
    }

    private Rectangle2D.Double getGutteredRectangle(Rectangle2D.Double r, int gen) {
        Rectangle2D.Double newRect = (Rectangle2D.Double)r.clone();
        if (this.gutterIt) {
            newRect.width -= 2.0;
            newRect.height -= 2.0;
            newRect.x += (r.width - newRect.width) / 2.0;
            newRect.y += (r.height - newRect.height) / 2.0;
        }
        return newRect;
    }

    public void drawStatusLine(ArrayList zoomNames, String otherLabel) {
        int numOtherLevels = 0;
        TextStyle statusTS = this.model.getStatusLineTextStyle();
        double labelHeight = 0.0;
        this.statusList.clear();
        this.variableLabelList.clear();
        this.variableNameList.clear();
        if (statusTS != null && this.model.isStatusLineVisible()) {
            double curX;
            this.channel.glSelect2DFont(statusTS.getFont());
            labelHeight = this.channel.glGetTextHeight();
            this.channel.glTextAlign(0, 0);
            if (statusTS.isShadowOn()) {
                this.channel.glEnable(11);
                this.channel.setShadowColor(statusTS.getShadowColor());
                this.channel.setShadowOffset(statusTS.getShadowOffsetX(), statusTS.getShadowOffsetY());
                this.channel.setShadowSoftness(statusTS.getShadowSoftness());
            }
            double oldX = curX = (double)(this.globalBounds.x + 3);
            Variable[] idVariableArray = this.model.getTileVariable();
            if (!this.isOLAPData(idVariableArray)) {
                for (int ii = 0; ii < idVariableArray.length + numOtherLevels; ++ii) {
                    boolean bold = false;
                    boolean underline = false;
                    boolean arrowAfter = true;
                    String name = idVariableArray[ii - numOtherLevels].getLabel();
                    if (zoomNames != null && zoomNames.size() > ii) {
                        String curZoomName = ((String)zoomNames.get(zoomNames.size() - ii - 1)).trim();
                        if (curZoomName.equals(otherLabel)) {
                            String otherName = "<" + curZoomName + "> " + name;
                            this.channel.glColor(statusTS.getColor());
                            curX = this.drawStatusLineElement(statusTS.getFont(), otherName, curX, false, true, true);
                            ++numOtherLevels;
                            continue;
                        }
                        name = name + " (" + curZoomName + ")";
                    }
                    if (ii == idVariableArray.length + numOtherLevels - 1) {
                        arrowAfter = false;
                    }
                    if (zoomNames != null && ii <= zoomNames.size() - 1) {
                        underline = true;
                    } else if (zoomNames != null && ii < zoomNames.size() + this.model.getDetailLevel() || ii < this.model.getDetailLevel()) {
                        bold = true;
                    }
                    this.channel.glColor(statusTS.getColor());
                    curX = this.drawStatusLineElement(statusTS.getFont(), name, curX, bold, underline, arrowAfter);
                    Rectangle2D.Double labelRect = new Rectangle2D.Double(oldX, this.globalBounds.height - this.globalBounds.height, curX - oldX, labelHeight);
                    this.statusList.add(labelRect);
                    this.variableLabelList.add(name);
                    this.variableNameList.add(idVariableArray[ii - numOtherLevels].getColumnName());
                    oldX = curX;
                }
            } else {
                String prevHier = ((OLAPLevelVariable)idVariableArray[0]).getHierachyName();
                for (int ii = 1; ii < idVariableArray.length + numOtherLevels; ++ii) {
                    String curHier = ((OLAPLevelVariable)idVariableArray[ii]).getHierachyName();
                    if (curHier.equals(prevHier)) continue;
                    String label = ((OLAPLevelVariable)idVariableArray[ii - 1]).getHierachyLabel();
                    this.channel.glColor(statusTS.getColor());
                    curX = this.drawStatusLineElement(statusTS.getFont(), label, curX, false, false, true);
                    Rectangle2D.Double labelRect = new Rectangle2D.Double(oldX, this.globalBounds.height - this.globalBounds.height, curX - oldX, labelHeight);
                    this.statusList.add(labelRect);
                    this.variableNameList.add(prevHier);
                    this.variableLabelList.add(label);
                    oldX = curX;
                    prevHier = curHier;
                }
                String label = ((OLAPLevelVariable)idVariableArray[idVariableArray.length - 1]).getHierachyLabel();
                this.channel.glColor(statusTS.getColor());
                curX = this.drawStatusLineElement(statusTS.getFont(), label, curX, false, false, false);
                Rectangle2D.Double labelRect = new Rectangle2D.Double(oldX, this.globalBounds.height - this.globalBounds.height, curX - oldX, labelHeight);
                this.statusList.add(labelRect);
                this.variableNameList.add(prevHier);
                this.variableLabelList.add(label);
            }
        }
        this.channel.glDisable(11);
    }

    private double drawStatusLineElement(Font f, String name, double xLoc, boolean bold, boolean underlined, boolean arrowAfter) {
        double newX = xLoc;
        Font elementFont = bold ? f.deriveFont(1) : f.deriveFont(0);
        this.channel.glSelect2DFont(elementFont);
        this.channel.glTextAlign(0, 0);
        this.channel.gl2DText(name, xLoc, (double)this.globalBounds.height, 0.0);
        newX += this.channel.glGetTextWidth(name);
        if (arrowAfter) {
            double arrowHeadTopX;
            double ARROW_WIDTH = this.channel.glGetTextWidth("n");
            double ARROW_SPACE = Math.ceil(this.channel.glGetTextWidth("a") * 0.25);
            double arrowLineBeginX = newX + ARROW_SPACE;
            double arrowLineEndX = arrowLineBeginX + ARROW_WIDTH;
            double arrowHeadBottomX = arrowHeadTopX = arrowLineEndX - ARROW_SPACE;
            double arrowLineY = Math.ceil((double)this.globalBounds.height - this.channel.glGetTextHeight() / 2.0);
            double arrowHeadTopY = arrowLineY - ARROW_SPACE;
            double arrowHeadBottomY = arrowLineY + ARROW_SPACE;
            this.channel.glLineWidth(1.0f);
            this.channel.glBegin(1);
            this.channel.glVertex(arrowLineBeginX, arrowLineY, 0.0);
            this.channel.glVertex(arrowLineEndX, arrowLineY, 0.0);
            this.channel.glVertex(arrowHeadTopX, arrowHeadTopY, 0.0);
            this.channel.glEnd();
            this.channel.glBegin(1);
            this.channel.glVertex(arrowLineEndX, arrowLineY, 0.0);
            this.channel.glVertex(arrowHeadBottomX, arrowHeadBottomY, 0.0);
            this.channel.glEnd();
            newX += ARROW_WIDTH + ARROW_SPACE * 3.0;
        }
        if (underlined) {
            this.channel.glLineWidth(1.0f);
            this.channel.glColor(Color.blue);
            this.channel.glBegin(1);
            double underlineAjustment = this.channel.glGetTextHeight() * 0.2;
            double textBottom = (double)this.globalBounds.height - this.channel.glGetTextHeight() + underlineAjustment;
            this.channel.glVertex(xLoc, textBottom, 0.0);
            this.channel.glVertex(xLoc + this.channel.glGetTextWidth(name), textBottom, 0.0);
            this.channel.glEnd();
        }
        return newX;
    }

    public Tile getTileAtPosition(Point2D point, DefaultMutableTreeNode node, boolean isAnimating) {
        int numVisibleLevels = 0;
        numVisibleLevels = this.isOLAPData(this.model.getTileVariable()) ? this.model.getCurrentRootTile().treeNode.getDepth() - 1 : Math.min(this.model.getDetailLevel(), this.model.getCurrentRootTile().treeNode.getDepth() - 1);
        int curLevel = 0;
        DefaultMutableTreeNode curNode = node;
        DefaultMutableTreeNode prevNode = null;
        Tile nodeObs = (Tile)node.getUserObject();
        if (nodeObs == null || nodeObs.rect == null || !nodeObs.rect.contains(point.getX(), point.getY()) || isAnimating) {
            return null;
        }
        block0: while (!this.isLeafTile(curNode) && curLevel < numVisibleLevels) {
            if (prevNode == curNode) {
                return null;
            }
            prevNode = curNode;
            for (int jj = 0; jj < curNode.getChildCount(); ++jj) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)curNode.getChildAt(jj);
                if (child instanceof DataTreeResponseNode) continue;
                Tile childObs = (Tile)child.getUserObject();
                if (childObs.rect == null) {
                    return null;
                }
                if (!childObs.rect.contains(point.getX(), point.getY())) continue;
                curNode = child;
                ++curLevel;
                continue block0;
            }
        }
        return (Tile)curNode.getUserObject();
    }

    public String[] getRootPath() {
        DataTreeGroupNode root = (DataTreeGroupNode)this.model.getDataTree();
        if (root != null && this.model.getCurrentRootTile() != null) {
            return this.model.getCurrentRootTile().getPath();
        }
        return new String[0];
    }

    public void setRootTilePath() {
        String[] path = this.model.getRootPath();
        DataTreeGroupNode root = (DataTreeGroupNode)this.model.getDataTree();
        Tile curTile = null;
        if (root == null || this.model.getCurrentRootTile() == null) {
            if (this.model.getRootTile() == null) {
                this.model.setRootTile(new Tile(rootTileName));
            }
            if (this.model.getDetailLevel() == 0) {
                this.model.setDetailLevel(this.model.getTileVariable().length);
            }
            double[] dataValues = this.attachTilesToDataTree();
            this.lowColorDataValue = dataValues[0];
            this.highColorDataValue = dataValues[1];
            if (this.highColorLegendValue == Double.NEGATIVE_INFINITY) {
                this.highColorLegendValue = this.highColorDataValue;
            }
            if (this.lowColorLegendValue == Double.POSITIVE_INFINITY) {
                this.lowColorLegendValue = this.lowColorDataValue;
            }
            this.model.setTreeToBeReattached(false);
            this.startCreateTree(this.model.getRootTile().treeNode, this.model.getRootTile().rect, new Point2D.Double(this.model.getRootTile().rect.x, this.model.getRootTile().rect.y));
        } else {
            DataTreeGroupNode curNode = root;
            if (path != null && path.length > 0 && path.length < curNode.getDepth() - 1) {
                DefaultMutableTreeNode tmpNode = null;
                for (int i = 0; i < path.length; ++i) {
                    for (int j = 0; j < curNode.getChildCount(); ++j) {
                        tmpNode = (DefaultMutableTreeNode)curNode.getChildAt(j);
                        if (!(tmpNode instanceof DataTreeGroupNode)) {
                            return;
                        }
                        if (!((Tile)tmpNode.getUserObject()).idValue.equals(path[i])) continue;
                        curNode = (DataTreeGroupNode)tmpNode;
                        break;
                    }
                    if (curNode != tmpNode) {
                        return;
                    }
                    curTile = (Tile)curNode.getUserObject();
                }
            }
            if (curTile == null) {
                return;
            }
            Rectangle2D.Double dr = new Rectangle2D.Double();
            double destAspect = curTile.rect.height / curTile.rect.width;
            double origRootAspect = this.model.getRootTile().rect.height / this.model.getRootTile().rect.width;
            if (destAspect < origRootAspect) {
                dr.width = this.model.getRootTile().rect.width;
                dr.height = dr.width / curTile.rect.width * curTile.rect.height;
                dr.x = this.model.getRootTile().rect.x;
                dr.y = (this.model.getRootTile().rect.height - dr.height) / 2.0;
            } else {
                dr.height = this.model.getRootTile().rect.height;
                dr.width = dr.height / curTile.rect.height * curTile.rect.width;
                dr.y = this.model.getRootTile().rect.y;
                dr.x = this.model.getRootTile().rect.x + (this.model.getRootTile().rect.width - dr.width) / 2.0;
            }
            this.model.setCurrentRootTile(curTile);
            this.model.getCurrentRootTile().rect = dr;
            this.startCreateTree(this.model.getCurrentRootTile().treeNode, this.model.getCurrentRootTile().rect, new Point2D.Double(this.model.getCurrentRootTile().rect.x, this.model.getCurrentRootTile().rect.y));
            this.model.setTreeToBeRecreated(false);
        }
    }

    public ArrayList getTileAtPosition(Rectangle2D rect, boolean isAnimating) {
        return this.getTileAtPosition(rect, this.model.getCurrentRootTile().treeNode, isAnimating);
    }

    public ArrayList getTileAtPosition(Rectangle2D rect, DefaultMutableTreeNode node, boolean isAnimating) {
        ArrayList<Object> tiles;
        block6: {
            int numVisibleLevels = 0;
            numVisibleLevels = this.isOLAPData(this.model.getTileVariable()) ? this.model.getCurrentRootTile().treeNode.getDepth() - 1 : Math.min(this.model.getDetailLevel(), this.model.getCurrentRootTile().treeNode.getDepth() - 1);
            int curLevel = 0;
            tiles = new ArrayList<Object>();
            DefaultMutableTreeNode curNode = node;
            Tile nodeObs = (Tile)node.getUserObject();
            if (nodeObs == null || nodeObs.rect == null || !nodeObs.rect.intersects(rect) || isAnimating) break block6;
            if (rect.getWidth() == 1.0 && rect.getHeight() == 1.0) {
                block0: while (!this.isLeafTile(curNode) && curLevel < numVisibleLevels) {
                    for (int jj = 0; jj < curNode.getChildCount(); ++jj) {
                        DefaultMutableTreeNode child = (DefaultMutableTreeNode)curNode.getChildAt(jj);
                        Tile childObs = (Tile)child.getUserObject();
                        if (childObs.rect == null) {
                            curLevel = numVisibleLevels;
                            continue block0;
                        }
                        if (!childObs.rect.intersects(rect) || !this.isLeafTile(curNode = child) && ++curLevel != numVisibleLevels) continue;
                        tiles.add(curNode.getUserObject());
                    }
                }
            } else {
                Enumeration<TreeNode> en = node.depthFirstEnumeration();
                while (en.hasMoreElements()) {
                    curNode = (DefaultMutableTreeNode)en.nextElement();
                    boolean leaf = this.isLeafTile(curNode);
                    if (!leaf && curNode.getLevel() - this.model.getCurrentRootTile().treeNode.getLevel() != numVisibleLevels + 1 || !(curNode instanceof DataTreeGroupNode)) continue;
                    DataTreeGroupNode curGroupNode = (DataTreeGroupNode)curNode;
                    Tile curTile = (Tile)curGroupNode.getUserObject();
                    Rectangle2D.Double rect2 = new Rectangle2D.Double(rect.getX(), rect.getY() - rect.getHeight(), rect.getWidth(), rect.getHeight());
                    if (!curTile.rect.intersects(rect2)) continue;
                    tiles.add(curNode.getUserObject());
                }
            }
        }
        return tiles;
    }

    public void initColorMapper() {
        ColorMapper colorMapper = this.model.getColorMapper();
        if (colorMapper instanceof ContinuousRangeToColorMapper) {
            ((ContinuousRangeToColorMapper)colorMapper).input.connectFrom(this.missingVals);
        }
        if (colorMapper != null) {
            colorMapper.init(new AInitAction());
        }
    }

    public boolean isLeafTile(DefaultMutableTreeNode node) {
        boolean ilt = false;
        if (node.getChildCount() == 1 && node.getChildAt(0) instanceof DataTreeResponseNode) {
            ilt = true;
        }
        return ilt;
    }

    public boolean isOLAPData(Variable[] idVariableArray) {
        Variable var = idVariableArray[0];
        return var instanceof OLAPLevelVariable;
    }

    private double isSelected(Tile tile) {
        double d1 = 0.0;
        double d2 = 0.0;
        double selectedPercentage = 0.0;
        int count = 0;
        DataTreeGroupNode gn = (DataTreeGroupNode)tile.treeNode;
        Iterator iter = gn.getValueIndexIterator();
        Variable sizeSelectionVariable = this.model.getSizeSelectionVariable();
        Variable colorSelectionVariable = this.model.getColorSelectionVariable();
        NumericVariable selectedPercentageVariable = this.model.getSelectedPercentageVariable();
        while (iter.hasNext()) {
            Integer bigI = (Integer)iter.next();
            try {
                d1 = ((NumericVariable)sizeSelectionVariable).value.getValue(bigI);
                d2 = ((NumericVariable)colorSelectionVariable).value.getValue(bigI);
                ++count;
                if (!(d1 > 0.0) && !(d2 > 0.0)) continue;
                if (selectedPercentageVariable != null) {
                    selectedPercentage += selectedPercentageVariable.value.getValue(bigI);
                    continue;
                }
                selectedPercentage = 1.0;
            }
            catch (MissingValueException missingValueException) {}
        }
        if (count != 0) {
            selectedPercentage /= (double)count;
        }
        return selectedPercentage;
    }

    static class HighlightRectangle {
        public Color color = null;
        public Color edgeColor = null;
        public Rectangle2D.Double rect = null;
        public double selectionPercentage = 0.0;

        public HighlightRectangle(Color c, Color ec, Rectangle2D.Double r, double sp) {
            this.color = c;
            this.edgeColor = ec;
            this.rect = r;
            this.selectionPercentage = sp;
        }
    }
}

