/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.render.map;

import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import javax.imageio.ImageIO;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RESTEsriUtil {
    public static String normalizeURLString(String urlString) {
        String retString = urlString;
        if (retString.indexOf("://") < 0) {
            retString = "http://" + retString;
        }
        if (retString.charAt(retString.length() - 1) == '/') {
            retString = retString.substring(0, retString.length() - 1);
        }
        if (retString.indexOf("MapServer") < 0) {
            retString = retString + "/MapServer";
        }
        return retString;
    }

    public static String getServicesURL(String urlString) {
        String retString = RESTEsriUtil.normalizeURLString(urlString);
        retString = retString.substring(0, retString.indexOf("/rest/services") + "/rest/services".length());
        return retString;
    }

    public static String getMapServiceURL(String server, String mapService) {
        return RESTEsriUtil.getMapServiceURL(server, mapService, false, null);
    }

    public static String getMapServiceURL(String server, String mapService, Proxy proxy) {
        return RESTEsriUtil.getMapServiceURL(server, mapService, false, proxy);
    }

    public static String getMapServiceURL(String server, String mapService, boolean validate) {
        return RESTEsriUtil.getMapServiceURL(server, mapService, validate, null);
    }

    public static String getMapServiceURL(String server, String mapService, boolean validate, Proxy proxy) {
        String urlString = "http://" + server + ":8399/arcgis/rest/services/" + mapService + "/MapServer";
        if (validate) {
            if (RESTEsriUtil.connectionExists(urlString, proxy)) {
                return urlString;
            }
            String urlString2 = "http://" + server + "/arcgis/rest/services/" + mapService + "/MapServer";
            if (RESTEsriUtil.connectionExists(urlString2, proxy)) {
                return urlString2;
            }
            urlString2 = "http://" + server + "/ArcGIS/rest/services/" + mapService + "/MapServer";
            if (RESTEsriUtil.connectionExists(urlString2, proxy)) {
                return urlString2;
            }
            urlString2 = "http://" + server + ":8399/ArcGIS/rest/services/" + mapService + "/MapServer";
            if (RESTEsriUtil.connectionExists(urlString2, proxy)) {
                return urlString2;
            }
        }
        return urlString;
    }

    public static Rectangle2D.Double getMapBounds(String url, Rectangle2D.Double bounds, int width, int height) {
        return RESTEsriUtil.getMapBounds(url, bounds, width, height, null);
    }

    public static Rectangle2D.Double getMapBounds(String urlString, Rectangle2D.Double bounds, int width, int height, Proxy proxy) {
        if (width == 0 || height == 0) {
            return null;
        }
        urlString = RESTEsriUtil.normalizeURLString(urlString) + "/export?f=json&size=" + width + "," + height + "&bbox=" + bounds.x + "," + bounds.y + "," + (bounds.x + bounds.width) + "," + (bounds.y + bounds.height);
        Rectangle2D.Double returnBounds = new Rectangle2D.Double();
        try {
            JSONObject extent = RESTEsriUtil.getJSONResponse(urlString, "extent", proxy);
            returnBounds.x = (Double)extent.get("xmin");
            returnBounds.y = (Double)extent.get("ymin");
            returnBounds.width = (Double)extent.get("xmax") - returnBounds.x;
            returnBounds.height = (Double)extent.get("ymax") - returnBounds.y;
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return returnBounds;
    }

    public static boolean isCached(String url) {
        return RESTEsriUtil.isCached(url, null);
    }

    public static boolean isCached(String urlString, Proxy proxy) {
        urlString = RESTEsriUtil.normalizeURLString(urlString) + "?f=json";
        try {
            return RESTEsriUtil.getJSONResponse(urlString, "singleFusedMapCache", proxy).getBoolean(null);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static JSONArray getFeaturesForLayer(String urlString, String layerName, String fieldName, String query) {
        return RESTEsriUtil.getFeaturesForLayer(urlString, layerName, fieldName, query, "", null);
    }

    public static JSONArray getFeaturesForLayer(String urlString, String layerName, String fieldName, String query, Proxy proxy) {
        return RESTEsriUtil.getFeatures(RESTEsriUtil.normalizeURLString(urlString) + "/" + RESTEsriUtil.getLayerId(urlString, layerName, proxy), fieldName, query, "", true, proxy);
    }

    public static JSONArray getFeaturesForLayer(String urlString, String layerName, String fieldName, String query, String spatialRef) {
        return RESTEsriUtil.getFeatures(RESTEsriUtil.normalizeURLString(urlString) + "/" + RESTEsriUtil.getLayerId(urlString, layerName), fieldName, query, spatialRef, true, null);
    }

    public static JSONArray getFeaturesForLayer(String urlString, String layerName, String fieldName, String query, String spatialRef, Proxy proxy) {
        return RESTEsriUtil.getFeatures(RESTEsriUtil.normalizeURLString(urlString) + "/" + RESTEsriUtil.getLayerId(urlString, layerName, proxy), fieldName, query, spatialRef, true, proxy);
    }

    public static JSONArray getAllAttributes(String urlString, String fieldName) {
        return RESTEsriUtil.getFeatures(urlString, fieldName, "1=1", "", false, null);
    }

    public static JSONArray getAllAttributes(String urlString, String fieldName, Proxy proxy) {
        return RESTEsriUtil.getFeatures(urlString, fieldName, "1=1", "", false, proxy);
    }

    public static JSONArray getAllFeatures(String urlString, String fieldName) {
        return RESTEsriUtil.getFeatures(urlString, fieldName, "1=1", "", true, null);
    }

    public static JSONArray getAllFeatures(String urlString, String fieldName, Proxy proxy) {
        return RESTEsriUtil.getFeatures(urlString, fieldName, "1=1", "", true, proxy);
    }

    public static JSONArray getAllFeatures(String urlString, String fieldName, String spatialRef) {
        return RESTEsriUtil.getFeatures(urlString, fieldName, "1=1", spatialRef, true, null);
    }

    public static JSONArray getAllFeatures(String urlString, String fieldName, String spatialRef, Proxy proxy) {
        return RESTEsriUtil.getFeatures(urlString, fieldName, "1=1", spatialRef, true, proxy);
    }

    public static JSONArray getFeatures(String urlString, String fieldName, String query) {
        return RESTEsriUtil.getFeatures(urlString, fieldName, query, "", true, null);
    }

    public static JSONArray getFeatures(String urlString, String fieldName, String query, Proxy proxy) {
        return RESTEsriUtil.getFeatures(urlString, fieldName, query, "", true, proxy);
    }

    public static JSONArray getFeatures(String urlString, String fieldName, String query, String spatialRef) {
        return RESTEsriUtil.getFeatures(urlString, fieldName, query, spatialRef, true, null);
    }

    public static JSONArray getFeatures(String urlString, String fieldName, String query, String spatialRef, Proxy proxy) {
        return RESTEsriUtil.getFeatures(urlString, fieldName, query, spatialRef, true, proxy);
    }

    private static JSONArray getFeatures(String urlString, String fieldName, String query, String spatialRef, boolean returnGeometries, Proxy proxy) {
        JSONArray features = null;
        String sr = spatialRef;
        if (sr == null) {
            sr = "";
        }
        try {
            urlString = RESTEsriUtil.normalizeURLString(urlString) + "/query?f=json&where=" + URLEncoder.encode(query, "UTF-8") + "&returnGeometry=" + returnGeometries + "&outSR=" + sr + "&outfields=" + fieldName;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            features = RESTEsriUtil.getJSONResponseArray(urlString, "features", proxy);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return features;
    }

    public static String getSpatialReference(String urlString) {
        return RESTEsriUtil.getSpatialReference(urlString, null);
    }

    public static String getSpatialReference(String urlString, Proxy proxy) {
        String sr = null;
        try {
            sr = RESTEsriUtil.getJSONResponse(RESTEsriUtil.normalizeURLString(urlString) + "?f=json", "spatialReference", proxy).getString("wkid");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return sr;
    }

    public static Vector<String> getMapServiceNames(String urlString) {
        return RESTEsriUtil.getMapServiceNames(urlString, null);
    }

    public static Vector<String> getMapServiceNames(String urlString, Proxy proxy) {
        Vector<String> nameArray = new Vector<String>();
        try {
            JSONArray ja = RESTEsriUtil.getJSONResponseArray(RESTEsriUtil.getServicesURL(urlString) + "?f=json", "services", proxy);
            for (int i = 0; i < ja.length(); ++i) {
                String type = ja.getJSONObject(i).getString("type");
                if (!type.equals("MapServer")) continue;
                nameArray.add(ja.getJSONObject(i).getString("name"));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return nameArray;
    }

    public static Vector<String> getVisibleLayers(String urlString, boolean includeGroup) {
        return RESTEsriUtil.getLayerNames(urlString, includeGroup, true, null);
    }

    public static Vector<String> getVisibleLayers(String urlString, Proxy proxy) {
        return RESTEsriUtil.getLayerNames(urlString, false, true, proxy);
    }

    public static Vector<String> getVisibleLayers(String urlString) {
        return RESTEsriUtil.getLayerNames(urlString, false, true, null);
    }

    public static Vector<String> getVisibleLayers(String urlString, boolean includeGroup, Proxy proxy) {
        return RESTEsriUtil.getLayerNames(urlString, includeGroup, true, proxy);
    }

    public static Vector<String> getAllLayers(String urlString, boolean includeGroup) {
        return RESTEsriUtil.getLayerNames(urlString, includeGroup, false, null);
    }

    public static Vector<String> getAllLayers(String urlString, Proxy proxy) {
        return RESTEsriUtil.getLayerNames(urlString, false, false, null);
    }

    public static Vector<String> getAllLayers(String urlString) {
        return RESTEsriUtil.getLayerNames(urlString, false, false, null);
    }

    public static Vector<String> getAllLayers(String urlString, boolean includeGroup, Proxy proxy) {
        return RESTEsriUtil.getLayerNames(urlString, includeGroup, false, proxy);
    }

    private static Vector<String> getLayerNames(String urlString, boolean includeGroup, boolean visibleOnly, Proxy proxy) {
        return new Vector<String>(RESTEsriUtil.getLayers(urlString, includeGroup, visibleOnly, proxy).keySet());
    }

    private static HashMap<String, String> getLayers(String urlString, boolean includeGroup, boolean visibleOnly, Proxy proxy) {
        HashMap<String, String> layers = new HashMap<String, String>();
        try {
            JSONArray ja = RESTEsriUtil.getJSONResponseArray(RESTEsriUtil.normalizeURLString(urlString) + "?f=json", "layers", proxy);
            for (int i = 0; i < ja.length(); ++i) {
                JSONArray sublayers = ja.getJSONObject(i).isNull("subLayerIds") ? null : ja.getJSONObject(i).getJSONArray("subLayerIds");
                boolean visible = ja.getJSONObject(i).getBoolean("defaultVisibility");
                if (!includeGroup && sublayers != null && sublayers.length() != 0 || visibleOnly && !visible) continue;
                String id = ja.getJSONObject(i).getString("id");
                String name = ja.getJSONObject(i).getString("name");
                layers.put(name, id);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return layers;
    }

    public static String getLayerId(String urlString, String layerName) {
        return RESTEsriUtil.getLayerId(urlString, layerName, null);
    }

    public static String getLayerId(String urlString, String layerName, Proxy proxy) {
        return RESTEsriUtil.getLayers(urlString, true, false, proxy).get(layerName);
    }

    public static Vector<String> getFields(String urlString, String layerName, Proxy proxy) {
        return RESTEsriUtil.getFields(RESTEsriUtil.normalizeURLString(urlString) + "/" + RESTEsriUtil.getLayerId(urlString, layerName, proxy), proxy);
    }

    public static Vector<String> getFields(String urlString, String layerName) {
        return RESTEsriUtil.getFields(urlString, layerName, null);
    }

    public static Vector<String> getFields(String urlString) {
        return RESTEsriUtil.getFields(urlString, (Proxy)null);
    }

    public static Vector<String> getFields(String urlString, Proxy proxy) {
        Vector<String> fieldArray = new Vector<String>();
        try {
            JSONArray ja = RESTEsriUtil.getJSONResponseArray(RESTEsriUtil.normalizeURLString(urlString) + "?f=json", "fields", proxy);
            for (int i = 0; i < ja.length(); ++i) {
                if (ja.getJSONObject(i).getString("type").equals("esriFieldTypeGeometry")) continue;
                fieldArray.add(ja.getJSONObject(i).getString("name"));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return fieldArray;
    }

    public static Vector<Object> getFieldValues(String urlString, String layerName, String fieldName) {
        return RESTEsriUtil.getFieldValues(urlString, layerName, fieldName, -1, null);
    }

    public static Vector<Object> getFieldValues(String urlString, String layerName, String fieldName, int numToReturn) {
        return RESTEsriUtil.getFieldValues(urlString, layerName, fieldName, numToReturn, null);
    }

    public static Vector<Object> getFieldValues(String urlString, String layerName, String fieldName, int numToReturn, Proxy proxy) {
        Vector<String> fields = new Vector<String>();
        fields.add(fieldName);
        return RESTEsriUtil.getFieldValues(urlString, layerName, fields, numToReturn, proxy).get(0);
    }

    private static Vector<Vector<Object>> getFieldValues(String urlString, String layerName, Vector<String> fieldNames, int numToReturn, Proxy proxy) {
        return RESTEsriUtil.getFieldValues(RESTEsriUtil.normalizeURLString(urlString) + "/" + RESTEsriUtil.getLayerId(urlString, layerName, proxy), fieldNames, numToReturn, proxy);
    }

    private static Vector<Vector<Object>> getFieldValues(String urlString, Vector<String> fieldNames, int numToReturn, Proxy proxy) {
        int i;
        Vector<String> fields = fieldNames;
        if (fieldNames == null || fieldNames.size() == 0) {
            fields = RESTEsriUtil.getFields(urlString, proxy);
        }
        String fieldList = fields.get(0);
        for (i = 1; i < fields.size(); ++i) {
            fieldList = fieldList + "," + fields.get(i);
        }
        Vector<Vector<Object>> valueArray = new Vector<Vector<Object>>();
        try {
            JSONArray ja = RESTEsriUtil.getAllAttributes(urlString, fieldList, proxy);
            if (numToReturn < 0) {
                numToReturn = ja.length();
            }
            for (i = 0; i < numToReturn; ++i) {
                for (int j = 0; j < fields.size(); ++j) {
                    if (i == 0) {
                        valueArray.add(new Vector());
                    }
                    valueArray.get(j).add(ja.getJSONObject(i).getJSONObject("attributes").get(fields.get(j)));
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return valueArray;
    }

    public static double[] testData(String urlString, String layerName, String fieldName, Object[] myData) {
        return RESTEsriUtil.testData(urlString, layerName, fieldName, myData, null);
    }

    public static double[] testData(String urlString, String layerName, String fieldName, Object[] myData, Proxy proxy) {
        Vector<Object> fieldData = RESTEsriUtil.getFieldValues(RESTEsriUtil.normalizeURLString(urlString), layerName, fieldName, -1, proxy);
        return RESTEsriUtil.compare(myData, fieldData);
    }

    public static String chooseField(String urlString, String layerName, Object[] data) {
        return RESTEsriUtil.chooseField(urlString, layerName, data, null, -1, null);
    }

    public static String chooseField(String urlString, String layerName, Object[] data, Proxy proxy) {
        return RESTEsriUtil.chooseField(urlString, layerName, data, null, -1, proxy);
    }

    public static String chooseField(String urlString, String layerName, Object[] data, Vector<String> fieldNames) {
        return RESTEsriUtil.chooseField(urlString, layerName, data, fieldNames, -1, null);
    }

    public static String chooseField(String urlString, String layerName, Object[] data, Vector<String> fieldNames, Proxy proxy) {
        return RESTEsriUtil.chooseField(urlString, layerName, data, fieldNames, -1, proxy);
    }

    public static String chooseField(String urlString, String layerName, Object[] data, Vector<String> fieldNames, int numToCheck) {
        return RESTEsriUtil.chooseField(urlString, layerName, data, fieldNames, numToCheck, null);
    }

    public static String chooseField(String urlString, String layerName, Object[] data, Vector<String> fieldNames, int numToCheck, Proxy proxy) {
        return RESTEsriUtil.chooseField(RESTEsriUtil.normalizeURLString(urlString) + "/" + RESTEsriUtil.getLayerId(urlString, layerName, proxy), data, fieldNames, numToCheck, proxy);
    }

    public static String chooseField(String layerUrl, Object[] data, Vector<String> fieldNames, int numToCheck, Proxy proxy) {
        Vector<String> fields = fieldNames;
        if (fields == null || fields.size() == 0) {
            fields = RESTEsriUtil.getFields(layerUrl, proxy);
        }
        Vector<Vector<Object>> fieldValues = RESTEsriUtil.getFieldValues(layerUrl, fields, numToCheck, proxy);
        double[][] comp = new double[fields.size()][2];
        int highIdx = 0;
        double highPct = -1.0;
        for (int i = 0; i < fieldValues.size(); ++i) {
            comp[i] = RESTEsriUtil.compare(data, fieldValues.get(i));
            if (!(comp[i][0] > highPct)) continue;
            highPct = comp[i][0];
            highIdx = i;
        }
        return fields.get(highIdx);
    }

    public static Image getImage(String urlString, Rectangle2D.Double bounds, int width, int height) throws IOException {
        return RESTEsriUtil.getImage(urlString, bounds, width, height, "jpg", null);
    }

    public static Image getImage(String urlString, Rectangle2D.Double bounds, int width, int height, Proxy proxy) throws IOException {
        return RESTEsriUtil.getImage(urlString, bounds, width, height, "jpg", proxy);
    }

    public static Image getImage(String urlString, Rectangle2D.Double bounds, int width, int height, String imageFormat) throws IOException {
        return RESTEsriUtil.getImage(urlString, bounds, width, height, imageFormat, null);
    }

    public static Image getImage(String urlString, Rectangle2D.Double bounds, int width, int height, String imageFormat, Proxy proxy) throws IOException {
        URL url = new URL(RESTEsriUtil.normalizeURLString(urlString) + "/export?f=image&format=" + imageFormat + "&size=" + width + "," + height + "&bbox=" + bounds.x + "," + bounds.y + "," + (bounds.x + bounds.width) + "," + (bounds.y + bounds.height));
        URLConnection connection = url.openConnection();
        connection.setDoOutput(true);
        connection.setAllowUserInteraction(false);
        BufferedInputStream is = new BufferedInputStream(connection.getInputStream());
        return ImageIO.read(is);
    }

    public static JSONObject getJSONResponse(String urlString, String itemString) throws JSONException {
        return RESTEsriUtil.getJSONResponse(urlString, itemString, null);
    }

    public static JSONObject getJSONResponse(String urlString, String itemString, Proxy proxy) throws JSONException {
        JSONObject item = null;
        try {
            item = new JSONObject(RESTEsriUtil.getResponseFromServer(urlString, proxy)).getJSONObject(itemString);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return item;
    }

    public static JSONObject getJSONResponse(String urlString) throws JSONException {
        return RESTEsriUtil.getJSONResponse(urlString, (Proxy)null);
    }

    public static JSONObject getJSONResponse(String urlString, Proxy proxy) throws JSONException {
        JSONObject item = null;
        try {
            item = new JSONObject(RESTEsriUtil.getResponseFromServer(urlString, proxy));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return item;
    }

    public static JSONArray getJSONResponseArray(String urlString, String itemString) throws JSONException {
        return RESTEsriUtil.getJSONResponseArray(urlString, itemString, null);
    }

    public static JSONArray getJSONResponseArray(String urlString, String itemString, Proxy proxy) throws JSONException {
        JSONArray item = null;
        try {
            item = new JSONObject(RESTEsriUtil.getResponseFromServer(urlString, proxy)).getJSONArray(itemString);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return item;
    }

    private static double[] compare(Object[] userData, Vector<Object> fieldData) {
        double percentAMatches;
        int i;
        double[] retVal = new double[]{-1.0, -1.0};
        if (userData == null || fieldData == null || userData.length == 0 || fieldData.size() == 0) {
            return retVal;
        }
        Object[] a = new Object[userData.length];
        Object[] b = new Object[fieldData.size()];
        if (userData[0] instanceof Number ^ fieldData.get(0) instanceof Number) {
            if (userData[0] instanceof Number) {
                fieldData.copyInto(b);
                for (i = 0; i < userData.length; ++i) {
                    a[i] = userData[i].toString();
                }
            } else {
                System.arraycopy(userData, 0, a, 0, userData.length);
                for (i = 0; i < fieldData.size(); ++i) {
                    b[i] = fieldData.get(i).toString();
                }
            }
        } else {
            fieldData.copyInto(b);
            System.arraycopy(userData, 0, a, 0, userData.length);
        }
        Arrays.sort(a);
        Arrays.sort(b);
        int numBMatches = 0;
        int numAMatches = 0;
        for (i = 0; i < a.length; ++i) {
            if (Arrays.binarySearch(b, a[i]) < 0) continue;
            ++numAMatches;
        }
        for (i = 0; i < b.length; ++i) {
            if (Arrays.binarySearch(a, b[i]) < 0) continue;
            ++numBMatches;
        }
        double percentBMatches = (double)numBMatches / (double)b.length;
        retVal[0] = percentAMatches = (double)numAMatches / (double)a.length;
        retVal[1] = percentBMatches;
        return retVal;
    }

    private static String getResponseFromServer(String urlString, Proxy proxy) throws IOException {
        String str;
        URL url = new URL(urlString);
        URLConnection connection = null;
        connection = proxy == null ? url.openConnection() : url.openConnection(proxy);
        connection.setDoOutput(true);
        connection.setAllowUserInteraction(false);
        BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuffer sb = new StringBuffer();
        while ((str = br.readLine()) != null) {
            sb.append(str);
            sb.append("\n");
        }
        br.close();
        return sb.toString();
    }

    public static boolean connectionExists(String urlString, Proxy proxy) {
        try {
            URL url = new URL(urlString);
            URLConnection connection = proxy == null ? url.openConnection() : url.openConnection(proxy);
            connection.setDoOutput(true);
            connection.setAllowUserInteraction(false);
            connection.setReadTimeout(5000);
            if (connection.getHeaderFields().isEmpty()) {
                return false;
            }
        }
        catch (IOException e) {
            System.out.println(e.getLocalizedMessage());
            return false;
        }
        return true;
    }
}

