/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.render.map;

import com.sas.graphics.util.LinearRing;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.WKBMultiPolygon;
import com.sas.graphics.util.WKBPolygon;
import com.sas.graphics.util.gtk.OLAPLevelVariable;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.render.map.RESTEsriUtil;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RESTEsriMapRegionLayer {
    private static JSONArray getFeaturesForLayer(String geometryServiceUrl, String fieldName, String layerName, StringVariable idVariable, String levelName, String spatialReference, Proxy proxy) throws IOException {
        String q = RESTEsriMapRegionLayer.buildQueryString(fieldName, 0, idVariable, levelName);
        return RESTEsriUtil.getFeaturesForLayer(geometryServiceUrl, layerName, fieldName, q, spatialReference, proxy);
    }

    public static void getMapPolygons(String geometryServiceUrl, String fieldName, String layerName, String levelName, StringVariable sv, ArrayList<WKBMultiPolygon> polygons, Vector<String> ids, HashMap<String, String> idHash, String spatialReference, Proxy proxy) throws IOException {
        JSONArray features = RESTEsriMapRegionLayer.getFeaturesForLayer(geometryServiceUrl, fieldName, layerName, sv, levelName, spatialReference, proxy);
        RESTEsriMapRegionLayer.addPolygons(polygons, ids, fieldName, features, idHash);
    }

    private static void addPolygons(ArrayList<WKBMultiPolygon> polygons, Vector<String> ids, String fieldName, JSONArray featureArray, HashMap<String, String> idHash) throws IOException {
        try {
            int numFeatures = featureArray.length();
            for (int i = 0; i < numFeatures; ++i) {
                WKBMultiPolygon multiPolygon = new WKBMultiPolygon();
                JSONObject feature = featureArray.getJSONObject(i);
                JSONObject attributes = feature.getJSONObject("attributes");
                ids.add(idHash.get(attributes.getString(fieldName)));
                JSONObject geom = feature.getJSONObject("geometry");
                JSONArray rings = geom.getJSONArray("rings");
                int numRings = rings.length();
                multiPolygon.WKBPolygons = new WKBPolygon[numRings];
                multiPolygon.num_wkbPolygons = numRings;
                for (int j = 0; j < numRings; ++j) {
                    multiPolygon.WKBPolygons[j] = new WKBPolygon();
                    multiPolygon.WKBPolygons[j].numRings = 1L;
                    multiPolygon.WKBPolygons[j].rings = new LinearRing[1];
                    multiPolygon.WKBPolygons[j].rings[0] = new LinearRing();
                    JSONArray points = rings.getJSONArray(j);
                    int numPoints = points.length();
                    if (numPoints < 3) break;
                    multiPolygon.WKBPolygons[j].rings[0].numPoints = numPoints;
                    multiPolygon.WKBPolygons[j].rings[0].points = new Vec3d[numPoints];
                    for (int k = 0; k < numPoints; ++k) {
                        JSONArray ja = points.getJSONArray(k);
                        multiPolygon.WKBPolygons[j].rings[0].points[k] = new Vec3d(((Double)ja.get(0)).doubleValue(), ((Double)ja.get(1)).doubleValue(), 0.0);
                    }
                }
                polygons.add(multiPolygon);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static Rectangle2D.Double getBoundsFromWKBPolygons(ArrayList<WKBMultiPolygon> polygons) {
        double xMin = Double.MAX_VALUE;
        double yMin = Double.MAX_VALUE;
        double xMax = -1.7976931348623157E308;
        double yMax = -1.7976931348623157E308;
        int numPolygons = polygons.size();
        for (int i = 0; i < numPolygons; ++i) {
            WKBMultiPolygon mp = polygons.get(i);
            if (mp == null) continue;
            int j = 0;
            while ((long)j < mp.num_wkbPolygons) {
                int k = 0;
                while ((long)k < mp.WKBPolygons[j].numRings) {
                    Vec3d[] points = mp.WKBPolygons[j].rings[k].points;
                    int l = 0;
                    while ((long)l < mp.WKBPolygons[j].rings[k].numPoints) {
                        double x = points[l].x;
                        double y = points[l].y;
                        if (x < xMin) {
                            xMin = x;
                        }
                        if (y < yMin) {
                            yMin = y;
                        }
                        if (x > xMax) {
                            xMax = x;
                        }
                        if (y > yMax) {
                            yMax = y;
                        }
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
        }
        return new Rectangle2D.Double(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    public static String buildQueryString(String fieldName, int fieldType, StringVariable sv, String levelName) {
        int i;
        if (sv == null || sv.getValueCount() == 0) {
            return null;
        }
        int numValues = sv.getValueCount();
        String s = null;
        StringBuffer query = new StringBuffer();
        query.append(fieldName + " in (");
        HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
        for (i = 0; i < numValues; ++i) {
            if (sv instanceof OLAPLevelVariable) {
                String l = ((OLAPLevelVariable)sv).getLevelName(i);
                s = ((OLAPLevelVariable)sv).getLowestLevelLabel(i);
                if (levelName != l) {
                    s = null;
                }
            } else {
                s = (String)Variable.getValue(sv, i, true);
            }
            if (s == null) continue;
            valueMap.put(s, new Integer(1));
        }
        String[] values = valueMap.keySet().toArray(new String[0]);
        for (i = 0; i < values.length; ++i) {
            s = values[i];
            if (s.indexOf("'") != -1) {
                query.append("'" + s.replaceAll("'", "''") + "'");
            } else {
                query.append("'" + s + "'");
            }
            if (i >= values.length - 1) continue;
            query.append(",");
        }
        query.append(")");
        return query.toString();
    }
}

