/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.render.map;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.WKBMultiPolygon;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.BooleanPipe;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.DiscreteRangeToColorMapper;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.StringProperty;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.SpatialFeatureCache;
import com.sas.graphics.util.gtk.gl.SpatialMap;
import com.sas.graphics.util.gtk.render.map.GraphedContinuousRangeToColorMapper;
import com.sas.util.NumericRangeSegment;
import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Vector;

public class MapObject {
    protected SpatialFeatureCache mapCache;
    protected SpatialMap map;
    protected Channel channel;
    protected NetworkRoot root;
    protected StringVariable wkbVariable;
    protected NumericVariable xVariable;
    protected NumericVariable yVariable;
    protected NumericVariable mapIDVariable;
    protected StringVariable mapStringIDVariable;
    protected NumericVariable segmentVariable;
    protected NumericVariable responseIDVariable;
    protected StringVariable responseStringIDVariable;
    protected NumericVariable colorVariable;
    protected StringVariable colorStringVariable;
    protected NumericVariable selectionVariable;
    protected NumericVariable graphedVariable;
    protected NumericVariable useChoroColorVariable;
    protected Color emptyColor = Color.BLACK;
    protected Color emptyEdgeColor = Color.BLACK;
    protected int emptyEdgePattern = 1;
    protected int emptyEdgeThickness = 1;
    protected Color edgeColor = Color.BLACK;
    protected int edgePattern = 1;
    protected int edgeThickness = 1;
    protected Color fillColor = Color.RED;
    protected Color selectionColor = Color.YELLOW;
    protected boolean edgesOn = true;
    protected boolean emptyEdgesOn = true;
    protected boolean missingAsEmpty = true;
    protected Color defaultColor = Color.red;
    protected ColorMapper colorMapper;
    protected Color[] rampColors;
    protected double[] rampValues;
    protected Object[] discreteValues;
    protected Color[] discreteColors;
    protected boolean discrete = false;
    protected boolean categorized = false;
    protected int statistic = 12;
    protected boolean autoProject = false;
    private VariableProcessor vp = null;
    protected boolean holding = false;

    public boolean isAutoProject() {
        return this.autoProject;
    }

    public void setAutoProject(boolean autoProject) {
        this.autoProject = autoProject;
    }

    public boolean isHolding() {
        return this.holding;
    }

    public void setHolding(boolean holding) {
        this.holding = holding;
        if (!holding) {
            this.setupColorMapper();
        }
    }

    public MapObject() {
        this.mapCache = new SpatialFeatureCache();
        this.map = new SpatialMap(this.mapCache);
        this.map.setAllFeaturesVisible(true);
        this.map.selectEnabled.setValue(true);
        this.map.selectDetailEnabled.setValue(true);
        this.map.setEmptyColor(this.emptyColor);
        this.map.setEmptyEdgeColor(this.emptyEdgeColor);
        this.map.setEmptyEdgePattern(this.emptyEdgePattern);
        this.map.setEmptyEdgeThickness(this.emptyEdgeThickness);
        this.map.setEmptyEdgeVisible(this.emptyEdgesOn);
        this.map.edgeColor.setValue(this.edgeColor);
        this.map.edgeOn.setValue(this.edgesOn);
        this.map.highlightColor.setValue(this.selectionColor);
        this.map.setDefaultColor(this.defaultColor);
        this.colorMapper = new GraphedContinuousRangeToColorMapper();
    }

    public void setChannel(Channel ch) {
        if (ch == null) {
            return;
        }
        this.channel = ch;
        this.createNetwork();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public NetworkRoot getNetworkRoot() {
        return this.root;
    }

    protected void createNetwork() {
        this.root = new NetworkRoot(this.channel);
        this.root.addElement(this.map);
    }

    protected void setupColorMapper() {
        if (this.holding) {
            return;
        }
        if (!((this.colorVariable != null && this.colorVariable.isConnected() || this.colorStringVariable != null && this.colorStringVariable.isConnected()) && (this.responseStringIDVariable != null || this.discrete))) {
            if (this.colorMapper != null && this.colorMapper instanceof ContinuousRangeToColorMapper) {
                ((ContinuousRangeToColorMapper)this.colorMapper).input.disconnect();
            } else if (this.colorMapper != null && this.colorMapper instanceof DiscreteRangeToColorMapper) {
                ((DiscreteRangeToColorMapper)this.colorMapper).input.disconnect();
            }
            this.map.color.setValue(this.fillColor);
        } else if (!this.discrete) {
            if (!this.categorized) {
                if (this.responseStringIDVariable == null || !this.responseStringIDVariable.isConnected()) {
                    this.map.color.setValue(this.fillColor);
                } else {
                    this.vp = new VariableProcessor();
                    this.vp.addGroupVariable(this.responseStringIDVariable);
                    this.vp.addVariable(this.colorVariable, this.statistic);
                    this.colorMapper = new GraphedContinuousRangeToColorMapper();
                    ((GraphedContinuousRangeToColorMapper)this.colorMapper).setColorSpectrumColors(this.rampColors);
                    ((GraphedContinuousRangeToColorMapper)this.colorMapper).setColorSpectrumValues(this.rampValues);
                    ((GraphedContinuousRangeToColorMapper)this.colorMapper).setMissingReplacement(this.missingAsEmpty ? this.emptyColor : this.fillColor);
                    ((GraphedContinuousRangeToColorMapper)this.colorMapper).setReplaceMissingValues(true);
                    ((GraphedContinuousRangeToColorMapper)this.colorMapper).input.connectFrom(this.colorVariable.value);
                    this.map.color.connectFrom(this.colorMapper.value);
                }
            } else {
                this.vp = new VariableProcessor();
                this.vp.addGroupVariable(this.responseStringIDVariable);
                this.vp.addVariable(this.colorVariable, this.statistic);
                this.colorMapper = new DiscreteRangeToColorMapper();
                ((DiscreteRangeToColorMapper)this.colorMapper).setRangeSegments(this.createSegments());
                ((DiscreteRangeToColorMapper)this.colorMapper).setMissingReplacement(this.missingAsEmpty ? this.emptyColor : this.fillColor);
                ((DiscreteRangeToColorMapper)this.colorMapper).setReplaceMissingValues(true);
                ((DiscreteRangeToColorMapper)this.colorMapper).input.connectFrom(this.colorVariable.value);
                this.map.color.connectFrom(this.colorMapper.value);
            }
        } else if (this.discrete) {
            this.colorMapper = new StringToColorMapper();
            ((StringToColorMapper)this.colorMapper).removeAll();
            for (int i = 0; i < this.discreteValues.length; ++i) {
                String str = this.discreteValues[i].toString();
                ((StringToColorMapper)this.colorMapper).add(str, this.discreteColors[i % this.discreteColors.length]);
            }
            this.colorMapper.setMissingReplacement(this.missingAsEmpty ? this.emptyColor : this.fillColor);
            this.colorMapper.setReplaceMissingValues(true);
            if (this.colorVariable != null) {
                ((StringToColorMapper)this.colorMapper).input.connectFrom(this.colorVariable.formattedValue);
            } else if (this.colorStringVariable != null) {
                ((StringToColorMapper)this.colorMapper).input.connectFrom(this.colorStringVariable.formattedValue);
            }
            this.map.color.connectFrom(this.colorMapper.value);
        }
        if (this.useChoroColorVariable != null && this.useChoroColorVariable.isConnected()) {
            this.map.useChoroColor.connectFrom(this.useChoroColorVariable.value);
            this.map.setDefaultColor(this.defaultColor);
        }
    }

    private NumericRangeSegment[] createSegments() {
        if (this.rampColors == null || this.rampValues == null || this.rampColors.length < this.rampValues.length - 1) {
            NumericRangeSegment[] tempSegments = new NumericRangeSegment[]{new NumericRangeSegment(this.colorVariable.getMin(), this.colorVariable.getMax(), false, false, (Object)Color.red)};
            return tempSegments;
        }
        NumericRangeSegment[] segments = new NumericRangeSegment[this.rampValues.length - 1];
        boolean minExclude = false;
        boolean maxExclude = true;
        for (int i = 0; i < this.rampValues.length - 1; ++i) {
            if (i == this.rampValues.length - 2) {
                maxExclude = false;
            }
            segments[i] = new NumericRangeSegment(this.rampValues[i], this.rampValues[i + 1], minExclude, maxExclude, (Object)this.rampColors[i]);
        }
        return segments;
    }

    public synchronized void draw() {
        if (this.root == null) {
            return;
        }
        this.channel.glPushAttrib(0);
        this.channel.glDisable(4);
        this.channel.glDisable(3);
        this.map.highlightOn.setValue(false);
        this.map.setOnlyDrawHighlightedRegions(false);
        this.root.draw();
        this.channel.glPopAttrib();
    }

    public synchronized void drawSelections() {
        if (this.root == null) {
            return;
        }
        if (this.selectionVariable != null && this.selectionVariable.isConnected()) {
            this.channel.glPushAttrib(0);
            this.channel.glDisable(4);
            this.channel.glDisable(3);
            this.map.highlightOn.connectFrom(this.selectionVariable.value);
            this.map.setOnlyDrawHighlightedRegions(true);
            this.root.draw();
            this.channel.glPopAttrib();
        }
    }

    public synchronized Vector getSelectResults(Rectangle r) {
        if (this.root == null) {
            return null;
        }
        this.channel.glPushAttrib(0);
        this.channel.glDisable(4);
        this.channel.glDisable(3);
        this.map.highlightOn.setValue(false);
        this.map.setOnlyDrawHighlightedRegions(false);
        Vector obs = this.root.select(r.x, r.y, r.width, r.height, true, true);
        this.channel.glPopAttrib();
        return obs;
    }

    protected void setProjection() {
        if (this.channel != null) {
            BoundingBox bbox = this.mapCache.getBoundingBox();
            this.channel.glOrtho(bbox.getMinimum().x, bbox.getMaximum().x, bbox.getMinimum().y, bbox.getMaximum().y, -1.0, 1.0);
            this.channel.glLoadIdentity();
        }
    }

    private void connectVar(StringVariable var, StringProperty prop) {
        if (prop == null) {
            return;
        }
        if (var == null || !var.isConnected()) {
            prop.disconnect();
        } else {
            prop.connectFrom(var.value);
        }
    }

    private void connectVar(NumericVariable var, NumericProperty prop) {
        if (prop == null) {
            return;
        }
        if (var == null || !var.isConnected()) {
            prop.disconnect();
        } else {
            prop.connectFrom(var.value);
        }
    }

    public NumericVariable getColorVariable() {
        return this.colorVariable;
    }

    public void setColorVariable(NumericVariable colorVariable) {
        this.colorVariable = colorVariable;
        this.colorStringVariable = null;
        this.setupColorMapper();
    }

    public NumericVariable getUseChoroColorVariable() {
        return this.useChoroColorVariable;
    }

    public void setUseChoroColorVariable(NumericVariable colorVariable) {
        this.useChoroColorVariable = colorVariable;
        this.setupColorMapper();
    }

    public StringVariable getColorStringVariable() {
        return this.colorStringVariable;
    }

    public void setColorStringVariable(StringVariable colorStringVariable) {
        this.colorStringVariable = colorStringVariable;
        this.colorVariable = null;
        this.setupColorMapper();
    }

    public NumericVariable getMapIDVariable() {
        return this.mapIDVariable;
    }

    public void setMapIDVariable(NumericVariable mapIDVariable) {
        this.mapIDVariable = mapIDVariable;
        this.connectVar(mapIDVariable, this.mapCache.id);
        if (mapIDVariable != null && this.xVariable != null && this.yVariable != null && this.channel != null) {
            this.mapCache.setAutoProject(this.autoProject);
            this.mapCache.cacheFeatures(this.channel);
        }
    }

    public NumericVariable getResponseIDVariable() {
        return this.responseIDVariable;
    }

    public void setResponseIDVariable(NumericVariable responseIDVariable) {
        this.responseIDVariable = responseIDVariable;
        this.connectVar(responseIDVariable, this.map.id);
    }

    public NumericVariable getSelectionVariable() {
        return this.selectionVariable;
    }

    public void setSelectionVariable(NumericVariable selectionVariable) {
        this.selectionVariable = selectionVariable;
    }

    public StringVariable getWkbVariable() {
        return this.wkbVariable;
    }

    public void setWkbVariable(StringVariable wkbVariable) {
        if (this.wkbVariable == wkbVariable) {
            return;
        }
        this.wkbVariable = wkbVariable;
        this.connectVar(wkbVariable, this.mapCache.wkb);
        this.mapCache.setAutoProject(this.autoProject);
        this.mapCache.cacheFeatures(this.channel);
    }

    public void projectPolygonData() {
    }

    public BoundingBox getBoundingBox() {
        return this.mapCache.getBoundingBox();
    }

    public void reCache() {
        this.mapCache.setAutoProject(this.autoProject);
        this.mapCache.cacheFeatures(this.channel);
    }

    public NumericVariable getXVariable() {
        return this.xVariable;
    }

    public void setXVariable(NumericVariable variable) {
        this.xVariable = variable;
        this.connectVar(this.xVariable, this.mapCache.x);
        if ((this.mapIDVariable != null || this.mapStringIDVariable != null) && this.xVariable != null && this.yVariable != null && this.channel != null) {
            this.mapCache.setAutoProject(this.autoProject);
            this.mapCache.cacheFeatures(this.channel);
        }
    }

    public void setMultiPolygons(ArrayList<WKBMultiPolygon> newPolygons) {
        this.mapCache.setMultiPolygons(newPolygons);
    }

    public NumericVariable getYVariable() {
        return this.yVariable;
    }

    public void setYVariable(NumericVariable variable) {
        this.yVariable = variable;
        this.connectVar(this.yVariable, this.mapCache.y);
        if ((this.mapIDVariable != null || this.mapStringIDVariable != null) && this.xVariable != null && this.yVariable != null && this.channel != null) {
            this.mapCache.setAutoProject(this.autoProject);
            this.mapCache.cacheFeatures(this.channel);
        }
    }

    public NumericVariable getSegmentVariable() {
        return this.segmentVariable;
    }

    public void setSegmentVariable(NumericVariable segmentVariable) {
        this.segmentVariable = segmentVariable;
        this.connectVar(segmentVariable, this.mapCache.segment);
        if ((this.mapIDVariable != null || this.mapStringIDVariable != null) && this.xVariable != null && this.yVariable != null && this.channel != null) {
            this.mapCache.setAutoProject(this.autoProject);
            this.mapCache.cacheFeatures(this.channel);
        }
    }

    public StringVariable getMapStringIDVariable() {
        return this.mapStringIDVariable;
    }

    public void setMapStringIDVariable(StringVariable mapStringIDVariable) {
        this.mapStringIDVariable = mapStringIDVariable;
        this.connectVar(mapStringIDVariable, this.mapCache.stringID);
        if (mapStringIDVariable != null && this.xVariable != null && this.yVariable != null && this.channel != null) {
            this.mapCache.setAutoProject(this.autoProject);
            this.mapCache.cacheFeatures(this.channel);
        }
    }

    public StringVariable getResponseStringIDVariable() {
        return this.responseStringIDVariable;
    }

    public void setResponseStringIDVariable(StringVariable responseStringIDVariable) {
        this.responseStringIDVariable = responseStringIDVariable;
        this.connectVar(responseStringIDVariable, this.map.stringID);
    }

    public int getStatistic() {
        return this.statistic;
    }

    public void setStatistic(int stat) {
        this.statistic = stat;
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public void setEdgeColor(Color edgeColor) {
        this.edgeColor = edgeColor;
        this.map.edgeColor.setValue(edgeColor);
    }

    public int getEdgePattern() {
        return this.edgePattern;
    }

    public void setEdgePattern(int pattern) {
        this.edgePattern = pattern;
        this.map.edgePattern.setValue(pattern);
    }

    public int getEdgeThickness() {
        return this.edgeThickness;
    }

    public void setEdgeThickness(int thickness) {
        this.edgeThickness = thickness;
        this.map.edgeThickness.setValue(thickness);
    }

    public boolean isEdgesOn() {
        return this.edgesOn;
    }

    public void setEdgesOn(boolean edgesOn) {
        this.edgesOn = edgesOn;
        this.map.edgeOn.setValue(edgesOn);
    }

    public Color getEmptyColor() {
        return this.emptyColor;
    }

    public void setEmptyColor(Color emptyColor) {
        this.emptyColor = emptyColor;
        this.map.setEmptyColor(emptyColor);
    }

    public boolean isEmptyEdgesOn() {
        return this.emptyEdgesOn;
    }

    public void setEmptyEdgesOn(boolean edgesOn) {
        this.emptyEdgesOn = edgesOn;
        this.map.setEmptyEdgeVisible(edgesOn);
    }

    public Color getEmptyEdgeColor() {
        return this.emptyEdgeColor;
    }

    public void setEmptyEdgeColor(Color emptyEdgeColor) {
        this.emptyEdgeColor = emptyEdgeColor;
        this.map.setEmptyEdgeColor(emptyEdgeColor);
    }

    public int getEmptyEdgePattern() {
        return this.emptyEdgePattern;
    }

    public void setEmptyEdgePattern(int pattern) {
        this.emptyEdgePattern = pattern;
        this.map.setEmptyEdgePattern(pattern);
    }

    public int getEmptyEdgeThickness() {
        return this.emptyEdgeThickness;
    }

    public void setEmptyEdgeThickness(int thickness) {
        this.emptyEdgeThickness = thickness;
        this.map.setEmptyEdgeThickness(thickness);
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
        this.setupColorMapper();
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color selectionColor) {
        this.selectionColor = selectionColor;
        this.map.highlightColor.setValue(selectionColor);
    }

    public Color[] getRampColors() {
        return this.rampColors;
    }

    public void setRampColors(Color[] rampColors) {
        this.rampColors = rampColors;
        this.setupColorMapper();
    }

    public double[] getRampValues() {
        return this.rampValues;
    }

    public void setRampValues(double[] rampValues) {
        this.rampValues = rampValues;
        this.setupColorMapper();
    }

    public NumericVariable getGraphedVariable() {
        return this.graphedVariable;
    }

    public void setGraphedVariable(NumericVariable graphedVariable) {
        this.graphedVariable = graphedVariable;
        if (this.colorMapper instanceof GraphedContinuousRangeToColorMapper) {
            ((GraphedContinuousRangeToColorMapper)this.colorMapper).graphed.disconnect();
        }
    }

    public double getCroppedTransparency() {
        if (this.colorMapper instanceof GraphedContinuousRangeToColorMapper) {
            return ((GraphedContinuousRangeToColorMapper)this.colorMapper).getCroppedTransparency();
        }
        return 0.5;
    }

    public void setCroppedTransparency(double transparency) {
        if (this.colorMapper instanceof GraphedContinuousRangeToColorMapper) {
            ((GraphedContinuousRangeToColorMapper)this.colorMapper).setCroppedTransparency(transparency);
        }
    }

    public void setDiscrete(boolean val) {
        this.discrete = val;
    }

    public void setDiscreteValues(Object[] values) {
        this.discreteValues = values;
        this.setupColorMapper();
    }

    public void setDiscreteColors(Color[] colors) {
        this.discreteColors = colors;
        this.setupColorMapper();
    }

    public void setMissingAsEmpty(boolean missingAsEmpty) {
        this.missingAsEmpty = missingAsEmpty;
        this.map.missingAsEmpty.setValue(missingAsEmpty);
    }

    public boolean getMissingAsEmpty() {
        return this.missingAsEmpty;
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public void setDefaultColor(Color defaultColor) {
        this.defaultColor = defaultColor;
    }

    public boolean isCategorized() {
        return this.categorized;
    }

    public void setCategorized(boolean categorized) {
        this.categorized = categorized;
    }

    public VariableProcessor getVariableProcessor() {
        return this.vp;
    }

    public void addConditionalHighlighting(BooleanPipe pipe, Image image) {
        this.map.addConditionalHighlighting(pipe, image);
    }

    public void setAllFeaturesVisible(boolean vis) {
        this.map.setAllFeaturesVisible(vis);
    }

    public boolean isAllFeaturesVisible() {
        return this.map.getAllFeaturesVisible();
    }

    public void setUserData(Object o) {
        this.map.setUserData(o);
    }
}

