/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.render.map;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.MissingValueException;
import java.awt.Color;

public class GraphedContinuousRangeToColorMapper
extends ContinuousRangeToColorMapper {
    private ContinuousRangeToColorMapper graphedColorMapper = null;
    private ContinuousRangeToColorMapper nonGraphedColorMapper = null;
    private double croppedTransparency = 0.5;
    public final BooleanProperty graphed = new BooleanProperty(this, false);

    public GraphedContinuousRangeToColorMapper() {
        this.graphedColorMapper = new ContinuousRangeToColorMapper();
        this.nonGraphedColorMapper = new ContinuousRangeToColorMapper();
    }

    @Override
    protected void setModified() {
        super.setModified();
        this.graphedColorMapper.input.disconnect();
        this.nonGraphedColorMapper.input.disconnect();
        this.graphedColorMapper.input.connectFrom(this.input);
        this.nonGraphedColorMapper.input.connectFrom(this.input);
        this.graphedColorMapper.init(new AInitAction());
        this.nonGraphedColorMapper.init(new AInitAction());
    }

    @Override
    public void setColorSpectrumColors(Color[] colors) {
        super.setColorSpectrumColors(colors);
        this.graphedColorMapper.setColorSpectrumColors(colors);
        this.initNonGraphedColorMapper(colors);
    }

    private void initNonGraphedColorMapper(Color[] colors) {
        Color[] alphaColors = new Color[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            alphaColors[i] = new Color(colors[i].getRed(), colors[i].getGreen(), colors[i].getBlue(), (int)((1.0 - this.croppedTransparency) * 255.0));
        }
        this.nonGraphedColorMapper.setColorSpectrumColors(alphaColors);
    }

    @Override
    public void setColorSpectrumValues(double[] values) {
        super.setColorSpectrumValues(values);
        this.graphedColorMapper.setColorSpectrumValues(values);
        this.nonGraphedColorMapper.setColorSpectrumValues(values);
    }

    @Override
    public void setMissingReplacement(Color c) {
        super.setMissingReplacement(c);
        this.graphedColorMapper.setMissingReplacement(c);
        this.nonGraphedColorMapper.setMissingReplacement(c);
    }

    @Override
    public void setReplaceMissingValues(boolean b) {
        super.setReplaceMissingValues(b);
        this.graphedColorMapper.setReplaceMissingValues(b);
        this.nonGraphedColorMapper.setReplaceMissingValues(b);
    }

    public double getCroppedTransparency() {
        return this.croppedTransparency;
    }

    public void setCroppedTransparency(double transparency) {
        this.croppedTransparency = transparency;
        Color[] colors = null;
        try {
            colors = this.graphedColorMapper.getColorSpectrumColors();
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        if (colors != null) {
            this.initNonGraphedColorMapper(colors);
        }
    }

    @Override
    public Color getValue(int index) throws MissingValueException {
        Color c = null;
        c = this.graphed.isConnected() && !this.graphed.getValue(index) ? this.nonGraphedColorMapper.getValue(index) : this.graphedColorMapper.getValue(index);
        return c;
    }
}

