/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.render.map;

import com.sas.graphics.util.LinearRing;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.WKBMultiPolygon;
import com.sas.graphics.util.WKBPolygon;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GMLParser
extends DefaultHandler {
    StringBuffer textBuffer = new StringBuffer();
    ArrayList<WKBMultiPolygon> mpList = null;
    Vector<String> ids = null;
    WKBMultiPolygon multiPolygon;
    WKBPolygon polygon;
    LinearRing linearRing;
    ArrayList<WKBPolygon> tempPolygonList = new ArrayList(0);
    ArrayList<LinearRing> tempLinearRingList = new ArrayList(0);
    String id;

    public ArrayList<WKBMultiPolygon> getMultiPolygons() {
        return this.mpList;
    }

    public void parseGML(String s, ArrayList<WKBMultiPolygon> mp, Vector<String> ids) {
        this.mpList = mp;
        this.ids = ids;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes("UTF-8"));
            saxParser.parse((InputStream)is, (DefaultHandler)this);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        this.textBuffer.setLength(0);
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                String aName = attrs.getLocalName(i);
                if (!"".equals(aName)) continue;
                aName = attrs.getQName(i);
            }
        }
        if (qName.equals("gml:MultiPolygon")) {
            this.multiPolygon = new WKBMultiPolygon();
        } else if (qName.equals("gml:Polygon")) {
            this.polygon = new WKBPolygon();
        } else if (qName.equals("gml:LinearRing")) {
            this.linearRing = new LinearRing();
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        if (eName.equals("gml:MultiPolygon")) {
            this.multiPolygon.num_wkbPolygons = this.tempPolygonList.size();
            this.multiPolygon.WKBPolygons = new WKBPolygon[(int)this.multiPolygon.num_wkbPolygons];
            for (int i = 0; i < this.tempPolygonList.size(); ++i) {
                this.multiPolygon.WKBPolygons[i] = this.tempPolygonList.get(i);
            }
            this.tempPolygonList.clear();
            this.mpList.add(this.multiPolygon);
        } else if (eName.equals("gml:Polygon")) {
            this.polygon.numRings = this.tempLinearRingList.size();
            this.polygon.rings = new LinearRing[(int)this.polygon.numRings];
            for (int i = 0; i < this.tempLinearRingList.size(); ++i) {
                this.polygon.rings[i] = this.tempLinearRingList.get(i);
            }
            this.tempPolygonList.add(this.polygon);
            this.tempLinearRingList.clear();
        } else if (!eName.equals("gml:LinearRing")) {
            if (eName.equals("topp:ID")) {
                this.id = this.textBuffer.toString();
                this.ids.add(this.id);
            } else if (eName.equals("gml:coordinates")) {
                String coordString = this.textBuffer.toString();
                coordString = coordString.trim();
                String[] coordPairs = coordString.split("  ");
                Vec3d[] p = new Vec3d[coordPairs.length];
                for (int i = 0; i < coordPairs.length; ++i) {
                    String[] coords = coordPairs[i].split(",");
                    double x = Double.valueOf(coords[0]);
                    double y = Double.valueOf(coords[1]);
                    x = x * 2.003750834E7 / 180.0;
                    y = Math.log(Math.tan((90.0 + y) * Math.PI / 360.0)) / (Math.PI / 180);
                    y = y * 2.003750834E7 / 180.0;
                    p[i] = new Vec3d(x, y, 0.0);
                }
                this.linearRing.numPoints = p.length;
                this.linearRing.points = p;
                this.tempLinearRingList.add(this.linearRing);
            }
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        this.textBuffer.append(buf, offset, len);
    }
}

