/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.render.kpi;

import com.sas.graphics.util.gtk.Util;
import com.sas.graphics.util.gtk.render.kpi.BoundaryValue;
import java.awt.Color;
import java.util.List;

public class KPIChartSegmentedRangeColorModel {
    private boolean boundaryInHigherSegment = true;
    private double[] segmentedRange;
    private Color[] segmentColors;
    private Color[] activeSegmentColors;
    private Color[] mappedSegmentColors;
    private Color[] mappedActiveSegmentColors;
    private Color underflowColor;
    private Color overflowColor;
    private List<BoundaryValue> bvSegmentedRange;

    public KPIChartSegmentedRangeColorModel(List<BoundaryValue> boundaryValues, Color[] segmentColors, Color[] activeSegmentColors, Color underFlowColor, Color overFlowColor) {
        this.bvSegmentedRange = boundaryValues;
        this.init(this.boundaryInHigherSegment, segmentColors, activeSegmentColors, underFlowColor, overFlowColor);
    }

    public KPIChartSegmentedRangeColorModel(double[] range, boolean boundaryInHigherSegment, Color[] segmentColors, Color[] activeSegmentColors, Color underFlowColor, Color overFlowColor) {
        this.segmentedRange = Util.copyOf(range);
        this.init(boundaryInHigherSegment, segmentColors, activeSegmentColors, underFlowColor, overFlowColor);
    }

    public KPIChartSegmentedRangeColorModel(double[] range, boolean boundaryInHigherSegment, Color[] segmentColors, Color[] activeSegmentColors) {
        this(range, boundaryInHigherSegment, segmentColors, activeSegmentColors, null, null);
    }

    private void init(boolean boundaryInHigherSegment, Color[] segmentColors, Color[] activeSegmentColors, Color underFlowColor, Color overFlowColor) {
        int numColors;
        this.boundaryInHigherSegment = boundaryInHigherSegment;
        this.underflowColor = underFlowColor;
        this.overflowColor = overFlowColor;
        int n = numColors = this.isBoundaryValue() ? this.bvSegmentedRange.size() - 1 : this.segmentedRange.length - 1;
        if (segmentColors == null) {
            Color neutralColor = new Color(178, 178, 178);
            Color redColor = new Color(208, 105, 89);
            Color orangeColor = new Color(225, 160, 93);
            Color yellowColor = new Color(241, 220, 99);
            Color yellowGreenColor = new Color(189, 205, 95);
            Color greenColor = new Color(132, 175, 91);
            segmentColors = new Color[numColors];
            switch (numColors) {
                case 1: {
                    segmentColors = new Color[]{redColor};
                    break;
                }
                case 2: {
                    segmentColors = new Color[]{redColor, greenColor};
                    break;
                }
                case 3: {
                    segmentColors = new Color[]{redColor, yellowColor, greenColor};
                    break;
                }
                case 4: {
                    segmentColors = new Color[]{redColor, orangeColor, yellowGreenColor, greenColor};
                    break;
                }
                case 5: {
                    segmentColors = new Color[]{redColor, orangeColor, yellowColor, yellowGreenColor, greenColor};
                    break;
                }
                default: {
                    for (int i = 0; i < numColors; ++i) {
                        segmentColors[i] = neutralColor;
                    }
                }
            }
        }
        this.segmentColors = Util.copyOf(segmentColors);
        this.activeSegmentColors = Util.copyOf(activeSegmentColors);
        this.mappedSegmentColors = Util.getColorList(segmentColors, numColors);
        this.mappedActiveSegmentColors = Util.getColorList(activeSegmentColors, numColors);
    }

    public double[] getSegmentedRange() {
        return this.isBoundaryValue() ? Util.convertBoundaryValuesToArray(this.bvSegmentedRange) : Util.copyOf(this.segmentedRange);
    }

    public List<BoundaryValue> getBoundaryValues() {
        return this.bvSegmentedRange;
    }

    public void setSegmentedRange(double[] range) {
        this.segmentedRange = range;
    }

    public void setBoundaryValues(List<BoundaryValue> range) {
        this.bvSegmentedRange = range;
    }

    public boolean isBoundaryInHigherSegment() {
        return this.boundaryInHigherSegment;
    }

    public void setBoundaryInHigherSegment(boolean value) {
        this.boundaryInHigherSegment = value;
    }

    public Color[] getSegmentColors() {
        return Util.copyOf(this.segmentColors);
    }

    public void setSegmentColors(Color[] colors) {
        this.segmentColors = colors;
    }

    public Color[] getActiveSegmentColors() {
        return Util.copyOf(this.activeSegmentColors);
    }

    public void setActiveSegmentColors(Color[] colors) {
        this.activeSegmentColors = colors;
    }

    public void apply(KPIChartSegmentedRangeColorModel otherObj) {
        this.bvSegmentedRange = otherObj.getBoundaryValues();
        this.segmentedRange = otherObj.isBoundaryValue() ? null : otherObj.getSegmentedRange();
        this.boundaryInHigherSegment = otherObj.isBoundaryInHigherSegment();
        this.activeSegmentColors = otherObj.getActiveSegmentColors();
        this.segmentColors = otherObj.getSegmentColors();
        this.underflowColor = otherObj.getUnderflowColor();
        this.overflowColor = otherObj.getOverflowColor();
        this.mappedSegmentColors = otherObj.mappedSegmentColors;
        this.mappedActiveSegmentColors = otherObj.mappedActiveSegmentColors;
    }

    public Color getUnderflowColor() {
        return this.underflowColor;
    }

    public void setUnderflowColor(Color underFlowColor) {
        this.underflowColor = underFlowColor;
    }

    public Color getOverflowColor() {
        return this.overflowColor;
    }

    public void setOverflowColor(Color overFlowColor) {
        this.overflowColor = overFlowColor;
    }

    public boolean isBoundaryValue() {
        return this.bvSegmentedRange != null;
    }

    public Color[] getMappedSegmentColors() {
        return this.mappedSegmentColors;
    }

    public Color[] getMappedActiveSegmentColors() {
        return this.mappedActiveSegmentColors;
    }
}

