/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.render.kpi;

import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.RB;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.Util;
import com.sas.graphics.util.gtk.render.RendererUtil;
import com.sas.graphics.util.gtk.render.kpi.BulletSkinModel;
import com.sas.graphics.util.gtk.render.kpi.DialSkinModel;
import com.sas.graphics.util.gtk.render.kpi.KPIChartCache;
import com.sas.graphics.util.gtk.render.kpi.KPIChartCustomSkinModel;
import com.sas.graphics.util.gtk.render.kpi.KPIChartRendererModel;
import com.sas.graphics.util.gtk.render.kpi.KPIChartSegmentedRangeColorModel;
import com.sas.graphics.util.gtk.render.kpi.SliderSkinModel;
import com.sas.graphics.util.gtk.render.kpi.SpeedometerFullSkinModel;
import com.sas.graphics.util.gtk.render.kpi.SpeedometerHalfSkinModel;
import com.sas.graphics.util.gtk.render.kpi.SpeedometerQuarterSkinModel;
import com.sas.graphics.util.gtk.resources.GraphResources;
import com.sas.text.Message;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.FilteredImageSource;
import java.awt.image.Kernel;
import java.awt.image.RGBImageFilter;
import java.text.DecimalFormat;
import java.text.Format;
import javax.swing.ImageIcon;

public class KPIChartRenderer {
    boolean showRangeLabels;
    boolean showValueLabel;
    boolean showMiddleRangeLabels;
    boolean displayGraph = true;
    double factor = 1.0;
    double ratio = 1.0;
    boolean show3DElements = true;
    boolean showBorder = true;
    int rangeLabelHeight;
    double[] rangeLabelWidths;
    boolean adjustMagnitude = false;
    private Rectangle[] dialRangeLabelBounds;
    float[] shadowElements;
    int orientation;
    Font tempRangeLabelFont;
    KPIChartRendererModel kpiRendererModel;
    KPIChartCache imageCache;
    String[] formattedSegmentValues;
    Rectangle bounds;
    boolean isUseFullSpace = false;
    double dpiScale = 1.0;
    private KPIChartSkinPolicy valueTextColorPolicy = KPIChartSkinPolicy.AUTO;
    private KPIChartSkinPolicy rangeTextColorPolicy = KPIChartSkinPolicy.AUTO;
    private boolean isUseAltValueColor = false;
    private boolean isUseAltRangeColor = false;
    private boolean isBIP = true;

    public KPIChartRenderer() {
        this.kpiRendererModel = new KPIChartRendererModel();
        this.shadowElements = KPIChartRenderer.getShadowKernel(4);
    }

    public KPIChartRenderer(boolean isBIP) {
        this();
        this.isBIP = isBIP;
    }

    public KPIChartRendererModel getRendererModel() {
        return this.kpiRendererModel;
    }

    protected void applyRenderingHints(Graphics2D g) {
        RenderingHints hints = new RenderingHints(null);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHints(hints);
    }

    public void setBounds(Rectangle newBounds) {
        this.bounds = newBounds;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void renderKPI(Graphics2D g, Rectangle componentBounds) {
        Rectangle bounds = new Rectangle();
        bounds.x = componentBounds.x;
        bounds.y = componentBounds.y;
        bounds.width = componentBounds.width;
        bounds.height = componentBounds.height;
        this.setBounds(bounds);
        this.isUseFullSpace = this.kpiRendererModel.getDataDPIScaleFactor() != 1.0 || this.kpiRendererModel.getDataSizeScaleFactor() != 1.0;
        this.dpiScale = this.kpiRendererModel.getDataDPIScaleFactor();
        RenderingHints oldHints = g.getRenderingHints();
        this.applyRenderingHints(g);
        Stroke oldStroke = g.getStroke();
        g.setStroke(this.getDefaultScaledThicknessStroke(g.getStroke()));
        this.showRangeLabels = this.kpiRendererModel.isRangeValueVisiblityEnabled();
        this.showValueLabel = this.kpiRendererModel.isActualValueVisiblityEnabled();
        this.showMiddleRangeLabels = this.showRangeLabels;
        this.displayGraph = true;
        this.orientation = this.kpiRendererModel.getOrientation();
        RendererUtil.KPIChartType kpiType = this.kpiRendererModel.getKPIChartType();
        if (!this.isBIP) {
            this.initTextColorPolicy(kpiType);
        }
        double[] segmentVals = this.getSegmentValues();
        if (kpiType == RendererUtil.KPIChartType.SPEEDOMETER_FULL) {
            segmentVals = this.calculateSpeedometerTickValues(segmentVals, 10);
        } else if (kpiType == RendererUtil.KPIChartType.SPEEDOMETER_HALF) {
            segmentVals = this.calculateSpeedometerTickValues(segmentVals, 5);
        } else if (kpiType == RendererUtil.KPIChartType.SPEEDOMETER_QUARTER) {
            segmentVals = this.calculateSpeedometerTickValues(segmentVals, 3);
        }
        double[] magnitudeVals = segmentVals;
        this.adjustMagnitude = this.kpiRendererModel.isAdjustMagnitudeValueEnabled();
        this.factor = Double.NaN;
        if (this.adjustMagnitude) {
            for (int i = 0; i < magnitudeVals.length; ++i) {
                if (magnitudeVals[i] == 0.0) continue;
                double tempFactor = Util.findFactor(Math.abs(magnitudeVals[i]));
                if (Double.isNaN(tempFactor)) {
                    tempFactor = 1.0;
                }
                this.factor = Double.isNaN(this.factor) ? tempFactor : Math.min(this.factor, tempFactor);
            }
            if (Double.isNaN(this.factor)) {
                this.factor = 1.0;
            }
        } else {
            this.factor = 1.0;
        }
        if (this.factor != 1.0) {
            for (int i = 0; i < magnitudeVals.length; ++i) {
                magnitudeVals[i] = magnitudeVals[i] / this.factor;
            }
        }
        this.formattedSegmentValues = this.getFormattedSegmentValues(magnitudeVals);
        this.setupImageCache();
        try {
            if (kpiType == RendererUtil.KPIChartType.BULLET) {
                this.paintBulletGraphKPIChart(g, componentBounds);
            } else if (kpiType == RendererUtil.KPIChartType.DIAL) {
                this.paintDialKPIChart(g, componentBounds);
            } else if (kpiType == RendererUtil.KPIChartType.SPEEDOMETER_FULL || kpiType == RendererUtil.KPIChartType.SPEEDOMETER_HALF || kpiType == RendererUtil.KPIChartType.SPEEDOMETER_QUARTER) {
                this.paintSpeedometerKPIChart(g, componentBounds);
            } else if (kpiType == RendererUtil.KPIChartType.TRAFFIC_LIGHT) {
                this.paintTrafficLightKPIChart(g, componentBounds);
            } else if (kpiType == RendererUtil.KPIChartType.SLIDER) {
                this.paintBulletGraphKPIChart(g, componentBounds);
            }
            g.setRenderingHints(oldHints);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        g.setRenderingHints(oldHints);
        g.setStroke(oldStroke);
    }

    protected void paintSpeedometerKPIChart(Graphics2D gc, Rectangle componentBounds) {
        this.displayGraph = true;
        RendererUtil.KPIChartType kpiType = this.kpiRendererModel.getKPIChartType();
        RendererUtil.Skin skin = this.kpiRendererModel.getSkin();
        if (skin == RendererUtil.Skin.MODERN) {
            this.paintSkinnableSpeedometer(gc, componentBounds, kpiType);
            return;
        }
        if (skin == RendererUtil.Skin.CUSTOM) {
            if (this.kpiRendererModel.getCustomSkinModel() != null) {
                this.paintSkinnableSpeedometer(gc, componentBounds, kpiType);
                return;
            }
            skin = RendererUtil.Skin.NONE;
        }
        ImageIcon borderIcon = null;
        ImageIcon backplateIcon = null;
        ImageIcon glassIcon = null;
        ImageIcon needleIcon = null;
        ImageIcon targetIcon = null;
        ImageIcon knobIcon = null;
        ImageIcon valueAreaIcon = null;
        ImageIcon backplateIcon2 = null;
        NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
        actualVariable.init();
        this.tempRangeLabelFont = this.kpiRendererModel.getRangeValueTextStyle().getFont();
        this.show3DElements = skin == RendererUtil.Skin.SATIN;
        this.showBorder = true;
        this.displayGraph = true;
        Rectangle drawSpace = new Rectangle(componentBounds.getBounds());
        double idealWidth = 0.0;
        double idealHeight = 0.0;
        double skinImageWidth = 203.0;
        double lowerBorderEdge = 203.0;
        if (kpiType == RendererUtil.KPIChartType.SPEEDOMETER_FULL) {
            idealWidth = 203.0;
            idealHeight = 203.0;
            this.valueTextColorPolicy = KPIChartSkinPolicy.DARK;
            this.rangeTextColorPolicy = KPIChartSkinPolicy.DARK;
            if (drawSpace.width < 79) {
                this.displayGraph = false;
            }
            if (drawSpace.height < 79) {
                this.displayGraph = false;
            }
        } else if (kpiType == RendererUtil.KPIChartType.SPEEDOMETER_HALF) {
            idealHeight = 134.0;
            idealWidth = 203.0;
            lowerBorderEdge = 129.0;
            this.valueTextColorPolicy = KPIChartSkinPolicy.AUTO;
            this.rangeTextColorPolicy = KPIChartSkinPolicy.DARK;
            if (drawSpace.width < 79) {
                this.displayGraph = false;
            }
            if (drawSpace.height < 53) {
                this.displayGraph = false;
            }
        } else if (kpiType == RendererUtil.KPIChartType.SPEEDOMETER_QUARTER) {
            idealHeight = 134.0;
            idealWidth = 203.0;
            lowerBorderEdge = 129.0;
            this.valueTextColorPolicy = KPIChartSkinPolicy.AUTO;
            this.rangeTextColorPolicy = KPIChartSkinPolicy.DARK;
            if (drawSpace.width < 79) {
                this.displayGraph = false;
            }
            if (drawSpace.height < 53) {
                this.displayGraph = false;
            }
        }
        if (drawSpace.width < 28) {
            this.displayGraph = false;
        }
        if (drawSpace.height < 28) {
            this.displayGraph = false;
        }
        if (!this.displayGraph) {
            return;
        }
        double[] segmentVals = this.getSegmentValues();
        this.showRangeLabels = this.kpiRendererModel.isRangeValueVisiblityEnabled();
        this.showValueLabel = this.kpiRendererModel.isActualValueVisiblityEnabled();
        this.showMiddleRangeLabels = this.showRangeLabels;
        if (!this.displayGraph) {
            return;
        }
        if (this.show3DElements && kpiType == RendererUtil.KPIChartType.SPEEDOMETER_FULL) {
            borderIcon = GraphResources.getImageIcon("skin/satin/speedometer/BorderFull.png");
            glassIcon = GraphResources.getImageIcon("skin/satin/speedometer/EffectsFull.png");
            if (this.showValueLabel) {
                backplateIcon = GraphResources.getImageIcon("skin/satin/speedometer/MinorTickMaskFullValue.png");
                backplateIcon2 = GraphResources.getImageIcon("skin/satin/speedometer/MajorTickMaskFullValue.png");
            } else {
                backplateIcon = GraphResources.getImageIcon("skin/satin/speedometer/MinorTickMaskFullNoValue.png");
                backplateIcon2 = GraphResources.getImageIcon("skin/satin/speedometer/MajorTickMaskFullNoValue.png");
            }
            needleIcon = GraphResources.getImageIcon("skin/satin/speedometer/Indicator.png");
            targetIcon = GraphResources.getImageIcon("skin/satin/speedometer/Target.png");
            knobIcon = GraphResources.getImageIcon("skin/satin/speedometer/HubFull.png");
            valueAreaIcon = GraphResources.getImageIcon("skin/satin/speedometer/ValueHubFull.png");
        } else if (!this.show3DElements && kpiType == RendererUtil.KPIChartType.SPEEDOMETER_FULL) {
            borderIcon = GraphResources.getImageIcon("skin/none/speedometer/BorderFull.png");
            glassIcon = null;
            if (this.showValueLabel) {
                backplateIcon = GraphResources.getImageIcon("skin/none/speedometer/MinorTickMaskFullValue.png");
                backplateIcon2 = GraphResources.getImageIcon("skin/none/speedometer/MajorTickMaskFullValue.png");
            } else {
                backplateIcon = GraphResources.getImageIcon("skin/none/speedometer/MinorTickMaskFullNoValue.png");
                backplateIcon2 = GraphResources.getImageIcon("skin/none/speedometer/MajorTickMaskFullNoValue.png");
            }
            needleIcon = GraphResources.getImageIcon("skin/none/speedometer/Indicator.png");
            targetIcon = GraphResources.getImageIcon("skin/none/speedometer/Target.png");
            knobIcon = GraphResources.getImageIcon("skin/none/speedometer/HubNotQuarter.png");
            valueAreaIcon = GraphResources.getImageIcon("skin/none/speedometer/ValueHubFull.png");
        } else if (this.show3DElements && kpiType == RendererUtil.KPIChartType.SPEEDOMETER_HALF) {
            borderIcon = GraphResources.getImageIcon("skin/satin/speedometer/BorderHalf.png");
            glassIcon = GraphResources.getImageIcon("skin/satin/speedometer/EffectsHalf.png");
            backplateIcon = GraphResources.getImageIcon("skin/satin/speedometer/MinorTickMaskHalf.png");
            backplateIcon2 = GraphResources.getImageIcon("skin/satin/speedometer/MajorTickMaskHalf.png");
            needleIcon = GraphResources.getImageIcon("skin/satin/speedometer/Indicator.png");
            targetIcon = GraphResources.getImageIcon("skin/satin/speedometer/Target.png");
            knobIcon = GraphResources.getImageIcon("skin/satin/speedometer/HubHalf.png");
            valueAreaIcon = null;
        } else if (!this.show3DElements && kpiType == RendererUtil.KPIChartType.SPEEDOMETER_HALF) {
            borderIcon = GraphResources.getImageIcon("skin/none/speedometer/BorderHalf.png");
            glassIcon = null;
            backplateIcon = GraphResources.getImageIcon("skin/none/speedometer/MinorTickMaskHalf.png");
            backplateIcon2 = GraphResources.getImageIcon("skin/none/speedometer/MajorTickMaskHalf.png");
            needleIcon = GraphResources.getImageIcon("skin/none/speedometer/Indicator.png");
            targetIcon = GraphResources.getImageIcon("skin/none/speedometer/Target.png");
            knobIcon = GraphResources.getImageIcon("skin/none/speedometer/HubNotQuarter.png");
            valueAreaIcon = null;
        } else if (this.show3DElements && kpiType == RendererUtil.KPIChartType.SPEEDOMETER_QUARTER) {
            borderIcon = GraphResources.getImageIcon("skin/satin/speedometer/BorderQuarter.png");
            glassIcon = GraphResources.getImageIcon("skin/satin/speedometer/EffectsQuarter.png");
            backplateIcon = GraphResources.getImageIcon("skin/satin/speedometer/MinorTickMaskQuarter.png");
            backplateIcon2 = GraphResources.getImageIcon("skin/satin/speedometer/MajorTickMaskQuarter.png");
            needleIcon = GraphResources.getImageIcon("skin/satin/speedometer/Indicator.png");
            targetIcon = GraphResources.getImageIcon("skin/satin/speedometer/Target.png");
            knobIcon = GraphResources.getImageIcon("skin/satin/speedometer/HubQuarter.png");
            valueAreaIcon = null;
        } else if (!this.show3DElements && kpiType == RendererUtil.KPIChartType.SPEEDOMETER_QUARTER) {
            borderIcon = GraphResources.getImageIcon("skin/none/speedometer/BorderQuarter.png");
            glassIcon = null;
            backplateIcon = GraphResources.getImageIcon("skin/none/speedometer/MinorTickMaskQuarter.png");
            backplateIcon2 = GraphResources.getImageIcon("skin/none/speedometer/MajorTickMaskQuarter.png");
            needleIcon = GraphResources.getImageIcon("skin/none/speedometer/Indicator.png");
            targetIcon = GraphResources.getImageIcon("skin/none/speedometer/Target.png");
            knobIcon = GraphResources.getImageIcon("skin/none/speedometer/HubQuarter.png");
            valueAreaIcon = null;
        }
        this.showBorder = true;
        int origWidth = drawSpace.width;
        int origHeight = drawSpace.height;
        Insets textInsets = this.calculateSpeedometerLabelInsets(gc, drawSpace);
        drawSpace.height -= textInsets.bottom;
        if (kpiType == RendererUtil.KPIChartType.SPEEDOMETER_FULL) {
            drawSpace.height = drawSpace.width = this.isUseFullSpace ? Math.min(drawSpace.width, drawSpace.height) : (int)Math.round(Math.min(skinImageWidth, (double)Math.min(drawSpace.width, drawSpace.height)));
            drawSpace.x += (int)Math.round((double)(origWidth - drawSpace.width) / 2.0);
            drawSpace.y = (int)Math.round((double)drawSpace.y + ((double)origHeight - (double)drawSpace.width * (idealHeight / idealWidth) - Math.max(0.0, (double)textInsets.bottom - (idealHeight - lowerBorderEdge) * (drawSpace.getWidth() / idealWidth))) / 2.0);
        } else if (kpiType == RendererUtil.KPIChartType.SPEEDOMETER_HALF) {
            drawSpace.height = drawSpace.width = this.isUseFullSpace ? (int)Math.min((double)drawSpace.width, (double)drawSpace.height * (idealWidth / idealHeight)) : (int)Math.round(Math.min(Math.min((double)drawSpace.width, (double)drawSpace.height * (idealWidth / idealHeight)), idealWidth));
            drawSpace.x += (int)Math.round((double)(origWidth - drawSpace.width) / 2.0);
            drawSpace.y = (int)Math.round((double)drawSpace.y + ((double)origHeight - (double)drawSpace.width * (idealHeight / idealWidth) - Math.max(0.0, (double)textInsets.bottom - (idealHeight - lowerBorderEdge) * (drawSpace.getWidth() / idealWidth))) / 2.0);
        } else if (kpiType == RendererUtil.KPIChartType.SPEEDOMETER_QUARTER) {
            drawSpace.height = drawSpace.width = this.isUseFullSpace ? (int)Math.min((double)drawSpace.width, (double)drawSpace.height * (idealWidth / idealHeight)) : (int)Math.round(Math.min(Math.min((double)drawSpace.width, (double)drawSpace.height * (idealWidth / idealHeight)), idealWidth));
            drawSpace.x += (int)Math.round((double)(origWidth - drawSpace.width) / 2.0);
            drawSpace.y = (int)Math.round((double)drawSpace.y + ((double)origHeight - (double)drawSpace.width * (idealHeight / idealWidth) - Math.max(0.0, (double)textInsets.bottom - (idealHeight - lowerBorderEdge) * (drawSpace.getWidth() / idealWidth))) / 2.0);
        }
        this.ratio = drawSpace.getWidth() / idealWidth;
        int numMajorSegments = 0;
        int numMinorMarks = 0;
        double startAngle = 0.0;
        double sweep = 0.0;
        if (kpiType == RendererUtil.KPIChartType.SPEEDOMETER_FULL) {
            numMajorSegments = 10;
            numMinorMarks = 3;
            startAngle = this.showValueLabel ? 225.0 : 253.64;
            sweep = this.showValueLabel ? 270.0 : 327.28;
        } else if (kpiType == RendererUtil.KPIChartType.SPEEDOMETER_HALF) {
            numMajorSegments = 5;
            numMinorMarks = 3;
            startAngle = 180.0;
            sweep = 180.0;
        } else if (kpiType == RendererUtil.KPIChartType.SPEEDOMETER_QUARTER) {
            numMajorSegments = 3;
            numMinorMarks = 2;
            startAngle = 135.0;
            sweep = 90.0;
        }
        double[] majorTickValues = this.calculateSpeedometerTickValues(segmentVals, numMajorSegments);
        this.calculateSpeedometerLabelWidths(gc, majorTickValues);
        Arc2D.Double[] segmentsArea = this.calculateSpeedometerSegmentArea(segmentVals, drawSpace, startAngle, sweep, null);
        boolean tempShowRangeLabels = this.showRangeLabels;
        Arc2D.Double[] majorTicks = this.calculateSpeedometerMajorTicks(majorTickValues, drawSpace, startAngle, sweep);
        if (this.showRangeLabels != tempShowRangeLabels) {
            while (!this.showRangeLabels && this.tempRangeLabelFont.getSize() >= 8) {
                this.showRangeLabels = true;
                this.tempRangeLabelFont = new Font(this.tempRangeLabelFont.getName(), this.tempRangeLabelFont.getStyle(), Math.min(this.tempRangeLabelFont.getSize() - 1, 30));
                this.calculateSpeedometerLabelWidths(gc, majorTickValues);
                majorTicks = this.calculateSpeedometerMajorTicks(majorTickValues, drawSpace, startAngle, sweep);
            }
        }
        this.renderSpeedometerLayer(gc, drawSpace, borderIcon);
        this.renderSpeedometerPie(gc, drawSpace, segmentsArea);
        this.renderSpeedometerMinorTicks(gc, segmentVals, drawSpace, startAngle, sweep, numMajorSegments, numMinorMarks);
        this.renderSpeedometerLayer(gc, drawSpace, backplateIcon);
        this.renderSpeedometerMajorTicks(gc, majorTicks);
        this.renderSpeedometerLayer(gc, drawSpace, backplateIcon2);
        if (this.showRangeLabels) {
            this.renderSpeedometerRangeLabels(gc, majorTickValues, majorTicks);
        }
        if (glassIcon != null) {
            this.renderSpeedometerLayer(gc, drawSpace, glassIcon);
        }
        this.renderSpeedometerIndicator(gc, drawSpace, needleIcon, segmentVals, startAngle, sweep, false);
        this.renderSpeedometerIndicator(gc, drawSpace, targetIcon, segmentVals, startAngle, sweep, true);
        this.renderSpeedometerLayer(gc, drawSpace, knobIcon);
        if (this.showValueLabel) {
            this.renderSpeedometerValueLabel(gc, drawSpace, lowerBorderEdge);
            if (valueAreaIcon != null) {
                this.renderSpeedometerLayer(gc, drawSpace, valueAreaIcon);
            }
        }
    }

    private void paintSkinnableSpeedometer(Graphics2D gc, Rectangle componentBounds, RendererUtil.KPIChartType kpiType) {
        Object skinModel;
        KPIChartCustomSkinModel customModel;
        double[] segmentVals = this.getSegmentValues();
        NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
        if (actualVariable == null) {
            return;
        }
        double rvValue = 0.0;
        actualVariable.init();
        try {
            rvValue = actualVariable.value.getValue(0);
        }
        catch (Exception e) {
            return;
        }
        double targetValue = Double.NaN;
        NumericVariable targetVariable = this.kpiRendererModel.getTargetVariable();
        if (targetVariable != null) {
            targetVariable.init();
            try {
                targetValue = targetVariable.value.getValue(0);
            }
            catch (Exception e) {
                targetValue = Double.NaN;
            }
            this.isTargetOutOfBounds(targetValue, segmentVals);
        }
        Insets textInsets = this.calculateSpeedometerLabelInsets(gc, componentBounds);
        componentBounds.width = componentBounds.width - textInsets.left - textInsets.right;
        componentBounds.height = componentBounds.height - textInsets.top - textInsets.bottom;
        componentBounds.x += textInsets.left;
        componentBounds.y += textInsets.top;
        ImageIcon colorBandMaskIcon = null;
        ImageIcon majorTickmarkIcon = null;
        ImageIcon minorTickmarkIcon = null;
        ImageIcon borderIcon = null;
        ImageIcon tintedIndicatorHubIcon = null;
        ImageIcon tintedIndicatorHubEffectsIcon = null;
        ImageIcon indicatorShadowIcon = null;
        ImageIcon indicatorIcon = null;
        ImageIcon targetIndicatorShadowIcon = null;
        ImageIcon targetIndicatorIcon = null;
        ImageIcon valueHubIcon = null;
        ImageIcon valueHubPlacementIcon = null;
        double startAngle = 0.0;
        double sweep = 0.0;
        int numMajorTicks = 0;
        int numMinorTicksPerSegment = 0;
        Rectangle colorBandSize = new Rectangle();
        Rectangle2D.Double ellipseBounds = new Rectangle2D.Double();
        Rectangle borderSize = new Rectangle();
        Rectangle2D.Double tickmarkEllipseBounds = new Rectangle2D.Double();
        KPIChartCustomSkinModel kPIChartCustomSkinModel = customModel = this.kpiRendererModel.getSkin() == RendererUtil.Skin.CUSTOM ? this.kpiRendererModel.getCustomSkinModel() : null;
        if (kpiType == RendererUtil.KPIChartType.SPEEDOMETER_FULL) {
            skinModel = null;
            if (customModel != null) {
                skinModel = customModel.getSpeedometerFullSkinModel();
            }
            if (skinModel == null) {
                skinModel = new SpeedometerFullSkinModel();
            }
            tintedIndicatorHubEffectsIcon = ((SpeedometerFullSkinModel)skinModel).getTintedLayerEffectsIcon();
            indicatorIcon = ((SpeedometerFullSkinModel)skinModel).getIndicatorIcon();
            indicatorShadowIcon = ((SpeedometerFullSkinModel)skinModel).getIndicatorShadowIcon();
            targetIndicatorIcon = ((SpeedometerFullSkinModel)skinModel).getTargetIndicatorIcon();
            targetIndicatorShadowIcon = ((SpeedometerFullSkinModel)skinModel).getTargetIndicatorShadowIcon();
            borderIcon = ((SpeedometerFullSkinModel)skinModel).getBorderIcon();
            majorTickmarkIcon = ((SpeedometerFullSkinModel)skinModel).getMajorTickmarkIcon();
            minorTickmarkIcon = ((SpeedometerFullSkinModel)skinModel).getMinorTickmarkIcon();
            tintedIndicatorHubIcon = ((SpeedometerFullSkinModel)skinModel).getTintedLayerIcon();
            if (this.showValueLabel) {
                colorBandMaskIcon = ((SpeedometerFullSkinModel)skinModel).getColorBandMaskValueIcon();
                valueHubIcon = ((SpeedometerFullSkinModel)skinModel).getValueHubIcon();
                valueHubPlacementIcon = ((SpeedometerFullSkinModel)skinModel).getValueHubPlacementIcon();
            } else {
                colorBandMaskIcon = ((SpeedometerFullSkinModel)skinModel).getColorBandMaskNoValueIcon();
            }
            startAngle = this.showValueLabel ? 225.0 : 253.64;
            sweep = this.showValueLabel ? 270.0 : 327.28;
            numMajorTicks = 11;
            numMinorTicksPerSegment = 3;
            colorBandSize = new Rectangle(colorBandMaskIcon.getIconWidth(), colorBandMaskIcon.getIconHeight());
            borderSize = new Rectangle(borderIcon.getIconWidth(), borderIcon.getIconHeight());
            ellipseBounds = new Rectangle2D.Double((borderSize.getWidth() - colorBandSize.getWidth()) / 2.0, (borderSize.getHeight() - colorBandSize.getHeight()) / 2.0, colorBandSize.getWidth(), colorBandSize.getHeight());
            tickmarkEllipseBounds = new Rectangle2D.Double(borderSize.getWidth() / 2.0 - (double)majorTickmarkIcon.getIconHeight(), borderSize.getHeight() / 2.0 - (double)majorTickmarkIcon.getIconHeight(), (double)majorTickmarkIcon.getIconHeight() * 2.0, (double)majorTickmarkIcon.getIconHeight() * 2.0);
        } else if (kpiType == RendererUtil.KPIChartType.SPEEDOMETER_HALF) {
            skinModel = null;
            if (customModel != null) {
                skinModel = customModel.getSpeedometerHalfSkinModel();
            }
            if (skinModel == null) {
                skinModel = new SpeedometerHalfSkinModel();
            }
            tintedIndicatorHubEffectsIcon = ((SpeedometerHalfSkinModel)skinModel).getTintedLayerEffectsIcon();
            indicatorIcon = ((SpeedometerHalfSkinModel)skinModel).getIndicatorIcon();
            indicatorShadowIcon = ((SpeedometerHalfSkinModel)skinModel).getIndicatorShadowIcon();
            targetIndicatorIcon = ((SpeedometerHalfSkinModel)skinModel).getTargetIndicatorIcon();
            targetIndicatorShadowIcon = ((SpeedometerHalfSkinModel)skinModel).getTargetIndicatorShadowIcon();
            borderIcon = ((SpeedometerHalfSkinModel)skinModel).getBorderIcon();
            majorTickmarkIcon = ((SpeedometerHalfSkinModel)skinModel).getMajorTickmarkIcon();
            minorTickmarkIcon = ((SpeedometerHalfSkinModel)skinModel).getMinorTickmarkIcon();
            tintedIndicatorHubIcon = ((SpeedometerHalfSkinModel)skinModel).getTintedLayerIcon();
            colorBandMaskIcon = ((SpeedometerHalfSkinModel)skinModel).getColorBandMaskIcon();
            startAngle = 180.0;
            sweep = 180.0;
            numMajorTicks = 6;
            numMinorTicksPerSegment = 3;
            colorBandSize = new Rectangle(colorBandMaskIcon.getIconWidth(), colorBandMaskIcon.getIconWidth());
            borderSize = new Rectangle(borderIcon.getIconWidth(), borderIcon.getIconHeight());
            ellipseBounds = new Rectangle2D.Double((borderSize.getWidth() - colorBandSize.getWidth()) / 2.0, (double)majorTickmarkIcon.getIconHeight() - colorBandSize.getHeight() / 2.0, colorBandSize.getWidth(), colorBandSize.getWidth());
            tickmarkEllipseBounds = new Rectangle2D.Double(borderSize.getWidth() / 2.0 - (double)minorTickmarkIcon.getIconHeight(), majorTickmarkIcon.getIconHeight() - minorTickmarkIcon.getIconHeight(), (double)minorTickmarkIcon.getIconHeight() * 2.0, (double)minorTickmarkIcon.getIconHeight() * 2.0);
        } else if (kpiType == RendererUtil.KPIChartType.SPEEDOMETER_QUARTER) {
            skinModel = null;
            if (customModel != null) {
                skinModel = customModel.getSpeedometerQuarterSkinModel();
            }
            if (skinModel == null) {
                skinModel = new SpeedometerQuarterSkinModel();
            }
            tintedIndicatorHubEffectsIcon = ((SpeedometerQuarterSkinModel)skinModel).getTintedLayerEffectsIcon();
            indicatorIcon = ((SpeedometerQuarterSkinModel)skinModel).getIndicatorIcon();
            indicatorShadowIcon = ((SpeedometerQuarterSkinModel)skinModel).getIndicatorShadowIcon();
            targetIndicatorIcon = ((SpeedometerQuarterSkinModel)skinModel).getTargetIndicatorIcon();
            targetIndicatorShadowIcon = ((SpeedometerQuarterSkinModel)skinModel).getTargetIndicatorShadowIcon();
            borderIcon = ((SpeedometerQuarterSkinModel)skinModel).getBorderIcon();
            majorTickmarkIcon = ((SpeedometerQuarterSkinModel)skinModel).getMajorTickmarkIcon();
            minorTickmarkIcon = ((SpeedometerQuarterSkinModel)skinModel).getMinorTickmarkIcon();
            tintedIndicatorHubIcon = ((SpeedometerQuarterSkinModel)skinModel).getTintedLayerIcon();
            colorBandMaskIcon = ((SpeedometerQuarterSkinModel)skinModel).getColorBandMaskIcon();
            startAngle = 135.0;
            sweep = 90.0;
            numMajorTicks = 4;
            numMinorTicksPerSegment = 2;
            colorBandSize = new Rectangle(colorBandMaskIcon.getIconWidth(), colorBandMaskIcon.getIconWidth());
            borderSize = new Rectangle(borderIcon.getIconWidth(), borderIcon.getIconHeight());
            ellipseBounds = new Rectangle2D.Double((borderSize.getWidth() - colorBandSize.getWidth()) / 2.0, (double)majorTickmarkIcon.getIconHeight() - colorBandSize.getHeight() / 2.0, colorBandSize.getWidth(), colorBandSize.getWidth());
            tickmarkEllipseBounds = new Rectangle2D.Double(borderSize.getWidth() / 2.0 - (double)minorTickmarkIcon.getIconHeight(), majorTickmarkIcon.getIconHeight() - minorTickmarkIcon.getIconHeight(), (double)minorTickmarkIcon.getIconHeight() * 2.0, (double)minorTickmarkIcon.getIconHeight() * 2.0);
        }
        double scaleFactor = this.calculateSkinnableKPIChartScaleFactor(componentBounds, borderSize);
        this.imageCache.setScaleFactor(scaleFactor);
        KPIChartSegmentedRangeColorModel rangeModel = this.kpiRendererModel.getSegmentedRangeColorModel();
        Arc2D.Double[] segmentsArea = (Arc2D.Double[])this.imageCache.getSegmentsArea(rangeModel);
        if (segmentsArea == null) {
            segmentsArea = this.calculateSpeedometerSegmentArea(segmentVals, borderSize, startAngle, sweep, ellipseBounds);
            this.imageCache.addSegmentsArea(segmentsArea, rangeModel);
        }
        int selectedIndex = Util.getRangeSegmentIndex(rangeModel, this.getCurrentValue());
        double[] tickmarkAngles = null;
        int componentCenterX = (int)((double)componentBounds.x + (componentBounds.getWidth() - (double)borderIcon.getIconWidth() * scaleFactor) / 2.0);
        int componentCenterY = (int)((double)componentBounds.y + (componentBounds.getHeight() - (double)borderIcon.getIconHeight() * scaleFactor) / 2.0);
        BufferedImage cachedBackLayers = (BufferedImage)this.imageCache.getScaledImage("backLayer_", scaleFactor, rangeModel, selectedIndex);
        if (cachedBackLayers == null) {
            cachedBackLayers = KPIChartRenderer.newBufferedImage(borderIcon.getIconWidth(), borderIcon.getIconHeight());
            Graphics2D cachedBackLayersGraphics = cachedBackLayers.createGraphics();
            this.applyRenderingHints(cachedBackLayersGraphics);
            this.renderSpeedometerPie(cachedBackLayersGraphics, borderSize, segmentsArea);
            this.renderSkinnableSpeedometerFullCenteredImageLayer(cachedBackLayersGraphics, colorBandMaskIcon.getImage(), borderSize);
            tickmarkAngles = this.renderSkinnableSpeedometerFullTickmarksLayer(cachedBackLayersGraphics, majorTickmarkIcon, minorTickmarkIcon, borderSize, numMajorTicks, numMinorTicksPerSegment, startAngle, sweep, kpiType);
            this.renderSkinnableSpeedometerFullCenteredImageLayer(cachedBackLayersGraphics, borderIcon.getImage(), borderSize);
            Color tintColor = Util.getRangeSegmentColor(this.kpiRendererModel.getSegmentedRangeColorModel(), rvValue, true);
            ImageIcon tintImageIcon = null;
            if (tintedIndicatorHubIcon != null) {
                Image tintImage = null;
                BufferedImage newTintImage = KPIChartRenderer.newBufferedImage(tintedIndicatorHubIcon.getIconWidth(), tintedIndicatorHubIcon.getIconHeight());
                newTintImage.getGraphics().drawImage(tintedIndicatorHubIcon.getImage(), 0, 0, null);
                tintImage = this.changeColor(newTintImage, tintColor);
                tintImageIcon = new ImageIcon(tintImage);
            }
            if (tintImageIcon != null) {
                this.renderSkinnableSpeedometerFullCenteredImageLayer(cachedBackLayersGraphics, tintImageIcon.getImage(), borderSize);
            }
            this.renderSkinnableSpeedometerFullCenteredImageLayer(cachedBackLayersGraphics, tintedIndicatorHubEffectsIcon.getImage(), borderSize);
            cachedBackLayersGraphics.dispose();
            cachedBackLayers = KPIChartRenderer.getFastScaledImage(cachedBackLayers, (int)((double)borderIcon.getIconWidth() * scaleFactor), (int)((double)borderIcon.getIconHeight() * scaleFactor));
            this.imageCache.addScaledImage(cachedBackLayers, "backLayer_", scaleFactor, rangeModel, selectedIndex);
        }
        gc.drawImage((Image)cachedBackLayers, componentCenterX, componentCenterY, null);
        BufferedImage indicatorImage = this.getScaledImage(indicatorIcon, "indicator_", rangeModel, scaleFactor);
        BufferedImage targetImage = this.getScaledImage(targetIndicatorIcon, "target_", rangeModel, scaleFactor);
        BufferedImage shadowImage = this.getScaledImage(indicatorShadowIcon, "indicatorShadow_", rangeModel, scaleFactor);
        BufferedImage targetShadowImage = this.getScaledImage(targetIndicatorShadowIcon, "targetShadow_", rangeModel, scaleFactor);
        BufferedImage valueHubImage = this.getScaledImage(valueHubIcon, "valueHub_", rangeModel, scaleFactor);
        this.renderSkinnableSpeedometerFullIndicatorLayer(gc, indicatorImage, shadowImage, majorTickmarkIcon == null ? null : majorTickmarkIcon.getImage(), borderSize, segmentVals, rvValue, startAngle, sweep, kpiType, scaleFactor, componentCenterX, componentCenterY);
        if (!Double.isNaN(targetValue)) {
            this.renderSkinnableSpeedometerFullIndicatorLayer(gc, targetImage, targetShadowImage, majorTickmarkIcon == null ? null : majorTickmarkIcon.getImage(), borderSize, segmentVals, targetValue, startAngle, sweep, kpiType, scaleFactor, componentCenterX, componentCenterY);
        }
        if (valueHubImage != null) {
            this.renderSkinnableSpeedometerFullValueHub(gc, valueHubImage, valueHubPlacementIcon, borderSize, scaleFactor, componentCenterX, componentCenterY);
        }
        AffineTransform scaleTransform = AffineTransform.getTranslateInstance(componentCenterX, componentCenterY);
        scaleTransform.scale(scaleFactor, scaleFactor);
        if (this.showRangeLabels) {
            if (tickmarkAngles == null) {
                tickmarkAngles = this.calculateSkinnableSpeedometerTickmarkAngles(numMajorTicks, numMinorTicksPerSegment, startAngle, sweep);
            }
            Point2D.Double[] labelCenterPositions = this.calculateSkinnableSpeedometerFullLabelPositions(borderSize, colorBandSize, majorTickmarkIcon, minorTickmarkIcon, scaleTransform, numMajorTicks, startAngle, sweep, tickmarkAngles, kpiType);
            Font labelsFont = this.kpiRendererModel.getRangeValueTextStyle().getFont();
            if ((labelsFont = this.checkSkinnableSpeedometerFullRangeLabelCollisions(gc, borderSize, ellipseBounds, tickmarkEllipseBounds, labelsFont, scaleTransform, labelCenterPositions)) != null) {
                this.renderSkinnableSpeedometerFullRangeLabels(gc, labelCenterPositions, labelsFont, this.getRangeTextStyleColor());
            }
        }
        if (this.showValueLabel) {
            Rectangle2D availableValueLabelSpace;
            Font valueFont = this.kpiRendererModel.getActualValueTextStyle().getFont();
            if (kpiType == RendererUtil.KPIChartType.SPEEDOMETER_FULL) {
                availableValueLabelSpace = this.determineAvailableValueLabelSpace(valueHubIcon, scaleTransform);
                String valueString = this.getValueLabel(false);
                valueFont = this.checkSkinnableSpeedometerFullValueLabelCollisions(gc, valueString, valueFont, availableValueLabelSpace);
                if (valueFont == null) {
                    valueString = "*";
                    valueFont = this.kpiRendererModel.getActualValueTextStyle().getFont();
                    valueFont = this.checkSkinnableSpeedometerFullValueLabelCollisions(gc, valueString, valueFont, availableValueLabelSpace);
                }
                if (valueFont != null) {
                    this.renderSkinnableSpeedometerFullValueLabel(gc, valueString, valueFont, valueHubIcon, valueHubPlacementIcon, scaleTransform, borderSize, this.factor != 1.0);
                }
            } else {
                availableValueLabelSpace = this.determineAvailableValueLabelSpace(borderIcon, scaleTransform);
                boolean valueLabelFits = true;
                String valueString = this.getValueLabel(true);
                valueLabelFits = this.checkSkinnableSpeedometerValueLabelCollisions(gc, valueString, valueFont, availableValueLabelSpace);
                if (!valueLabelFits) {
                    valueString = this.getValueLabel(false);
                    valueLabelFits = this.checkSkinnableSpeedometerValueLabelCollisions(gc, valueString, valueFont, availableValueLabelSpace);
                }
                if (!valueLabelFits) {
                    valueString = "*";
                    valueLabelFits = this.checkSkinnableSpeedometerValueLabelCollisions(gc, valueString, valueFont, availableValueLabelSpace);
                }
                if (valueLabelFits) {
                    this.renderSkinnableSpeedometerHalfValueLabel(gc, valueString, valueFont, this.getValueTextStyleColor(), borderSize, scaleTransform);
                }
            }
        }
    }

    private void renderSkinnableSpeedometerFullValueLabel(Graphics2D gc, String valueString, Font valueFont, ImageIcon valueHubIcon, ImageIcon indicatorHubEffectsIcon, AffineTransform transform, Rectangle borderSize, boolean showMagnitudeString) {
        Point2D.Double valueHubCenterPoint = new Point2D.Double((borderSize.getWidth() - 1.0) / 2.0, (double)indicatorHubEffectsIcon.getIconHeight() + (double)valueHubIcon.getIconHeight() / 2.0);
        transform.transform(valueHubCenterPoint, valueHubCenterPoint);
        gc.setFont(valueFont);
        gc.setColor(this.getValueTextStyleColor());
        FontRenderContext frc = gc.getFontRenderContext();
        TextLayout textLayout = new TextLayout(valueString, valueFont, frc);
        valueHubCenterPoint = this.calculateCenterTextOrigin(textLayout, valueHubCenterPoint);
        gc.drawString(valueString, (float)valueHubCenterPoint.x, (float)valueHubCenterPoint.y);
        if (showMagnitudeString) {
            valueFont = this.kpiRendererModel.getActualValueTextStyle().getFont();
            gc.setFont(valueFont);
            frc = gc.getFontRenderContext();
            valueString = this.getMagnitudeLabel().trim();
            textLayout = new TextLayout(valueString, valueFont, frc);
            Point2D.Double magnitudeTopCenter = new Point2D.Double((borderSize.getWidth() - 1.0) / 2.0, borderSize.getHeight() + 3.0);
            transform.transform(magnitudeTopCenter, magnitudeTopCenter);
            FontMetrics fm = gc.getFontMetrics();
            double height = fm.getHeight() - fm.getDescent();
            gc.drawString(valueString, (float)(magnitudeTopCenter.x - textLayout.getBounds().getWidth() / 2.0), (float)(magnitudeTopCenter.y + height));
        }
    }

    private Font checkSkinnableSpeedometerFullValueLabelCollisions(Graphics2D gc, String valueString, Font valueFont, Rectangle2D availableValueLabelSpace) {
        boolean valueLabelTooLarge;
        gc.setFont(valueFont);
        FontRenderContext frc = gc.getFontRenderContext();
        TextLayout textLayout = new TextLayout(valueString, valueFont, frc);
        Rectangle2D valueLabelBounds = textLayout.getBounds();
        boolean bl = valueLabelTooLarge = valueLabelBounds.getWidth() > availableValueLabelSpace.getWidth() || valueLabelBounds.getHeight() > availableValueLabelSpace.getHeight();
        if (valueLabelTooLarge) {
            if (valueFont.getSize() <= 8) {
                return null;
            }
            valueFont = valueFont.deriveFont(valueFont.getSize2D() - 1.0f);
            return this.checkSkinnableSpeedometerFullValueLabelCollisions(gc, valueString, valueFont, availableValueLabelSpace);
        }
        return valueFont;
    }

    private Rectangle2D determineAvailableValueLabelSpace(ImageIcon valueHubIcon, AffineTransform scaleTransform) {
        Rectangle2D availableValueLabelSpace = new Rectangle2D.Double(0.0, 0.0, valueHubIcon.getIconWidth() - 6, valueHubIcon.getIconHeight() - 6);
        availableValueLabelSpace = scaleTransform.createTransformedShape(availableValueLabelSpace).getBounds2D();
        return availableValueLabelSpace;
    }

    private void renderSkinnableSpeedometerFullRangeLabels(Graphics2D gc, Point2D.Double[] labelCenterPositions, Font labelsFont, Color labelsColor) {
        FontRenderContext frc = gc.getFontRenderContext();
        gc.setFont(labelsFont);
        gc.setColor(labelsColor);
        for (int i = 0; i < labelCenterPositions.length; ++i) {
            String label = this.formattedSegmentValues[i];
            TextLayout labelLayout = new TextLayout(label, labelsFont, frc);
            Point2D.Double point = this.calculateCenterTextOrigin(labelLayout, labelCenterPositions[i]);
            gc.drawString(label, (float)point.x, (float)point.y);
        }
    }

    private Font checkSkinnableSpeedometerFullRangeLabelCollisions(Graphics2D gc, Rectangle borderSize, Rectangle2D.Double colorBandEllipseBounds, Rectangle2D.Double tickmarkEllipseBounds, Font labelsFont, AffineTransform transform, Point2D.Double[] labelCenterPositions) {
        Ellipse2D.Double colorBandMaskE = new Ellipse2D.Double(colorBandEllipseBounds.getX(), colorBandEllipseBounds.getY(), colorBandEllipseBounds.getWidth(), colorBandEllipseBounds.getHeight());
        Ellipse2D.Double tickmarkE = new Ellipse2D.Double(tickmarkEllipseBounds.getX(), tickmarkEllipseBounds.getY(), tickmarkEllipseBounds.getWidth(), tickmarkEllipseBounds.getHeight());
        Shape colorBandMaskEllipse = transform.createTransformedShape(colorBandMaskE);
        Shape tickmarkEllipse = transform.createTransformedShape(tickmarkE);
        RectangularShape previousRectangle = null;
        Rectangle2D.Double currentRectangle = null;
        gc.setFont(labelsFont);
        FontRenderContext frc = gc.getFontRenderContext();
        for (int i = 0; i < labelCenterPositions.length; ++i) {
            String currentLabel = this.formattedSegmentValues[i];
            TextLayout textLayout = new TextLayout(currentLabel, labelsFont, frc);
            Point2D.Double point = this.calculateCenterTextOrigin(textLayout, labelCenterPositions[i]);
            currentRectangle = new Rectangle2D.Double(point.x, point.y, textLayout.getBounds().getWidth(), textLayout.getBounds().getHeight());
            if (!tickmarkEllipse.intersects(currentRectangle) && colorBandMaskEllipse.contains(currentRectangle) && (previousRectangle == null || !previousRectangle.intersects(currentRectangle))) continue;
            if (labelsFont.getSize() <= 8) {
                return null;
            }
            labelsFont = labelsFont.deriveFont(labelsFont.getSize2D() - 1.0f);
            return this.checkSkinnableSpeedometerFullRangeLabelCollisions(gc, borderSize, colorBandEllipseBounds, tickmarkEllipseBounds, labelsFont, transform, labelCenterPositions);
        }
        return labelsFont;
    }

    private Point2D.Double calculateCenterTextOrigin(TextLayout textLayout, Point2D point) {
        Rectangle2D textBounds = textLayout.getBounds();
        double y = point.getY() - textBounds.getMinY() - 0.5 * textBounds.getHeight();
        double x = point.getX() - textBounds.getMinX() - 0.5 * textBounds.getWidth();
        return new Point2D.Double(x, y);
    }

    private Point2D.Double[] calculateSkinnableSpeedometerFullLabelPositions(Rectangle borderSize, Rectangle colorBandSize, ImageIcon majorTickmarkIcon, ImageIcon minorTickmarkIcon, AffineTransform scaleTransform, int numTickMarks, double startAngle, double sweep, double[] tickmarkAngles, RendererUtil.KPIChartType kpiType) {
        int i;
        Point2D.Double[] labelPositions = new Point2D.Double[numTickMarks];
        double centerX = 0.0;
        double centerY = 0.0;
        double radius = 0.0;
        if (kpiType == RendererUtil.KPIChartType.SPEEDOMETER_FULL) {
            centerX = (borderSize.getWidth() - 1.0) / 2.0;
            centerY = (borderSize.getHeight() - 1.0) / 2.0;
            radius = (double)majorTickmarkIcon.getIconHeight() + (colorBandSize.getHeight() / 2.0 - (double)majorTickmarkIcon.getIconHeight()) / 2.0;
        } else {
            centerX = (borderSize.getWidth() - 1.0) / 2.0;
            centerY = majorTickmarkIcon.getIconHeight() - 1;
            radius = (double)minorTickmarkIcon.getIconHeight() + (colorBandSize.getHeight() / 2.0 - (double)minorTickmarkIcon.getIconHeight()) / 2.0;
        }
        for (i = 0; i < labelPositions.length; ++i) {
            labelPositions[i] = new Point2D.Double(centerX + radius * Math.sin(tickmarkAngles[i]), centerY - radius * Math.cos(tickmarkAngles[i]));
        }
        for (i = 0; i < labelPositions.length; ++i) {
            scaleTransform.transform(labelPositions[i], labelPositions[i]);
        }
        return labelPositions;
    }

    private double[] calculateSkinnableSpeedometerTickmarkAngles(int numMajorTicks, int numMinorTicks, double startAngle, double sweep) {
        double[] tickmarkAngles = new double[numMajorTicks];
        for (int i = 0; i < numMajorTicks; ++i) {
            double relativePosition = Math.min(Math.max((double)i / (double)(numMajorTicks - 1), 0.0), 1.0);
            double tickAngle = relativePosition * sweep - (startAngle - 90.0);
            tickmarkAngles[i] = tickAngle * (Math.PI / 180);
        }
        return tickmarkAngles;
    }

    private double[] renderSkinnableSpeedometerFullTickmarksLayer(Graphics2D graphics, ImageIcon majorTickmarkIcon, ImageIcon minorTickmarkIcon, Rectangle borderSize, int numMajorTicks, int numMinorTicks, double startAngle, double sweep, RendererUtil.KPIChartType kpiType) {
        AffineTransform oldTransform = graphics.getTransform();
        BufferedImage majorTickImage = KPIChartRenderer.newBufferedImage(majorTickmarkIcon.getIconWidth(), majorTickmarkIcon.getIconHeight());
        majorTickImage.getGraphics().drawImage(majorTickmarkIcon.getImage(), 0, 0, null);
        BufferedImage minorTickImage = KPIChartRenderer.newBufferedImage(minorTickmarkIcon.getIconWidth(), minorTickmarkIcon.getIconHeight());
        minorTickImage.getGraphics().drawImage(minorTickmarkIcon.getImage(), 0, 0, null);
        double centerX = 0.0;
        double centerY = 0.0;
        double topMajorTickY = 0.0;
        double topMajorTickX = 0.0;
        double topMinorTickY = 0.0;
        double topMinorTickX = 0.0;
        if (kpiType == RendererUtil.KPIChartType.SPEEDOMETER_FULL) {
            centerX = (borderSize.getWidth() - 1.0) / 2.0;
            centerY = (borderSize.getHeight() - 1.0) / 2.0;
            topMajorTickY = centerY - (double)majorTickmarkIcon.getIconHeight() + 1.0;
            topMajorTickX = (borderSize.getWidth() - (double)majorTickmarkIcon.getIconWidth()) / 2.0;
            topMinorTickY = centerY - (double)minorTickmarkIcon.getIconHeight() + 1.0;
            topMinorTickX = (borderSize.getWidth() - (double)minorTickmarkIcon.getIconWidth()) / 2.0;
            centerX = borderSize.getCenterX();
            centerY = borderSize.getCenterY();
        } else {
            topMajorTickY = 0.0;
            topMajorTickX = (borderSize.getWidth() - (double)majorTickmarkIcon.getIconWidth()) / 2.0;
            topMinorTickY = majorTickmarkIcon.getIconHeight() - minorTickmarkIcon.getIconHeight();
            topMinorTickX = (borderSize.getWidth() - (double)minorTickmarkIcon.getIconWidth()) / 2.0;
            centerX = borderSize.getCenterX();
            centerY = (double)majorTickmarkIcon.getIconHeight() - 0.5;
        }
        double previousAngle = Double.NaN;
        double[] tickmarkAngles = new double[numMajorTicks];
        for (int i = 0; i < numMajorTicks; ++i) {
            double theta;
            double relativePosition = Math.min(Math.max((double)i / (double)(numMajorTicks - 1), 0.0), 1.0);
            double tickAngle = relativePosition * sweep - (startAngle - 90.0);
            tickmarkAngles[i] = theta = tickAngle * (Math.PI / 180);
            AffineTransform rotate = AffineTransform.getRotateInstance(theta, centerX, centerY);
            rotate.translate(topMajorTickX, topMajorTickY);
            graphics.setTransform(rotate);
            graphics.drawImage((Image)majorTickImage, 0, 0, null);
            if (!Double.isNaN(previousAngle)) {
                for (int j = 0; j < numMinorTicks; ++j) {
                    double minorTickAngle = (previousAngle - tickAngle) * ((double)(j + 1) / (double)(numMinorTicks + 1)) + tickAngle;
                    theta = minorTickAngle * (Math.PI / 180);
                    rotate = AffineTransform.getRotateInstance(theta, centerX, centerY);
                    rotate.translate(topMinorTickX, topMinorTickY);
                    graphics.setTransform(rotate);
                    graphics.drawImage((Image)minorTickImage, 0, 0, null);
                }
            }
            previousAngle = tickAngle;
        }
        graphics.setTransform(oldTransform);
        return tickmarkAngles;
    }

    private void renderSkinnableSpeedometerFullValueHub(Graphics2D gc, BufferedImage valueHubImage, ImageIcon tintedIndicatorHubEffectsIcon, Rectangle borderSize, double scaleFactor, int x, int y) {
        double valueHubWidth = valueHubImage.getWidth();
        double centerX = (borderSize.getWidth() * scaleFactor - 1.0) / 2.0;
        double valueHubX = centerX - (valueHubWidth - 1.0) / 2.0 + (double)x;
        double valueHubY = (double)tintedIndicatorHubEffectsIcon.getIconHeight() * scaleFactor + (double)y;
        gc.drawImage((Image)valueHubImage, (int)valueHubX, (int)valueHubY, null);
    }

    private double calculateSkinnableKPIChartScaleFactor(Rectangle drawSpace, Rectangle imageSize) {
        if (this.isUseFullSpace) {
            Rectangle2D.Double rect2D = new Rectangle2D.Double(imageSize.x, imageSize.y, imageSize.width, imageSize.height);
            return this.calculateSkinnableKPIChartScaleFactor(drawSpace, rect2D);
        }
        double scaleFactor = 1.0;
        if (drawSpace.height > imageSize.height && drawSpace.width > imageSize.width) {
            return scaleFactor;
        }
        if (drawSpace.height < imageSize.height) {
            scaleFactor = (double)drawSpace.height / (double)imageSize.height;
        }
        if ((double)drawSpace.width < (double)imageSize.width * scaleFactor) {
            scaleFactor = (double)drawSpace.width / (double)imageSize.width;
        }
        return scaleFactor;
    }

    private void renderSpeedometerIndicator(Graphics2D gc, Rectangle drawSpace, ImageIcon needleIcon, double[] segmentVals, double startAngle, double sweep, boolean target) {
        int numRange = segmentVals.length - 1;
        double value0 = segmentVals[0];
        double valueN = segmentVals[numRange];
        double delta = valueN - value0;
        double rvValue = 0.0;
        if (!target) {
            NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
            actualVariable.init();
            try {
                rvValue = actualVariable.value.getValue(0);
            }
            catch (MissingValueException missingValueException) {}
        } else {
            NumericVariable targetVariable = this.kpiRendererModel.getTargetVariable();
            if (targetVariable == null) {
                return;
            }
            targetVariable.init();
            try {
                rvValue = targetVariable.value.getValue(0);
            }
            catch (MissingValueException e) {
                return;
            }
            this.isTargetOutOfBounds(rvValue, segmentVals);
        }
        double relativePosition = Math.min(Math.max((rvValue - value0) / delta, 0.0), 1.0);
        double theta = relativePosition * sweep - (startAngle - 90.0);
        AffineTransform oldTransform = gc.getTransform();
        AffineTransform rotate = AffineTransform.getRotateInstance(theta *= Math.PI / 180, drawSpace.getX() + 101.5 * this.ratio, drawSpace.getY() + 101.5 * this.ratio);
        gc.transform(rotate);
        gc.drawImage(needleIcon.getImage(), (int)Math.round(drawSpace.getX()), (int)Math.round(drawSpace.getY()), (int)((double)needleIcon.getIconWidth() * this.ratio), (int)Math.round((double)needleIcon.getIconHeight() * this.ratio), null);
        gc.setTransform(oldTransform);
    }

    private void renderSpeedometerValueLabel(Graphics2D gc, Rectangle drawSpace, double lowerBorderEdge) {
        String valueLabel = this.getValueLabel(this.kpiRendererModel.getKPIChartType() != RendererUtil.KPIChartType.SPEEDOMETER_FULL);
        Font valueFont = this.kpiRendererModel.getActualValueTextStyle().getFont();
        gc.setFont(valueFont);
        FontRenderContext frc = gc.getFontRenderContext();
        String allNumbers = "0123456789-,$%+-=()";
        Rectangle2D valueLabelBounds = valueFont.createGlyphVector(frc, valueLabel).getVisualBounds();
        FontMetrics fm = gc.getFontMetrics();
        int valueHeight = (int)Math.round(valueFont.createGlyphVector(frc, allNumbers).getVisualBounds().getHeight());
        boolean showLabel = true;
        RendererUtil.KPIChartType kpiType = this.kpiRendererModel.getKPIChartType();
        int xValue = 0;
        int yValue = 0;
        if (kpiType == RendererUtil.KPIChartType.SPEEDOMETER_FULL) {
            Rectangle bounds = new Rectangle((int)(drawSpace.getX() + 76.0 * this.ratio), (int)(drawSpace.getY() + 151.0 * this.ratio + 1.0), (int)(52.0 * this.ratio), (int)(16.0 * this.ratio) - 1);
            xValue = (int)Math.round(bounds.getCenterX() - valueLabelBounds.getWidth() / 2.0);
            yValue = (int)Math.round(bounds.getCenterY() + (double)valueHeight / 2.0 - (double)fm.getDescent());
            boolean bl = showLabel = valueLabelBounds.getWidth() < bounds.getWidth() && (double)valueHeight < bounds.getHeight();
            while (!showLabel) {
                valueFont = new Font(valueFont.getName(), valueFont.getStyle(), Math.min(valueFont.getSize() - 1, 50));
                gc.setFont(valueFont);
                frc = gc.getFontRenderContext();
                fm = gc.getFontMetrics();
                valueHeight = (int)Math.round(valueFont.createGlyphVector(frc, allNumbers).getVisualBounds().getHeight());
                valueLabelBounds = valueFont.createGlyphVector(frc, valueLabel).getVisualBounds();
                xValue = (int)Math.round(bounds.getCenterX() - valueLabelBounds.getWidth() / 2.0);
                yValue = (int)Math.round(bounds.getCenterY() + (double)valueHeight / 2.0 - (double)fm.getDescent());
                boolean bl2 = showLabel = valueLabelBounds.getWidth() < bounds.getWidth() && (double)valueHeight < bounds.getHeight();
                if (valueFont.getSize() > 8) continue;
            }
            if (!showLabel) {
                valueFont = this.kpiRendererModel.getActualValueTextStyle().getFont();
                valueLabel = "*";
                valueFont = new Font(valueFont.getName(), valueFont.getStyle(), Math.min(valueFont.getSize() + 1, 50));
                while (!showLabel) {
                    valueFont = new Font(valueFont.getName(), valueFont.getStyle(), valueFont.getSize() - 1);
                    gc.setFont(valueFont);
                    frc = gc.getFontRenderContext();
                    fm = gc.getFontMetrics();
                    valueLabelBounds = valueFont.getStringBounds(valueLabel, frc);
                    valueHeight = fm.getHeight() - fm.getDescent();
                    xValue = (int)Math.round(bounds.getCenterX() - valueLabelBounds.getWidth() / 2.0);
                    yValue = (int)Math.round(bounds.getCenterY() + (double)valueHeight / 2.0);
                    boolean bl3 = showLabel = valueLabelBounds.getWidth() < bounds.getWidth() && (double)valueHeight < bounds.getHeight();
                    if (valueFont.getSize() > 8) continue;
                    break;
                }
            }
        } else if (kpiType == RendererUtil.KPIChartType.SPEEDOMETER_HALF || kpiType == RendererUtil.KPIChartType.SPEEDOMETER_QUARTER) {
            double valueLabelSpace = 5.0;
            yValue = (int)Math.round(drawSpace.getY() + lowerBorderEdge * this.ratio + valueLabelSpace + (double)valueHeight - (double)fm.getDescent());
            xValue = (int)Math.round(drawSpace.getCenterX() - valueLabelBounds.getWidth() / 2.0);
            if (xValue < 0) {
                if (this.kpiRendererModel.isAdjustMagnitudeValueEnabled()) {
                    valueLabel = this.getValueLabel(false);
                    valueLabelBounds = valueFont.createGlyphVector(frc, valueLabel).getVisualBounds();
                    xValue = (int)Math.round(drawSpace.getCenterX() - valueLabelBounds.getWidth() / 2.0);
                }
                if (xValue < 0) {
                    valueLabel = "*";
                    valueLabelBounds = valueFont.createGlyphVector(frc, valueLabel).getVisualBounds();
                    xValue = (int)Math.round(drawSpace.getCenterX() - valueLabelBounds.getWidth() / 2.0);
                }
            }
        }
        if (showLabel) {
            gc.setColor(this.getValueTextStyleColor());
            gc.setFont(valueFont);
            gc.drawString(valueLabel, xValue, yValue);
        }
        if (this.kpiRendererModel.isActualValueVisiblityEnabled() && kpiType == RendererUtil.KPIChartType.SPEEDOMETER_FULL && this.kpiRendererModel.isAdjustMagnitudeValueEnabled() && this.factor != 1.0) {
            valueFont = this.kpiRendererModel.getActualValueTextStyle().getFont();
            gc.setFont(valueFont);
            gc.setColor(this.getValueTextStyleColor());
            valueLabel = this.getMagnitudeLabel().trim();
            valueLabelBounds = valueFont.createGlyphVector(frc, valueLabel).getVisualBounds();
            double valueLabelSpace = -3.0;
            yValue = (int)Math.round(drawSpace.getY() + lowerBorderEdge * this.ratio + valueLabelSpace + valueLabelBounds.getHeight());
            xValue = (int)Math.round(drawSpace.getCenterX() - valueLabelBounds.getWidth() / 2.0);
            gc.drawString(valueLabel, xValue, yValue);
        }
    }

    private void renderSpeedometerRangeLabels(Graphics2D gc, double[] tickmarkValues, Arc2D.Double[] majorTicks) {
        NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
        actualVariable.init();
        Format formatter = actualVariable.getJavaFormat();
        if (formatter == null) {
            formatter = new DecimalFormat(new String("#0.##"));
        }
        gc.setColor(this.getRangeTextStyleColor());
        gc.setFont(this.tempRangeLabelFont);
        for (int i = 0; i < this.dialRangeLabelBounds.length; ++i) {
            String rangeLabel = this.formattedSegmentValues[i];
            int xPos = (int)this.dialRangeLabelBounds[i].getX();
            int yPos = (int)this.dialRangeLabelBounds[i].getY();
            gc.drawString(rangeLabel, xPos, yPos);
        }
    }

    private void renderSpeedometerMajorTicks(Graphics2D gc, Arc2D.Double[] majorTicksArea) {
        gc.setColor(new Color(97, 97, 97));
        Stroke oldStroke = gc.getStroke();
        int stroke = (int)Math.round(3.0 * this.ratio);
        double dpiScaleFactor = this.kpiRendererModel.getDataDPIScaleFactor();
        if (stroke > 3) {
            stroke = (int)(3.0 * dpiScaleFactor);
        } else if (stroke < 1) {
            stroke = (int)(1.0 * dpiScaleFactor);
        }
        gc.setStroke(new BasicStroke(stroke));
        for (int i = 0; i < majorTicksArea.length; ++i) {
            gc.draw(majorTicksArea[i]);
        }
        gc.setStroke(oldStroke);
    }

    private void renderSpeedometerMinorTicks(Graphics2D gc, double[] segmentVals, Rectangle drawSpace, double startAngle, double sweep, int numMajorSegments, int numMinorMarks) {
        double origStartAngle = startAngle;
        double maxVal = segmentVals[segmentVals.length - 1];
        double minVal = segmentVals[0];
        double delta = maxVal - minVal;
        int numMinorTicks = numMajorSegments * numMinorMarks + numMajorSegments + 1;
        double[] tickPositions = new double[numMinorTicks];
        double currentVal = minVal;
        for (int i = 0; i < tickPositions.length; ++i) {
            tickPositions[i] = currentVal;
            currentVal = minVal + (double)(i + 1) * (delta / (double)(numMinorTicks - 1));
        }
        Area[] colorSegments = new Area[tickPositions.length - 1];
        int buffer = (int)(40.0 * this.ratio);
        Rectangle ellipseBounds = new Rectangle(drawSpace.x + buffer, drawSpace.y + buffer, drawSpace.width - buffer - buffer, drawSpace.height - buffer - buffer);
        gc.setColor(new Color(97, 97, 97, 100));
        for (int i = 0; i < colorSegments.length; ++i) {
            double endAngle = origStartAngle - (tickPositions[i + 1] - tickPositions[0]) / delta * sweep;
            double currentPercentage = endAngle - startAngle;
            Arc2D.Double arc = new Arc2D.Double(ellipseBounds, startAngle, currentPercentage, 2);
            colorSegments[i] = new Area(arc);
            startAngle = endAngle;
            gc.draw(colorSegments[i]);
        }
    }

    private Arc2D.Double[] calculateSpeedometerMajorTicks(double[] tickmarkValues, Rectangle drawSpace, double startAngle, double sweep) {
        this.dialRangeLabelBounds = new Rectangle[tickmarkValues.length];
        double origStartAngle = startAngle;
        double maxVal = tickmarkValues[tickmarkValues.length - 1];
        double minVal = tickmarkValues[0];
        double delta = maxVal - minVal;
        Arc2D.Double[] colorSegments = new Arc2D.Double[tickmarkValues.length - 1];
        int buffer = (int)(36.0 * this.ratio);
        Rectangle ellipseBounds = new Rectangle(drawSpace.x + buffer, drawSpace.y + buffer, drawSpace.width - buffer - buffer, drawSpace.height - buffer - buffer);
        for (int i = 0; i < colorSegments.length; ++i) {
            Arc2D.Double arc;
            double endAngle = origStartAngle - (tickmarkValues[i + 1] - tickmarkValues[0]) / delta * sweep;
            double currentPercentage = endAngle - startAngle;
            colorSegments[i] = arc = new Arc2D.Double(ellipseBounds, startAngle, currentPercentage, 2);
            startAngle = endAngle;
            if (!this.showRangeLabels) continue;
            if (i == 0) {
                this.dialRangeLabelBounds[0] = new Rectangle((int)((double)Math.round(arc.getStartPoint().getX()) - this.rangeLabelWidths[0] / 2.0), (int)(Math.round(arc.getStartPoint().getY()) + (long)(this.rangeLabelHeight / 2)), (int)this.rangeLabelWidths[0], this.rangeLabelHeight);
            }
            this.dialRangeLabelBounds[i + 1] = new Rectangle((int)((double)Math.round(arc.getEndPoint().getX()) - this.rangeLabelWidths[i + 1] / 2.0), (int)Math.round(arc.getEndPoint().getY() + (double)(this.rangeLabelHeight / 2)), (int)this.rangeLabelWidths[i + 1], this.rangeLabelHeight);
            Rectangle tempRect = new Rectangle(this.dialRangeLabelBounds[i]);
            Rectangle tempRect2 = new Rectangle(this.dialRangeLabelBounds[i + 1]);
            tempRect.y -= tempRect.height;
            tempRect2.y -= tempRect2.height;
            if (tempRect.intersects(tempRect2)) {
                this.showRangeLabels = false;
            }
            int border = (int)(22.0 * this.ratio);
            Rectangle borderBounds = new Rectangle(drawSpace.x + border, drawSpace.y + border, drawSpace.width - border - border, drawSpace.height - border - border);
            Ellipse2D.Double ellipse = new Ellipse2D.Double(borderBounds.getX(), borderBounds.getY(), borderBounds.getWidth(), borderBounds.getHeight());
            Area labelArea = new Area(tempRect);
            Area compareArea = new Area(tempRect);
            labelArea.intersect(new Area(ellipse));
            if (labelArea.equals(compareArea)) continue;
            this.showRangeLabels = false;
        }
        return colorSegments;
    }

    private void renderSpeedometerLayer(Graphics2D gc, Rectangle drawSpace, ImageIcon layerIcon) {
        int overlayX = drawSpace.x;
        int overlayY = drawSpace.y;
        int overlayWidth = drawSpace.width;
        int overlayHeight = drawSpace.height;
        gc.drawImage(layerIcon.getImage(), overlayX, overlayY, overlayWidth, overlayHeight, null);
    }

    private Insets calculateSpeedometerLabelInsets(Graphics2D gc, Rectangle drawSpace) {
        Insets textInsets = new Insets(0, 0, 0, 0);
        RendererUtil.KPIChartType kpiType = this.kpiRendererModel.getKPIChartType();
        if (!this.showValueLabel) {
            return textInsets;
        }
        if (!(kpiType != RendererUtil.KPIChartType.SPEEDOMETER_FULL || this.kpiRendererModel.isAdjustMagnitudeValueEnabled() && this.factor != 1.0)) {
            return textInsets;
        }
        NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
        actualVariable.init();
        Format formatter = actualVariable.getJavaFormat();
        if (formatter == null) {
            formatter = new DecimalFormat(new String("#0.##"));
        }
        Font valueFont = this.kpiRendererModel.getActualValueTextStyle().getFont();
        gc.setFont(valueFont);
        FontMetrics fontMetrics = gc.getFontMetrics();
        int valueHeight = fontMetrics.getHeight() - fontMetrics.getLeading() - (int)(0.25 * (double)fontMetrics.getDescent());
        int valueLabelSpace = 4;
        if (drawSpace.height - (kpiType == RendererUtil.KPIChartType.SPEEDOMETER_FULL ? 79 : 53) < valueHeight + valueLabelSpace) {
            this.showValueLabel = false;
            return textInsets;
        }
        textInsets.bottom = valueHeight + valueLabelSpace;
        return textInsets;
    }

    private void calculateSpeedometerLabelWidths(Graphics2D gc, double[] tickValues) {
        this.rangeLabelWidths = new double[tickValues.length];
        Font labelsFont = this.tempRangeLabelFont;
        NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
        actualVariable.init();
        Format formatter = actualVariable.getJavaFormat();
        if (formatter == null) {
            formatter = new DecimalFormat(new String("#0.##"));
        }
        gc.setFont(labelsFont);
        String firstRangeLabel = this.formattedSegmentValues[0];
        String lastRangeLabel = this.formattedSegmentValues[tickValues.length - 1];
        FontMetrics fontMetrics = gc.getFontMetrics();
        this.rangeLabelHeight = Math.round(fontMetrics.getHeight() - fontMetrics.getLeading() - fontMetrics.getDescent());
        double firstLabelWidth = fontMetrics.stringWidth(firstRangeLabel);
        double lastLabelWidth = fontMetrics.stringWidth(lastRangeLabel);
        double maxLabelWidth = Math.max(firstLabelWidth, lastLabelWidth);
        FontRenderContext frc = gc.getFontRenderContext();
        this.rangeLabelHeight = (int)labelsFont.createGlyphVector(frc, lastRangeLabel).getVisualBounds().getHeight();
        this.rangeLabelWidths[0] = firstLabelWidth;
        this.rangeLabelWidths[this.rangeLabelWidths.length - 1] = lastLabelWidth;
        for (int i = 1; i < tickValues.length - 1; ++i) {
            String rangeLabel = this.formattedSegmentValues[i];
            this.rangeLabelWidths[i] = fontMetrics.stringWidth(rangeLabel);
            maxLabelWidth = Math.max(maxLabelWidth, this.rangeLabelWidths[i]);
        }
    }

    protected void paintTrafficLightKPIChart(Graphics2D gc, Rectangle componentBounds) {
        double idealHeight = 0.0;
        double idealWidth = 0.0;
        Rectangle drawSpace = new Rectangle(componentBounds);
        NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
        actualVariable.init();
        this.showValueLabel = this.kpiRendererModel.isActualValueVisiblityEnabled();
        RendererUtil.Skin skin = this.kpiRendererModel.getSkin();
        this.show3DElements = skin == RendererUtil.Skin.SATIN;
        this.showBorder = true;
        this.displayGraph = true;
        Insets textInsets = this.calculateTrafficLightLabelInsets(gc);
        drawSpace.height = drawSpace.height - textInsets.bottom - textInsets.top;
        if (drawSpace.height <= 0) {
            this.showValueLabel = false;
            drawSpace.height = drawSpace.height + textInsets.bottom + textInsets.top;
        }
        double[] segmentVals = this.getSegmentValues();
        int numRanges = segmentVals.length - 1;
        if (this.orientation == 1) {
            idealHeight = 38 + 64 * numRanges + 11 * (numRanges - 1);
            idealWidth = 94.0;
        } else {
            idealHeight = 34 + 64 * numRanges + 11 * (numRanges - 1);
            idealWidth = 94.0;
        }
        this.ratio = idealHeight / idealWidth;
        int smallestHeight = (int)Math.ceil(this.ratio * 15.0);
        int shadowSpace = this.show3DElements ? 4 : 0;
        drawSpace.height -= shadowSpace;
        drawSpace.width -= shadowSpace;
        if (drawSpace.height <= 0) {
            drawSpace.width += shadowSpace;
            drawSpace.height += shadowSpace;
            this.show3DElements = false;
        }
        if (this.orientation == 0) {
            this.showBorder = true;
            int origWidth = drawSpace.width;
            int origHeight = drawSpace.height;
            if (!((double)drawSpace.width / (double)drawSpace.height <= this.ratio)) {
                drawSpace.width = (int)Math.floor((double)drawSpace.height * this.ratio);
            } else {
                drawSpace.height = (int)Math.floor((double)drawSpace.width / this.ratio);
            }
            if (this.show3DElements && (drawSpace.height < 17 || drawSpace.width < smallestHeight)) {
                this.show3DElements = false;
                drawSpace.width = origWidth + shadowSpace;
                drawSpace.height = origHeight + shadowSpace;
                if (!((double)drawSpace.width / (double)drawSpace.height <= this.ratio)) {
                    drawSpace.width = (int)Math.floor((double)drawSpace.height * this.ratio);
                } else {
                    drawSpace.height = (int)Math.floor((double)drawSpace.width / this.ratio);
                }
            }
            if (drawSpace.height < 15 || drawSpace.width < smallestHeight) {
                if (!this.showValueLabel) {
                    this.displayGraph = false;
                } else {
                    drawSpace.height = origHeight + (textInsets.bottom + textInsets.top);
                    drawSpace.width = origWidth;
                    if (!((double)drawSpace.width / (double)drawSpace.height <= this.ratio)) {
                        drawSpace.width = (int)Math.floor((double)drawSpace.height * this.ratio);
                    } else {
                        drawSpace.height = (int)Math.floor((double)drawSpace.width / this.ratio);
                    }
                    this.showValueLabel = false;
                    if (drawSpace.width < smallestHeight || drawSpace.height < 15) {
                        this.displayGraph = false;
                    }
                }
            }
            if (drawSpace.width < smallestHeight || drawSpace.width < smallestHeight) {
                this.displayGraph = false;
            }
            if (!this.displayGraph) {
                return;
            }
        } else {
            int origHeight = drawSpace.height;
            int origWidth = drawSpace.width;
            if (!((double)drawSpace.height / (double)drawSpace.width <= this.ratio)) {
                drawSpace.height = (int)Math.floor((double)drawSpace.width * this.ratio);
            } else {
                drawSpace.width = (int)Math.floor((double)drawSpace.height / this.ratio);
            }
            if (this.show3DElements && (drawSpace.height < smallestHeight || drawSpace.width < 17)) {
                this.show3DElements = false;
                drawSpace.width = origWidth + shadowSpace;
                drawSpace.height = origHeight + shadowSpace;
                if (!((double)drawSpace.height / (double)drawSpace.width <= this.ratio)) {
                    drawSpace.height = (int)Math.floor((double)drawSpace.width * this.ratio);
                } else {
                    drawSpace.width = (int)Math.floor((double)drawSpace.height / this.ratio);
                }
            }
            if (drawSpace.width < 15 || drawSpace.height < smallestHeight) {
                if (!this.showValueLabel) {
                    this.displayGraph = false;
                } else {
                    drawSpace.height = origHeight;
                    drawSpace.height += textInsets.bottom + textInsets.top;
                    drawSpace.width = origWidth;
                    if (!((double)drawSpace.height / (double)drawSpace.width <= this.ratio)) {
                        drawSpace.height = (int)Math.floor((double)drawSpace.width * this.ratio);
                    } else {
                        drawSpace.width = (int)Math.floor((double)drawSpace.height / this.ratio);
                    }
                    this.showValueLabel = false;
                    if (drawSpace.width < 15 || drawSpace.height < smallestHeight) {
                        this.displayGraph = false;
                    }
                }
            }
            if (!this.displayGraph) {
                return;
            }
        }
        Area backdropArea = this.calculateTrafficLightBackdrop(drawSpace, idealHeight, idealWidth);
        Area[] segmentsArea = this.calculateTrafficLightLights(backdropArea, idealWidth, idealHeight, segmentVals);
        double graphHeight = backdropArea.getBounds().getHeight() + (double)textInsets.top + (double)textInsets.bottom;
        double totalHeight = componentBounds.getHeight() - (double)shadowSpace;
        double graphWidth = backdropArea.getBounds().getWidth() + (double)textInsets.left + (double)textInsets.right;
        double totalWidth = componentBounds.getWidth() - (double)shadowSpace;
        double heightAdjustment = (int)Math.max(0.0, (totalHeight - graphHeight) / 2.0);
        double widthAdjustment = (int)Math.max(0.0, (totalWidth - graphWidth) / 2.0);
        AffineTransform transform = AffineTransform.getTranslateInstance(widthAdjustment, heightAdjustment);
        backdropArea.transform(transform);
        this.renderTrafficLightBackdrop(gc, drawSpace, backdropArea);
        this.renderTrafficLights(gc, segmentsArea, backdropArea, segmentVals);
        if (this.showValueLabel) {
            this.renderTrafficLightValueLabel(gc, backdropArea);
        }
    }

    private Area[] calculateTrafficLightLights(Area trafficLightBackdropArea, double idealWidth, double idealHeight, double[] segmentVals) {
        double idealSpaceBetweenLights;
        double idealDiameter;
        double backdropHeight = idealHeight;
        double backdropWidth = idealWidth;
        if (this.orientation == 0) {
            backdropHeight = backdropWidth;
            backdropWidth = idealHeight;
        }
        double lightDiameter = idealDiameter = 64.0;
        int numSegments = segmentVals.length - 1;
        Area[] colorSegments = new Area[numSegments];
        Ellipse2D.Double[] circles = new Ellipse2D.Double[numSegments];
        double spaceBetweenLights = idealSpaceBetweenLights = 11.0;
        double bufferSpaceLeft = (backdropWidth - lightDiameter) / 2.0;
        if (this.orientation == 1) {
            double cirX = bufferSpaceLeft;
            double cirY = backdropHeight - 21.0 - lightDiameter;
            for (int i = 0; i < numSegments; ++i) {
                circles[i] = new Ellipse2D.Double(cirX + 0.5, cirY + 0.5, lightDiameter - 1.0, lightDiameter - 1.0);
                cirY = cirY - spaceBetweenLights - lightDiameter;
                colorSegments[i] = new Area(circles[i]);
            }
        } else {
            double cirX = 16.0;
            double cirY = 15.0;
            for (int i = 0; i < numSegments; ++i) {
                circles[i] = new Ellipse2D.Double(cirX + 0.5, cirY + 0.5, lightDiameter - 1.0, lightDiameter - 1.0);
                cirX = cirX + spaceBetweenLights + lightDiameter;
                colorSegments[i] = new Area(circles[i]);
            }
        }
        return colorSegments;
    }

    private void renderTrafficLightValueLabel(Graphics2D gc, Area backdropArea) {
        String valueLabel = this.getValueLabel(true);
        Font valueFont = this.kpiRendererModel.getActualValueTextStyle().getFont();
        gc.setFont(valueFont);
        FontRenderContext frc = gc.getFontRenderContext();
        Rectangle2D valueLabelBounds = valueFont.getStringBounds(valueLabel, frc);
        FontMetrics fm = gc.getFontMetrics();
        Rectangle segmentBounds = backdropArea.getBounds();
        int xValue = (int)Math.round(segmentBounds.getCenterX() - valueLabelBounds.getWidth() / 2.0);
        if (xValue < 0) {
            if (valueLabelBounds.getWidth() > this.getBounds().getWidth()) {
                if (this.kpiRendererModel.isAdjustMagnitudeValueEnabled()) {
                    valueLabel = this.getValueLabel(false);
                    valueLabelBounds = valueFont.getStringBounds(valueLabel, frc);
                    xValue = (int)Math.round(segmentBounds.getCenterX() - valueLabelBounds.getWidth() / 2.0);
                }
                if (valueLabelBounds.getWidth() > this.getBounds().getWidth()) {
                    valueLabel = "*";
                    valueLabelBounds = valueFont.getStringBounds(valueLabel, frc);
                    xValue = (int)Math.round(segmentBounds.getCenterX() - valueLabelBounds.getWidth() / 2.0);
                }
            } else {
                xValue = 0;
            }
        }
        int valueLabelSpace = 7;
        int yValue = valueLabelSpace + (int)Math.round(segmentBounds.getY() + segmentBounds.getHeight() + (double)fm.getHeight() - (double)fm.getLeading() - (double)fm.getDescent());
        gc.setColor(this.getValueTextStyleColor());
        gc.drawString(valueLabel, xValue, yValue);
    }

    private void renderTrafficLights(Graphics2D gc, Area[] colorSegments, Area trafficLightBackdropArea, double[] segmentVals) {
        double tempImageHeight;
        double tempImageWidth;
        NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
        actualVariable.init();
        KPIChartSegmentedRangeColorModel rangeModel = this.kpiRendererModel.getSegmentedRangeColorModel();
        double rvValue = 0.0;
        try {
            rvValue = actualVariable.value.getValue(0);
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        ImageIcon topLightIcon = null;
        ImageIcon bottomLightIcon = null;
        ImageIcon middleLightIcon = null;
        ImageIcon singleLightIcon = null;
        if (this.orientation == 0) {
            if (this.show3DElements) {
                topLightIcon = GraphResources.getImageIcon("skin/satin/trafficlight/horizontal/LeftLight.png");
                bottomLightIcon = GraphResources.getImageIcon("skin/satin/trafficlight/horizontal/RightLight.png");
                middleLightIcon = GraphResources.getImageIcon("skin/satin/trafficlight/horizontal/MiddleLight.png");
                if (colorSegments.length == 1) {
                    singleLightIcon = GraphResources.getImageIcon("skin/satin/trafficlight/horizontal/SingleLight.png");
                }
            } else {
                topLightIcon = GraphResources.getImageIcon("skin/none/trafficlight/horizontal/LeftLight.png");
                bottomLightIcon = GraphResources.getImageIcon("skin/none/trafficlight/horizontal/RightLight.png");
                middleLightIcon = GraphResources.getImageIcon("skin/none/trafficlight/horizontal/MiddleLight.png");
                if (colorSegments.length == 1) {
                    singleLightIcon = GraphResources.getImageIcon("skin/none/trafficlight/horizontal/SingleLight.png");
                }
            }
        } else if (this.show3DElements) {
            topLightIcon = GraphResources.getImageIcon("skin/satin/trafficlight/vertical/TopLight.png");
            bottomLightIcon = GraphResources.getImageIcon("skin/satin/trafficlight/vertical/BottomLight.png");
            middleLightIcon = GraphResources.getImageIcon("skin/satin/trafficlight/vertical/MiddleLight.png");
            if (colorSegments.length == 1) {
                singleLightIcon = GraphResources.getImageIcon("skin/satin/trafficlight/vertical/SingleLight.png");
            }
        } else {
            topLightIcon = GraphResources.getImageIcon("skin/none/trafficlight/vertical/TopLight.png");
            bottomLightIcon = GraphResources.getImageIcon("skin/none/trafficlight/vertical/BottomLight.png");
            middleLightIcon = GraphResources.getImageIcon("skin/none/trafficlight/vertical/MiddleLight.png");
            if (colorSegments.length == 1) {
                singleLightIcon = GraphResources.getImageIcon("skin/none/trafficlight/vertical/SingleLight.png");
            }
        }
        int numRanges = segmentVals.length - 1;
        if (this.orientation == 1) {
            tempImageWidth = middleLightIcon.getIconWidth();
            tempImageHeight = topLightIcon.getIconHeight() + bottomLightIcon.getIconHeight() + middleLightIcon.getIconHeight() * Math.max(0, numRanges - 2);
            if (colorSegments.length == 1) {
                tempImageHeight = singleLightIcon.getIconHeight();
            }
        } else {
            tempImageHeight = middleLightIcon.getIconHeight();
            tempImageWidth = topLightIcon.getIconWidth() + bottomLightIcon.getIconWidth() + middleLightIcon.getIconWidth() * Math.max(0, numRanges - 2);
            if (colorSegments.length == 1) {
                tempImageWidth = singleLightIcon.getIconWidth();
            }
        }
        BufferedImage tempLightsImage = new BufferedImage((int)Math.round(tempImageWidth), (int)Math.round(tempImageHeight), 2);
        Graphics2D lightsG = tempLightsImage.createGraphics();
        this.applyRenderingHints(lightsG);
        int selectedIndex = Util.getRangeSegmentIndex(rangeModel, rvValue);
        for (int i = 0; i < colorSegments.length; ++i) {
            if (selectedIndex == i || selectedIndex < 0 && i == 0 || selectedIndex > colorSegments.length - 1 && i == colorSegments.length - 1) {
                lightsG.setColor(Util.getRangeSegmentColor(rangeModel, rvValue, true));
            } else {
                lightsG.setColor(Color.white);
            }
            lightsG.fill(colorSegments[i]);
            lightsG.draw(colorSegments[i]);
        }
        lightsG.setColor(new Color(75, 75, 75));
        Rectangle2D backdropBounds = trafficLightBackdropArea.getBounds2D();
        double yValue = tempImageHeight;
        double xValue = 0.0;
        if (singleLightIcon != null) {
            lightsG.drawImage(singleLightIcon.getImage(), 0, 0, null);
        } else {
            for (int i = 0; i < colorSegments.length; ++i) {
                if (this.orientation == 1) {
                    if (i == colorSegments.length - 1) {
                        lightsG.drawImage(topLightIcon.getImage(), 0, (int)Math.round(yValue -= (double)topLightIcon.getIconHeight()), null);
                        continue;
                    }
                    if (i == 0) {
                        lightsG.drawImage(bottomLightIcon.getImage(), 0, (int)Math.round(yValue -= (double)bottomLightIcon.getIconHeight()), null);
                        continue;
                    }
                    lightsG.drawImage(middleLightIcon.getImage(), 0, (int)Math.round(yValue -= (double)middleLightIcon.getIconHeight()), null);
                    continue;
                }
                if (i == 0) {
                    lightsG.drawImage(topLightIcon.getImage(), (int)xValue, 0, null);
                    xValue += (double)topLightIcon.getIconWidth();
                    continue;
                }
                if (i == colorSegments.length - 1) {
                    lightsG.drawImage(bottomLightIcon.getImage(), (int)xValue, 0, null);
                    continue;
                }
                lightsG.drawImage(middleLightIcon.getImage(), (int)xValue, 0, null);
                xValue += (double)middleLightIcon.getIconWidth();
            }
        }
        lightsG.dispose();
        Image scaleImage = this.orientation == 0 ? tempLightsImage.getScaledInstance((int)backdropBounds.getWidth() - 1, (int)backdropBounds.getHeight() - 1, 16) : tempLightsImage.getScaledInstance((int)backdropBounds.getWidth() - 1, (int)backdropBounds.getHeight() - 1, 16);
        gc.drawImage(scaleImage, (int)backdropBounds.getX() + 1, (int)backdropBounds.getY() + 1, null);
    }

    private void renderTrafficLightBackdrop(Graphics2D gc, Rectangle drawSpace, Area trafficLightBackdropArea) {
        this.renderShadow(gc, drawSpace, trafficLightBackdropArea);
        Rectangle2D backdropBounds = trafficLightBackdropArea.getBounds2D();
        if (this.show3DElements) {
            gc.setPaint(new GradientPaint((float)(backdropBounds.getX() + backdropBounds.getWidth() / 2.0), (float)backdropBounds.getY(), new Color(231, 231, 231), (float)(backdropBounds.getX() + backdropBounds.getWidth() / 2.0), (float)(backdropBounds.getY() + backdropBounds.getHeight()), new Color(183, 183, 183)));
        } else {
            gc.setPaint(new GradientPaint((float)(backdropBounds.getX() + backdropBounds.getWidth() / 2.0), (float)backdropBounds.getY(), new Color(249, 249, 249), (float)(backdropBounds.getX() + backdropBounds.getWidth() / 2.0), (float)(backdropBounds.getY() + backdropBounds.getHeight()), new Color(212, 212, 212)));
        }
        gc.fill(trafficLightBackdropArea);
        if (this.show3DElements) {
            gc.setPaint(new GradientPaint((float)(backdropBounds.getX() + backdropBounds.getWidth() / 2.0), (float)backdropBounds.getY(), new Color(224, 224, 224), (float)(backdropBounds.getX() + backdropBounds.getWidth() / 2.0), (float)(backdropBounds.getY() + backdropBounds.getHeight()), new Color(112, 112, 112)));
        } else {
            gc.setPaint(new GradientPaint((float)(backdropBounds.getX() + backdropBounds.getWidth() / 2.0), (float)backdropBounds.getY(), new Color(178, 178, 178), (float)(backdropBounds.getX() + backdropBounds.getWidth() / 2.0), (float)(backdropBounds.getY() + backdropBounds.getHeight()), new Color(86, 86, 86)));
        }
        gc.draw(trafficLightBackdropArea);
    }

    private Area calculateTrafficLightBackdrop(Rectangle drawSpace, double idealHeight, double idealWidth) {
        Ellipse2D.Double ellipseBottom;
        Ellipse2D.Double ellipseTop;
        double bandHeight;
        double bandWidth;
        Rectangle2D colorRect = new Rectangle();
        if (this.orientation == 0) {
            bandWidth = this.isUseFullSpace ? (double)(drawSpace.width - 1) : Math.min(idealHeight, (double)(drawSpace.width - 1));
            bandHeight = (int)(bandWidth / this.ratio);
        } else {
            bandHeight = this.isUseFullSpace ? (double)(drawSpace.height - 1) : Math.min(idealHeight, (double)(drawSpace.height - 1));
            bandWidth = (int)(bandHeight / this.ratio);
        }
        if (this.orientation == 1) {
            double radius = bandHeight * (45.5 / idealHeight);
            colorRect = new Rectangle2D.Double(drawSpace.getX(), drawSpace.getY() + radius, bandWidth, bandHeight - radius * 2.0);
            ellipseTop = new Ellipse2D.Double(drawSpace.getX(), drawSpace.getY(), bandWidth, radius * 2.0);
            ellipseBottom = new Ellipse2D.Double(drawSpace.getX(), drawSpace.getY() + (bandHeight - radius * 2.0), bandWidth, radius * 2.0);
        } else {
            double radius = bandWidth * (45.5 / idealHeight);
            colorRect = new Rectangle2D.Double(drawSpace.getX() + radius, drawSpace.getY(), bandWidth - radius * 2.0, bandHeight);
            ellipseTop = new Ellipse2D.Double(drawSpace.getX(), drawSpace.getY(), radius * 2.0, bandHeight);
            ellipseBottom = new Ellipse2D.Double(drawSpace.getX() + bandWidth - radius * 2.0, drawSpace.getY(), radius * 2.0, bandHeight);
        }
        Area backdropA = new Area(colorRect);
        backdropA.add(new Area(ellipseTop));
        backdropA.add(new Area(ellipseBottom));
        return backdropA;
    }

    private Insets calculateTrafficLightLabelInsets(Graphics2D gc) {
        this.showValueLabel = this.kpiRendererModel.isActualValueVisiblityEnabled();
        Insets maxTextInsets = new Insets(0, 0, 0, 0);
        if (!this.showValueLabel) {
            return maxTextInsets;
        }
        NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
        actualVariable.init();
        Format formatter = actualVariable.getJavaFormat();
        if (formatter == null) {
            formatter = new DecimalFormat(new String("#0.##"));
        }
        Font valueFont = this.kpiRendererModel.getActualValueTextStyle().getFont();
        gc.setFont(valueFont);
        FontMetrics fontMetrics = gc.getFontMetrics();
        int valueHeight = fontMetrics.getHeight() - fontMetrics.getLeading() - (int)(0.25 * (double)fontMetrics.getDescent());
        int valueLabelSpace = 7;
        maxTextInsets.bottom = valueHeight + valueLabelSpace;
        return maxTextInsets;
    }

    protected void paintDialKPIChart(Graphics2D gc, Rectangle componentBounds) {
        RendererUtil.Skin skin = this.kpiRendererModel.getSkin();
        if (skin == RendererUtil.Skin.MODERN) {
            this.paintSkinnableDial(gc, componentBounds);
            return;
        }
        if (skin == RendererUtil.Skin.CUSTOM) {
            if (this.kpiRendererModel.getCustomSkinModel() != null) {
                this.paintSkinnableDial(gc, componentBounds);
                return;
            }
            skin = RendererUtil.Skin.NONE;
        }
        ImageIcon overlayIcon1 = null;
        ImageIcon overlayIcon2 = null;
        NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
        actualVariable.init();
        this.show3DElements = skin == RendererUtil.Skin.SATIN;
        this.showBorder = true;
        Rectangle drawSpace = new Rectangle(componentBounds.getBounds());
        double idealWidth = 163.0;
        double idealHeight = 144.0;
        if (drawSpace.width < 28) {
            this.displayGraph = false;
        }
        if ((double)drawSpace.height < 28.0 * (idealHeight / idealWidth)) {
            this.displayGraph = false;
        }
        if (!this.displayGraph) {
            return;
        }
        double[] segmentVals = this.getSegmentValues();
        int shadowSpace = 4;
        drawSpace.width = drawSpace.width - (this.show3DElements ? shadowSpace : 0);
        drawSpace.height = drawSpace.height - (this.show3DElements ? shadowSpace : 0);
        this.showRangeLabels = this.kpiRendererModel.isRangeValueVisiblityEnabled();
        this.showValueLabel = this.kpiRendererModel.isActualValueVisiblityEnabled();
        this.showMiddleRangeLabels = this.showRangeLabels;
        Insets textInsets = this.calculateDialLabelInsets(gc, drawSpace, segmentVals, idealWidth, idealHeight);
        if (!this.displayGraph) {
            return;
        }
        if (drawSpace.width - textInsets.left - textInsets.right < 28) {
            this.showRangeLabels = false;
        }
        if ((double)(drawSpace.height - textInsets.top - textInsets.bottom) < 28.0 * (idealHeight / idealWidth)) {
            this.showRangeLabels = false;
        }
        textInsets = this.calculateDialLabelInsets(gc, drawSpace, segmentVals, idealWidth, idealHeight);
        drawSpace.width = drawSpace.width - textInsets.left - textInsets.right;
        drawSpace.height = drawSpace.height - textInsets.top - textInsets.bottom;
        drawSpace.x += textInsets.left;
        drawSpace.y += textInsets.top;
        if ((double)drawSpace.height < 57.0 * (idealHeight / idealWidth)) {
            this.show3DElements = false;
        } else if (drawSpace.width < 57) {
            this.show3DElements = false;
        }
        if (this.show3DElements) {
            overlayIcon1 = GraphResources.getImageIcon("skin/satin/dial/PieEffects.png");
            overlayIcon2 = GraphResources.getImageIcon("skin/satin/dial/HubEffects.png");
        } else {
            overlayIcon1 = GraphResources.getImageIcon("skin/none/dial/HubEffects.png");
            overlayIcon2 = null;
        }
        this.showBorder = true;
        drawSpace.height = drawSpace.width = this.isUseFullSpace ? (int)Math.min((double)drawSpace.width, (double)drawSpace.height * (idealWidth / idealHeight)) : (int)Math.min(Math.min((double)drawSpace.width, (double)drawSpace.height * (idealWidth / idealHeight)), 164.0);
        this.ratio = (drawSpace.getWidth() - 1.0) / idealWidth;
        Area backdropArea = this.calculateDialBackdrop(drawSpace);
        Area colorBandArea = this.calculateDialColorBandArea(drawSpace);
        Arc2D.Double[] segmentsArea = this.calculateDialSegmentArea(backdropArea, colorBandArea.getBounds(), segmentVals);
        if (!this.showMiddleRangeLabels && this.showRangeLabels) {
            drawSpace = new Rectangle(componentBounds.getBounds());
            drawSpace.width = drawSpace.width - (this.show3DElements ? shadowSpace : 0);
            drawSpace.height = drawSpace.height - (this.show3DElements ? shadowSpace : 0);
            textInsets = this.calculateDialLabelInsets(gc, drawSpace, segmentVals, idealWidth, idealHeight);
            drawSpace.width = drawSpace.width - textInsets.left - textInsets.right;
            drawSpace.height = drawSpace.height - textInsets.top - textInsets.bottom;
            drawSpace.x += textInsets.left;
            drawSpace.y += textInsets.top;
            drawSpace.height = drawSpace.width = (int)Math.min(Math.min((double)drawSpace.width, (double)drawSpace.height * (idealWidth / idealHeight)), 164.0);
            this.ratio = (drawSpace.getWidth() - 1.0) / idealWidth;
            backdropArea = this.calculateDialBackdrop(drawSpace);
            colorBandArea = this.calculateDialColorBandArea(drawSpace);
            segmentsArea = this.calculateDialSegmentArea(backdropArea, colorBandArea.getBounds(), segmentVals);
        }
        colorBandArea = this.calculateDialColorBandAreaMinusWedge(drawSpace, colorBandArea);
        Area innerOutlineCircleArea = this.calculateDialInnerOutlineCircle(drawSpace);
        Area innerCircleArea = this.calculateDialInnerCircle(drawSpace);
        Area indicatorArea = this.calculateDialIndicator(backdropArea, colorBandArea, segmentVals, false);
        Area targetIndicatorArea = this.calculateDialIndicator(backdropArea, colorBandArea, segmentVals, true);
        double graphHeight = backdropArea.getBounds().getHeight() + (double)textInsets.top + (double)textInsets.bottom;
        double totalHeight = componentBounds.getHeight();
        double graphWidth = backdropArea.getBounds().getWidth() + (double)textInsets.left + (double)textInsets.right;
        double totalWidth = componentBounds.getWidth();
        double heightAdjustment = (int)Math.max(0.0, (totalHeight - graphHeight) / 2.0);
        double widthAdjustment = (int)Math.max(0.0, (totalWidth - graphWidth) / 2.0);
        AffineTransform transform = AffineTransform.getTranslateInstance(widthAdjustment, heightAdjustment);
        AffineTransform oldTransform = gc.getTransform();
        gc.transform(transform);
        this.renderDialBackdrop(gc, drawSpace, backdropArea);
        this.renderDialColorSegments(gc, segmentsArea);
        if (this.show3DElements) {
            this.renderDialOverlay1(gc, colorBandArea, overlayIcon1);
        }
        if (targetIndicatorArea != null) {
            this.renderDialIndicator(gc, drawSpace, targetIndicatorArea, true);
        }
        this.renderDialIndicator(gc, drawSpace, indicatorArea, false);
        this.renderDialInnerOutlineCircle(gc, drawSpace, innerOutlineCircleArea);
        this.renderDialInnerCircle(gc, backdropArea, innerCircleArea, segmentVals);
        if (this.show3DElements) {
            this.renderDialOverlay2(gc, backdropArea, innerOutlineCircleArea, overlayIcon2);
        } else {
            this.renderDialOverlay1(gc, colorBandArea, overlayIcon1);
        }
        if (this.showValueLabel) {
            this.renderDialValueLabel(gc, backdropArea, widthAdjustment);
        }
        if (this.showRangeLabels) {
            this.renderDialRangeLabels(gc, segmentVals);
        }
        gc.setTransform(oldTransform);
    }

    protected void paintBulletGraphKPIChart(Graphics2D gc, Rectangle componentBounds) {
        int adjustment;
        RendererUtil.Skin skin = this.kpiRendererModel.getSkin();
        if (skin == RendererUtil.Skin.MODERN) {
            if (this.kpiRendererModel.getKPIChartType() == RendererUtil.KPIChartType.BULLET) {
                this.paintSkinnableBulletGraph(gc, componentBounds);
            } else {
                this.paintSkinnableSlider(gc, componentBounds);
            }
            return;
        }
        if (skin == RendererUtil.Skin.CUSTOM) {
            if (this.kpiRendererModel.getCustomSkinModel() != null) {
                if (this.kpiRendererModel.getKPIChartType() == RendererUtil.KPIChartType.BULLET) {
                    this.paintSkinnableBulletGraph(gc, componentBounds);
                } else {
                    this.paintSkinnableSlider(gc, componentBounds);
                }
                return;
            }
            skin = RendererUtil.Skin.NONE;
        }
        Rectangle drawSpace = componentBounds.getBounds();
        double[] segmentValues = this.getSegmentValues();
        NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
        actualVariable.init();
        this.ratio = 9.62;
        Insets textInsets = this.calculateBulletGraphLabelInsets(gc, drawSpace, segmentValues);
        this.displayGraph = true;
        this.show3DElements = this.kpiRendererModel.getSkin() == RendererUtil.Skin.SATIN;
        this.showBorder = true;
        this.orientation = this.kpiRendererModel.getOrientation();
        double dpiScaleFactor = this.kpiRendererModel.getDataDPIScaleFactor();
        if (this.orientation == 0) {
            if (drawSpace.height - Math.max(textInsets.top, 0) - Math.max(textInsets.bottom, 0) < 7) {
                this.displayGraph = false;
            }
            if (drawSpace.height - Math.max(textInsets.top - 3, 0) - Math.max(textInsets.bottom - 3, 0) <= 14) {
                this.show3DElements = false;
                this.showBorder = false;
            } else if (drawSpace.height - Math.max(textInsets.top - 3, 0) - Math.max(textInsets.bottom - 3, 0) < 21) {
                this.show3DElements = false;
            }
            if (drawSpace.width < 50) {
                this.displayGraph = false;
            }
            if (drawSpace.width - Math.max(textInsets.left - 3, 0) - Math.max(textInsets.right - 3, 0) <= 69) {
                this.show3DElements = false;
                this.showBorder = false;
            } else if (drawSpace.width - Math.max(textInsets.left - 3, 0) - Math.max(textInsets.right - 3 - 4, 0) < 99) {
                this.show3DElements = false;
            }
            if (!this.displayGraph) {
                return;
            }
            textInsets.left = Math.max(textInsets.left - (this.showBorder ? (int)(3.0 * dpiScaleFactor) : 0), 0);
            textInsets.right = Math.max(textInsets.right - (this.showBorder ? (int)(3.0 * dpiScaleFactor) : 0) - (this.show3DElements ? (int)(4.0 * dpiScaleFactor) : 0), 0);
            textInsets.bottom = Math.max(textInsets.bottom - (this.showBorder ? (int)(3.0 * dpiScaleFactor) : 0) - (this.show3DElements ? (int)(4.0 * dpiScaleFactor) : 0), 0);
            textInsets.top = Math.max(textInsets.top - (this.showBorder ? (int)(3.0 * dpiScaleFactor) : 0), 0);
            drawSpace.width = drawSpace.width - textInsets.left - textInsets.right;
            drawSpace.height = drawSpace.height - textInsets.top - textInsets.bottom;
            drawSpace.x += textInsets.left;
            drawSpace.y += textInsets.top;
            adjustment = 2 + (this.showBorder ? (int)(6.0 * dpiScaleFactor) : 0) + (this.show3DElements ? (int)(4.0 * dpiScaleFactor) : 0);
            if (!((double)((drawSpace.width - adjustment) / (drawSpace.height - adjustment)) <= this.ratio)) {
                drawSpace.width = (int)Math.floor((double)(drawSpace.height - adjustment) * this.ratio) + adjustment;
            }
        } else {
            if (drawSpace.width - textInsets.left - textInsets.right < 7) {
                this.displayGraph = false;
            }
            if (drawSpace.width - textInsets.left - textInsets.right <= 14) {
                this.show3DElements = false;
                this.showBorder = false;
            } else if (drawSpace.width - textInsets.left - textInsets.right < 21) {
                this.show3DElements = false;
            }
            if (drawSpace.height < 50) {
                this.displayGraph = false;
            }
            if (drawSpace.height - Math.max(textInsets.top - 3, 0) - Math.max(textInsets.bottom - 3, 0) <= 69) {
                this.show3DElements = false;
                this.showBorder = false;
            } else if (drawSpace.height - Math.max(textInsets.top - 3, 0) - Math.max(textInsets.bottom - 3 - 4, 0) < 99) {
                this.show3DElements = false;
            }
            if (!this.displayGraph) {
                return;
            }
            componentBounds = new Rectangle(drawSpace.getBounds());
            textInsets.right = Math.max(textInsets.right - (this.show3DElements ? (int)(4.0 * dpiScaleFactor) : 0), 0);
            textInsets.bottom = Math.max(textInsets.bottom - (this.show3DElements ? (int)(4.0 * dpiScaleFactor) : 0), 0);
            textInsets.top = Math.max(textInsets.top - (this.showBorder ? (int)(3.0 * dpiScaleFactor) : 0), 0);
            drawSpace.width = drawSpace.width - textInsets.left - textInsets.right;
            drawSpace.height = drawSpace.height - textInsets.top - textInsets.bottom;
            drawSpace.x += textInsets.left;
            drawSpace.y += textInsets.top;
            adjustment = (int)(2.0 * dpiScaleFactor) + (this.showBorder ? (int)(6.0 * dpiScaleFactor) : 0) + (this.show3DElements ? (int)(4.0 * dpiScaleFactor) : 0);
            if (!((double)((drawSpace.height - adjustment) / (drawSpace.width - adjustment)) <= this.ratio)) {
                drawSpace.height = (int)Math.floor((double)(drawSpace.width - adjustment) * this.ratio) + adjustment;
            }
        }
        Area colorBandArea = this.calculateBulletGraphColorBandArea(drawSpace);
        Area backdropArea = this.calculateBulletGraphBackdropArea(colorBandArea);
        Area[] segmentsArea = this.calculateBulletGraphSegmentsArea(gc, segmentValues, colorBandArea);
        Area indicatorArea = this.calculateBulletGraphIndicatorArea(colorBandArea, backdropArea, segmentValues);
        Area targetIndicatorArea = null;
        targetIndicatorArea = this.kpiRendererModel.getKPIChartType() == RendererUtil.KPIChartType.BULLET ? this.calculateBulletGraphTargetIndicatorArea(indicatorArea, colorBandArea, segmentValues) : this.calculateSliderTargetIndicatorArea(colorBandArea, segmentValues);
        double graphHeight = backdropArea.getBounds().getHeight() + (double)(this.show3DElements ? (int)(4.0 * dpiScaleFactor) : 0) + (double)textInsets.top + (double)textInsets.bottom;
        double totalHeight = componentBounds.getHeight();
        double graphWidth = backdropArea.getBounds().getWidth() + (double)(this.show3DElements ? (int)(4.0 * dpiScaleFactor) : 0) + (double)textInsets.left + (double)textInsets.right;
        double totalWidth = componentBounds.getWidth();
        double heightAdjustment = Math.max(0.0, (totalHeight - graphHeight) / 2.0);
        double widthAdjustment = Math.max(0.0, (totalWidth - graphWidth) / 2.0);
        AffineTransform transform = AffineTransform.getTranslateInstance(widthAdjustment, heightAdjustment);
        backdropArea.transform(transform);
        for (int i = 0; i < segmentsArea.length; ++i) {
            segmentsArea[i].transform(transform);
        }
        colorBandArea.transform(transform);
        indicatorArea.transform(transform);
        if (targetIndicatorArea != null) {
            targetIndicatorArea.transform(transform);
        }
        if (this.showBorder) {
            this.renderBulletGraphBackdrop(gc, drawSpace, backdropArea);
        }
        this.renderBulletGraphColorSegments(gc, segmentsArea, true, this.show3DElements);
        this.renderBulletGraphIndicator(gc, indicatorArea, false);
        if (targetIndicatorArea != null) {
            this.renderBulletGraphIndicator(gc, targetIndicatorArea, true);
        }
        if (this.showValueLabel) {
            this.renderBulletGraphValueLabel(gc, colorBandArea);
        }
        if (this.showRangeLabels) {
            this.renderBulletGraphRangeLabels(gc, colorBandArea, segmentsArea, segmentValues);
        }
    }

    private void renderBulletGraphRangeLabels(Graphics2D gc, Area colorBandArea, Area[] segmentsArea, double[] segmentValues) {
        block10: {
            int yValue;
            int xValue;
            int scaledBorder4;
            NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
            actualVariable.init();
            Format formatter = actualVariable.getJavaFormat();
            if (formatter == null) {
                formatter = new DecimalFormat(new String("#0.##"));
            }
            String firstRangeLabel = this.formattedSegmentValues[0];
            Font labelsFont = this.kpiRendererModel.getRangeValueTextStyle().getFont();
            gc.setFont(labelsFont);
            FontRenderContext frc = gc.getFontRenderContext();
            Rectangle2D firstLabelBounds = labelsFont.createGlyphVector(frc, firstRangeLabel).getVisualBounds();
            String lastRangeLabel = this.formattedSegmentValues[segmentValues.length - 1];
            Rectangle2D lastLabelBounds = labelsFont.createGlyphVector(frc, lastRangeLabel).getVisualBounds();
            gc.setColor(new Color(153, 153, 153));
            FontMetrics fontMetrics = gc.getFontMetrics();
            int labelHeight = (int)Math.round(firstLabelBounds.getHeight());
            int firstLabelWidth = (int)Math.round(firstLabelBounds.getWidth());
            int lastLabelWidth = (int)Math.round(lastLabelBounds.getWidth());
            double dpiScaleFactor = this.kpiRendererModel.getDataDPIScaleFactor();
            int tickMarkHeight = (int)(6.0 * dpiScaleFactor);
            int tickMarkSpace = (int)(2.0 * dpiScaleFactor);
            Rectangle segmentBounds = colorBandArea.getBounds();
            int scaledBorder3 = this.showBorder ? (int)(3.0 * dpiScaleFactor) : 0;
            int n = scaledBorder4 = this.showBorder ? (int)(4.0 * dpiScaleFactor) : 0;
            if (this.orientation == 0) {
                xValue = (int)(segmentBounds.getX() - (double)((int)((double)firstLabelWidth / 2.0)));
                yValue = (int)(segmentBounds.getY() + segmentBounds.getHeight() + (double)tickMarkHeight + (double)tickMarkSpace + (double)labelHeight + (double)scaledBorder4);
                gc.drawLine((int)segmentBounds.getX(), scaledBorder3 + (int)(segmentBounds.getY() + segmentBounds.getHeight()), (int)segmentBounds.getX(), scaledBorder3 + (int)(segmentBounds.getY() + segmentBounds.getHeight() + (double)tickMarkHeight));
            } else {
                xValue = scaledBorder3 + (int)(segmentBounds.getX() + segmentBounds.getWidth() + (double)tickMarkHeight + (double)tickMarkSpace);
                yValue = (int)(segmentBounds.getY() + segmentBounds.getHeight() + (double)labelHeight / 2.0) - 1;
                gc.drawLine(xValue - tickMarkHeight - tickMarkSpace - 1, (int)(segmentBounds.getY() + segmentBounds.getHeight()) - 1, xValue - tickMarkSpace - 1, (int)(segmentBounds.getY() + segmentBounds.getHeight() - 1.0));
            }
            gc.setColor(this.getRangeTextStyleColor());
            gc.drawString(firstRangeLabel, xValue, yValue);
            gc.setColor(new Color(153, 153, 153));
            if (this.orientation == 0) {
                xValue = (int)(segmentBounds.getX() + segmentBounds.getWidth() - (double)((int)((double)lastLabelWidth / 2.0)));
                gc.drawLine((int)(segmentBounds.getX() + segmentBounds.getWidth()) - 1, scaledBorder3 + (int)(segmentBounds.getY() + segmentBounds.getHeight()), (int)(segmentBounds.getX() + segmentBounds.getWidth()) - 1, scaledBorder3 + (int)(segmentBounds.getY() + segmentBounds.getHeight() + (double)tickMarkHeight));
            } else {
                yValue = (int)(segmentBounds.getY() + (double)((int)((double)labelHeight / 2.0))) - 1;
                gc.drawLine(xValue - tickMarkHeight - tickMarkSpace - 1, (int)segmentBounds.getY(), xValue - tickMarkSpace - 1, (int)segmentBounds.getY());
            }
            gc.setColor(this.getRangeTextStyleColor());
            gc.drawString(lastRangeLabel, xValue, yValue);
            gc.setColor(new Color(153, 153, 153));
            if (!this.showMiddleRangeLabels || segmentValues.length <= 2) break block10;
            if (this.orientation == 0) {
                int i;
                int n2 = i = this.isNextSegmentEqual(segmentValues, 0) ? 2 : 1;
                while (i < segmentsArea.length) {
                    if (!this.isNextSegmentEqual(segmentValues, i)) {
                        Rectangle colorRect = segmentsArea[i].getBounds();
                        String middleRangeLabel = this.formattedSegmentValues[i];
                        double middleLabelWidth = fontMetrics.stringWidth(middleRangeLabel);
                        xValue = (int)(colorRect.getX() - (double)((int)(middleLabelWidth / 2.0)));
                        yValue = (int)(colorRect.getY() + colorRect.getHeight() + (double)tickMarkHeight + (double)tickMarkSpace + (double)labelHeight + (double)scaledBorder4);
                        gc.drawLine((int)colorRect.getX() - 1, scaledBorder3 + (int)(colorRect.getY() + colorRect.getHeight()), (int)colorRect.getX() - 1, scaledBorder3 + (int)(colorRect.getY() + colorRect.getHeight() + (double)tickMarkHeight));
                        gc.setColor(this.getRangeTextStyleColor());
                        gc.drawString(middleRangeLabel, xValue, yValue);
                        gc.setColor(new Color(153, 153, 153));
                    }
                    ++i;
                }
            } else {
                int j = this.isNextSegmentEqual(segmentValues, segmentValues.length - 2) ? 2 : 1;
                for (int i = 0; i < segmentsArea.length - j; ++i) {
                    if (this.isNextSegmentEqual(segmentValues, i)) continue;
                    Rectangle colorRect = segmentsArea[i].getBounds();
                    String middleRangeLabel = this.formattedSegmentValues[i + 1];
                    xValue = (this.showBorder ? (int)(2.0 * dpiScaleFactor) : 0) + (int)(colorRect.getX() + colorRect.getWidth() + (double)tickMarkHeight + (double)tickMarkSpace);
                    yValue = (int)colorRect.getY();
                    gc.drawLine(xValue - tickMarkHeight - tickMarkSpace, yValue - 1, xValue - tickMarkSpace, yValue - 1);
                    gc.setColor(this.getRangeTextStyleColor());
                    gc.drawString(middleRangeLabel, xValue, yValue + (int)((double)labelHeight / 2.0) - 1);
                    gc.setColor(new Color(153, 153, 153));
                }
            }
        }
    }

    private void renderBulletGraphValueLabel(Graphics2D gc, Area backdropArea) {
        String valueLabel = this.getValueLabel(true);
        Font valueFont = this.kpiRendererModel.getActualValueTextStyle().getFont();
        gc.setFont(valueFont);
        FontRenderContext frc = gc.getFontRenderContext();
        Rectangle2D valueLabelBounds = valueFont.getStringBounds(valueLabel, frc);
        FontMetrics fm = gc.getFontMetrics();
        double fontHeight = fm.getHeight() - fm.getLeading();
        Rectangle segmentBounds = backdropArea.getBounds();
        int xValue = (int)Math.round(segmentBounds.getCenterX() - valueLabelBounds.getWidth() / 2.0);
        if (xValue < 0) {
            if (this.getBounds().getWidth() < valueLabelBounds.getWidth()) {
                if (this.kpiRendererModel.isAdjustMagnitudeValueEnabled()) {
                    valueLabel = this.getValueLabel(false);
                    valueLabelBounds = valueFont.getStringBounds(valueLabel, frc);
                    xValue = Math.max(0, (int)Math.round(segmentBounds.getCenterX() - valueLabelBounds.getWidth() / 2.0));
                }
                if (this.getBounds().getWidth() < valueLabelBounds.getWidth()) {
                    valueLabel = "*";
                    valueLabelBounds = valueFont.getStringBounds(valueLabel, frc);
                    xValue = Math.max(0, (int)Math.round(segmentBounds.getCenterX() - valueLabelBounds.getWidth() / 2.0));
                }
            } else {
                xValue = 0;
            }
        }
        double dpiScale = this.kpiRendererModel.getDataDPIScaleFactor();
        int valueSpace = (int)(7.0 * dpiScale + (this.showBorder ? 3.0 * dpiScale : 0.0));
        int yValue = this.orientation == 0 ? (int)Math.round(segmentBounds.getY() - (double)fm.getDescent() - (double)valueSpace) : (int)Math.round(segmentBounds.getY() + segmentBounds.getHeight() + fontHeight - (double)fm.getDescent() + (double)valueSpace);
        gc.setColor(this.getValueTextStyleColor());
        gc.drawString(valueLabel, xValue, yValue);
    }

    private void renderBulletGraphIndicator(Graphics2D gc, Area indicatorArea, boolean target) {
        RendererUtil.KPIChartType type = this.kpiRendererModel.getKPIChartType();
        if (type == RendererUtil.KPIChartType.BULLET) {
            gc.setColor(Color.black);
            Rectangle indicatorBounds = indicatorArea.getBounds();
            gc.fill(indicatorBounds);
        } else if (target) {
            gc.setColor(Color.black);
            gc.fill(indicatorArea);
        } else {
            NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
            actualVariable.init();
            double rvValue = 0.0;
            try {
                rvValue = actualVariable.value.getValue(0);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            Color arrowHubColor = Util.getRangeSegmentColor(this.kpiRendererModel.getSegmentedRangeColorModel(), rvValue, true);
            gc.setColor(arrowHubColor);
            gc.fill(indicatorArea);
            gc.setColor(Color.black);
            gc.draw(indicatorArea);
        }
    }

    private Stroke getDefaultScaledThicknessStroke(Stroke stroke) {
        if (stroke instanceof BasicStroke) {
            BasicStroke bStroke = (BasicStroke)stroke;
            return new BasicStroke((int)this.kpiRendererModel.getDataDPIScaleFactor(), bStroke.getEndCap(), bStroke.getLineJoin(), bStroke.getMiterLimit(), bStroke.getDashArray(), bStroke.getDashPhase());
        }
        return new BasicStroke((float)this.kpiRendererModel.getDataDPIScaleFactor());
    }

    private void renderBulletGraphColorSegments(Graphics2D gc, Area[] colorSegmentsArea, boolean showOutlines, boolean showBevels) {
        KPIChartSegmentedRangeColorModel rangeModel = this.kpiRendererModel.getSegmentedRangeColorModel();
        NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
        actualVariable.init();
        Double rvValue = new Double(0.0);
        try {
            rvValue = new Double(actualVariable.value.getValue(0));
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        int selectedIndex = Util.getRangeSegmentIndex(rangeModel, rvValue);
        Color[] segmentColors = rangeModel.getMappedSegmentColors();
        double dpiScale = this.kpiRendererModel.getDataDPIScaleFactor();
        for (int i = 0; i < colorSegmentsArea.length; ++i) {
            int vertAdjustment;
            Color segmentColor = this.orientation == 0 ? (selectedIndex == i ? Util.getRangeSegmentColor(rangeModel, rvValue, true) : segmentColors[i]) : (selectedIndex == colorSegmentsArea.length - 1 - i ? Util.getRangeSegmentColor(rangeModel, rvValue, true) : segmentColors[colorSegmentsArea.length - 1 - i]);
            gc.setColor(segmentColor);
            Area colorSegment = colorSegmentsArea[this.orientation == 0 ? i : colorSegmentsArea.length - 1 - i];
            gc.fill(colorSegment);
            Rectangle segmentBounds = colorSegment.getBounds();
            int horizAdjustment = i != 0 && this.orientation == 0 ? 1 : 0;
            int n = vertAdjustment = i != 0 && this.orientation == 1 ? 1 : 0;
            if (showBevels) {
                Rectangle2D.Double tempRect = new Rectangle2D.Double(segmentBounds.getX() + 1.0 * dpiScale - (double)horizAdjustment, segmentBounds.getY() + 1.0 * dpiScale - (double)vertAdjustment, segmentBounds.getWidth() - 1.0 * dpiScale + (double)horizAdjustment, 1.0 * dpiScale);
                gc.setColor(new Color(255, 255, 255, 120));
                gc.fill(tempRect);
                tempRect = new Rectangle2D.Double(segmentBounds.getX() + 2.0 * dpiScale - (double)horizAdjustment, segmentBounds.getY() + 2.0 * dpiScale - (double)vertAdjustment, segmentBounds.getWidth() - 2.0 * dpiScale + (double)horizAdjustment, 1.0 * dpiScale);
                gc.setColor(new Color(255, 255, 255, 90));
                gc.fill(tempRect);
                tempRect = new Rectangle2D.Double(segmentBounds.getX() + 3.0 * dpiScale - (double)horizAdjustment, segmentBounds.getY() + 3.0 * dpiScale - (double)vertAdjustment, segmentBounds.getWidth() - 3.0 * dpiScale + (double)horizAdjustment, 1.0 * dpiScale);
                gc.setColor(new Color(255, 255, 255, 60));
                gc.fill(tempRect);
                tempRect = new Rectangle2D.Double(segmentBounds.getX() + 4.0 * dpiScale - (double)horizAdjustment, segmentBounds.getY() + 4.0 * dpiScale - (double)vertAdjustment, segmentBounds.getWidth() - 4.0 * dpiScale + (double)horizAdjustment, 1.0 * dpiScale);
                gc.setColor(new Color(255, 255, 255, 30));
                gc.fill(tempRect);
                tempRect = new Rectangle2D.Double(segmentBounds.getX() + 1.0 * dpiScale - (double)horizAdjustment, segmentBounds.getY() + 1.0 * dpiScale - (double)vertAdjustment, 1.0 * dpiScale, segmentBounds.getHeight() - 1.0 * dpiScale + (double)vertAdjustment);
                gc.setColor(new Color(255, 255, 255, 120));
                gc.fill(tempRect);
                tempRect = new Rectangle2D.Double(segmentBounds.getX() + 2.0 * dpiScale - (double)horizAdjustment, segmentBounds.getY() + 2.0 * dpiScale - (double)vertAdjustment, 1.0 * dpiScale, segmentBounds.getHeight() - 2.0 * dpiScale + (double)vertAdjustment);
                gc.setColor(new Color(255, 255, 255, 90));
                gc.fill(tempRect);
                tempRect = new Rectangle2D.Double(segmentBounds.getX() + 3.0 * dpiScale - (double)horizAdjustment, segmentBounds.getY() + 3.0 * dpiScale - (double)vertAdjustment, 1.0 * dpiScale, segmentBounds.getHeight() - 3.0 * dpiScale + (double)vertAdjustment);
                gc.setColor(new Color(255, 255, 255, 60));
                gc.fill(tempRect);
                tempRect = new Rectangle2D.Double(segmentBounds.getX() + 4.0 * dpiScale - (double)horizAdjustment, segmentBounds.getY() + 4.0 * dpiScale - (double)vertAdjustment, 1.0 * dpiScale, segmentBounds.getHeight() - 4.0 * dpiScale + (double)vertAdjustment);
                gc.setColor(new Color(255, 255, 255, 30));
                gc.fill(tempRect);
                tempRect = new Rectangle2D.Double(segmentBounds.getX() + 1.0 * dpiScale - (double)horizAdjustment, segmentBounds.getY() + segmentBounds.getHeight() - 1.0 * dpiScale, segmentBounds.getWidth() - 1.0 * dpiScale + (double)horizAdjustment, 1.0 * dpiScale);
                gc.setColor(new Color(102, 102, 102, 120));
                gc.fill(tempRect);
                tempRect = new Rectangle2D.Double(segmentBounds.getX() + 2.0 * dpiScale - (double)horizAdjustment, segmentBounds.getY() + segmentBounds.getHeight() - 2.0 * dpiScale, segmentBounds.getWidth() - 2.0 * dpiScale + (double)horizAdjustment, 1.0 * dpiScale);
                gc.setColor(new Color(102, 102, 102, 90));
                gc.fill(tempRect);
                tempRect = new Rectangle2D.Double(segmentBounds.getX() + 3.0 * dpiScale - (double)horizAdjustment, segmentBounds.getY() + segmentBounds.getHeight() - 3.0 * dpiScale, segmentBounds.getWidth() - 3.0 * dpiScale + (double)horizAdjustment, 1.0 * dpiScale);
                gc.setColor(new Color(102, 102, 102, 60));
                gc.fill(tempRect);
                tempRect = new Rectangle2D.Double(segmentBounds.getX() + 4.0 * dpiScale - (double)horizAdjustment, segmentBounds.getY() + segmentBounds.getHeight() - 4.0 * dpiScale, segmentBounds.getWidth() - 4.0 * dpiScale + (double)horizAdjustment, 1.0 * dpiScale);
                gc.setColor(new Color(102, 102, 102, 30));
                gc.fill(tempRect);
                tempRect = new Rectangle2D.Double(segmentBounds.getX() + segmentBounds.getWidth() - 1.0 * dpiScale, segmentBounds.getY() + 1.0 * dpiScale - (double)vertAdjustment, 1.0 * dpiScale, segmentBounds.getHeight() - 1.0 * dpiScale + (double)vertAdjustment);
                gc.setColor(new Color(102, 102, 102, 120));
                gc.fill(tempRect);
                tempRect = new Rectangle2D.Double(segmentBounds.getX() + segmentBounds.getWidth() - 2.0 * dpiScale, segmentBounds.getY() + 2.0 * dpiScale - (double)vertAdjustment, 1.0 * dpiScale, segmentBounds.getHeight() - 2.0 * dpiScale + (double)vertAdjustment);
                gc.setColor(new Color(102, 102, 102, 90));
                gc.fill(tempRect);
                tempRect = new Rectangle2D.Double(segmentBounds.getX() + segmentBounds.getWidth() - 3.0 * dpiScale, segmentBounds.getY() + 3.0 * dpiScale - (double)vertAdjustment, 1.0 * dpiScale, segmentBounds.getHeight() - 3.0 * dpiScale + (double)vertAdjustment);
                gc.setColor(new Color(102, 102, 102, 60));
                gc.fill(tempRect);
                tempRect = new Rectangle2D.Double(segmentBounds.getX() + segmentBounds.getWidth() - 4.0 * dpiScale, segmentBounds.getY() + 4.0 * dpiScale - (double)vertAdjustment, 1.0 * dpiScale, segmentBounds.getHeight() - 4.0 * dpiScale + (double)vertAdjustment);
                gc.setColor(new Color(102, 102, 102, 30));
                gc.fill(tempRect);
            }
            if (!showOutlines) continue;
            gc.setColor(new Color(102, 102, 102));
            Rectangle colorSegmentBounds = colorSegment.getBounds();
            gc.drawRect((int)colorSegmentBounds.getX() - horizAdjustment, (int)colorSegmentBounds.getY() - vertAdjustment, (int)colorSegmentBounds.getWidth() + horizAdjustment - 1, (int)colorSegmentBounds.getHeight() - 1 + vertAdjustment);
        }
    }

    private void renderBulletGraphBackdrop(Graphics2D gc, Rectangle drawSpace, Area backdropArea) {
        Rectangle backdropBounds = backdropArea.getBounds();
        double dpiScale = this.kpiRendererModel.getDataDPIScaleFactor();
        if (this.show3DElements) {
            int adjustment = this.isUseFullSpace && dpiScale > 1.0 ? (int)(2.0 * dpiScale) : 0;
            Rectangle r = new Rectangle(backdropBounds.x, backdropBounds.y, backdropBounds.width + adjustment, backdropBounds.height + adjustment);
            this.renderShadow(gc, drawSpace, new Area(r), Color.LIGHT_GRAY);
        }
        gc.setColor(new Color(153, 153, 153));
        gc.drawRect((int)backdropBounds.getX(), (int)backdropBounds.getY(), (int)backdropBounds.getWidth() - 1, (int)backdropBounds.getHeight() - 1);
        Rectangle2D tempRect = backdropArea.getBounds();
        tempRect = new Rectangle2D.Double(tempRect.getX() + (double)((int)dpiScale), tempRect.getY() + (double)((int)dpiScale), tempRect.getWidth() - (double)(2 * (int)dpiScale) - 1.0, tempRect.getHeight() - (double)(2 * (int)dpiScale) - 1.0);
        gc.setColor(new Color(191, 191, 191));
        gc.draw(tempRect);
        tempRect = new Rectangle2D.Double(tempRect.getX() + (double)((int)dpiScale), tempRect.getY() + (double)((int)dpiScale), tempRect.getWidth() - (double)(2 * (int)dpiScale), tempRect.getHeight() - (double)(2 * (int)dpiScale));
        gc.setColor(new Color(228, 228, 228));
        gc.draw(tempRect);
    }

    private Area calculateSliderTargetIndicatorArea(Area colorBandArea, double[] segmentValues) {
        double rightX;
        double leftX;
        double rightY;
        double leftY;
        double pointerY;
        double pointerX;
        NumericVariable targetVariable = this.kpiRendererModel.getTargetVariable();
        if (targetVariable == null) {
            return null;
        }
        double rvValue = 0.0;
        targetVariable.init();
        try {
            rvValue = targetVariable.value.getValue(0);
        }
        catch (Exception e) {
            return null;
        }
        this.isTargetOutOfBounds(rvValue, segmentValues);
        Rectangle colorSegmentsBounds = colorBandArea.getBounds();
        double targetIndicatorWidth = Math.min(7.0, Math.max(3.0, (double)colorSegmentsBounds.width / (this.orientation == 0 ? 205.0 : 23.0) * 7.0));
        double targetIndicatorHeight = Math.min(8.0, Math.max(4.0, (double)colorSegmentsBounds.width / (this.orientation == 0 ? 205.0 : 23.0) * 8.0));
        targetIndicatorWidth *= this.kpiRendererModel.getDataDPIScaleFactor();
        targetIndicatorHeight *= this.kpiRendererModel.getDataDPIScaleFactor();
        int numRange = segmentValues.length - 1;
        double value0 = segmentValues[0];
        double valueN = segmentValues[numRange];
        double delta = valueN - value0;
        double relativePosition = Math.min(Math.max((rvValue - value0) / delta, 0.0), 1.0);
        double yValue = colorSegmentsBounds.getY();
        double rectWidth = colorSegmentsBounds.getWidth();
        double rectHeight = colorSegmentsBounds.getHeight();
        double xValue = colorSegmentsBounds.getX();
        Area targetIndicatorArea = new Area();
        if (this.orientation == 0) {
            pointerX = Math.max(colorSegmentsBounds.getX(), Math.min(rectWidth * relativePosition + xValue, colorSegmentsBounds.getX() + colorSegmentsBounds.getWidth()));
            pointerY = yValue + rectHeight - targetIndicatorHeight;
            rightY = leftY = yValue + rectHeight;
            leftX = pointerX - (double)Math.round(targetIndicatorWidth / 2.0);
            rightX = pointerX + (double)Math.round(targetIndicatorWidth / 2.0);
        } else {
            pointerX = xValue + rectWidth - targetIndicatorHeight;
            pointerY = Math.min(yValue + rectHeight, Math.max(yValue + rectHeight - relativePosition * rectHeight, yValue));
            rightX = leftX = xValue + rectWidth;
            leftY = pointerY - (double)Math.round(targetIndicatorWidth / 2.0);
            rightY = pointerY + (double)Math.round(targetIndicatorWidth / 2.0);
        }
        Polygon triangle = new Polygon();
        triangle.addPoint((int)leftX, (int)leftY);
        triangle.addPoint((int)rightX, (int)rightY);
        triangle.addPoint((int)pointerX, (int)pointerY);
        targetIndicatorArea = new Area(triangle);
        return targetIndicatorArea;
    }

    private Area calculateBulletGraphTargetIndicatorArea(Area indicatorArea, Area colorBandArea, double[] segmentValues) {
        double pointerY;
        double pointerX;
        NumericVariable targetVariable = this.kpiRendererModel.getTargetVariable();
        if (targetVariable == null) {
            return null;
        }
        double rvValue = 0.0;
        targetVariable.init();
        try {
            rvValue = targetVariable.value.getValue(0);
        }
        catch (Exception e) {
            return null;
        }
        this.isTargetOutOfBounds(rvValue, segmentValues);
        double targetIndicatorWidthRatio = 0.6;
        double targetIndicatorHeightRatio = 0.71;
        double indicatorRatio = 0.238;
        double rectWidth = this.orientation == 1 ? colorBandArea.getBounds2D().getWidth() : colorBandArea.getBounds2D().getHeight();
        double indicatorWidth = Math.round(indicatorRatio * rectWidth);
        indicatorWidth = Math.max(2.0, indicatorWidth);
        int targetIndicatorWidth = Math.max((int)Math.round(targetIndicatorWidthRatio * indicatorWidth), 2);
        Rectangle colorSegmentsBounds = colorBandArea.getBounds();
        int targetIndicatorHeight = (int)Math.round(targetIndicatorHeightRatio * (this.orientation == 0 ? colorSegmentsBounds.getHeight() : colorSegmentsBounds.getWidth()));
        int numRange = segmentValues.length - 1;
        double value0 = segmentValues[0];
        double valueN = segmentValues[numRange];
        double delta = valueN - value0;
        double relativePosition = Math.min(Math.max((rvValue - value0) / delta, 0.0), 1.0);
        double yValue = colorSegmentsBounds.getY();
        rectWidth = colorSegmentsBounds.getWidth();
        double rectHeight = colorSegmentsBounds.getHeight();
        double xValue = colorSegmentsBounds.getX();
        double pointerHeight = rectHeight;
        double pointerWidth = rectWidth;
        Area targetIndicatorArea = new Area();
        if (this.orientation == 0) {
            pointerHeight = targetIndicatorHeight;
            if (Math.round((pointerHeight = Math.max(2.0, pointerHeight)) % 2.0) != Math.round(rectHeight % 2.0)) {
                pointerHeight -= 1.0;
            }
            if (pointerHeight < 1.0) {
                pointerHeight = 2.0;
            }
            pointerX = Math.max(colorSegmentsBounds.getX(), Math.min(rectWidth * relativePosition + xValue - (double)targetIndicatorWidth / 2.0, colorSegmentsBounds.getX() + colorSegmentsBounds.getWidth() - (double)targetIndicatorWidth));
            pointerWidth = targetIndicatorWidth;
            pointerY = yValue + (double)((int)(rectHeight / 2.0 - pointerHeight / 2.0));
        } else {
            pointerWidth = targetIndicatorHeight;
            if (Math.round((pointerWidth = Math.max(2.0, pointerWidth)) % 2.0) != Math.round(rectWidth % 2.0)) {
                pointerWidth -= 1.0;
            }
            if (pointerWidth < 1.0) {
                pointerWidth = 2.0;
            }
            pointerHeight = targetIndicatorWidth;
            pointerY = Math.min(yValue + rectHeight - (double)targetIndicatorWidth, Math.max(yValue + rectHeight - relativePosition * rectHeight - (double)targetIndicatorWidth / 2.0, yValue));
            pointerX = xValue + (double)((int)(rectWidth / 2.0 - pointerWidth / 2.0));
        }
        Rectangle indicator = new Rectangle((int)pointerX, (int)pointerY, (int)pointerWidth, (int)pointerHeight);
        targetIndicatorArea = new Area(indicator);
        return targetIndicatorArea;
    }

    private Area calculateBulletGraphIndicatorArea(Area colorSegmentsArea, Area backdropArea, double[] segmentValues) {
        double indicatorRatio = 0.238;
        int numRange = segmentValues.length - 1;
        double value0 = segmentValues[0];
        double valueN = segmentValues[numRange];
        double delta = valueN - value0;
        double rvValue = 0.0;
        NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
        actualVariable.init();
        try {
            rvValue = actualVariable.value.getValue(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        double relativePosition = Math.min(Math.max((rvValue - value0) / delta, 0.0), 1.0);
        Rectangle2D colorSegmentsBounds = colorSegmentsArea.getBounds2D();
        double yValue = colorSegmentsBounds.getY();
        double rectWidth = colorSegmentsBounds.getWidth();
        double rectHeight = colorSegmentsBounds.getHeight();
        double xValue = colorSegmentsBounds.getX();
        double pointerHeight = rectHeight;
        double pointerWidth = rectWidth;
        RendererUtil.KPIChartType kpiType = this.kpiRendererModel.getKPIChartType();
        Area indicatorArea = new Area();
        if (kpiType == RendererUtil.KPIChartType.BULLET) {
            double pointerY;
            double pointerX;
            if (this.orientation == 0) {
                pointerHeight = Math.round(indicatorRatio * rectHeight);
                if (Math.round((pointerHeight = Math.max(2.0, pointerHeight)) % 2.0) != Math.round(rectHeight % 2.0)) {
                    pointerHeight -= 1.0;
                }
                if (pointerHeight < 1.0) {
                    pointerHeight = 2.0;
                }
                pointerX = xValue;
                pointerWidth = Math.round(rectWidth * relativePosition);
                pointerY = yValue + (double)((int)(rectHeight / 2.0 - pointerHeight / 2.0));
            } else {
                pointerWidth = Math.round(indicatorRatio * rectWidth);
                if (Math.round((pointerWidth = Math.max(2.0, pointerWidth)) % 2.0) != Math.round(rectWidth % 2.0)) {
                    pointerWidth -= 1.0;
                }
                if (pointerWidth < 1.0) {
                    pointerWidth = 2.0;
                }
                pointerHeight = Math.round(rectHeight * relativePosition);
                pointerY = yValue + rectHeight - pointerHeight;
                pointerX = xValue + (double)((int)(rectWidth / 2.0 - pointerWidth / 2.0));
            }
            Rectangle indicator = new Rectangle((int)pointerX, (int)pointerY, (int)pointerWidth, (int)pointerHeight);
            indicatorArea = new Area(indicator);
            indicatorArea.intersect(colorSegmentsArea);
        } else {
            double dpiScale = this.kpiRendererModel.getDataDPIScaleFactor();
            int borderThickness = (int)(colorSegmentsArea.getBounds2D().getY() - backdropArea.getBounds2D().getY());
            int n = borderThickness = borderThickness < 3 ? 3 : borderThickness;
            if (this.orientation == 0) {
                Polygon triangle = new Polygon();
                int pointY = (int)yValue + (int)(3.0 * dpiScale);
                int topY = pointY - borderThickness - (int)(8.0 * dpiScale);
                int pointX = (int)(relativePosition * rectWidth + xValue);
                triangle.addPoint(pointX - (int)(6.0 * dpiScale), topY);
                triangle.addPoint(pointX + (int)(6.0 * dpiScale), topY);
                triangle.addPoint(pointX, pointY);
                indicatorArea = new Area(triangle);
            } else {
                Polygon triangle = new Polygon();
                int pointX = (int)xValue + (int)(3.0 * dpiScale);
                int topX = pointX - borderThickness - (int)(8.0 * dpiScale);
                int pointY = (int)(yValue + rectHeight - relativePosition * rectHeight);
                triangle.addPoint(topX, pointY - (int)(6.0 * dpiScale));
                triangle.addPoint(topX, pointY + (int)(6.0 * dpiScale));
                triangle.addPoint(pointX, pointY);
                indicatorArea = new Area(triangle);
            }
        }
        return indicatorArea;
    }

    private Area calculateBulletGraphBackdropArea(Area colorSegmentsArea) {
        Rectangle segmentBounds = colorSegmentsArea.getBounds();
        Rectangle backdropRect = new Rectangle();
        int thicknessDPIScale = (int)this.kpiRendererModel.getDataDPIScaleFactor();
        backdropRect.setRect(segmentBounds.getX() - (double)(3 * thicknessDPIScale), segmentBounds.getY() - (double)(3 * thicknessDPIScale), segmentBounds.getWidth() + (double)(6 * thicknessDPIScale), segmentBounds.getHeight() + (double)(6 * thicknessDPIScale));
        Area backdropArea = new Area(backdropRect);
        if (!this.showBorder) {
            backdropArea = new Area(segmentBounds);
        }
        return backdropArea;
    }

    private Area[] calculateBulletGraphSegmentsArea(Graphics2D gc, double[] segmentValues, Area colorBandArea) {
        Font labelsFont = this.kpiRendererModel.getRangeValueTextStyle().getFont();
        gc.setFont(labelsFont);
        FontMetrics fontMetrics = gc.getFontMetrics();
        double labelHeight = fontMetrics.getHeight() - fontMetrics.getLeading() - fontMetrics.getDescent();
        FontRenderContext frc = gc.getFontRenderContext();
        Rectangle colorRect = colorBandArea.getBounds();
        int numRange = segmentValues.length - 1;
        Area[] colorSegmentsArea = new Area[numRange];
        double colorBandWidth = colorRect.getWidth();
        double xValue = colorRect.getX();
        double yValue = this.orientation == 0 ? colorRect.getY() : colorRect.getY() + colorRect.getHeight();
        double colorBandHeight = colorRect.getHeight();
        double xStart = xValue;
        double yStart = colorRect.getY();
        double yEnd = colorRect.getY() + colorBandHeight;
        double value0 = segmentValues[0];
        double valueN = segmentValues[numRange];
        String formattedValueN = this.formattedSegmentValues[numRange];
        double delta = valueN - value0;
        this.showMiddleRangeLabels = true;
        for (int i = 0; i < numRange; ++i) {
            valueN = segmentValues[i + 1];
            formattedValueN = this.formattedSegmentValues[i + 1];
            String formattedValueMin = this.formattedSegmentValues[i];
            double relativeWidth = (valueN - value0) / delta;
            double xMax = xStart + (double)Math.round(relativeWidth * colorBandWidth);
            double yMin = yEnd - (double)Math.round(relativeWidth * colorBandHeight);
            Rectangle leftRect = new Rectangle();
            Rectangle rightRect = new Rectangle();
            if (this.orientation == 0) {
                leftRect.setRect(xStart, yValue - 2.0, xValue - xStart, colorBandHeight + 4.0);
                if (i == numRange - 1) {
                    xMax = colorBandArea.getBounds2D().getX() + colorBandArea.getBounds2D().getWidth();
                }
                rightRect.setRect(xMax, yValue - 2.0, colorBandWidth + 4.0, colorBandHeight + 4.0);
            } else {
                leftRect.setRect(xStart - 2.0, yStart, colorBandWidth + 4.0, yMin - yStart);
                if (i == numRange - 1) {
                    yValue = colorBandArea.getBounds().getY() + colorBandArea.getBounds().getHeight();
                }
                rightRect.setRect(xStart - 2.0, yValue, colorBandWidth + 4.0, colorBandHeight + 4.0);
            }
            Area segmentArea = new Area(colorBandArea);
            segmentArea.subtract(new Area(leftRect));
            segmentArea.subtract(new Area(rightRect));
            NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
            actualVariable.init();
            Format formatter = actualVariable.getJavaFormat();
            if (formatter == null) {
                formatter = new DecimalFormat(new String("#0.##"));
            }
            if (this.orientation == 0) {
                if (!this.isNextSegmentEqual(segmentValues, i) && (double)fontMetrics.stringWidth(formattedValueN) / 2.0 + (double)fontMetrics.stringWidth(formattedValueMin) / 2.0 > segmentArea.getBounds().getWidth()) {
                    this.showMiddleRangeLabels = false;
                }
                xValue = xMax;
                colorSegmentsArea[i] = segmentArea;
                continue;
            }
            double heightN = labelsFont.createGlyphVector(frc, formattedValueN).getVisualBounds().getHeight();
            double heightMin = labelsFont.createGlyphVector(frc, formattedValueMin).getVisualBounds().getHeight();
            labelHeight = heightN + heightMin + 2.0;
            yValue = yMin;
            if (!this.isNextSegmentEqual(segmentValues, i) && labelHeight / 2.0 > segmentArea.getBounds().getHeight()) {
                this.showMiddleRangeLabels = false;
            }
            colorSegmentsArea[i] = segmentArea;
        }
        return colorSegmentsArea;
    }

    private Area calculateBulletGraphColorBandArea(Rectangle drawSpace) {
        double bandHeight;
        double bandWidth;
        Rectangle colorRect = new Rectangle();
        int dpiScale = (int)this.kpiRendererModel.getDataDPIScaleFactor();
        if (this.orientation == 0) {
            bandWidth = this.show3DElements ? drawSpace.width - 10 * dpiScale : (this.showBorder ? drawSpace.width - 6 * dpiScale : drawSpace.width);
            bandHeight = (int)Math.round((bandWidth - 2.0) / this.ratio + 2.0);
        } else {
            bandHeight = this.show3DElements ? drawSpace.height - 10 * dpiScale : (this.showBorder ? drawSpace.height - 6 * dpiScale : drawSpace.height);
            bandWidth = (int)Math.round((bandHeight - 2.0) / this.ratio + 2.0);
        }
        colorRect = this.showBorder ? new Rectangle((int)(3.0 + drawSpace.getX()), (int)((double)(3 * dpiScale) + drawSpace.getY()), (int)bandWidth, (int)bandHeight) : new Rectangle((int)drawSpace.getX(), (int)drawSpace.getY(), (int)bandWidth, (int)bandHeight);
        return new Area(colorRect);
    }

    private void paintSkinnableBulletGraph(Graphics2D gc, Rectangle componentBounds) {
        KPIChartCustomSkinModel customModel;
        RendererUtil.Skin skin = this.kpiRendererModel.getSkin();
        NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
        actualVariable.init();
        ImageIcon borderIcon = null;
        ImageIcon effectsIcon = null;
        ImageIcon indicatorIcon = null;
        ImageIcon targetIcon = null;
        ImageIcon shadowIcon = null;
        ImageIcon indicatorCapIcon = null;
        BulletSkinModel bulletSkinModel = null;
        if (skin == RendererUtil.Skin.CUSTOM && (customModel = this.kpiRendererModel.getCustomSkinModel()) != null) {
            bulletSkinModel = customModel.getBulletSkinModel();
        }
        if (bulletSkinModel == null) {
            bulletSkinModel = new BulletSkinModel();
        }
        if (this.orientation == 0) {
            borderIcon = bulletSkinModel.getHorizontalBorderIcon();
            effectsIcon = bulletSkinModel.getHorizontalEffectsIcon();
            indicatorIcon = bulletSkinModel.getHorizontalIndicatorIcon();
            indicatorCapIcon = bulletSkinModel.getHorizontalIndicatorCapIcon();
            targetIcon = bulletSkinModel.getHorizontalTargetIndicatorIcon();
            shadowIcon = bulletSkinModel.getHorizontalShadowIcon();
        } else {
            borderIcon = bulletSkinModel.getVerticalBorderIcon();
            effectsIcon = bulletSkinModel.getVerticalEffectsIcon();
            indicatorIcon = bulletSkinModel.getVerticalIndicatorIcon();
            indicatorCapIcon = bulletSkinModel.getVerticalIndicatorCapIcon();
            targetIcon = bulletSkinModel.getVerticalTargetIndicatorIcon();
            shadowIcon = bulletSkinModel.getVerticalShadowIcon();
        }
        Rectangle drawSpace = componentBounds.getBounds();
        double[] segmentValues = this.getSegmentValues();
        Rectangle2D.Double shadowSize = new Rectangle2D.Double(0.0, 0.0, shadowIcon.getIconWidth(), shadowIcon.getIconHeight());
        double scaleFactor = this.calculateSkinnableKPIChartScaleFactor(drawSpace, shadowSize);
        int minGraphWidth = 21;
        int minGraphHeight = 50;
        Insets textInsets = this.calculateSkinnableBulletGraphLabelInsets(gc, drawSpace, segmentValues, shadowIcon, effectsIcon, scaleFactor, minGraphWidth, minGraphHeight);
        drawSpace.width = drawSpace.width - textInsets.left - textInsets.right;
        drawSpace.height = drawSpace.height - textInsets.top - textInsets.bottom;
        drawSpace.x += textInsets.left;
        drawSpace.y += textInsets.top;
        if (this.orientation == 0) {
            if (drawSpace.width < minGraphHeight || drawSpace.height < minGraphWidth) {
                this.displayGraph = false;
                return;
            }
        } else if (drawSpace.height < minGraphHeight || drawSpace.width < minGraphWidth) {
            this.displayGraph = false;
            return;
        }
        scaleFactor = this.calculateSkinnableKPIChartScaleFactor(drawSpace, shadowSize);
        this.imageCache.setScaleFactor(scaleFactor);
        Rectangle2D.Double imageLayersPosition = new Rectangle2D.Double(0.0, 0.0, (drawSpace.getWidth() - shadowSize.width * scaleFactor) / 2.0, (drawSpace.getHeight() - shadowSize.height * scaleFactor) / 2.0);
        Rectangle2D.Double colorBandSize = new Rectangle2D.Double((shadowSize.getWidth() - (double)effectsIcon.getIconWidth()) / 2.0, (shadowSize.getHeight() - (double)effectsIcon.getIconHeight()) / 2.0, effectsIcon.getIconWidth(), effectsIcon.getIconHeight());
        KPIChartSegmentedRangeColorModel rangeModel = this.kpiRendererModel.getSegmentedRangeColorModel();
        double x = (double)drawSpace.x + imageLayersPosition.width;
        double y = (double)drawSpace.y + imageLayersPosition.height;
        Area[] origColorSegmentsArea = (Area[])this.imageCache.getSegmentsArea(rangeModel);
        if (origColorSegmentsArea == null) {
            origColorSegmentsArea = this.calculateSkinnableBulletGraphColorSegments(colorBandSize, segmentValues);
            this.imageCache.addSegmentsArea(origColorSegmentsArea, rangeModel);
        }
        AffineTransform scaleTransform = AffineTransform.getTranslateInstance(x, y);
        scaleTransform.scale(scaleFactor, scaleFactor);
        Area[] scaledColorSegmentsArea = new Area[origColorSegmentsArea.length];
        for (int i = 0; i < scaledColorSegmentsArea.length; ++i) {
            scaledColorSegmentsArea[i] = origColorSegmentsArea[i].createTransformedArea(scaleTransform);
        }
        Area scaledColorBandSize = new Area(colorBandSize).createTransformedArea(scaleTransform);
        int selectedIndex = Util.getRangeSegmentIndex(rangeModel, this.getCurrentValue());
        Line2D.Double[] tickmarkLines = null;
        if (this.showRangeLabels) {
            tickmarkLines = this.calculateSkinnableBulletGraphTickmarks(gc, new Dimension((int)(shadowSize.width * scaleFactor), (int)(shadowSize.height * scaleFactor)), scaledColorSegmentsArea, segmentValues, scaledColorBandSize);
            this.renderSkinnableBulletGraphTickmarksLayer(gc, tickmarkLines);
        }
        BufferedImage savedSegmentsImage = (BufferedImage)this.imageCache.getScaledImage("coloredSegmentsImage_", scaleFactor, rangeModel, selectedIndex);
        BufferedImage effectsImage = this.getScaledImage(effectsIcon, "effects_", rangeModel, scaleFactor);
        if (savedSegmentsImage == null) {
            savedSegmentsImage = KPIChartRenderer.newBufferedImage((int)shadowSize.width, (int)shadowSize.height);
            Graphics2D savedSegmentsGraphics = savedSegmentsImage.createGraphics();
            this.applyRenderingHints(savedSegmentsGraphics);
            this.renderSkinnableBulletGraphImageLayer(savedSegmentsGraphics, shadowSize, shadowIcon, imageLayersPosition);
            this.renderBulletGraphColorSegments(savedSegmentsGraphics, origColorSegmentsArea, false, false);
            savedSegmentsImage = KPIChartRenderer.getFastScaledImage(savedSegmentsImage, (int)((double)savedSegmentsImage.getWidth() * scaleFactor), (int)((double)savedSegmentsImage.getHeight() * scaleFactor));
            this.imageCache.addScaledImage(savedSegmentsImage, "coloredSegmentsImage_", scaleFactor, rangeModel, selectedIndex);
        }
        gc.drawImage((Image)savedSegmentsImage, (int)x, (int)y, null);
        this.renderSkinnableBulletGraphColorSegmentBoundaries(gc, scaledColorSegmentsArea);
        gc.drawImage((Image)effectsImage, (int)(x + imageLayersPosition.x + (shadowSize.width * scaleFactor - (double)effectsImage.getWidth()) / 2.0), (int)(y + imageLayersPosition.y + (shadowSize.height * scaleFactor - (double)effectsImage.getHeight()) / 2.0), null);
        BufferedImage indicatorCapImage = this.getScaledImage(indicatorCapIcon, "indicatorCap_", rangeModel, scaleFactor);
        BufferedImage targetImage = this.getScaledImage(targetIcon, "target_", rangeModel, scaleFactor);
        this.renderSkinnableBulletGraphIndicatorImageLayer(gc, colorBandSize, indicatorIcon.getImage(), indicatorCapImage, segmentValues, x, y, scaleFactor);
        this.renderSkinnableBulletGraphTargetIndicatorImageLayer(gc, colorBandSize, targetImage, segmentValues, x, y, scaleFactor);
        BufferedImage borderImage = this.getScaledImage(borderIcon, "border_", rangeModel, scaleFactor);
        gc.drawImage((Image)borderImage, (int)((double)drawSpace.x + drawSpace.getWidth() / 2.0 - (double)borderImage.getWidth() / 2.0), (int)((double)drawSpace.y + (double)drawSpace.height / 2.0 - (double)borderImage.getHeight() / 2.0), null);
        if (this.showRangeLabels) {
            gc.setColor(gc.getColor());
            gc.setFont(gc.getFont());
            this.renderSkinnableBulletGraphRangeLabelsLayer(gc, tickmarkLines, segmentValues);
        }
        double borderSizeHeightDifference = (double)(borderIcon.getIconHeight() - effectsIcon.getIconHeight()) / 2.0 * scaleFactor;
        double borderSizeWidthDifference = (double)(borderIcon.getIconWidth() - effectsIcon.getIconWidth()) / 2.0 * scaleFactor;
        double borderSizeHeight = (double)borderIcon.getIconHeight() * scaleFactor;
        double borderSizeWidth = (double)borderIcon.getIconWidth() * scaleFactor;
        Rectangle2D.Double bulletSize = null;
        bulletSize = this.orientation == 0 ? new Rectangle2D.Double(scaledColorBandSize.getBounds().getX() - borderSizeWidthDifference, scaledColorBandSize.getBounds().getY() - borderSizeHeightDifference, borderSizeWidth, borderSizeHeight) : new Rectangle2D.Double(scaledColorBandSize.getBounds().getX() - borderSizeWidthDifference, scaledColorBandSize.getBounds().getY() + borderSizeHeightDifference, borderSizeWidth, scaledColorBandSize.getBounds().getHeight());
        if (this.showValueLabel) {
            this.renderSkinnableBulletGraphValueLabelLayer(gc, bulletSize);
        }
    }

    private void renderSkinnableBulletGraphValueLabelLayer(Graphics2D gc, Rectangle2D bulletSize) {
        String valueLabel = this.getValueLabel(true);
        Font valueFont = this.kpiRendererModel.getActualValueTextStyle().getFont();
        gc.setFont(valueFont);
        FontRenderContext frc = gc.getFontRenderContext();
        Rectangle2D valueLabelBounds = valueFont.getStringBounds(valueLabel, frc);
        FontMetrics fm = gc.getFontMetrics();
        double fontHeight = fm.getHeight() - fm.getLeading();
        int xValue = (int)Math.round(bulletSize.getCenterX() - valueLabelBounds.getWidth() / 2.0);
        if (xValue < 0) {
            Rectangle b = this.getBounds();
            if (b.getWidth() < valueLabelBounds.getWidth()) {
                if (this.kpiRendererModel.isAdjustMagnitudeValueEnabled()) {
                    valueLabel = this.getValueLabel(false);
                    valueLabelBounds = valueFont.getStringBounds(valueLabel, frc);
                    xValue = Math.max(0, (int)Math.round(bulletSize.getCenterX() - valueLabelBounds.getWidth() / 2.0));
                }
                if (this.getBounds().getWidth() < valueLabelBounds.getWidth()) {
                    valueLabel = "*";
                    valueLabelBounds = valueFont.getStringBounds(valueLabel, frc);
                    xValue = Math.max(0, (int)Math.round(bulletSize.getCenterX() - valueLabelBounds.getWidth() / 2.0));
                }
            } else {
                xValue = 0;
            }
        }
        int valueSpace = 2;
        int yValue = this.orientation == 0 ? (int)Math.round(bulletSize.getY() - (double)fm.getDescent() - (double)valueSpace) : (int)Math.round(bulletSize.getY() + bulletSize.getHeight() + fontHeight + (double)valueSpace);
        gc.setColor(this.getValueTextStyleColor());
        gc.drawString(valueLabel, xValue, yValue);
    }

    private void renderSkinnableBulletGraphRangeLabelsLayer(Graphics2D gc, Line2D.Double[] tickmarkLines, double[] segmentValues) {
        NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
        actualVariable.init();
        Format formatter = actualVariable.getJavaFormat();
        if (formatter == null) {
            formatter = new DecimalFormat(new String("#0.##"));
        }
        Font labelsFont = this.kpiRendererModel.getRangeValueTextStyle().getFont();
        gc.setFont(labelsFont);
        FontRenderContext frc = gc.getFontRenderContext();
        FontMetrics fontMetrics = gc.getFontMetrics();
        double labelHeight = fontMetrics.getHeight() - fontMetrics.getLeading();
        gc.setColor(new Color(153, 153, 153));
        int tickmarkSpace = 2;
        gc.setColor(this.getRangeTextStyleColor());
        if (this.orientation == 0) {
            labelHeight -= (double)fontMetrics.getDescent();
            if (this.showMiddleRangeLabels) {
                for (int i = 0; i < tickmarkLines.length; ++i) {
                    if (tickmarkLines[i] == null) continue;
                    String label = this.formattedSegmentValues[i];
                    TextLayout labelLayout = new TextLayout(label, labelsFont, frc);
                    Rectangle2D labelBounds = labelsFont.createGlyphVector(frc, label).getVisualBounds();
                    double labelWidth = labelBounds.getWidth();
                    Line2D.Double tickmark = tickmarkLines[i];
                    int xValue = (int)(tickmark.getX1() - (double)((int)(labelWidth / 2.0)));
                    int yValue = (int)(tickmark.getY2() + (double)tickmarkSpace + labelHeight);
                    labelLayout.draw(gc, xValue, yValue);
                }
            } else {
                String label = this.formattedSegmentValues[0];
                TextLayout labelLayout = new TextLayout(label, labelsFont, frc);
                Rectangle2D labelBounds = labelsFont.createGlyphVector(frc, label).getVisualBounds();
                double labelWidth = labelBounds.getWidth();
                Line2D.Double tickmark = tickmarkLines[0];
                int xValue = (int)(tickmark.getX1() - (double)((int)(labelWidth / 2.0)));
                int yValue = (int)(tickmark.getY2() + (double)tickmarkSpace + labelHeight);
                labelLayout.draw(gc, xValue, yValue);
                label = this.formattedSegmentValues[segmentValues.length - 1];
                labelLayout = new TextLayout(label, labelsFont, frc);
                labelBounds = labelsFont.createGlyphVector(frc, label).getVisualBounds();
                labelWidth = labelBounds.getWidth();
                tickmark = tickmarkLines[segmentValues.length - 1];
                xValue = (int)(tickmark.getX1() - (double)((int)(labelWidth / 2.0)));
                yValue = (int)(tickmark.getY2() + (double)tickmarkSpace + labelHeight);
                labelLayout.draw(gc, xValue, yValue);
            }
        } else if (this.showMiddleRangeLabels) {
            for (int i = 0; i < tickmarkLines.length; ++i) {
                if (tickmarkLines[i] == null) continue;
                String label = this.formattedSegmentValues[i];
                TextLayout labelLayout = new TextLayout(label, labelsFont, frc);
                Line2D.Double tickmark = tickmarkLines[i];
                Point2D point = this.calculateVerticalCenterTextOrigin(labelLayout, new Point2D.Double(tickmark.x2, tickmark.y2), tickmarkSpace);
                labelLayout.draw(gc, (int)point.getX(), (int)point.getY());
            }
        } else {
            String label = this.formattedSegmentValues[0];
            TextLayout labelLayout = new TextLayout(label, labelsFont, frc);
            Line2D.Double tickmark = tickmarkLines[0];
            Point2D point = this.calculateVerticalCenterTextOrigin(labelLayout, new Point2D.Double(tickmark.x2, tickmark.y2), tickmarkSpace);
            labelLayout.draw(gc, (int)point.getX(), (int)point.getY());
            label = this.formattedSegmentValues[segmentValues.length - 1];
            labelLayout = new TextLayout(label, labelsFont, frc);
            tickmark = tickmarkLines[segmentValues.length - 1];
            point = this.calculateVerticalCenterTextOrigin(labelLayout, new Point2D.Double(tickmark.x2, tickmark.y2), tickmarkSpace);
            labelLayout.draw(gc, (int)point.getX(), (int)point.getY());
        }
    }

    private Point2D calculateVerticalCenterTextOrigin(TextLayout textLayout, Point2D point, int spacing) {
        Rectangle2D textBounds = textLayout.getBounds();
        double y = point.getY() - textBounds.getMinY() - 0.5 * textBounds.getHeight();
        double x = point.getX() + (double)spacing;
        return new Point2D.Double(x, y);
    }

    private void renderSkinnableBulletGraphTargetIndicatorImageLayer(Graphics2D gc, Rectangle2D.Double colorBandSize, BufferedImage targetImage, double[] segmentValues, double x, double y, double scaleFactor) {
        double colorBandWidth = colorBandSize.getWidth() * scaleFactor;
        double colorBandHeight = colorBandSize.getHeight() * scaleFactor;
        double colorBandX = colorBandSize.getMinX() * scaleFactor;
        double colorBandY = colorBandSize.getMaxY() * scaleFactor;
        double indicatorWidth = targetImage.getWidth();
        double indicatorHeight = targetImage.getHeight();
        int numRange = segmentValues.length - 1;
        double value0 = segmentValues[0];
        double valueN = segmentValues[numRange];
        double delta = valueN - value0;
        NumericVariable targetVariable = this.kpiRendererModel.getTargetVariable();
        if (targetVariable == null) {
            return;
        }
        double rvValue = 0.0;
        targetVariable.init();
        try {
            rvValue = targetVariable.value.getValue(0);
        }
        catch (Exception e) {
            return;
        }
        this.isTargetOutOfBounds(rvValue, segmentValues);
        double relativePosition = Math.min(Math.max((rvValue - value0) / delta, 0.0), 1.0);
        if (this.orientation == 0) {
            double targetPosition = colorBandWidth * relativePosition - indicatorWidth / 2.0;
            gc.drawImage((Image)targetImage, (int)(colorBandX + targetPosition + x), (int)y, null);
        } else {
            double targetPosition = colorBandHeight * relativePosition + indicatorHeight / 2.0;
            gc.drawImage((Image)targetImage, (int)x, (int)(colorBandY - targetPosition + y), null);
        }
    }

    private void renderSkinnableBulletGraphColorSegmentBoundaries(Graphics2D gc, Area[] colorSegmentsArea) {
        gc.setColor(new Color(102, 102, 102));
        if (this.orientation == 0) {
            for (int i = 0; i < colorSegmentsArea.length - 1; ++i) {
                if (colorSegmentsArea[i].isEmpty()) continue;
                Rectangle2D segmentBounds = colorSegmentsArea[i].getBounds2D();
                Line2D.Double boundaryLine = new Line2D.Double(segmentBounds.getMaxX(), segmentBounds.getMinY(), segmentBounds.getMaxX(), segmentBounds.getMaxY());
                gc.draw(boundaryLine);
            }
        } else {
            for (int i = 0; i < colorSegmentsArea.length - 1; ++i) {
                if (colorSegmentsArea[i].isEmpty()) continue;
                Rectangle2D segmentBounds = colorSegmentsArea[i].getBounds2D();
                Line2D.Double boundaryLine = new Line2D.Double(segmentBounds.getMinX(), segmentBounds.getMinY(), segmentBounds.getMaxX(), segmentBounds.getMinY());
                gc.draw(boundaryLine);
            }
        }
    }

    private void renderSkinnableBulletGraphIndicatorImageLayer(Graphics2D gc, Rectangle2D.Double colorBandSize, Image indicatorImage, BufferedImage scaledIndicatorCapImage, double[] segmentValues, double x, double y, double scaleFactor) {
        int numRange = segmentValues.length - 1;
        double value0 = segmentValues[0];
        double valueN = segmentValues[numRange];
        double delta = valueN - value0;
        double rvValue = 0.0;
        NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
        actualVariable.init();
        try {
            rvValue = actualVariable.value.getValue(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        double relativePosition = Math.min(Math.max((rvValue - value0) / delta, 0.0), 1.0);
        if (this.orientation == 0) {
            int indicatorWidth;
            double colorBandWidth = colorBandSize.getWidth() * scaleFactor;
            int indicatorHeight = (int)((double)indicatorImage.getHeight(null) * scaleFactor);
            int indicatorWithoutCapWidth = indicatorWidth = (int)(colorBandWidth * relativePosition);
            int indicatorCapWidth = 0;
            if (scaledIndicatorCapImage != null) {
                indicatorCapWidth = scaledIndicatorCapImage.getWidth();
                indicatorWithoutCapWidth = Math.max(0, indicatorWidth - indicatorCapWidth);
            }
            if (Math.ceil(indicatorWidth) <= 0.0) {
                return;
            }
            BufferedImage scaledIndicatorImage = KPIChartRenderer.newBufferedImage(indicatorImage.getWidth(null), indicatorImage.getHeight(null));
            scaledIndicatorImage.createGraphics().drawImage(indicatorImage, 0, 0, null);
            scaledIndicatorImage = KPIChartRenderer.getFastScaledImage(scaledIndicatorImage, indicatorWithoutCapWidth, indicatorHeight);
            gc.drawImage((Image)scaledIndicatorImage, (int)(colorBandSize.x * scaleFactor + x), (int)y, null);
            if (scaledIndicatorCapImage != null) {
                gc.drawImage((Image)scaledIndicatorCapImage, (int)(colorBandSize.x * scaleFactor + (double)indicatorWithoutCapWidth + x), (int)y, null);
            }
        } else {
            int indicatorHeight;
            double colorBandHeight = colorBandSize.getHeight() * scaleFactor;
            int indicatorWidth = (int)((double)indicatorImage.getWidth(null) * scaleFactor);
            int indicatorWithoutCapHeight = indicatorHeight = (int)(colorBandHeight * relativePosition);
            int indicatorCapHeight = 0;
            if (scaledIndicatorCapImage != null) {
                indicatorCapHeight = scaledIndicatorCapImage.getHeight();
                indicatorWithoutCapHeight = Math.max(0, indicatorHeight - indicatorCapHeight);
            }
            if (Math.ceil(indicatorHeight) <= 0.0) {
                return;
            }
            BufferedImage scaledIndicatorImage = KPIChartRenderer.newBufferedImage(indicatorImage.getWidth(null), indicatorImage.getHeight(null));
            scaledIndicatorImage.createGraphics().drawImage(indicatorImage, 0, 0, null);
            scaledIndicatorImage = KPIChartRenderer.getFastScaledImage(scaledIndicatorImage, indicatorWidth, indicatorWithoutCapHeight);
            int startY = (int)((colorBandSize.y + colorBandSize.height) * scaleFactor + y);
            gc.drawImage((Image)scaledIndicatorImage, (int)x, startY - indicatorWithoutCapHeight, null);
            if (scaledIndicatorCapImage != null) {
                gc.drawImage((Image)scaledIndicatorCapImage, (int)x, startY - indicatorHeight, null);
            }
        }
    }

    private void renderSkinnableBulletGraphImageLayer(Graphics2D gc, Rectangle2D.Double areaSize, ImageIcon imageIcon, Rectangle2D.Double imageLayersPosition) {
        Rectangle imageSize = new Rectangle(imageIcon.getIconWidth(), imageIcon.getIconHeight());
        gc.drawImage(imageIcon.getImage(), (int)(imageLayersPosition.x + (areaSize.width - (double)imageSize.width) / 2.0), (int)(imageLayersPosition.y + (areaSize.height - (double)imageSize.height) / 2.0), null);
    }

    private void renderSkinnableBulletGraphTickmarksLayer(Graphics2D gc, Line2D.Double[] tickmarkLines) {
        gc.setColor(new Color(153, 153, 153));
        if (!this.showMiddleRangeLabels && tickmarkLines.length > 0) {
            gc.draw(tickmarkLines[0]);
            gc.draw(tickmarkLines[tickmarkLines.length - 1]);
        } else {
            for (int i = 0; i < tickmarkLines.length; ++i) {
                if (tickmarkLines[i] == null) continue;
                gc.draw(tickmarkLines[i]);
            }
        }
    }

    private Line2D.Double[] calculateSkinnableBulletGraphTickmarks(Graphics2D gc, Dimension shadowSize, Area[] colorSegmentsArea, double[] segmentValues, Area scaledColorBandSize) {
        return this.calculateSkinnableBulletGraphTickmarks(gc, shadowSize, colorSegmentsArea, segmentValues, scaledColorBandSize.getBounds2D());
    }

    private Line2D.Double[] calculateSkinnableBulletGraphTickmarks(Graphics2D gc, Dimension shadowSize, Area[] colorSegmentsArea, double[] segmentValues, Rectangle2D colorBandSize) {
        return this.calculateSkinnableBulletGraphTickmarks(gc, shadowSize.getWidth(), shadowSize.getHeight(), colorSegmentsArea, segmentValues, colorBandSize);
    }

    private Insets calculateSkinnableBulletGraphLabelInsets(Graphics2D gc, Rectangle drawSpace, double[] segmentValues, ImageIcon shadowIcon, ImageIcon effectsIcon, double scaleFactor, int minGraphWidth, int minGraphHeight) {
        Insets textInsets = new Insets(0, 0, 0, 0);
        NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
        actualVariable.init();
        Format formatter = actualVariable.getJavaFormat();
        if (formatter == null) {
            formatter = new DecimalFormat(new String("#0.##"));
        }
        if (this.showRangeLabels) {
            Font labelsFont = this.kpiRendererModel.getRangeValueTextStyle().getFont();
            gc.setFont(labelsFont);
            FontMetrics fontMetrics = gc.getFontMetrics();
            String firstRangeLabel = this.formattedSegmentValues[0];
            String lastRangeLabel = this.formattedSegmentValues[segmentValues.length - 1];
            int firstLabelWidth = fontMetrics.stringWidth(firstRangeLabel);
            int lastLabelWidth = fontMetrics.stringWidth(lastRangeLabel);
            int labelHeight = fontMetrics.getHeight() - fontMetrics.getLeading();
            if (this.orientation == 0) {
                textInsets.bottom = labelHeight + 2;
                double horizontalOverhang = scaleFactor * ((double)(shadowIcon.getIconWidth() - effectsIcon.getIconWidth()) / 2.0);
                textInsets.left = 1 + (int)Math.round(Math.max(0.0, -(horizontalOverhang - (double)firstLabelWidth / 2.0)));
                textInsets.right = 1 + (int)Math.round(Math.max(0.0, -(horizontalOverhang - (double)lastLabelWidth / 2.0)));
                if (drawSpace.height - textInsets.bottom < minGraphWidth) {
                    this.showRangeLabels = false;
                    textInsets.bottom = 0;
                    textInsets.left = 0;
                    textInsets.right = 0;
                } else if (drawSpace.width - textInsets.left - textInsets.right < minGraphHeight) {
                    this.showRangeLabels = false;
                    textInsets.bottom = 0;
                    textInsets.left = 0;
                    textInsets.right = 0;
                }
            } else {
                int rightRangeLabelBuffer = Math.max(firstLabelWidth, lastLabelWidth);
                gc.setFont(labelsFont);
                fontMetrics = gc.getFontMetrics();
                for (int i = 0; i < segmentValues.length - 1; ++i) {
                    String rangeLabel = this.formattedSegmentValues[i];
                    int thisLabelWidth = fontMetrics.stringWidth(rangeLabel);
                    rightRangeLabelBuffer = (int)Math.ceil(Math.max(rightRangeLabelBuffer, thisLabelWidth));
                }
                textInsets.right = rightRangeLabelBuffer + 2;
                FontRenderContext frc = gc.getFontRenderContext();
                Rectangle2D firstLabelBounds = labelsFont.createGlyphVector(frc, firstRangeLabel).getVisualBounds();
                Rectangle2D lastLabelBounds = labelsFont.createGlyphVector(frc, lastRangeLabel).getVisualBounds();
                double verticalOverhang = scaleFactor * ((double)(shadowIcon.getIconHeight() - effectsIcon.getIconHeight()) / 2.0);
                textInsets.top = textInsets.top + 2 + (int)Math.round(Math.max(0.0, -(verticalOverhang - firstLabelBounds.getHeight() / 2.0)));
                textInsets.bottom = textInsets.bottom + 2 + (int)Math.round(Math.max(0.0, -(verticalOverhang - lastLabelBounds.getHeight() / 2.0)));
                if (drawSpace.width - textInsets.right < minGraphWidth) {
                    this.showRangeLabels = false;
                    textInsets.bottom = 0;
                    textInsets.right = 0;
                    textInsets.top = 0;
                } else if (drawSpace.height - textInsets.top - textInsets.bottom < minGraphHeight) {
                    this.showRangeLabels = false;
                    textInsets.top = 0;
                    textInsets.bottom = 0;
                    textInsets.right = 0;
                }
            }
        }
        if (this.showValueLabel) {
            int valuePadding = 3;
            Font valueFont = this.kpiRendererModel.getActualValueTextStyle().getFont();
            gc.setFont(valueFont);
            FontMetrics fontMetrics = gc.getFontMetrics();
            int valueHeight = fontMetrics.getHeight() - fontMetrics.getLeading();
            if (this.orientation == 0) {
                textInsets.top = textInsets.top + valueHeight + valuePadding;
                if (drawSpace.height - textInsets.top - textInsets.bottom < minGraphWidth) {
                    if (this.showRangeLabels) {
                        this.showRangeLabels = false;
                        textInsets.bottom = 0;
                        textInsets.left = 0;
                        textInsets.right = 0;
                        textInsets.top = valueHeight + valuePadding;
                        if (drawSpace.height - textInsets.top < minGraphWidth) {
                            this.showValueLabel = false;
                            textInsets.top = 0;
                        }
                    } else {
                        this.showValueLabel = false;
                        textInsets.top = 0;
                    }
                }
            } else {
                valuePadding = 5;
                textInsets.bottom = textInsets.bottom + valueHeight + valuePadding;
                if (drawSpace.height - textInsets.top - textInsets.bottom < minGraphHeight) {
                    if (this.showRangeLabels) {
                        this.showRangeLabels = false;
                        textInsets.top = 0;
                        textInsets.left = 0;
                        textInsets.right = 0;
                        textInsets.bottom = valueHeight + valuePadding;
                        if (drawSpace.height - textInsets.bottom < minGraphHeight) {
                            this.showValueLabel = false;
                            textInsets.bottom = 0;
                        }
                    } else {
                        this.showValueLabel = false;
                        textInsets.bottom = 0;
                    }
                }
            }
        }
        return textInsets;
    }

    private Area[] calculateSkinnableBulletGraphColorSegments(Rectangle2D.Double colorBandSize, double[] segmentValues) {
        int numSegments = segmentValues.length - 1;
        Area[] colorSegmentsArea = new Area[numSegments];
        double colorBandWidth = colorBandSize.getWidth();
        double colorBandHeight = colorBandSize.getHeight();
        double value0 = segmentValues[0];
        double valueN = segmentValues[numSegments];
        double delta = valueN - value0;
        double xStart = colorBandSize.getX();
        double yStart = colorBandSize.getY();
        double xEnd = colorBandSize.getMaxX();
        double yEnd = colorBandSize.getMaxY();
        if (this.orientation == 0) {
            for (int i = 0; i < numSegments; ++i) {
                valueN = segmentValues[i + 1];
                double relativeWidth = (valueN - value0) / delta;
                xEnd = Math.min(colorBandSize.getMinX() + relativeWidth * colorBandWidth, colorBandSize.getMaxX());
                Rectangle2D.Double currentSegment = new Rectangle2D.Double(xStart, yStart, xEnd - xStart, yEnd - yStart);
                colorSegmentsArea[i] = new Area(currentSegment);
                xStart = xEnd;
            }
        } else {
            for (int i = 0; i < numSegments; ++i) {
                valueN = segmentValues[i + 1];
                double relativeHeight = (valueN - value0) / delta;
                yStart = Math.max(colorBandSize.getMaxY() - relativeHeight * colorBandHeight, colorBandSize.getMinY());
                Rectangle2D.Double currentSegment = new Rectangle2D.Double(xStart, yStart, xEnd - xStart, yEnd - yStart);
                colorSegmentsArea[i] = new Area(currentSegment);
                yEnd = yStart;
            }
        }
        return colorSegmentsArea;
    }

    private double calculateSkinnableKPIChartScaleFactor(Rectangle drawSpace, Rectangle2D.Double imageSize) {
        if (this.isUseFullSpace) {
            double widthRatio = (double)drawSpace.width / imageSize.width;
            double heightRatio = (double)drawSpace.height / imageSize.height;
            double minRatio = Math.min(widthRatio, heightRatio);
            return minRatio - minRatio * 0.05;
        }
        double scaleFactor = 1.0;
        if ((double)drawSpace.height > imageSize.height && (double)drawSpace.width > imageSize.width) {
            return scaleFactor;
        }
        if ((double)drawSpace.height < imageSize.height) {
            scaleFactor = (double)drawSpace.height / imageSize.height;
        }
        if ((double)drawSpace.width < imageSize.width * scaleFactor) {
            scaleFactor = (double)drawSpace.width / imageSize.width;
        }
        return scaleFactor;
    }

    private void paintSkinnableSlider(Graphics2D gc, Rectangle componentBounds) {
        int padding;
        double borderSize;
        KPIChartCustomSkinModel customSkinModel;
        RendererUtil.Skin skin = this.kpiRendererModel.getSkin();
        NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
        actualVariable.init();
        ImageIcon borderIcon = null;
        ImageIcon effectsIcon = null;
        ImageIcon indicatorIcon = null;
        ImageIcon indicatorTintIcon = null;
        ImageIcon targetIcon = null;
        ImageIcon shadowIcon = null;
        SliderSkinModel sliderSkinModel = null;
        if (skin == RendererUtil.Skin.CUSTOM && (customSkinModel = this.kpiRendererModel.getCustomSkinModel()) != null) {
            sliderSkinModel = customSkinModel.getSliderSkinModel();
        }
        if (sliderSkinModel == null) {
            sliderSkinModel = new SliderSkinModel();
        }
        if (this.orientation == 0) {
            borderIcon = sliderSkinModel.getHorizontalBorderIcon();
            effectsIcon = sliderSkinModel.getHorizontalEffectsIcon();
            indicatorIcon = sliderSkinModel.getHorizontalIndicatorIcon();
            indicatorTintIcon = sliderSkinModel.getHorizontalTintedIndicatorIcon();
            targetIcon = sliderSkinModel.getHorizontalTargetIndicatorIcon();
            shadowIcon = sliderSkinModel.getHorizontalShadowIcon();
        } else {
            borderIcon = sliderSkinModel.getVerticalBorderIcon();
            effectsIcon = sliderSkinModel.getVerticalEffectsIcon();
            indicatorIcon = sliderSkinModel.getVerticalIndicatorIcon();
            indicatorTintIcon = sliderSkinModel.getVerticalTintedIndicatorIcon();
            targetIcon = sliderSkinModel.getVerticalTargetIndicatorIcon();
            shadowIcon = sliderSkinModel.getVerticalShadowIcon();
        }
        Rectangle drawSpace = componentBounds.getBounds();
        double[] segmentValues = this.getSegmentValues();
        Rectangle2D.Double shadowSize = new Rectangle2D.Double(0.0, 0.0, shadowIcon.getIconWidth(), shadowIcon.getIconHeight());
        Rectangle2D.Double bufferedImageSize = new Rectangle2D.Double(0.0, 0.0, Math.max((double)indicatorIcon.getIconWidth(), shadowSize.width), Math.max((double)indicatorIcon.getIconHeight(), shadowSize.height));
        if (this.orientation == 0) {
            borderSize = (shadowSize.width - (double)effectsIcon.getIconWidth()) / 2.0;
            double halfIndicatorWidth = (double)indicatorIcon.getIconWidth() / 2.0;
            padding = (int)Math.ceil(Math.max(0.0, halfIndicatorWidth - borderSize));
            bufferedImageSize.width += (double)padding * 2.0;
            bufferedImageSize.x = padding;
            bufferedImageSize.y = (double)indicatorIcon.getIconHeight() - shadowSize.height;
        } else {
            borderSize = (shadowSize.height - (double)effectsIcon.getIconHeight()) / 2.0;
            double halfIndicatorHeight = (double)indicatorIcon.getIconHeight() / 2.0;
            padding = (int)Math.ceil(Math.max(0.0, halfIndicatorHeight - borderSize));
            bufferedImageSize.height += (double)padding * 2.0;
            bufferedImageSize.y = padding;
            bufferedImageSize.x = (double)indicatorIcon.getIconWidth() - shadowSize.width;
        }
        double scaleFactor = this.calculateSkinnableKPIChartScaleFactor(drawSpace, bufferedImageSize);
        int minGraphWidth = 21;
        int minGraphHeight = 50;
        Insets textInsets = this.calculateSkinnableBulletGraphLabelInsets(gc, drawSpace, segmentValues, shadowIcon, effectsIcon, scaleFactor, minGraphWidth, minGraphHeight);
        drawSpace.width = drawSpace.width - textInsets.left - textInsets.right;
        drawSpace.height = drawSpace.height - textInsets.top - textInsets.bottom;
        drawSpace.x += textInsets.left;
        drawSpace.y += textInsets.top;
        if (this.orientation == 0) {
            if (drawSpace.width < minGraphHeight || drawSpace.height < minGraphWidth) {
                this.displayGraph = false;
                return;
            }
        } else if (drawSpace.height < minGraphHeight || drawSpace.width < minGraphWidth) {
            this.displayGraph = false;
            return;
        }
        scaleFactor = this.calculateSkinnableKPIChartScaleFactor(drawSpace, bufferedImageSize);
        this.imageCache.setScaleFactor(scaleFactor);
        Rectangle2D.Double scaledBufferedImageSize = new Rectangle2D.Double(bufferedImageSize.x * scaleFactor, bufferedImageSize.y * scaleFactor, bufferedImageSize.width * scaleFactor, bufferedImageSize.height * scaleFactor);
        Rectangle2D.Double scaledImageLayersPosition = new Rectangle2D.Double(scaledBufferedImageSize.x, scaledBufferedImageSize.y, (drawSpace.getWidth() - scaledBufferedImageSize.width) / 2.0, (drawSpace.getHeight() - scaledBufferedImageSize.height) / 2.0);
        Rectangle2D.Double imageLayersPosition = new Rectangle2D.Double(bufferedImageSize.x, bufferedImageSize.y, scaledImageLayersPosition.width / scaleFactor, scaledImageLayersPosition.height / scaleFactor);
        Rectangle2D.Double colorBandSize = new Rectangle2D.Double((shadowSize.getWidth() - (double)effectsIcon.getIconWidth()) / 2.0 + imageLayersPosition.x, imageLayersPosition.y + (shadowSize.getHeight() - (double)effectsIcon.getIconHeight()) / 2.0, effectsIcon.getIconWidth(), effectsIcon.getIconHeight());
        KPIChartSegmentedRangeColorModel rangeModel = this.kpiRendererModel.getSegmentedRangeColorModel();
        Area[] origColorSegmentsArea = (Area[])this.imageCache.getSegmentsArea(rangeModel);
        if (origColorSegmentsArea == null) {
            origColorSegmentsArea = this.calculateSkinnableBulletGraphColorSegments(colorBandSize, segmentValues);
            this.imageCache.addSegmentsArea(origColorSegmentsArea, rangeModel);
        }
        double x = (double)drawSpace.x + scaledImageLayersPosition.width;
        double y = (double)drawSpace.y + scaledImageLayersPosition.height;
        AffineTransform scaleTransform = AffineTransform.getTranslateInstance(x, y);
        scaleTransform.scale(scaleFactor, scaleFactor);
        Area[] scaledColorSegmentsArea = new Area[origColorSegmentsArea.length];
        for (int i = 0; i < scaledColorSegmentsArea.length; ++i) {
            scaledColorSegmentsArea[i] = origColorSegmentsArea[i].createTransformedArea(scaleTransform);
        }
        Area scaledColorBandSize = new Area(colorBandSize).createTransformedArea(scaleTransform);
        int selectedIndex = Util.getRangeSegmentIndex(rangeModel, this.getCurrentValue());
        Image savedSegmentsImage = this.imageCache.getScaledImage("coloredSegmentsImage_", scaleFactor, rangeModel, selectedIndex);
        BufferedImage effectsImage = this.getScaledImage(effectsIcon, "effects_", rangeModel, scaleFactor);
        Line2D.Double[] tickmarkLines = this.calculateSkinnableBulletGraphTickmarks(gc, shadowSize.width * scaleFactor, shadowSize.height * scaleFactor, scaledColorSegmentsArea, segmentValues, scaledColorBandSize.getBounds2D());
        this.renderSkinnableBulletGraphTickmarksLayer(gc, tickmarkLines);
        if (savedSegmentsImage == null) {
            savedSegmentsImage = KPIChartRenderer.newBufferedImage((int)bufferedImageSize.width, (int)bufferedImageSize.height);
            Graphics2D savedSegmentsGraphics = ((BufferedImage)savedSegmentsImage).createGraphics();
            this.applyRenderingHints(savedSegmentsGraphics);
            this.renderSkinnableBulletGraphImageLayer(savedSegmentsGraphics, shadowSize, shadowIcon, imageLayersPosition);
            this.renderBulletGraphColorSegments(savedSegmentsGraphics, origColorSegmentsArea, false, false);
            savedSegmentsImage = KPIChartRenderer.getFastScaledImage((BufferedImage)savedSegmentsImage, (int)scaledBufferedImageSize.width, (int)scaledBufferedImageSize.height);
            this.imageCache.addScaledImage(savedSegmentsImage, "coloredSegmentsImage_", scaleFactor, rangeModel, selectedIndex);
        }
        gc.drawImage(savedSegmentsImage, (int)(x + 0.5), (int)(y + 0.5), null);
        this.renderSkinnableBulletGraphColorSegmentBoundaries(gc, scaledColorSegmentsArea);
        double effectsX = x + scaledImageLayersPosition.x + (shadowSize.width * scaleFactor - (double)effectsImage.getWidth()) / 2.0;
        double effectsY = y + scaledImageLayersPosition.y + (shadowSize.height * scaleFactor - (double)effectsImage.getHeight()) / 2.0;
        gc.drawImage((Image)effectsImage, (int)(effectsX + 0.5), (int)(effectsY + 0.5), null);
        BufferedImage targetImage = this.getScaledImage(targetIcon, "target_", rangeModel, scaleFactor);
        this.renderSkinnableBulletGraphTargetIndicatorImageLayer(gc, colorBandSize, targetImage, segmentValues, x, y, scaleFactor);
        BufferedImage borderImage = (BufferedImage)this.imageCache.getScaledImage("border_", scaleFactor, rangeModel);
        if (borderImage == null) {
            borderImage = KPIChartRenderer.newBufferedImage((int)bufferedImageSize.width, (int)bufferedImageSize.height);
            Graphics2D borderGraphics = borderImage.createGraphics();
            this.applyRenderingHints(borderGraphics);
            this.renderSkinnableBulletGraphImageLayer(borderGraphics, shadowSize, borderIcon, imageLayersPosition);
            borderGraphics.dispose();
            borderImage = KPIChartRenderer.getFastScaledImage(borderImage, (int)scaledBufferedImageSize.width, (int)scaledBufferedImageSize.height);
            this.imageCache.addScaledImage((Image)borderImage, "border_", scaleFactor, rangeModel);
        }
        gc.drawImage((Image)borderImage, (int)(x + 0.5), (int)(y + 0.5), null);
        this.renderSkinnableSliderIndicatorImageLayer(gc, colorBandSize, indicatorIcon, indicatorTintIcon, segmentValues, x, y, scaleFactor, selectedIndex);
        if (this.showRangeLabels) {
            this.renderSkinnableBulletGraphRangeLabelsLayer(gc, tickmarkLines, segmentValues);
        }
        double borderSizeHeightDifference = (double)(borderIcon.getIconHeight() - effectsIcon.getIconHeight()) / 2.0 * scaleFactor;
        double borderSizeWidthDifference = (double)(borderIcon.getIconWidth() - effectsIcon.getIconWidth()) / 2.0 * scaleFactor;
        double borderSizeHeight = (double)borderIcon.getIconHeight() * scaleFactor;
        double borderSizeWidth = (double)borderIcon.getIconWidth() * scaleFactor;
        Rectangle2D.Double bulletSize = null;
        bulletSize = this.orientation == 0 ? new Rectangle2D.Double(scaledColorBandSize.getBounds().getX() - borderSizeWidthDifference, scaledColorBandSize.getBounds().getY() - (borderSizeHeightDifference += scaleFactor * (double)(indicatorIcon.getIconHeight() - borderIcon.getIconHeight())), borderSizeWidth, borderSizeHeight) : new Rectangle2D.Double(scaledColorBandSize.getBounds().getX() - borderSizeWidthDifference, scaledColorBandSize.getBounds().getY() + borderSizeHeightDifference, borderSizeWidth, scaledColorBandSize.getBounds().getHeight());
        if (this.showValueLabel) {
            this.renderSkinnableBulletGraphValueLabelLayer(gc, bulletSize);
        }
    }

    private void renderSkinnableSliderIndicatorImageLayer(Graphics2D gc, Rectangle2D.Double colorBandSize, ImageIcon indicatorIcon, ImageIcon indicatorTintIcon, double[] segmentValues, double x, double y, double scaleFactor, int selectedIndex) {
        double colorBandWidth = colorBandSize.getWidth() * scaleFactor;
        double colorBandHeight = colorBandSize.getHeight() * scaleFactor;
        KPIChartSegmentedRangeColorModel rangeModel = this.kpiRendererModel.getSegmentedRangeColorModel();
        NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
        if (actualVariable == null) {
            return;
        }
        double rvValue = 0.0;
        actualVariable.init();
        try {
            rvValue = actualVariable.value.getValue(0);
        }
        catch (Exception e) {
            return;
        }
        Color tintColor = Util.getRangeSegmentColor(rangeModel, rvValue, true);
        BufferedImage indicatorImage = this.createIndicatorImage(indicatorIcon, indicatorTintIcon, tintColor, segmentValues, rangeModel, scaleFactor, selectedIndex);
        int numRange = segmentValues.length - 1;
        double value0 = segmentValues[0];
        double valueN = segmentValues[numRange];
        double delta = valueN - value0;
        double relativePosition = Math.min(Math.max((rvValue - value0) / delta, 0.0), 1.0);
        if (this.orientation == 0) {
            double targetPosition = colorBandWidth * relativePosition - (double)indicatorImage.getWidth() / 2.0;
            gc.drawImage((Image)indicatorImage, (int)(colorBandSize.getMinX() * scaleFactor + targetPosition + x + 0.5), (int)(y + 0.5), null);
        } else {
            double targetPosition = colorBandHeight * relativePosition + (double)indicatorImage.getHeight() / 2.0;
            gc.drawImage((Image)indicatorImage, (int)(x + 0.5), (int)(colorBandSize.getMaxY() * scaleFactor - targetPosition + y + 0.5), null);
        }
    }

    private BufferedImage createIndicatorImage(ImageIcon indicatorIcon, ImageIcon indicatorTintIcon, Color tintColor, double[] segmentValues, KPIChartSegmentedRangeColorModel rangeModel, double scaleFactor, int selectedIndex) {
        BufferedImage image = (BufferedImage)this.imageCache.getScaledImage("indicatorComposite_", scaleFactor, rangeModel, selectedIndex);
        if (image == null) {
            int indicatorWidth = indicatorIcon.getIconWidth();
            int indicatorHeight = indicatorIcon.getIconHeight();
            image = KPIChartRenderer.newBufferedImage(indicatorWidth, indicatorHeight);
            Graphics2D graphics = image.createGraphics();
            if (indicatorTintIcon != null) {
                BufferedImage newTintImage = KPIChartRenderer.newBufferedImage(indicatorWidth, indicatorHeight);
                newTintImage.getGraphics().drawImage(indicatorTintIcon.getImage(), 0, 0, null);
                Image tintImage = this.changeColor(newTintImage, tintColor);
                graphics.drawImage(tintImage, 0, 0, null);
            }
            graphics.drawImage(indicatorIcon.getImage(), 0, 0, null);
            graphics.dispose();
            image = KPIChartRenderer.getFastScaledImage(image, (int)((double)indicatorWidth * scaleFactor), (int)((double)indicatorHeight * scaleFactor));
            this.imageCache.addScaledImage(image, "indicatorComposite_", scaleFactor, rangeModel, selectedIndex);
        }
        return image;
    }

    private Line2D.Double[] calculateSkinnableBulletGraphTickmarks(Graphics2D gc, double shadowWidth, double shadowHeight, Area[] colorSegmentsArea, double[] segmentValues, Rectangle2D colorBandSize) {
        this.showMiddleRangeLabels = true;
        Line2D.Double[] tickmarks = new Line2D.Double[colorSegmentsArea.length + 1];
        NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
        actualVariable.init();
        Format formatter = actualVariable.getJavaFormat();
        if (formatter == null) {
            formatter = new DecimalFormat(new String("#0.##"));
        }
        Font labelsFont = this.kpiRendererModel.getRangeValueTextStyle().getFont();
        gc.setFont(labelsFont);
        FontRenderContext frc = gc.getFontRenderContext();
        if (this.orientation == 0) {
            double tickmarkLength = (shadowHeight - colorBandSize.getHeight()) / 2.0;
            for (int i = 0; i < colorSegmentsArea.length; ++i) {
                if (this.isNextSegmentEqual(segmentValues, i)) continue;
                Area colorSegment = colorSegmentsArea[i];
                if (colorSegment.isEmpty()) {
                    this.showMiddleRangeLabels = false;
                    continue;
                }
                Rectangle2D segmentBounds = colorSegment.getBounds2D();
                tickmarks[i] = new Line2D.Double(segmentBounds.getMinX(), segmentBounds.getMaxY(), segmentBounds.getMinX(), segmentBounds.getMaxY() + tickmarkLength);
                this.showMiddleRangeLabels = this.showMiddleRangeLabels && !(segmentBounds.getWidth() < labelsFont.createGlyphVector(frc, this.formattedSegmentValues[i]).getVisualBounds().getWidth() / 2.0 + labelsFont.createGlyphVector(frc, this.formattedSegmentValues[i + 1]).getVisualBounds().getWidth() / 2.0);
            }
            if (!this.showMiddleRangeLabels) {
                tickmarks[0] = new Line2D.Double(colorBandSize.getMinX(), colorBandSize.getMaxY(), colorBandSize.getMinX(), colorBandSize.getMaxY() + tickmarkLength);
            }
            tickmarks[tickmarks.length - 1] = new Line2D.Double(colorBandSize.getMaxX(), colorBandSize.getMaxY(), colorBandSize.getMaxX(), colorBandSize.getMaxY() + tickmarkLength);
        } else {
            double tickmarkLength = (shadowWidth - colorBandSize.getWidth()) / 2.0;
            for (int i = 0; i < colorSegmentsArea.length; ++i) {
                if (this.isNextSegmentEqual(segmentValues, i)) continue;
                Area colorSegment = colorSegmentsArea[i];
                if (colorSegment.isEmpty()) {
                    this.showMiddleRangeLabels = false;
                    continue;
                }
                Rectangle2D segmentBounds = colorSegment.getBounds2D();
                tickmarks[i] = new Line2D.Double(segmentBounds.getMaxX(), segmentBounds.getMaxY(), segmentBounds.getMaxX() + tickmarkLength, segmentBounds.getMaxY());
                this.showMiddleRangeLabels = this.showMiddleRangeLabels && !(segmentBounds.getHeight() < labelsFont.createGlyphVector(frc, this.formattedSegmentValues[i]).getVisualBounds().getHeight() / 2.0 + labelsFont.createGlyphVector(frc, formatter.format(new Double(segmentValues[i + 1] / this.factor)).trim()).getVisualBounds().getHeight() / 2.0);
            }
            if (!this.showMiddleRangeLabels) {
                tickmarks[0] = new Line2D.Double(colorBandSize.getMaxX(), colorBandSize.getMaxY(), colorBandSize.getMaxX() + tickmarkLength, colorBandSize.getMaxY());
            }
            tickmarks[tickmarks.length - 1] = new Line2D.Double(colorBandSize.getMaxX(), colorBandSize.getMinY(), colorBandSize.getMaxX() + tickmarkLength, colorBandSize.getMinY());
        }
        return tickmarks;
    }

    private Insets calculateBulletGraphLabelInsets(Graphics2D gc, Rectangle drawSpace, double[] segmentValues) {
        return this.calculateBulletGraphLabelInsets(gc, drawSpace, segmentValues, true);
    }

    private Insets calculateBulletGraphLabelInsets(Graphics2D gc, Rectangle drawSpace, double[] segmentValues, boolean determineLabelVisibility) {
        int valueLabelSpace;
        Insets textInsets = new Insets(0, 0, 0, 0);
        RendererUtil.KPIChartType kpiType = this.kpiRendererModel.getKPIChartType();
        if (kpiType == RendererUtil.KPIChartType.SLIDER) {
            textInsets = this.orientation == 0 ? new Insets((int)(5.0 * this.dpiScale), (int)(6.0 * this.dpiScale), 0, (int)(6.0 * this.dpiScale)) : (!this.showRangeLabels && !this.showValueLabel ? new Insets((int)(6.0 * this.dpiScale), (int)(5.0 * this.dpiScale), (int)(4.0 * this.dpiScale), (int)(6.0 * this.dpiScale)) : new Insets((int)(6.0 * this.dpiScale), (int)(5.0 * this.dpiScale), 0, (int)(6.0 * this.dpiScale)));
        }
        if (!this.showRangeLabels && !this.showValueLabel) {
            return textInsets;
        }
        Font labelsFont = this.kpiRendererModel.getRangeValueTextStyle().getFont();
        NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
        actualVariable.init();
        Format formatter = actualVariable.getJavaFormat();
        if (formatter == null) {
            formatter = new DecimalFormat(new String("#0.##"));
        }
        gc.setFont(labelsFont);
        String firstRangeLabel = this.formattedSegmentValues[0];
        String lastRangeLabel = this.formattedSegmentValues[segmentValues.length - 1];
        FontMetrics fontMetrics = gc.getFontMetrics();
        int labelHeight = this.showRangeLabels ? fontMetrics.getHeight() - fontMetrics.getLeading() : 0;
        int firstLabelWidth = this.showRangeLabels ? fontMetrics.stringWidth(firstRangeLabel) : 0;
        int lastLabelWidth = this.showRangeLabels ? fontMetrics.stringWidth(lastRangeLabel) : 0;
        Font valueFont = this.kpiRendererModel.getActualValueTextStyle().getFont();
        gc.setFont(valueFont);
        fontMetrics = gc.getFontMetrics();
        int valueHeight = this.showValueLabel ? fontMetrics.getHeight() - fontMetrics.getLeading() - (int)(0.25 * (double)fontMetrics.getDescent()) : 0;
        String valueLabel = this.getValueLabel(true);
        int valueWidth = this.showValueLabel ? fontMetrics.stringWidth(valueLabel) : 0;
        double dpiScale = this.kpiRendererModel.getDataDPIScaleFactor();
        int tickMarkLength = (int)(6.0 * dpiScale);
        int tickMarkSpace = (int)(2.0 * dpiScale);
        int n = valueLabelSpace = this.showValueLabel ? (int)(7.0 * dpiScale) : 0;
        if (this.orientation == 0) {
            if (determineLabelVisibility) {
                if (drawSpace.width + tickMarkSpace < firstLabelWidth + lastLabelWidth) {
                    this.showRangeLabels = false;
                }
                if (drawSpace.height - 17 < labelHeight + tickMarkLength + tickMarkSpace + valueHeight + valueLabelSpace) {
                    this.showRangeLabels = false;
                }
                if (drawSpace.height - 7 < valueHeight + valueLabelSpace) {
                    this.showValueLabel = false;
                    this.showRangeLabels = false;
                }
            }
            if (this.showRangeLabels) {
                int indicatorSpace = 4 + (this.showBorder ? (int)(3.0 * dpiScale) : 0);
                textInsets.left = Math.max(indicatorSpace, (int)Math.ceil((double)firstLabelWidth / 2.0));
                textInsets.right = Math.max(indicatorSpace, (int)Math.ceil((double)lastLabelWidth / 2.0));
                textInsets.bottom = (int)Math.ceil(labelHeight + tickMarkLength + tickMarkSpace);
            }
            textInsets.top = this.showValueLabel ? valueHeight + valueLabelSpace : (kpiType == RendererUtil.KPIChartType.SLIDER ? 8 : 0);
        } else {
            int rightRangeLabelBuffer = 0;
            if (this.showRangeLabels) {
                rightRangeLabelBuffer = Math.max(firstLabelWidth, lastLabelWidth);
                gc.setFont(labelsFont);
                fontMetrics = gc.getFontMetrics();
                for (int i = 0; i < segmentValues.length - 1; ++i) {
                    String rangeLabel = this.formattedSegmentValues[i];
                    int thisLabelWidth = fontMetrics.stringWidth(rangeLabel);
                    rightRangeLabelBuffer = (int)Math.ceil(Math.max(rightRangeLabelBuffer, thisLabelWidth));
                }
                rightRangeLabelBuffer = rightRangeLabelBuffer + tickMarkLength + tickMarkSpace;
            }
            if (determineLabelVisibility) {
                if ((double)(drawSpace.height + 2) < (double)labelHeight * 2.0) {
                    this.showRangeLabels = false;
                }
                if (drawSpace.width - 17 < rightRangeLabelBuffer) {
                    this.showRangeLabels = false;
                }
                if (drawSpace.height - valueHeight - valueLabelSpace - labelHeight < 69) {
                    this.showRangeLabels = false;
                }
                if (drawSpace.width < valueWidth) {
                    // empty if block
                }
                if (drawSpace.height - 50 < valueHeight + valueLabelSpace) {
                    this.showValueLabel = false;
                    this.showRangeLabels = false;
                }
            }
            int n2 = textInsets.left = kpiType == RendererUtil.KPIChartType.BULLET ? 0 : (int)(8.0 * dpiScale);
            if (this.showRangeLabels) {
                textInsets.right = rightRangeLabelBuffer;
                textInsets.top = (int)Math.ceil((double)labelHeight / 2.0);
                textInsets.bottom = (int)Math.ceil((double)labelHeight / 2.0);
            } else if (this.kpiRendererModel.getKPIChartType() == RendererUtil.KPIChartType.SLIDER) {
                textInsets.right = (int)(8.0 * dpiScale);
                textInsets.top = (int)(6.0 * dpiScale);
                textInsets.bottom = (int)(6.0 * dpiScale);
            } else {
                textInsets.right = 0;
                textInsets.top = 0;
                textInsets.bottom = 0;
            }
            if (this.showValueLabel) {
                textInsets.bottom = Math.max(textInsets.bottom, valueLabelSpace) + valueHeight;
            }
        }
        return textInsets;
    }

    private void renderDialRangeLabels(Graphics2D gc, double[] segmentValues) {
        NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
        actualVariable.init();
        Format formatter = actualVariable.getJavaFormat();
        if (formatter == null) {
            formatter = new DecimalFormat(new String("#0.##"));
        }
        gc.setColor(this.getRangeTextStyleColor());
        gc.setFont(this.kpiRendererModel.getRangeValueTextStyle().getFont());
        for (int i = 0; i < segmentValues.length; ++i) {
            Rectangle position = this.dialRangeLabelBounds[i];
            String rangeLabel = this.formattedSegmentValues[i];
            int xPos = (int)position.getX();
            int yPos = (int)position.getY();
            if (i != 0 && i != segmentValues.length - 1 && (!this.showMiddleRangeLabels || this.isPreviousSegmentEqual(segmentValues, i))) continue;
            gc.drawString(rangeLabel, xPos, yPos);
        }
    }

    private void renderDialValueLabel(Graphics2D gc, Area backdropArea, double widthAdjustment) {
        String valueLabel = this.getValueLabel(true);
        Font valueFont = this.kpiRendererModel.getActualValueTextStyle().getFont();
        gc.setFont(valueFont);
        FontRenderContext frc = gc.getFontRenderContext();
        Rectangle segmentBounds = backdropArea.getBounds();
        Rectangle2D valueLabelBounds = valueFont.getStringBounds(valueLabel, frc);
        FontMetrics fm = gc.getFontMetrics();
        double fontHeight = fm.getHeight() - fm.getLeading();
        int xValue = (int)Math.round(segmentBounds.getCenterX() - valueLabelBounds.getWidth() / 2.0);
        if ((double)xValue < -widthAdjustment) {
            if (this.getBounds().getWidth() < valueLabelBounds.getWidth()) {
                if (this.kpiRendererModel.isAdjustMagnitudeValueEnabled()) {
                    valueLabel = this.getValueLabel(false);
                    valueLabelBounds = valueFont.getStringBounds(valueLabel, frc);
                    xValue = (int)Math.max(-widthAdjustment, (double)Math.round(segmentBounds.getCenterX() - valueLabelBounds.getWidth() / 2.0));
                }
                if (this.getBounds().getWidth() < valueLabelBounds.getWidth()) {
                    valueLabel = "*";
                    valueLabelBounds = valueFont.getStringBounds(valueLabel, frc);
                    xValue = (int)Math.max(-widthAdjustment, (double)Math.round(segmentBounds.getCenterX() - valueLabelBounds.getWidth() / 2.0));
                }
            } else {
                xValue = (int)(-widthAdjustment);
            }
        }
        int yValue = (int)Math.round(segmentBounds.getY() + segmentBounds.getHeight() + fontHeight - (double)fm.getDescent() + (double)Math.max(this.showBorder ? 5 : 2, this.showRangeLabels ? this.rangeLabelHeight + 2 : 0));
        gc.setFont(valueFont);
        gc.setColor(this.getValueTextStyleColor());
        gc.drawString(valueLabel, xValue, yValue);
    }

    private void renderDialOverlay1(Graphics2D gc, Area segmentsArea, ImageIcon overlayIcon1) {
        int overlayX = (int)segmentsArea.getBounds().getX();
        int overlayY = (int)segmentsArea.getBounds().getY();
        int overlayWidth = (int)segmentsArea.getBounds().getWidth();
        int overlayHeight = (int)(0.9271523178807947 * (double)overlayWidth);
        gc.drawImage(overlayIcon1.getImage(), overlayX, overlayY, overlayWidth, overlayHeight, null);
    }

    private void renderDialOverlay2(Graphics2D gc, Area backdropArea, Area outerCircleArea, ImageIcon overlayIcon2) {
        int overlayX = (int)(backdropArea.getBounds().getX() + 33.0 * this.ratio);
        int overlayY = (int)(backdropArea.getBounds().getY() + 37.0 * this.ratio);
        int overlayWidth = (int)outerCircleArea.getBounds().getWidth();
        int overlayHeight = (int)(0.9587628865979382 * (double)overlayWidth);
        gc.drawImage(overlayIcon2.getImage(), overlayX, overlayY, overlayWidth, overlayHeight, null);
    }

    private void renderDialInnerCircle(Graphics2D gc, Area backdropArea, Area innerCircleArea, double[] segmentValues) {
        NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
        actualVariable.init();
        double rvValue = 0.0;
        try {
            rvValue = actualVariable.value.getValue(0);
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        Color arrowHubColor = Util.getRangeSegmentColor(this.kpiRendererModel.getSegmentedRangeColorModel(), rvValue, true);
        gc.setColor(arrowHubColor);
        gc.fill(innerCircleArea);
        if (this.show3DElements) {
            gc.setColor(new Color(145, 145, 145));
        } else {
            gc.setColor(new Color(165, 165, 165));
        }
        gc.draw(innerCircleArea);
    }

    private void renderDialInnerOutlineCircle(Graphics2D gc, Rectangle drawSpace, Area innerOutlineCircleArea) {
        this.renderShadow(gc, drawSpace, innerOutlineCircleArea);
        if (this.show3DElements) {
            gc.setColor(new Color(218, 218, 218));
        } else {
            gc.setColor(new Color(236, 236, 236));
        }
        gc.fill(innerOutlineCircleArea);
        if (this.show3DElements) {
            gc.setColor(new Color(127, 127, 127));
        } else {
            gc.setColor(new Color(105, 105, 105));
        }
        gc.draw(innerOutlineCircleArea);
    }

    private void renderDialIndicator(Graphics2D gc, Rectangle drawSpace, Area indicatorArea, boolean target) {
        if (!target && this.show3DElements) {
            this.renderShadow(gc, drawSpace, indicatorArea);
        }
        gc.setColor(target ? Color.black : Color.white);
        gc.fill(indicatorArea);
        if (!target) {
            if (this.show3DElements) {
                gc.setColor(new Color(83, 83, 83));
            } else {
                gc.setColor(new Color(49, 49, 49));
            }
            gc.draw(indicatorArea);
        }
    }

    private void renderDialColorSegments(Graphics2D gc, Arc2D.Double[] colorSegments) {
        KPIChartSegmentedRangeColorModel rangeModel = this.kpiRendererModel.getSegmentedRangeColorModel();
        Color[] rangeColors = rangeModel.getMappedSegmentColors();
        NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
        actualVariable.init();
        Double rvValue = new Double(0.0);
        try {
            rvValue = new Double(actualVariable.value.getValue(0));
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        int selectedIndex = Util.getRangeSegmentIndex(rangeModel, rvValue);
        for (int i = 0; i < colorSegments.length; ++i) {
            Color segmentColor = selectedIndex == i ? Util.getRangeSegmentColor(rangeModel, rvValue, true) : rangeColors[i];
            gc.setColor(segmentColor);
            gc.fill(colorSegments[i]);
            gc.setColor(new Color(102, 102, 102));
            gc.draw(colorSegments[i]);
        }
    }

    private void renderDialBackdrop(Graphics2D gc, Rectangle drawSpace, Area backdropArea) {
        if (this.show3DElements) {
            this.renderShadow(gc, drawSpace, backdropArea);
        }
        Rectangle2D backdropBounds = backdropArea.getBounds2D();
        if (this.show3DElements) {
            gc.setPaint(new GradientPaint((float)backdropBounds.getX(), (float)backdropBounds.getY(), new Color(231, 231, 231), (float)(backdropBounds.getX() + backdropBounds.getWidth()), (float)(backdropBounds.getY() + backdropBounds.getHeight()), new Color(183, 183, 183)));
        } else {
            gc.setColor(new Color(236, 236, 236));
        }
        gc.fill(backdropArea);
        gc.setPaint(new GradientPaint((float)(backdropBounds.getX() + backdropBounds.getWidth() / 2.0), (float)backdropBounds.getY(), new Color(224, 224, 224), (float)(backdropBounds.getX() + backdropBounds.getWidth() / 2.0), (float)(backdropBounds.getY() + backdropBounds.getHeight()), new Color(112, 112, 112)));
        gc.draw(backdropArea);
    }

    private void renderShadow(Graphics2D gc, Rectangle drawSpace, Area shape) {
        Color shadowColor = new Color(0, 0, 0, 100);
        this.renderShadow(gc, drawSpace, shape, shadowColor);
    }

    private void renderShadow(Graphics2D gc, Rectangle drawSpace, Area shape, Color shadowColor) {
        int radius = (int)Math.sqrt(this.shadowElements.length) / 2;
        Area shadowShape = new Area(shape);
        Rectangle shadowBounds = shape.getBounds();
        AffineTransform transform = AffineTransform.getTranslateInstance(-shadowBounds.getX(), -shadowBounds.getY());
        shadowShape.transform(transform);
        int dpiScale = (int)this.kpiRendererModel.getDataDPIScaleFactor();
        if (this.show3DElements) {
            BufferedImage tempShadowImage = new BufferedImage((int)(shadowShape.getBounds().getWidth() + (double)radius * 4.0), (int)(shadowShape.getBounds().getHeight() + (double)radius * 4.0), 3);
            Graphics2D shadowG = tempShadowImage.createGraphics();
            this.applyRenderingHints(shadowG);
            shadowG.translate(radius * 2, radius * 2);
            shadowG.setColor(shadowColor);
            shadowG.fill(shadowShape);
            shadowG.dispose();
            Kernel myKernel = new Kernel(radius * 2 + 1, radius * 2 + 1, this.shadowElements);
            ConvolveOp simpleBlur = new ConvolveOp(myKernel, 1, null);
            BufferedImage shadowImage = simpleBlur.filter(tempShadowImage, null);
            gc.drawImage((Image)shadowImage, (int)shadowBounds.getX() - 6 + dpiScale, (int)shadowBounds.getY() - 6 + dpiScale, null);
        }
    }

    private Area calculateDialIndicator(Area backdropArea, Area segmentsArea, double[] segmentVals, boolean target) {
        Polygon indicator = new Polygon();
        Rectangle2D backdropBounds = backdropArea.getBounds2D();
        indicator.addPoint((int)Math.round(backdropBounds.getX() + 81.0 * this.ratio), (int)Math.round(backdropBounds.getY() + 12.0 * this.ratio));
        indicator.addPoint((int)Math.round(backdropBounds.getX() + 55.0 * this.ratio), (int)Math.round(backdropBounds.getY() + 81.0 * this.ratio));
        indicator.addPoint((int)Math.round(backdropBounds.getX() + 107.0 * this.ratio), (int)Math.round(backdropBounds.getY() + 81.0 * this.ratio));
        Area indicatorArea = new Area(indicator);
        int numRange = segmentVals.length - 1;
        double value0 = segmentVals[0];
        double valueN = segmentVals[numRange];
        double delta = valueN - value0;
        double rvValue = 0.0;
        if (!target) {
            NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
            actualVariable.init();
            try {
                rvValue = actualVariable.value.getValue(0);
            }
            catch (MissingValueException missingValueException) {}
        } else {
            NumericVariable targetVariable = this.kpiRendererModel.getTargetVariable();
            if (targetVariable == null) {
                return null;
            }
            targetVariable.init();
            try {
                rvValue = targetVariable.value.getValue(0);
            }
            catch (MissingValueException e) {
                return null;
            }
            this.isTargetOutOfBounds(rvValue, segmentVals);
        }
        double relativePosition = Math.min(Math.max((rvValue - value0) / delta, 0.0), 1.0);
        double theta = relativePosition * 270.0 - 135.0;
        theta *= Math.PI / 180;
        if (target) {
            AffineTransform targetTransform = AffineTransform.getRotateInstance(Math.PI, indicatorArea.getBounds().getCenterX(), indicatorArea.getBounds().getCenterY());
            indicatorArea.transform(targetTransform);
            targetTransform.setToTranslation(0.0, (int)(-indicatorArea.getBounds().getHeight() + 6.0 * this.ratio));
            indicatorArea.transform(targetTransform);
        }
        AffineTransform rotate = AffineTransform.getRotateInstance(theta, backdropBounds.getX() + 81.0 * this.ratio, backdropBounds.getY() + 81.0 * this.ratio);
        indicatorArea.transform(rotate);
        if (target) {
            indicatorArea.intersect(segmentsArea);
        }
        return indicatorArea;
    }

    private Area calculateDialInnerCircle(Rectangle drawSpace) {
        double innerDiameter = 85.0 * this.ratio;
        Ellipse2D.Double innerCircle = new Ellipse2D.Double(drawSpace.getX() + 39.0 * this.ratio, drawSpace.getY() + 39.0 * this.ratio, innerDiameter, innerDiameter);
        return new Area(innerCircle);
    }

    private Area calculateDialInnerOutlineCircle(Rectangle drawSpace) {
        double innerOutlineDiameter = 97.0 * this.ratio;
        Ellipse2D.Double innerOutlineCircle = new Ellipse2D.Double(drawSpace.getX() + 33.0 * this.ratio, drawSpace.getY() + 33.0 * this.ratio, innerOutlineDiameter, innerOutlineDiameter);
        return new Area(innerOutlineCircle);
    }

    private void paintSkinnableDial(Graphics2D gc, Rectangle componentBounds) {
        int smallestGraphDiameter;
        KPIChartCustomSkinModel customModel;
        double[] segmentVals = this.getSegmentValues();
        NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
        if (actualVariable == null) {
            return;
        }
        double rvValue = 0.0;
        actualVariable.init();
        try {
            rvValue = actualVariable.value.getValue(0);
        }
        catch (Exception e) {
            return;
        }
        Format formatter = actualVariable.getJavaFormat();
        double targetValue = Double.NaN;
        NumericVariable targetVariable = this.kpiRendererModel.getTargetVariable();
        if (targetVariable != null) {
            targetVariable.init();
            try {
                targetValue = targetVariable.value.getValue(0);
            }
            catch (Exception e) {
                targetValue = Double.NaN;
            }
            this.isTargetOutOfBounds(targetValue, segmentVals);
        }
        DialSkinModel dialSkinModel = null;
        if (this.kpiRendererModel.getSkin() == RendererUtil.Skin.CUSTOM && (customModel = this.kpiRendererModel.getCustomSkinModel()) != null) {
            dialSkinModel = customModel.getDialSkinModel();
        }
        if (dialSkinModel == null) {
            dialSkinModel = new DialSkinModel();
        }
        ImageIcon borderIcon = dialSkinModel.getBorderIcon();
        ImageIcon segmentEffectsIcon = dialSkinModel.getSegmentEffectsIcon();
        ImageIcon tintedHubIcon = dialSkinModel.getTintedLayerIcon();
        ImageIcon hubEffectsIcon = dialSkinModel.getTintedLayerEffectsIcon();
        ImageIcon indicatorShadowIcon = dialSkinModel.getIndicatorShadowIcon();
        ImageIcon indicatorIcon = dialSkinModel.getIndicatorIcon();
        ImageIcon targetIndicatorShadowIcon = dialSkinModel.getTargetIndicatorShadowIcon();
        ImageIcon targetIndicatorIcon = dialSkinModel.getTargetIndicatorIcon();
        Rectangle borderSize = new Rectangle(borderIcon.getIconHeight(), borderIcon.getIconWidth());
        Font labelsFont = this.kpiRendererModel.getRangeValueTextStyle().getFont();
        Font valueFont = this.kpiRendererModel.getActualValueTextStyle().getFont();
        double startAngle = 225.0;
        double sweep = 270.0;
        Rectangle2D.Double[] rangeLabelPositions = this.calculateSkinnableRangeLabelDimensions(gc, labelsFont, segmentVals, formatter);
        gc.setFont(valueFont);
        FontMetrics fm = gc.getFontMetrics();
        double valueLabelHeight = fm.getHeight();
        int valueLabelSpace = (int)(3.0 * this.dpiScale);
        double[] tickmarkAngles = this.calculateSkinnableDialTickmarkAngles(startAngle, sweep, segmentVals);
        if (this.showRangeLabels && rangeLabelPositions[0].getWidth() + rangeLabelPositions[rangeLabelPositions.length - 1].getWidth() + 2.0 > (double)componentBounds.width) {
            this.showRangeLabels = false;
        }
        if ((double)(componentBounds.height - (smallestGraphDiameter = 28)) < valueLabelHeight + (double)valueLabelSpace) {
            this.showValueLabel = false;
            this.showRangeLabels = false;
        }
        double mxRad = this.isUseFullSpace ? (double)Math.min(componentBounds.width, componentBounds.height) / 2.0 : borderSize.getHeight() / 2.0;
        double actualRadius = this.calculateSkinnableDialRadius(componentBounds, tickmarkAngles, rangeLabelPositions, mxRad, valueLabelHeight + (double)valueLabelSpace);
        if (this.showRangeLabels && this.showMiddleRangeLabels) {
            if (actualRadius < (double)smallestGraphDiameter / 2.0) {
                this.showMiddleRangeLabels = false;
                actualRadius = this.calculateSkinnableDialRadius(componentBounds, tickmarkAngles, rangeLabelPositions, borderSize.getHeight() / 2.0, valueLabelHeight + (double)valueLabelSpace);
                if (actualRadius < (double)smallestGraphDiameter / 2.0) {
                    this.showRangeLabels = false;
                }
            }
            if (this.showRangeLabels) {
                this.calculateSkinnableDialRangeLabelCollisions(rangeLabelPositions, tickmarkAngles, actualRadius, segmentVals);
            }
            if (!this.showMiddleRangeLabels) {
                actualRadius = this.calculateSkinnableDialRadius(componentBounds, tickmarkAngles, rangeLabelPositions, borderSize.getHeight() / 2.0, valueLabelHeight);
                rangeLabelPositions = this.calculateSkinnableRangeLabelDimensions(gc, labelsFont, segmentVals, formatter);
                this.calculateSkinnableDialRangeLabelCollisions(rangeLabelPositions, tickmarkAngles, actualRadius, segmentVals);
            }
        }
        if (actualRadius < (double)smallestGraphDiameter / 2.0) {
            return;
        }
        double scaleFactor = actualRadius / (borderSize.getWidth() / 2.0);
        this.imageCache.setScaleFactor(scaleFactor);
        Insets textInsets = this.calculateSkinnableDialTextInsets(actualRadius, tickmarkAngles, rangeLabelPositions, valueLabelHeight);
        Rectangle drawSpace = new Rectangle(componentBounds);
        drawSpace.width = componentBounds.width - textInsets.left - textInsets.right;
        drawSpace.height = componentBounds.height - textInsets.top - textInsets.bottom;
        drawSpace.x = componentBounds.x + textInsets.left;
        drawSpace.y = componentBounds.y + textInsets.top;
        Rectangle2D.Double segmentBounds = new Rectangle2D.Double((borderSize.getWidth() - (double)segmentEffectsIcon.getIconWidth()) / 2.0, (borderSize.getHeight() - (double)segmentEffectsIcon.getIconHeight()) / 2.0, segmentEffectsIcon.getIconWidth(), segmentEffectsIcon.getIconHeight());
        KPIChartSegmentedRangeColorModel rangeModel = this.kpiRendererModel.getSegmentedRangeColorModel();
        Arc2D.Double[] segmentsArea = (Arc2D.Double[])this.imageCache.getSegmentsArea(rangeModel);
        if (segmentsArea == null) {
            segmentsArea = this.calculateSpeedometerSegmentArea(segmentVals, drawSpace, startAngle, sweep, segmentBounds);
            this.imageCache.addSegmentsArea(segmentsArea, rangeModel);
        }
        float componentCenterX = (float)((double)drawSpace.x + (componentBounds.getWidth() - ((double)(textInsets.left + textInsets.right) + (double)borderSize.width * scaleFactor)) / 2.0);
        float componentCenterY = (float)((double)drawSpace.y + (componentBounds.getHeight() - ((double)(textInsets.bottom + textInsets.top) + (double)borderSize.width * scaleFactor)) / 2.0);
        int selectedIndex = Util.getRangeSegmentIndex(rangeModel, this.getCurrentValue());
        Image savedPieImage = this.imageCache.getScaledImage("coloredSegmentsImage_", scaleFactor, rangeModel, selectedIndex);
        if (savedPieImage == null) {
            savedPieImage = KPIChartRenderer.newBufferedImage((int)borderSize.getWidth(), (int)borderSize.getHeight());
            Graphics2D savedPieGraphics = ((BufferedImage)savedPieImage).createGraphics();
            this.applyRenderingHints(savedPieGraphics);
            if (this.showRangeLabels) {
                Point2D.Double[] tickmarkEndPoints = this.calculateSkinnableDialTickmarkEndpoints(borderSize, startAngle, sweep, tickmarkAngles);
                this.renderSkinnableDialTickmarks(savedPieGraphics, borderSize, tickmarkEndPoints);
            }
            this.renderSpeedometerPie(savedPieGraphics, drawSpace, segmentsArea);
            this.renderSkinnableSpeedometerFullCenteredImageLayer(savedPieGraphics, borderIcon.getImage(), borderSize);
            this.renderSkinnableSpeedometerFullCenteredImageLayer(savedPieGraphics, segmentEffectsIcon.getImage(), borderSize);
            if (tintedHubIcon != null) {
                ImageIcon tintedImageIcon = null;
                Color tintedColor = Util.getRangeSegmentColor(this.kpiRendererModel.getSegmentedRangeColorModel(), rvValue, true);
                if (this.kpiRendererModel.getSkin() == RendererUtil.Skin.MODERN) {
                    tintedImageIcon = this.imageCache.getImageIcon("tintedImage_", tintedColor);
                }
                if (tintedImageIcon == null) {
                    BufferedImage newTintImage = KPIChartRenderer.newBufferedImage(tintedHubIcon.getIconWidth(), tintedHubIcon.getIconHeight());
                    newTintImage.getGraphics().drawImage(tintedHubIcon.getImage(), 0, 0, null);
                    Image tintedImage = this.changeColor(newTintImage, tintedColor);
                    tintedImageIcon = new ImageIcon(tintedImage);
                    if (this.kpiRendererModel.getSkin() == RendererUtil.Skin.MODERN) {
                        this.imageCache.addImageIcon(tintedImageIcon, "tintedImage_", tintedColor);
                    }
                }
                this.renderSkinnableSpeedometerFullCenteredImageLayer(savedPieGraphics, tintedImageIcon.getImage(), borderSize);
            }
            this.renderSkinnableSpeedometerFullCenteredImageLayer(savedPieGraphics, hubEffectsIcon.getImage(), borderSize);
            savedPieImage = KPIChartRenderer.getFastScaledImage((BufferedImage)savedPieImage, (int)(borderSize.getWidth() * scaleFactor), (int)(borderSize.getHeight() * scaleFactor));
            this.imageCache.addScaledImage(savedPieImage, "coloredSegmentsImage_", scaleFactor, rangeModel, selectedIndex);
        }
        gc.drawImage(savedPieImage, (int)componentCenterX, (int)componentCenterY, null);
        BufferedImage indicatorImage = this.getScaledImage(indicatorIcon, "indicator_", rangeModel, scaleFactor);
        BufferedImage targetImage = this.getScaledImage(targetIndicatorIcon, "target_", rangeModel, scaleFactor);
        BufferedImage shadowImage = this.getScaledImage(indicatorShadowIcon, "indicatorShadow_", rangeModel, scaleFactor);
        BufferedImage targetShadowImage = this.getScaledImage(targetIndicatorShadowIcon, "targetShadow_", rangeModel, scaleFactor);
        if (indicatorImage != null) {
            this.renderSkinnableSpeedometerFullIndicatorLayer(gc, indicatorImage, shadowImage, null, borderSize, segmentVals, rvValue, startAngle, sweep, this.kpiRendererModel.getKPIChartType(), scaleFactor, (int)componentCenterX, (int)componentCenterY);
        }
        if (!Double.isNaN(targetValue) && targetImage != null) {
            this.renderSkinnableSpeedometerFullIndicatorLayer(gc, targetImage, targetShadowImage, null, borderSize, segmentVals, targetValue, startAngle, sweep, this.kpiRendererModel.getKPIChartType(), scaleFactor, (int)componentCenterX, (int)componentCenterY);
        }
        if (this.showRangeLabels) {
            gc.setColor(this.getRangeTextStyleColor());
            gc.setFont(labelsFont);
            for (int i = 0; i < rangeLabelPositions.length; ++i) {
                if (i != 0 && i != rangeLabelPositions.length - 1 && (!this.showMiddleRangeLabels || this.isPreviousSegmentEqual(segmentVals, i))) continue;
                gc.drawString(this.formattedSegmentValues[i], (float)(rangeLabelPositions[i].x + (double)componentCenterX + borderSize.getWidth() * scaleFactor / 2.0), (float)(rangeLabelPositions[i].y + (double)componentCenterY + borderSize.getHeight() * scaleFactor / 2.0));
            }
        }
        if (this.showValueLabel) {
            AffineTransform scaleTransform = AffineTransform.getTranslateInstance(componentCenterX, componentCenterY);
            scaleTransform.scale(scaleFactor, scaleFactor);
            Area[] scaledSegmentsArea = new Area[segmentsArea.length];
            gc.setColor(new Color(102, 102, 102));
            for (int i = 0; i < segmentsArea.length; ++i) {
                scaledSegmentsArea[i] = new Area(segmentsArea[i]);
                scaledSegmentsArea[i].transform(scaleTransform);
            }
            String valueString = this.getValueLabel(true);
            boolean valueLabelFits = true;
            valueLabelFits = this.checkSkinnableSpeedometerValueLabelCollisions(gc, valueString, valueFont, componentBounds);
            if (!valueLabelFits) {
                valueString = this.getValueLabel(false);
                valueLabelFits = this.checkSkinnableSpeedometerValueLabelCollisions(gc, valueString, valueFont, componentBounds);
            }
            if (!valueLabelFits) {
                valueString = "*";
                valueLabelFits = this.checkSkinnableSpeedometerValueLabelCollisions(gc, valueString, valueFont, componentBounds);
            }
            if (valueLabelFits) {
                Rectangle borderSizePlusRangeLabels = new Rectangle(0, 0, (int)borderSize.getWidth(), (int)(borderSize.getHeight() + (double)textInsets.bottom / scaleFactor - Math.ceil(valueLabelHeight) / scaleFactor));
                this.renderSkinnableSpeedometerHalfValueLabel(gc, valueString, valueFont, this.getValueTextStyleColor(), borderSizePlusRangeLabels, scaleTransform);
            }
        }
    }

    private Area calculateDialColorBandAreaMinusWedge(Rectangle drawSpace, Area backdropA) {
        Polygon removeWedge = new Polygon();
        int xVal = (int)drawSpace.getX();
        int yVal = (int)drawSpace.getY();
        removeWedge.addPoint(xVal + (int)Math.round(81.0 * this.ratio), yVal + (int)Math.round(81.0 * this.ratio));
        removeWedge.addPoint(xVal + (int)Math.round(0.0 * this.ratio), yVal + (int)Math.round(162.0 * this.ratio));
        removeWedge.addPoint(xVal + (int)Math.round(0.0 * this.ratio), yVal + (int)Math.round(162.0 * this.ratio) + 10);
        removeWedge.addPoint(xVal + (int)Math.round(162.0 * this.ratio), yVal + (int)Math.round(162.0 * this.ratio) + 10);
        removeWedge.addPoint(xVal + (int)Math.round(162.0 * this.ratio), yVal + (int)Math.round(162.0 * this.ratio));
        backdropA.subtract(new Area(removeWedge));
        return backdropA;
    }

    private Arc2D.Double[] calculateDialSegmentArea(Area backdropArea, Rectangle ellipseBounds, double[] segmentVals) {
        double startAngle;
        Arc2D.Double[] colorSegments = new Arc2D.Double[segmentVals.length - 1];
        this.dialRangeLabelBounds = new Rectangle[segmentVals.length];
        double origStartAngle = startAngle = 225.0;
        double maxVal = segmentVals[segmentVals.length - 1];
        double minVal = segmentVals[0];
        double delta = maxVal - minVal;
        int labelSpace = 3;
        Rectangle labelEllipseBounds = new Rectangle((int)(backdropArea.getBounds().getX() - (double)labelSpace), (int)backdropArea.getBounds().getY() - labelSpace, (int)(backdropArea.getBounds().getWidth() + (double)labelSpace * 2.0), (int)(backdropArea.getBounds().getWidth() + (double)labelSpace * 2.0));
        for (int i = 0; i < colorSegments.length; ++i) {
            double endAngle = origStartAngle - (segmentVals[i + 1] - segmentVals[0]) / delta * 270.0;
            double currentPercentage = endAngle - startAngle;
            Arc2D.Double arc = new Arc2D.Double(ellipseBounds, startAngle, currentPercentage, 2);
            Arc2D.Double labelArc = new Arc2D.Double(labelEllipseBounds, startAngle, currentPercentage, 2);
            colorSegments[i] = arc;
            startAngle = endAngle;
            if (!this.showRangeLabels) continue;
            if (i == 0) {
                this.dialRangeLabelBounds[0] = new Rectangle((int)((double)Math.round(labelArc.getStartPoint().getX()) - this.rangeLabelWidths[0]), (int)(Math.round(labelArc.getStartPoint().getY()) + (long)this.rangeLabelHeight), (int)this.rangeLabelWidths[0], this.rangeLabelHeight);
            }
            this.dialRangeLabelBounds[i + 1] = new Rectangle((int)Math.round(labelArc.getEndPoint().getX()), (int)Math.round(labelArc.getEndPoint().getY()), (int)this.rangeLabelWidths[i + 1], this.rangeLabelHeight);
            double relativePercentage = (double)Math.round(1000.0 * ((segmentVals[i + 1] - minVal) / delta)) / 1000.0;
            if (relativePercentage < 0.52 && relativePercentage > 0.48) {
                this.dialRangeLabelBounds[i + 1].x -= (int)(this.rangeLabelWidths[i + 1] / 2.0);
            } else if (relativePercentage < 0.22 && relativePercentage > 0.17) {
                this.dialRangeLabelBounds[i + 1].y = (int)((double)this.dialRangeLabelBounds[i + 1].y + (double)this.rangeLabelHeight / 2.0);
                this.dialRangeLabelBounds[i + 1].x = (int)((double)this.dialRangeLabelBounds[i + 1].x - this.rangeLabelWidths[i + 1]);
            } else if (relativePercentage < 0.83 && relativePercentage > 0.78) {
                this.dialRangeLabelBounds[i + 1].y = (int)((double)this.dialRangeLabelBounds[i + 1].y + (double)this.rangeLabelHeight / 2.0);
            } else if (relativePercentage < 0.2) {
                this.dialRangeLabelBounds[i + 1].y += this.rangeLabelHeight;
                this.dialRangeLabelBounds[i + 1].x = (int)((double)this.dialRangeLabelBounds[i + 1].x - this.rangeLabelWidths[i + 1]);
            } else if (relativePercentage < 0.5) {
                this.dialRangeLabelBounds[i + 1].x = (int)((double)this.dialRangeLabelBounds[i + 1].x - this.rangeLabelWidths[i + 1]);
            } else if (!(relativePercentage < 0.8)) {
                this.dialRangeLabelBounds[i + 1].y += this.rangeLabelHeight;
            }
            Rectangle tempRect = new Rectangle(this.dialRangeLabelBounds[i]);
            Rectangle tempRect2 = new Rectangle(this.dialRangeLabelBounds[i + 1]);
            tempRect.y -= tempRect.height;
            tempRect2.y -= tempRect2.height;
            if (this.isNextSegmentEqual(segmentVals, i) || !tempRect.intersects(tempRect2)) continue;
            this.showMiddleRangeLabels = false;
        }
        return colorSegments;
    }

    private Area calculateDialColorBandArea(Rectangle drawSpace) {
        double segmentDiameter = 151.0 * this.ratio;
        Ellipse2D.Double segmentCircle = new Ellipse2D.Double(drawSpace.getX() + 6.0 * this.ratio, drawSpace.getY() + 6.0 * this.ratio, segmentDiameter, segmentDiameter);
        Area backdropA = new Area(segmentCircle);
        return backdropA;
    }

    private boolean isTargetOutOfBounds(double rvValue, double[] segmentValues) {
        boolean reverseRange = segmentValues[segmentValues.length - 1] < segmentValues[0];
        boolean outOfBounds = false;
        if (!reverseRange) {
            if (rvValue > segmentValues[segmentValues.length - 1] || rvValue < segmentValues[0]) {
                outOfBounds = true;
            }
        } else if (rvValue > segmentValues[0] || rvValue < segmentValues[segmentValues.length - 1]) {
            outOfBounds = true;
        }
        if (outOfBounds) {
            String message = Message.format((String)RB.getStringResource("KPIChartCell.targetOutOfRange.fmt.txt"), (Object[])new String[]{"" + rvValue});
            System.err.println(message);
        }
        return outOfBounds;
    }

    private Area calculateDialBackdrop(Rectangle drawSpace) {
        double bandDiameter = drawSpace.height - 1;
        Ellipse2D.Double backdropCircle = new Ellipse2D.Double(drawSpace.getX(), drawSpace.getY(), bandDiameter, bandDiameter);
        Polygon removeWedge = new Polygon();
        int xVal = (int)drawSpace.getX();
        int yVal = (int)drawSpace.getY();
        removeWedge.addPoint(xVal + (int)Math.round(81.0 * this.ratio), yVal + (int)Math.round(90.0 * this.ratio));
        removeWedge.addPoint(xVal + (int)Math.round(9.0 * this.ratio), yVal + (int)Math.round(162.0 * this.ratio));
        removeWedge.addPoint(xVal + (int)Math.round(9.0 * this.ratio), yVal + (int)Math.round(162.0 * this.ratio) + 10);
        removeWedge.addPoint(xVal + (int)Math.round(153.0 * this.ratio), yVal + (int)Math.round(162.0 * this.ratio) + 10);
        removeWedge.addPoint(xVal + (int)Math.round(153.0 * this.ratio), yVal + (int)Math.round(162.0 * this.ratio));
        Area backdropA = new Area(backdropCircle);
        backdropA.subtract(new Area(removeWedge));
        return backdropA;
    }

    private void renderSkinnableSpeedometerHalfValueLabel(Graphics2D gc, String valueString, Font valueFont, Color valueColor, Rectangle borderSize, AffineTransform transform) {
        gc.setFont(valueFont);
        gc.setColor(valueColor);
        Point2D.Double magnitudeTopCenter = new Point2D.Double((borderSize.getWidth() - 1.0) / 2.0, borderSize.getHeight() + 3.0);
        transform.transform(magnitudeTopCenter, magnitudeTopCenter);
        FontMetrics fm = gc.getFontMetrics();
        double height = fm.getHeight() - fm.getDescent();
        FontRenderContext frc = gc.getFontRenderContext();
        TextLayout textLayout = new TextLayout(valueString, valueFont, frc);
        gc.drawString(valueString, Math.max(0.0f, (float)(magnitudeTopCenter.x - textLayout.getBounds().getWidth() / 2.0)), (float)(magnitudeTopCenter.y + height));
    }

    private boolean checkSkinnableSpeedometerValueLabelCollisions(Graphics2D gc, String valueString, Font valueFont, Rectangle2D availableValueLabelSpace) {
        boolean valueLabelTooLarge;
        gc.setFont(valueFont);
        FontRenderContext frc = gc.getFontRenderContext();
        TextLayout textLayout = new TextLayout(valueString, valueFont, frc);
        Rectangle2D valueLabelBounds = textLayout.getBounds();
        boolean bl = valueLabelTooLarge = valueLabelBounds.getWidth() > availableValueLabelSpace.getWidth() || valueLabelBounds.getHeight() > availableValueLabelSpace.getHeight();
        return !valueLabelTooLarge;
    }

    private String getValueLabel(boolean showMagnitudeLabel) {
        NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
        Format formatter = actualVariable.getJavaFormat();
        if (formatter == null) {
            formatter = new DecimalFormat(new String("#0.##"));
        }
        Double rvValue = new Double(0.0);
        try {
            rvValue = new Double(actualVariable.value.getValue(0) / this.factor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String valueLabel = formatter.format(rvValue).trim();
        if (showMagnitudeLabel && this.adjustMagnitude && this.factor != 1.0) {
            valueLabel = valueLabel.concat(" " + this.getMagnitudeLabel());
        }
        return valueLabel;
    }

    private void renderSkinnableSpeedometerFullIndicatorLayer(Graphics2D graphics, Image image, Image shadowImage, Image majorTickmarkImage, Rectangle borderSize, double[] segmentValues, double rvValue, double startAngle, double sweep, RendererUtil.KPIChartType kpiType, double scaleFactor, int x, int y) {
        if (image == null) {
            return;
        }
        AffineTransform savedTransform = graphics.getTransform();
        int shadowWidth = 0;
        int shadowHeight = 0;
        if (shadowImage != null) {
            shadowWidth = shadowImage.getWidth(null);
            shadowHeight = shadowImage.getHeight(null);
        }
        Rectangle newRect = new Rectangle(borderSize.x, borderSize.y, (int)((double)borderSize.width * scaleFactor), (int)((double)borderSize.height * scaleFactor));
        double centerX = 0.0;
        double centerY = 0.0;
        double topImageX = 0.0;
        double topImageY = 0.0;
        double topShadowImageX = 0.0;
        double topShadowImageY = 0.0;
        if (kpiType == RendererUtil.KPIChartType.SPEEDOMETER_FULL || kpiType == RendererUtil.KPIChartType.DIAL) {
            centerX = (newRect.getWidth() - 1.0) / 2.0 + (double)x;
            centerY = (newRect.getHeight() - 1.0) / 2.0 + (double)y;
            topImageX = centerX - (double)(image.getWidth(null) - 1) / 2.0;
            topImageY = centerY - (double)(image.getHeight(null) - 1) / 2.0;
            topShadowImageX = centerX - (double)(shadowWidth - 1) / 2.0 - topImageX;
            topShadowImageY = centerY - (double)(shadowHeight - 1) / 2.0 - topImageY;
            centerX = newRect.getCenterX() + (double)x;
            centerY = newRect.getCenterY() + (double)y;
        } else {
            centerX = (newRect.getWidth() - 1.0) / 2.0 + (double)x;
            centerY = (double)(majorTickmarkImage.getHeight(null) - 1) * scaleFactor + (double)y;
            topImageX = centerX - (double)(image.getWidth(null) - 1) / 2.0;
            topImageY = centerY - (double)(image.getHeight(null) - 1) / 2.0;
            topShadowImageX = centerX - (double)(shadowWidth - 1) / 2.0 - topImageX;
            topShadowImageY = centerY - (double)(shadowHeight - 1) / 2.0 - topImageY;
            centerX = newRect.getCenterX() + (double)x;
            centerY = ((double)majorTickmarkImage.getHeight(null) - 0.5) * scaleFactor + (double)y;
        }
        double delta = segmentValues[segmentValues.length - 1] - segmentValues[0];
        double relativePosition = Math.min(Math.max((rvValue - segmentValues[0]) / delta, 0.0), 1.0);
        double tickAngle = relativePosition * sweep - (startAngle - 90.0);
        double theta = tickAngle * (Math.PI / 180);
        graphics.rotate(theta, centerX, centerY);
        graphics.translate(topImageX, topImageY);
        graphics.drawImage(shadowImage, (int)topShadowImageX, (int)topShadowImageY, null);
        graphics.drawImage(image, 0, 0, null);
        graphics.setTransform(savedTransform);
    }

    private Image changeColor(Image originalImage, Color newColor) {
        KPIChartColorFilter colorFilter = new KPIChartColorFilter(newColor.getRGB());
        Image newImage = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(originalImage.getSource(), colorFilter));
        return newImage;
    }

    private void renderSpeedometerPie(Graphics2D gc, Rectangle drawSpace, Arc2D.Double[] colorSegments) {
        KPIChartSegmentedRangeColorModel rangeModel = this.kpiRendererModel.getSegmentedRangeColorModel();
        Color[] rangeColors = rangeModel.getMappedSegmentColors();
        NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
        actualVariable.init();
        Double rvValue = new Double(0.0);
        try {
            rvValue = new Double(actualVariable.value.getValue(0));
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        int selectedIndex = Util.getRangeSegmentIndex(rangeModel, rvValue);
        for (int i = 0; i < colorSegments.length; ++i) {
            Color segmentColor = selectedIndex == i ? Util.getRangeSegmentColor(rangeModel, rvValue, true) : rangeColors[i];
            gc.setColor(segmentColor);
            Arc2D.Double colorSegment = colorSegments[i];
            gc.fill(colorSegment);
            gc.draw(colorSegment);
        }
    }

    private void renderSkinnableSpeedometerFullCenteredImageLayer(Graphics2D gc, Image image, Rectangle borderSize) {
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        gc.drawImage(image, (int)((double)(borderSize.width - imageWidth) / 2.0), (int)((double)(borderSize.height - imageHeight) / 2.0), null);
    }

    private void renderSkinnableDialTickmarks(Graphics2D gc, Rectangle borderSize, Point2D.Double[] endPoints) {
        double centerX = 0.0;
        double centerY = 0.0;
        centerX = (borderSize.getWidth() - 1.0) / 2.0;
        centerY = (borderSize.getHeight() - 1.0) / 2.0;
        Point2D.Double centerPoint = new Point2D.Double(centerX, centerY);
        gc.setColor(new Color(102, 102, 102));
        if (!this.showMiddleRangeLabels && endPoints.length > 0) {
            gc.drawLine((int)centerPoint.x, (int)centerPoint.y, (int)endPoints[0].x, (int)endPoints[0].y);
            gc.drawLine((int)centerPoint.x, (int)centerPoint.y, (int)endPoints[endPoints.length - 1].x, (int)endPoints[endPoints.length - 1].y);
        } else {
            for (int i = 0; i < endPoints.length; ++i) {
                gc.drawLine((int)centerPoint.x, (int)centerPoint.y, (int)endPoints[i].x, (int)endPoints[i].y);
            }
        }
    }

    private Point2D.Double[] calculateSkinnableDialTickmarkEndpoints(Rectangle borderSize, double startAngle, double sweep, double[] tickmarkAngles) {
        double centerX = 0.0;
        double centerY = 0.0;
        double radius = 0.0;
        centerX = (borderSize.getWidth() - 1.0) / 2.0;
        centerY = (borderSize.getHeight() - 1.0) / 2.0;
        radius = borderSize.getWidth() / 2.0;
        Point2D.Double[] endPoints = new Point2D.Double[tickmarkAngles.length];
        for (int i = 0; i < endPoints.length; ++i) {
            endPoints[i] = new Point2D.Double(centerX + radius * Math.sin(tickmarkAngles[i]), centerY - radius * Math.cos(tickmarkAngles[i]));
        }
        return endPoints;
    }

    private double getCurrentValue() {
        NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
        actualVariable.init();
        Double rvValue = new Double(0.0);
        try {
            rvValue = new Double(actualVariable.value.getValue(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rvValue;
    }

    private Arc2D.Double[] calculateSpeedometerSegmentArea(double[] segmentVals, Rectangle drawSpace, double startAngle, double sweep, Rectangle2D.Double ellipseBounds) {
        Arc2D.Double[] colorSegments = new Arc2D.Double[segmentVals.length - 1];
        double origStartAngle = startAngle;
        double maxVal = segmentVals[segmentVals.length - 1];
        double minVal = segmentVals[0];
        double delta = maxVal - minVal;
        if (ellipseBounds == null) {
            int buffer = (int)(41.0 * this.ratio);
            ellipseBounds = new Rectangle2D.Double(drawSpace.x + buffer, drawSpace.y + buffer, drawSpace.width - buffer - buffer, drawSpace.height - buffer - buffer);
        }
        for (int i = 0; i < colorSegments.length; ++i) {
            Arc2D.Double arc;
            double endAngle = origStartAngle - (segmentVals[i + 1] - segmentVals[0]) / delta * sweep;
            double currentPercentage = endAngle - startAngle;
            colorSegments[i] = arc = new Arc2D.Double(ellipseBounds, startAngle, currentPercentage, 2);
            startAngle = endAngle;
        }
        return colorSegments;
    }

    private Rectangle2D.Double[] calculateSkinnableRangeLabelDimensions(Graphics2D gc, Font labelsFont, double[] segmentVals, Format formatter) {
        gc.setFont(labelsFont);
        FontRenderContext frc = gc.getFontRenderContext();
        Rectangle2D.Double[] rangeLabelDimensions = new Rectangle2D.Double[segmentVals.length];
        for (int i = 0; i < segmentVals.length; ++i) {
            TextLayout textLayout = new TextLayout(this.formattedSegmentValues[i], labelsFont, frc);
            Rectangle2D textBounds = textLayout.getBounds();
            rangeLabelDimensions[i] = new Rectangle2D.Double(textBounds.getMinX(), textBounds.getMinY(), textBounds.getWidth(), textBounds.getHeight());
        }
        return rangeLabelDimensions;
    }

    private Insets calculateSkinnableDialTextInsets(double radius, double[] tickmarkAngles, Rectangle2D.Double[] labelPositions, double valueHeight) {
        Insets textInsets = new Insets(0, 0, 0, 0);
        if (!this.showRangeLabels && !this.showValueLabel) {
            return textInsets;
        }
        if (this.showRangeLabels) {
            double maxLeftMargin = 0.0;
            double maxRightMargin = 0.0;
            for (int i = 0; i < tickmarkAngles.length; ++i) {
                if (!this.showMiddleRangeLabels && i != 0 && i != tickmarkAngles.length - 1 || tickmarkAngles[i] == 0.0) continue;
                double labelMargin = labelPositions[i].width - (radius + 2.0 - Math.abs(Math.sin(tickmarkAngles[i])) * (radius + 2.0));
                if (tickmarkAngles[i] > 0.0) {
                    maxRightMargin = Math.max(labelMargin, maxRightMargin);
                    continue;
                }
                if (!(tickmarkAngles[i] < 0.0)) continue;
                maxLeftMargin = Math.max(labelMargin, maxLeftMargin);
            }
            textInsets.left = (int)Math.ceil(maxLeftMargin) + 1;
            textInsets.right = (int)Math.ceil(maxRightMargin) + 1;
            double maxTopMargin = 0.0;
            double maxBottomMargin = 0.0;
            for (int i = 0; i < tickmarkAngles.length; ++i) {
                if (!this.showMiddleRangeLabels && i != 0 && i != tickmarkAngles.length - 1 || Math.abs(tickmarkAngles[i]) == Math.toRadians(90.0)) continue;
                double labelMargin = labelPositions[i].height - (radius + 2.0 - Math.abs(Math.cos(tickmarkAngles[i])) * (radius + 2.0));
                if (Math.abs(tickmarkAngles[i]) > Math.toRadians(90.0)) {
                    maxBottomMargin = Math.max(labelMargin, maxBottomMargin);
                    continue;
                }
                if (!(Math.abs(tickmarkAngles[i]) < Math.toRadians(90.0))) continue;
                maxTopMargin = Math.max(labelMargin, maxTopMargin);
            }
            textInsets.top = (int)Math.ceil(maxTopMargin) + 1;
            textInsets.bottom = (int)Math.ceil(maxBottomMargin) + 1;
        }
        if (this.showValueLabel) {
            textInsets.bottom += (int)Math.ceil(valueHeight);
        }
        return textInsets;
    }

    private double[] calculateSkinnableDialTickmarkAngles(double startAngle, double sweep, double[] segmentVals) {
        double delta = segmentVals[segmentVals.length - 1] - segmentVals[0];
        double[] tickmarkAngles = new double[segmentVals.length];
        for (int i = 0; i < tickmarkAngles.length; ++i) {
            double theta;
            double relativePosition = Math.min(Math.max((segmentVals[i] - segmentVals[0]) / delta, 0.0), 1.0);
            double tickAngle = relativePosition * sweep - (startAngle - 90.0);
            tickmarkAngles[i] = theta = tickAngle * (Math.PI / 180);
        }
        return tickmarkAngles;
    }

    private void calculateSkinnableDialRangeLabelCollisions(Rectangle2D.Double[] rangeLabelPositions, double[] tickmarkAngles, double radius, double[] segmentVals) {
        int i;
        for (i = 0; i < rangeLabelPositions.length; ++i) {
            rangeLabelPositions[i].x = (radius + 2.0) * Math.sin(tickmarkAngles[i]) - rangeLabelPositions[i].x;
            rangeLabelPositions[i].y = -((radius + 2.0) * Math.cos(tickmarkAngles[i])) - rangeLabelPositions[i].y;
            if (tickmarkAngles[i] < Math.toRadians(-90.0)) {
                rangeLabelPositions[i].x -= rangeLabelPositions[i].width;
                continue;
            }
            if (tickmarkAngles[i] == Math.toRadians(-90.0)) {
                rangeLabelPositions[i].x -= rangeLabelPositions[i].width;
                rangeLabelPositions[i].y -= 0.5 * rangeLabelPositions[i].height;
                continue;
            }
            if (tickmarkAngles[i] < Math.toRadians(0.0)) {
                rangeLabelPositions[i].x -= rangeLabelPositions[i].width;
                rangeLabelPositions[i].y -= rangeLabelPositions[i].height;
                continue;
            }
            if (tickmarkAngles[i] == Math.toRadians(0.0)) {
                rangeLabelPositions[i].x -= 0.5 * rangeLabelPositions[i].width;
                rangeLabelPositions[i].y -= rangeLabelPositions[i].height;
                continue;
            }
            if (tickmarkAngles[i] < Math.toRadians(90.0)) {
                rangeLabelPositions[i].y -= rangeLabelPositions[i].height;
                continue;
            }
            if (tickmarkAngles[i] == Math.toRadians(90.0)) {
                rangeLabelPositions[i].y -= 0.5 * rangeLabelPositions[i].height;
                continue;
            }
            if (!(tickmarkAngles[i] < Math.toRadians(180.0))) continue;
        }
        for (i = 1; i < rangeLabelPositions.length; ++i) {
            if (this.isPreviousSegmentEqual(segmentVals, i) || !rangeLabelPositions[i].intersects(rangeLabelPositions[i - 1])) continue;
            this.showMiddleRangeLabels = false;
            return;
        }
    }

    private double calculateSkinnableDialRadius(Rectangle componentBounds, double[] tickmarkAngles, Rectangle2D.Double[] rangeLabelDimensions, double maxRadius, double valueHeight) {
        double maximumRadius = Math.min(maxRadius, Math.min(componentBounds.getWidth() / 2.0, (componentBounds.getHeight() - (this.showValueLabel ? valueHeight : 0.0)) / 2.0));
        if (!this.showRangeLabels) {
            return maximumRadius;
        }
        double minimumRadius = 0.0;
        if (maximumRadius < minimumRadius) {
            this.displayGraph = false;
            return maximumRadius;
        }
        double[] fractionOfWidth = new double[tickmarkAngles.length];
        double[] fractionOfHeight = new double[tickmarkAngles.length];
        for (int i = 0; i < tickmarkAngles.length; ++i) {
            fractionOfWidth[i] = Math.abs(Math.sin(tickmarkAngles[i]));
            fractionOfHeight[i] = Math.abs(Math.cos(tickmarkAngles[i]));
        }
        int numberOfSteps = (int)Math.ceil(Math.log(maximumRadius) / Math.log(2.0));
        double currentRadius = maximumRadius;
        double lowRadius = minimumRadius;
        double highRadius = maximumRadius;
        for (int i = 0; i < numberOfSteps; ++i) {
            double maximumWidthLeftside = currentRadius;
            double maximumWidthRightside = currentRadius;
            for (int j = 0; j < tickmarkAngles.length; ++j) {
                if (tickmarkAngles[j] == 0.0) continue;
                double currentWidth = rangeLabelDimensions[j].getWidth() + currentRadius * fractionOfWidth[j];
                if (!this.showMiddleRangeLabels && j != 0 && j != tickmarkAngles.length - 1) continue;
                if (tickmarkAngles[j] < 0.0) {
                    maximumWidthLeftside = Math.max(maximumWidthLeftside, currentWidth);
                    continue;
                }
                maximumWidthRightside = Math.max(maximumWidthRightside, currentWidth);
            }
            if (maximumWidthLeftside + maximumWidthRightside > componentBounds.getWidth()) {
                highRadius = currentRadius;
                currentRadius = lowRadius + (currentRadius - lowRadius) / 2.0;
                continue;
            }
            if (currentRadius == maximumRadius) break;
            lowRadius = currentRadius;
            currentRadius += (highRadius - currentRadius) / 2.0;
        }
        double bestRadiusForWidth = currentRadius;
        currentRadius = maximumRadius;
        lowRadius = minimumRadius;
        highRadius = maximumRadius;
        for (int i = 0; i < numberOfSteps; ++i) {
            double maximumHeightTop = currentRadius;
            double maximumHeightBottom = currentRadius;
            for (int j = 0; j < tickmarkAngles.length; ++j) {
                if (Math.abs(tickmarkAngles[j]) == Math.toRadians(90.0)) continue;
                double currentHeight = rangeLabelDimensions[j].getHeight() + currentRadius * fractionOfHeight[j];
                if (!this.showMiddleRangeLabels && j != 0 && j != tickmarkAngles.length - 1) continue;
                if (Math.abs(tickmarkAngles[j]) < Math.toRadians(90.0)) {
                    maximumHeightTop = Math.max(maximumHeightTop, currentHeight);
                    continue;
                }
                maximumHeightBottom = Math.max(maximumHeightBottom, currentHeight);
            }
            double d = this.showValueLabel ? valueHeight : 0.0;
            if (maximumHeightTop + maximumHeightBottom + d > componentBounds.getHeight()) {
                highRadius = currentRadius;
                currentRadius = lowRadius + (currentRadius - lowRadius) / 2.0;
                continue;
            }
            if (currentRadius == maximumRadius) break;
            lowRadius = currentRadius;
            currentRadius += (highRadius - currentRadius) / 2.0;
        }
        double bestRadiusForHeight = currentRadius;
        return Math.min(bestRadiusForHeight, bestRadiusForWidth) - 3.0;
    }

    private Insets calculateDialLabelInsets(Graphics2D gc, Rectangle drawSpace, double[] segmentValues, double idealWidth, double idealHeight) {
        return this.calculateDialLabelInsets(gc, drawSpace, segmentValues, idealWidth, idealHeight, true);
    }

    private Insets calculateDialLabelInsets(Graphics2D gc, Rectangle drawSpace, double[] segmentValues, double idealWidth, double idealHeight, boolean determineVisibleText) {
        Insets maxTextInsets = new Insets(0, 0, 0, 0);
        if (!this.showRangeLabels && !this.showValueLabel) {
            return maxTextInsets;
        }
        Font labelsFont = this.kpiRendererModel.getRangeValueTextStyle().getFont();
        NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
        actualVariable.init();
        Format formatter = actualVariable.getJavaFormat();
        if (formatter == null) {
            formatter = new DecimalFormat(new String("#0.##"));
        }
        gc.setFont(labelsFont);
        String firstRangeLabel = this.formattedSegmentValues[0];
        String lastRangeLabel = this.formattedSegmentValues[segmentValues.length - 1];
        FontMetrics fontMetrics = gc.getFontMetrics();
        this.rangeLabelHeight = Math.round(fontMetrics.getHeight() - fontMetrics.getLeading() - fontMetrics.getDescent());
        int firstLabelWidth = fontMetrics.stringWidth(firstRangeLabel);
        int lastLabelWidth = fontMetrics.stringWidth(lastRangeLabel);
        double maxLabelWidth = Math.max(firstLabelWidth, lastLabelWidth);
        this.rangeLabelWidths = new double[segmentValues.length];
        int rangeLabelSpacing = 3;
        this.rangeLabelWidths[0] = firstLabelWidth;
        this.rangeLabelWidths[this.rangeLabelWidths.length - 1] = lastLabelWidth;
        for (int i = 1; i < segmentValues.length - 1; ++i) {
            String rangeLabel = this.formattedSegmentValues[i];
            this.rangeLabelWidths[i] = fontMetrics.stringWidth(rangeLabel);
            maxLabelWidth = Math.max(maxLabelWidth, this.rangeLabelWidths[i]);
        }
        Font valueFont = this.kpiRendererModel.getActualValueTextStyle().getFont();
        gc.setFont(valueFont);
        fontMetrics = gc.getFontMetrics();
        int valueHeight = fontMetrics.getHeight() - fontMetrics.getLeading() - (int)(0.25 * (double)fontMetrics.getDescent());
        int valueLabelSpace = 5;
        if (determineVisibleText && drawSpace.width < firstLabelWidth + lastLabelWidth + 2) {
            this.showRangeLabels = false;
        }
        int smallestGraphWidth = 28;
        int smallestGraphHeight = (int)((double)smallestGraphWidth * (idealHeight / idealWidth));
        if (determineVisibleText && drawSpace.height - smallestGraphHeight < valueHeight + valueLabelSpace) {
            this.showValueLabel = false;
            this.showRangeLabels = false;
            return maxTextInsets;
        }
        if (this.showRangeLabels) {
            maxTextInsets.left = (int)(maxLabelWidth + (double)rangeLabelSpacing);
            maxTextInsets.right = (int)(maxLabelWidth + (double)rangeLabelSpacing);
            maxTextInsets.bottom = (int)Math.ceil(this.rangeLabelHeight + rangeLabelSpacing);
            if (this.showMiddleRangeLabels) {
                maxTextInsets.top = (int)Math.ceil(this.rangeLabelHeight + rangeLabelSpacing);
            }
        } else {
            maxTextInsets.left = 0;
            maxTextInsets.right = 0;
            maxTextInsets.bottom = 0;
        }
        if (this.showValueLabel) {
            valueLabelSpace = Math.max(maxTextInsets.bottom, valueLabelSpace);
            maxTextInsets.bottom = valueHeight + valueLabelSpace;
        }
        return maxTextInsets;
    }

    protected double[] getSegmentValues() {
        double[] rangeSegmentValues = this.kpiRendererModel.getSegmentedRangeColorModel().getSegmentedRange();
        int numRange = rangeSegmentValues.length;
        double[] labelValue = new double[numRange];
        double value0 = rangeSegmentValues[0];
        double valueN = rangeSegmentValues[numRange - 1];
        labelValue[0] = value0;
        labelValue[labelValue.length - 1] = valueN;
        for (int i = 1; i < numRange - 1; ++i) {
            labelValue[i] = rangeSegmentValues[i];
        }
        return labelValue;
    }

    private double[] calculateSpeedometerTickValues(double[] segmentVals, int numMajorSegments) {
        double maxVal = segmentVals[segmentVals.length - 1];
        double minVal = segmentVals[0];
        double delta = maxVal - minVal;
        double currentVal = minVal;
        double[] tickValues = new double[1 + numMajorSegments];
        double segmentDelta = delta / (double)numMajorSegments;
        for (int i = 0; i < tickValues.length; ++i) {
            tickValues[i] = currentVal;
            currentVal = minVal + (double)(i + 1) * segmentDelta;
            double epsilon = Math.abs(currentVal) < 1.0 ? currentVal / 1.0E14 : 0.0;
            currentVal += epsilon;
        }
        return tickValues;
    }

    private String[] getFormattedSegmentValues(double[] segmentVals) {
        String[] formattedVals = new String[segmentVals.length];
        NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
        Format formatter = actualVariable.getJavaFormat();
        if (formatter == null) {
            formatter = new DecimalFormat(new String("#0.##"));
        }
        for (int i = 0; i < segmentVals.length; ++i) {
            formattedVals[i] = formatter.format(new Double(segmentVals[i])).trim();
        }
        return formattedVals;
    }

    private void setupImageCache() {
        RendererUtil.Skin skin = this.kpiRendererModel.getSkin();
        if (this.imageCache == null) {
            this.imageCache = new KPIChartCache();
        }
        if (skin == RendererUtil.Skin.CUSTOM) {
            KPIChartCustomSkinModel customModel = this.kpiRendererModel.getCustomSkinModel();
            if (customModel != null) {
                this.imageCache.setCustomSkinModel(customModel);
            } else {
                skin = RendererUtil.Skin.MODERN;
            }
        }
        this.imageCache.setSkinType(skin);
        KPIChartSegmentedRangeColorModel rangeModel = this.kpiRendererModel.getSegmentedRangeColorModel();
        this.imageCache.setKPIChartType(this.kpiRendererModel.getKPIChartType(), this.kpiRendererModel.isActualValueVisiblityEnabled());
        this.imageCache.setRangeModel(rangeModel);
        this.imageCache.setOrientation(this.kpiRendererModel.getOrientation());
    }

    public static BufferedImage newBufferedImage(int width, int height) {
        if (Util.isHeadless()) {
            return new BufferedImage(width, height, 3);
        }
        BufferedImage image = new BufferedImage(width, height, 3);
        return image.createGraphics().getDeviceConfiguration().createCompatibleImage(width, height);
    }

    private String getMagnitudeLabel() {
        return Util.getFactorLabel(this.factor);
    }

    public static BufferedImage getFastScaledImage(BufferedImage img, int targetWidth, int targetHeight) {
        if (targetWidth <= 0 || targetHeight <= 0) {
            return null;
        }
        BufferedImage ret = img;
        int w = img.getWidth();
        int h = img.getHeight();
        int prevW = w;
        int prevH = h;
        BufferedImage oldScratchImage = null;
        BufferedImage newScratchImage = null;
        Graphics2D oldScratchGraphics = null;
        Graphics2D newScratchGraphics = null;
        if (w < targetWidth) {
            w = targetWidth;
        }
        if (h < targetHeight) {
            h = targetHeight;
        }
        do {
            if (w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            if (oldScratchImage == null) {
                oldScratchImage = KPIChartRenderer.newBufferedImage(w, h);
                newScratchImage = KPIChartRenderer.newBufferedImage(w, h);
                oldScratchGraphics = oldScratchImage.createGraphics();
                oldScratchGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                newScratchGraphics = newScratchImage.createGraphics();
                newScratchGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                newScratchGraphics.drawImage(img, 0, 0, w, h, 0, 0, prevW, prevH, null);
            } else {
                Composite oldComposite = newScratchGraphics.getComposite();
                newScratchGraphics.setComposite(AlphaComposite.Clear);
                newScratchGraphics.fillRect(0, 0, w, h);
                newScratchGraphics.setComposite(oldComposite);
                newScratchGraphics.drawImage(oldScratchImage, 0, 0, w, h, 0, 0, prevW, prevH, null);
            }
            ret = newScratchImage;
            prevW = w;
            prevH = h;
            BufferedImage tempImage = oldScratchImage;
            oldScratchImage = newScratchImage;
            newScratchImage = tempImage;
            Graphics2D tempGraphics = oldScratchGraphics;
            oldScratchGraphics = newScratchGraphics;
            newScratchGraphics = tempGraphics;
        } while (w != targetWidth || h != targetHeight);
        if (oldScratchGraphics != null) {
            oldScratchGraphics.dispose();
        }
        if (newScratchGraphics != null) {
            newScratchGraphics.dispose();
        }
        if (targetWidth != ret.getWidth() || targetHeight != ret.getHeight()) {
            BufferedImage buffer = KPIChartRenderer.newBufferedImage(targetWidth, targetHeight);
            Graphics2D bufferGraphics = buffer.createGraphics();
            bufferGraphics.drawImage((Image)ret, 0, 0, null);
            bufferGraphics.dispose();
            ret = buffer;
        }
        return ret;
    }

    public Dimension getPreferredSize() {
        RendererUtil.KPIChartType type = this.kpiRendererModel.getKPIChartType();
        int chartWidth = 200;
        int chartHeight = 200;
        double[] values = this.getSegmentValues();
        int orientation = this.kpiRendererModel.getOrientation();
        boolean show3Delements = this.kpiRendererModel.getSkin() == RendererUtil.Skin.SATIN;
        Graphics2D gc = new BufferedImage(2, 2, 2).createGraphics();
        this.showRangeLabels = this.kpiRendererModel.isRangeValueVisiblityEnabled();
        this.showValueLabel = this.kpiRendererModel.isActualValueVisiblityEnabled();
        if (this.formattedSegmentValues == null) {
            this.formattedSegmentValues = this.getFormattedSegmentValues(this.getSegmentValues());
        }
        if (type == RendererUtil.KPIChartType.BULLET || type == RendererUtil.KPIChartType.SLIDER) {
            Insets labelInsets = this.calculateBulletGraphLabelInsets(gc, new Rectangle(500, 500), values, false);
            chartWidth = 160;
            chartHeight = 35;
            if (orientation == 1) {
                int tempWidth = chartWidth;
                chartWidth = chartHeight;
                chartHeight = tempWidth;
            }
            chartWidth = chartWidth + labelInsets.left + Math.max(show3Delements ? 4 : 0, labelInsets.right);
            chartHeight = chartHeight + labelInsets.top + Math.max(show3Delements ? 4 : 0, labelInsets.bottom);
        } else if (type == RendererUtil.KPIChartType.SPEEDOMETER_FULL) {
            chartWidth = 181;
            chartHeight = 181;
        } else if (type == RendererUtil.KPIChartType.SPEEDOMETER_HALF || type == RendererUtil.KPIChartType.SPEEDOMETER_QUARTER) {
            chartWidth = 181;
            chartHeight = 137;
        } else if (type == RendererUtil.KPIChartType.DIAL) {
            Insets labelInsets = this.calculateDialLabelInsets(gc, new Rectangle(500, 500), values, 85.0, 85.0, false);
            chartWidth = 90;
            chartHeight = 90;
            chartWidth = chartWidth + labelInsets.left + Math.max(show3Delements ? 4 : 0, labelInsets.right);
            chartHeight = chartHeight + labelInsets.top + Math.max(show3Delements ? 4 : 0, labelInsets.bottom);
        } else if (type == RendererUtil.KPIChartType.TRAFFIC_LIGHT) {
            Insets labelInsets = this.calculateTrafficLightLabelInsets(gc);
            int numSegments = values.length - 1;
            chartHeight = (int)Math.round(47.0) + (show3Delements ? 10 : 5);
            chartWidth = (int)Math.round((double)(38 + 64 * numSegments + 11 * (numSegments - 1)) * 0.5);
            if (orientation == 1) {
                int tempWidth = chartWidth;
                chartWidth = chartHeight;
                chartHeight = tempWidth;
            }
            chartWidth = chartWidth + labelInsets.left + Math.max(show3Delements ? 4 : 0, labelInsets.right);
            chartHeight = chartHeight + labelInsets.top + Math.max(show3Delements ? 4 : 0, labelInsets.bottom);
        }
        return new Dimension(chartWidth, chartHeight);
    }

    private BufferedImage getScaledImage(ImageIcon source, String name, KPIChartSegmentedRangeColorModel rangeModel, double scaleFactor) {
        BufferedImage newImage = (BufferedImage)this.imageCache.getScaledImage(name, scaleFactor, rangeModel);
        if (newImage == null && source != null && source.getIconHeight() > 0 && source.getIconWidth() > 0) {
            newImage = KPIChartRenderer.newBufferedImage(source.getIconWidth(), source.getIconHeight());
            Graphics2D graphics = newImage.createGraphics();
            this.applyRenderingHints(graphics);
            graphics.drawImage(source.getImage(), 0, 0, null);
            graphics.dispose();
            newImage = KPIChartRenderer.getFastScaledImage(newImage, (int)((double)newImage.getWidth() * scaleFactor), (int)((double)newImage.getHeight() * scaleFactor));
            this.imageCache.addScaledImage((Image)newImage, name, scaleFactor, rangeModel);
        }
        return newImage;
    }

    private static float[] getShadowKernel(int radius) {
        int j;
        int i;
        float[] kernel = new float[(radius * 2 + 1) * (radius * 2 + 1)];
        double sum = 0.0;
        int w = 2 * radius + 1;
        double deviation = (double)radius / 3.0;
        double devSqr2 = 2.0 * Math.pow(deviation, 2.0);
        double piDevSqr2 = Math.PI * devSqr2;
        for (i = 0; i < w; ++i) {
            for (j = 0; j < w; ++j) {
                kernel[i * w + j] = (float)(Math.pow(Math.E, (double)(-((j - radius) * (j - radius) + (i - radius) * (i - radius))) / devSqr2) / piDevSqr2);
                sum += (double)kernel[i * w + j];
            }
        }
        for (i = 0; i < w; ++i) {
            for (j = 0; j < w; ++j) {
                int n = i * w + j;
                kernel[n] = (float)((double)kernel[n] / sum);
            }
        }
        return kernel;
    }

    private boolean isAltColorDarker(TextStyle textAttrs) {
        return this.getLuminosity(textAttrs.getAltColor()) < this.getLuminosity(textAttrs.getColor());
    }

    private boolean useAltTextColor(TextStyle textAttr, KPIChartSkinPolicy colorPolicy) {
        if (colorPolicy == KPIChartSkinPolicy.AUTO) {
            return false;
        }
        boolean isAltColorDarker = this.isAltColorDarker(textAttr);
        return colorPolicy == KPIChartSkinPolicy.DARK ? isAltColorDarker : !isAltColorDarker;
    }

    private double getLuminosity(Color rgb) {
        return (double)rgb.getRed() * 0.3 + (double)rgb.getGreen() * 0.59 + (double)rgb.getBlue() * 0.11;
    }

    private void initTextColorPolicy(RendererUtil.KPIChartType kpiType) {
        switch (kpiType) {
            case SPEEDOMETER_FULL: {
                this.rangeTextColorPolicy = KPIChartSkinPolicy.DARK;
                this.valueTextColorPolicy = KPIChartSkinPolicy.DARK;
                break;
            }
            case SPEEDOMETER_HALF: 
            case SPEEDOMETER_QUARTER: {
                this.rangeTextColorPolicy = KPIChartSkinPolicy.DARK;
                this.valueTextColorPolicy = KPIChartSkinPolicy.AUTO;
                break;
            }
            default: {
                this.rangeTextColorPolicy = KPIChartSkinPolicy.AUTO;
                this.valueTextColorPolicy = KPIChartSkinPolicy.AUTO;
            }
        }
        this.isUseAltRangeColor = this.useAltTextColor(this.kpiRendererModel.getRangeValueTextStyle(), this.rangeTextColorPolicy);
        this.isUseAltValueColor = this.useAltTextColor(this.kpiRendererModel.getActualValueTextStyle(), this.valueTextColorPolicy);
    }

    private Color getValueTextStyleColor() {
        TextStyle ts = this.kpiRendererModel.getActualValueTextStyle();
        if (this.isBIP) {
            return ts.getColor();
        }
        return this.isUseAltValueColor ? ts.getAltColor() : ts.getColor();
    }

    private Color getRangeTextStyleColor() {
        TextStyle ts = this.kpiRendererModel.getRangeValueTextStyle();
        if (this.isBIP) {
            return ts.getColor();
        }
        return this.isUseAltRangeColor ? ts.getAltColor() : ts.getColor();
    }

    private boolean isNextSegmentEqual(double[] values, int index) {
        return values[index] == values[index + 1];
    }

    private boolean isPreviousSegmentEqual(double[] values, int index) {
        return values[index] == values[index - 1];
    }

    static enum KPIChartSkinPolicy {
        AUTO,
        LIGHT,
        DARK;

    }

    public class KPIChartColorFilter
    extends RGBImageFilter {
        private int filterColor;

        public KPIChartColorFilter(int newFilterColor) {
            this.filterColor = newFilterColor & 0xFFFFFF;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            return rgb & 0xFF000000 | this.filterColor;
        }
    }
}

