/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.render.kpi;

import com.sas.graphics.util.gtk.render.RendererUtil;
import com.sas.graphics.util.gtk.render.kpi.KPIChartCustomSkinModel;
import com.sas.graphics.util.gtk.render.kpi.KPIChartSegmentedRangeColorModel;
import java.awt.Color;
import java.awt.Image;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import javax.swing.ImageIcon;

public class KPIChartCache {
    HashMap imageCache = new HashMap();
    RendererUtil.Skin skinType;
    RendererUtil.KPIChartType kpiChartType;
    KPIChartCustomSkinModel customSkinModel = null;
    KPIChartSegmentedRangeColorModel rangeModel = null;
    int orientation = -1;
    double scaleFactor = -1.0;
    public static final String TINTED_IMAGE = "tintedImage_";
    public static final String COLORED_SEGMENTS_IMAGE = "coloredSegmentsImage_";
    public static final String COLORED_SEGMENTS = "coloredSegments";
    public static final String SCALED_CACHE = "scaledCache";
    public static final String BACK_LAYER = "backLayer_";
    public static final String RANGE_LABELS = "rangeLabels_";
    public static final String INDICATOR = "indicator_";
    public static final String INDICATOR_CAP = "indicatorCap_";
    public static final String INDICATOR_SHADOW = "indicatorShadow_";
    public static final String INDICATOR_COMPOSITE = "indicatorComposite_";
    public static final String TARGET = "target_";
    public static final String TARGET_SHADOW = "targetShadow_";
    public static final String VALUE_HUB = "valueHub_";
    public static final String EFFECTS = "effects_";
    public static final String BORDER = "border_";
    public static final int KPICHART_TYPE_SPEEDOMETER_FULL_NOLABEL = -1;

    public void setScaleFactor(double scaleFactor) {
        if (scaleFactor == this.scaleFactor) {
            return;
        }
        HashMap scaledCache = (HashMap)this.imageCache.get(SCALED_CACHE);
        if (scaledCache == null) {
            scaledCache = new HashMap();
            this.imageCache.put(SCALED_CACHE, scaledCache);
        } else {
            scaledCache.clear();
        }
        this.scaleFactor = scaleFactor;
    }

    public void setRangeModel(KPIChartSegmentedRangeColorModel rangeModel) {
        if (rangeModel.equals(this.rangeModel)) {
            return;
        }
        this.clearCache();
        if (this.rangeModel == null) {
            this.rangeModel = new KPIChartSegmentedRangeColorModel(rangeModel.getSegmentedRange(), rangeModel.isBoundaryInHigherSegment(), null, null);
        }
        this.rangeModel.apply(rangeModel);
    }

    public void setOrientation(int orientation) {
        if (orientation == this.orientation) {
            return;
        }
        this.clearCache();
        this.orientation = orientation;
    }

    public void setKPIChartType(RendererUtil.KPIChartType newType, boolean isVisible) {
        if (newType == RendererUtil.KPIChartType.SPEEDOMETER_FULL && !isVisible) {
            newType = RendererUtil.KPIChartType.SPEEDOMETER_FULL_NOLABEL;
        }
        if (this.kpiChartType == newType) {
            return;
        }
        this.clearCache();
        this.kpiChartType = newType;
    }

    public void setSkinType(RendererUtil.Skin newType) {
        if (this.skinType == newType) {
            return;
        }
        this.clearCache();
        this.skinType = newType;
    }

    public void clearCache() {
        this.imageCache.clear();
        this.imageCache.put(SCALED_CACHE, new HashMap());
    }

    public void setCustomSkinModel(KPIChartCustomSkinModel model) {
        if (model.equals(this.customSkinModel)) {
            return;
        }
        this.clearCache();
        this.customSkinModel = model;
    }

    public void addSegmentsArea(Object segments, KPIChartSegmentedRangeColorModel rangeModel) {
        if (!rangeModel.equals(this.rangeModel)) {
            this.clearCache();
        }
        SoftReference<Object> segmentsToBeAdded = new SoftReference<Object>(segments);
        this.imageCache.put(COLORED_SEGMENTS, segmentsToBeAdded);
    }

    public Object getSegmentsArea(KPIChartSegmentedRangeColorModel rangeModel) {
        if (!rangeModel.equals(this.rangeModel)) {
            return null;
        }
        Object segments = this.getObject(this.imageCache, COLORED_SEGMENTS);
        return segments;
    }

    public void addImageIcon(ImageIcon image, String key, Color color) {
        String lookupKey = key + color.toString();
        this.imageCache.put(lookupKey, new SoftReference<ImageIcon>(image));
    }

    public ImageIcon getImageIcon(String key, Color color) {
        Object image = this.getObject(this.imageCache, key + color.toString());
        return (ImageIcon)image;
    }

    public void addImage(Image image, String key, KPIChartSegmentedRangeColorModel rangeModel, int selectedIndex) {
        if (!rangeModel.equals(this.rangeModel)) {
            this.clearCache();
        }
        String lookupKey = key + selectedIndex;
        this.imageCache.put(lookupKey, new SoftReference<Image>(image));
    }

    public Image getImage(String key, KPIChartSegmentedRangeColorModel rangeModel, int selectedIndex) {
        if (!rangeModel.equals(this.rangeModel)) {
            return null;
        }
        String lookupKey = key + selectedIndex;
        return (Image)this.getObject(this.imageCache, lookupKey);
    }

    public void addImage(Image image, String key, KPIChartSegmentedRangeColorModel rangeModel) {
        if (!rangeModel.equals(this.rangeModel)) {
            this.clearCache();
        }
        String lookupKey = key;
        this.imageCache.put(lookupKey, new SoftReference<Image>(image));
    }

    public Image getImage(String key, KPIChartSegmentedRangeColorModel rangeModel) {
        if (!rangeModel.equals(this.rangeModel)) {
            return null;
        }
        String lookupKey = key;
        return (Image)this.getObject(this.imageCache, lookupKey);
    }

    public Image getScaledImage(String key, double scaleFactor, KPIChartSegmentedRangeColorModel rangeModel, int selectedIndex) {
        HashMap scaledCache = (HashMap)this.imageCache.get(SCALED_CACHE);
        if (!rangeModel.equals(this.rangeModel)) {
            return null;
        }
        if (scaleFactor == this.scaleFactor) {
            return (Image)this.getObject(scaledCache, key + selectedIndex);
        }
        return null;
    }

    public void addScaledImage(Image image, String key, double scaleFactor, KPIChartSegmentedRangeColorModel rangeModel, int selectedIndex) {
        if (!rangeModel.equals(this.rangeModel)) {
            this.clearCache();
        }
        String lookupKey = key + selectedIndex;
        HashMap scaledCache = (HashMap)this.imageCache.get(SCALED_CACHE);
        scaledCache.put(lookupKey, new SoftReference<Image>(image));
    }

    public Image getScaledImage(String key, double scaleFactor, KPIChartSegmentedRangeColorModel rangeModel) {
        HashMap scaledCache = (HashMap)this.imageCache.get(SCALED_CACHE);
        if (scaleFactor == this.scaleFactor) {
            return (Image)this.getObject(scaledCache, key);
        }
        return null;
    }

    public void addScaledImage(Image image, String key, double scaleFactor, KPIChartSegmentedRangeColorModel rangeModel) {
        if (!rangeModel.equals(this.rangeModel)) {
            this.clearCache();
        }
        HashMap scaledCache = (HashMap)this.imageCache.get(SCALED_CACHE);
        scaledCache.put(key, new SoftReference<Image>(image));
    }

    public Image getScaledImage(String key, double scaleFactor, int selectedIndex) {
        HashMap scaledCache = (HashMap)this.imageCache.get(SCALED_CACHE);
        if (scaleFactor == this.scaleFactor) {
            return (Image)this.getObject(scaledCache, key + selectedIndex);
        }
        return null;
    }

    public void addScaledImage(Image image, String key, double scaleFactor, int selectedIndex) {
        HashMap scaledCache = (HashMap)this.imageCache.get(SCALED_CACHE);
        String lookupKey = key + selectedIndex;
        scaledCache.put(lookupKey, new SoftReference<Image>(image));
    }

    private Object getObject(HashMap map, Object key) {
        SoftReference refToImage = (SoftReference)map.get(key);
        return refToImage == null ? null : refToImage.get();
    }
}

