/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.labeling;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.labeling.LabelLayoutInterface;
import com.sas.graphics.util.gtk.labeling.LabelLayoutManagerInterface;
import com.sas.graphics.util.gtk.labeling.PointLabelLayout;
import com.sas.graphics.util.labeling.Graph;
import com.sas.graphics.util.labeling.Node;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;

public final class PointLabelLayoutManager
implements LabelLayoutManagerInterface {
    ArrayList layouts = new ArrayList();
    Graph cg;
    Rectangle clipBounds;
    private static final Ellipse2D arrowHeadEllipse = new Ellipse2D.Double(-6.0, -6.0, 12.0, 12.0);

    public PointLabelLayoutManager(Rectangle bounds) {
        this.clipBounds = bounds;
    }

    public void addLayout(PointLabelLayout layout) {
        this.layouts.add(layout);
        layout.setLayoutManager(this);
    }

    public void init(PointLabelLayout layout, AInitAction initAction) {
        double ypos;
        double xpos2;
        int j;
        PointLabelLayout l;
        int i;
        int vc = 0;
        boolean beenInitialized = true;
        for (i = 0; i < this.layouts.size(); ++i) {
            l = (PointLabelLayout)this.layouts.get(i);
            initAction.pushValueCount();
            l.x.init(initAction);
            l.y.init(initAction);
            l.label.init(initAction);
            vc = initAction.getValueCount();
            l.setValueCount(vc);
            initAction.popValueCount();
            beenInitialized &= initAction.beenInitialized(l);
        }
        if (beenInitialized) {
            return;
        }
        this.cg = new Graph(this.clipBounds);
        for (i = 0; i < this.layouts.size(); ++i) {
            l = (PointLabelLayout)this.layouts.get(i);
            if (l.isProtectedCurve()) {
                GeneralPath obstacle = new GeneralPath();
                this.cg.addObstacle((Shape)obstacle);
                for (j = 0; j < l.getValueCount(); ++j) {
                    try {
                        xpos2 = l.x.getValue(j);
                        ypos = (double)(this.clipBounds.y + this.clipBounds.height) - l.y.getValue(j);
                        Graph.addObstaclePoint((GeneralPath)obstacle, (int)((int)xpos2), (int)((int)ypos));
                        continue;
                    }
                    catch (MissingValueException xpos2) {
                        // empty catch block
                    }
                }
                continue;
            }
            if (!l.isVectorPlot()) continue;
            for (int j2 = 0; j2 < l.getValueCount(); ++j2) {
                try {
                    double xpos3 = l.x.getValue(j2);
                    double ypos2 = (double)(this.clipBounds.y + this.clipBounds.height) - l.y.getValue(j2);
                    double vox = l.getVectorOriginX();
                    double voy = this.clipBounds.y + this.clipBounds.height - l.getVectorOriginY();
                    Shape arrowHeadBBox = PointLabelLayoutManager.createArrowHeadBBox(vox, voy, xpos3, ypos2);
                    this.cg.addObstacle(arrowHeadBBox);
                    continue;
                }
                catch (MissingValueException xpos3) {
                    // empty catch block
                }
            }
        }
        if (this.cg.isFreeOfObstacles()) {
            this.cg.setHMaxShift(20);
            this.cg.setVMaxShift(4);
            this.cg.setVDistanceWeight(2.0);
        } else {
            this.cg.setHMaxShift(20);
            this.cg.setVMaxShift(6);
            this.cg.setVDistanceWeight(2.0);
        }
        int offset = 0;
        for (int i2 = 0; i2 < this.layouts.size(); ++i2) {
            PointLabelLayout l2 = (PointLabelLayout)this.layouts.get(i2);
            if (l2.isProtectedCurve() && !l2.isLabelConnected()) continue;
            for (j = 0; j < l2.getValueCount(); ++j) {
                xpos2 = -1.7976931348623157E308;
                ypos = -1.7976931348623157E308;
                try {
                    xpos2 = l2.x.getValue(j);
                    ypos = (double)(this.clipBounds.y + this.clipBounds.height) - l2.y.getValue(j);
                    String str = " " + l2.label.getValue(j).trim() + " ";
                    this.cg.addNode(j, str, (int)xpos2, (int)ypos, l2.getFontMetrics(), l2.getMarkerSize());
                    continue;
                }
                catch (MissingValueException e) {
                    if (xpos2 == -1.7976931348623157E308 || ypos == -1.7976931348623157E308) {
                        this.cg.addNode(j, null, -1, -1, null, 0);
                        continue;
                    }
                    this.cg.addNode(j, " ", (int)xpos2, (int)ypos, l2.getFontMetrics(), l2.getMarkerSize());
                }
            }
            l2.setIndexOffset(offset);
            offset += l2.getValueCount();
        }
        this.cg.buildConflictGraph();
        this.cg.placeLabels();
    }

    @Override
    public int getAlignValue(int i, LabelLayoutInterface layout, boolean v) {
        int align;
        Node n;
        try {
            n = this.cg.getNode(i + layout.getIndexOffset());
        }
        catch (Exception e) {
            return -1;
        }
        if (n.text == null || n.text.trim().length() == 0) {
            return -1;
        }
        switch (n.getLabelPosition()) {
            case 0: {
                if (!v) {
                    align = 0;
                    break;
                }
                align = 3;
                break;
            }
            case 1: {
                if (!v) {
                    align = 2;
                    break;
                }
                align = 3;
                break;
            }
            case 2: {
                if (!v) {
                    align = 0;
                    break;
                }
                align = 0;
                break;
            }
            case 3: {
                if (!v) {
                    align = 2;
                    break;
                }
                align = 0;
                break;
            }
            case 4: {
                if (!v) {
                    align = 0;
                    break;
                }
                align = 1;
                break;
            }
            case 5: {
                if (!v) {
                    align = 1;
                    break;
                }
                align = 3;
                break;
            }
            case 6: {
                if (!v) {
                    align = 2;
                    break;
                }
                align = 1;
                break;
            }
            case 7: {
                if (!v) {
                    align = 1;
                    break;
                }
                align = 0;
                break;
            }
            default: {
                align = -1;
            }
        }
        return align;
    }

    @Override
    public String getLabelValue(int i, LabelLayoutInterface layout) {
        Node n;
        try {
            n = this.cg.getNode(i + layout.getIndexOffset());
        }
        catch (Exception e) {
            return null;
        }
        if (n.text == null || n.text.trim().length() == 0) {
            return null;
        }
        return n.text;
    }

    @Override
    public double getPositionValue(int i, LabelLayoutInterface l, boolean isVertical) {
        double value;
        Node n;
        PointLabelLayout layout = (PointLabelLayout)l;
        try {
            n = this.cg.getNode(i + layout.getIndexOffset());
            value = isVertical ? layout.y.getValue(i) - (double)n.dy : layout.x.getValue(i) + (double)n.dx;
            int hms = layout.getMarkerSize() / 2;
            value += (double)this.offsetByHalfMarkerSize(n.getLabelPosition(), isVertical, hms);
        }
        catch (Exception e) {
            return Double.NaN;
        }
        if (n.text == null || n.text.trim().length() == 0) {
            return Double.NaN;
        }
        return value;
    }

    private int offsetByHalfMarkerSize(int labelPosition, boolean vertical, int hms) {
        int offset = 0;
        switch (labelPosition) {
            default: {
                break;
            }
            case 0: {
                if (vertical) break;
                offset = hms;
                break;
            }
            case 1: {
                if (vertical) break;
                offset = -hms;
                break;
            }
            case 2: {
                if (vertical) break;
                offset = hms;
                break;
            }
            case 3: {
                if (vertical) break;
                offset = -hms;
                break;
            }
            case 4: {
                if (vertical) break;
                offset = hms;
                break;
            }
            case 5: {
                if (!vertical) break;
                offset = hms;
                break;
            }
            case 6: {
                if (vertical) break;
                offset = -hms;
                break;
            }
            case 7: {
                if (!vertical) break;
                offset = -hms;
            }
        }
        return offset;
    }

    private static Shape createArrowHeadBBox(double x1, double y1, double x2, double y2) {
        AffineTransform at;
        double d = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        if (d == 0.0) {
            at = AffineTransform.getTranslateInstance(x2, y2);
        } else {
            double x = x2 - 4.0 * (x2 - x1) / d;
            double y = y2 - 4.0 * (y2 - y1) / d;
            at = AffineTransform.getTranslateInstance(x, y);
        }
        return at.createTransformedShape(arrowHeadEllipse);
    }

    @Override
    public double getAngleValue(int i, LabelLayoutInterface layout) {
        return 0.0;
    }

    @Override
    public Color getColorValue(int i, LabelLayoutInterface layout) {
        return Color.BLACK;
    }
}

