/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.Plane;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ATriangleConnector;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.SelectDetail;
import com.sas.graphics.util.gtk.TriangleConnectorDetail;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;
import java.util.Iterator;
import java.util.Stack;

public class TriangleConnector
extends ATriangleConnector {
    public static final int SAMPLE_POLICY_LINE = 1;
    public static final int SAMPLE_POLICY_FILL_AND_LINE = 2;
    private static final int CORNER_0 = 0;
    private static final int CORNER_1 = 1;
    private static final int CORNER_2 = 2;
    private static final int CORNER_3 = 3;
    private int pointCount;
    private int rowSampleSize = 1;
    private int columnSampleSize = 1;
    private Vec3d edge1 = new Vec3d();
    private Vec3d edge2 = new Vec3d();
    private Vec3d v1 = new Vec3d();
    private Vec3d v2 = new Vec3d();
    private Vec3d v3 = new Vec3d();
    private Vec3d v4 = new Vec3d();
    private int[] cornerIndex = new int[4];
    private int[] backEdgeIndices = new int[2];
    private int maximumGridSampleSize = Integer.MAX_VALUE;
    private int samplePolicy = 2;
    private SurfaceIterator iter = new SurfaceIterator();

    public TriangleConnector() {
        super(new Transform());
    }

    public void setGridPlane(Plane gridPlane) {
    }

    public void setRowSampleSize(int rowSampleSize) {
        if (rowSampleSize <= 0) {
            throw new IllegalArgumentException("rowSampleSize must be >0");
        }
        this.rowSampleSize = rowSampleSize;
    }

    public int getRowSampleSize() {
        return this.rowSampleSize;
    }

    public void setColumnSampleSize(int columnSampleSize) {
        if (columnSampleSize <= 0) {
            throw new IllegalArgumentException("columnSampleSize must be >0");
        }
        this.columnSampleSize = columnSampleSize;
    }

    public int getColumnSampleSize() {
        return this.columnSampleSize;
    }

    public void setMaximumGridSampleSize(int maximumGridSampleSize) {
        this.maximumGridSampleSize = maximumGridSampleSize;
        this.setRowSampleSize(1);
        this.setColumnSampleSize(1);
    }

    public int getMaximumGridSampleSize() {
        return this.maximumGridSampleSize;
    }

    public void setAlpha(float alpha) {
    }

    @Override
    public void init(AInitAction initAction) {
        super.init(initAction);
        initAction.pushValueCount();
        this.edgeColor.init(initAction);
        this.color.init(initAction);
        this.pointX.init(initAction);
        this.pointY.init(initAction);
        this.pointZ.init(initAction);
        this.pointCount = initAction.getValueCount();
        initAction.popValueCount();
        this.setupCornerIndices();
    }

    private void setupCornerIndices() {
        this.cornerIndex[0] = 0;
        this.cornerIndex[1] = this.width - 1;
        this.cornerIndex[2] = this.pointCount - this.width;
        this.cornerIndex[3] = this.pointCount - 1;
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        boolean detailsEnabled = false;
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        Channel channel = ba.getChannel();
        int index = ba.getValueIndex();
        if (this.width == 0) {
            throw new IllegalStateException("Width must be set a value > 0. Use setWidth().");
        }
        try {
            detailsEnabled = this.selectDetailEnabled.getValue(index);
        }
        catch (MissingValueException e) {
            detailsEnabled = false;
        }
        boolean useNameStack = detailsEnabled && ba.isUseNameStack();
        channel.glPushAttrib(0);
        channel.glEdgeColor(this.edgeColor.getValue(index));
        boolean fo = this.fillOn.getValue(index);
        boolean eo = this.edgeOn.getValue(index);
        if (fo) {
            this.drawFill(channel, useNameStack);
        }
        if (eo) {
            this.drawEdge(channel, fo);
        }
        channel.glPopAttrib();
    }

    private void drawFill(Channel channel, boolean useNameStack) {
        int saveRowSampleSize = this.getRowSampleSize();
        int saveColumnSampleSize = this.getColumnSampleSize();
        if (this.samplePolicy == 2) {
            if (this.getMaximumGridSampleSize() < Integer.MAX_VALUE && this.getMajorGridCount() > this.getMaximumGridSampleSize()) {
                int sampleSize = (int)Math.ceil(this.getMajorGridCount() / this.getMaximumGridSampleSize());
                this.setColumnSampleSize(sampleSize);
                sampleSize = (int)Math.ceil(this.pointCount / this.getMajorGridCount() / this.getMaximumGridSampleSize());
                this.setRowSampleSize(sampleSize);
            }
        } else {
            this.setRowSampleSize(1);
            this.setColumnSampleSize(1);
        }
        channel.glPolygonMode(2, 3);
        channel.glFrontFace(1);
        channel.glDisable(0);
        this.findBackEdgeIndices(channel);
        this.iter.setStartEdge(this.backEdgeIndices[0], this.backEdgeIndices[1]);
        this.iter.reset();
        while (this.iter.hasNext()) {
            Section section = (Section)this.iter.next();
            this.drawSection(section, channel, useNameStack);
        }
        this.setRowSampleSize(saveRowSampleSize);
        this.setColumnSampleSize(saveColumnSampleSize);
    }

    private void drawEdge(Channel channel, boolean fo) {
        int vertexIndex2;
        int vertexIndex1;
        int row;
        int col;
        int columnIncrement = 1;
        int rowIncrement = 1;
        if (this.samplePolicy == 2 || this.samplePolicy == 1) {
            if (this.getMaximumGridSampleSize() < Integer.MAX_VALUE) {
                if (this.getMajorGridCount() > this.getMaximumGridSampleSize()) {
                    columnIncrement = (int)Math.ceil(this.getMajorGridCount() / this.getMaximumGridSampleSize());
                    rowIncrement = (int)Math.ceil(this.pointCount / this.getMajorGridCount() / this.getMaximumGridSampleSize());
                    columnIncrement = Math.max(columnIncrement, 1);
                    rowIncrement = Math.max(rowIncrement, 1);
                }
            } else {
                columnIncrement = this.getColumnSampleSize();
                rowIncrement = this.getRowSampleSize();
            }
        }
        channel.glEnable(30);
        channel.glPolygonOffset(-0.75f, -0.9f);
        for (col = 0; col < this.width; col += columnIncrement) {
            for (row = 1; row < this.pointCount / this.width; ++row) {
                vertexIndex1 = col + (row - 1) * this.width;
                vertexIndex2 = col + row * this.width;
                this.readDataDrawLine(channel, fo, vertexIndex1, vertexIndex2);
            }
        }
        for (row = 0; row < this.pointCount / this.width; row += rowIncrement) {
            for (col = 1; col < this.width; ++col) {
                vertexIndex1 = col - 1 + row * this.width;
                vertexIndex2 = col + row * this.width;
                this.readDataDrawLine(channel, fo, vertexIndex1, vertexIndex2);
            }
        }
    }

    private void readDataDrawLine(Channel channel, boolean fo, int vertexIndex1, int vertexIndex2) {
        try {
            Color c2;
            Color c1;
            if (fo) {
                c1 = this.edgeColor.getValue(vertexIndex1);
                c2 = this.edgeColor.getValue(vertexIndex2);
            } else {
                c1 = this.color.getValue(vertexIndex1);
                c2 = this.color.getValue(vertexIndex2);
            }
            Color c = c1;
            if (c1 != c2) {
                c = new Color((c1.getRed() + c2.getRed()) / 2, (c1.getGreen() + c2.getGreen()) / 2, (c1.getBlue() + c2.getBlue()) / 2, (c1.getAlpha() + c2.getAlpha()) / 2);
            }
            channel.glColor(c);
            this.v1.x = this.pointX.getValue(vertexIndex1);
            this.v1.y = this.pointY.getValue(vertexIndex1);
            this.v1.z = this.pointZ.getValue(vertexIndex1);
            this.v2.x = this.pointX.getValue(vertexIndex2);
            this.v2.y = this.pointY.getValue(vertexIndex2);
            this.v2.z = this.pointZ.getValue(vertexIndex2);
            channel.glBegin(1);
            channel.glVertex(this.v1.x, this.v1.y, this.v1.z);
            channel.glVertex(this.v2.x, this.v2.y, this.v2.z);
            channel.glEnd();
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
    }

    private void findBackEdgeIndices(Channel channel) {
        int farthestIndex = 0;
        int secondFarthestIndex = 0;
        double farthestZ = Double.NEGATIVE_INFINITY;
        double secondFarthestZ = Double.NEGATIVE_INFINITY;
        double[] object = new double[3];
        double[] window = new double[3];
        double[] cornerZ = new double[4];
        for (int corner = 0; corner < this.cornerIndex.length; ++corner) {
            try {
                object[0] = this.pointX.getValue(this.cornerIndex[corner]);
                object[1] = this.pointY.getValue(this.cornerIndex[corner]);
                object[2] = this.pointZ.getValue(this.cornerIndex[corner]);
                channel.gluProject(object, window);
                cornerZ[corner] = window[2];
                if (!(window[2] > farthestZ)) continue;
                if (farthestZ > secondFarthestZ) {
                    secondFarthestZ = farthestZ;
                    secondFarthestIndex = farthestIndex;
                }
                farthestZ = window[2];
                farthestIndex = this.cornerIndex[corner];
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        int farthestCorner = this.indexToCorner(farthestIndex);
        switch (farthestCorner) {
            case 0: {
                if (cornerZ[1] > cornerZ[2]) {
                    secondFarthestIndex = this.cornerIndex[1];
                    break;
                }
                secondFarthestIndex = this.cornerIndex[2];
                break;
            }
            case 1: {
                if (cornerZ[0] > cornerZ[3]) {
                    secondFarthestIndex = this.cornerIndex[0];
                    break;
                }
                secondFarthestIndex = this.cornerIndex[3];
                break;
            }
            case 2: {
                if (cornerZ[0] > cornerZ[3]) {
                    secondFarthestIndex = this.cornerIndex[0];
                    break;
                }
                secondFarthestIndex = this.cornerIndex[3];
                break;
            }
            case 3: {
                secondFarthestIndex = cornerZ[1] > cornerZ[2] ? this.cornerIndex[1] : this.cornerIndex[2];
            }
        }
        this.backEdgeIndices[0] = farthestIndex;
        this.backEdgeIndices[1] = secondFarthestIndex;
    }

    private void drawSection(Section section, Channel channel, boolean useNameStack) {
        if (useNameStack) {
            channel.glLoadName((Object)new Section(section));
        }
        Vertex[] v = section.sectionVertices;
        double g1 = 1.0;
        double g2 = 0.0;
        this.v1 = v[0].v;
        this.v2 = v[1].v;
        this.v3 = v[2].v;
        this.v4 = v[3].v;
        if (Double.isInfinite(this.v1.x) || Double.isInfinite(this.v2.x) || Double.isInfinite(this.v3.x) || Double.isInfinite(this.v4.x)) {
            g1 = Double.isInfinite(this.v2.x) || Double.isInfinite(this.v4.x) ? Double.POSITIVE_INFINITY : Vec3d.gradient((Vec3d)this.v2, (Vec3d)this.v4);
            g2 = Double.isInfinite(this.v1.x) || Double.isInfinite(this.v3.x) ? Double.POSITIVE_INFINITY : Vec3d.gradient((Vec3d)this.v1, (Vec3d)this.v3);
        } else {
            g1 = Vec3d.gradient((Vec3d)this.v2, (Vec3d)this.v4);
            g2 = Vec3d.gradient((Vec3d)this.v1, (Vec3d)this.v3);
        }
        if (Double.isInfinite(g1)) {
            if (!(Double.isInfinite(this.v1.x) | Double.isInfinite(this.v3.x))) {
                if (Double.isInfinite(this.v2.x)) {
                    this.drawTriangle(channel, section.cellIndex, v[0], v[2], v[3]);
                } else if (Double.isInfinite(this.v4.x)) {
                    this.drawTriangle(channel, section.cellIndex, v[2], v[0], v[1]);
                }
            }
        } else if (Double.isInfinite(g2)) {
            if (!(Double.isInfinite(this.v2.x) | Double.isInfinite(this.v4.x))) {
                if (Double.isInfinite(this.v3.x)) {
                    this.drawTriangle(channel, section.cellIndex, v[1], v[3], v[0]);
                } else if (Double.isInfinite(this.v1.x)) {
                    this.drawTriangle(channel, section.cellIndex, v[3], v[1], v[2]);
                }
            }
        } else if (g1 < g2) {
            this.drawTriangle(channel, section.cellIndex, v[1], v[3], v[2]);
            this.drawTriangle(channel, section.cellIndex, v[3], v[1], v[0]);
        } else {
            this.drawTriangle(channel, section.cellIndex, v[0], v[2], v[1]);
            this.drawTriangle(channel, section.cellIndex, v[2], v[0], v[3]);
        }
    }

    private int indexToCorner(int index) {
        int result;
        if (index == this.cornerIndex[0]) {
            result = 0;
        } else if (index == this.cornerIndex[1]) {
            result = 1;
        } else if (index == this.cornerIndex[2]) {
            result = 2;
        } else if (index == this.cornerIndex[3]) {
            result = 3;
        } else {
            throw new IllegalStateException();
        }
        return result;
    }

    private void drawTriangle(Channel channel, int index, Vertex vertex1, Vertex vertex2, Vertex vertex3) {
        if (vertex1 == null || vertex2 == null || vertex3 == null) {
            return;
        }
        this.edge1.set(vertex2.v.x - vertex1.v.x, vertex2.v.y - vertex1.v.y, vertex2.v.z - vertex1.v.z);
        this.edge2.set(vertex3.v.x - vertex1.v.x, vertex3.v.y - vertex1.v.y, vertex3.v.z - vertex1.v.z);
        Vec3d cross = this.edge1.cross(this.edge2);
        cross.scale(-1.0);
        channel.glNormal(cross.x, cross.y, cross.z);
        channel.glBegin(2);
        channel.glColor(vertex1.color);
        channel.glEdgeColor(vertex1.edgeColor);
        channel.glVertex(vertex1.v.x, vertex1.v.y, vertex1.v.z);
        channel.glColor(vertex2.color);
        channel.glVertex(vertex2.v.x, vertex2.v.y, vertex2.v.z);
        channel.glColor(vertex3.color);
        channel.glVertex(vertex3.v.x, vertex3.v.y, vertex3.v.z);
        channel.glColor(vertex1.color);
        channel.glVertex(vertex1.v.x, vertex1.v.y, vertex1.v.z);
        channel.glEnd();
    }

    @Override
    protected SelectDetail getSelectDetail(Object rawDetail, int startIndex) {
        Stack nameStack = (Stack)rawDetail;
        int entryLength = (Integer)nameStack.elementAt(startIndex);
        int detailIndex = startIndex + entryLength - 1;
        Section section = (Section)nameStack.elementAt(detailIndex);
        TriangleConnectorDetail detail = null;
        if (section != null) {
            detail = new TriangleConnectorDetail(section.cellIndex, section.corners);
        }
        return detail;
    }

    public int getSamplePolicy() {
        return this.samplePolicy;
    }

    public void setSamplePolicy(int samplePolicy) {
        switch (samplePolicy) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid samplePolicy");
            }
        }
        this.samplePolicy = samplePolicy;
    }

    private class SurfaceIterator
    implements Iterator {
        private int height;
        private int from;
        private int to;
        private Section so = new Section();
        private int sectionCount;
        private int section;
        private int row;
        private int column;
        private int reset;
        private int rowIncrement;
        private int columnIncrement;
        private boolean rowMajor = true;
        private int sampleAdjustedWidth;
        private int sampleAdjustedHeight;

        private SurfaceIterator() {
        }

        public void reset() {
            int fromCorner;
            int toCorner;
            if (TriangleConnector.this.width > 0) {
                this.height = TriangleConnector.this.pointCount / TriangleConnector.this.getWidth();
            }
            if ((toCorner = TriangleConnector.this.indexToCorner(this.to)) == (fromCorner = TriangleConnector.this.indexToCorner(this.from))) {
                this.sectionCount = 0;
                return;
            }
            this.sampleAdjustedWidth = TriangleConnector.this.width;
            this.sampleAdjustedHeight = this.height;
            this.sampleAdjustedWidth = (int)Math.ceil((TriangleConnector.this.width - 1) / TriangleConnector.this.getRowSampleSize());
            this.sampleAdjustedHeight = (int)Math.ceil((this.height - 1) / TriangleConnector.this.getColumnSampleSize());
            this.sectionCount = this.sampleAdjustedWidth * this.sampleAdjustedHeight;
            this.row = this.from / TriangleConnector.this.width;
            this.column = this.from % TriangleConnector.this.width;
            this.section = 0;
            block0 : switch (fromCorner) {
                case 0: {
                    switch (toCorner) {
                        case 1: {
                            this.rowIncrement = 1;
                            this.columnIncrement = 1;
                            this.rowMajor = false;
                            this.reset = 0;
                            break block0;
                        }
                        case 2: {
                            this.rowIncrement = 1;
                            this.columnIncrement = 1;
                            this.rowMajor = true;
                            this.reset = 0;
                            break block0;
                        }
                    }
                    System.out.println("to?");
                    break;
                }
                case 1: {
                    switch (toCorner) {
                        case 0: {
                            this.rowIncrement = 1;
                            this.columnIncrement = -1;
                            this.rowMajor = false;
                            this.reset = TriangleConnector.this.width - 1;
                            break block0;
                        }
                        case 3: {
                            this.rowIncrement = 1;
                            this.columnIncrement = -1;
                            this.rowMajor = true;
                            this.reset = 0;
                            break block0;
                        }
                    }
                    System.out.println("to?");
                    break;
                }
                case 2: {
                    switch (toCorner) {
                        case 0: {
                            this.rowIncrement = -1;
                            this.columnIncrement = 1;
                            this.rowMajor = true;
                            this.reset = this.height - 1;
                            break block0;
                        }
                        case 3: {
                            this.rowIncrement = -1;
                            this.columnIncrement = 1;
                            this.rowMajor = false;
                            this.reset = 0;
                            break block0;
                        }
                    }
                    System.out.println("to?");
                    break;
                }
                case 3: {
                    switch (toCorner) {
                        case 1: {
                            this.rowIncrement = -1;
                            this.columnIncrement = -1;
                            this.rowMajor = true;
                            this.reset = this.height - 1;
                            break block0;
                        }
                        case 2: {
                            this.rowIncrement = -1;
                            this.columnIncrement = -1;
                            this.rowMajor = false;
                            this.reset = TriangleConnector.this.width - 1;
                            break block0;
                        }
                    }
                    System.out.println("to?");
                    break;
                }
                default: {
                    System.out.println("from?");
                }
            }
            this.rowIncrement *= TriangleConnector.this.getRowSampleSize();
            this.columnIncrement *= TriangleConnector.this.getColumnSampleSize();
        }

        public void setStartEdge(int from, int to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public boolean hasNext() {
            return this.section < this.sectionCount;
        }

        private void readSectionVertices(Section s, int corner, int index) {
            if (index >= 0 && index < TriangleConnector.this.pointCount) {
                try {
                    ((Section)s).sectionVertices[corner].v.x = TriangleConnector.this.pointX.getValue(index);
                    ((Section)s).sectionVertices[corner].v.y = TriangleConnector.this.pointY.getValue(index);
                    ((Section)s).sectionVertices[corner].v.z = TriangleConnector.this.pointZ.getValue(index);
                    ((Section)s).sectionVertices[corner].color = TriangleConnector.this.color.getValue(index);
                    ((Section)s).sectionVertices[corner].edgeColor = TriangleConnector.this.edgeColor.getValue(index);
                    ((Section)s).corners[corner] = index;
                }
                catch (MissingValueException e) {
                    ((Section)s).sectionVertices[corner].v.x = Double.POSITIVE_INFINITY;
                    ((Section)s).sectionVertices[corner].v.y = Double.POSITIVE_INFINITY;
                    ((Section)s).sectionVertices[corner].v.z = Double.POSITIVE_INFINITY;
                    ((Section)s).sectionVertices[corner].color = Color.black;
                    ((Section)s).sectionVertices[corner].edgeColor = Color.black;
                }
            }
        }

        public Object next() {
            this.so.cellIndex = this.section;
            int i = this.row * TriangleConnector.this.width + this.column + this.columnIncrement;
            this.readSectionVertices(this.so, 0, i);
            i = this.row * TriangleConnector.this.width + this.column;
            this.readSectionVertices(this.so, 1, i);
            i = (this.row + this.rowIncrement) * TriangleConnector.this.width + this.column;
            this.readSectionVertices(this.so, 2, i);
            i = (this.row + this.rowIncrement) * TriangleConnector.this.width + this.column + this.columnIncrement;
            this.readSectionVertices(this.so, 3, i);
            if (this.rowIncrement == -1) {
                if (this.columnIncrement == -1) {
                    Vertex tempVertex = this.so.sectionVertices[0];
                    ((Section)this.so).sectionVertices[0] = this.so.sectionVertices[1];
                    ((Section)this.so).sectionVertices[1] = tempVertex;
                    tempVertex = this.so.sectionVertices[2];
                    ((Section)this.so).sectionVertices[2] = this.so.sectionVertices[3];
                    ((Section)this.so).sectionVertices[3] = tempVertex;
                }
            } else if (this.columnIncrement == 1) {
                Vertex tempVertex = this.so.sectionVertices[0];
                ((Section)this.so).sectionVertices[0] = this.so.sectionVertices[3];
                ((Section)this.so).sectionVertices[3] = tempVertex;
                tempVertex = this.so.sectionVertices[1];
                ((Section)this.so).sectionVertices[1] = this.so.sectionVertices[2];
                ((Section)this.so).sectionVertices[2] = tempVertex;
            } else {
                Vertex tempVertex = this.so.sectionVertices[0];
                ((Section)this.so).sectionVertices[0] = this.so.sectionVertices[2];
                ((Section)this.so).sectionVertices[2] = tempVertex;
                tempVertex = this.so.sectionVertices[1];
                ((Section)this.so).sectionVertices[1] = this.so.sectionVertices[3];
                ((Section)this.so).sectionVertices[3] = tempVertex;
            }
            ++this.section;
            if (this.rowMajor) {
                this.row += this.rowIncrement;
                if (this.row + this.rowIncrement < 0 || this.row + this.rowIncrement > this.height - 1) {
                    this.column += this.columnIncrement;
                    this.row = this.reset;
                }
            } else {
                this.column += this.columnIncrement;
                if (this.column + this.columnIncrement < 0 || this.column + this.columnIncrement > TriangleConnector.this.width - 1) {
                    this.row += this.rowIncrement;
                    this.column = this.reset;
                }
            }
            return this.so;
        }

        @Override
        public void remove() {
        }
    }

    private static class Section {
        private Vertex[] sectionVertices = new Vertex[4];
        private int cellIndex;
        private int[] corners = new int[4];

        public Section() {
            for (int i = 0; i < this.sectionVertices.length; ++i) {
                this.sectionVertices[i] = new Vertex();
            }
        }

        public Section(Section section) {
            this.cellIndex = section.cellIndex;
            for (int i = 0; i < 4; ++i) {
                this.sectionVertices[i] = new Vertex(section.sectionVertices[i]);
                this.corners[i] = section.corners[i];
            }
        }
    }

    private static class Vertex {
        public Vec3d v = new Vec3d();
        public Color color;
        public Color edgeColor;

        public Vertex() {
        }

        public Vertex(Vertex vertex) {
            this.v.set(vertex.v);
            this.color = vertex.color;
            this.edgeColor = vertex.edgeColor;
        }
    }
}

