/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.ATriangle;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;

public class Triangle
extends ATriangle {
    public Triangle() {
        super(new Transform());
    }

    public static void drawTriangle(Channel channel, double base, double height, Color color, Color edgeColor, boolean edgeOn, boolean fillOn, int origin) {
        double hHalf = height / 2.0;
        double bHalf = base / 2.0;
        channel.glPushAttrib(0);
        Vec3d center = new Vec3d();
        ATriangle.computeCenter(base, height, origin, center);
        channel.glTranslate(center.x, center.y, center.z);
        channel.glColor(color);
        channel.glEdgeColor(edgeColor);
        channel.glPolygonMode(BuildAction.getGLFillStyle(fillOn, edgeOn));
        channel.glBegin(2);
        channel.glNormal(0.0, 0.0, 1.0);
        channel.glVertex(0.0, hHalf, 0.0);
        channel.glVertex(-bHalf, -hHalf, 0.0);
        channel.glVertex(bHalf, -hHalf, 0.0);
        channel.glEnd();
        channel.glPopAttrib();
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        int index = ba.getValueIndex();
        Triangle.drawTriangle(ba.getChannel(), this.base.getValue(index), this.height.getValue(index), this.color.getValue(index), this.edgeColor.getValue(index), this.edgeOn.getValue(index), this.fillOn.getValue(index), this.origin.getValue(index));
    }
}

