/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.ASplineConnector;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.FilledLineConnector;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.ResetAction;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;
import java.util.Vector;

public class SplineConnector
extends ASplineConnector {
    private Vec3d[] controlPoints = new Vec3d[4];
    private Vec3d[] controlPoints2 = new Vec3d[4];
    private Vec3d v1 = new Vec3d();
    private Vec3d v2 = new Vec3d();
    private int index_k_s;
    private int index_k_e;

    public SplineConnector() {
        super(new Transform());
        for (int i = 0; i < this.controlPoints.length; ++i) {
            this.controlPoints[i] = new Vec3d();
            this.controlPoints2[i] = new Vec3d();
        }
    }

    @Override
    public void reset(AResetAction resetAction) {
        if (this.multipleGroup) {
            return;
        }
        super.reset(resetAction);
        ResetAction ra = (ResetAction)resetAction;
        Channel channel = ra.getChannel();
        int firstIndex = this.getFirstIndex();
        Color c = ColorProperty.getDefaultColor();
        Color fc = ColorProperty.getDefaultColor();
        boolean fo = false;
        boolean lo = true;
        float lw = 1.0f;
        try {
            c = this.color.getValue(firstIndex);
            fc = this.fillColor.getValue(firstIndex);
            lw = (float)this.lineWidth.getValue(firstIndex);
            fo = this.fillOn.getValue(firstIndex);
            lo = this.lineOn.getValue(firstIndex);
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        channel.glPushAttrib(0);
        if (fo) {
            channel.glColor(fc);
            channel.glDisable(1);
            this.fillSpline(channel);
        }
        if (lo) {
            channel.glLineWidth(lw);
            if (this.stippleFactor > 0) {
                channel.glEnable(6);
                channel.glLineStipple(this.stippleFactor, (int)((short)this.stipplePattern));
            }
            channel.lineCapStyle(0);
            channel.setLineJoinStyle(1);
            channel.glColor(c);
            this.drawSpline(channel);
        }
        channel.glPopAttrib();
        this.resetRenderIndices();
    }

    private void getControlPoints(Vector controlPointIndices) {
        int i;
        int n = controlPointIndices.size();
        if (this.controlPoints == null || this.controlPoints.length < n) {
            Vec3d[] newControlPoints = new Vec3d[n];
            System.arraycopy(this.controlPoints, 0, newControlPoints, 0, this.controlPoints.length);
            for (i = this.controlPoints.length; i < n; ++i) {
                newControlPoints[i] = new Vec3d();
            }
            this.controlPoints = newControlPoints;
        }
        try {
            for (i = 0; i < n; ++i) {
                Vec3d cp = this.controlPoints[i];
                int valueIndex = (Integer)controlPointIndices.elementAt(i);
                cp.x = this.pointX.getValue(valueIndex);
                cp.y = this.pointY.getValue(valueIndex);
                cp.z = this.pointZ.getValue(valueIndex);
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
    }

    private void getControlPoints2(Vector controlPointIndices) {
        int i;
        int n = controlPointIndices.size();
        if (this.controlPoints2 == null || this.controlPoints2.length < n) {
            Vec3d[] newControlPoints = new Vec3d[n];
            System.arraycopy(this.controlPoints2, 0, newControlPoints, 0, this.controlPoints2.length);
            for (i = this.controlPoints2.length; i < n; ++i) {
                newControlPoints[i] = new Vec3d();
            }
            this.controlPoints2 = newControlPoints;
        }
        try {
            for (i = 0; i < n; ++i) {
                Vec3d cp = this.controlPoints2[i];
                int valueIndex = (Integer)controlPointIndices.elementAt(i);
                cp.x = this.pointX2.getValue(valueIndex);
                cp.y = this.pointY2.getValue(valueIndex);
                cp.z = this.pointZ2.getValue(valueIndex);
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
    }

    private void fillSpline(Channel channel) {
        int splineCount = this.renderIndices.size();
        for (int i = 0; i < splineCount; ++i) {
            Vector v = (Vector)this.renderIndices.elementAt(i);
            if (v == null) continue;
            this.getControlPoints(v);
            int controlPointCount = v.size();
            switch (controlPointCount) {
                case 0: 
                case 1: {
                    Vec3d cp0 = this.controlPoints[0];
                    channel.glBegin(1);
                    channel.glVertex(cp0.x, cp0.y, cp0.z);
                    channel.glEnd();
                    break;
                }
                case 2: {
                    Vec3d cp0 = this.controlPoints[0];
                    Vec3d cp1 = this.controlPoints[1];
                    this.drawFillUnder(channel, cp0, cp1);
                    break;
                }
                default: {
                    Vec3d cp1;
                    Vec3d cp0;
                    for (int j = 0; j < controlPointCount - 1; ++j) {
                        Vec3d cp3;
                        Vec3d cp2;
                        if (j == 0) {
                            cp0 = this.controlPoints[0];
                            cp1 = this.controlPoints[0];
                            cp2 = this.controlPoints[1];
                            cp3 = this.controlPoints[2];
                        } else if (j == controlPointCount - 2) {
                            cp0 = this.controlPoints[controlPointCount - 3];
                            cp1 = this.controlPoints[controlPointCount - 2];
                            cp2 = this.controlPoints[controlPointCount - 1];
                            cp3 = this.controlPoints[controlPointCount - 1];
                        } else {
                            cp0 = this.controlPoints[j - 1];
                            cp1 = this.controlPoints[j];
                            cp2 = this.controlPoints[j + 1];
                            cp3 = this.controlPoints[j + 2];
                        }
                        for (int k = 0; k < this.precision - 1; ++k) {
                            this.v1.x = cp0.x * this.cardinalBasis[k][0] + cp1.x * this.cardinalBasis[k][1] + cp2.x * this.cardinalBasis[k][2] + cp3.x * this.cardinalBasis[k][3];
                            this.v1.y = cp0.y * this.cardinalBasis[k][0] + cp1.y * this.cardinalBasis[k][1] + cp2.y * this.cardinalBasis[k][2] + cp3.y * this.cardinalBasis[k][3];
                            this.v1.z = cp0.z * this.cardinalBasis[k][0] + cp1.z * this.cardinalBasis[k][1] + cp2.z * this.cardinalBasis[k][2] + cp3.z * this.cardinalBasis[k][3];
                            this.v2.x = cp0.x * this.cardinalBasis[k + 1][0] + cp1.x * this.cardinalBasis[k + 1][1] + cp2.x * this.cardinalBasis[k + 1][2] + cp3.x * this.cardinalBasis[k + 1][3];
                            this.v2.y = cp0.y * this.cardinalBasis[k + 1][0] + cp1.y * this.cardinalBasis[k + 1][1] + cp2.y * this.cardinalBasis[k + 1][2] + cp3.y * this.cardinalBasis[k + 1][3];
                            this.v2.z = cp0.z * this.cardinalBasis[k + 1][0] + cp1.z * this.cardinalBasis[k + 1][1] + cp2.z * this.cardinalBasis[k + 1][2] + cp3.z * this.cardinalBasis[k + 1][3];
                            this.drawFillUnder(channel, this.v1, this.v2);
                        }
                        this.drawFillUnder(channel, this.v2, cp2);
                    }
                }
            }
            if (!this.subpixelRendering) continue;
            this.drawSegments(channel);
        }
    }

    private void fillStackedSpline(Channel channel) {
        int splineCount = this.renderIndices.size();
        block4: for (int i = 0; i < splineCount; ++i) {
            Vector v = (Vector)this.renderIndices.elementAt(i);
            if (v == null) continue;
            this.getControlPoints(v);
            this.getControlPoints2(v);
            int controlPointCount = v.size();
            switch (controlPointCount) {
                case 0: 
                case 1: {
                    Vec3d cp0 = this.controlPoints[0];
                    channel.glBegin(1);
                    channel.glVertex(cp0.x, cp0.y, cp0.z);
                    channel.glEnd();
                    continue block4;
                }
                case 2: {
                    Vec3d cp0 = this.controlPoints[0];
                    Vec3d cp1 = this.controlPoints[1];
                    Vec3d cp2 = this.controlPoints2[1];
                    Vec3d cp3 = this.controlPoints2[0];
                    channel.glPolygonMode(3);
                    channel.glBegin(2);
                    channel.glVertex(cp0.x, cp0.y, cp0.z);
                    channel.glVertex(cp1.x, cp1.y, cp1.z);
                    channel.glVertex(cp2.x, cp2.y, cp2.z);
                    channel.glVertex(cp3.x, cp3.y, cp3.z);
                    channel.glEnd();
                    continue block4;
                }
                default: {
                    int k;
                    int j;
                    Vec3d cp3;
                    Vec3d cp2;
                    Vec3d cp1;
                    Vec3d cp0;
                    channel.glPolygonMode(3);
                    channel.glBegin(2);
                    for (j = 0; j < controlPointCount - 1; ++j) {
                        if (j == 0) {
                            cp0 = this.controlPoints[0];
                            cp1 = this.controlPoints[0];
                            cp2 = this.controlPoints[1];
                            cp3 = this.controlPoints[2];
                        } else if (j == controlPointCount - 2) {
                            cp0 = this.controlPoints[controlPointCount - 3];
                            cp1 = this.controlPoints[controlPointCount - 2];
                            cp2 = this.controlPoints[controlPointCount - 1];
                            cp3 = this.controlPoints[controlPointCount - 1];
                        } else {
                            cp0 = this.controlPoints[j - 1];
                            cp1 = this.controlPoints[j];
                            cp2 = this.controlPoints[j + 1];
                            cp3 = this.controlPoints[j + 2];
                        }
                        for (k = 0; k < this.precision; ++k) {
                            this.endPointX = cp0.x * this.cardinalBasis[k][0] + cp1.x * this.cardinalBasis[k][1] + cp2.x * this.cardinalBasis[k][2] + cp3.x * this.cardinalBasis[k][3];
                            this.endPointY = cp0.y * this.cardinalBasis[k][0] + cp1.y * this.cardinalBasis[k][1] + cp2.y * this.cardinalBasis[k][2] + cp3.y * this.cardinalBasis[k][3];
                            this.endPointZ = cp0.z * this.cardinalBasis[k][0] + cp1.z * this.cardinalBasis[k][1] + cp2.z * this.cardinalBasis[k][2] + cp3.z * this.cardinalBasis[k][3];
                            channel.glVertex(this.endPointX, this.endPointY, this.endPointZ);
                        }
                    }
                    cp0 = this.controlPoints[controlPointCount - 1];
                    channel.glVertex(cp0.x, cp0.y, cp0.z);
                    cp0 = this.controlPoints2[controlPointCount - 1];
                    channel.glVertex(cp0.x, cp0.y, cp0.z);
                    for (j = controlPointCount - 2; j >= 0; --j) {
                        if (j == 0) {
                            cp0 = this.controlPoints2[0];
                            cp1 = this.controlPoints2[0];
                            cp2 = this.controlPoints2[1];
                            cp3 = this.controlPoints2[2];
                        } else if (j == controlPointCount - 2) {
                            cp0 = this.controlPoints2[controlPointCount - 3];
                            cp1 = this.controlPoints2[controlPointCount - 2];
                            cp2 = this.controlPoints2[controlPointCount - 1];
                            cp3 = this.controlPoints2[controlPointCount - 1];
                        } else {
                            cp0 = this.controlPoints2[j - 1];
                            cp1 = this.controlPoints2[j];
                            cp2 = this.controlPoints2[j + 1];
                            cp3 = this.controlPoints2[j + 2];
                        }
                        for (k = this.precision - 1; k >= 0; --k) {
                            this.endPointX = cp0.x * this.cardinalBasis[k][0] + cp1.x * this.cardinalBasis[k][1] + cp2.x * this.cardinalBasis[k][2] + cp3.x * this.cardinalBasis[k][3];
                            this.endPointY = cp0.y * this.cardinalBasis[k][0] + cp1.y * this.cardinalBasis[k][1] + cp2.y * this.cardinalBasis[k][2] + cp3.y * this.cardinalBasis[k][3];
                            this.endPointZ = cp0.z * this.cardinalBasis[k][0] + cp1.z * this.cardinalBasis[k][1] + cp2.z * this.cardinalBasis[k][2] + cp3.z * this.cardinalBasis[k][3];
                            channel.glVertex(this.endPointX, this.endPointY, this.endPointZ);
                        }
                    }
                    channel.glEnd();
                }
            }
        }
    }

    private void drawSpline(Channel channel) {
        int splineCount = this.renderIndices.size();
        for (int i = 0; i < splineCount; ++i) {
            Vector v = (Vector)this.renderIndices.elementAt(i);
            if (v == null) continue;
            this.getControlPoints(v);
            int controlPointCount = v.size();
            if ((this.startArrow || this.endArrow) && controlPointCount >= 2) {
                this.computeArrowHeadParameters(channel, v, controlPointCount);
            }
            switch (controlPointCount) {
                case 0: 
                case 1: {
                    Vec3d cp0 = this.controlPoints[0];
                    channel.glBegin(1);
                    channel.glVertex(cp0.x, cp0.y, cp0.z);
                    channel.glEnd();
                    break;
                }
                case 2: {
                    Vec3d cp0 = this.controlPoints[0];
                    Vec3d cp1 = this.controlPoints[1];
                    if (this.startArrow) {
                        this.adjustStartPoint(cp0);
                    }
                    if (this.endArrow) {
                        this.adjustEndPoint(cp1);
                    }
                    channel.glBegin(1);
                    channel.glVertex(cp0.x, cp0.y, cp0.z);
                    channel.glVertex(cp1.x, cp1.y, cp1.z);
                    channel.glEnd();
                    break;
                }
                default: {
                    Vec3d cp1;
                    Vec3d cp0;
                    channel.glBegin(1);
                    for (int j = 0; j < controlPointCount - 1; ++j) {
                        Vec3d cp3;
                        Vec3d cp2;
                        if (j == 0) {
                            cp0 = this.controlPoints[0];
                            cp1 = this.controlPoints[0];
                            cp2 = this.controlPoints[1];
                            cp3 = this.controlPoints[2];
                        } else if (j == controlPointCount - 2) {
                            cp0 = this.controlPoints[controlPointCount - 3];
                            cp1 = this.controlPoints[controlPointCount - 2];
                            cp2 = this.controlPoints[controlPointCount - 1];
                            cp3 = this.controlPoints[controlPointCount - 1];
                        } else {
                            cp0 = this.controlPoints[j - 1];
                            cp1 = this.controlPoints[j];
                            cp2 = this.controlPoints[j + 1];
                            cp3 = this.controlPoints[j + 2];
                        }
                        for (int k = 0; k < this.precision; ++k) {
                            double[] pt;
                            this.endPointX = cp0.x * this.cardinalBasis[k][0] + cp1.x * this.cardinalBasis[k][1] + cp2.x * this.cardinalBasis[k][2] + cp3.x * this.cardinalBasis[k][3];
                            this.endPointY = cp0.y * this.cardinalBasis[k][0] + cp1.y * this.cardinalBasis[k][1] + cp2.y * this.cardinalBasis[k][2] + cp3.y * this.cardinalBasis[k][3];
                            this.endPointZ = cp0.z * this.cardinalBasis[k][0] + cp1.z * this.cardinalBasis[k][1] + cp2.z * this.cardinalBasis[k][2] + cp3.z * this.cardinalBasis[k][3];
                            if (this.startArrow && (j < this.index_s || j == this.index_s && k < this.index_k_s)) {
                                pt = this.adjustStartPoint(this.endPointX, this.endPointY, this.endPointZ);
                                this.endPointX = pt[0];
                                this.endPointY = pt[1];
                            }
                            if (this.endArrow && (j > this.index_e || j == this.index_e && k > this.index_k_e)) {
                                pt = this.adjustEndPoint(this.endPointX, this.endPointY, this.endPointZ);
                                this.endPointX = pt[0];
                                this.endPointY = pt[1];
                            }
                            channel.glVertex(this.endPointX, this.endPointY, this.endPointZ);
                        }
                    }
                    cp0 = this.controlPoints[controlPointCount - 1];
                    if (this.endArrow) {
                        this.adjustEndPoint(cp0);
                    }
                    channel.glVertex(cp0.x, cp0.y, cp0.z);
                    channel.glEnd();
                }
            }
            if (this.startArrow && controlPointCount >= 2) {
                this.drawArrow(channel, this.arrowV1, this.arrowV2);
            }
            if (!this.endArrow || controlPointCount < 2) continue;
            this.drawArrow(channel, this.arrowV1end, this.arrowV2end);
        }
    }

    @Override
    protected void renderPolylineGroup(ABuildAction buildAction, FilledLineConnector.PolylineGroup group, boolean fillOn) {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        Channel channel = ba.getChannel();
        int polyLineCount = group.getPolylineCount();
        if (polyLineCount <= 0) {
            return;
        }
        boolean is3d = this.depth.length() > 0.0;
        for (int i = 0; i < polyLineCount; ++i) {
            Vector line = group.getPolyline(i);
            if (line == null || is3d && line.size() <= 1) continue;
            if (fillOn) {
                if (this.pointX2.isConnected() || this.pointY2.isConnected()) {
                    this.fillStackedSpline(channel);
                    continue;
                }
                this.fillSpline(channel);
                continue;
            }
            this.drawSpline(channel);
        }
    }

    private void computeArrowHeadParameters(Channel channel, Vector aLine, int controlPointCount) {
        int k;
        Vec3d cp3;
        Vec3d cp2;
        int j;
        Vec3d cp1;
        Vec3d cp0;
        this.arrowV1 = null;
        this.arrowV2 = null;
        this.index_s = 0;
        this.index_k_s = 0;
        if (this.startArrow && controlPointCount >= 2) {
            if (controlPointCount == 2) {
                cp0 = this.controlPoints[0];
                cp1 = this.controlPoints[1];
                if (!cp0.equals((Object)cp1)) {
                    this.arrowV2 = new Vec3d(cp0);
                    this.arrowV1 = new Vec3d(cp1);
                }
            } else {
                this.arrowV2 = new Vec3d(this.controlPoints[0]);
                for (j = 0; j < controlPointCount - 1; ++j) {
                    if (j == 0) {
                        cp0 = this.controlPoints[0];
                        cp1 = this.controlPoints[0];
                        cp2 = this.controlPoints[1];
                        cp3 = this.controlPoints[2];
                    } else if (j == controlPointCount - 2) {
                        cp0 = this.controlPoints[controlPointCount - 3];
                        cp1 = this.controlPoints[controlPointCount - 2];
                        cp2 = this.controlPoints[controlPointCount - 1];
                        cp3 = this.controlPoints[controlPointCount - 1];
                    } else {
                        cp0 = this.controlPoints[j - 1];
                        cp1 = this.controlPoints[j];
                        cp2 = this.controlPoints[j + 1];
                        cp3 = this.controlPoints[j + 2];
                    }
                    for (k = 0; k < this.precision; ++k) {
                        this.endPointX = cp0.x * this.cardinalBasis[k][0] + cp1.x * this.cardinalBasis[k][1] + cp2.x * this.cardinalBasis[k][2] + cp3.x * this.cardinalBasis[k][3];
                        this.endPointY = cp0.y * this.cardinalBasis[k][0] + cp1.y * this.cardinalBasis[k][1] + cp2.y * this.cardinalBasis[k][2] + cp3.y * this.cardinalBasis[k][3];
                        this.endPointZ = cp0.z * this.cardinalBasis[k][0] + cp1.z * this.cardinalBasis[k][1] + cp2.z * this.cardinalBasis[k][2] + cp3.z * this.cardinalBasis[k][3];
                        if (this.arrowV1 != null) continue;
                        this.arrowV1 = new Vec3d(this.endPointX, this.endPointY, this.endPointZ);
                        if (this.arrowV1.equals((Object)this.arrowV2)) {
                            this.arrowV1 = null;
                            continue;
                        }
                        this.index_s = j;
                        this.index_k_s = k;
                        break;
                    }
                    if (this.arrowV1 != null && this.arrowV2 != null) break;
                }
            }
            this.startArrow = this.adjustStartArrow(channel);
        }
        this.arrowV1end = null;
        this.arrowV2end = null;
        this.index_e = 0;
        this.index_k_e = 0;
        if (this.endArrow && controlPointCount >= 2) {
            if (controlPointCount == 2) {
                cp0 = this.controlPoints[0];
                cp1 = this.controlPoints[1];
                if (!cp0.equals((Object)cp1)) {
                    this.arrowV2end = new Vec3d(cp1);
                    this.arrowV1end = new Vec3d(cp0);
                }
            } else {
                this.arrowV2end = new Vec3d(this.controlPoints[controlPointCount - 1]);
                for (j = controlPointCount - 2; j >= 0; --j) {
                    if (j == 0) {
                        cp0 = this.controlPoints[0];
                        cp1 = this.controlPoints[0];
                        cp2 = this.controlPoints[1];
                        cp3 = this.controlPoints[2];
                    } else if (j == controlPointCount - 2) {
                        cp0 = this.controlPoints[controlPointCount - 3];
                        cp1 = this.controlPoints[controlPointCount - 2];
                        cp2 = this.controlPoints[controlPointCount - 1];
                        cp3 = this.controlPoints[controlPointCount - 1];
                    } else {
                        cp0 = this.controlPoints[j - 1];
                        cp1 = this.controlPoints[j];
                        cp2 = this.controlPoints[j + 1];
                        cp3 = this.controlPoints[j + 2];
                    }
                    for (k = this.precision - 1; k >= 0; --k) {
                        this.endPointX = cp0.x * this.cardinalBasis[k][0] + cp1.x * this.cardinalBasis[k][1] + cp2.x * this.cardinalBasis[k][2] + cp3.x * this.cardinalBasis[k][3];
                        this.endPointY = cp0.y * this.cardinalBasis[k][0] + cp1.y * this.cardinalBasis[k][1] + cp2.y * this.cardinalBasis[k][2] + cp3.y * this.cardinalBasis[k][3];
                        this.endPointZ = cp0.z * this.cardinalBasis[k][0] + cp1.z * this.cardinalBasis[k][1] + cp2.z * this.cardinalBasis[k][2] + cp3.z * this.cardinalBasis[k][3];
                        if (this.arrowV1end != null) continue;
                        this.arrowV1end = new Vec3d(this.endPointX, this.endPointY, this.endPointZ);
                        if (this.arrowV1end.equals((Object)this.arrowV2end)) {
                            this.arrowV1end = null;
                            continue;
                        }
                        this.index_e = j;
                        this.index_k_e = k;
                        break;
                    }
                    if (this.arrowV1end != null && this.arrowV2end != null) break;
                }
            }
            this.endArrow = this.adjustEndArrow(channel);
        }
    }
}

