/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.SASLinePatterns;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.BooleanPipe;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.SelectEntry;
import com.sas.graphics.util.gtk.StringProperty;
import com.sas.graphics.util.gtk.gl.Image;
import com.sas.graphics.util.gtk.gl.SpatialFeatureCache;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;

public class SpatialMap
extends Element {
    public final NumericProperty id = new NumericProperty(this, true);
    public final StringProperty stringID = new StringProperty(this, true);
    public final ColorProperty color = new ColorProperty(this, true);
    public final ColorProperty edgeColor = new ColorProperty(this, true);
    public final BooleanProperty edgeOn = new BooleanProperty(this, true);
    public final NumericProperty edgeThickness = new NumericProperty(this, true);
    public final IntegerProperty edgePattern = new IntegerProperty(this, true);
    public final ColorProperty highlightColor = new ColorProperty(this, true);
    public final ColorProperty highlightEdgeColor = new ColorProperty(this, true);
    public final BooleanProperty highlightOn = new BooleanProperty(this, true);
    public final BooleanProperty extrudeOn = new BooleanProperty(this, true);
    public final NumericProperty extrudeHeight = new NumericProperty(this, true);
    public final BooleanProperty missingAsEmpty = new BooleanProperty(this, true);
    public final BooleanProperty useChoroColor = new BooleanProperty(this, true);
    private final SpatialFeatureCache cache;
    private int valueCount;
    private boolean showAllFeatures = false;
    private Color defaultColor = null;
    private Color emptyEdgeColor = null;
    private boolean emptyEdgeOn = true;
    private double emptyEdgeThickness = 1.0;
    private Color emptyColor = null;
    private boolean onlyDrawHighlightedRegions = false;
    private BufferedImage emptyTextureImage = null;
    private int emptyEdgePattern = -1;
    private int emptyTextureMode = -1;
    private int emptyTextureFit = -1;
    private ArrayList<BooleanPipe> conditionalHighlightingPipes = new ArrayList();
    private ArrayList<java.awt.Image> conditionalHighlightingImages = new ArrayList();

    public SpatialMap(SpatialFeatureCache newCache) {
        super(new Transform());
        if (newCache == null) {
            throw new IllegalArgumentException("Spatial map requires a non-null SpatialFeatureCache.");
        }
        this.cache = newCache;
    }

    @Override
    public void init(AInitAction initAction) {
        initAction.pushValueCount();
        super.init(initAction);
        this.valueCount = initAction.getValueCount();
        if (this.valueCount == -1) {
            this.valueCount = 1;
        }
        this.setValueCount(1);
        initAction.popValueCount();
        initAction.setValueCount(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void render(ABuildAction buildAction) throws MissingValueException {
        SpatialFeatureCache.FeatureInterface feature;
        Channel ch = (Channel)buildAction.getGraphicsContext();
        ch.glPushAttrib(0);
        if (this.showAllFeatures) {
            this.cache.beginFeatureRetrievalTracking();
        }
        if (this.extrudeOn.getValue()) {
            ch.glEnable(1);
        } else {
            ch.glDisable(1);
        }
        for (int i = 0; i < this.valueCount; ++i) {
            try {
                int outlinePattern;
                boolean ho = this.highlightOn.getValue(i);
                if (!this.isPicking(buildAction) && this.onlyDrawHighlightedRegions && !ho || (feature = this.id.isConnected() ? this.cache.getFeature(this.id.getValue(i)) : this.cache.getFeature(this.stringID.getValue(i).trim())) == null) continue;
                if (buildAction.isUseNameStack()) {
                    ch.glPopName();
                    ch.glLoadName((Object)new SelectEntry(this, i));
                    ch.glPushName(null);
                }
                if (this.extrudeOn.getValue()) {
                    ch.glPushMatrix();
                    ch.glScale(1.0, 1.0, this.extrudeHeight.getValue(i));
                }
                Color fillColor = this.useChoroColor.isConnected() && !this.useChoroColor.getValue(i) ? this.defaultColor : this.color.getValue(i);
                boolean treatAsEmpty = fillColor == this.emptyColor;
                boolean drawOutline = treatAsEmpty && this.emptyEdgeOn || !treatAsEmpty && this.edgeOn.getValue();
                int n = outlinePattern = treatAsEmpty ? this.emptyEdgePattern : this.edgePattern.getValue(i);
                if (this.onlyDrawHighlightedRegions && ho) {
                    ch.glColor(this.highlightColor.getValue(i));
                    ch.glPolygonMode(6);
                    ch.glCallList(feature.getDisplayList());
                } else {
                    if (outlinePattern > 0) {
                        ch.glEnable(6);
                        ch.glLineStipple(SASLinePatterns.getStippleFactor((int)outlinePattern), SASLinePatterns.getStipplePattern((int)outlinePattern));
                    } else {
                        ch.glDisable(6);
                    }
                    ch.glColor(fillColor);
                    ch.glEdgeColor(treatAsEmpty ? this.emptyEdgeColor : this.edgeColor.getValue(i));
                    ch.glLineWidth(treatAsEmpty ? (float)this.emptyEdgeThickness : (float)this.edgeThickness.getValue(i));
                    ch.glPolygonMode(ho ? 3 : (drawOutline ? 4 : 3));
                    ch.glCallList(feature.getDisplayList());
                }
                for (int j = 0; j < this.conditionalHighlightingPipes.size(); ++j) {
                    BooleanPipe bp = this.conditionalHighlightingPipes.get(j);
                    if (!bp.getValue(i)) continue;
                    Vec3d centroid = feature.getCentroid();
                    java.awt.Image image = this.conditionalHighlightingImages.get(j);
                    ch.glAlignment(2, 0);
                    ch.Image2D(image, centroid.x, centroid.y, 0.0, image.getWidth(null), image.getHeight(null));
                    ch.glAlignment(0, 2);
                }
                continue;
            }
            catch (MissingValueException missingValueException) {
                continue;
            }
            finally {
                if (this.extrudeOn.getValue()) {
                    ch.glPopMatrix();
                }
            }
        }
        if (this.showAllFeatures) {
            this.cache.endFeatureRetrievalTracking();
        }
        if (!this.onlyDrawHighlightedRegions && this.showAllFeatures && !this.isPicking(buildAction)) {
            if (this.extrudeOn.getValue()) {
                ch.glPushMatrix();
                ch.glScale(1.0, 1.0, 0.0);
            }
            if (this.emptyEdgeColor == null) {
                Color color = this.emptyEdgeColor = this.edgeColor.isConnected() ? Color.DARK_GRAY : this.edgeColor.getValue();
            }
            if (this.emptyColor != null) {
                ch.glColor(this.emptyColor);
            }
            if (this.emptyEdgeThickness == 0.0) {
                this.emptyEdgeThickness = this.edgeThickness.getValue();
            }
            if (this.emptyEdgePattern >= 0) {
                ch.glEnable(6);
                ch.glLineStipple(SASLinePatterns.getStippleFactor((int)this.emptyEdgePattern), SASLinePatterns.getStipplePattern((int)this.emptyEdgePattern));
            } else {
                ch.glDisable(6);
            }
            ch.glEdgeColor(this.emptyEdgeColor);
            ch.glPolygonMode(this.emptyEdgeOn ? 4 : 3);
            ch.glLineWidth((float)this.emptyEdgeThickness);
            if (this.emptyTextureImage != null) {
                ch.glEnable(10);
                ch.glTexImage2D((java.awt.Image)this.emptyTextureImage);
                ch.glTexEnv(10, 1, this.emptyTextureMode);
                ch.glTexEnv(10, 2, this.emptyTextureFit);
            }
            if (this.emptyColor == null && this.emptyTextureImage == null) {
                ch.glPolygonMode(2);
                ch.glColor(this.emptyEdgeColor);
            }
            Iterator iterator = this.cache.getUnretrievedFeatureIterator();
            while (iterator.hasNext()) {
                feature = (SpatialFeatureCache.FeatureInterface)iterator.next();
                ch.glCallList(feature.getDisplayList());
            }
            if (this.extrudeOn.getValue()) {
                ch.glPopMatrix();
            }
        }
        ch.glPopAttrib();
        ch.glEdgeFlag(true);
    }

    private boolean isPicking(ABuildAction ba) {
        return ba.isUseNameStack();
    }

    public void setEmptyTextureImage(java.awt.Image textureImage) {
        try {
            this.emptyTextureImage = Image.convertImageToBufferedImage(textureImage);
        }
        catch (IllegalArgumentException e) {
            this.emptyTextureImage = null;
        }
        if (this.emptyTextureImage == null) {
            this.emptyTextureFit = -1;
            this.emptyTextureMode = -1;
            return;
        }
        if (this.emptyTextureFit == -1) {
            this.emptyTextureFit = 4;
        }
        if (this.emptyTextureMode == -1) {
            this.emptyTextureMode = 2;
        }
    }

    public java.awt.Image getEmptyTextureImage() {
        return this.emptyTextureImage;
    }

    public void setEmptyTextureFit(int fit) {
        this.emptyTextureFit = fit;
    }

    public int getEmptyTextureFit() {
        return this.emptyTextureFit;
    }

    public void setEmptyTextureMode(int mode) {
        this.emptyTextureMode = mode;
    }

    public int getEmptyTextureMode() {
        return this.emptyTextureMode;
    }

    public void setEmptyColor(Color color) {
        this.emptyColor = color;
    }

    public Color getEmptyColor() {
        return this.emptyColor;
    }

    public void setEmptyEdgeColor(Color color) {
        this.emptyEdgeColor = color;
    }

    public void setDefaultColor(Color color) {
        this.defaultColor = color;
    }

    public boolean getEmptyVisible() {
        return this.emptyEdgeOn;
    }

    public void setEmptyEdgeVisible(boolean visible) {
        this.emptyEdgeOn = visible;
    }

    public double getEmptyEdgeThickness() {
        return this.emptyEdgeThickness;
    }

    public void setEmptyEdgeThickness(double width) {
        this.emptyEdgeThickness = width;
    }

    public int getEmptyEdgePattern() {
        return this.emptyEdgePattern;
    }

    public void setEmptyEdgePattern(int pattern) {
        this.emptyEdgePattern = pattern;
    }

    public Color getEmptyEdgeColor() {
        return this.emptyEdgeColor;
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public void setAllFeaturesVisible(boolean showAll) {
        this.showAllFeatures = showAll;
    }

    public boolean getAllFeaturesVisible() {
        return this.showAllFeatures;
    }

    public boolean isOnlyDrawHighlightedRegions() {
        return this.onlyDrawHighlightedRegions;
    }

    public void setOnlyDrawHighlightedRegions(boolean onlyDrawHighlightedRegions) {
        this.onlyDrawHighlightedRegions = onlyDrawHighlightedRegions;
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) {
        BoundingBox onBox = bBoxAction.getNetworkBoundingBox();
        BoundingBox nBox = new BoundingBox(onBox);
        onBox.makeEmpty();
        BoundingBox ebox = bBoxAction.getElementBoundingBox();
        BoundingBox nbox = bBoxAction.getNetworkBoundingBox();
        ebox.union(nbox);
        nbox.makeEmpty();
        nbox.union(nBox);
    }

    public SpatialFeatureCache getCache() {
        return this.cache;
    }

    public void addConditionalHighlighting(BooleanPipe pipe, java.awt.Image image) {
        this.conditionalHighlightingPipes.add(pipe);
        this.conditionalHighlightingImages.add(image);
    }
}

