/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.LinearRing;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.WKBMultiPolygon;
import com.sas.graphics.util.WKBPolygon;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.PropertyContainer;
import com.sas.graphics.util.gtk.StringProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class SpatialFeatureCache
extends PropertyContainer {
    public final StringProperty wkb = new StringProperty(this, false);
    public final NumericProperty id = new NumericProperty(this, false);
    public final StringProperty stringID = new StringProperty(this, false);
    public final NumericProperty segment = new NumericProperty(this, false);
    public final NumericProperty x = new NumericProperty(this, false);
    public final NumericProperty y = new NumericProperty();
    public final BooleanProperty extrudeOn = new BooleanProperty(this, false);
    private boolean featuresCached = false;
    private boolean numericID = true;
    private int featureCount = 0;
    private int vertexCountForAllFeatures = 0;
    private int rowCount = 0;
    private BoundingBox dataBox = new BoundingBox();
    private FeatureIterator map = new FeatureIterator();
    private long firstListID = -1L;
    private long numListIDs = 0L;
    private char[] charArray;
    private int charArrayPointer;
    private boolean autoProject = false;
    private ArrayList<WKBMultiPolygon> multiPolygons;

    public boolean isAutoProject() {
        return this.autoProject;
    }

    public void setAutoProject(boolean autoProject) {
        this.autoProject = autoProject;
    }

    private boolean initProperties() {
        boolean beenInitialized = true;
        AInitAction ia = new AInitAction();
        ia.pushValueCount();
        if (this.wkb.isConnected()) {
            this.wkb.init(ia);
            beenInitialized = ia.beenInitialized(this);
        } else {
            this.segment.init(ia);
            beenInitialized &= ia.beenInitialized(this);
            this.x.init(ia);
            beenInitialized &= ia.beenInitialized(this);
            this.y.init(ia);
            beenInitialized &= ia.beenInitialized(this);
            this.extrudeOn.init(ia);
            beenInitialized &= ia.beenInitialized(this);
        }
        boolean bl = this.numericID = !this.stringID.isConnected();
        if (this.numericID) {
            this.id.init(ia);
        } else {
            this.stringID.init(ia);
        }
        this.rowCount = ia.getValueCount();
        ia.popValueCount();
        return beenInitialized &= ia.beenInitialized(this);
    }

    public long getVertexCount() {
        return this.vertexCountForAllFeatures;
    }

    public long getFeatureCount() {
        return this.featureCount;
    }

    private void removeAll() {
        this.map.idHashMap.clear();
        this.dataBox.makeEmpty();
        this.featureCount = 0;
        this.vertexCountForAllFeatures = 0;
        this.featuresCached = false;
    }

    private void project(Vec3d coord) {
        coord.x = coord.x * 2.003750834E7 / 180.0;
        coord.y = Math.log(Math.tan((90.0 + coord.y) * Math.PI / 360.0)) / (Math.PI / 180);
        coord.y = coord.y * 2.003750834E7 / 180.0;
    }

    public void cacheFeatures(Channel ch) {
        int curSeg;
        boolean beenInitialized = this.initProperties();
        if (beenInitialized) {
            return;
        }
        this.removeAll();
        ch.glPushAttrib(0);
        if (this.extrudeOn.getValue()) {
            ch.setExtrusionVector(0.0, 0.0, 1.0);
        }
        if (this.firstListID > 0L && this.numListIDs >= (long)this.rowCount) {
            for (long i = this.firstListID; i < this.firstListID + this.numListIDs; ++i) {
                ch.glDeleteList(i);
            }
        } else {
            this.numListIDs = this.rowCount;
            this.firstListID = ch.glGenLists(this.numListIDs);
        }
        if (this.wkb.isConnected()) {
            try {
                this.buildWKB(ch);
            }
            catch (Throwable t) {
                System.out.println(t.toString());
            }
            return;
        }
        if (this.multiPolygons != null) {
            this.buildFromPassedInWKB(ch);
            return;
        }
        if (!this.mapDataSetPropertiesAllConnected()) {
            return;
        }
        long listName = this.firstListID;
        Object curID = null;
        int i = 0;
        Vec3d coord = new Vec3d(0.0, 0.0, 0.0);
        SpatialFeature newFeature = new SpatialFeature();
        ch.glNewList(listName);
        while (true) {
            try {
                coord.x = this.x.getValue(i);
                coord.y = this.y.getValue(i);
                if (this.autoProject) {
                    this.project(coord);
                }
                ++newFeature.numVertices;
            }
            catch (MissingValueException mve) {
                ++i;
                continue;
            }
            break;
        }
        try {
            curID = this.numericID ? new Double(this.id.getValue(i)) : this.stringID.getValue(i).trim();
        }
        catch (MissingValueException mve) {
            curID = mve.getMissingValue();
        }
        try {
            curSeg = (int)this.segment.getValue(i);
        }
        catch (MissingValueException mve) {
            curSeg = 1;
        }
        ch.glBegin(this.extrudeOn.getValue() ? 3 : 2);
        ch.glEdgeFlag(true);
        ch.glVertex(coord.x, coord.y, coord.z);
        Vec3d first = new Vec3d(coord);
        Vec3d firstSeg = new Vec3d(coord);
        newFeature.bb.union(coord);
        int firstSegi = i++;
        int firstID = firstSegi;
        while (i < this.rowCount) {
            block34: {
                Object thisID;
                int thisSeg = 0;
                try {
                    thisID = this.numericID ? new Double(this.id.getValue(i)) : this.stringID.getValue(i).trim();
                }
                catch (MissingValueException mve) {
                    thisID = mve.getMissingValue();
                }
                try {
                    thisSeg = (int)this.segment.getValue(i);
                }
                catch (MissingValueException mve) {
                    thisSeg = 1;
                }
                if (!thisID.equals(curID)) {
                    if (firstSegi != i && firstSeg != null) {
                        ch.glEdgeFlag(false);
                        ch.glVertex(firstSeg.x, firstSeg.y, firstSeg.z);
                        ch.glVertex(first.x, first.y, first.z);
                        ch.glEdgeFlag(true);
                        first = null;
                        firstSeg = null;
                        this.dataBox.union(newFeature.bb);
                    }
                    ch.glEnd();
                    ch.glEndList();
                    ++listName;
                    newFeature.displayName = newFeature.displayName;
                    newFeature.ID = curID;
                    ++newFeature.numPolygons;
                    ++this.featureCount;
                    this.vertexCountForAllFeatures += newFeature.numVertices;
                    this.map.idHashMap.put(curID, newFeature);
                    newFeature = new SpatialFeature();
                    ch.glNewList(listName);
                    ch.glBegin(this.extrudeOn.getValue() ? 3 : 2);
                    curID = thisID;
                    curSeg = thisSeg;
                    firstID = firstSegi = i;
                } else if (curSeg != thisSeg) {
                    ch.glEdgeFlag(false);
                    ch.glVertex(firstSeg.x, firstSeg.y, firstSeg.z);
                    ch.glVertex(first.x, first.y, first.z);
                    ch.glEdgeFlag(true);
                    ++newFeature.numPolygons;
                    curSeg = thisSeg;
                    firstSegi = i;
                    firstSeg = null;
                }
                try {
                    coord.x = this.x.getValue(i);
                    coord.y = this.y.getValue(i);
                    if (this.autoProject) {
                        this.project(coord);
                    }
                    ch.glVertex(coord.x, coord.y, coord.z);
                    newFeature.bb.union(coord);
                    ++newFeature.numVertices;
                    if (first == null) {
                        first = new Vec3d(coord);
                    }
                    if (firstSeg == null) {
                        firstSeg = new Vec3d(coord);
                    }
                }
                catch (MissingValueException mve) {
                    if (i == firstSegi) break block34;
                    ch.glEdgeFlag(false);
                    ch.glVertex(firstSeg.x, firstSeg.y, firstSeg.z);
                    ch.glVertex(first.x, first.y, first.z);
                    ch.glEdgeFlag(true);
                    firstSegi = i + 1;
                    firstSeg = null;
                    ++newFeature.numHoles;
                }
            }
            ++i;
        }
        if (firstID != firstSegi) {
            ch.glEdgeFlag(false);
            ch.glVertex(firstSeg.x, firstSeg.y, firstSeg.z);
        }
        if (firstID != i) {
            ch.glEdgeFlag(false);
            ch.glVertex(first.x, first.y, first.z);
            ch.glEnd();
            ch.glEndList();
        }
        newFeature.displayName = listName;
        newFeature.ID = curID;
        ++newFeature.numPolygons;
        ++this.featureCount;
        this.vertexCountForAllFeatures += newFeature.numVertices;
        this.dataBox.union(newFeature.bb);
        this.map.idHashMap.put(curID, newFeature);
        this.featuresCached = true;
    }

    private boolean mapDataSetPropertiesAllConnected() {
        return this.id.isConnected() || this.stringID.isConnected();
    }

    private void buildFromPassedInWKB(Channel ch) {
        long listName = this.firstListID;
        this.featureCount = this.rowCount;
        for (int i = 0; i < this.rowCount; ++i) {
            SpatialFeature newFeature = new SpatialFeature();
            ch.glNewList(listName);
            try {
                newFeature.ID = this.numericID ? new Double(this.id.getValue(i)) : this.stringID.getValue(i).trim();
            }
            catch (MissingValueException mve) {
                newFeature.ID = mve.getMissingValue();
            }
            WKBMultiPolygon mp = this.multiPolygons.get(i);
            newFeature.centroid = this.getCentroid(mp);
            newFeature.displayName = listName;
            if (mp != null) {
                this.addMultiPolygon(mp, newFeature, ch);
            }
            this.map.idHashMap.put(newFeature.ID, newFeature);
            this.vertexCountForAllFeatures += newFeature.numVertices;
            this.dataBox.union(newFeature.bb);
            ch.glEndList();
            ++listName;
        }
        this.charArrayPointer = 0;
        this.charArray = null;
        this.featuresCached = true;
    }

    private void buildWKB(Channel ch) {
        long listName = this.firstListID;
        this.featureCount = this.rowCount;
        this.multiPolygons = new ArrayList();
        for (int i = 0; i < this.rowCount; ++i) {
            String wkbString;
            SpatialFeature newFeature = new SpatialFeature();
            ch.glNewList(listName);
            try {
                newFeature.ID = this.numericID ? new Double(this.id.getValue(i)) : this.stringID.getValue(i).trim();
            }
            catch (MissingValueException mve) {
                newFeature.ID = mve.getMissingValue();
            }
            try {
                wkbString = this.wkb.getValue(i);
            }
            catch (MissingValueException mve) {
                wkbString = null;
            }
            newFeature.displayName = listName;
            if (wkbString != null && wkbString.length() > 0) {
                WKBMultiPolygon mp = this.readWKBString(wkbString);
                if (mp != null) {
                    this.addMultiPolygon(mp, newFeature, ch);
                }
                this.multiPolygons.add(mp);
            }
            this.map.idHashMap.put(newFeature.ID, newFeature);
            this.vertexCountForAllFeatures += newFeature.numVertices;
            this.dataBox.union(newFeature.bb);
            ch.glEndList();
            ++listName;
        }
        this.charArrayPointer = 0;
        this.charArray = null;
        this.featuresCached = true;
    }

    private void addMultiPolygon(WKBMultiPolygon mp, SpatialFeature item, Channel ch) {
        ch.glBegin(this.extrudeOn.getValue() ? 3 : 2);
        int npgn = 0;
        while ((long)npgn < mp.num_wkbPolygons) {
            WKBPolygon pgn = mp.WKBPolygons[npgn];
            item.numHoles += (int)pgn.numRings - 1;
            int nrng = 0;
            while ((long)nrng < pgn.numRings) {
                LinearRing ring = pgn.rings[nrng];
                item.numVertices = (int)((long)item.numVertices + ring.numPoints);
                ch.glEdgeFlag(true);
                int npts = 0;
                while ((long)npts < ring.numPoints) {
                    ch.glVertex(ring.points[npts].x, ring.points[npts].y, ring.points[npts].z);
                    item.bb.union(ring.points[npts]);
                    ++npts;
                }
                if (pgn.numRings > 1L) {
                    ch.glEdgeFlag(false);
                    ch.glVertex(ring.points[0].x, ring.points[0].y, ring.points[0].z);
                    ch.glVertex(mp.WKBPolygons[0].rings[0].points[0].x, mp.WKBPolygons[0].rings[0].points[0].y, mp.WKBPolygons[0].rings[0].points[0].z);
                    ch.glEdgeFlag(true);
                }
                ++nrng;
            }
            if (mp.num_wkbPolygons > 1L || pgn.numRings > 1L) {
                ch.glEdgeFlag(false);
            }
            ch.glVertex(pgn.rings[(int)pgn.numRings - 1].points[0].x, pgn.rings[(int)pgn.numRings - 1].points[0].y, pgn.rings[(int)pgn.numRings - 1].points[0].z);
            ch.glVertex(mp.WKBPolygons[0].rings[0].points[0].x, mp.WKBPolygons[0].rings[0].points[0].y, mp.WKBPolygons[0].rings[0].points[0].z);
            ++npgn;
        }
        ch.glEnd();
    }

    private WKBMultiPolygon readWKBString(String WKB) {
        WKBMultiPolygon mpg = new WKBMultiPolygon();
        this.charArrayPointer = 0;
        this.charArray = WKB.toCharArray();
        String temp = new String(this.charArray, this.charArrayPointer, 2);
        this.charArrayPointer += 4;
        mpg.byteOrder = Byte.parseByte(temp, 16) == 1;
        temp = new String(this.charArray, this.charArrayPointer, 4);
        this.charArrayPointer += 4;
        mpg.wkbType = this.getIntFromString(temp, mpg.byteOrder);
        temp = new String(this.charArray, this.charArrayPointer, 8);
        this.charArrayPointer += 8;
        mpg.num_wkbPolygons = this.getLongFromString(temp, mpg.byteOrder);
        mpg.WKBPolygons = new WKBPolygon[(int)mpg.num_wkbPolygons];
        int npgn = 0;
        while ((long)npgn < mpg.num_wkbPolygons) {
            WKBPolygon pgn = mpg.WKBPolygons[npgn] = this.readPolygon();
            int nrng = 0;
            while ((long)nrng < pgn.numRings) {
                LinearRing ring = pgn.rings[nrng];
                int npts = 0;
                while ((long)npts < ring.numPoints) {
                    ++npts;
                }
                if (pgn.numRings > 1L) {
                    // empty if block
                }
                ++nrng;
            }
            ++npgn;
        }
        return mpg;
    }

    private WKBPolygon readPolygon() {
        WKBPolygon polygon = new WKBPolygon();
        String temp = new String(this.charArray, this.charArrayPointer, 2);
        this.charArrayPointer += 4;
        polygon.byteOrder = Byte.parseByte(temp, 16) == 1;
        temp = new String(this.charArray, this.charArrayPointer, 4);
        this.charArrayPointer += 4;
        polygon.wkbType = this.getIntFromString(temp, polygon.byteOrder);
        temp = new String(this.charArray, this.charArrayPointer, 8);
        this.charArrayPointer += 8;
        polygon.numRings = this.getLongFromString(temp, polygon.byteOrder);
        polygon.rings = new LinearRing[(int)polygon.numRings];
        int i = 0;
        while ((long)i < polygon.numRings) {
            polygon.rings[i] = new LinearRing();
            temp = new String(this.charArray, this.charArrayPointer, 8);
            this.charArrayPointer += 8;
            polygon.rings[i].numPoints = this.getLongFromString(temp, polygon.byteOrder);
            this.charArrayPointer += 8;
            polygon.rings[i].points = new Vec3d[(int)polygon.rings[i].numPoints];
            int j = 0;
            while ((long)j < polygon.rings[i].numPoints) {
                String xString = new String(this.charArray, this.charArrayPointer, 16);
                this.charArrayPointer += 16;
                String yString = new String(this.charArray, this.charArrayPointer, 16);
                this.charArrayPointer += 16;
                double x = this.getDoubleFromString(xString, polygon.byteOrder);
                double y = this.getDoubleFromString(yString, polygon.byteOrder);
                if (this.autoProject) {
                    x = x * 2.003750834E7 / 180.0;
                    y = Math.log(Math.tan((90.0 + y) * Math.PI / 360.0)) / (Math.PI / 180);
                    y = y * 2.003750834E7 / 180.0;
                }
                polygon.rings[i].points[j] = new Vec3d(x, y, 0.0);
                ++j;
            }
            ++i;
        }
        return polygon;
    }

    private int getIntFromString(String tempString, boolean bigEndian) {
        if (bigEndian) {
            tempString = this.swapEnd(tempString);
        }
        return Integer.parseInt(tempString, 16);
    }

    private long getLongFromString(String tempString, boolean bigEndian) {
        if (bigEndian) {
            tempString = this.swapEnd(tempString);
        }
        return Long.parseLong(tempString, 16);
    }

    private double getDoubleFromString(String tempString, boolean bigEndian) {
        if (bigEndian) {
            tempString = this.swapEnd(tempString);
        }
        return Double.longBitsToDouble(this.getLongBitsFromString(tempString));
    }

    private long getLongBitsFromString(String tempString) {
        long l = 0L;
        int shift = 0;
        for (int i = 15; i >= 0; --i) {
            switch (tempString.charAt(i)) {
                case '0': {
                    break;
                }
                case '1': {
                    l += 1L << shift;
                    break;
                }
                case '2': {
                    l += 2L << shift;
                    break;
                }
                case '3': {
                    l += 3L << shift;
                    break;
                }
                case '4': {
                    l += 4L << shift;
                    break;
                }
                case '5': {
                    l += 5L << shift;
                    break;
                }
                case '6': {
                    l += 6L << shift;
                    break;
                }
                case '7': {
                    l += 7L << shift;
                    break;
                }
                case '8': {
                    l += 8L << shift;
                    break;
                }
                case '9': {
                    l += 9L << shift;
                    break;
                }
                case 'A': 
                case 'a': {
                    l += 10L << shift;
                    break;
                }
                case 'B': 
                case 'b': {
                    l += 11L << shift;
                    break;
                }
                case 'C': 
                case 'c': {
                    l += 12L << shift;
                    break;
                }
                case 'D': 
                case 'd': {
                    l += 13L << shift;
                    break;
                }
                case 'E': 
                case 'e': {
                    l += 14L << shift;
                    break;
                }
                case 'F': 
                case 'f': {
                    l += 15L << shift;
                }
            }
            shift += 4;
        }
        return l;
    }

    private String swapEnd(String tempString) {
        char[] ary = tempString.toCharArray();
        char[] rev = new char[ary.length];
        int placement = 0;
        for (int i = ary.length - 1; i >= 0; i -= 2) {
            rev[placement++] = ary[i - 1];
            rev[placement++] = ary[i];
        }
        return new String(rev);
    }

    public boolean isFeaturesCached() {
        return this.featuresCached;
    }

    public FeatureInterface getFeature(double featureID) {
        return this.getFeature(new Double(featureID));
    }

    public FeatureInterface getFeature(Object featureID) {
        return this.map.getFeature(featureID);
    }

    public BoundingBox getBoundingBox() {
        return this.dataBox;
    }

    public Vec3d getCentroid() {
        return this.dataBox.getCenter();
    }

    public void beginFeatureRetrievalTracking() {
        ++this.map.retrieveLevel;
        this.map.currentIndex = 0;
    }

    public void endFeatureRetrievalTracking() {
    }

    public Iterator getUnretrievedFeatureIterator() {
        this.map.currentIndex = 0;
        return this.map;
    }

    public void setMultiPolygons(ArrayList<WKBMultiPolygon> pathList) {
        this.multiPolygons = pathList;
    }

    protected double getPolygonSize(WKBPolygon poly) {
        double xmin = Double.MAX_VALUE;
        double xmax = -1.7976931348623157E308;
        double ymin = Double.MAX_VALUE;
        double ymax = -1.7976931348623157E308;
        int i = 0;
        while ((long)i < poly.rings[0].numPoints) {
            Vec3d point = poly.rings[0].points[i];
            if (point.x < xmin) {
                xmin = point.x;
            }
            if (point.x > xmax) {
                xmax = point.x;
            }
            if (point.y < ymin) {
                ymin = point.y;
            }
            if (point.y > ymax) {
                ymax = point.y;
            }
            ++i;
        }
        return Math.pow((xmax - xmin) * (xmax - xmin) + (ymax - ymin) * (ymax - ymin), 0.5);
    }

    private static Vec3d getCenterWithinPolygon(WKBPolygon poly) {
        int j;
        Vec3d centroid = new Vec3d();
        Vec3d average = new Vec3d();
        Vec3d newPoint = new Vec3d();
        int numPoints = 0;
        double polyxMin = Double.MAX_VALUE;
        double polyxMax = -1.7976931348623157E308;
        double polyyMin = Double.MAX_VALUE;
        double polyyMax = -1.7976931348623157E308;
        int i = 0;
        while ((long)i < poly.numRings) {
            j = 0;
            while ((long)j < poly.rings[i].numPoints) {
                Vec3d point = poly.rings[i].points[j];
                if (point.x < polyxMin) {
                    polyxMin = point.x;
                }
                if (point.x > polyxMax) {
                    polyxMax = point.x;
                }
                if (point.y < polyyMin) {
                    polyyMin = point.y;
                }
                if (point.y > polyyMax) {
                    polyyMax = point.y;
                }
                average.x += point.x;
                average.y += point.y;
                ++j;
            }
            numPoints = (int)((long)numPoints + poly.rings[i].numPoints);
            ++i;
        }
        average.x /= (double)numPoints;
        average.y /= (double)numPoints;
        centroid.x = (polyxMin + polyxMax) * 0.5;
        centroid.y = (polyyMin + polyyMax) * 0.5;
        if (poly.rings[0].numPoints <= 2L) {
            return centroid;
        }
        int n = 0;
        double[] work = new double[numPoints];
        int k = 0;
        while ((long)k < poly.numRings) {
            i = 0;
            while ((long)i < poly.rings[k].numPoints - 1L) {
                double y1 = poly.rings[k].points[i].y;
                double x1 = poly.rings[k].points[i].x;
                double y2 = poly.rings[k].points[i + 1].y;
                double x2 = poly.rings[k].points[i + 1].x;
                if (y1 > y2) {
                    double tempY = y1;
                    y1 = y2;
                    y2 = tempY;
                    double tempX = x1;
                    x1 = x2;
                    x2 = tempX;
                }
                if (centroid.y >= y1 && centroid.y < y2) {
                    newPoint.x = x1 + (centroid.y - y1) / (y2 - y1) * (x2 - x1);
                    if (n == 0) {
                        work[0] = newPoint.x;
                    } else if (newPoint.x >= work[n - 1]) {
                        work[n] = newPoint.x;
                    } else {
                        for (j = n; j > 0 && newPoint.x < work[j - 1]; --j) {
                            work[j] = work[j - 1];
                        }
                        work[j] = newPoint.x;
                    }
                    ++n;
                }
                ++i;
            }
            ++k;
        }
        switch (n) {
            case 0: {
                centroid.x = average.x;
                centroid.y = average.y;
                break;
            }
            case 2: 
            case 3: {
                centroid.x = (work[0] + work[1]) * 0.5;
                break;
            }
            default: {
                if ((n & 1) != 0) {
                    --n;
                }
                j = 0;
                for (i = 2; i < n; i += 2) {
                    if (!(work[i + 1] - work[i] > work[j + 1] - work[j])) continue;
                    j = i;
                }
                centroid.x = (work[j] + work[j + 1]) * 0.5;
            }
        }
        return centroid;
    }

    public Vec3d getCentroid(WKBMultiPolygon mp) {
        double maxSize = Double.MIN_VALUE;
        int foundIndex = -1;
        if (mp == null) {
            return null;
        }
        int i = 0;
        while ((long)i < mp.num_wkbPolygons) {
            double newSize = this.getPolygonSize(mp.WKBPolygons[i]);
            if (newSize >= maxSize) {
                maxSize = newSize;
                foundIndex = i;
            }
            ++i;
        }
        if (foundIndex != -1) {
            return SpatialFeatureCache.getCenterWithinPolygon(mp.WKBPolygons[foundIndex]);
        }
        return null;
    }

    private class FeatureIterator
    implements Iterator {
        public Object[] featureArray = null;
        public int currentIndex = 0;
        public int retrieveLevel = 0;
        public HashMap idHashMap = new HashMap();

        private FeatureIterator() {
        }

        public FeatureInterface getFeature(Object ID) {
            SpatialFeature item = (SpatialFeature)this.idHashMap.get(ID);
            if (item == null) {
                return null;
            }
            item.retrieveIndex = this.retrieveLevel;
            return item;
        }

        @Override
        public boolean hasNext() {
            if (this.featureArray == null) {
                this.featureArray = this.idHashMap.values().toArray();
            }
            while (this.currentIndex < this.featureArray.length && ((SpatialFeature)this.featureArray[this.currentIndex]).retrieveIndex == this.retrieveLevel) {
                ++this.currentIndex;
            }
            return this.currentIndex < this.featureArray.length;
        }

        public Object next() {
            return this.hasNext() ? this.featureArray[this.currentIndex++] : null;
        }

        @Override
        public void remove() {
            this.idHashMap.remove(((SpatialFeature)this.featureArray[this.currentIndex]).ID);
            this.featureArray = this.idHashMap.values().toArray();
        }
    }

    private class SpatialFeature
    implements FeatureInterface {
        public long displayName;
        public Object ID;
        public final BoundingBox bb = new BoundingBox();
        public int numVertices = 0;
        public int numPolygons = 0;
        public int numHoles = 0;
        public int retrieveIndex = 0;
        public Vec3d centroid = null;

        private SpatialFeature() {
        }

        @Override
        public long getDisplayList() {
            return this.displayName;
        }

        @Override
        public BoundingBox getBoundingBox() {
            return this.bb;
        }

        @Override
        public int getVertexCount() {
            return this.numVertices;
        }

        @Override
        public Vec3d getCentroid() {
            if (this.centroid != null) {
                return this.centroid;
            }
            return this.bb.getCenter();
        }
    }

    public static interface FeatureInterface {
        public long getDisplayList();

        public BoundingBox getBoundingBox();

        public Vec3d getCentroid();

        public int getVertexCount();
    }
}

