/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.SASLinePatterns;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.ARectangle;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;

public class Rectangle
extends ARectangle {
    public Rectangle() {
        super(new Transform());
    }

    public static void drawRectangle(Channel channel, double sizeX, double sizeY, Color color, Color edgeColor, boolean edgeOn, boolean fillOn, int origin) {
        Rectangle.drawRectangle(channel, sizeX, sizeY, 0.0, 0.0, 0.0, color, edgeColor, edgeOn, fillOn, origin);
    }

    public static void drawRectangle(Channel channel, double sizeX, double sizeY, double coordX, double coordY, double coordZ, Color color, Color edgeColor, boolean edgeOn, boolean fillOn, int origin) {
        double sXHalf = sizeX / 2.0;
        double sYHalf = sizeY / 2.0;
        Vec3d center = new Vec3d();
        ARectangle.computeCenter(sizeX, sizeY, coordX, coordY, coordZ, origin, center);
        channel.glPushAttrib(0);
        channel.glColor(color);
        channel.glEdgeColor(edgeColor);
        channel.glPolygonMode(BuildAction.getGLFillStyle(fillOn, edgeOn));
        channel.glBegin(2);
        channel.glNormal(0.0, 0.0, 1.0);
        channel.glVertex(center.x - sXHalf, center.y - sYHalf);
        channel.glVertex(center.x + sXHalf, center.y - sYHalf);
        channel.glVertex(center.x + sXHalf, center.y + sYHalf);
        channel.glVertex(center.x - sXHalf, center.y + sYHalf);
        channel.glEnd();
        channel.glPopAttrib();
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        int index = ba.getValueIndex();
        Channel ch = ba.getChannel();
        if (ch.isSVGSelectionMode()) {
            ch.setSVGSelectionText(this.userDataToString(index));
        }
        Color ec = null;
        int ew = 0;
        int ep = -1;
        double sx = this.sizeX.getValue(index);
        double sy = this.sizeY.getValue(index);
        double cx = this.coordX.getValue(index);
        double cy = this.coordY.getValue(index);
        Color c = this.color.getValue(index);
        boolean eo = this.edgeOn.getValue(index);
        if (eo) {
            ec = this.edgeColor.getValue(index);
            ew = this.edgeWidth.getValue(index);
            ep = this.edgePattern.getValue(index);
        }
        boolean fo = this.fillOn.getValue(index);
        int o = this.origin.getValue(index);
        if (this.is2D()) {
            double y1;
            double x1;
            if (fo) {
                ch.glColor(c);
            } else {
                ch.glColor(ec);
            }
            if (eo) {
                ch.glEdgeColor(ec);
                ch.glLineWidth((float)ew);
                if (ep >= 0) {
                    ch.glEnable(6);
                    ch.glLineStipple(SASLinePatterns.getStippleFactor((int)ep), SASLinePatterns.getStipplePattern((int)ep));
                }
            }
            ch.glPolygonMode(BuildAction.getGLFillStyle(fo, eo));
            switch (o) {
                default: {
                    x1 = cx - sx / 2.0;
                    y1 = cy - sy / 2.0;
                    break;
                }
                case 1: {
                    x1 = cx - sx / 2.0;
                    y1 = cy;
                    break;
                }
                case 2: {
                    x1 = cx - sx / 2.0;
                    y1 = cy + sy;
                    break;
                }
                case 3: {
                    x1 = cx;
                    y1 = cy - sy / 2.0;
                    break;
                }
                case 4: {
                    x1 = cx + sx;
                    y1 = cy - sy / 2.0;
                    break;
                }
                case 5: {
                    x1 = cx;
                    y1 = cy;
                }
            }
            double x2 = x1 + sx;
            double y2 = y1 + sy;
            ch.glRect(x1, y1, x2, y2);
            ch.glLineWidth(1.0f);
            ch.glDisable(6);
        } else {
            double cz = this.coordZ.getValue(index);
            Rectangle.drawRectangle(ch, sx, sy, cx, cy, cz, c, ec, eo, fo, o);
        }
    }
}

