/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Markers;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.SelectEntry;
import com.sas.graphics.util.gtk.gl.AbstractMarkerSkinFactory;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;

public class Marker
extends Element {
    public final NumericProperty coordX = new NumericProperty(this, true);
    public final NumericProperty coordY = new NumericProperty(this, true);
    public final NumericProperty coordZ = new NumericProperty(this, true);
    public final ColorProperty color = new ColorProperty(this, true);
    public final ColorProperty edgeColor = new ColorProperty(this, true);
    public final IntegerProperty type = new IntegerProperty(this, true);
    public final IntegerProperty size = new IntegerProperty(this, true);
    public final ColorProperty highlightFillColor = new ColorProperty(this, true);
    public final ColorProperty highlightEdgeColor = new ColorProperty(this, true);
    public final BooleanProperty highlightOn = new BooleanProperty(this, true);
    public final IntegerProperty edgeWeight = new IntegerProperty(this, true);
    public final IntegerProperty edgeWidth = new IntegerProperty(this, true);
    public final BooleanProperty weightedEdgeEnabled = new BooleanProperty(this, true);
    public final NumericProperty drawCount = new NumericProperty(this, true);
    private int myValueCount;
    private boolean fast = true;
    private Image skin = null;
    private AbstractMarkerSkinFactory skinFactory = null;
    private int skinType = 0;
    private Image[] pixelBenderImages = null;
    private float DPIScaleFactor = 1.0f;
    private boolean cacheSkinFilters = true;
    protected boolean SVGRender;

    public Marker() {
        super(new Transform());
        this.size.setValue(6);
        this.type.setValue(3);
        this.highlightOn.setValue(false);
        this.weightedEdgeEnabled.setValue(false);
        this.edgeWeight.setValue(0);
        this.edgeWidth.setValue(1);
        this.drawCount.setValue(1.0);
        this.SVGRender = false;
    }

    public void setFast(boolean trueOrFalse) {
        this.fast = trueOrFalse;
    }

    public boolean isFast() {
        return this.fast;
    }

    public void setSkin(Image newImage) {
        this.skin = newImage;
    }

    public Image getSkin() {
        return this.skin;
    }

    public void setSkinType(int t) {
        this.skinType = t;
    }

    public int getSkinType() {
        return this.skinType;
    }

    public void setPixelBenderImages(Image[] newImages) {
        this.pixelBenderImages = newImages;
    }

    public Image[] getPixelBenderImages() {
        return this.pixelBenderImages;
    }

    public void setDPIScaleFactor(float fac) {
        this.DPIScaleFactor = fac;
    }

    public float getDPIScaleFactor() {
        return this.DPIScaleFactor;
    }

    public void setCacheSkinFilters(boolean b) {
        this.cacheSkinFilters = b;
    }

    public boolean isCacheSkinFilters() {
        return this.cacheSkinFilters;
    }

    @Override
    public void init(AInitAction initAction) {
        if (this.fast) {
            this.initFast(initAction);
        } else {
            this.initFullFeatured(initAction);
        }
    }

    private void initFast(AInitAction initAction) {
        initAction.pushValueCount();
        super.init(initAction);
        this.myValueCount = initAction.getValueCount();
        if (this.myValueCount == -1) {
            this.myValueCount = 1;
        }
        initAction.popValueCount();
        this.setValueCount(1);
        initAction.setValueCount(1);
    }

    private void initFullFeatured(AInitAction initAction) {
        super.init(initAction);
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        boolean antialiasingOn;
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        Channel channel = ba.getChannel();
        Graphics2D g2 = (Graphics2D)channel.getBackbufferGC();
        boolean bl = antialiasingOn = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_ON;
        if (antialiasingOn) {
            channel.glEnable(13);
        } else {
            channel.glDisable(13);
        }
        if (this.fast) {
            this.renderFast(buildAction);
        } else {
            this.renderFullFeatured(buildAction);
        }
    }

    private void renderFast(ABuildAction buildAction) throws MissingValueException {
        boolean colorsCanVary;
        if (this.myValueCount == 0) {
            return;
        }
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        Channel channel = ba.getChannel();
        boolean colorConnected = this.color.isConnected();
        boolean edgeColorConnected = this.edgeColor.isConnected();
        boolean highlightColorConnected = this.highlightFillColor.isConnected();
        boolean highlightEdgeColorConnected = this.highlightEdgeColor.isConnected();
        boolean sizeConnected = this.size.isConnected();
        boolean typeConnected = this.type.isConnected();
        boolean zConnected = this.coordZ.isConnected();
        boolean highlightOnConnected = this.highlightOn.isConnected();
        boolean weightedEdgeEnabledConnected = this.weightedEdgeEnabled.isConnected();
        boolean edgeWidthConnected = this.edgeWidth.isConnected();
        boolean edgeWeightConnected = this.edgeWeight.isConnected();
        boolean ho = this.highlightOn.getValue();
        boolean porpEdgeEnabled = false;
        boolean drawCountConnected = this.drawCount.isConnected();
        int dc = (int)this.drawCount.getValue();
        int markerSize = 0;
        boolean edgeWidthVaries = true;
        if (!weightedEdgeEnabledConnected) {
            porpEdgeEnabled = this.weightedEdgeEnabled.getValue();
            if (porpEdgeEnabled) {
                channel.glEnable(28);
                if (!edgeWeightConnected) {
                    edgeWidthVaries = false;
                    channel.setMarkerWeight(this.edgeWeight.getValue());
                }
            } else {
                channel.glDisable(28);
                if (!edgeWidthConnected) {
                    edgeWidthVaries = false;
                    channel.glLineWidth((float)this.edgeWidth.getValue());
                }
            }
        }
        boolean bl = colorsCanVary = colorConnected || edgeColorConnected || highlightColorConnected || highlightOnConnected || highlightEdgeColorConnected;
        if (!highlightOnConnected && ho) {
            channel.glColor(this.highlightFillColor.getValue());
            channel.glEdgeColor(this.highlightEdgeColor.getValue());
        } else {
            channel.glColor(this.color.getValue());
            Color ec = this.edgeColor.getValue();
            channel.glEdgeColor(ec);
        }
        if (!sizeConnected) {
            markerSize = this.size.getValue();
            channel.setMarkerSize(markerSize);
        }
        if (!typeConnected) {
            if (this.SVGRender) {
                channel.setMarkerType(Markers.getSVGShape((int)this.type.getValue()));
            } else {
                channel.setMarkerType(this.type.getValue());
            }
        }
        double z = this.coordZ.getValue();
        channel.glSkinType(this.getSkinType());
        channel.glPixelBenderImages(this.getPixelBenderImages());
        channel.glDPIScaleFactor(this.getDPIScaleFactor());
        channel.glCacheSkinFilters(this.isCacheSkinFilters());
        for (int index = 0; index < this.myValueCount; ++index) {
            try {
                if (colorsCanVary) {
                    ho = this.highlightOn.getValue(index);
                    if (ho) {
                        channel.glColor(this.highlightFillColor.getValue(index));
                        channel.glEdgeColor(this.highlightEdgeColor.getValue(index));
                    } else {
                        channel.glColor(this.color.getValue(index));
                        channel.glEdgeColor(this.edgeColor.getValue(index));
                    }
                }
                if (sizeConnected) {
                    markerSize = this.size.getValue(index);
                    channel.setMarkerSize(markerSize);
                }
                if (typeConnected) {
                    if (this.SVGRender) {
                        channel.setMarkerType(Markers.getSVGShape((int)this.type.getValue(index)));
                    } else {
                        channel.setMarkerType(this.type.getValue(index));
                    }
                }
                if (this.skinFactory != null) {
                    Image skin = this.skinFactory.getSkinImage(this.type.getValue(index));
                    channel.setMarkerskin(skin);
                } else if (this.skin != null) {
                    channel.setMarkerskin(this.skin);
                } else {
                    channel.setMarkerskin(null);
                }
                if (weightedEdgeEnabledConnected) {
                    porpEdgeEnabled = this.weightedEdgeEnabled.getValue(index);
                    if (porpEdgeEnabled) {
                        channel.glEnable(28);
                    } else {
                        channel.glDisable(28);
                    }
                }
                if (edgeWidthVaries) {
                    if (porpEdgeEnabled) {
                        channel.setMarkerWeight(this.edgeWeight.getValue(index));
                    } else {
                        channel.glLineWidth((float)this.edgeWidth.getValue(index));
                    }
                }
                double x = this.coordX.getValue(index);
                double y = this.coordY.getValue(index);
                if (zConnected) {
                    z = this.coordZ.getValue(index);
                }
                if (buildAction.isUseNameStack()) {
                    channel.glPopName();
                    channel.glLoadName((Object)new SelectEntry(this, index));
                    channel.glPushName(null);
                    if (channel.isSVGSelectionMode()) {
                        channel.setSVGSelectionText(this.userDataToString(index));
                    }
                }
                if (drawCountConnected) {
                    dc = (int)this.drawCount.getValue(index);
                }
                if (dc == 1) {
                    channel.glMarker(x, y, z);
                    continue;
                }
                if (dc <= 1) continue;
                for (int j = 0; j < dc; ++j) {
                    channel.glMarker(x, y, z);
                }
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        channel.glPolygonMode(3);
        channel.glSkinType(0);
        channel.glPixelBenderImages(null);
        channel.glCacheSkinFilters(false);
        channel.clearSkinFilterCache();
    }

    private void renderFullFeatured(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        Channel channel = ba.getChannel();
        int index = ba.getValueIndex();
        try {
            boolean weighted = this.weightedEdgeEnabled.getValue(index);
            if (weighted) {
                channel.glEnable(28);
                channel.setMarkerWeight(this.edgeWeight.getValue(index));
            } else {
                channel.glDisable(28);
                channel.glLineWidth((float)this.edgeWidth.getValue(index));
            }
            channel.setMarkerSize(this.size.getValue(index));
            if (this.SVGRender) {
                channel.setMarkerType(Markers.getSVGShape((int)this.type.getValue(index)));
            } else {
                channel.setMarkerType(this.type.getValue(index));
            }
            if (this.skinFactory != null) {
                channel.setMarkerskin(this.skinFactory.getSkinImage(this.type.getValue(index)));
            } else if (this.skin != null) {
                channel.setMarkerskin(this.skin);
            } else {
                channel.setMarkerskin(null);
            }
            channel.glSkinType(this.getSkinType());
            channel.glPixelBenderImages(this.getPixelBenderImages());
            channel.glDPIScaleFactor(this.getDPIScaleFactor());
            double x = this.coordX.getValue(index);
            double y = this.coordY.getValue(index);
            double z = this.coordZ.getValue(index);
            Color c = this.color.getValue(index);
            channel.glColor(c);
            if (this.highlightOn.getValue(index)) {
                channel.glColor(this.highlightFillColor.getValue(index));
                channel.glEdgeColor(this.highlightEdgeColor.getValue(index));
            }
            c = this.edgeColor.getValue(index);
            channel.glEdgeColor(c);
            int dc = (int)this.drawCount.getValue(index);
            for (int i = 0; i < dc; ++i) {
                channel.glMarker(x, y, z);
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        channel.glSkinType(0);
        channel.glPixelBenderImages(null);
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) {
        Vec3d pt = bBoxAction.pt1;
        BoundingBox box = bBoxAction.getElementBoundingBox();
        int i = bBoxAction.getValueIndex();
        try {
            pt.x = this.coordX.getValue(i);
            pt.y = this.coordY.getValue(i);
            pt.z = this.coordZ.getValue(i);
            box.union(pt);
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
    }

    public void setSVGRender(boolean SVG) {
        this.SVGRender = SVG;
    }

    public boolean isSVGRender() {
        return this.SVGRender;
    }

    public AbstractMarkerSkinFactory getSkinFactory() {
        return this.skinFactory;
    }

    public void setSkinFactory(AbstractMarkerSkinFactory skinFactory) {
        this.skinFactory = skinFactory;
    }
}

