/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.SASLinePatterns;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.ALineSegment;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;

public class LineSegment
extends ALineSegment {
    public LineSegment() {
        super(new Transform());
    }

    public static void drawLineSegment(Channel channel, double beginX, double beginY, double beginZ, double endX, double endY, double endZ, Color color, double lineWidth, int stipplePat, int stippleFac) {
        LineSegment.drawLineSegment(channel, beginX, beginY, beginZ, endX, endY, endZ, color, lineWidth, stipplePat, stippleFac, false);
    }

    public static void drawLineSegment(Channel channel, double beginX, double beginY, double beginZ, double endX, double endY, double endZ, Color color, double lineWidth, int stipplePat, int stippleFac, boolean disableAntialiasForHorizontalOrVertical) {
        LineSegment.drawLineSegment(channel, beginX, beginY, beginZ, endX, endY, endZ, color, lineWidth, stipplePat, stippleFac, disableAntialiasForHorizontalOrVertical, 1);
    }

    public static void drawLineSegment(Channel channel, double beginX, double beginY, double beginZ, double endX, double endY, double endZ, Color color, double lineWidth, int stipplePat, int stippleFac, boolean disableAntialiasForHorizontalOrVertical, int drawCount) {
        boolean stippleNeeded;
        boolean bl = stippleNeeded = stippleFac > 0 && (stipplePat & 0xFFFF) != 65535;
        if (stippleNeeded) {
            channel.glEnable(6);
            channel.glLineStipple(stippleFac, (int)((short)stipplePat));
        }
        if (disableAntialiasForHorizontalOrVertical) {
            channel.glEnable(17);
        }
        channel.glLineWidth((float)lineWidth);
        channel.glColor(color);
        for (int i = 0; i < drawCount; ++i) {
            channel.glBegin(1);
            channel.glVertex(beginX, beginY, beginZ);
            channel.glVertex(endX, endY, endZ);
            channel.glEnd();
        }
        channel.glLineWidth(1.0f);
        if (disableAntialiasForHorizontalOrVertical) {
            channel.glDisable(17);
        }
        if (stippleNeeded) {
            channel.glDisable(6);
        }
    }

    public static void drawLineSegment(Channel channel, double beginX, double beginY, double beginZ, double endX, double endY, double endZ, Color color, double lineWidth, int stipplePat, int stippleFac, boolean disableAntialiasForHorizontalOrVertical, int drawCount, int skinType, float dpiFactor) {
        boolean stippleNeeded;
        boolean bl = stippleNeeded = stippleFac > 0 && (stipplePat & 0xFFFF) != 65535;
        if (stippleNeeded) {
            channel.glEnable(6);
            channel.glLineStipple(stippleFac, (int)((short)stipplePat));
        }
        if (disableAntialiasForHorizontalOrVertical) {
            channel.glEnable(17);
        }
        channel.glLineWidth((float)lineWidth);
        channel.glColor(color);
        channel.glSkinType(skinType);
        channel.glDPIScaleFactor(dpiFactor);
        for (int i = 0; i < drawCount; ++i) {
            channel.glBegin(1);
            channel.glVertex(beginX, beginY, beginZ);
            channel.glVertex(endX, endY, endZ);
            channel.glEnd();
        }
        channel.glLineWidth(1.0f);
        if (disableAntialiasForHorizontalOrVertical) {
            channel.glDisable(17);
        }
        if (stippleNeeded) {
            channel.glDisable(6);
        }
        channel.glSkinType(0);
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        int index = ba.getValueIndex();
        if (ba.getChannel().isSVGSelectionMode()) {
            ba.getChannel().setSVGSelectionText(this.userDataToString(index));
        }
        double bx = this.beginX.getValue(index);
        double by = this.beginY.getValue(index);
        double bz = this.beginZ.getValue(index);
        double ex = this.endX.getValue(index);
        double ey = this.endY.getValue(index);
        double ez = this.endZ.getValue(index);
        boolean disableHV = this.disableAntialiasingForHorizontalOrVerticalLines.getValue(index);
        int stippleFactor_sav = this.stippleFactor;
        if (this.linePattern.isConnected()) {
            int patternIndex = this.linePattern.getValue(index);
            this.stipplePattern = SASLinePatterns.getStipplePattern((int)patternIndex);
            this.stippleFactor = (int)(0.5 + this.stippleScaleFactor * (double)SASLinePatterns.getStippleFactor((int)patternIndex));
        } else if (this.linePattern.getValue() != -1) {
            int patternIndex = this.linePattern.getValue();
            this.stipplePattern = SASLinePatterns.getStipplePattern((int)patternIndex);
            this.stippleFactor = (int)(0.5 + this.stippleScaleFactor * (double)SASLinePatterns.getStippleFactor((int)patternIndex));
        } else if (this.stippleScaleFactor != 1.0) {
            this.stippleFactor = (int)(0.5 + this.stippleScaleFactor * (double)this.stippleFactor);
        }
        if (this.skinType == 0) {
            LineSegment.drawLineSegment(ba.getChannel(), bx, by, bz, ex, ey, ez, this.color.getValue(index), this.lineWidth.getValue(index), this.stipplePattern, this.stippleFactor, disableHV, (int)this.drawCount.getValue(index));
        } else {
            LineSegment.drawLineSegment(ba.getChannel(), bx, by, bz, ex, ey, ez, this.color.getValue(index), this.lineWidth.getValue(index), this.stipplePattern, this.stippleFactor, disableHV, (int)this.drawCount.getValue(index), this.skinType, this.DPIScaleFactor);
        }
        this.stippleFactor = stippleFactor_sav;
    }
}

