/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ALegend;
import com.sas.graphics.util.gtk.ColorMap;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.LegendDetail;
import com.sas.graphics.util.gtk.LegendStyle;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.SelectDetail;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.gl.AbstractMarkerSkinFactory;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.InitAction;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;

public class Legend
extends ALegend {
    private static final Integer labelDetailType = new Integer(0);
    private static final Integer titleDetailType = new Integer(1);
    private static final Integer titleMarkerDetailType = new Integer(2);
    private static final Integer backgroundDetailType = new Integer(3);
    private static final Integer labelMarkerDetailType = new Integer(4);
    protected Channel channel = null;
    private int labelCount;
    private int rangeCount;
    private int colorPlacementPercentageCount;
    private double maxLabelLength = 0.0;
    private double maxLabelHeight = 0.0;
    private double[] maxColumnLabelLength;
    private double rowLabelLength;
    private double[] labelLength;
    private double[] labelHeight;
    private double shortestLabelLength;
    private double longestLabelLength;
    private String[] labelArray = new String[5];
    private double tmpWidth = Double.NaN;
    private double tmpHeight = Double.NaN;
    double titleMargin = 0.0;
    double labelMargin = 0.0;
    private double markerWidth;
    private double markerHeight;
    private double usableWidth;
    private double usableHeight;
    private int tmpShapePolicy;
    private double pixelWidth;
    private int rowCount = 0;
    private int columnCount = 0;
    private double[] titleInsets;
    private boolean legendFits = true;
    private Font currentTitleFont;
    private Font currentLabelFont;
    private boolean smoothShading = true;
    private List colorPercentageList = new ArrayList();
    private AbstractMarkerSkinFactory skinFactory = null;
    private SoftReference[][] scaledSkinCache = null;
    private int SKIN_CACHE_LIMIT = 100;
    private final Comparator colorRampEntryComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            ColorRampEntry e1 = (ColorRampEntry)o1;
            ColorRampEntry e2 = (ColorRampEntry)o2;
            return Double.compare(e1.percentage, e2.percentage);
        }
    };
    private double continuousColorBarThickness;
    private boolean SVGRender = false;
    static final int TOP = 0;
    static final int BOTTOM = 1;
    static final int LEFT = 2;
    static final int RIGHT = 3;

    public Legend(ColorMapper mapper) {
        this();
        this.labels.connectFrom(mapper.label);
        this.colors.connectFrom(mapper.uniqueValue);
    }

    public Legend(ColorMap map) {
        this();
        this.labels.connectFrom(map.label);
        this.colors.connectFrom(map.uniqueValue);
    }

    public Legend() {
        super(new Transform());
    }

    @Override
    public void init(AInitAction initAction) {
        super.init(initAction);
        this.currentTitleFont = this.style.getTitleStyle().getFont();
        this.currentLabelFont = this.style.getLabelStyle().getFont();
        this.labelCount = this.initLabels(initAction);
        this.rangeCount = this.isContinuous() ? this.labelCount - 1 : this.labelCount;
    }

    @Override
    protected int initLabels(AInitAction initAction) {
        initAction.pushValueCount();
        this.labels.init(initAction);
        this.colors.init(initAction);
        this.colorPlacementPercentages.init(initAction);
        this.markerTypes.init(initAction);
        this.labelCount = initAction.getValueCount();
        initAction.popValueCount();
        initAction.pushValueCount();
        this.colorPlacementPercentages.init(initAction);
        this.colorPlacementPercentageCount = initAction.getValueCount();
        initAction.popValueCount();
        this.buildColorPercentageList();
        this.channel = InitAction.castInitAction(initAction).getChannel();
        this.legendFits = false;
        double[] origin = new double[]{0.0, 0.0, 0.0};
        double[] win = new double[3];
        double[] winpixel = new double[3];
        this.channel.gluProject(origin, win);
        win[0] = win[0] + 1.0;
        win[1] = win[1] + 1.0;
        this.channel.gluUnProject(win, winpixel);
        this.pixelWidth = Math.round(winpixel[0]);
        winpixel = null;
        origin = null;
        win = null;
        this.labelMargin = this.titleMargin = 4.0 * this.pixelWidth;
        this.tmpHeight = 0.0;
        this.tmpWidth = 0.0;
        if (this.labelCount <= 0) {
            this.legendFits = true;
            return this.labelCount;
        }
        if (this.labelLength == null || this.labelLength.length < this.labelCount) {
            this.labelLength = new double[this.labelCount];
            this.labelHeight = new double[this.labelCount];
            this.labelArray = new String[this.labelCount];
            this.maxColumnLabelLength = new double[this.labelCount];
        }
        double[] insets = this.getTitleBorderInsets(this.channel, this.title.getValue(), this.style);
        this.applyTextStyle(this.style.getLabelStyle());
        this.computeLabelLengths(this.currentLabelFont);
        this.computeUsableSize(insets);
        if (this.usableWidth > 0.0 && this.usableHeight > 0.0) {
            if (this.isContinuous()) {
                this.layoutContinuous(insets);
                this.legendFits = true;
            } else {
                this.layoutDiscrete(insets);
            }
        }
        return this.labelCount;
    }

    private void layoutContinuous(double[] insets) {
        this.continuousColorBarThickness = this.maxLabelHeight * this.style.getContinuousColorBarThickness();
        if (this.isLayoutByRow()) {
            this.tmpWidth = this.labelLength[0] + this.labelLength[this.labelLength.length - 1] + 2.0 * this.labelMargin + 2.0 * this.getHorizontalMargin() + this.getContinuousLength();
            this.tmpHeight = 2.0 * this.getVerticalMargin() + this.continuousColorBarThickness;
        } else {
            this.tmpWidth = this.continuousColorBarThickness + 2.0 * this.getHorizontalMargin();
            this.tmpHeight = this.getContinuousLength() + 2.0 * this.getVerticalMargin();
            if (this.getLabelingMethod() != 0) {
                this.tmpWidth += this.maxLabelLength + this.labelMargin;
                this.tmpHeight += 2.0 * this.labelMargin + this.maxLabelHeight;
            }
        }
        this.tmpWidth += this.getWidth() - this.usableWidth;
        this.legendFits = this.tmpWidth <= this.getWidth();
    }

    private void layoutDiscrete(double[] insets) {
        int layoutCount = this.getLayoutCount();
        int labelFontSize = this.currentLabelFont.getSize();
        int titleFontSize = this.currentTitleFont.getSize();
        int originalLabelFontSize = labelFontSize;
        int originalTitleFontSize = titleFontSize;
        this.tmpShapePolicy = this.style.getShapePolicy();
        if (this.tmpShapePolicy == 0) {
            this.tmpShapePolicy = this.usableWidth > this.usableHeight ? 1 : 2;
        }
        this.legendFits = false;
        this.channel.glSelect2DFont(this.currentLabelFont);
        while (!this.legendFits && labelFontSize >= this.style.getMinimumLabelFontSize() && titleFontSize >= this.style.getMinimumLabelFontSize()) {
            if (labelFontSize < originalLabelFontSize) {
                titleFontSize = (int)Math.floor((double)originalTitleFontSize * ((double)labelFontSize / (double)originalLabelFontSize));
                this.currentLabelFont = this.currentLabelFont.deriveFont((float)labelFontSize);
                this.currentTitleFont = this.currentTitleFont.deriveFont((float)titleFontSize);
                insets = this.getTitleBorderInsets(this.channel, this.title.getValue(), this.style);
                this.computeLabelLengths(this.currentLabelFont);
                this.computeUsableSize(insets);
            }
            if (layoutCount == -1) {
                if (this.tmpShapePolicy == 1) {
                    this.rowCount = (int)Math.ceil(((double)this.labelCount * (this.shortestLabelLength + this.markerWidth + this.labelMargin) + (double)(this.labelCount - 1) * this.labelMargin) / this.usableWidth);
                    this.columnCount = (int)Math.ceil((double)this.labelCount / (double)this.rowCount);
                } else {
                    if (!(this.usableHeight > 0.0)) break;
                    this.columnCount = (int)Math.ceil(((double)this.labelCount * this.markerHeight + (double)(this.labelCount - 1) * this.labelMargin) / this.usableHeight);
                    if (this.columnCount > this.labelCount) {
                        this.columnCount = this.labelCount;
                    }
                    this.rowCount = (int)Math.ceil((double)this.labelCount / (double)this.columnCount);
                }
                this.rowLabelLength = this.computeMaxLabelLengthPerColumn();
                this.legendFits = this.doesLegendFit();
                if (!this.legendFits) {
                    while (!this.legendFits && !this.isRowColumnMaxedOut()) {
                        if (this.tmpShapePolicy == 1) {
                            ++this.rowCount;
                            this.columnCount = (int)Math.ceil((double)this.labelCount / (double)this.rowCount);
                        } else if (this.usableHeight > 0.0) {
                            ++this.columnCount;
                            this.rowCount = (int)Math.ceil((double)this.labelCount / (double)this.columnCount);
                        }
                        this.rowLabelLength = this.computeMaxLabelLengthPerColumn();
                        this.legendFits = this.doesLegendFit();
                    }
                }
            } else {
                if (this.isLayoutByRow()) {
                    this.columnCount = layoutCount <= this.labelCount ? layoutCount : this.labelCount;
                    this.rowCount = (int)Math.ceil((double)this.labelCount / (double)this.columnCount);
                } else if (this.usableHeight > 0.0) {
                    this.rowCount = layoutCount <= this.labelCount ? layoutCount : this.labelCount;
                    this.columnCount = (int)Math.ceil((double)this.labelCount / (double)this.rowCount);
                }
                this.rowLabelLength = this.computeMaxLabelLengthPerColumn();
                this.legendFits = this.doesLegendFit();
            }
            if (this.legendFits) continue;
            --labelFontSize;
        }
        this.tmpWidth += this.computeMarkersLabelsWidth() + (this.getWidth() - this.usableWidth + 1.0);
        this.tmpHeight += this.computeMarkersLabelsHeight() + 2.0 * this.getVerticalMargin();
    }

    private boolean isRowColumnMaxedOut() {
        boolean maxedOut = false;
        maxedOut = this.tmpShapePolicy == 1 ? this.rowCount >= this.labelCount : this.columnCount >= this.labelCount;
        return maxedOut;
    }

    private double computeMarkersLabelsWidth() {
        double result = (double)this.columnCount * (this.markerWidth + this.labelMargin) + (double)(this.columnCount - 1) * this.markerWidth + this.rowLabelLength;
        return result;
    }

    private double computeMarkersLabelsHeight() {
        double result = (double)this.rowCount * this.markerHeight + (double)(this.rowCount - 1) * this.labelMargin;
        return result;
    }

    private void computeUsableSize(double[] titleBorderInsets) {
        this.usableWidth = this.getWidth() - (titleBorderInsets[2] + titleBorderInsets[3] + 2.0 * this.getHorizontalMargin()) - 1.0;
        this.usableHeight = this.getHeight() - (titleBorderInsets[0] + titleBorderInsets[1] + 2.0 * this.getVerticalMargin());
    }

    private void computeLabelLengths(Font labelFont) {
        this.channel.glSelect2DFont(labelFont);
        this.maxLabelHeight = this.channel.glGetTextHeight();
        this.shortestLabelLength = Double.POSITIVE_INFINITY;
        this.longestLabelLength = Double.NEGATIVE_INFINITY;
        for (int index = 0; index < this.labelCount; ++index) {
            try {
                this.labelArray[index] = this.labels.getValue(index);
                this.labelLength[index] = this.channel.glGetTextWidth(this.labelArray[index]);
                this.labelHeight[index] = this.maxLabelHeight;
                if (this.labelLength[index] > this.longestLabelLength) {
                    this.longestLabelLength = this.labelLength[index];
                }
                if (this.labelLength[index] < this.shortestLabelLength) {
                    this.shortestLabelLength = this.labelLength[index];
                }
                this.maxColumnLabelLength[index] = 0.0;
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        this.maxLabelLength = this.longestLabelLength;
        this.markerWidth = this.markerHeight = this.maxLabelHeight;
    }

    private double computeMaxLabelLengthPerColumn() {
        int row;
        int column;
        for (column = 0; column < this.columnCount; ++column) {
            this.maxColumnLabelLength[column] = 0.0;
        }
        if (this.isLayoutByRow()) {
            for (row = 0; row < this.rowCount; ++row) {
                int columnOffset = row * this.columnCount;
                for (column = 0; column < this.columnCount && columnOffset + column < this.labelLength.length; ++column) {
                    this.maxColumnLabelLength[column] = Math.max(this.maxColumnLabelLength[column], this.labelLength[columnOffset + column]);
                }
            }
        } else {
            for (column = 0; column < this.columnCount; ++column) {
                int rowOffset = column * this.rowCount;
                for (row = 0; row < this.rowCount && rowOffset + row < this.labelLength.length; ++row) {
                    this.maxColumnLabelLength[column] = Math.max(this.maxColumnLabelLength[column], this.labelLength[rowOffset + row]);
                }
            }
        }
        int rowLabelLength = 0;
        for (int j = 0; j < this.columnCount; ++j) {
            rowLabelLength = (int)((double)rowLabelLength + this.maxColumnLabelLength[j]);
        }
        return rowLabelLength;
    }

    private double computeTitleWidth() {
        this.channel.glSelect2DFont(this.currentTitleFont);
        return this.channel.glGetTextWidth(this.title.getValue());
    }

    private boolean doesLegendFit() {
        double heightAttempt = this.computeMarkersLabelsHeight();
        double widthAttempt = this.computeMarkersLabelsWidth();
        return heightAttempt <= this.usableHeight && widthAttempt <= this.usableWidth;
    }

    public boolean isLegendFit() {
        return this.legendFits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        if (!this.legendFits) {
            return;
        }
        int valueIndex = buildAction.getValueIndex();
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        this.channel = ba.getChannel();
        String titleStr = null;
        try {
            double h;
            double w;
            this.channel.glPushAttrib(0);
            if (this.isTitleVisible()) {
                titleStr = this.title.getValue(valueIndex);
                Vec3d tp = this.addTitleDimensions(this.channel, titleStr, this.tmpWidth, this.tmpHeight, this.style);
                this.tmpWidth = tp.x;
                this.tmpHeight = tp.y;
            }
            if (this.style.isBorderOn()) {
                Vec3d bp = this.addBorderDimensions(this.tmpWidth, this.tmpHeight, this.style);
                this.tmpWidth = bp.x;
                this.tmpHeight = bp.y;
            }
            if (this.getWidth() > 0.0 && this.getHeight() > 0.0) {
                double w2 = this.getWidth();
                double h2 = this.getHeight();
                if (this.isLayoutByRow() || w2 > this.tmpWidth) {
                    this.tmpWidth = w2;
                }
                if (!this.isLayoutByRow() || h2 > this.tmpHeight) {
                    this.tmpHeight = h2;
                }
            }
            if (this.getWidth() > 2.0 && this.tmpWidth > (w = this.getWidth())) {
                this.tmpWidth = w;
            }
            if (this.getHeight() > 2.0 && this.tmpHeight > (h = this.getHeight())) {
                this.tmpHeight = h;
            }
            if (this.style.isBackgroundOn()) {
                this.channel.glLoadName((Object)backgroundDetailType);
                this.channel.glNormal(0.0, 0.0, 1.0);
                double backX = 1.0;
                double backY = 1.0;
                double backWidth = this.tmpWidth - 1.0;
                double backHeight = this.tmpHeight - 2.0;
                if (this.style.getBorderStyle() == 1 || this.style.getBorderStyle() == 2) {
                    backY = this.style.getBorderOffset();
                    backWidth -= this.style.getBorderOffset();
                    backHeight -= this.style.getBorderOffset();
                }
                this.drawBackground(backX, backY, backWidth, backHeight, this.style);
            }
            Color bc = this.findBorderColor();
            Color blc = this.findBorderLineColor();
            this.titleInsets = this.drawTitleBorder(this.channel, this.tmpWidth, this.tmpHeight, titleStr, bc, blc, this.style, true);
            if (this.isTitleVisible()) {
                // empty if block
            }
            if (this.labelCount <= 0) {
                return;
            }
            double usableWidth = this.tmpWidth - (this.titleInsets[2] + this.titleInsets[3]);
            double usableHeight = this.tmpHeight - (this.titleInsets[0] + this.titleInsets[1]);
            if (usableHeight > 0.0 && usableWidth > 0.0) {
                if (this.isContinuous()) {
                    this.renderContinuous();
                } else {
                    this.renderDiscrete();
                }
            }
        }
        finally {
            this.channel.glPopAttrib();
        }
    }

    private double getHorizontalMargin() {
        return this.style.getHorizontalMargin() * this.maxLabelHeight;
    }

    private double getVerticalMargin() {
        return this.style.getVerticalMargin() * this.maxLabelHeight;
    }

    private double getContinuousLength() {
        return 5.0 * this.maxLabelHeight;
    }

    private void renderContinuous() throws MissingValueException {
        double usableLength;
        Vec3d delta = new Vec3d();
        Vec3d labelPosition = new Vec3d();
        Vec3d itemPosition = new Vec3d();
        double firstLabelPosition = 0.0;
        double lastLabelPosition = 0.0;
        TextStyle labelStyle = new TextStyle(this.style.getLabelStyle());
        Color edgeColor = this.style.getMarkerEdgeColor();
        if (edgeColor == null) {
            edgeColor = this.style.getLabelStyle().getColor();
        }
        double usableWidth = this.tmpWidth - (this.titleInsets[2] + this.titleInsets[3]);
        double usableHeight = this.tmpHeight - (this.titleInsets[0] + this.titleInsets[1]);
        delta.x = 0.0;
        delta.y = 0.0;
        delta.z = 0.0;
        labelPosition.z = 0.0;
        itemPosition.z = 0.0;
        labelStyle.setHorizontalJustification(0);
        labelStyle.setVerticalJustification(1);
        this.applyTextStyle(labelStyle);
        this.markerWidth = this.channel.glGetTextHeight();
        this.markerWidth *= this.style.getContinuousColorBarThickness();
        this.markerHeight = this.markerWidth;
        if (this.isLayoutByRow()) {
            itemPosition.x = 0.0;
            usableWidth -= this.getHorizontalMargin() * 2.0;
            if (this.getLabelingMethod() != 0) {
                usableWidth -= this.labelLength[0] + this.labelLength[this.labelLength.length - 1] + this.labelMargin * 2.0;
            }
            this.markerWidth = delta.x = usableWidth / (double)this.rangeCount;
            itemPosition.y = labelPosition.y = this.titleInsets[1] + usableHeight / 2.0;
            firstLabelPosition = this.titleInsets[2] + this.getHorizontalMargin();
            itemPosition.x += firstLabelPosition + this.labelLength[0] + this.labelMargin;
            lastLabelPosition = firstLabelPosition + this.labelLength[0] + this.labelMargin + (double)this.rangeCount * this.markerWidth + this.labelMargin;
            usableLength = usableWidth;
        } else {
            this.markerHeight = delta.y = (usableHeight -= this.getVerticalMargin() * 2.0) / (double)this.rangeCount;
            itemPosition.y = this.titleInsets[1] + this.getVerticalMargin();
            double labelWidth = this.markerWidth + this.labelMargin + this.maxLabelLength;
            itemPosition.x = this.titleInsets[2] + this.markerWidth / 2.0;
            if (this.getLabelingMethod() != 0) {
                itemPosition.x += (usableWidth - labelWidth - this.labelMargin) / 2.0;
            }
            labelPosition.x = itemPosition.x + this.markerWidth / 2.0 + this.labelMargin;
            labelPosition.y = itemPosition.y;
            firstLabelPosition = lastLabelPosition = labelPosition.x;
            usableLength = usableHeight;
        }
        this.renderContinuousItems(itemPosition, usableLength);
        if (this.getLabelingMethod() != 0) {
            this.renderContinuousLables(labelPosition, delta, firstLabelPosition, lastLabelPosition, labelStyle);
        }
        this.renderContinuousEdge(itemPosition, usableLength);
    }

    private void buildColorPercentageList() {
        ColorRampEntry entry;
        boolean useColorPlacementPercentages;
        this.colorPercentageList.clear();
        boolean bl = useColorPlacementPercentages = this.colorPlacementPercentageCount > 0 && this.colorPlacementPercentageCount == this.labelCount;
        if (useColorPlacementPercentages) {
            for (int i = 0; i < this.labelCount; ++i) {
                try {
                    entry = new ColorRampEntry();
                    entry.color = this.colors.getValue(i);
                    entry.percentage = this.colorPlacementPercentages.getValue(i);
                    if (entry.percentage < 0.0 || entry.percentage > 1.0) {
                        throw new IllegalStateException("Legend: colorPlacementPercentage values must be between 0 and 1.");
                    }
                    this.colorPercentageList.add(entry);
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
                Collections.sort(this.colorPercentageList, this.colorRampEntryComparator);
            }
        } else {
            double percentageIncrement = this.smoothShading ? 1.0 / (double)(this.labelCount - 1) : 1.0 / (double)this.labelCount;
            int n = this.labelCount == -1 ? 1 : this.labelCount;
            n = this.labelCount;
            for (int i = 0; i < n; ++i) {
                try {
                    Color c = this.colors.getValue(i);
                    entry = new ColorRampEntry();
                    entry.color = c;
                    entry.percentage = this.smoothShading ? (double)i * percentageIncrement : (double)((i + 1) % (this.labelCount + 1)) * percentageIncrement;
                    this.colorPercentageList.add(entry);
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
        }
        if (this.colorPercentageList.size() >= 1) {
            entry = (ColorRampEntry)this.colorPercentageList.get(0);
            if (entry.percentage > 0.0) {
                ColorRampEntry newEntry = new ColorRampEntry();
                newEntry.percentage = 0.0;
                newEntry.color = entry.color;
                this.colorPercentageList.add(0, newEntry);
            }
            entry = (ColorRampEntry)this.colorPercentageList.get(this.colorPercentageList.size() - 1);
            if (entry.percentage < 1.0) {
                ColorRampEntry newEntry = new ColorRampEntry();
                newEntry.percentage = 1.0;
                newEntry.color = entry.color;
                this.colorPercentageList.add(newEntry);
            }
        }
    }

    private void renderContinuousItems(Vec3d firstItemPosition, double usableLength) throws MissingValueException {
        if (this.smoothShading) {
            this.renderContinuousSmoothItems(firstItemPosition, usableLength);
        } else {
            this.renderContinuousNotSmoothItems(firstItemPosition, usableLength);
        }
    }

    private void renderContinuousNotSmoothItems(Vec3d firstItemPosition, double usableLength) throws MissingValueException {
        boolean isHorizontal = this.isLayoutByRow();
        double x = firstItemPosition.x;
        double y = firstItemPosition.y;
        double w = this.markerWidth;
        double h = this.markerHeight;
        for (int i = 0; i < this.colorPercentageList.size() - 1; ++i) {
            this.channel.glLoadName((Object)new Integer(i));
            this.channel.glPushName((Object)labelMarkerDetailType);
            ColorRampEntry e1 = (ColorRampEntry)this.colorPercentageList.get(i);
            ColorRampEntry e2 = (ColorRampEntry)this.colorPercentageList.get(i + 1);
            double p1 = e1.percentage;
            double p2 = e2.percentage;
            if (isHorizontal) {
                w = (p2 - p1) * usableLength;
                x = firstItemPosition.x + p1 * usableLength + w / 2.0;
            } else {
                h = (p2 - p1) * usableLength;
                y = firstItemPosition.y + p1 * usableLength + h / 2.0;
            }
            this.drawItem(x, y, w, h, e2.color, e2.color);
            this.channel.glPopName();
        }
    }

    private void renderContinuousSmoothItems(Vec3d firstItemPosition, double usableLength) throws MissingValueException {
        ColorRampEntry e1;
        boolean isHorizontal = this.isLayoutByRow();
        double[] breaks = new double[this.colorPercentageList.size()];
        double first = isHorizontal ? firstItemPosition.x : firstItemPosition.y;
        for (int i = 0; i < this.colorPercentageList.size(); ++i) {
            e1 = (ColorRampEntry)this.colorPercentageList.get(i);
            breaks[i] = Math.round(first + e1.percentage * usableLength);
        }
        for (int i = 0; i < this.colorPercentageList.size() - 1; ++i) {
            double offset;
            Color c2;
            this.channel.glLoadName((Object)new Integer(i));
            this.channel.glPushName((Object)labelMarkerDetailType);
            e1 = (ColorRampEntry)this.colorPercentageList.get(i);
            ColorRampEntry e2 = (ColorRampEntry)this.colorPercentageList.get(i + 1);
            Color c1 = c2 = e2.color;
            if (this.smoothShading) {
                c1 = e1.color;
            }
            double d = offset = this.SVGRender ? 0.0 : 0.6;
            if (isHorizontal) {
                this.drawSmoothItem(breaks[i], firstItemPosition.y - this.markerHeight / 2.0, breaks[i + 1] - offset, firstItemPosition.y + this.markerHeight / 2.0, c1, c2);
            } else {
                this.drawSmoothItem(firstItemPosition.x - this.markerWidth / 2.0, breaks[i], firstItemPosition.x + this.markerWidth / 2.0, breaks[i + 1] - offset, c2, c1);
            }
            this.channel.glPopName();
        }
    }

    private void renderContinuousLables(Vec3d labelPosition, Vec3d delta, double firstLabelPosition, double lastLabelPosition, TextStyle labelStyle) {
        for (int i = 0; i < this.labelCount; ++i) {
            this.channel.glLoadName((Object)new Integer(i));
            if (!this.style.isLabelsOn()) continue;
            double currentLabelXPosition = 0.0;
            double currentLabelYPosition = 0.0;
            if (this.isLayoutByRow()) {
                currentLabelYPosition = labelPosition.y - this.markerHeight * this.style.getContinuousColorBarThickness();
                if (i == 0) {
                    currentLabelXPosition = firstLabelPosition;
                    if (this.rangeCount == 1 || this.getLabelingMethod() == 2) {
                        currentLabelYPosition += this.labelHeight[0] / 2.0 + this.markerHeight / 2.0;
                    }
                } else if (i == this.labelCount - 1) {
                    currentLabelXPosition = lastLabelPosition;
                    if (this.rangeCount == 1 || this.getLabelingMethod() == 2) {
                        currentLabelYPosition += this.labelHeight[i] / 2.0 + this.markerHeight / 2.0;
                    }
                } else if (this.getLabelingMethod() == 1) {
                    currentLabelXPosition = labelPosition.x + this.labelLength[i] / 2.0;
                    if (this.rangeCount == 1 || this.getLabelingMethod() == 2) {
                        currentLabelYPosition -= this.markerHeight;
                    }
                }
            } else if (i == 0) {
                currentLabelXPosition = firstLabelPosition;
                currentLabelYPosition = labelPosition.y + this.labelHeight[0] / 2.0 - this.markerHeight / 2.0;
            } else if (i == this.labelCount - 1) {
                currentLabelXPosition = labelPosition.x;
                currentLabelYPosition = labelPosition.y - this.markerHeight / 2.0 - this.labelHeight[i] / 2.0;
            } else if (this.getLabelingMethod() == 1) {
                currentLabelXPosition = labelPosition.x;
                currentLabelYPosition = labelPosition.y - this.markerHeight / 2.0;
            }
            if (i == 0 || i == this.labelCount - 1 || this.getLabelingMethod() == 1) {
                this.drawLabel(this.labelArray[i], currentLabelXPosition, currentLabelYPosition, labelStyle, i);
            }
            labelPosition.add(delta);
        }
    }

    private void renderContinuousEdge(Vec3d itemPosition, double usableLength) {
        double ymax;
        double xmax;
        double ymin;
        double xmin;
        Color edgeColor = this.style.getMarkerEdgeColor();
        if (edgeColor == null) {
            edgeColor = this.style.getLabelStyle().getColor();
        }
        if (edgeColor == null) {
            return;
        }
        if (this.isLayoutByRow()) {
            xmin = itemPosition.x;
            ymin = itemPosition.y - this.markerHeight / 2.0;
            xmax = xmin + usableLength;
            ymax = ymin + this.markerHeight;
        } else {
            xmin = itemPosition.x - this.markerWidth / 2.0;
            ymin = itemPosition.y;
            ymax = ymin + usableLength;
            xmax = xmin + this.markerWidth;
        }
        float lw = this.style.getContinuousEdgeStyle().getWidth();
        this.channel.glLineWidth(lw);
        double ewOffset = Math.ceil((double)lw / 2.0) - 1.0;
        if (this.style.isContinuousEdgeColorLinkedToLabelColor()) {
            this.channel.glColor(edgeColor);
        } else {
            this.channel.glColor(this.style.getContinuousEdgeStyle().getColor());
        }
        this.channel.glPolygonMode(2);
        this.channel.glRect(xmin + ewOffset, ymin + ewOffset, xmax - ewOffset, ymax - ewOffset);
    }

    private double computeLeftmostMarkerCenterX(double[] titleInsets) {
        return titleInsets[2] + this.markerWidth / 2.0 + (this.getWidth() - this.computeMarkersLabelsWidth()) / 2.0;
    }

    private void renderDiscrete() throws MissingValueException {
        double ilp;
        double iip;
        Vec3d delta = new Vec3d();
        Vec3d labelPosition = new Vec3d();
        Vec3d markerPosition = new Vec3d();
        TextStyle labelStyle = new TextStyle(this.style.getLabelStyle());
        Color edgeColor = this.style.getMarkerEdgeColor();
        if (edgeColor == null) {
            edgeColor = this.style.getLabelStyle().getColor();
        }
        delta.x = 0.0;
        delta.y = 0.0;
        delta.z = 0.0;
        labelPosition.z = 0.0;
        markerPosition.z = 0.0;
        labelStyle.setHorizontalJustification(0);
        labelStyle.setVerticalJustification(1);
        labelStyle.setFont(this.currentLabelFont);
        this.applyTextStyle(labelStyle);
        markerPosition.y = this.usableHeight - (double)this.rowCount * (this.maxLabelHeight + (this.rowCount == 1 ? 0.0 : this.labelMargin));
        markerPosition.y = markerPosition.y < 0.0 ? 0.0 : (markerPosition.y /= (double)(this.rowCount + 1));
        markerPosition.x = this.computeLeftmostMarkerCenterX(this.titleInsets);
        delta.x = this.markerWidth;
        delta.y = -1.0 * (markerPosition.y + this.markerHeight + this.labelMargin);
        delta.y = -1.0 * (this.markerHeight + this.labelMargin);
        markerPosition.y = this.tmpHeight - this.titleInsets[0] - this.markerHeight / 2.0 - this.getVerticalMargin();
        labelPosition.x = markerPosition.x + this.markerWidth / 2.0 + this.labelMargin;
        labelPosition.y = markerPosition.y;
        if (this.isLayoutByRow()) {
            iip = markerPosition.x;
            ilp = labelPosition.x;
        } else {
            iip = markerPosition.y;
            ilp = labelPosition.y;
        }
        int count = 0;
        for (int i = 0; i < this.labelCount; ++i) {
            this.channel.glLoadName((Object)new Integer(i));
            this.channel.glPushName((Object)labelMarkerDetailType);
            this.drawItem(markerPosition.x, markerPosition.y, this.markerWidth, this.markerHeight, this.colors.getValue(i), edgeColor, this.markerTypes.getValue(i));
            this.channel.glAlignment(0, 1);
            if (this.style.isLabelsOn()) {
                this.channel.glLoadName((Object)labelDetailType);
                this.drawLabel(this.labelArray[i], labelPosition.x, labelPosition.y, labelStyle, i);
                if (this.isLayoutByRow()) {
                    if ((i + 1) % this.columnCount == 0) {
                        markerPosition.x = iip;
                        markerPosition.y += delta.y;
                        labelPosition.x = ilp;
                        labelPosition.y += delta.y;
                    } else {
                        markerPosition.x += delta.x + this.markerWidth + this.labelMargin + this.maxColumnLabelLength[i % this.columnCount];
                        labelPosition.x += delta.x + this.markerWidth + this.labelMargin + this.maxColumnLabelLength[i % this.columnCount];
                    }
                } else if ((i + 1) % this.rowCount == 0) {
                    markerPosition.x += delta.x + this.markerWidth + this.labelMargin + this.maxColumnLabelLength[count];
                    markerPosition.y = iip;
                    labelPosition.x += delta.x + this.markerWidth + this.labelMargin + this.maxColumnLabelLength[count];
                    labelPosition.y = ilp;
                    ++count;
                } else {
                    markerPosition.y += delta.y;
                    labelPosition.y += delta.y;
                }
            }
            this.channel.glPopName();
        }
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) {
        Vec3d size = bBoxAction.pt1;
        Vec3d center = bBoxAction.pt2;
        BoundingBox box = bBoxAction.getElementBoundingBox();
        this.channel = (Channel)bBoxAction.getGraphicsContext();
        Vec3d pSize = this.getPreferredSize(this.channel, bBoxAction.getValueIndex(), false);
        size.set(pSize.x, pSize.y, 0.0);
        center.set(pSize.x / 2.0, pSize.y / 2.0, 0.0);
        box.union(center, size);
    }

    public Vec3d getPreferredSize(Channel channel, int index) {
        return this.getPreferredSize(channel, index, true);
    }

    protected Vec3d getPreferredSize(Channel channel, int index, boolean initLegend) {
        Vec3d p;
        if (initLegend) {
            this.init(new InitAction(channel));
        }
        if (this.isTitleVisible()) {
            String titleStr;
            try {
                titleStr = this.title.getValue(index);
            }
            catch (MissingValueException mve) {
                titleStr = new String();
            }
            p = this.addTitleDimensions(channel, titleStr, this.tmpWidth, this.tmpHeight, this.style);
            if (this.style.isBorderOn()) {
                Vec3d bp = this.addBorderDimensions(p.x, p.y, this.style);
                p.x = bp.x;
                p.y = bp.y;
            }
            if (this.tmpWidth - 1.0 <= this.getWidth() && p.x > this.getWidth() && p.x > this.getWidth()) {
                p.x = this.getWidth();
            }
            if (this.tmpHeight <= this.getHeight() && p.y > this.getHeight()) {
                p.y = this.getHeight();
            }
        } else {
            p = this.style.isBorderOn() ? this.addBorderDimensions(this.tmpWidth, this.tmpHeight, this.style) : new Vec3d(this.tmpWidth, this.tmpHeight, 0.0);
        }
        return p;
    }

    Vec3d addBorderDimensions(double width, double height, LegendStyle legendStyle) {
        if (legendStyle.isBorderOn()) {
            if (legendStyle.getBorderStyle() != 0) {
                double borderOffset = legendStyle.getBorderOffset();
                width += borderOffset;
                height += borderOffset;
            } else {
                double borderLineWidth = legendStyle.getBorderLineWidth();
                width += borderLineWidth * 2.0;
                height += borderLineWidth * 2.0;
            }
        }
        return new Vec3d(width, height, 0.0);
    }

    Vec3d addTitleDimensions(Channel channel, String title, double width, double height, LegendStyle legendStyle) {
        if (this.isTitleVisible()) {
            TextStyle titleStyle = legendStyle.getTitleStyle();
            this.applyTextStyle(titleStyle);
            double titleHeight = channel.glGetTextHeight(title);
            double titleWidth = channel.glGetTextWidth(title);
            double minTitleWidth = 0.0;
            double minTitleHeight = 0.0;
            int position = this.style.getTitlePosition();
            int hj = titleStyle.getHorizontalJustification();
            double titleOffset = titleHeight;
            switch (position) {
                case 0: 
                case 1: {
                    minTitleWidth = titleWidth + 4.0 * this.titleMargin;
                    minTitleHeight = titleHeight + 2.0 * this.labelMargin;
                    height += 2.0 * this.labelMargin + titleOffset;
                    break;
                }
                case 2: {
                    if (hj == 0 || hj == 2) {
                        minTitleWidth = titleHeight + 2.0 * this.labelMargin;
                        minTitleHeight = titleWidth + 4.0 * this.titleMargin;
                        width += 2.0 * this.labelMargin + titleOffset;
                        break;
                    }
                    minTitleWidth = titleWidth + 4.0 * this.titleMargin;
                    minTitleHeight = titleHeight + 2.0 * this.labelMargin;
                    height += 2.0 * this.labelMargin + titleOffset;
                }
            }
            height = Math.max(height, minTitleHeight);
            width = Math.max(width, minTitleWidth);
            if (this.style.isTitleMarkerVisible()) {
                width += (double)this.style.getTitleMarkerSize() + this.style.getTitleMarkerSpace();
                height = Math.max(height, (double)this.style.getTitleMarkerSize());
            }
        }
        return new Vec3d(width, height, 0.0);
    }

    @Override
    protected void setLabelStyle(TextStyle labelStyle) {
        this.applyTextStyle(labelStyle);
    }

    private void applyTextStyle(TextStyle textStyle) {
        this.channel.glSelect2DFont(textStyle.getFont());
        this.channel.glAlignment(textStyle.getHorizontalJustification(), textStyle.getVerticalJustification());
        this.channel.setShadowOffset(textStyle.getShadowOffsetX(), textStyle.getShadowOffsetY());
        if (textStyle.isShadowOn()) {
            this.channel.glEnable(11);
        } else {
            this.channel.glDisable(11);
        }
    }

    @Override
    protected void drawLabel(String label, double x, double y, TextStyle labelStyle, int index) {
        if (labelStyle.isShadowOn()) {
            this.channel.glEnable(11);
            this.channel.setShadowColor(labelStyle.getShadowColor());
            this.channel.setShadowOffset(labelStyle.getShadowOffsetX(), labelStyle.getShadowOffsetY());
            this.channel.setShadowSoftness(labelStyle.getShadowSoftness());
        }
        this.channel.glColor(labelStyle.getColor());
        Color rasterBackground = this.channel.getRasterBackgroundColor();
        this.channel.setRasterBackgroundColor(labelStyle.getBackgroundColor());
        this.channel.gl2DText(label, x, y, 0.0);
        this.channel.glDisable(11);
        this.channel.setRasterBackgroundColor(rasterBackground);
    }

    protected void drawSmoothItem(double x1, double y1, double x2, double y2, Color startColor, Color endColor) {
        this.channel.glPolygonMode(3);
        if (startColor == endColor) {
            this.channel.glColor(endColor);
            this.channel.glRect(x1, y1, x2, y2);
        } else {
            int grad = this.isLayoutByRow() ? 0 : 1;
            this.channel.glRect(x1, y1, startColor, 1.0f, x2, y2, endColor, 1.0f, grad);
        }
    }

    @Override
    protected void drawItem(double centerX, double centerY, double sizeX, double sizeY, Color startColor, Color endColor) {
        this.channel.glPolygonMode(3);
        this.channel.glLineWidth(1.0f);
        this.channel.glNormal(0.0, 0.0, 1.0);
        this.channel.glBegin(2);
        if (this.isLayoutByRow()) {
            this.channel.glRect(centerX - sizeX / 2.0, centerY - sizeY / 2.0, startColor, 1.0f, centerX + sizeX / 2.0, centerY + sizeY / 2.0, endColor, 1.0f, 0);
        } else {
            this.channel.glRect(centerX - sizeX / 2.0, centerY + sizeY / 2.0, endColor, 1.0f, centerX + sizeX / 2.0, centerY - sizeY / 2.0, startColor, 1.0f, 1);
        }
        this.channel.glEnd();
    }

    @Override
    protected void drawItem(double centerX, double centerY, double sizeX, double sizeY, Color color, Color edgeColor, int markerType) {
        this.channel.glColor(color);
        this.channel.glLineWidth(1.0f);
        if (markerType != -1) {
            this.channel.setMarkerType(markerType);
            this.channel.setMarkerSize((int)(sizeX / this.pixelWidth));
            if (edgeColor != null) {
                this.channel.glEdgeColor(edgeColor);
            } else {
                this.channel.glEdgeColor(Color.black);
            }
            if (this.skinFactory != null) {
                this.channel.setMarkerskin(this.skinFactory.getSkinImage(markerType));
            } else {
                this.channel.setMarkerskin(null);
            }
            this.channel.glBegin(4);
            this.channel.glVertex(centerX, centerY);
            this.channel.glEnd();
        } else {
            if (edgeColor != null && !this.isContinuous()) {
                this.channel.glPolygonMode(4);
                this.channel.glEdgeColor(edgeColor);
            } else {
                this.channel.glPolygonMode(3);
            }
            this.channel.glNormal(0.0, 0.0, 1.0);
            this.channel.glBegin(2);
            this.channel.glVertex(centerX - sizeX / 2.0, centerY - sizeY / 2.0);
            this.channel.glVertex(centerX + sizeX / 2.0, centerY - sizeY / 2.0);
            this.channel.glVertex(centerX + sizeX / 2.0, centerY + sizeY / 2.0);
            this.channel.glVertex(centerX - sizeX / 2.0, centerY + sizeY / 2.0);
            this.channel.glEnd();
            this.drawSkinFromFactory(centerX, centerY, 0.0, markerType);
        }
    }

    protected double[] drawTitleBorder(Channel channel, double sizeX, double sizeY, String title, Color borderClr, Color borderLineClr, LegendStyle legendStyle, boolean draw) {
        double[] inset = new double[4];
        double[] borderInsets = new double[4];
        inset[3] = 0.0;
        inset[2] = 0.0;
        inset[1] = 0.0;
        inset[0] = 0.0;
        borderInsets[3] = 0.0;
        borderInsets[2] = 0.0;
        borderInsets[1] = 0.0;
        borderInsets[0] = 0.0;
        if (this.style.isBorderOn()) {
            if (legendStyle.getBorderStyle() == 0) {
                inset[2] = inset[3] = (double)this.style.getBorderLineWidth();
                inset[1] = inset[3];
                inset[0] = inset[3];
                borderInsets[2] = borderInsets[3] = (double)this.style.getBorderLineWidth();
                borderInsets[1] = borderInsets[3];
                borderInsets[0] = borderInsets[3];
            } else {
                double offset = legendStyle.getBorderOffset();
                switch (legendStyle.getBorderVerticalJustification()) {
                    default: {
                        inset[1] = inset[1] + offset;
                        borderInsets[1] = borderInsets[1] + offset;
                        break;
                    }
                    case 0: {
                        inset[0] = inset[0] + offset;
                        borderInsets[0] = borderInsets[0] + offset;
                    }
                }
                switch (legendStyle.getBorderHorizontalJustification()) {
                    default: {
                        inset[2] = inset[2] + offset;
                        borderInsets[2] = borderInsets[2] + offset;
                        break;
                    }
                    case 2: {
                        inset[3] = inset[3] + offset;
                        borderInsets[3] = borderInsets[3] + offset;
                    }
                }
            }
            if (draw) {
                channel.glLoadName((Object)backgroundDetailType);
                if (legendStyle.getBorderStyle() == 0) {
                    float lw = this.style.getBorderLineWidth();
                    channel.glLineWidth(lw);
                    channel.glColor(borderLineClr);
                    channel.glPolygonMode(2);
                    double llx = borderInsets[2] / 2.0;
                    double lly = borderInsets[0] / 2.0;
                    double urx = this.getWidth() - borderInsets[3] / 2.0;
                    if (lw > 0.0f && lw % 2.0f == 0.0f) {
                        urx += 1.0;
                    }
                    double ury = sizeY - borderInsets[1] / 2.0;
                    channel.glBegin(2);
                    channel.glVertex(llx, lly);
                    channel.glVertex(llx, ury);
                    channel.glVertex(urx, ury);
                    channel.glVertex(urx, lly);
                    channel.glEnd();
                } else {
                    if (legendStyle.getBorderStyle() == 1) {
                        this.drawBlock(channel, borderInsets, legendStyle.getBorderOffset(), sizeX, sizeY, borderClr, borderLineClr, legendStyle);
                    } else {
                        this.drawShadow(channel, borderInsets, legendStyle.getShadowOffsetX(), legendStyle.getShadowOffsetY(), sizeX, sizeY, borderClr, legendStyle);
                    }
                    channel.glLineWidth(1.0f);
                    channel.glColor(borderLineClr);
                    channel.glPolygonMode(2);
                    channel.glBegin(2);
                    channel.glVertex(borderInsets[2], borderInsets[1]);
                    channel.glVertex(sizeX - borderInsets[3], borderInsets[1]);
                    channel.glVertex(sizeX - borderInsets[3], sizeY - borderInsets[0]);
                    channel.glVertex(borderInsets[2], sizeY - borderInsets[0]);
                    channel.glEnd();
                }
            }
        }
        if (this.isTitleVisible()) {
            double x;
            double titleWidth;
            int hj = this.style.getTitleStyle().getHorizontalJustification();
            TextStyle titleStyle = legendStyle.getTitleStyle();
            this.applyTextStyle(titleStyle);
            double titleHeight = channel.glGetTextHeight();
            double widthIncludingMarker = titleWidth = channel.glGetTextWidth(title);
            double heightIncludingMarker = titleHeight;
            if (this.style.isTitleMarkerVisible()) {
                widthIncludingMarker += (double)this.style.getTitleMarkerSize() + this.style.getTitleMarkerSpace();
                heightIncludingMarker = Math.max((double)this.style.getTitleMarkerSize(), titleHeight);
            }
            if (draw && widthIncludingMarker >= this.getWidth()) {
                title = this.truncateTitle(title, this.getWidth());
                widthIncludingMarker = channel.glGetTextWidth(title);
                if (this.style.isTitleMarkerVisible()) {
                    widthIncludingMarker += (double)this.style.getTitleMarkerSize() + this.style.getTitleMarkerSpace();
                }
            }
            if (titleStyle.isShadowOn() && draw) {
                channel.glEnable(11);
                channel.setShadowColor(titleStyle.getShadowColor());
                channel.setShadowOffset(titleStyle.getShadowOffsetX(), titleStyle.getShadowOffsetY());
                channel.setShadowSoftness(titleStyle.getShadowSoftness());
            }
            switch (hj) {
                case 0: {
                    if (this.isContinuous()) {
                        x = borderInsets[2] + this.titleMargin;
                        break;
                    }
                    x = this.computeLeftmostMarkerCenterX(inset) - this.markerWidth / 2.0;
                    if (!(x + widthIncludingMarker > this.getWidth())) break;
                    x = this.getWidth() / 2.0 - widthIncludingMarker / 2.0;
                    break;
                }
                case 2: {
                    x = sizeX - (borderInsets[3] + widthIncludingMarker);
                    break;
                }
                default: {
                    x = this.getWidth() / 2.0 - widthIncludingMarker / 2.0;
                }
            }
            double y = sizeY - (inset[0] + this.titleMargin + heightIncludingMarker / 2.0);
            inset[0] = inset[0] + (this.titleMargin + heightIncludingMarker);
            borderInsets[0] = borderInsets[0] + (this.titleMargin + heightIncludingMarker);
            if (this.style.isTitleMarkerVisible()) {
                if (draw) {
                    channel.glLoadName((Object)titleMarkerDetailType);
                    channel.setMarkerType(this.style.getTitleMarkerId());
                    channel.setMarkerSize(this.style.getTitleMarkerSize());
                    channel.glBegin(4);
                    channel.glVertex(x += (double)this.style.getTitleMarkerSize() / 2.0, y);
                    channel.glEnd();
                }
                x += (double)this.style.getTitleMarkerSize() / 2.0 + this.style.getTitleMarkerSpace();
            }
            Color rasterBackground = channel.getRasterBackgroundColor();
            channel.setRasterBackgroundColor(this.style.getTitleStyle().getBackgroundColor());
            if (draw) {
                channel.glLoadName((Object)titleDetailType);
                channel.glColor(titleStyle.getColor());
                channel.glTextAlign(0, 1);
                channel.gl2DText(title, x, y, 0.0);
            }
            channel.setRasterBackgroundColor(rasterBackground);
            channel.glDisable(11);
        }
        return inset;
    }

    private String truncateTitle(String displayTitle, double w) {
        if (w <= 0.0) {
            displayTitle = "";
        } else if (displayTitle.length() > 3) {
            double titleWidth;
            StringBuffer sb = new StringBuffer(displayTitle);
            sb.append("...");
            do {
                sb.delete(sb.length() - 4, sb.length());
                sb.append("...");
                displayTitle = sb.toString();
                titleWidth = this.channel.glGetTextWidth(displayTitle);
                if (!this.style.isTitleMarkerVisible()) continue;
                titleWidth += (double)this.style.getTitleMarkerSize() + this.style.getTitleMarkerSpace();
            } while (titleWidth > w && displayTitle.length() > 3);
        }
        return displayTitle;
    }

    double[] getTitleBorderInsets(Channel channel, String title, LegendStyle legendStyle) {
        double[] i = this.drawTitleBorder(channel, this.tmpWidth, this.tmpHeight, title, Color.black, Color.black, legendStyle, false);
        return i;
    }

    private void drawBlock(Channel channel, double[] insets, double offset, double sizeX, double sizeY, Color borderClr, Color edgeClr, LegendStyle legendStyle) {
        int vj = legendStyle.getBorderVerticalJustification();
        int hj = legendStyle.getBorderHorizontalJustification();
        channel.glPushAttrib(0);
        channel.glPolygonMode(4);
        channel.glColor(borderClr);
        channel.glEdgeColor(edgeClr);
        block0 : switch (vj) {
            default: {
                switch (hj) {
                    default: {
                        channel.glBegin(2);
                        channel.glVertex(insets[2] - offset, insets[1] - offset);
                        channel.glVertex(sizeX - insets[3] - offset, insets[1] - offset);
                        channel.glVertex(sizeX - insets[3], insets[1]);
                        channel.glVertex(insets[2] - offset, insets[1]);
                        channel.glEnd();
                        channel.glBegin(2);
                        channel.glVertex(insets[2], insets[1]);
                        channel.glVertex(insets[2], sizeY - insets[0]);
                        channel.glVertex(insets[2] - offset, sizeY - insets[0] - offset);
                        channel.glVertex(insets[2] - offset, insets[1] - offset);
                        channel.glEnd();
                        break block0;
                    }
                    case 2: 
                }
                channel.glBegin(2);
                channel.glVertex(insets[2], insets[1]);
                channel.glVertex(insets[2] + offset, insets[1] - offset);
                channel.glVertex(sizeX - insets[3] + offset, insets[1] - offset);
                channel.glVertex(sizeX - insets[3], insets[1]);
                channel.glEnd();
                channel.glBegin(2);
                channel.glVertex(sizeX - insets[3], insets[1]);
                channel.glVertex(sizeX - insets[3] + offset, insets[1] - offset);
                channel.glVertex(sizeX - insets[3] + offset, sizeY - insets[0] - offset);
                channel.glVertex(sizeX - insets[3], sizeY - insets[0]);
                channel.glEnd();
                break;
            }
            case 0: {
                switch (hj) {
                    default: {
                        channel.glBegin(2);
                        channel.glVertex(insets[2], sizeY - insets[0]);
                        channel.glVertex(sizeX - insets[3], sizeY - insets[0]);
                        channel.glVertex(sizeX - insets[3] - offset, sizeY - insets[0] + offset);
                        channel.glVertex(insets[2] - offset, sizeY - insets[0] + offset);
                        channel.glEnd();
                        channel.glBegin(2);
                        channel.glVertex(insets[2] - offset, sizeY - insets[0] + offset);
                        channel.glVertex(insets[2] - offset, insets[1] + offset);
                        channel.glVertex(insets[2], insets[1]);
                        channel.glVertex(insets[2], sizeY - insets[0]);
                        channel.glEnd();
                        break block0;
                    }
                    case 2: 
                }
                channel.glBegin(2);
                channel.glVertex(sizeX - insets[3], sizeY - insets[0]);
                channel.glVertex(sizeX - insets[3], insets[1]);
                channel.glVertex(sizeX - insets[3] + offset, insets[1] + offset);
                channel.glVertex(sizeX - insets[3] + offset, sizeY - insets[0] + offset);
                channel.glEnd();
                channel.glBegin(2);
                channel.glVertex(sizeX - insets[3] + offset, sizeY - insets[0] + offset);
                channel.glVertex(insets[2] + offset, sizeY - insets[0] + offset);
                channel.glVertex(insets[2], sizeY - insets[0]);
                channel.glVertex(sizeX - insets[3], sizeY - insets[0]);
                channel.glEnd();
            }
        }
        channel.glPopAttrib();
    }

    private void drawShadow(Channel channel, double[] insets, double offsetx, double offsety, double sizeX, double sizeY, Color color, LegendStyle legendStyle) {
        int vj = legendStyle.getBorderVerticalJustification();
        int hj = legendStyle.getBorderHorizontalJustification();
        channel.glColor(color);
        block0 : switch (vj) {
            default: {
                switch (hj) {
                    default: {
                        channel.glBegin(2);
                        channel.glVertex(insets[2] - offsetx, insets[1] - offsety);
                        channel.glVertex(sizeX - insets[3] - offsetx, insets[1] - offsety);
                        channel.glVertex(sizeX - insets[3] - offsetx, insets[1]);
                        channel.glVertex(insets[2], insets[1]);
                        channel.glVertex(insets[2], sizeY - insets[0] - offsety);
                        channel.glVertex(insets[2] - offsetx, sizeY - insets[0] - offsety);
                        channel.glEnd();
                        break block0;
                    }
                    case 2: 
                }
                channel.glBegin(2);
                channel.glVertex(insets[2] + offsetx, insets[1]);
                channel.glVertex(insets[2] + offsetx, insets[1] - offsety);
                channel.glVertex(sizeX - insets[3] + offsetx, insets[1] - offsety);
                channel.glVertex(sizeX - insets[3] + offsetx, sizeY - insets[0] - offsety);
                channel.glVertex(sizeX - insets[3], sizeY - insets[0] - offsety);
                channel.glVertex(sizeX - insets[3], insets[1]);
                channel.glEnd();
                break;
            }
            case 0: {
                switch (hj) {
                    default: {
                        channel.glBegin(2);
                        channel.glVertex(insets[2], sizeY - insets[0]);
                        channel.glVertex(sizeX - insets[3] - offsetx, sizeY - insets[0]);
                        channel.glVertex(sizeX - insets[3] - offsetx, sizeY - insets[0] + offsety);
                        channel.glVertex(insets[2] - offsetx, sizeY - insets[0] + offsety);
                        channel.glVertex(insets[2] - offsetx, insets[1] + offsety);
                        channel.glVertex(insets[2], insets[1] + offsety);
                        channel.glEnd();
                        break block0;
                    }
                    case 2: 
                }
                channel.glBegin(2);
                channel.glVertex(sizeX - insets[3], sizeY - insets[0]);
                channel.glVertex(sizeX - insets[3], insets[1] + offsety);
                channel.glVertex(sizeX - insets[3] + offsetx, insets[1] + offsety);
                channel.glVertex(sizeX - insets[3] + offsetx, sizeY - insets[0] + offsety);
                channel.glVertex(insets[2] + offsetx, sizeY - insets[0] + offsety);
                channel.glVertex(insets[2] + offsetx, sizeY - insets[0]);
                channel.glEnd();
            }
        }
    }

    protected void drawBackground(double x, double y, double sizeX, double sizeY, LegendStyle style) {
        this.channel.glColor(style.getBackgroundColor());
        this.channel.glPolygonMode(3);
        double xadjust = 0.0;
        double yadjust = 0.0;
        if (style.isBorderOn() && style.getBorderStyle() == 0) {
            xadjust = yadjust = (double)(style.getBorderLineWidth() / 2.0f);
        }
        this.channel.glRect(x, y, x + sizeX - xadjust, y + sizeY - yadjust);
    }

    private Color findBorderLineColor() {
        Color blc = this.style.getBorderLineColor();
        if (blc == null) {
            blc = this.borderLineColor.getValue();
        }
        return blc;
    }

    private Color findBorderColor() {
        Color blc = this.style.getBorderColor();
        if (blc == null) {
            blc = this.borderColor.getValue();
        }
        return blc;
    }

    @Override
    protected SelectDetail getSelectDetail(Object rawDetail, int startIndex) {
        Stack nameStack = (Stack)rawDetail;
        int entryLength = (Integer)nameStack.elementAt(startIndex);
        int typeIndex = startIndex + entryLength - 1;
        int obsIndex = typeIndex - 1;
        int type = (Integer)nameStack.elementAt(typeIndex);
        int labelIndex = -1;
        switch (type) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 0: 
            case 4: {
                labelIndex = (Integer)nameStack.elementAt(obsIndex);
            }
        }
        LegendDetail legendDetail = new LegendDetail();
        legendDetail.setLabelIndex(labelIndex);
        legendDetail.setType(type);
        return legendDetail;
    }

    public int getLabelCount() {
        InitAction ia = new InitAction(this.channel);
        this.labels.init(ia);
        return ia.getValueCount();
    }

    public void setEndLabelsOnly(boolean b) {
        if (b) {
            this.setLabelingMethod(2);
        } else {
            this.setLabelingMethod(1);
        }
    }

    public boolean isEndLabelsOnly() {
        return this.getLabelingMethod() == 2;
    }

    public boolean isSmoothShading() {
        return this.smoothShading;
    }

    public void setSmoothShading(boolean smoothShading) {
        this.smoothShading = smoothShading;
    }

    public int getLabelFontSize() {
        return this.currentLabelFont.getSize();
    }

    public int getTitleFontSize() {
        return this.currentTitleFont.getSize();
    }

    private boolean isTitleVisible() {
        return this.style.isTitleOn() && this.title.getValue() != null && this.title.getValue().length() > 0;
    }

    protected double getLabelMargin() {
        return this.labelMargin;
    }

    protected double getTitleMargin() {
        return this.titleMargin;
    }

    public AbstractMarkerSkinFactory getSkinFactory() {
        return this.skinFactory;
    }

    public void setSkinFactory(AbstractMarkerSkinFactory skinFactory) {
        this.skinFactory = skinFactory;
    }

    private void drawSkinFromFactory(double x, double y, double z, int markerType) {
        if (this.skinFactory == null) {
            return;
        }
        Image skin = this.skinFactory.getSkinImage(markerType);
        this.drawSkin(x, y, z, markerType, skin);
    }

    private void drawSkin(double x, double y, double z, int markerType, Image skin) {
        boolean isDefaultMarker;
        if (skin == null) {
            return;
        }
        int markerSize = (int)this.markerWidth;
        int edgeThickness = 1;
        if (markerSize < 1) {
            return;
        }
        boolean bl = isDefaultMarker = markerType == -1;
        if (isDefaultMarker) {
            markerSize -= edgeThickness;
        }
        BufferedImage image = null;
        if (this.scaledSkinCache != null && ++markerType < this.scaledSkinCache.length && markerSize < this.scaledSkinCache.length && this.scaledSkinCache[markerSize][markerType] != null && this.scaledSkinCache[markerSize][markerType].get() != null) {
            image = (BufferedImage)this.scaledSkinCache[markerSize][markerType].get();
        } else {
            image = new BufferedImage(markerSize, markerSize, 3);
            Graphics2D imageGraphics = image.createGraphics();
            imageGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            imageGraphics.drawImage(skin, 0, 0, markerSize, markerSize, null);
            if (markerType < this.SKIN_CACHE_LIMIT) {
                if (this.scaledSkinCache == null) {
                    this.scaledSkinCache = new SoftReference[this.SKIN_CACHE_LIMIT][this.SKIN_CACHE_LIMIT];
                }
                this.scaledSkinCache[markerSize][markerType] = new SoftReference<BufferedImage>(image);
            }
        }
        this.channel.glAlignment(1, 1);
        if (isDefaultMarker) {
            this.channel.Image2D((Image)image, x + (double)edgeThickness, y - (double)edgeThickness, z, markerSize, markerSize);
        } else {
            this.channel.Image2D((Image)image, x, y, z, markerSize, markerSize);
        }
    }

    public void setSVGRender(boolean b) {
        this.SVGRender = b;
    }

    private static class ColorRampEntry {
        public double percentage;
        public Color color;

        private ColorRampEntry() {
        }
    }
}

