/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AxisMetrics;
import com.sas.graphics.util.gtk.gl.ColorRampLegend;
import com.sas.graphics.util.gtk.gl.Legend;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public class JLegend
extends JComponent {
    private static final long serialVersionUID = 1L;
    private NetworkRoot networkRoot;
    private Channel channel = new Channel((Component)this, 2);
    private Legend legend;
    private ColorRampLegend colorRampLegend;
    private AxisMetrics metrics;
    private boolean antiAliasingEnabled;

    public JLegend() {
        this.channel.glDisable(4);
        this.channel.glDisable(3);
        this.channel.glDisable(1);
        this.channel.glDisable(5);
        this.channel.setBackbuffer(-1);
        this.networkRoot = new NetworkRoot(this.channel);
        this.setSize(10, 10);
    }

    public void setLegend(Legend legend) {
        if (legend != null) {
            this.legend = legend;
            this.colorRampLegend = null;
            this.networkRoot.removeAllElements();
            this.networkRoot.addElement(legend);
        }
    }

    public void setColorRampLegend(ColorRampLegend colorRampLegend) {
        if (colorRampLegend != null) {
            this.legend = null;
            this.colorRampLegend = colorRampLegend;
            this.networkRoot.removeAllElements();
            this.networkRoot.addElement(colorRampLegend);
        }
    }

    public Legend getLegend() {
        return this.legend;
    }

    public ColorRampLegend getColorRampLegend() {
        return this.colorRampLegend;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.setProjection(x, y, width, height);
        if (this.colorRampLegend != null) {
            Insets insets = this.getInsets();
            int usableWidth = width - insets.left - insets.right;
            int usableHeight = height - insets.top - insets.bottom;
            this.colorRampLegend.setLength(1.0);
            this.metrics = this.getColorRampLegendMetrics();
            double length = this.colorRampLegend.getOrientation() == 1 ? (double)usableWidth : (double)usableHeight;
            this.colorRampLegend.setLength(length -= this.metrics.getLowExtender() + this.metrics.getHighExtender());
        }
    }

    private AxisMetrics getColorRampLegendMetrics() {
        AxisMetrics m = null;
        if (this.colorRampLegend != null) {
            m = this.colorRampLegend.getMetrics(this.channel);
        }
        return m;
    }

    private void setProjection(int x, int y, int width, int height) {
        Insets insets = this.getInsets();
        this.channel.glViewport(width, height, insets);
        this.channel.glOrtho(0.375, (double)(width - (insets.left + insets.right)) + 0.375, 0.375, (double)(height - (insets.top + insets.bottom)) + 0.375, 1000.0, -1000.0);
    }

    private void setSafeProjection() {
        this.channel.glViewport(0, 0, 50, 50);
        this.channel.glOrtho(0.0, 50.0, 0.0, 50.0, 1000.0, -1000.0);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.channel.setSingleBufferGraphics(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.antiAliasingEnabled) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.channel.glEnable(13);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            this.channel.glDisable(13);
        }
        if (this.legend != null || this.colorRampLegend != null) {
            Insets insets = this.getInsets();
            if (this.legend != null) {
                this.legend.setWidth(this.getSize().width - insets.left - insets.right);
                this.legend.setHeight(this.getSize().height - insets.top - insets.bottom);
                this.legend.transform.translateX.setValue(0.0);
                this.legend.transform.translateY.setValue(1.0);
            } else {
                if (this.isOpaque()) {
                    Dimension d = this.getSize();
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, d.width, d.height);
                }
                this.metrics = this.colorRampLegend.getMetrics(this.channel);
                if (this.metrics != null) {
                    if (this.colorRampLegend.getStyle().getOrientation() == 1) {
                        this.colorRampLegend.transform.translateX.setValue(this.metrics.getLowExtender());
                        this.colorRampLegend.transform.translateY.setValue(1.0);
                    } else {
                        this.colorRampLegend.transform.translateX.setValue(0.0);
                        this.colorRampLegend.transform.translateY.setValue(this.metrics.getLowExtender());
                    }
                }
            }
        }
        this.networkRoot.draw();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = new Dimension();
        if (this.networkRoot != null) {
            Insets insets = this.getInsets();
            this.setSafeProjection();
            if (this.legend != null) {
                this.legend.setWidth(this.getMaximumSize().getWidth() - (double)insets.left - (double)insets.right);
                this.legend.setHeight(this.getMaximumSize().getHeight() - (double)insets.top - (double)insets.bottom);
                BoundingBox bbox = this.networkRoot.computeBoundingBox();
                Vec3d bboxSize = bbox.getSize();
                if (bboxSize.x != 0.0 || bboxSize.y != 0.0) {
                    preferredSize.width = (int)Math.ceil(bboxSize.x + (double)insets.left + (double)insets.right);
                    preferredSize.height = (int)Math.ceil(bboxSize.y + (double)insets.top + (double)insets.bottom);
                }
            } else {
                AxisMetrics m = this.colorRampLegend.getPreferredMetrics(this.channel);
                if (m.getWidth() != 0.0 || m.getWidth() != 0.0) {
                    preferredSize.width = (int)Math.ceil(m.getWidth() + (double)insets.left + (double)insets.right + 1.0);
                    preferredSize.height = (int)Math.ceil(m.getHeight() + (double)insets.top + (double)insets.bottom + 1.0);
                }
            }
            this.setProjection(0, 0, this.getWidth(), this.getHeight());
        }
        return preferredSize;
    }

    public NetworkRoot getNetworkRoot() {
        return this.networkRoot;
    }

    public void setTextAntiAliasingEnabled(boolean b) {
        if (b) {
            this.channel.glEnable(14);
        } else {
            this.channel.glDisable(14);
        }
    }

    public void setAntiAliasingEnabled(boolean b) {
        this.antiAliasingEnabled = b;
    }
}

