/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.SASLinePatterns;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.SelectEntry;
import com.sas.graphics.util.gtk.gl.BaseBar;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.Image;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class HighLowBar
extends Element {
    private Rectangle2D.Double fullSize = new Rectangle2D.Double();
    private BufferedImage[] texImage;
    private float polygonOffsetFactor = 0.001f;
    private float polygonOffsetUnits = 0.0f;
    private java.awt.Image skin = null;
    private BufferedImage barSizedImage;
    private java.awt.Image[] pixelBenderImages = null;
    private int skinType = 0;
    private int myValueCount;
    private List drawOrderList;
    private static final double defaultThickness = 10.0;
    public static final int CAP_NONE = 0;
    public static final int CAP_SERIF = 1;
    public static final int CAP_ARROW = 2;
    public static final int CAP_BARBED_ARROW = 3;
    public static final int CAP_OPEN_ARROW = 4;
    public static final int CAP_CLIP = 5;
    public static int CAP_DISPLAY_AUTO = 0;
    public static int CAP_DISPLAY_ALWAYS = 1;
    private int capDisplayPolicy = CAP_DISPLAY_AUTO;
    private int clipCapShape = 5;
    private boolean clipCapOn = false;
    private double clipMin;
    private double clipMax;
    private boolean isClipHighCap = false;
    private boolean isClipLowCap = false;
    protected double stippleScaleFactor = 1.0;
    protected boolean subpixelRendering = false;
    public final NumericProperty thickness = new NumericProperty(this, true);
    public final NumericProperty position = new NumericProperty(this, true);
    public final NumericProperty startValue = new NumericProperty(this, true);
    public final NumericProperty endValue = new NumericProperty(this, true);
    public final BooleanProperty openOn = new BooleanProperty(this, true);
    public final NumericProperty openValue = new NumericProperty(this, true);
    public final BooleanProperty closeOn = new BooleanProperty(this, true);
    public final NumericProperty closeValue = new NumericProperty(this, true);
    public final BooleanProperty highCapOn = new BooleanProperty(this, true);
    public final IntegerProperty highCap = new IntegerProperty(this, true);
    public final BooleanProperty lowCapOn = new BooleanProperty(this, true);
    public final IntegerProperty lowCap = new IntegerProperty(this, true);
    public final BooleanProperty verticalOn = new BooleanProperty(this, true);
    public final NumericProperty openCloseThickness = new NumericProperty(this, true);
    public final NumericProperty openCloseWidth = new NumericProperty(this, true);
    public final ColorProperty openCloseColor = new ColorProperty(this, true);
    public final NumericProperty capThickness = new NumericProperty(this, true);
    public final ColorProperty color1 = new ColorProperty(this, true);
    public final ColorProperty color2 = new ColorProperty(this, true);
    public final ColorProperty highlightFillColor = new ColorProperty(this, true);
    public final ColorProperty highlightEdgeColor = new ColorProperty(this, true);
    public final ColorProperty edgeColor = new ColorProperty(this, true);
    public final BooleanProperty edgeOn = new BooleanProperty(this, true);
    public final NumericProperty edgeWidth = new NumericProperty(this, true);
    public final IntegerProperty edgePattern = new IntegerProperty(this, true);
    public final BooleanProperty fillOn = new BooleanProperty(this, true);
    public final BooleanProperty fillPatternOn = new BooleanProperty(this, true);
    public final IntegerProperty fillPatternType = new IntegerProperty(this, true);
    public final ColorProperty fillPatternColor = new ColorProperty(this, true);
    public final NumericProperty fillPatternWidth = new NumericProperty(this, true);
    public final NumericProperty fillPatternScaleFactor = new NumericProperty(this, true);
    public final BooleanProperty highlightOn = new BooleanProperty(this, true);
    public final NumericProperty highlightPercentage = new NumericProperty(this, true);
    public final BooleanProperty gradientOn = new BooleanProperty(this, true);
    public final IntegerProperty gradientDirection = new IntegerProperty(this, true);
    public final BooleanProperty textureOn = new BooleanProperty(this, true);
    public final IntegerProperty textureMode = new IntegerProperty(this, true);
    public final IntegerProperty textureStyle = new IntegerProperty(this, true);
    public final IntegerProperty textureIndex = new IntegerProperty(this, true);
    private GradientDefinition contextSensitiveGradient = new GradientDefinition();
    private final PropertyValueBlock propertyValueBlock = new PropertyValueBlock();
    private Comparator positionComparator;
    private Comparator stackComparator;

    public HighLowBar() {
        super(new Transform());
        this.color1.setValue(ColorProperty.getDefaultColor());
        this.color2.setValue(ColorProperty.getDefaultColor());
        this.highlightFillColor.setValue(Color.yellow);
        this.highlightEdgeColor.setValue(Color.yellow);
        this.edgeColor.setValue(Color.black);
        this.thickness.setValue(10.0);
        this.edgeOn.setValue(true);
        this.edgeWidth.setValue(1.0);
        this.edgePattern.setValue(-1);
        this.fillOn.setValue(true);
        this.highlightOn.setValue(false);
        this.highlightPercentage.setValue(1.0);
        this.gradientOn.setValue(false);
        this.gradientDirection.setValue(1);
        this.fillPatternOn.setValue(false);
        this.fillPatternType.setValue(-1);
        this.fillPatternColor.setValue(Color.black);
        this.fillPatternWidth.setValue(1.0);
        this.fillPatternScaleFactor.setValue(1.0);
        this.textureOn.setValue(false);
        this.textureMode.setValue(3);
        this.textureStyle.setValue(4);
        this.verticalOn.setValue(true);
        this.openOn.setValue(false);
        this.closeOn.setValue(false);
        this.highCapOn.setValue(false);
        this.lowCapOn.setValue(false);
    }

    @Override
    public void init(AInitAction initAction) {
        initAction.pushValueCount();
        super.init(initAction);
        int vc = initAction.getValueCount();
        this.setMyValueCount(vc);
        initAction.popValueCount();
        int initVC = vc == 0 ? 0 : 1;
        this.setValueCount(initVC);
        initAction.setValueCount(initVC);
    }

    public void setTextureImage(BufferedImage[] image) {
        this.texImage = image;
        this.setModified();
    }

    public BufferedImage[] getTextureImage() {
        return this.texImage;
    }

    public void setSkin(java.awt.Image newImage) {
        this.skin = newImage;
    }

    public java.awt.Image getSkin() {
        return this.skin;
    }

    public void setSkinType(int t) {
        this.skinType = t;
    }

    public int getSkinType() {
        return this.skinType;
    }

    public void setPixelBenderImages(java.awt.Image[] newImages) {
        this.pixelBenderImages = newImages;
    }

    public java.awt.Image[] getPixelBenderImages() {
        return this.pixelBenderImages;
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
        Vec3d s = bBoxAction.pt1;
        Vec3d c = bBoxAction.pt2;
        double dx = 0.0;
        double dy = 0.0;
        s.set(dx, dy, 0.0);
        BoundingBox box = bBoxAction.getElementBoundingBox();
        box.union(c, s);
    }

    public static BufferedImage convertImageToBufferedImage(java.awt.Image image) {
        return Image.convertImageToBufferedImage(image);
    }

    private void computeRectangle(double pos, double sv, double ev, double thick, boolean vertical, Rectangle2D.Double r1, boolean capOn) {
        double halfThick;
        if (capOn || thick < 1.0) {
            halfThick = this.getHalfThickness(thick);
            thick = halfThick * 2.0;
        } else {
            halfThick = thick * 0.5;
        }
        if (vertical) {
            r1.y = sv;
            r1.height = ev - sv;
            r1.x = pos - halfThick;
            r1.width = thick;
        } else {
            r1.x = sv;
            r1.width = ev - sv;
            r1.y = pos - halfThick;
            r1.height = thick;
        }
        this.removeNegativeWidthHeight(r1);
    }

    private void computePolygon(PropertyValueBlock pBlock, ArrayList x, ArrayList y) {
        double ew2;
        double h = pBlock.capThick * Math.sin(1.0471975511965976);
        double halfThick = this.getHalfThickness(pBlock.capThick);
        double d = ew2 = pBlock.eo ? this.getHalfThickness(pBlock.ew) : 0.0;
        if (pBlock.hcap != 0 && pBlock.lcap != 0) {
            if (Math.abs(pBlock.ev - pBlock.sv) < (h + ew2) * 2.0) {
                if (pBlock.hcap < 5) {
                    pBlock.hcapOn = false;
                }
                if (pBlock.lcap < 5) {
                    pBlock.lcapOn = false;
                }
            }
        } else if (pBlock.hcap != 0) {
            pBlock.lcapOn = false;
            if (Math.abs(pBlock.ev - pBlock.sv) < h + ew2 && pBlock.hcap < 5) {
                pBlock.hcapOn = false;
            }
        } else if (pBlock.lcap != 0) {
            pBlock.hcapOn = false;
            if (Math.abs(pBlock.ev - pBlock.sv) < h + ew2 && pBlock.lcap < 5) {
                pBlock.lcapOn = false;
            }
        } else {
            pBlock.hcapOn = false;
            pBlock.lcapOn = false;
        }
        if (!pBlock.hcapOn && !pBlock.lcapOn) {
            return;
        }
        if (pBlock.lcap == 5 && this.clipCapShape < 5) {
            pBlock.lcap = 2;
        }
        if (pBlock.hcap == 5 && this.clipCapShape < 5) {
            pBlock.hcap = 2;
        }
        double gap = Math.max(1.0, h / 6.0);
        double topH = h * 0.5 - Math.floor(gap * 0.5);
        double topBase2 = topH * halfThick / h;
        double bottomBase2 = (topH + gap) * halfThick / h;
        if (pBlock.hcapOn && pBlock.lcapOn) {
            if (Math.abs(pBlock.ev - pBlock.sv) < 2.0 * h) {
                h = Math.abs(pBlock.ev - pBlock.sv) * 0.5;
                gap = Math.max(1.0, h / 6.0);
                topH = h * 0.5 - Math.floor(gap * 0.5);
                topBase2 = topH * halfThick / h;
                bottomBase2 = (topH + gap) * halfThick / h;
                if (pBlock.vertical) {
                    if (this.clipCapShape == 5) {
                        x.add(pBlock.pos + bottomBase2);
                        y.add(pBlock.ev - topH - gap);
                        x.add(pBlock.pos - bottomBase2);
                        y.add(pBlock.ev - topH - gap);
                        x.add(pBlock.pos - halfThick);
                        y.add(pBlock.ev - h);
                        x.add(pBlock.pos - bottomBase2);
                        y.add(pBlock.sv + topH + gap);
                        x.add(pBlock.pos + bottomBase2);
                        y.add(pBlock.sv + topH + gap);
                        x.add(pBlock.pos + halfThick);
                        y.add(pBlock.ev - h);
                    } else {
                        x.add(pBlock.pos);
                        y.add(pBlock.ev);
                        x.add(pBlock.pos - halfThick);
                        y.add(pBlock.ev - h);
                        x.add(pBlock.pos);
                        y.add(pBlock.sv);
                        x.add(pBlock.pos + halfThick);
                        y.add(pBlock.sv + h);
                    }
                } else if (this.clipCapShape == 5) {
                    x.add(pBlock.sv + topH + gap);
                    y.add(pBlock.pos + bottomBase2);
                    x.add(pBlock.sv + topH + gap);
                    y.add(pBlock.pos - bottomBase2);
                    x.add(pBlock.ev - h);
                    y.add(pBlock.pos - halfThick);
                    x.add(pBlock.ev - topH - gap);
                    y.add(pBlock.pos - bottomBase2);
                    x.add(pBlock.ev - topH - gap);
                    y.add(pBlock.pos + bottomBase2);
                    x.add(pBlock.ev - h);
                    y.add(pBlock.pos + halfThick);
                } else {
                    x.add(pBlock.sv);
                    y.add(pBlock.pos);
                    x.add(pBlock.sv + h);
                    y.add(pBlock.pos - halfThick);
                    x.add(pBlock.ev);
                    y.add(pBlock.pos);
                    x.add(pBlock.ev - h);
                    y.add(pBlock.pos + halfThick);
                }
            } else if (pBlock.vertical) {
                if (pBlock.hcap == 5) {
                    x.add(pBlock.pos + bottomBase2);
                    y.add(pBlock.ev - topH - gap);
                    x.add(pBlock.pos - bottomBase2);
                    y.add(pBlock.ev - topH - gap);
                } else {
                    x.add(pBlock.pos);
                    y.add(pBlock.ev);
                }
                x.add(pBlock.pos - halfThick);
                y.add(pBlock.ev - h);
                x.add(this.fullSize.x);
                y.add(pBlock.ev - h);
                x.add(this.fullSize.x);
                y.add(pBlock.sv + h);
                x.add(pBlock.pos - halfThick);
                y.add(pBlock.sv + h);
                if (pBlock.lcap == 5) {
                    x.add(pBlock.pos - bottomBase2);
                    y.add(pBlock.sv + topH + gap);
                    x.add(pBlock.pos + bottomBase2);
                    y.add(pBlock.sv + topH + gap);
                } else {
                    x.add(pBlock.pos);
                    y.add(pBlock.sv);
                }
                x.add(pBlock.pos + halfThick);
                y.add(pBlock.sv + h);
                x.add(this.fullSize.x + this.fullSize.width);
                y.add(pBlock.sv + h);
                x.add(this.fullSize.x + this.fullSize.width);
                y.add(pBlock.ev - h);
                x.add(pBlock.pos + halfThick);
                y.add(pBlock.ev - h);
            } else {
                if (pBlock.lcap == 5) {
                    x.add(pBlock.sv + topH + gap);
                    y.add(pBlock.pos + bottomBase2);
                    x.add(pBlock.sv + topH + gap);
                    y.add(pBlock.pos - bottomBase2);
                } else {
                    x.add(pBlock.sv);
                    y.add(pBlock.pos);
                }
                x.add(pBlock.sv + h);
                y.add(pBlock.pos - halfThick);
                x.add(pBlock.sv + h);
                y.add(this.fullSize.y);
                x.add(pBlock.ev - h);
                y.add(this.fullSize.y);
                x.add(pBlock.ev - h);
                y.add(pBlock.pos - halfThick);
                if (pBlock.hcap == 5) {
                    x.add(pBlock.ev - topH - gap);
                    y.add(pBlock.pos - bottomBase2);
                    x.add(pBlock.ev - topH - gap);
                    y.add(pBlock.pos + bottomBase2);
                } else {
                    x.add(pBlock.ev);
                    y.add(pBlock.pos);
                }
                x.add(pBlock.ev - h);
                y.add(pBlock.pos + halfThick);
                x.add(pBlock.ev - h);
                y.add(this.fullSize.y + this.fullSize.height);
                x.add(pBlock.sv + h);
                y.add(this.fullSize.y + this.fullSize.height);
                x.add(pBlock.sv + h);
                y.add(pBlock.pos + halfThick);
            }
        } else if (pBlock.hcapOn) {
            if (Math.abs(pBlock.ev - pBlock.sv) < h) {
                if (pBlock.vertical) {
                    if (this.clipCapShape == 5) {
                        x.add(pBlock.pos + bottomBase2);
                        y.add(pBlock.ev - topH - gap);
                        x.add(pBlock.pos - bottomBase2);
                        y.add(pBlock.ev - topH - gap);
                        x.add(pBlock.pos - halfThick);
                        y.add(pBlock.ev - h);
                        x.add(pBlock.pos + halfThick);
                        y.add(pBlock.ev - h);
                    } else {
                        x.add(pBlock.pos);
                        y.add(pBlock.ev);
                        x.add(pBlock.pos - halfThick);
                        y.add(pBlock.ev - h);
                        x.add(pBlock.pos + halfThick);
                        y.add(pBlock.ev - h);
                    }
                } else if (this.clipCapShape == 5) {
                    x.add(pBlock.ev - topH - gap);
                    y.add(pBlock.pos - bottomBase2);
                    x.add(pBlock.ev - topH - gap);
                    y.add(pBlock.pos + bottomBase2);
                    x.add(pBlock.ev - h);
                    y.add(pBlock.pos + halfThick);
                    x.add(pBlock.ev - h);
                    y.add(pBlock.pos - halfThick);
                } else {
                    x.add(pBlock.ev);
                    y.add(pBlock.pos);
                    x.add(pBlock.ev - h);
                    y.add(pBlock.pos + halfThick);
                    x.add(pBlock.ev - h);
                    y.add(pBlock.pos - halfThick);
                }
            } else if (pBlock.vertical) {
                if (pBlock.hcap == 5) {
                    x.add(pBlock.pos + bottomBase2);
                    y.add(pBlock.ev - topH - gap);
                    x.add(pBlock.pos - bottomBase2);
                    y.add(pBlock.ev - topH - gap);
                } else {
                    x.add(pBlock.pos);
                    y.add(pBlock.ev);
                }
                x.add(pBlock.pos - halfThick);
                y.add(pBlock.ev - h);
                x.add(this.fullSize.x);
                y.add(pBlock.ev - h);
                x.add(this.fullSize.x);
                y.add(pBlock.sv);
                x.add(this.fullSize.x + this.fullSize.width);
                y.add(pBlock.sv);
                x.add(this.fullSize.x + this.fullSize.width);
                y.add(pBlock.ev - h);
                x.add(pBlock.pos + halfThick);
                y.add(pBlock.ev - h);
            } else {
                x.add(pBlock.sv);
                y.add(this.fullSize.y);
                x.add(pBlock.ev - h);
                y.add(this.fullSize.y);
                x.add(pBlock.ev - h);
                y.add(pBlock.pos - halfThick);
                if (pBlock.hcap == 5) {
                    x.add(pBlock.ev - topH - gap);
                    y.add(pBlock.pos - bottomBase2);
                    x.add(pBlock.ev - topH - gap);
                    y.add(pBlock.pos + bottomBase2);
                } else {
                    x.add(pBlock.ev);
                    y.add(pBlock.pos);
                }
                x.add(pBlock.ev - h);
                y.add(pBlock.pos + halfThick);
                x.add(pBlock.ev - h);
                y.add(this.fullSize.y + this.fullSize.height);
                x.add(pBlock.sv);
                y.add(this.fullSize.y + this.fullSize.height);
            }
        } else if (pBlock.lcapOn) {
            if (Math.abs(pBlock.ev - pBlock.sv) < h) {
                if (pBlock.vertical) {
                    if (this.clipCapShape == 5) {
                        x.add(pBlock.pos - halfThick);
                        y.add(pBlock.sv + h);
                        x.add(pBlock.pos + halfThick);
                        y.add(pBlock.sv + h);
                        x.add(pBlock.pos + bottomBase2);
                        y.add(pBlock.sv + topH + gap);
                        x.add(pBlock.pos - bottomBase2);
                        y.add(pBlock.sv + topH + gap);
                    } else {
                        x.add(pBlock.pos);
                        y.add(pBlock.sv);
                        x.add(pBlock.pos - halfThick);
                        y.add(pBlock.sv + h);
                        x.add(pBlock.pos + halfThick);
                        y.add(pBlock.sv + h);
                    }
                } else if (this.clipCapShape == 5) {
                    x.add(pBlock.sv + topH + gap);
                    y.add(pBlock.pos + bottomBase2);
                    x.add(pBlock.sv + topH + gap);
                    y.add(pBlock.pos - bottomBase2);
                    x.add(pBlock.sv + h);
                    y.add(pBlock.pos - halfThick);
                    x.add(pBlock.sv + h);
                    y.add(pBlock.pos + halfThick);
                } else {
                    x.add(pBlock.sv);
                    y.add(pBlock.pos);
                    x.add(pBlock.sv + h);
                    y.add(pBlock.pos - halfThick);
                    x.add(pBlock.sv + h);
                    y.add(pBlock.pos + halfThick);
                }
            } else if (pBlock.vertical) {
                x.add(this.fullSize.x);
                y.add(pBlock.ev);
                x.add(this.fullSize.x);
                y.add(pBlock.sv + h);
                x.add(pBlock.pos - halfThick);
                y.add(pBlock.sv + h);
                if (pBlock.lcap == 5) {
                    x.add(pBlock.pos - bottomBase2);
                    y.add(pBlock.sv + topH + gap);
                    x.add(pBlock.pos + bottomBase2);
                    y.add(pBlock.sv + topH + gap);
                } else {
                    x.add(pBlock.pos);
                    y.add(pBlock.sv);
                }
                x.add(pBlock.pos + halfThick);
                y.add(pBlock.sv + h);
                x.add(this.fullSize.x + this.fullSize.width);
                y.add(pBlock.sv + h);
                x.add(this.fullSize.x + this.fullSize.width);
                y.add(pBlock.ev);
            } else {
                if (pBlock.lcap == 5) {
                    x.add(pBlock.sv + topH + gap);
                    y.add(pBlock.pos + bottomBase2);
                    x.add(pBlock.sv + topH + gap);
                    y.add(pBlock.pos - bottomBase2);
                } else {
                    x.add(pBlock.sv);
                    y.add(pBlock.pos);
                }
                x.add(pBlock.sv + h);
                y.add(pBlock.pos - halfThick);
                x.add(pBlock.sv + h);
                y.add(this.fullSize.y);
                x.add(pBlock.ev);
                y.add(this.fullSize.y);
                x.add(pBlock.ev);
                y.add(this.fullSize.y + this.fullSize.height);
                x.add(pBlock.sv + h);
                y.add(this.fullSize.y + this.fullSize.height);
                x.add(pBlock.sv + h);
                y.add(pBlock.pos + halfThick);
            }
        }
    }

    private void drawClipArrow(Channel channel, PropertyValueBlock pBlock) {
        double h = pBlock.capThick * Math.sin(1.0471975511965976);
        double halfThick = this.getHalfThickness(pBlock.capThick);
        if (pBlock.hcapOn && pBlock.lcapOn && Math.abs(pBlock.ev - pBlock.sv) < h * 2.0) {
            h = Math.abs(pBlock.ev - pBlock.sv) * 0.5;
        }
        double gap = Math.max(1.0, h / 6.0);
        double topH = h * 0.5 - Math.floor(gap * 0.5);
        double topBase2 = topH * halfThick / h;
        double bottomBase2 = (topH + gap) * halfThick / h;
        if (pBlock.hcap == 5) {
            channel.glBegin(2);
            if (pBlock.vertical) {
                channel.glVertex(pBlock.pos, pBlock.ev);
                channel.glVertex(pBlock.pos - topBase2, pBlock.ev - topH);
                channel.glVertex(pBlock.pos + topBase2, pBlock.ev - topH);
            } else {
                channel.glVertex(pBlock.ev, pBlock.pos);
                channel.glVertex(pBlock.ev - topH, pBlock.pos - topBase2);
                channel.glVertex(pBlock.ev - topH, pBlock.pos + topBase2);
            }
            channel.glEnd();
        }
        if (pBlock.lcap == 5) {
            channel.glBegin(2);
            if (pBlock.vertical) {
                channel.glVertex(pBlock.pos, pBlock.sv);
                channel.glVertex(pBlock.pos - topBase2, pBlock.sv + topH);
                channel.glVertex(pBlock.pos + topBase2, pBlock.sv + topH);
            } else {
                channel.glVertex(pBlock.sv, pBlock.pos);
                channel.glVertex(pBlock.sv + topH, pBlock.pos - topBase2);
                channel.glVertex(pBlock.sv + topH, pBlock.pos + topBase2);
            }
            channel.glEnd();
        }
    }

    private void drawHighLowLine(Channel channel, double pos, double sv, double ev, int lcap, int hcap, double thick, double lw, boolean vertical, boolean capOnly) {
        double h;
        double hshift = 0.0;
        double lshift = 0.0;
        double arrowH = 0.0;
        double size = thick;
        switch (hcap) {
            case 0: {
                break;
            }
            case 1: {
                hshift = lw == 1.0 ? 0.0 : this.getHalfThickness(lw);
                arrowH += lw;
                break;
            }
            case 2: {
                size = this.getAdjustedArrowSize(thick, lw, hcap);
                h = size * Math.sin(1.0471975511965976);
                hshift = h * 0.5;
                arrowH += h;
                break;
            }
            case 3: {
                size = this.getAdjustedArrowSize(thick, lw, hcap);
                h = size * Math.sin(1.0471975511965976);
                hshift = h * 0.5;
                arrowH += h;
                break;
            }
            case 4: {
                size = this.getAdjustedArrowSize(thick, lw, hcap);
                h = size * Math.sin(1.0471975511965976);
                hshift = this.getMiterLength(lw);
                arrowH += h + hshift;
                break;
            }
            case 5: {
                size = this.getAdjustedArrowSize(thick, lw, hcap);
                h = size * Math.sin(1.0471975511965976);
                hshift = h * 0.75;
                arrowH += h;
            }
        }
        switch (lcap) {
            case 0: {
                break;
            }
            case 1: {
                lshift = lw == 1.0 ? 0.0 : this.getHalfThickness(lw);
                arrowH += lw;
                break;
            }
            case 2: {
                size = this.getAdjustedArrowSize(thick, lw, lcap);
                h = size * Math.sin(1.0471975511965976);
                lshift = h * 0.5;
                arrowH += h;
                break;
            }
            case 3: {
                size = this.getAdjustedArrowSize(thick, lw, lcap);
                h = size * Math.sin(1.0471975511965976);
                lshift = h * 0.5;
                arrowH += h;
                break;
            }
            case 4: {
                size = this.getAdjustedArrowSize(thick, lw, lcap);
                h = size * Math.sin(1.0471975511965976);
                lshift = this.getMiterLength(lw);
                arrowH += h + lshift;
                break;
            }
            case 5: {
                size = this.getAdjustedArrowSize(thick, lw, lcap);
                h = size * Math.sin(1.0471975511965976);
                lshift = h * 0.75;
                arrowH += h;
            }
        }
        if (Math.abs(ev - sv) < arrowH && this.capDisplayPolicy == CAP_DISPLAY_AUTO) {
            if (!this.isClipHighCap) {
                hcap = 0;
                hshift = 0.0;
            }
            if (!this.isClipLowCap) {
                lcap = 0;
                lshift = 0.0;
            }
        }
        if (this.skinType != 0) {
            if (capOnly) {
                channel.glSkinRenderMode(7);
            } else {
                channel.glSkinRenderMode(2);
            }
        }
        channel.glDisable(6);
        switch (hcap) {
            case 0: {
                break;
            }
            case 1: {
                this.drawHighCap(channel, pos, ev - hshift, hcap, thick, lw, vertical);
                break;
            }
            case 2: {
                size = this.getAdjustedArrowSize(thick, lw, hcap);
                this.drawHighCap(channel, pos, ev, hcap, size, lw, vertical);
                break;
            }
            case 3: {
                size = this.getAdjustedArrowSize(thick, lw, hcap);
                this.drawHighCap(channel, pos, ev, hcap, size, lw, vertical);
                break;
            }
            case 4: {
                size = this.getAdjustedArrowSize(thick, lw, hcap);
                this.drawHighCap(channel, pos, ev - hshift, hcap, size, lw, vertical);
                break;
            }
            case 5: {
                size = this.getAdjustedArrowSize(thick, lw, hcap);
                this.drawHighCap(channel, pos, ev, hcap, size, lw, vertical);
            }
        }
        switch (lcap) {
            case 0: {
                break;
            }
            case 1: {
                this.drawLowCap(channel, pos, sv + lshift, lcap, thick, lw, vertical);
                break;
            }
            case 2: {
                size = this.getAdjustedArrowSize(thick, lw, lcap);
                this.drawLowCap(channel, pos, sv, lcap, size, lw, vertical);
                break;
            }
            case 3: {
                size = this.getAdjustedArrowSize(thick, lw, lcap);
                this.drawLowCap(channel, pos, sv, lcap, size, lw, vertical);
                break;
            }
            case 4: {
                size = this.getAdjustedArrowSize(thick, lw, lcap);
                this.drawLowCap(channel, pos, sv + lshift, lcap, size, lw, vertical);
                break;
            }
            case 5: {
                size = this.getAdjustedArrowSize(thick, lw, lcap);
                this.drawLowCap(channel, pos, sv, lcap, size, lw, vertical);
            }
        }
        channel.glEnable(6);
        if (capOnly) {
            return;
        }
        if (this.skinType != 0) {
            channel.glSkinRenderMode(15);
        }
        channel.glBegin(1);
        if (vertical) {
            channel.glVertex(pos, sv + lshift);
            channel.glVertex(pos, ev - hshift);
        } else {
            channel.glVertex(sv + lshift, pos);
            channel.glVertex(ev - hshift, pos);
        }
        channel.glEnd();
        if (channel.isSVGSelectionMode()) {
            channel.clearSVGSelectionText();
        }
        if (this.skinType != 0) {
            channel.glSkinRenderMode(5);
            channel.glDisable(6);
            switch (hcap) {
                case 0: {
                    break;
                }
                case 1: {
                    this.drawHighCap(channel, pos, ev - hshift, hcap, thick, lw, vertical);
                    break;
                }
                case 2: {
                    size = this.getAdjustedArrowSize(thick, lw, hcap);
                    this.drawHighCap(channel, pos, ev, hcap, size, lw, vertical);
                    break;
                }
                case 3: {
                    size = this.getAdjustedArrowSize(thick, lw, hcap);
                    this.drawHighCap(channel, pos, ev, hcap, size, lw, vertical);
                    break;
                }
                case 4: {
                    size = this.getAdjustedArrowSize(thick, lw, hcap);
                    this.drawHighCap(channel, pos, ev - hshift, hcap, size, lw, vertical);
                    break;
                }
                case 5: {
                    size = this.getAdjustedArrowSize(thick, lw, hcap);
                    this.drawHighCap(channel, pos, ev, hcap, size, lw, vertical);
                }
            }
            switch (lcap) {
                case 0: {
                    break;
                }
                case 1: {
                    this.drawLowCap(channel, pos, sv + lshift, lcap, thick, lw, vertical);
                    break;
                }
                case 2: {
                    size = this.getAdjustedArrowSize(thick, lw, lcap);
                    this.drawLowCap(channel, pos, sv, lcap, size, lw, vertical);
                    break;
                }
                case 3: {
                    size = this.getAdjustedArrowSize(thick, lw, lcap);
                    this.drawLowCap(channel, pos, sv, lcap, size, lw, vertical);
                    break;
                }
                case 4: {
                    size = this.getAdjustedArrowSize(thick, lw, lcap);
                    this.drawLowCap(channel, pos, sv + lshift, lcap, size, lw, vertical);
                    break;
                }
                case 5: {
                    size = this.getAdjustedArrowSize(thick, lw, lcap);
                    this.drawLowCap(channel, pos, sv, lcap, size, lw, vertical);
                }
            }
            channel.glEnable(6);
        }
    }

    private void drawHighCap(Channel channel, double pos, double val, int cap, double thick, double lw, boolean vertical) {
        double halfThick = this.getHalfThickness(thick);
        switch (cap) {
            case 0: {
                break;
            }
            case 1: {
                channel.glBegin(1);
                if (vertical) {
                    channel.glVertex(pos - halfThick, val);
                    channel.glVertex(pos + halfThick, val);
                } else {
                    channel.glVertex(val, pos - halfThick);
                    channel.glVertex(val, pos + halfThick);
                }
                channel.glEnd();
                break;
            }
            case 2: {
                double h = thick * Math.sin(1.0471975511965976);
                int mode = channel.getPolygonMode();
                channel.glPolygonMode(3);
                channel.glBegin(2);
                if (vertical) {
                    channel.glVertex(pos, val);
                    channel.glVertex(pos - halfThick, val - h);
                    channel.glVertex(pos + halfThick, val - h);
                } else {
                    channel.glVertex(val, pos);
                    channel.glVertex(val - h, pos - halfThick);
                    channel.glVertex(val - h, pos + halfThick);
                }
                channel.glEnd();
                channel.glPolygonMode(mode);
                break;
            }
            case 4: {
                double h = thick * Math.sin(1.0471975511965976);
                channel.glBegin(1);
                if (vertical) {
                    channel.glVertex(pos - halfThick, val - h);
                    channel.glVertex(pos, val);
                    channel.glVertex(pos + halfThick, val - h);
                } else {
                    channel.glVertex(val - h, pos - halfThick);
                    channel.glVertex(val, pos);
                    channel.glVertex(val - h, pos + halfThick);
                }
                channel.glEnd();
                break;
            }
            case 3: {
                double h = thick * Math.sin(1.0471975511965976);
                int mode = channel.getPolygonMode();
                channel.glPolygonMode(3);
                channel.glBegin(2);
                if (vertical) {
                    channel.glVertex(pos, val);
                    channel.glVertex(pos - halfThick, val - h);
                    channel.glVertex(pos, val - h * 0.75);
                    channel.glVertex(pos + halfThick, val - h);
                } else {
                    channel.glVertex(val, pos);
                    channel.glVertex(val - h, pos - halfThick);
                    channel.glVertex(val - h * 0.75, pos);
                    channel.glVertex(val - h, pos + halfThick);
                }
                channel.glEnd();
                channel.glPolygonMode(mode);
                break;
            }
            case 5: {
                double h = thick * Math.sin(1.0471975511965976);
                double gap = Math.max(1.0, h / 6.0);
                double topH = h * 0.5 - Math.floor(gap * 0.5);
                double topBase2 = topH * halfThick / h;
                double bottomBase2 = (topH + gap) * halfThick / h;
                int mode = channel.getPolygonMode();
                channel.glPolygonMode(3);
                if (vertical) {
                    channel.glBegin(2);
                    channel.glVertex(pos, val);
                    channel.glVertex(pos - topBase2, val - topH);
                    channel.glVertex(pos + topBase2, val - topH);
                    channel.glEnd();
                    channel.glBegin(2);
                    channel.glVertex(pos - bottomBase2, val - topH - gap);
                    channel.glVertex(pos - halfThick, val - h);
                    channel.glVertex(pos + halfThick, val - h);
                    channel.glVertex(pos + bottomBase2, val - topH - gap);
                    channel.glEnd();
                } else {
                    channel.glBegin(2);
                    channel.glVertex(val, pos);
                    channel.glVertex(val - topH, pos - topBase2);
                    channel.glVertex(val - topH, pos + topBase2);
                    channel.glEnd();
                    channel.glBegin(2);
                    channel.glVertex(val - topH - gap, pos - bottomBase2);
                    channel.glVertex(val - h, pos - halfThick);
                    channel.glVertex(val - h, pos + halfThick);
                    channel.glVertex(val - topH - gap, pos + bottomBase2);
                    channel.glEnd();
                }
                channel.glPolygonMode(mode);
            }
        }
    }

    private void drawLowCap(Channel channel, double pos, double val, int cap, double thick, double lw, boolean vertical) {
        double halfThick = this.getHalfThickness(thick);
        switch (cap) {
            case 0: {
                break;
            }
            case 1: {
                channel.glBegin(1);
                if (vertical) {
                    channel.glVertex(pos - halfThick, val);
                    channel.glVertex(pos + halfThick, val);
                } else {
                    channel.glVertex(val, pos - halfThick);
                    channel.glVertex(val, pos + halfThick);
                }
                channel.glEnd();
                break;
            }
            case 2: {
                double h = thick * Math.sin(1.0471975511965976);
                int mode = channel.getPolygonMode();
                channel.glPolygonMode(3);
                channel.glBegin(2);
                if (vertical) {
                    channel.glVertex(pos, val);
                    channel.glVertex(pos - halfThick, val + h);
                    channel.glVertex(pos + halfThick, val + h);
                } else {
                    channel.glVertex(val, pos);
                    channel.glVertex(val + h, pos - halfThick);
                    channel.glVertex(val + h, pos + halfThick);
                }
                channel.glEnd();
                channel.glPolygonMode(mode);
                break;
            }
            case 4: {
                double h = thick * Math.sin(1.0471975511965976);
                channel.glBegin(1);
                if (vertical) {
                    channel.glVertex(pos - halfThick, val + h);
                    channel.glVertex(pos, val);
                    channel.glVertex(pos + halfThick, val + h);
                } else {
                    channel.glVertex(val + h, pos - halfThick);
                    channel.glVertex(val, pos);
                    channel.glVertex(val + h, pos + halfThick);
                }
                channel.glEnd();
                break;
            }
            case 3: {
                double h = thick * Math.sin(1.0471975511965976);
                int mode = channel.getPolygonMode();
                channel.glPolygonMode(3);
                channel.glBegin(2);
                if (vertical) {
                    channel.glVertex(pos, val);
                    channel.glVertex(pos - halfThick, val + h);
                    channel.glVertex(pos, val + h * 0.75);
                    channel.glVertex(pos + halfThick, val + h);
                } else {
                    channel.glVertex(val, pos);
                    channel.glVertex(val + h, pos - halfThick);
                    channel.glVertex(val + h * 0.75, pos);
                    channel.glVertex(val + h, pos + halfThick);
                }
                channel.glEnd();
                channel.glPolygonMode(mode);
                break;
            }
            case 5: {
                double h = thick * Math.sin(1.0471975511965976);
                double gap = Math.max(1.0, h / 6.0);
                double topH = h * 0.5 - Math.floor(gap * 0.5);
                double topBase2 = topH * halfThick / h;
                double bottomBase2 = (topH + gap) * halfThick / h;
                int mode = channel.getPolygonMode();
                channel.glPolygonMode(3);
                if (vertical) {
                    channel.glBegin(2);
                    channel.glVertex(pos, val);
                    channel.glVertex(pos - topBase2, val + topH);
                    channel.glVertex(pos + topBase2, val + topH);
                    channel.glEnd();
                    channel.glBegin(2);
                    channel.glVertex(pos - bottomBase2, val + topH + gap);
                    channel.glVertex(pos - halfThick, val + h);
                    channel.glVertex(pos + halfThick, val + h);
                    channel.glVertex(pos + bottomBase2, val + topH + gap);
                    channel.glEnd();
                } else {
                    channel.glBegin(2);
                    channel.glVertex(val, pos);
                    channel.glVertex(val + topH, pos - topBase2);
                    channel.glVertex(val + topH, pos + topBase2);
                    channel.glEnd();
                    channel.glBegin(2);
                    channel.glVertex(val + topH + gap, pos - bottomBase2);
                    channel.glVertex(val + h, pos - halfThick);
                    channel.glVertex(val + h, pos + halfThick);
                    channel.glVertex(val + topH + gap, pos + bottomBase2);
                    channel.glEnd();
                }
                channel.glPolygonMode(mode);
            }
        }
    }

    private double getHalfThickness(double thick) {
        if (thick > 1.0) {
            return Math.floor((thick - 1.0) * 0.5);
        }
        return 0.0;
    }

    private double getAdjustedArrowSize(double capSize, double lw, int capType) {
        switch (capType) {
            case 4: {
                if (lw <= 3.0) {
                    return capSize;
                }
                return capSize - lw / Math.sin(1.0471975511965976);
            }
            case 2: 
            case 3: 
            case 5: {
                if (lw <= 3.0) {
                    return capSize + 2.0;
                }
                return capSize;
            }
        }
        return capSize;
    }

    private double getMiterLength(double lw) {
        double miterLength = 0.0;
        if (lw > 1.0) {
            miterLength = lw - 1.0;
        }
        return miterLength;
    }

    private void removeNegativeWidthHeight(Rectangle2D.Double r) {
        if (r.width < 0.0) {
            r.x += r.width;
            r.width = -r.width;
        }
        if (r.height < 0.0) {
            r.y += r.height;
            r.height = -r.height;
        }
    }

    private static double lerp(double alpha, double d1, double d2) {
        double result = d1 + alpha * (d2 - d1);
        return result;
    }

    protected void drawHighLowBar(Channel channel, PropertyValueBlock pBlock, int valueIndex) {
        int i;
        boolean drawBar = pBlock.thick > 0.0;
        boolean drawPattern = drawBar && pBlock.fpOn;
        boolean clip = false;
        if (this.clipCapOn) {
            clip = this.clipHighLow(pBlock, this.clipMin, this.clipMax, drawBar);
        }
        this.computeRectangle(pBlock.pos, pBlock.sv, pBlock.ev, pBlock.thick, pBlock.vertical, this.fullSize, pBlock.hcapOn || pBlock.lcapOn);
        ArrayList x = new ArrayList();
        ArrayList y = new ArrayList();
        if (drawBar && (pBlock.hcapOn || pBlock.lcapOn || clip)) {
            this.computePolygon(pBlock, x, y);
        }
        if (pBlock.textureNeeded) {
            channel.glEnable(10);
        }
        channel.glPolygonMode(3);
        if (pBlock.fo && drawBar) {
            if (pBlock.go) {
                this.computeContextSensitiveGradientDirection(pBlock.gd, pBlock.sv, pBlock.ev, pBlock.vertical, pBlock.c1, pBlock.c2);
                channel.glRect(this.fullSize.x, this.fullSize.y, this.contextSensitiveGradient.c1, 1.0f, this.fullSize.x + this.fullSize.width, this.fullSize.y + this.fullSize.height, this.contextSensitiveGradient.c2, 1.0f, this.contextSensitiveGradient.direction);
            } else {
                channel.glColor(pBlock.c1);
                if (pBlock.hcapOn || pBlock.lcapOn) {
                    if (this.fullSize.height * this.fullSize.width == 0.0) {
                        channel.glLineWidth(1.0f);
                        channel.glDisable(6);
                        if (clip) {
                            this.drawHighLowLine(channel, pBlock.pos, pBlock.sv, pBlock.ev, pBlock.lcap, pBlock.hcap, pBlock.capThick, pBlock.ew, pBlock.vertical, false);
                        } else {
                            this.drawLineForZeroAreaPolygon(channel, pBlock.sv, pBlock.ev);
                        }
                        channel.glLineWidth((float)pBlock.ew);
                        channel.glEnable(6);
                        drawPattern = false;
                    } else {
                        if (this.getSkinType() != 0 && pBlock.fpOn) {
                            channel.glSkinRenderMode(3);
                            channel.glSkinImage(null);
                        }
                        channel.glBegin(2);
                        for (i = 0; i < x.size(); ++i) {
                            channel.glVertex(((Double)x.get(i)).doubleValue(), ((Double)y.get(i)).doubleValue());
                        }
                        channel.glEnd();
                        if (clip) {
                            this.drawClipArrow(channel, pBlock);
                        }
                        if (this.getSkinType() != 0 && pBlock.fpOn) {
                            channel.glSkinType(0);
                            channel.glPixelBenderImages(null);
                        }
                    }
                } else if (this.fullSize.height * this.fullSize.width == 0.0) {
                    channel.glLineWidth(1.0f);
                    channel.glDisable(6);
                    this.drawLineForZeroAreaRect(channel);
                    channel.glLineWidth((float)pBlock.ew);
                    channel.glEnable(6);
                    drawPattern = false;
                } else if (this.getSkinType() == 0) {
                    channel.glRect(this.fullSize.x, this.fullSize.y, this.fullSize.x + this.fullSize.width, this.fullSize.y + this.fullSize.height);
                } else {
                    if (pBlock.fpOn || this.getSkin() != null) {
                        channel.glSkinRenderMode(3);
                    } else {
                        channel.glSkinRenderMode(15);
                    }
                    channel.glRect(this.fullSize.x, this.fullSize.y, this.fullSize.x + this.fullSize.width, this.fullSize.y + this.fullSize.height);
                    if (pBlock.fpOn || this.getSkin() != null) {
                        channel.glSkinType(0);
                        channel.glPixelBenderImages(null);
                    }
                }
            }
        }
        if (drawPattern) {
            channel.glPolygonMode(8);
            channel.glColor(pBlock.fpc);
            channel.glFillPatternColor(pBlock.fpc);
            channel.glFillPatternType(pBlock.fpt);
            channel.glFillPatternWidth(pBlock.fpw);
            channel.glFillPatternScaleFactor(pBlock.fpsf);
            if (pBlock.hcapOn || pBlock.lcapOn) {
                channel.glBegin(2);
                for (i = 0; i < x.size(); ++i) {
                    channel.glVertex(((Double)x.get(i)).doubleValue(), ((Double)y.get(i)).doubleValue());
                }
                channel.glEnd();
                if (clip) {
                    this.drawClipArrow(channel, pBlock);
                }
            } else {
                if (this.getSkinType() != 0 && this.isSubpixelRendering()) {
                    channel.setSubpixelRendering(false);
                }
                channel.glRect(this.fullSize.x, this.fullSize.y, this.fullSize.x + this.fullSize.width, this.fullSize.y + this.fullSize.height);
                if (this.getSkinType() != 0 && this.isSubpixelRendering()) {
                    channel.setSubpixelRendering(true);
                }
            }
        }
        if (pBlock.fo && this.getSkinType() != 0 && (pBlock.fpOn || this.getSkin() != null) && (int)this.fullSize.height > 0 && (int)this.fullSize.width > 0) {
            channel.glPolygonMode(3);
            channel.glColor(pBlock.c1);
            channel.glSkinType(this.getSkinType());
            channel.glSkinImage(this.getSkin());
            channel.glSkinRenderMode(12);
            if (pBlock.hcapOn || pBlock.lcapOn) {
                if (pBlock.fpOn) {
                    channel.glBegin(2);
                    for (i = 0; i < x.size(); ++i) {
                        channel.glVertex(((Double)x.get(i)).doubleValue(), ((Double)y.get(i)).doubleValue());
                    }
                    channel.glEnd();
                    if (clip) {
                        this.drawClipArrow(channel, pBlock);
                    }
                }
            } else {
                if (this.getSkin() != null) {
                    int skinWidth = (int)Math.ceil(this.fullSize.width);
                    this.barSizedImage = new BufferedImage(skinWidth, (int)this.fullSize.height, 2);
                    Graphics2D graphics2D = this.barSizedImage.createGraphics();
                    graphics2D.drawImage(this.skin, 0, 0, skinWidth, (int)this.fullSize.height, null);
                    channel.glAlignment(0, 3);
                    channel.Image2D((java.awt.Image)this.barSizedImage, this.fullSize.x, this.fullSize.y, 0.0, (int)this.fullSize.width, (int)this.fullSize.height);
                }
                channel.glRect(this.fullSize.x, this.fullSize.y, this.fullSize.x + this.fullSize.width, this.fullSize.y + this.fullSize.height);
            }
        }
        if (pBlock.textureNeeded) {
            channel.glDisable(10);
        }
        if (pBlock.eo) {
            channel.glPolygonMode(2);
            channel.glColor(pBlock.ec);
            if (drawBar) {
                if (this.skinType == 0) {
                    if (pBlock.hcapOn || pBlock.lcapOn) {
                        if (this.fullSize.height * this.fullSize.width == 0.0) {
                            if (clip) {
                                this.drawHighLowLine(channel, pBlock.pos, pBlock.sv, pBlock.ev, pBlock.lcap, pBlock.hcap, pBlock.capThick, pBlock.ew, pBlock.vertical, false);
                            } else {
                                this.drawLineForZeroAreaPolygon(channel, pBlock.sv, pBlock.ev);
                            }
                        } else {
                            channel.glBegin(2);
                            for (i = 0; i < x.size(); ++i) {
                                channel.glVertex(((Double)x.get(i)).doubleValue(), ((Double)y.get(i)).doubleValue());
                            }
                            channel.glEnd();
                            if (clip) {
                                this.drawClipArrow(channel, pBlock);
                            }
                        }
                    } else if (this.fullSize.height * this.fullSize.width == 0.0) {
                        this.drawLineForZeroAreaRect(channel);
                    } else {
                        channel.glRect(this.fullSize.x, this.fullSize.y, this.fullSize.x + this.fullSize.width, this.fullSize.y + this.fullSize.height);
                    }
                }
            } else {
                if (channel.isSVGSelectionMode()) {
                    channel.setSVGSelectionText(this.userDataToString(valueIndex), false);
                }
                if (pBlock.sv == pBlock.ev) {
                    if (clip || this.capDisplayPolicy == CAP_DISPLAY_ALWAYS && (pBlock.lcap != 0 || pBlock.hcap != 0)) {
                        this.drawHighLowLine(channel, pBlock.pos, pBlock.sv, pBlock.ev, pBlock.lcap, pBlock.hcap, pBlock.capThick, pBlock.ew, pBlock.vertical, true);
                    } else {
                        this.drawLineIndicator(channel, pBlock.pos, pBlock.sv, pBlock.ev, pBlock.ew, pBlock.vertical);
                    }
                } else {
                    this.drawHighLowLine(channel, pBlock.pos, pBlock.sv, pBlock.ev, pBlock.lcap, pBlock.hcap, pBlock.capThick, pBlock.ew, pBlock.vertical, false);
                }
            }
        }
        if (pBlock.ho && pBlock.hp <= 1.0 && pBlock.hp >= 0.0) {
            channel.glColor(pBlock.hc);
            channel.glEdgeColor(pBlock.hc);
            this.computeRectangle(pBlock.pos, pBlock.sv, pBlock.sv + (pBlock.ev - pBlock.sv) * pBlock.hp, pBlock.thick, pBlock.vertical, this.fullSize, pBlock.hcapOn || pBlock.lcapOn);
            channel.glPolygonMode(6);
            channel.glLineWidth(2.0f);
            channel.glRect(this.fullSize.x, this.fullSize.y, this.fullSize.x + this.fullSize.width, this.fullSize.y + this.fullSize.height);
            channel.glLineWidth(1.0f);
            channel.glPolygonMode(3);
        }
        if (pBlock.openOn || pBlock.closeOn) {
            if (channel.isSVGSelectionMode()) {
                channel.setSVGSelectionText(this.userDataToString(valueIndex), false);
            }
            channel.glColor(pBlock.occ);
            channel.glLineWidth((float)pBlock.ocw);
            channel.glDisable(6);
            if (pBlock.openOn) {
                try {
                    pBlock.open = this.openValue.getValue(valueIndex);
                    if (!this.clipCapOn || pBlock.open >= this.clipMin && pBlock.open <= this.clipMax) {
                        channel.glBegin(1);
                        if (pBlock.vertical) {
                            channel.glVertex(this.fullSize.x - pBlock.ocThick, pBlock.open);
                            channel.glVertex(this.fullSize.x, pBlock.open);
                        } else {
                            channel.glVertex(pBlock.open, this.fullSize.y - pBlock.ocThick);
                            channel.glVertex(pBlock.open, this.fullSize.y);
                        }
                        channel.glEnd();
                    }
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            if (pBlock.closeOn) {
                try {
                    pBlock.close = this.closeValue.getValue(valueIndex);
                    if (!this.clipCapOn || pBlock.close >= this.clipMin && pBlock.close <= this.clipMax) {
                        channel.glBegin(1);
                        if (pBlock.vertical) {
                            channel.glVertex(this.fullSize.x + this.fullSize.width, pBlock.close);
                            channel.glVertex(this.fullSize.x + this.fullSize.width + pBlock.ocThick, pBlock.close);
                        } else {
                            channel.glVertex(pBlock.close, this.fullSize.y + this.fullSize.height);
                            channel.glVertex(pBlock.close, this.fullSize.y + this.fullSize.height + pBlock.ocThick);
                        }
                        channel.glEnd();
                    }
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
        }
    }

    private void drawLineForZeroAreaRect(Channel channel) {
        channel.glBegin(1);
        if (this.fullSize.height == 0.0) {
            channel.glVertex(this.fullSize.x, this.fullSize.y);
            channel.glVertex(this.fullSize.x + this.fullSize.width, this.fullSize.y);
        } else if (this.fullSize.width == 0.0) {
            channel.glVertex(this.fullSize.x, this.fullSize.y);
            channel.glVertex(this.fullSize.x, this.fullSize.y + this.fullSize.height);
        }
        channel.glEnd();
    }

    private void drawLineForZeroAreaPolygon(Channel channel, double sv, double ev) {
        channel.glBegin(1);
        if (this.fullSize.height == 0.0) {
            channel.glVertex(sv, this.fullSize.y);
            channel.glVertex(ev, this.fullSize.y);
        } else if (this.fullSize.width == 0.0) {
            channel.glVertex(this.fullSize.x, sv);
            channel.glVertex(this.fullSize.x, ev);
        }
        channel.glEnd();
    }

    private boolean clipHighLow(PropertyValueBlock pBlock, double clipMin, double clipMax, boolean isBar) {
        boolean clip = false;
        double min = Math.min(pBlock.sv, pBlock.ev);
        double max = Math.max(pBlock.sv, pBlock.ev);
        this.isClipHighCap = false;
        this.isClipLowCap = false;
        if (min >= clipMax) {
            pBlock.hcap = isBar ? 5 : this.clipCapShape;
            pBlock.lcap = 0;
            pBlock.hcapOn = true;
            pBlock.lcapOn = false;
            max = min = clipMax;
            clip = true;
            this.isClipHighCap = true;
        } else if (max <= clipMin) {
            pBlock.hcap = 0;
            pBlock.lcap = isBar ? 5 : this.clipCapShape;
            pBlock.hcapOn = false;
            pBlock.lcapOn = true;
            max = min = clipMin;
            clip = true;
            this.isClipLowCap = true;
        } else {
            if (max > clipMax) {
                max = clipMax;
                pBlock.hcap = isBar ? 5 : this.clipCapShape;
                pBlock.hcapOn = true;
                clip = true;
                this.isClipHighCap = true;
            }
            if (min < clipMin) {
                min = clipMin;
                pBlock.lcap = isBar ? 5 : this.clipCapShape;
                pBlock.lcapOn = true;
                clip = true;
                this.isClipLowCap = true;
            }
        }
        if (pBlock.ev >= pBlock.sv) {
            pBlock.ev = max;
            pBlock.sv = min;
        } else {
            pBlock.ev = min;
            pBlock.sv = max;
        }
        return clip;
    }

    private void drawLineIndicator(Channel channel, double pos, double sv, double ev, double thick, boolean vertical) {
        channel.glLineWidth(1.0f);
        channel.glDisable(6);
        double half = thick * 0.5;
        channel.glBegin(1);
        if (vertical) {
            channel.glVertex(pos - half, sv);
            channel.glVertex(pos + half, ev);
        } else {
            channel.glVertex(sv, pos - half);
            channel.glVertex(ev, pos + half);
        }
        channel.glEnd();
        channel.glLineWidth((float)thick);
    }

    private void computeContextSensitiveGradientDirection(int gd, double sv, double ev, boolean vertical, Color c1, Color c2) {
        this.contextSensitiveGradient.direction = gd;
        this.contextSensitiveGradient.c1 = c1;
        this.contextSensitiveGradient.c2 = c2;
        boolean swapColors = false;
        if (vertical) {
            switch (gd) {
                case 0: {
                    break;
                }
                case 3: {
                    if (!(ev < sv)) break;
                    this.contextSensitiveGradient.direction = 2;
                    break;
                }
                case 2: {
                    if (!(ev < sv)) break;
                    this.contextSensitiveGradient.direction = 3;
                    break;
                }
                case 1: {
                    if (!(ev < sv)) break;
                    swapColors = true;
                }
            }
        } else {
            switch (gd) {
                case 1: {
                    this.contextSensitiveGradient.direction = 0;
                    if (!(ev > sv)) break;
                    swapColors = true;
                    break;
                }
                case 3: {
                    if (!(ev > sv)) break;
                    this.contextSensitiveGradient.direction = 2;
                    swapColors = true;
                    break;
                }
                case 2: {
                    if (ev < sv) {
                        swapColors = true;
                        break;
                    }
                    this.contextSensitiveGradient.direction = 3;
                    break;
                }
                case 0: {
                    this.contextSensitiveGradient.direction = 1;
                }
            }
        }
        if (swapColors) {
            this.contextSensitiveGradient.c1 = c2;
            this.contextSensitiveGradient.c2 = c1;
        }
    }

    protected float getPolygonOffsetFactor() {
        return this.polygonOffsetFactor;
    }

    protected void setPolygonOffsetFactor(float polygonOffsetFactor) {
        this.polygonOffsetFactor = polygonOffsetFactor;
    }

    protected float getPolygonOffsetUnits() {
        return this.polygonOffsetUnits;
    }

    protected void setPolygonOffsetUnits(float polygonOffsetUnits) {
        this.polygonOffsetUnits = polygonOffsetUnits;
    }

    protected PropertyValueBlock getPropertyValueBlock() {
        return this.propertyValueBlock;
    }

    protected int getMyValueCount() {
        return this.myValueCount;
    }

    protected void setMyValueCount(int myValueCount) {
        if (myValueCount == -1) {
            myValueCount = 1;
        }
        this.myValueCount = myValueCount;
    }

    protected List getDrawOrderList() {
        if (this.drawOrderList == null) {
            this.drawOrderList = new ArrayList();
        }
        return this.drawOrderList;
    }

    protected Comparator getPositionComparator() {
        if (this.positionComparator == null) {
            this.positionComparator = new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    BaseBar.BarInfo bi0 = (BaseBar.BarInfo)arg0;
                    BaseBar.BarInfo bi1 = (BaseBar.BarInfo)arg1;
                    return Double.compare(bi0.categoryPosition, bi1.categoryPosition);
                }
            };
        }
        return this.positionComparator;
    }

    protected Comparator getStackComparator() {
        if (this.stackComparator == null) {
            this.stackComparator = new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    BaseBar.BarInfo bi0 = (BaseBar.BarInfo)arg0;
                    BaseBar.BarInfo bi1 = (BaseBar.BarInfo)arg1;
                    if (bi0.categoryPosition == bi1.categoryPosition) {
                        return Double.compare(bi0.middle, bi1.middle);
                    }
                    return 0;
                }
            };
        }
        return this.stackComparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        boolean subpixel;
        Channel channel = (Channel)buildAction.getGraphicsContext();
        if (!this.transform.isIdentity()) {
            channel.glPopMatrix();
        }
        if (!(subpixel = channel.isSubpixelRendering()) && this.isSubpixelRendering()) {
            channel.setSubpixelRendering(this.isSubpixelRendering());
        }
        BaseBar.BarInfo bi = null;
        for (int i = 0; i < this.getMyValueCount(); ++i) {
            int valueIndex = i;
            boolean isIdentity = this.transform.isIdentity();
            try {
                if (!isIdentity) {
                    buildAction.setValueIndex(valueIndex);
                    this.transform.push(buildAction);
                    this.transform.apply(buildAction);
                }
                PropertyValueBlock pBlock = this.loadPropertyValueBlock(bi, valueIndex, i);
                this.setGLAttributes(channel, pBlock);
                if (buildAction.isUseNameStack()) {
                    channel.glPopName();
                    channel.glLoadName((Object)new SelectEntry(this, valueIndex));
                    channel.glPushName(null);
                    if (channel.isSVGSelectionMode()) {
                        channel.setSVGSelectionText(this.userDataToString(valueIndex));
                    }
                }
                if (pBlock.ev >= pBlock.sv) {
                    this.drawHighLowBar(channel, pBlock, valueIndex);
                }
            }
            catch (MissingValueException missingValueException) {
            }
            finally {
                if (!isIdentity) {
                    this.transform.pop(buildAction);
                }
            }
            channel.glDisable(10);
            channel.glDisable(6);
            channel.glSkinType(0);
            channel.glSkinImage(null);
            channel.glPixelBenderImages(null);
            channel.glSkinCategory(0);
            channel.glSkinRenderMode(15);
        }
        if (!this.transform.isIdentity()) {
            channel.glPushMatrix();
        }
        channel.setSubpixelRendering(subpixel);
        if (channel.isSVGSelectionMode()) {
            channel.clearSVGSelectionText();
        }
    }

    private void setGLAttributes(Channel channel, PropertyValueBlock pBlock) {
        channel.glEdgeColor(pBlock.ec);
        channel.glPolygonMode(BuildAction.getGLFillStyle(pBlock.fo, pBlock.eo));
        channel.glLineWidth((float)pBlock.ew);
        if (pBlock.ep >= 0) {
            channel.glEnable(6);
            channel.glLineStipple((int)(0.5 + this.stippleScaleFactor * (double)SASLinePatterns.getStippleFactor((int)pBlock.ep)), SASLinePatterns.getStipplePattern((int)pBlock.ep));
        }
        BufferedImage[] texImage = this.getTextureImage();
        boolean bl = pBlock.textureNeeded = pBlock.texOn && pBlock.fo && texImage != null && texImage.length > 0;
        if (pBlock.textureNeeded) {
            if (pBlock.ti < 0 || pBlock.ti > texImage.length - 1) {
                pBlock.ti = 0;
            }
            channel.glTexImage2D((java.awt.Image)texImage[pBlock.ti]);
            channel.glTexEnv(10, 1, pBlock.tm);
            channel.glTexEnv(10, 2, pBlock.ts);
        }
        channel.glSkinType(this.getSkinType());
        if (pBlock.thick > 0.0) {
            channel.glSkinImage(this.getSkin());
            channel.glPixelBenderImages(this.getPixelBenderImages());
        }
        channel.glDPIScaleFactor((float)this.stippleScaleFactor);
        channel.glSkinCategory(pBlock.vertical ? 1 : 2);
    }

    private PropertyValueBlock loadPropertyValueBlock(BaseBar.BarInfo bi, int valueIndex, int loopIndex) throws MissingValueException {
        PropertyValueBlock pBlock = this.getPropertyValueBlock();
        try {
            pBlock.pos = this.position.getValue(valueIndex);
            pBlock.sv = this.startValue.getValue(valueIndex);
            pBlock.ev = this.endValue.getValue(valueIndex);
            pBlock.hcap = this.highCap.getValue(valueIndex);
            pBlock.lcap = this.lowCap.getValue(valueIndex);
            pBlock.openOn = this.openOn.getValue(valueIndex);
            pBlock.closeOn = this.closeOn.getValue(valueIndex);
            pBlock.hcapOn = this.highCapOn.getValue(valueIndex);
            pBlock.lcapOn = this.lowCapOn.getValue(valueIndex);
            pBlock.vertical = this.verticalOn.getValue(valueIndex);
            pBlock.thick = this.thickness.getValue(valueIndex);
            pBlock.ocThick = this.openCloseThickness.getValue(valueIndex);
            pBlock.ocw = this.openCloseWidth.getValue(valueIndex);
            pBlock.occ = this.openCloseColor.getValue(valueIndex);
            pBlock.capThick = this.capThickness.getValue(valueIndex);
            pBlock.c1 = this.color1.getValue(valueIndex);
            pBlock.c2 = this.color2.getValue(valueIndex);
            pBlock.ec = this.edgeColor.getValue(valueIndex);
            pBlock.ew = this.edgeWidth.getValue(valueIndex);
            pBlock.ep = this.edgePattern.getValue(valueIndex);
            pBlock.fo = this.fillOn.getValue(valueIndex);
            pBlock.eo = this.edgeOn.getValue(valueIndex);
            pBlock.hc = this.highlightFillColor.getValue(valueIndex);
            pBlock.hec = this.highlightEdgeColor.getValue(valueIndex);
            pBlock.hp = this.highlightPercentage.getValue(valueIndex);
            pBlock.ho = this.highlightOn.getValue(valueIndex);
            pBlock.go = this.gradientOn.getValue(valueIndex);
            pBlock.gd = this.gradientDirection.getValue(valueIndex);
            pBlock.texOn = this.textureOn.getValue(valueIndex);
            pBlock.tm = this.textureMode.getValue(valueIndex);
            pBlock.ts = this.textureStyle.getValue(valueIndex);
            pBlock.ti = this.textureIndex.getValue(valueIndex);
            pBlock.fpOn = this.fillPatternOn.getValue(valueIndex);
            pBlock.fpt = this.fillPatternType.getValue(valueIndex);
            pBlock.fpc = this.fillPatternColor.getValue(valueIndex);
            pBlock.fpw = this.fillPatternWidth.getValue(valueIndex);
            pBlock.fpsf = this.fillPatternScaleFactor.getValue(valueIndex);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Problem loading bar properties.", e);
        }
        return pBlock;
    }

    public void setStippleScaleFactor(double fac) {
        this.stippleScaleFactor = fac;
    }

    public double getStippleScaleFactor() {
        return this.stippleScaleFactor;
    }

    public void setCapDisplayPolicy(int policy) {
        this.capDisplayPolicy = policy;
    }

    public int getCapDisplayPolicy() {
        return this.capDisplayPolicy;
    }

    public void setClipCapShape(int shape) {
        this.clipCapShape = shape;
    }

    public int getClipCapShape() {
        return this.clipCapShape;
    }

    public void setClipCapOn(boolean b) {
        this.clipCapOn = b;
    }

    public boolean isClipCapOn() {
        return this.clipCapOn;
    }

    public void setClipMin(double min) {
        this.clipMin = min;
    }

    public double getClipMin() {
        return this.clipMin;
    }

    public void setClipMax(double max) {
        this.clipMax = max;
    }

    public double getClipMax() {
        return this.clipMax;
    }

    public void setSubpixelRendering(boolean b) {
        this.subpixelRendering = b;
    }

    public boolean isSubpixelRendering() {
        return this.subpixelRendering;
    }

    private static class GradientDefinition {
        public int direction;
        public Color c1;
        public Color c2;

        private GradientDefinition() {
        }
    }

    protected static class PropertyValueBlock {
        public double pos;
        public double sv;
        public double ev;
        public boolean openOn;
        public boolean closeOn;
        public double open;
        public double close;
        public boolean hcapOn;
        public boolean lcapOn;
        public int hcap;
        public int lcap;
        public boolean vertical;
        public double thick;
        public double ocThick;
        public double ocw;
        public Color occ;
        public double capThick;
        public boolean fo;
        public Color c1;
        public Color c2;
        public boolean eo;
        public Color ec;
        public double ew;
        public int ep;
        public boolean ho;
        public Color hc;
        public Color hec;
        public double hp;
        public boolean go;
        public int gd;
        public boolean texOn;
        public int tm;
        public int ts;
        public int ti;
        public boolean fpOn;
        public int fpt;
        public Color fpc;
        public double fpw;
        public double fpsf;
        public boolean textureNeeded;

        protected PropertyValueBlock() {
        }
    }
}

