/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.AGrid;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.GridStyle;
import com.sas.graphics.util.gtk.LineStyle;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.Image;
import com.sas.graphics.util.gtk.gl.LineSegment;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;

public class Grid
extends AGrid {
    protected Channel channel;

    public Grid() {
        super(new Transform());
    }

    public Grid(Vec3d normal) {
        this();
        this.setNormal(normal);
    }

    @Override
    public void render(ABuildAction buildAction) {
        double zNormalComponent;
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        this.channel = ba.getChannel();
        this.channel.glPushMatrix();
        if (!ATransform.isZero(this.normal.x)) {
            zNormalComponent = -this.normal.x;
            this.channel.glRotate(-90.0, 0.0, 1.0, 0.0);
        } else if (!ATransform.isZero(this.normal.y)) {
            zNormalComponent = -this.normal.y;
            this.channel.glRotate(90.0, 1.0, 0.0, 0.0);
        } else {
            zNormalComponent = this.normal.z;
        }
        if (this.style.isBackgroundOn()) {
            if (this.style.getBackgroundImage() != null) {
                Image.drawImage(this.channel, this.style.getBackgroundImage(), 0, 3, 1, true, this.getWidth(), this.getHeight(), this.style.getBackgroundColor());
            } else {
                this.drawBackground(this.backgroundHorizontalOrigin, this.backgroundVerticalOrigin, 0.0, this.backgroundHorizontalOrigin + this.getWidth(), this.backgroundVerticalOrigin + this.getHeight(), 0.0, 0.0, 0.0, zNormalComponent, this.style);
            }
        }
        if (this.style.getHorizontalMajorLineStyle().isVisible() || this.style.getHorizontalMinorLineStyle().isVisible()) {
            this.renderHorizontalGridLines();
        }
        if (this.style.getVerticalMajorLineStyle().isVisible() || this.style.getVerticalMinorLineStyle().isVisible()) {
            this.renderVerticalGridLines();
        }
        if (this.style.isBorderOn()) {
            this.drawBorder(this.backgroundHorizontalOrigin, this.backgroundVerticalOrigin, this.backgroundHorizontalOrigin + this.getWidth(), this.backgroundVerticalOrigin + this.getHeight());
        }
        this.channel.glPopMatrix();
    }

    private void renderHorizontalGridLines() {
        int i;
        LineStyle ls;
        int index = 0;
        double prevOffset = this.horizontalOrigin;
        int numOfMinGrids = this.style.getMinorGridLineCount();
        prevOffset = this.verticalOrigin;
        double yClipStartValue = this.yClipStart.getValue();
        double yClipEndValue = this.yClipEnd.getValue();
        boolean connected = this.horizontalLineOffset.isConnected();
        double offset = this.horizontalLineOffset.getValue();
        if (!connected && offset > 0.0) {
            this.horizontalLineCount = (int)(this.getHeight() / offset) - 1;
        }
        offset += prevOffset;
        for (index = 0; index < this.horizontalLineCount; ++index) {
            try {
                double minTicDelta;
                if (connected) {
                    offset = this.horizontalLineOffset.getValue(index);
                }
                if (offset < yClipStartValue || offset > yClipEndValue) continue;
                if (this.style.getHorizontalMajorLineStyle().isVisible()) {
                    LineStyle ls2 = this.style.getHorizontalMajorLineStyle();
                    this.drawHorizontalMajorLine(this.horizontalOrigin, offset, this.horizontalOrigin + this.getWidth(), offset, ls2.getWidth(), ls2.getColor(), ls2.getStipplePattern(), ls2.getStippleFactor());
                }
                if (this.style.getHorizontalMinorLineStyle().isVisible() && (minTicDelta = (offset - prevOffset) / (double)(numOfMinGrids + 1)) != 0.0) {
                    ls = this.style.isLinkedLineAttributes() ? this.style.getHorizontalMajorLineStyle() : this.style.getHorizontalMinorLineStyle();
                    for (i = 1; i <= numOfMinGrids; ++i) {
                        this.drawHorizontalMinorLine(this.horizontalOrigin, prevOffset + minTicDelta * (double)i, this.horizontalOrigin + this.getWidth(), prevOffset + minTicDelta * (double)i, ls.getWidth(), ls.getColor(), ls.getStipplePattern(), ls.getStippleFactor());
                    }
                }
                prevOffset = offset;
                if (connected) continue;
                offset += this.horizontalLineOffset.getValue();
                continue;
            }
            catch (MissingValueException minTicDelta) {
                // empty catch block
            }
        }
        if (this.style.getHorizontalMinorLineStyle().isVisible() && this.verticalOrigin + this.getHeight() > prevOffset) {
            double minTicDelta = (this.getHeight() - prevOffset) / (double)(numOfMinGrids + 1);
            ls = this.style.isLinkedLineAttributes() ? this.style.getHorizontalMajorLineStyle() : this.style.getHorizontalMinorLineStyle();
            for (i = 1; i <= numOfMinGrids; ++i) {
                this.drawHorizontalMinorLine(this.horizontalOrigin, prevOffset + minTicDelta * (double)i, this.horizontalOrigin + this.getWidth(), prevOffset + minTicDelta * (double)i, ls.getWidth(), ls.getColor(), ls.getStipplePattern(), ls.getStippleFactor());
            }
        }
    }

    private void renderVerticalGridLines() {
        int i;
        LineStyle ls;
        int index = 0;
        double prevOffset = this.horizontalOrigin;
        int numOfMinGrids = this.style.getMinorGridLineCount();
        boolean connected = this.verticalLineOffset.isConnected();
        double offset = this.verticalLineOffset.getValue();
        if (!connected && offset > 0.0) {
            this.verticalLineCount = (int)(this.getWidth() / offset) - 1;
        }
        offset += prevOffset;
        for (index = 0; index < this.verticalLineCount; ++index) {
            try {
                if (connected) {
                    offset = this.verticalLineOffset.getValue(index);
                }
                if (this.style.getVerticalMajorLineStyle().isVisible()) {
                    LineStyle ls2 = this.style.isLinkedLineAttributes() ? this.style.getHorizontalMajorLineStyle() : this.style.getVerticalMajorLineStyle();
                    this.drawVerticalMajorLine(offset, this.verticalOrigin, offset, this.getHeight() + this.verticalOrigin, ls2.getWidth(), ls2.getColor(), ls2.getStipplePattern(), ls2.getStippleFactor());
                }
                if (this.style.getVerticalMinorLineStyle().isVisible()) {
                    double minTicDelta = (offset - prevOffset) / (double)(numOfMinGrids + 1);
                    LineStyle lineStyle = ls = this.style.isLinkedLineAttributes() ? this.style.getHorizontalMajorLineStyle() : this.style.getVerticalMinorLineStyle();
                    if (minTicDelta != 0.0) {
                        for (i = 1; i <= numOfMinGrids; ++i) {
                            this.drawVerticalMinorLine(prevOffset + minTicDelta * (double)i, this.verticalOrigin, prevOffset + minTicDelta * (double)i, this.getHeight() + this.verticalOrigin, ls.getWidth(), ls.getColor(), ls.getStipplePattern(), ls.getStippleFactor());
                        }
                    }
                }
                prevOffset = offset;
                if (connected) continue;
                offset += this.verticalLineOffset.getValue();
                continue;
            }
            catch (MissingValueException minTicDelta) {
                // empty catch block
            }
        }
        if (this.style.isVerticalMinorLinesOn() && this.horizontalOrigin + this.getWidth() > prevOffset) {
            double minTicDelta = (this.horizontalOrigin + this.getWidth() - prevOffset) / (double)(numOfMinGrids + 1);
            ls = this.style.isLinkedLineAttributes() ? this.style.getHorizontalMajorLineStyle() : this.style.getVerticalMinorLineStyle();
            for (i = 1; i <= numOfMinGrids; ++i) {
                this.drawVerticalMinorLine(prevOffset + minTicDelta * (double)i, this.verticalOrigin, prevOffset + minTicDelta * (double)i, this.getHeight() + this.verticalOrigin, ls.getWidth(), ls.getColor(), ls.getStipplePattern(), ls.getStippleFactor());
            }
        }
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) {
        Vec3d size = bBoxAction.pt1;
        Vec3d center = bBoxAction.pt2;
        size.x = this.getWidth();
        size.y = this.getHeight();
        size.z = 0.0;
        center.x = this.horizontalOrigin + this.getWidth() / 2.0;
        center.y = this.getHeight() / 2.0;
        center.z = 0.0;
        if (!ATransform.isZero(this.normal.x)) {
            center.z = center.x;
            center.x = 0.0;
            size.z = size.x;
            size.x = 0.0;
        } else if (!ATransform.isZero(this.normal.y)) {
            center.z = center.y;
            center.y = 0.0;
            size.z = size.y;
            size.y = 0.0;
        }
        BoundingBox bb = new BoundingBox();
        bb.setCenter(center);
        bb.setSize(size);
        BoundingBox box = bBoxAction.getElementBoundingBox();
        box.union(bb);
        bBoxAction.unionProjection(bb);
    }

    @Override
    protected void drawVerticalMajorLine(double beginX, double beginY, double endX, double endY, int w, Color color, int stipplePattern, int stippleFactor) {
        LineSegment.drawLineSegment(this.channel, beginX, beginY, 0.0, endX, endY, 0.0, color, w, stipplePattern, stippleFactor);
    }

    @Override
    protected void drawVerticalMinorLine(double beginX, double beginY, double endX, double endY, int w, Color color, int stipplePattern, int stippleFactor) {
        LineSegment.drawLineSegment(this.channel, beginX, beginY, 0.0, endX, endY, 0.0, color, w, stipplePattern, stippleFactor);
    }

    @Override
    protected void drawHorizontalMajorLine(double beginX, double beginY, double endX, double endY, int w, Color color, int stipplePattern, int stippleFactor) {
        LineSegment.drawLineSegment(this.channel, beginX, beginY, 0.0, endX, endY, 0.0, color, w, stipplePattern, stippleFactor);
    }

    @Override
    protected void drawHorizontalMinorLine(double beginX, double beginY, double endX, double endY, int w, Color color, int stipplePattern, int stippleFactor) {
        LineSegment.drawLineSegment(this.channel, beginX, beginY, 0.0, endX, endY, 0.0, color, w, stipplePattern, stippleFactor);
    }

    @Override
    protected void drawBackground(double llx, double lly, double llz, double urx, double ury, double urz, double normalx, double normaly, double normalz, GridStyle gridStyle) {
        this.channel.glPushAttrib(0);
        this.channel.glPolygonMode(3);
        if (gridStyle.isGradientOn()) {
            this.channel.glRect(llx, lly, gridStyle.getBackgroundColor(), (float)gridStyle.getBackgroundColor().getAlpha() / 255.0f, urx, ury, gridStyle.getBackgroundColor2(), (float)gridStyle.getBackgroundColor2().getAlpha() / 255.0f, gridStyle.getGradientDirection());
        } else {
            this.channel.glColor(gridStyle.getBackgroundColor());
            this.channel.glBegin(2);
            this.channel.glNormal(normalx, normaly, normalz);
            if (normalz > 0.0) {
                this.channel.glVertex(llx, lly, llz);
                this.channel.glVertex(urx, lly, urz);
                this.channel.glVertex(urx, ury, urz);
                this.channel.glVertex(llx, ury, llz);
            } else {
                this.channel.glVertex(llx, lly, llz);
                this.channel.glVertex(llx, ury, llz);
                this.channel.glVertex(urx, ury, urz);
                this.channel.glVertex(urx, lly, urz);
            }
            this.channel.glEnd();
        }
        this.channel.glPopAttrib();
    }

    protected void drawBorder(double llx, double lly, double urx, double ury) {
        boolean stippleNeeded;
        LineStyle ls = this.style.isLinkedLineAttributes() ? this.style.getHorizontalMajorLineStyle() : this.style.getBorderLineStyle();
        int stippleFac = ls.getStippleFactor();
        int stipplePat = ls.getStipplePattern();
        boolean bl = stippleNeeded = stippleFac > 0 && (stipplePat & 0xFFFF) != 65535;
        if (stippleNeeded) {
            this.channel.glEnable(6);
            this.channel.glLineStipple(stippleFac, (int)((short)stipplePat));
        }
        if (this.channel.getBackbufferId() == -1) {
            this.channel.glColor(ls.getColor());
            this.channel.glLineWidth((float)ls.getWidth());
            this.channel.glBegin(1);
            this.channel.glVertex(llx, lly);
            this.channel.glVertex(urx, lly);
            this.channel.glVertex(urx, ury);
            this.channel.glVertex(llx, ury);
            this.channel.glVertex(llx, lly);
            this.channel.glEnd();
        } else {
            this.channel.glColor(ls.getColor());
            this.channel.glLineWidth((float)ls.getWidth());
            this.channel.glPolygonMode(2);
            this.channel.glBegin(2);
            this.channel.glVertex(llx, lly);
            this.channel.glVertex(urx, lly);
            this.channel.glVertex(urx, ury);
            this.channel.glVertex(llx, ury);
            this.channel.glEnd();
        }
        if (stippleNeeded) {
            this.channel.glDisable(6);
        }
    }
}

