/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Plane;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.Transform;
import java.util.Enumeration;
import java.util.Vector;

public class CuttingPlane
extends Element {
    private BoundingBox boundingBox;
    private Plane plane;
    private Vec3d[] boxPoints;
    private Vec3d normal;
    private Vec3d[] planePoints;
    private static final int[] caseMask = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    public final ColorProperty color = new ColorProperty(this, false);
    public final ColorProperty edgeColor = new ColorProperty(this, false);
    public final BooleanProperty edgeOn = new BooleanProperty(this, true);
    public final BooleanProperty fillOn = new BooleanProperty(this, true);

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
        this.setModified();
    }

    public Plane getPlane() {
        return this.plane;
    }

    public void setPlane(Plane plane) {
        this.plane = plane;
        this.setModified();
    }

    public CuttingPlane() {
        this(new Transform());
    }

    private CuttingPlane(ATransform aTransform) {
        super(aTransform);
        this.edgeOn.setValue(false);
        this.fillOn.setValue(true);
    }

    @Override
    protected void render(ABuildAction buildAction) throws MissingValueException {
        Channel ch = (Channel)buildAction.getGraphicsContext();
        int index = buildAction.getValueIndex();
        if (this.planePoints == null || this.normal == null) {
            return;
        }
        ch.glPushAttrib(0);
        ch.glColor(this.color.getValue(index));
        ch.glEdgeColor(this.edgeColor.getValue(index));
        ch.glPolygonMode(BuildAction.getGLFillStyle(this.fillOn.getValue(index), this.edgeOn.getValue(index)));
        ch.glNormal(this.normal.x, this.normal.y, this.normal.z);
        ch.glBegin(2);
        for (int i = 0; i < this.planePoints.length; ++i) {
            ch.glVertex(this.planePoints[i].x, this.planePoints[i].y, this.planePoints[i].z);
        }
        ch.glEnd();
        ch.glPopAttrib();
    }

    @Override
    protected void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
    }

    @Override
    public void init(AInitAction initAction) {
        initAction.pushValueCount();
        super.init(initAction);
        initAction.popValueCount();
        this.setValueCount(1);
        initAction.setValueCount(1);
        if (!initAction.beenInitialized(this)) {
            this.computeVerticies();
        }
    }

    private void computeVerticies() {
        int i;
        if (this.plane == null || this.boundingBox == null) {
            return;
        }
        Vec3d min = this.boundingBox.getMinimum();
        Vec3d max = this.boundingBox.getMaximum();
        this.boxPoints = new Vec3d[8];
        this.boxPoints[0] = new Vec3d(min.x, min.y, min.z);
        this.boxPoints[1] = new Vec3d(max.x, min.y, min.z);
        this.boxPoints[2] = new Vec3d(max.x, max.y, min.z);
        this.boxPoints[3] = new Vec3d(min.x, max.y, min.z);
        this.boxPoints[4] = new Vec3d(min.x, min.y, max.z);
        this.boxPoints[5] = new Vec3d(max.x, min.y, max.z);
        this.boxPoints[6] = new Vec3d(max.x, max.y, max.z);
        this.boxPoints[7] = new Vec3d(min.x, max.y, max.z);
        int mcCase = this.getMCCase();
        Vector segments = new Vector(6);
        this.storeLineSegments(0, 1, 2, 3, segments, mcCase);
        this.storeLineSegments(4, 5, 6, 7, segments, mcCase);
        this.storeLineSegments(0, 1, 5, 4, segments, mcCase);
        this.storeLineSegments(1, 2, 6, 5, segments, mcCase);
        this.storeLineSegments(2, 3, 7, 6, segments, mcCase);
        this.storeLineSegments(3, 0, 4, 7, segments, mcCase);
        if (segments.size() < 3) {
            return;
        }
        this.planePoints = new Vec3d[segments.size()];
        Vec3d[] nextSeg = (Vec3d[])segments.get(0);
        this.planePoints[0] = nextSeg[0];
        for (i = 1; i < this.planePoints.length && nextSeg != null; ++i) {
            this.planePoints[i] = this.planePoints[i - 1].equals((Object)nextSeg[0]) ? nextSeg[1] : nextSeg[0];
            segments.remove(nextSeg);
            nextSeg = this.findSegment(segments, this.planePoints[i]);
        }
        if (i < this.planePoints.length) {
            this.planePoints = null;
            this.normal = null;
            return;
        }
        Vec3d vec1 = Vec3d.subtract((Vec3d)this.planePoints[0], (Vec3d)this.planePoints[1]);
        Vec3d vec2 = Vec3d.subtract((Vec3d)this.planePoints[1], (Vec3d)this.planePoints[2]);
        this.normal = vec1.cross(vec2);
        this.normal.normalize();
    }

    private int getMCCase() {
        int[] caseMask = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        int caseVal = 0;
        for (int i = 0; i < 8; ++i) {
            if (!this.plane.isOnPositiveSide(this.boxPoints[i])) continue;
            caseVal |= caseMask[i];
        }
        return caseVal;
    }

    private void storeLineSegments(int idx0, int idx1, int idx2, int idx3, Vector lineSegments, int mcCase) {
        if (lineSegments == null) {
            return;
        }
        int pt0Bit = (mcCase & caseMask[idx0]) >> idx0;
        int pt1Bit = (mcCase & caseMask[idx1]) >> idx1;
        int pt2Bit = (mcCase & caseMask[idx2]) >> idx2;
        int pt3Bit = (mcCase & caseMask[idx3]) >> idx3;
        Vec3d intersection = null;
        Vec3d[] segment = null;
        if ((pt0Bit ^ pt1Bit) == 1) {
            intersection = this.getPlaneIntersection(idx0, idx1);
            segment = new Vec3d[2];
            segment[0] = intersection;
        }
        if ((pt1Bit ^ pt2Bit) == 1) {
            intersection = this.getPlaneIntersection(idx1, idx2);
            if (segment == null) {
                segment = new Vec3d[2];
                segment[0] = intersection;
            } else {
                segment[1] = intersection;
            }
        }
        if ((pt2Bit ^ pt3Bit) == 1) {
            intersection = this.getPlaneIntersection(idx2, idx3);
            if (segment == null) {
                segment = new Vec3d[2];
                segment[0] = intersection;
            } else {
                segment[1] = intersection;
            }
        }
        if ((pt3Bit ^ pt0Bit) == 1) {
            intersection = this.getPlaneIntersection(idx3, idx0);
            if (segment == null) {
                segment = new Vec3d[2];
                segment[0] = intersection;
            } else {
                segment[1] = intersection;
            }
        }
        if (segment != null && segment[0] != null && segment[1] != null && !segment[0].equals((Object)segment[1])) {
            lineSegments.add(segment);
        }
    }

    private Vec3d[] findSegment(Vector segments, Vec3d point) {
        Enumeration e = segments.elements();
        while (e.hasMoreElements()) {
            Vec3d[] seg = (Vec3d[])e.nextElement();
            if (!seg[0].equals((Object)point) && !seg[1].equals((Object)point)) continue;
            return seg;
        }
        return null;
    }

    private Vec3d getPlaneIntersection(int idx1, int idx2) {
        if (idx1 < idx2) {
            return this.plane.getPointOfIntersection(this.boxPoints[idx1], this.boxPoints[idx2]);
        }
        return this.plane.getPointOfIntersection(this.boxPoints[idx2], this.boxPoints[idx1]);
    }
}

