/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.AxisMetrics;
import com.sas.graphics.util.gtk.AxisStyle;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.LegendStyle;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringProperty;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.TickMarkStyle;
import com.sas.graphics.util.gtk.gl.ColorRampLegendStyle;
import com.sas.graphics.util.gtk.gl.Composite;
import com.sas.graphics.util.gtk.gl.InitAction;
import com.sas.graphics.util.gtk.gl.Legend;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RectangularAxis;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class ColorRampLegend
extends Composite {
    public static final int POSITION_TOP = 0;
    public static final int POSITION_BOTTOM = 1;
    public static final int POSITION_LEFT = 2;
    public static final int POSITION_RIGHT = 3;
    public final StringProperty title = new StringProperty(this, true);
    public final StringProperty labels = new StringProperty(this, false);
    public final NumericProperty rampPercentage;
    public final NumericProperty labelPlacementPercentage = this.rampPercentage = new NumericProperty(this, false);
    public final ColorProperty colors = new ColorProperty(this, false);
    public final NumericProperty colorPlacementPercentage = new NumericProperty(this, false);
    public final StringProperty missingLabels = new StringProperty(this, false);
    public final ColorProperty missingColors = new ColorProperty(this, false);
    private double length = 1.0;
    private double axisLength = 0.0;
    private double titleHeight = 0.0;
    private boolean primary = true;
    private Channel channel;
    private NumericVector labelOffset;
    private Composite composite = new Composite();
    private RectangularAxis axis = new RectangularAxis();
    private Legend legendBackground = new Legend();
    private Legend legend = new Legend();
    private MissingValuesElement missingValues = new MissingValuesElement();
    private ColorRampLegendStyle style = new ColorRampLegendStyle(this.axis, this.legend, this.legendBackground);
    private Vec3d missingValuesSize;
    private double legendThickness;
    private double fontHeight;
    private static final int BORDER_SIZE = 5;
    private int titleTruncateEndCount = -1;
    private boolean dropAxisAsNeeded = false;
    private boolean axisDropped = false;
    private static final EmptyColorPipe EMPTY_COLOR_PIPE = new EmptyColorPipe();
    private static final EmptyStringPipe EMPTY_STRING_PIPE = new EmptyStringPipe();

    public ColorRampLegend() {
        this.addElement(this.composite);
        this.composite.addElement(this.legendBackground);
        this.composite.addElement(this.axis);
        this.composite.addElement(this.legend);
        this.composite.addElement(this.missingValues);
        this.legendBackground.getStyle().setBackgroundOn(false);
        this.legendBackground.getStyle().setBorderOn(false);
        this.axis.setFitAlgorithm(new String[]{"thinkeepend"});
    }

    @Override
    public void init(AInitAction initAction) {
        this.channel = (Channel)initAction.getGraphicsContext();
        this.setupFont(this.channel);
        this.fontHeight = this.channel.glGetTextHeight();
        this.setupTitle();
        this.setupMissingValues(initAction);
        this.setupLegendBackground(initAction);
        this.setupLegend(initAction);
        this.setupAxis(initAction);
        this.setupTransforms();
    }

    private void setupFont(Channel channel) {
        TextStyle ts = this.axis.getStyle().getLabelStyle();
        channel.glSelect2DFont(ts.getFont());
        if (ts.isShadowOn()) {
            channel.glEnable(11);
            channel.setShadowOffset(ts.getShadowOffsetX(), ts.getShadowOffsetY());
            channel.setShadowColor(ts.getShadowColor());
        } else {
            channel.glDisable(11);
        }
    }

    private void setupMissingValues(AInitAction initAction) {
        this.missingValues.missingColors.connectFrom(this.missingColors);
        this.missingValues.missingLabels.connectFrom(this.missingLabels);
        this.missingValues.setLegendStyle(this.legend.getStyle());
        this.missingValues.setAxisStyle(this.axis.getStyle());
        this.missingValues.setOrientation(this.style.getOrientation());
        this.missingValues.setPrimary(this.primary);
        this.missingValues.init(initAction);
        this.missingValuesSize = this.missingValues.getSize();
    }

    private void setupLegendBackground(AInitAction initAction) {
        this.legendBackground.labels.connectFrom(EMPTY_STRING_PIPE);
        this.legendBackground.colors.connectFrom(EMPTY_COLOR_PIPE);
        this.legendBackground.setLabelingMethod(0);
        this.legendBackground.setContinuous(true);
        this.legendBackground.init(initAction);
    }

    private void setupLegend(AInitAction initAction) {
        this.legend.colors.connectFrom(this.colors);
        this.legend.colorPlacementPercentages.connectFrom(this.colorPlacementPercentage);
        this.legend.setLabelingMethod(0);
        this.legend.setContinuous(true);
        this.legend.getStyle().setBorderOn(false);
        this.legend.getStyle().setVerticalMargin(0.0);
        this.legend.getStyle().setHorizontalMargin(0.0);
        this.legend.getStyle().getLabelStyle().setFont(this.axis.getStyle().getLabelStyle().getFont());
        this.legend.getStyle().getLabelStyle().setShadowOn(false);
        this.legend.getStyle().getLabelStyle().setShadowOffsetX(0);
        this.legend.getStyle().getLabelStyle().setShadowOffsetY(0);
        this.legend.getStyle().getContinuousEdgeStyle().setWidth(this.axis.getStyle().getMajorTickStyle().getLineWidth());
        if (this.style.getOrientation() == 2) {
            this.legend.setLayoutByRow(false);
            this.legend.setHeight(this.length);
            this.legend.setWidth(2.0);
        } else {
            this.legend.setLayoutByRow(true);
            this.legend.setWidth(this.length);
            this.legend.setHeight(2.0);
        }
        this.legend.init(initAction);
        this.legendThickness = this.fontHeight * this.legend.getStyle().getContinuousColorBarThickness();
    }

    private void setupAxis(AInitAction initAction) {
        this.labelOffset = new NumericVector();
        this.labels.init(initAction);
        AxisStyle aStyle = this.axis.getStyle();
        this.axis.labels.connectFrom(this.labels);
        this.axisLength = this.length;
        if (this.style.getOrientation() == 2 && this.legend.getStyle().isTitleOn() && this.legend.title.getValue() != null && this.legend.title.getValue().length() > 0) {
            this.axisLength -= this.titleHeight;
        }
        for (int i = 0; i < initAction.getValueCount(); ++i) {
            try {
                this.labelOffset.addValue(this.axisLength * this.rampPercentage.getValue(i));
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        this.axis.labelOffset.connectFrom(this.labelOffset);
        this.axis.setLength(this.axisLength);
        this.axis.setUseLabelFromStyle(true);
        aStyle.setAxisLineOn(false);
        if (this.style.getOrientation() == 2) {
            aStyle.setVerticalLabelSpace(0.25);
            aStyle.getTitleStyle().setVerticalJustification(1);
            aStyle.getLabelStyle().setVerticalJustification(1);
            aStyle.getLabelStyle().setHorizontalJustification(2);
            if (this.primary) {
                aStyle.getTitleStyle().setHorizontalJustification(0);
            } else {
                aStyle.getTitleStyle().setHorizontalJustification(2);
            }
            this.axis.setPrimary(!this.primary);
            this.axis.setLabelOrientation(1);
        } else {
            aStyle.setVerticalLabelSpace(0.0);
            aStyle.getTitleStyle().setHorizontalJustification(1);
            aStyle.getLabelStyle().setHorizontalJustification(1);
            aStyle.getLabelStyle().setVerticalJustification(0);
            if (this.primary) {
                aStyle.getTitleStyle().setVerticalJustification(0);
            } else {
                aStyle.getTitleStyle().setVerticalJustification(3);
            }
            this.axis.setPrimary(this.primary);
            this.axis.setLabelOrientation(2);
        }
    }

    public TextStyle getTitleStyle() {
        return this.axis.getStyle().getTitleStyle();
    }

    public TextStyle getLabelStyle() {
        return this.axis.getStyle().getLabelStyle();
    }

    public TickMarkStyle getTickStyle() {
        return this.style.getTickStyle();
    }

    public void setFitAlgoritm(String[] fitAlgorithm) {
        this.style.setFitAlgoritm(fitAlgorithm);
    }

    private void setupTitle() {
        boolean on = this.style.isTitleOn() && this.title.getValue() != null && this.title.getValue().length() > 0;
        this.axis.getStyle().setTitleOn(on);
        if (on) {
            double ta;
            this.axis.title.setValue(this.title.getValue());
            if (this.titleTruncateEndCount > 0) {
                this.axis.setTitleTruncateEndCount(this.titleTruncateEndCount);
            }
            if ((ta = this.style.getTitleAngle()) == -1.0) {
                ta = this.getOrientation() == 2 ? (this.isPrimary() ? 270.0 : 90.0) : 0.0;
            }
            this.axis.getStyle().getTitleStyle().setAngle(ta);
        }
    }

    private void setupTransforms() {
        double lbH;
        double lbW;
        double lbY;
        double lbX;
        double mvX;
        double mvY;
        NetworkRoot nr = new NetworkRoot();
        nr.addElement(this.legend);
        BoundingBox legendBounds = nr.computeBoundingBox(this.channel);
        AxisMetrics axisMetrics = this.axis.getMetrics(this.channel);
        if (this.legend.isLegendFit() && this.dropAxisAsNeeded && !this.axis.isDisplayTitleFit()) {
            axisMetrics.setWidth(0.0);
            axisMetrics.setHeight(0.0);
            axisMetrics.setHighExtender(0.0);
            axisMetrics.setLowExtender(0.0);
        }
        double extender = Math.min(axisMetrics.getLowExtender(), axisMetrics.getHighExtender());
        double maxLength = this.length + 2.0 * extender;
        maxLength = this.length + axisMetrics.getLowExtender() + axisMetrics.getHighExtender();
        double axX = 0.0;
        double axY = 0.0;
        double legX = 0.0;
        double legY = 0.0;
        double borderSize = 0.0;
        if (this.useLegendBackground()) {
            borderSize = 5.0;
        }
        switch (this.style.getOrientation()) {
            case 2: {
                mvY = this.length + axisMetrics.getHighExtender();
                if (this.primary) {
                    this.applyLegendLabelStyle(this.channel);
                    axX = this.legendThickness + borderSize;
                    legX = borderSize;
                    mvX = borderSize;
                } else {
                    axX = axisMetrics.getWidth();
                    legX = axisMetrics.getWidth();
                    mvX = axisMetrics.getWidth();
                }
                this.axis.setMaximumSize(new Vec3d(Double.MAX_VALUE, maxLength, 0.0));
                lbX = legX - borderSize;
                lbY = legY - axisMetrics.getLowExtender() - borderSize + 1.0;
                lbW = axisMetrics.getWidth() + this.legendThickness + borderSize * 2.0;
                lbH = axisMetrics.getHeight() + this.missingValuesSize.y + 2.0 * borderSize;
                break;
            }
            default: {
                legX = -this.legend.getLabelMargin();
                mvX = this.length + axisMetrics.getHighExtender();
                if (this.primary) {
                    axY = axisMetrics.getHeight() + borderSize;
                    legY = axisMetrics.getHeight() + borderSize;
                    mvY = axisMetrics.getHeight() + borderSize;
                } else {
                    axY = legendBounds.getSize().y + borderSize;
                    legY = borderSize;
                    mvY = borderSize;
                }
                this.axis.setMaximumSize(new Vec3d(maxLength, Double.MAX_VALUE, 0.0));
                lbX = -axisMetrics.getLowExtender() - borderSize;
                lbY = 0.0;
                lbW = axisMetrics.getWidth() + this.missingValuesSize.x + 2.0 * borderSize;
                lbH = axisMetrics.getHeight() + this.legendThickness + borderSize * 2.0;
            }
        }
        this.legend.transform.translateX.setValue(legX);
        this.legend.transform.translateY.setValue(legY);
        this.axis.transform.translateX.setValue(axX);
        this.axis.transform.translateY.setValue(axY);
        this.missingValues.transform.translateX.setValue(mvX);
        this.missingValues.transform.translateY.setValue(mvY);
        this.legendBackground.transform.translateX.setValue(lbX);
        this.legendBackground.transform.translateY.setValue(lbY);
        this.legendBackground.setWidth(lbW);
        this.legendBackground.setHeight(lbH);
    }

    private boolean useLegendBackground() {
        return this.style.isBackgroundOn() || this.style.isBorderOn();
    }

    public AxisMetrics getMetrics(Channel ch) {
        this.init(new InitAction(ch));
        AxisMetrics axisMetrics = this.axis.getMetrics(ch);
        NetworkRoot nr = new NetworkRoot();
        nr.addElement(this.legend);
        BoundingBox bbox = nr.computeBoundingBox(ch);
        double legendHeight = bbox.getSize().y;
        double legendWidth = bbox.getSize().x;
        this.axisDropped = false;
        if (this.legend.isLegendFit() && this.dropAxisAsNeeded && !this.axis.isDisplayTitleFit()) {
            axisMetrics.setWidth(0.0);
            axisMetrics.setHeight(0.0);
            axisMetrics.setHighExtender(0.0);
            axisMetrics.setLowExtender(0.0);
            this.axisDropped = true;
        }
        double borderMargin = 0.0;
        if (this.useLegendBackground()) {
            borderMargin = 5.0;
        }
        switch (this.style.getOrientation()) {
            case 2: {
                axisMetrics.setWidth(axisMetrics.getWidth() + legendWidth + 2.0 * borderMargin);
                axisMetrics.setHighExtender(axisMetrics.getHighExtender() + this.missingValuesSize.y + borderMargin);
                axisMetrics.setLowExtender(axisMetrics.getLowExtender() + borderMargin);
                axisMetrics.setHeight(axisMetrics.getHeight() + this.missingValuesSize.y + 2.0 * borderMargin);
                break;
            }
            default: {
                axisMetrics.setHeight(axisMetrics.getHeight() + legendHeight + 2.0 * borderMargin);
                axisMetrics.setHighExtender(axisMetrics.getHighExtender() + this.missingValuesSize.x + borderMargin);
                axisMetrics.setLowExtender(axisMetrics.getLowExtender() + borderMargin);
                axisMetrics.setWidth(axisMetrics.getWidth() + this.missingValuesSize.x + 2.0 * borderMargin);
            }
        }
        return axisMetrics;
    }

    public AxisMetrics getPreferredMetrics(Channel ch) {
        this.init(new InitAction(ch));
        AxisMetrics axisMetrics = this.axis.getPreferredMetrics(ch);
        this.applyLegendLabelStyle(ch);
        double borderMargin = 0.0;
        if (this.useLegendBackground()) {
            borderMargin = 5.0;
        }
        switch (this.style.getOrientation()) {
            case 2: {
                axisMetrics.setWidth(axisMetrics.getWidth() + this.legendThickness + borderMargin * 2.0);
                axisMetrics.setHeight(axisMetrics.getHeight() + this.missingValuesSize.y + borderMargin * 2.0);
                axisMetrics.setHighExtender(axisMetrics.getHighExtender() + this.missingValuesSize.y + borderMargin);
                break;
            }
            default: {
                axisMetrics.setHeight(axisMetrics.getHeight() + this.legendThickness + borderMargin * 2.0);
                axisMetrics.setHighExtender(axisMetrics.getHighExtender() + this.missingValuesSize.x + borderMargin);
                axisMetrics.setWidth(axisMetrics.getWidth() + this.missingValuesSize.x + borderMargin * 2.0);
            }
        }
        axisMetrics.setLowExtender(axisMetrics.getLowExtender() + borderMargin);
        return axisMetrics;
    }

    private void applyLegendLabelStyle(Channel ch) {
        TextStyle legendLabelStyle = this.legend.getStyle().getLabelStyle();
        if (legendLabelStyle.isShadowOn()) {
            ch.glEnable(11);
            ch.setShadowOffset(legendLabelStyle.getShadowOffsetX(), legendLabelStyle.getShadowOffsetY());
        } else {
            ch.glDisable(11);
        }
        ch.glSelect2DFont(legendLabelStyle.getFont());
    }

    public void setLength(double length) {
        this.length = length;
    }

    public double getLength() {
        return this.length;
    }

    public void setOrientation(int orientation) {
        this.style.setOrientation(orientation);
    }

    public int getOrientation() {
        return this.style.getOrientation();
    }

    public void setSmoothShading(boolean trueOrFalse) {
        this.style.setSmoothShading(trueOrFalse);
    }

    public boolean isSmoothShading() {
        return this.style.isSmoothShading();
    }

    public void setTitlePosition(int titlePosition) {
        this.style.setTitlePosition(titlePosition);
    }

    public int getTitlePositon() {
        return this.style.getTitlePositon();
    }

    public boolean isTitleOn() {
        return this.style.isTitleOn();
    }

    public void setTitleOn(boolean titleOn) {
        this.style.setTitleOn(titleOn);
    }

    public void setTitleAngle(double titleAngle) {
        this.style.setTitleAngle(titleAngle);
    }

    public double getTitleAngle() {
        return this.style.getTitleAngle();
    }

    public boolean isPrimary() {
        return this.style.isPrimary();
    }

    public void setPrimary(boolean primary) {
        this.style.setPrimary(primary);
    }

    public boolean isMissingItemsVisible() {
        return this.style.isMissingItemsVisible();
    }

    public void setMissingItemsVisible(boolean missingItemsVisible) {
        this.style.setMissingItemsVisible(missingItemsVisible);
    }

    public void setContinuousColorBarThickness(double continuousColorBarThickness) {
        this.style.setContinuousColorBarThickness(continuousColorBarThickness);
    }

    public double getContinuousColorBarThickness() {
        return this.style.getContinuousColorBarThickness();
    }

    public ColorRampLegendStyle getStyle() {
        return this.style;
    }

    public void setLabelFitAlgorithm(String[] fit) {
        this.axis.setFitAlgorithm(fit);
    }

    public double getLegendThickness() {
        return this.legendThickness;
    }

    public void setShowThinnedTicks(boolean b) {
        this.axis.getStyle().setShowThinnedTicks(b);
    }

    public void setTitleTruncateEndCount(int count) {
        this.titleTruncateEndCount = count;
    }

    public int getTitleTruncateEndCount() {
        return this.titleTruncateEndCount;
    }

    public void setDropAxisAsNeeded(boolean drop) {
        this.dropAxisAsNeeded = drop;
    }

    public boolean isDropAxisAsNeeded() {
        return this.dropAxisAsNeeded;
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        AxisStyle as = this.axis.getStyle();
        boolean titleOn = as.isTitleOn();
        boolean labelOn = as.isLabelsOn();
        boolean ticksOn = as.isMajorTickMarksOn();
        if (this.axisDropped) {
            as.setTitleOn(false);
            as.setLabelsOn(false);
            as.setMajorTickMarksOn(false);
        }
        super.render(buildAction);
        if (this.axisDropped) {
            as.setTitleOn(titleOn);
            as.setLabelsOn(labelOn);
            as.setMajorTickMarksOn(ticksOn);
        }
    }

    public void setSVGRender(boolean b) {
        this.legend.setSVGRender(b);
    }

    private static class MissingValuesElement
    extends Element {
        public final ColorProperty missingColors = new ColorProperty(this, true);
        public final StringProperty missingLabels = new StringProperty(this, true);
        private LegendStyle legendStyle;
        private AxisStyle axisStyle;
        private int orientation;
        private boolean primary;
        private Vec3d size = new Vec3d();
        private List values = new ArrayList();
        private double fontHeight;

        public Vec3d getSize() {
            this.init(new AInitAction());
            return this.size;
        }

        @Override
        public void init(AInitAction ia) {
            ia.pushValueCount();
            super.init(ia);
            int missingValuesCount = ia.getValueCount();
            ia.popValueCount();
            if (ia.beenInitialized(this)) {
                return;
            }
            this.size.set(0.0, 0.0, 0.0);
            if (missingValuesCount > 0) {
                int i;
                Channel ch = (Channel)ia.getGraphicsContext();
                this.setupFont(ch);
                this.fontHeight = ch.glGetTextHeight();
                this.values.clear();
                for (i = 0; i < missingValuesCount; ++i) {
                    try {
                        Color c = this.missingColors.getValue(i);
                        String s = this.missingLabels.getValue(i);
                        if (c == null || s == null || s.length() <= 0) continue;
                        ValueInfo vi = new ValueInfo();
                        this.values.add(vi);
                        vi.color = c;
                        vi.label = s;
                        double labelWidth = ch.glGetTextWidth(s);
                        if (this.orientation == 1) {
                            vi.size.x = Math.max(this.fontHeight, labelWidth);
                            vi.size.y = this.markerSize() + this.tickLength() + this.labelMargin() + this.fontHeight;
                            continue;
                        }
                        vi.size.x = this.fontHeight + this.axisStyle.getHorizontalLabelSpace() * this.fontHeight + labelWidth;
                        vi.size.y = this.fontHeight;
                        continue;
                    }
                    catch (MissingValueException c) {
                        // empty catch block
                    }
                }
                if (this.values.size() > 0) {
                    int n = this.values.size();
                    for (i = 0; i < n; ++i) {
                        ValueInfo vi = (ValueInfo)this.values.get(i);
                        if (this.orientation == 1) {
                            this.size.x += vi.size.x;
                            this.size.y = vi.size.y;
                            continue;
                        }
                        this.size.x = Math.max(this.size.x, vi.size.x);
                        this.size.y += this.fontHeight;
                    }
                    this.size.x += this.fontHeight / 2.0;
                }
            }
        }

        private double markerSize() {
            return this.fontHeight * this.legendStyle.getContinuousColorBarThickness();
        }

        private double tickLength() {
            double result = this.axisStyle.getMajorTickStyle().getLength() * this.fontHeight;
            return result;
        }

        private double labelMargin() {
            double result = this.orientation == 1 ? this.fontHeight * this.axisStyle.getVerticalLabelSpace() : this.fontHeight * this.axisStyle.getHorizontalLabelSpace();
            return result;
        }

        private void setupFont(Channel channel) {
            TextStyle ts = this.axisStyle.getLabelStyle();
            channel.glSelect2DFont(ts.getFont());
            if (ts.isShadowOn()) {
                channel.glEnable(11);
                channel.setShadowOffset(ts.getShadowOffsetX(), ts.getShadowOffsetY());
                channel.setShadowColor(ts.getShadowColor());
            } else {
                channel.glDisable(11);
            }
        }

        @Override
        protected void render(ABuildAction buildAction) throws MissingValueException {
            if (this.values.size() <= 0) {
                return;
            }
            Channel ch = (Channel)buildAction.getGraphicsContext();
            this.setupFont(ch);
            ch.setMarkerSize((int)this.fontHeight);
            ch.setMarkerType(19);
            double d = 0.0;
            Vec3d markerCenter = new Vec3d();
            Vec3d labelTopCenter = new Vec3d();
            int n = this.values.size();
            for (int i = 0; i < n; ++i) {
                ValueInfo vi = (ValueInfo)this.values.get(i);
                if (this.orientation == 1) {
                    ch.glAlignment(1, 0);
                    if (i == 0) {
                        d = this.fontHeight / 2.0;
                    }
                    d += vi.size.x / 2.0;
                    if (this.primary) {
                        markerCenter.x = d;
                        markerCenter.y = this.markerSize() / 2.0;
                        labelTopCenter.x = d;
                        labelTopCenter.y = -this.tickLength() - this.labelMargin();
                    } else {
                        labelTopCenter.x = d;
                        labelTopCenter.y = vi.size.y;
                        markerCenter.x = d;
                        markerCenter.y = this.markerSize() / 2.0;
                    }
                    d += vi.size.x / 2.0;
                } else {
                    if (i == 0) {
                        d = this.fontHeight / 2.0;
                    }
                    if (this.primary) {
                        labelTopCenter.x = vi.size.y + this.tickLength();
                        ch.glAlignment(0, 1);
                    } else {
                        labelTopCenter.x = -this.tickLength();
                        ch.glAlignment(2, 1);
                    }
                    markerCenter.y = labelTopCenter.y = d;
                    markerCenter.x = this.markerSize() / 2.0;
                    d += vi.size.y / 2.0;
                    d += this.fontHeight / 2.0;
                }
                ch.glColor(vi.color);
                ch.glEdgeColor(Color.black);
                ch.glLineWidth(1.0f);
                ch.glPolygonMode(3);
                ch.glMarker(markerCenter.x, markerCenter.y, 0.0);
                ch.glColor(this.axisStyle.getLabelStyle().getColor());
                ch.gl2DText(vi.label, labelTopCenter.x, labelTopCenter.y, 0.0);
            }
        }

        @Override
        protected void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
        }

        public MissingValuesElement() {
            super(new Transform());
        }

        public AxisStyle getAxisStyle() {
            return this.axisStyle;
        }

        public void setAxisStyle(AxisStyle axisStyle) {
            this.axisStyle = axisStyle;
            this.setModified();
        }

        public int getOrientation() {
            return this.orientation;
        }

        public void setOrientation(int orientation) {
            this.orientation = orientation;
            this.setModified();
        }

        public boolean isPrimary() {
            return this.primary;
        }

        public void setPrimary(boolean primary) {
            this.primary = primary;
        }

        public LegendStyle getLegendStyle() {
            return this.legendStyle;
        }

        public void setLegendStyle(LegendStyle legendStyle) {
            this.legendStyle = legendStyle;
            this.setModified();
        }

        private static class ValueInfo {
            Color color;
            String label;
            Vec3d size = new Vec3d();

            private ValueInfo() {
            }
        }
    }

    private static class EmptyStringPipe
    implements StringPipe {
        private EmptyStringPipe() {
        }

        @Override
        public String getValue(int index) throws MissingValueException {
            return null;
        }

        @Override
        public Formatter getFormatter() {
            return null;
        }

        @Override
        public void init(AInitAction initAction) {
            initAction.setValueCount(0);
        }

        @Override
        public void reset(AResetAction resetAction) {
        }
    }

    private static class EmptyColorPipe
    implements ColorPipe {
        private EmptyColorPipe() {
        }

        @Override
        public Color getValue(int index) throws MissingValueException {
            return null;
        }

        @Override
        public Formatter getFormatter() {
            return null;
        }

        @Override
        public void init(AInitAction initAction) {
            initAction.setValueCount(0);
        }

        @Override
        public void reset(AResetAction resetAction) {
        }
    }
}

