/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.ACircle;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;

public class Circle
extends ACircle {
    public Circle() {
        super(new Transform());
    }

    public static void drawCircle(Channel channel, double radius, Color color, Color edgeColor, boolean edgeOn, boolean fillOn, int precision) {
        int numOfEdges = precision;
        channel.glPushAttrib(0);
        channel.glColor(color);
        channel.glEdgeColor(edgeColor);
        channel.glPolygonMode(BuildAction.getGLFillStyle(fillOn, edgeOn));
        channel.glBegin(2);
        channel.glNormal(0.0, 0.0, 1.0);
        double angleIncrement = Math.PI * 2 / (double)numOfEdges;
        double angle = 0.0;
        for (int i = 0; i < numOfEdges; ++i) {
            angle = angleIncrement * (double)i;
            double x = Math.cos(angle) * radius;
            double y = Math.sin(angle) * radius;
            channel.glVertex(x, y, 0.0);
        }
        channel.glEnd();
        channel.glPopAttrib();
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        int index = ba.getValueIndex();
        Circle.drawCircle(ba.getChannel(), this.radius.getValue(index), this.color.getValue(index), this.edgeColor.getValue(index), this.edgeOn.getValue(index), this.fillOn.getValue(index), this.precision.getValue(index));
    }
}

