/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.SelectEntry;
import com.sas.graphics.util.gtk.gl.ResetAction;

public class BuildAction
extends ABuildAction {
    private boolean displayListCreate = true;
    private long displayListName;

    public BuildAction(Channel aChannel) {
        super(new ResetAction(aChannel), aChannel);
        this.getResetAction().setCompanionAction(this);
    }

    public Channel getChannel() {
        return (Channel)this.getGraphicsContext();
    }

    @Override
    public void apply(Element element) {
        Channel channel = this.getChannel();
        channel.glFrontFace(0);
        channel.glDisable(0);
        super.apply(element);
    }

    public static BuildAction castBuildAction(ABuildAction anABuildAction) {
        return (BuildAction)anABuildAction;
    }

    public void setDisplayListCreate(boolean onOrOff) {
        this.displayListCreate = onOrOff;
    }

    public boolean isDisplayListCreationEnabled() {
        return this.displayListCreate;
    }

    public void setDisplayListName(long name) {
        this.displayListName = name;
    }

    public long getDisplayListName() {
        return this.displayListName;
    }

    @Override
    public void pushName(Element e) {
        if (this.useNameStack) {
            BuildAction.pushName(this.getChannel(), this.getValueIndex(), e);
        }
    }

    @Override
    public void popName(Element e) {
        if (this.useNameStack) {
            BuildAction.popName(this.getChannel(), e);
        }
    }

    public static void pushName(Channel channel, int valueIndex, Element e) {
        SelectEntry entry = e.buildSelectEntry(valueIndex);
        channel.glPushName((Object)entry);
        if (BuildAction.canHaveSelectDetails(e)) {
            channel.glPushName(null);
        }
    }

    public static void popName(Channel channel, Element e) {
        channel.glPopName();
        if (BuildAction.canHaveSelectDetails(e)) {
            channel.glPopName();
        }
    }

    public static int getGLFillStyle(boolean fillOn, boolean edgeOn) {
        int result = 5;
        if (fillOn) {
            result = edgeOn ? 4 : 3;
        } else if (edgeOn) {
            result = 2;
        }
        return result;
    }
}

