/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AAxisSet;
import com.sas.graphics.util.gtk.ANetworkRoot;
import com.sas.graphics.util.gtk.NumericMap;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.gl.Box;
import com.sas.graphics.util.gtk.gl.Grid;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RectangularAxis;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class AxisSet
extends AAxisSet {
    private static final double defaultPerspectiveAzimuth = 30.0;
    private static final double defaultPerspectiveIncline = -0.1;
    private static final double defaultOrthographicAzimuth = 30.0;
    private static final double defaultOrthographicIncline = -15.0;
    private Vec3d adjustedCenter = new Vec3d();

    public AxisSet(ANetworkRoot root) {
        super(root);
    }

    public void setupLighting() {
        Channel channel = ((NetworkRoot)this.getNetworkRoot()).getChannel();
        channel.glEnable(3);
        channel.glEnable(19);
        channel.glLight(19, 3, new double[]{0.0, 0.0, 1.0});
        channel.glLight(19, 0, new double[]{0.3, 0.3, 0.3});
        channel.glLight(19, 1, new double[]{0.4, 0.4, 0.4});
        channel.glLight(19, 2, new double[]{0.0, 0.0, 0.0});
        channel.glEnable(20);
        channel.glLight(20, 3, new double[]{1.0, 1.0, 1.0});
        channel.glLight(20, 0, new double[]{0.0, 0.0, 0.0});
        channel.glLight(20, 1, new double[]{0.3, 0.3, 0.3});
        channel.glLight(20, 2, new double[]{0.0, 0.0, 0.0});
    }

    public Box newWireBox() {
        Box box = new Box();
        this.newWireBox(box);
        return box;
    }

    public RectangularAxis newXAxis(NumericMapper aMapper) {
        return this.newXAxis(aMapper.getNumericMap());
    }

    public RectangularAxis newXAxis(NumericMap map) {
        this.setXMap(map);
        return this.newXAxis();
    }

    public RectangularAxis newXAxis() {
        RectangularAxis axis = RectangularAxis.getXAxis(this.getXMap(), this.getSize().x);
        this.newXAxis(axis, this.getXMap());
        return axis;
    }

    public RectangularAxis newYAxis(NumericMapper aMapper) {
        return this.newYAxis(aMapper.getNumericMap());
    }

    public RectangularAxis newYAxis(NumericMap map) {
        this.setYMap(map);
        return this.newYAxis();
    }

    public RectangularAxis newYAxis() {
        RectangularAxis axis = RectangularAxis.getYAxis(this.getYMap(), this.getSize().y);
        this.newYAxis(axis, this.getYMap());
        return axis;
    }

    public RectangularAxis newZAxis(NumericMapper mapper) {
        return this.newZAxis(mapper.getNumericMap());
    }

    public RectangularAxis newZAxis(NumericMap map) {
        this.setZMap(map);
        return this.newZAxis();
    }

    public RectangularAxis newZAxis() {
        RectangularAxis axis = RectangularAxis.getZAxis(this.getZMap(), this.getSize().z);
        this.newZAxis(axis, this.getZMap());
        return axis;
    }

    public RectangularAxis newX2Axis(NumericMap map) {
        this.setX2Map(map);
        RectangularAxis axis = RectangularAxis.getXAxis(this.getX2Map(), this.getSize().x);
        this.newX2Axis(axis, this.getX2Map());
        return axis;
    }

    public RectangularAxis newY2Axis(NumericMap map) {
        this.setY2Map(map);
        RectangularAxis axis = RectangularAxis.getYAxis(this.getY2Map(), this.getSize().y);
        this.newY2Axis(axis, this.getY2Map());
        return axis;
    }

    public RectangularAxis newZ2Axis(NumericMap map) {
        this.setZ2Map(map);
        RectangularAxis axis = RectangularAxis.getZAxis(this.getZ2Map(), this.getSize().z);
        this.newZ2Axis(axis, this.getZ2Map());
        return axis;
    }

    public Grid newFloorGrid(NumericMapper horizMapper, NumericMapper vertMapper) {
        return this.newFloorGrid(horizMapper.getNumericMap(), vertMapper.getNumericMap());
    }

    public Grid newFloorGrid(NumericMap horizMap, NumericMap vertMap) {
        Grid grid = new Grid();
        this.newFloorGrid(grid, horizMap, vertMap);
        return grid;
    }

    public Grid newFloorGrid() {
        return this.newFloorGrid(this.getXMap(), this.getZMap());
    }

    public Grid newSideGrid(NumericMapper horizMapper, NumericMapper vertMapper) {
        return this.newSideGrid(horizMapper.getNumericMap(), vertMapper.getNumericMap());
    }

    public Grid newSideGrid(NumericMap horizMap, NumericMap vertMap) {
        Grid grid = new Grid();
        this.newSideGrid(grid, horizMap, vertMap);
        return grid;
    }

    public Grid newSideGrid() {
        return this.newSideGrid(this.getZMap(), this.getYMap());
    }

    public Grid newBackGrid(NumericMapper horizMapper, NumericMapper vertMapper) {
        return this.newBackGrid(horizMapper.getNumericMap(), vertMapper.getNumericMap());
    }

    public Grid newBackGrid(NumericMap horizMap, NumericMap vertMap) {
        Grid grid = new Grid();
        this.newBackGrid(grid, horizMap, vertMap);
        return grid;
    }

    public Grid newBackGrid() {
        return this.newBackGrid(this.getYMap(), this.getXMap());
    }

    public Grid newFloorGrid2(NumericMap horizMap, NumericMap vertMap) {
        Grid grid = new Grid();
        this.newFloorGrid(grid, horizMap, vertMap);
        return grid;
    }

    public Grid newSideGrid2(NumericMap horizMap, NumericMap vertMap) {
        Grid grid = new Grid();
        this.newSideGrid2(grid, horizMap, vertMap);
        return grid;
    }

    public Grid newBackGrid2(NumericMap horizMap, NumericMap vertMap) {
        Grid grid = new Grid();
        this.newBackGrid2(grid, horizMap, vertMap);
        return grid;
    }

    public double getWorldCoordinatePixelWidth() {
        double pw = 1.0;
        Channel channel = this.getChannel();
        switch (this.getProjection()) {
            case 2: {
                break;
            }
            case 0: 
            case 1: {
                channel.gluLookAt(0.0, 0.0, 0.0, this.getDistance(), 0.0, 0.0, 0.0);
                double[] world1 = new double[]{0.0, 0.0, 0.0};
                double[] world2 = new double[3];
                double[] p = new double[3];
                channel.gluProject(world1, p);
                p[0] = p[0] + 1.0;
                p[1] = p[1] + 1.0;
                channel.gluUnProject(p, world2);
                pw = Math.abs(world1[0] - world2[0]);
            }
        }
        this.setView(this.getAzimuth(), this.getIncline(), this.getDistance());
        return pw;
    }

    public void setView(double azimuth, double incline, double distance, Vec3d focal) {
        super.setView(azimuth, incline, distance);
        if (this.getBoundingBox() == null) {
            this.getView();
            return;
        }
        Channel channel = this.getChannel();
        if (channel != null) {
            double[] view = channel.glGetDoublev(0);
            double aspectRatio = view[3] / view[2];
            Vec3d c = this.getBoundingBox().getCenter();
            switch (this.getProjection()) {
                case 1: {
                    Vec3d s = this.getBoundingBox().getSize();
                    if (focal == null) {
                        channel.gluLookAt(this.adjustedCenter.x, this.adjustedCenter.y, this.adjustedCenter.z, s.length() / 2.0, azimuth, incline, 0.0);
                        break;
                    }
                    channel.gluLookAt(focal.x, focal.y, focal.z, distance, azimuth, incline, 0.0);
                    break;
                }
                case 0: {
                    if (aspectRatio > 1.0) {
                        aspectRatio = 1.0 / aspectRatio;
                    }
                    channel.gluPerspective(this.getFieldOfView(), 1.0 / aspectRatio, 0.1, 2.0 * distance);
                    if (focal == null) {
                        channel.gluLookAt(c.x, c.y, c.z, distance, azimuth, incline, 0.0);
                        break;
                    }
                    channel.gluLookAt(focal.x, focal.y, focal.z, distance, azimuth, incline, 0.0);
                    break;
                }
                case 2: {
                    this.getNetworkRoot().setObliqueView(this.getBoundingBox(), this.getObliqueFactor(), this.getObliqueAngle(), 0.0, 0.0, this.getFocalPoint(), this.isFitScreen());
                }
            }
        }
    }

    @Override
    public void setView(double azimuth, double incline, double distance) {
        this.setView(azimuth, incline, distance, null);
    }

    public double[] getView() {
        double inc;
        double az;
        switch (this.getProjection()) {
            default: {
                az = 30.0;
                inc = -0.1;
                break;
            }
            case 1: {
                az = 30.0;
                inc = -15.0;
            }
        }
        return this.getView(az, inc);
    }

    private Channel getChannel() {
        return ((NetworkRoot)this.getNetworkRoot()).getChannel();
    }

    public double[] getView(double azimuth, double incline) {
        double[] defView = new double[]{azimuth, incline, this.getGreatestDimension()};
        super.setView(defView[0], defView[1], defView[2]);
        Channel channel = this.getChannel();
        if (channel != null) {
            double[] viewport = channel.glGetDoublev(0);
            switch (this.getProjection()) {
                case 0: {
                    channel.gluPerspective(this.getFieldOfView(), viewport[2] / viewport[3], 0.1, defView[2]);
                    channel.gluLookAt(0.0, 0.0, 0.0, defView[2], defView[0], defView[1], 0.0);
                    BoundingBox tempBbox = this.computeBoundingBox();
                    this.setBoundingBox(tempBbox);
                    defView[2] = this.getNetworkRoot().setPerspectiveView(tempBbox, this.getFieldOfView(), defView[0], defView[1]);
                    break;
                }
                case 1: {
                    double[] vp = channel.glGetDoublev(0);
                    Rectangle2D.Double vpr = new Rectangle2D.Double(vp[0], vp[1], vp[2], vp[3]);
                    Vec3d tempSize = new Vec3d(this.size);
                    if (((RectangularShape)vpr).getWidth() > ((RectangularShape)vpr).getHeight()) {
                        tempSize.x *= ((RectangularShape)vpr).getWidth() / ((RectangularShape)vpr).getHeight();
                    } else {
                        tempSize.y *= ((RectangularShape)vpr).getHeight() / ((RectangularShape)vpr).getWidth();
                    }
                    channel.glOrtho(0.0, tempSize.x, 0.0, tempSize.y, 0.0, tempSize.z);
                    channel.gluLookAt(0.0, 0.0, 0.0, defView[2], defView[0], defView[1], 0.0);
                    ANetworkRoot.BoundsInfo boundsInfo = this.getNetworkRoot().computeBounds();
                    this.setBoundingBox(boundsInfo.getBoundingBox());
                    Rectangle2D projection = boundsInfo.getProjection();
                    double diagonal = tempSize.length() * 2.0;
                    for (int i = 0; i < 10 && !this.closeEnough(vpr, projection); ++i) {
                        double sf = this.computeScalingFactor(vpr, projection);
                        tempSize.scale(sf);
                        diagonal = tempSize.length() * 2.0;
                        channel.glOrtho(-tempSize.x / 2.0, tempSize.x / 2.0, -tempSize.y / 2.0, tempSize.y / 2.0, -diagonal / 2.0, diagonal / 2.0);
                        boundsInfo = this.getNetworkRoot().computeBounds();
                        this.setBoundingBox(boundsInfo.getBoundingBox());
                        projection = boundsInfo.getProjection();
                    }
                    this.adjustedCenter = boundsInfo.getBoundingBox().getCenter();
                    double zoomFactor = this.getZoom();
                    if (zoomFactor <= 1.0) {
                        Vec3d center = new Vec3d();
                        center = boundsInfo.getBoundingBox().getCenter();
                        channel.gluLookAt(center.x, center.y, center.z, defView[2], defView[0], defView[1], 0.0);
                        boundsInfo = this.getNetworkRoot().computeBounds();
                        center = boundsInfo.getBoundingBox().getCenter();
                        projection = boundsInfo.getProjection();
                        for (int i = 0; i < 3 && !vpr.contains(projection); ++i) {
                            double vprCenterX = vpr.getCenterX();
                            double vprCenterY = vpr.getCenterY();
                            double projectionCenterX = projection.getCenterX();
                            double projectionCenterY = projection.getCenterY();
                            double winDiffX = projectionCenterX - vprCenterX;
                            double winDiffY = projectionCenterY - vprCenterY;
                            center = boundsInfo.getBoundingBox().getCenter();
                            double[] winCenter = new double[3];
                            double[] worldCenter = new double[]{center.x, center.y, center.z};
                            winCenter = new double[3];
                            channel.gluProject(worldCenter, winCenter);
                            winCenter[0] = winCenter[0] + winDiffX;
                            winCenter[1] = winCenter[1] + winDiffY;
                            channel.gluUnProject(winCenter, worldCenter);
                            this.adjustedCenter.set(worldCenter[0], worldCenter[1], worldCenter[2]);
                            channel.gluLookAt(this.adjustedCenter.x, this.adjustedCenter.y, this.adjustedCenter.z, defView[2], defView[0], defView[1], 0.0);
                            boundsInfo = this.getNetworkRoot().computeBounds();
                            projection = boundsInfo.getProjection();
                        }
                        break;
                    }
                    if (!this.closeEnough(vpr, projection) || zoomFactor == 1.0) break;
                    tempSize.scale(1.0 / zoomFactor);
                    channel.glOrtho(-tempSize.x / 2.0, tempSize.x / 2.0, -tempSize.y / 2.0, tempSize.y / 2.0, -diagonal / 2.0, diagonal / 2.0);
                    boundsInfo = this.getNetworkRoot().computeBounds();
                    this.setBoundingBox(boundsInfo.getBoundingBox());
                    projection = boundsInfo.getProjection();
                    break;
                }
                case 2: {
                    double factor = Math.sin(this.getObliqueAngle() * Math.PI / 180.0) * this.getObliqueFactor();
                    double skew = this.getSize().z * factor * 0.5;
                    channel.glOblique(-skew, this.getSize().x + skew, -skew, this.getSize().y + skew, -1000.0, 1000.0, this.getObliqueFactor(), this.getObliqueAngle());
                    channel.gluLookAt(this.getFocalPoint().x, this.getFocalPoint().y, this.getFocalPoint().z, this.getSize().z * 0.5, 0.0, 0.0, 0.0);
                    BoundingBox tempBbox = this.networkRoot.computeBoundingBox();
                    this.setBoundingBox(tempBbox);
                    defView[0] = 0.0;
                    defView[2] = this.getNetworkRoot().setObliqueView(tempBbox, this.getObliqueFactor(), this.getObliqueAngle(), 0.0, 0.0, this.getFocalPoint(), this.isFitScreen());
                    tempBbox = this.networkRoot.computeBoundingBox();
                    this.setBoundingBox(tempBbox);
                    defView[2] = this.getNetworkRoot().setObliqueView(tempBbox, this.getObliqueFactor(), this.getObliqueAngle(), 0.0, 0.0, this.getFocalPoint(), this.isFitScreen());
                    break;
                }
            }
        }
        return defView;
    }

    private boolean closeEnough(Rectangle2D vp, Rectangle2D projection) {
        boolean result = false;
        double xdiff = vp.getWidth() - projection.getWidth();
        double ydiff = vp.getHeight() - projection.getHeight();
        if (xdiff > 0.0 && ydiff > 0.0 && (xdiff / vp.getWidth() < 0.1 || ydiff / vp.getHeight() < 0.1)) {
            return true;
        }
        return result;
    }

    private double computeScalingFactor(Rectangle2D vp, Rectangle2D projection) {
        double result = 1.0;
        double xdiff = vp.getWidth() - projection.getWidth();
        double ydiff = vp.getHeight() - projection.getHeight();
        if (xdiff < 0.0 || ydiff < 0.0) {
            result = xdiff > ydiff ? projection.getHeight() / (vp.getHeight() * 0.99) : projection.getWidth() / (vp.getWidth() * 0.99);
        } else if (xdiff > 0.0 && ydiff > 0.0) {
            result = xdiff > ydiff ? vp.getHeight() * 1.01 / projection.getHeight() : vp.getWidth() * 1.01 / projection.getWidth();
        }
        return result;
    }
}

