/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.Debug;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.Expression;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.VariableProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

class WhereProcessor {
    protected int valueCount;
    private Vector variables;
    private List skipTable = new ArrayList();
    private int skipCount;
    private int keepIndex = 0;
    private boolean lastIndexKept = false;
    private SkipEntry currentSkipEntry = null;
    private WhereExpressionEvaluator whereExpressionEvaluator = new WhereExpressionEvaluator();
    private String parseErrorMessage = null;
    private boolean processed = false;

    public void setExpression(String expression) {
        if (expression == null) {
            expression = "";
        }
        this.whereExpressionEvaluator.setExpression(expression);
    }

    public String getExpression() {
        return this.whereExpressionEvaluator.getExpression();
    }

    public boolean isWhereProcessingNeeded() {
        return !this.whereExpressionEvaluator.isExpressionEmpty() && this.whereExpressionEvaluator.parse(this.variables);
    }

    public int process(Vector allVariables, int aValueCount) {
        VariableProcessor.VEntry ve;
        int i;
        this.processed = true;
        this.variables = allVariables;
        this.valueCount = aValueCount;
        this.skipCount = 0;
        this.keepIndex = 0;
        this.lastIndexKept = false;
        int variableCount = this.variables.size();
        this.currentSkipEntry = null;
        this.skipTable.clear();
        if (!this.isWhereProcessingNeeded()) {
            return aValueCount;
        }
        if (this.getExpression().trim().length() == 0) {
            throw new IllegalStateException();
        }
        for (i = 0; i < variableCount; ++i) {
            ve = (VariableProcessor.VEntry)this.variables.elementAt(i);
            if (ve.type != 0) continue;
            ve.variable.uniqueValueAddBegin(this.valueCount);
        }
        for (i = 0; i < this.valueCount; ++i) {
            if (!this.whereProcessObservation(i)) continue;
            for (int j = 0; j < variableCount; ++j) {
                ve = (VariableProcessor.VEntry)this.variables.elementAt(j);
                if (ve.type != 0) continue;
                ve.variable.addUniqueValue(i);
            }
        }
        for (i = 0; i < variableCount; ++i) {
            ve = (VariableProcessor.VEntry)this.variables.elementAt(i);
            if (ve.type != 0) continue;
            ve.variable.uniqueValueAddEnd();
        }
        this.valueCount -= this.skipCount;
        for (i = 0; i < variableCount; ++i) {
            ve = (VariableProcessor.VEntry)this.variables.elementAt(i);
            if (ve.variable instanceof NumericVariable) {
                NumericVariable nv = (NumericVariable)ve.variable;
                NumericSkipPipe np = new NumericSkipPipe(nv.getProcessedValuePipe());
                nv.setProcessedValuePipe(np, this.valueCount);
                continue;
            }
            StringVariable sv = (StringVariable)ve.variable;
            StringSkipPipe sp = new StringSkipPipe(sv.getProcessedValuePipe());
            sv.setProcessedValuePipe(sp, this.valueCount);
        }
        return this.valueCount;
    }

    public boolean whereProcessObservation(int valueIndex) {
        boolean keep = this.whereExpressionEvaluator.evaluateExpression(valueIndex);
        if (keep) {
            ++this.keepIndex;
            this.lastIndexKept = true;
        } else {
            if (this.lastIndexKept || this.currentSkipEntry == null) {
                this.currentSkipEntry = new SkipEntry(this.keepIndex, valueIndex, this.skipCount, this.keepIndex);
                this.skipTable.add(this.currentSkipEntry);
            } else {
                ++this.currentSkipEntry.localSkipCount;
            }
            ++this.skipCount;
            this.lastIndexKept = false;
        }
        return keep;
    }

    public Integer getIndex(Integer index) {
        if (this.skipTable.size() == 0) {
            return index;
        }
        return new Integer(this.getIndex((int)index));
    }

    public int getIndex(int index) {
        int size = this.skipTable.size();
        int lowerIndex = 0;
        int upperIndex = size - 1;
        int resultIndex = index;
        while (lowerIndex <= upperIndex) {
            int middleIndex = (lowerIndex + upperIndex) / 2;
            SkipEntry entry = this.getSkipEntry(middleIndex);
            if (index >= entry.index) {
                SkipEntry nextEntry = this.getSkipEntry(middleIndex + 1);
                if (nextEntry == null || nextEntry != null && index < nextEntry.index) {
                    resultIndex = index + entry.globalSkipCount + entry.localSkipCount;
                    break;
                }
                lowerIndex = middleIndex + 1;
                continue;
            }
            SkipEntry prevEntry = this.getSkipEntry(middleIndex - 1);
            if (prevEntry == null) {
                resultIndex = index;
                break;
            }
            if (index >= prevEntry.index) {
                resultIndex = index + prevEntry.globalSkipCount + prevEntry.localSkipCount;
                break;
            }
            upperIndex = middleIndex - 1;
        }
        return resultIndex;
    }

    public SkipEntry getSkipEntry(int index) {
        SkipEntry result = null;
        if (index >= 0 && index < this.skipTable.size()) {
            result = (SkipEntry)this.skipTable.get(index);
        }
        return result;
    }

    public boolean isExpressionValid(Vector variableList) {
        return this.whereExpressionEvaluator.parse(variableList);
    }

    public String getParseErrorMessage() {
        return this.parseErrorMessage;
    }

    private class SkipEntry {
        public int globalSkipCount;
        public int globalKeepCount;
        public int index;
        public int originalIndex;
        public int localSkipCount;

        public SkipEntry(int index, int originalIndex, int skipCount, int keepCount) {
            this.index = index;
            this.localSkipCount = 1;
            this.globalSkipCount = skipCount;
            this.globalKeepCount = keepCount;
            this.originalIndex = originalIndex;
        }
    }

    private class WhereExpressionEvaluator
    extends Expression {
        public WhereExpressionEvaluator() {
            this.setInterpretQuestionMarkAsContains(true);
        }

        public boolean isExpressionEmpty() {
            String e = super.getExpression();
            if (e == null || e.length() == 0) {
                return true;
            }
            StringTokenizer tokenizer = new StringTokenizer(e);
            return !tokenizer.hasMoreTokens();
        }

        public boolean parse(Vector variables) {
            if (this.isExpressionEmpty()) {
                return true;
            }
            this.removeOperands();
            int n = variables.size();
            for (int i = 0; i < n; ++i) {
                VariableProcessor.VEntry ve = (VariableProcessor.VEntry)variables.elementAt(i);
                if (ve.variable instanceof NumericVariable) {
                    this.addOperand(ve.variable.getName(), (NumericVariable)ve.variable, true);
                    continue;
                }
                this.addOperand(ve.variable.getName(), (StringVariable)ve.variable, true);
            }
            try {
                WhereProcessor.this.parseErrorMessage = null;
                super.parse();
            }
            catch (Expression.ExpressionParseException exception) {
                WhereProcessor.this.parseErrorMessage = exception.getMessage();
                return false;
            }
            if (this.getEvaluationType() != 1) {
                Debug.println((String)"Where expression must yield boolean.");
                return false;
            }
            return true;
        }

        public boolean evaluateExpression(int index) {
            try {
                Expression.MultiTypedValue result = this.evaluate(index);
                return result.booleanValue;
            }
            catch (MissingValueException e) {
                Debug.println((String)"Internal error: where expression resolved to a missing value");
                return true;
            }
        }
    }

    private class NumericSkipPipe
    extends SkipPipe
    implements NumericPipe {
        private NumericPipe rawValuePipe;

        public NumericSkipPipe(NumericPipe aRawValuePipe) {
            super(aRawValuePipe);
            this.rawValuePipe = aRawValuePipe;
        }

        @Override
        public double getValue(int i) throws MissingValueException {
            return this.rawValuePipe.getValue(this.getSkipIndex(i));
        }
    }

    private class StringSkipPipe
    extends SkipPipe
    implements StringPipe {
        private StringPipe rawValuePipe;

        public StringSkipPipe(StringPipe aRawValuePipe) {
            super(aRawValuePipe);
            this.rawValuePipe = aRawValuePipe;
        }

        @Override
        public String getValue(int i) throws MissingValueException {
            return this.rawValuePipe.getValue(this.getSkipIndex(i));
        }
    }

    private class SkipPipe
    implements Pipe {
        private boolean wasInited = false;

        public SkipPipe(Pipe aRawValue) {
        }

        @Override
        public void init(AInitAction initAction) {
            initAction.setValueCount(WhereProcessor.this.valueCount);
        }

        @Override
        public void reset(AResetAction resetAction) {
        }

        @Override
        public Formatter getFormatter() {
            return null;
        }

        public int getSkipIndex(int i) {
            if (i >= WhereProcessor.this.valueCount) {
                throw new IllegalArgumentException("Value index out of bounds.  valueIndex=" + i + " valueCount=" + WhereProcessor.this.valueCount);
            }
            return WhereProcessor.this.getIndex(i);
        }
    }
}

