/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.RB;
import com.sas.graphics.util.gtk.render.kpi.BoundaryValue;
import com.sas.graphics.util.gtk.render.kpi.KPIChartSegmentedRangeColorModel;
import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.util.List;

public class Util {
    private static final double thousandths = 0.001;
    private static final double millionths = 1.0E-6;
    private static final double billionths = 1.0E-9;
    private static final double trillionths = 1.0E-12;
    private static final double thousands = 1000.0;
    private static final double millions = 1000000.0;
    private static final double billions = 1.0E9;
    private static final double trillions = 1.0E12;

    public static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    public static double findFactor(double product) {
        if (product == 0.0) {
            return 1.0;
        }
        double factor = Double.NaN;
        if ((product = Math.abs(product)) >= 1000.0) {
            factor = 1000.0;
            if (product >= 1000000.0) {
                factor = 1000000.0;
                if (product >= 1.0E9) {
                    factor = 1.0E9;
                    if (product >= 1.0E12) {
                        factor = 1.0E12;
                    }
                }
            }
        } else if (product < 0.01) {
            factor = 0.001;
            if (product < 9.999999999999999E-6) {
                factor = 1.0E-6;
                if (product < 1.0E-8) {
                    factor = 1.0E-9;
                    if (product < 1.0E-11) {
                        factor = 1.0E-12;
                    }
                }
            }
        }
        return factor;
    }

    public static String getFactorLabel(double factor) {
        String factorString = null;
        if (!Double.isNaN(factor)) {
            if (factor == 1.0E12) {
                factorString = RB.getStringResource("KPIChartRenderer.trillions.ex.txt");
            } else if (factor == 1.0E9) {
                factorString = RB.getStringResource("KPIChartRenderer.billions.ex.txt");
            } else if (factor == 1000000.0) {
                factorString = RB.getStringResource("KPIChartRenderer.millions.ex.txt");
            } else if (factor == 1000.0) {
                factorString = RB.getStringResource("KPIChartRenderer.thousands.ex.txt");
            } else if (factor == 1.0E-12) {
                factorString = RB.getStringResource("KPIChartRenderer.trillionths.ex.txt");
            } else if (factor == 1.0E-9) {
                factorString = RB.getStringResource("KPIChartRenderer.billionths.ex.txt");
            } else if (factor == 1.0E-6) {
                factorString = RB.getStringResource("KPIChartRenderer.millionths.ex.txt");
            } else if (factor == 0.001) {
                factorString = RB.getStringResource("KPIChartRenderer.thousandths.ex.txt");
            }
        }
        return factorString;
    }

    public static int getRangeSegmentIndex(KPIChartSegmentedRangeColorModel rangeModel, double value) {
        if (rangeModel.isBoundaryValue()) {
            List<BoundaryValue> values = rangeModel.getBoundaryValues();
            return Util.getValueIndex(values, value);
        }
        double[] rangeValues = rangeModel.getSegmentedRange();
        boolean boundaryInHigherSegment = rangeModel.isBoundaryInHigherSegment();
        if (Util.isBoundReverse(rangeValues)) {
            if (value < rangeValues[rangeValues.length - 1]) {
                return rangeValues.length;
            }
            if (value > rangeValues[0]) {
                return -1;
            }
            for (int i = 1; i < rangeValues.length; ++i) {
                if (!(value > rangeValues[i]) && (!boundaryInHigherSegment || value != rangeValues[i])) continue;
                return i - 1;
            }
        } else {
            if (value < rangeValues[0]) {
                return -1;
            }
            if (value > rangeValues[rangeValues.length - 1]) {
                return rangeValues.length;
            }
            for (int i = 1; i < rangeValues.length; ++i) {
                if (!(value < rangeValues[i]) && (boundaryInHigherSegment || value != rangeValues[i])) continue;
                return i - 1;
            }
        }
        return rangeValues.length - 2;
    }

    public static Color getRangeSegmentColor(KPIChartSegmentedRangeColorModel rangeModel, double value, boolean activeColor) {
        boolean isReverse;
        int segIndex;
        if (rangeModel.isBoundaryValue()) {
            List<BoundaryValue> values = rangeModel.getBoundaryValues();
            segIndex = Util.getValueIndex(values, value);
            isReverse = Util.isBoundReverse(values);
        } else {
            double[] values = rangeModel.getSegmentedRange();
            segIndex = Util.getRangeSegmentIndex(rangeModel, value);
            isReverse = Util.isBoundReverse(values);
        }
        return Util.getColor(rangeModel, segIndex, activeColor, isReverse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Color[] copyOf(Color[] colors) {
        if (colors == null) {
            return null;
        }
        Color[] colorArray = colors;
        synchronized (colors) {
            Color[] copyOfColors = new Color[colors.length];
            System.arraycopy(colors, 0, copyOfColors, 0, copyOfColors.length);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return copyOfColors;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] copyOf(double[] doubles) {
        if (doubles == null) {
            return null;
        }
        double[] dArray = doubles;
        synchronized (doubles) {
            double[] copyOfDoubles = new double[doubles.length];
            System.arraycopy(doubles, 0, copyOfDoubles, 0, copyOfDoubles.length);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return copyOfDoubles;
        }
    }

    private static int getValueIndex(List<BoundaryValue> values, double value) {
        if (values.size() == 1) {
            return 0;
        }
        if (!Util.getMinBound(values).isValueInHigherSegment(value)) {
            return -1;
        }
        if (Util.getMaxBound(values).isValueInHigherSegment(value)) {
            return values.size();
        }
        if (Util.isBoundReverse(values)) {
            for (int i = 0; i < values.size() - 1; ++i) {
                BoundaryValue cur = values.get(i);
                BoundaryValue next = values.get(i + 1);
                if (cur.isValueInHigherSegment(value) || !next.isValueInHigherSegment(value)) continue;
                return i;
            }
        } else {
            for (int i = 0; i < values.size() - 1; ++i) {
                BoundaryValue cur = values.get(i);
                BoundaryValue next = values.get(i + 1);
                if (!cur.isValueInHigherSegment(value) || next.isValueInHigherSegment(value)) continue;
                return i;
            }
        }
        return values.size() - 1;
    }

    private static Color getColor(KPIChartSegmentedRangeColorModel rangeModel, int index, boolean activeColor, boolean isRangeReverse) {
        Color[] rangeColors = rangeModel.getMappedSegmentColors();
        Color[] activeColors = rangeModel.getMappedActiveSegmentColors();
        Color underflowColor = rangeModel.getUnderflowColor();
        Color overflowColor = rangeModel.getOverflowColor();
        if (activeColors == null || activeColors.length != rangeColors.length) {
            activeColors = rangeColors;
        }
        int segLength = rangeModel.getSegmentedRange().length;
        if (isRangeReverse && index >= segLength || !isRangeReverse && index == -1) {
            if (underflowColor != null) {
                return underflowColor;
            }
            index = isRangeReverse ? rangeColors.length - 1 : 0;
        } else if (isRangeReverse && index == -1 || !isRangeReverse && index == segLength) {
            if (overflowColor != null) {
                return overflowColor;
            }
            int n = index = isRangeReverse ? 0 : rangeColors.length - 1;
        }
        if (activeColor && activeColors[index] != null) {
            return activeColors[index];
        }
        return rangeColors[index];
    }

    private static boolean isBoundReverse(double[] values) {
        for (int i = 0; i < values.length - 1; ++i) {
            if (values[i] == values[i + 1]) continue;
            return values[i] > values[i + 1];
        }
        return false;
    }

    private static boolean isBoundReverse(List<BoundaryValue> values) {
        for (int i = 0; i < values.size() - 1; ++i) {
            if (values.get(i).getValue() == values.get(i + 1).getValue()) continue;
            return values.get(i).getValue() > values.get(i + 1).getValue();
        }
        return false;
    }

    private static BoundaryValue getMinBound(List<BoundaryValue> values) {
        return Util.isBoundReverse(values) ? values.get(values.size() - 1) : values.get(0);
    }

    private static BoundaryValue getMaxBound(List<BoundaryValue> values) {
        return Util.isBoundReverse(values) ? values.get(0) : values.get(values.size() - 1);
    }

    public static double[] convertBoundaryValuesToArray(List<BoundaryValue> values) {
        if (values == null) {
            return null;
        }
        double[] ranges = new double[values.size()];
        for (int j = 0; j < values.size(); ++j) {
            ranges[j] = values.get(j).getValue();
        }
        return ranges;
    }

    public static Color[] getColorList(Color[] actualColors, int noColorsRequired) {
        if (actualColors == null || actualColors.length == 0) {
            return null;
        }
        if (noColorsRequired == 1) {
            return new Color[]{actualColors[0]};
        }
        if (actualColors.length == noColorsRequired) {
            return Util.copyOf(actualColors);
        }
        Color[] computedColors = new Color[noColorsRequired];
        if (noColorsRequired < actualColors.length) {
            double increment = ((double)actualColors.length - 1.0) / ((double)noColorsRequired - 1.0);
            double counter = 0.0;
            for (int i = 0; i < computedColors.length; ++i) {
                computedColors[i] = actualColors[(int)Math.round(counter)];
                counter += increment;
            }
            return computedColors;
        }
        double middleIndex = ((double)actualColors.length - 1.0) / 2.0;
        int startRed = actualColors[(int)middleIndex].getRed();
        int endRed = actualColors[(int)Math.round(middleIndex)].getRed();
        int startGreen = actualColors[(int)middleIndex].getGreen();
        int endGreen = actualColors[(int)Math.round(middleIndex)].getGreen();
        int startBlue = actualColors[(int)middleIndex].getBlue();
        int endBlue = actualColors[(int)Math.round(middleIndex)].getBlue();
        Color middleColor = new Color(startRed + (endRed - startRed) / 2, startGreen + (endGreen - startGreen) / 2, startBlue + (endBlue - startBlue) / 2);
        Color startColor = actualColors[0];
        Color endColor = actualColors[actualColors.length - 1];
        startRed = middleColor.getRed();
        startGreen = middleColor.getGreen();
        startBlue = middleColor.getBlue();
        computedColors[0] = startColor;
        computedColors[computedColors.length - 1] = endColor;
        middleIndex = (double)(computedColors.length - 1) / 2.0;
        for (int i = 1; i < computedColors.length - 1; ++i) {
            Color endPointColor = (double)i < middleIndex ? startColor : endColor;
            double distanceFromMiddle = Math.abs(middleIndex - (double)i) / middleIndex;
            endRed = endPointColor.getRed();
            endGreen = endPointColor.getGreen();
            endBlue = endPointColor.getBlue();
            computedColors[i] = new Color((int)((double)startRed + (double)(endRed - startRed) * distanceFromMiddle), (int)((double)startGreen + (double)(endGreen - startGreen) * distanceFromMiddle), (int)((double)startBlue + (double)(endBlue - startBlue) * distanceFromMiddle));
        }
        return computedColors;
    }
}

