/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.MissingValues;
import com.sas.graphics.util.gtk.Sort;
import java.util.Locale;

class UniqueValue {
    private String formattedValue;
    private MissingValues missingValue;
    private double number;
    private String string;
    private boolean compareByFormattedValue;
    private int firstOccurringIndex;
    private int category;

    public UniqueValue() {
    }

    public UniqueValue(UniqueValue uv, int firstOccurringIndex, int category) {
        this.formattedValue = uv.formattedValue;
        this.missingValue = uv.missingValue;
        this.number = uv.number;
        this.string = uv.string;
        this.compareByFormattedValue = uv.compareByFormattedValue;
        this.firstOccurringIndex = firstOccurringIndex;
        this.category = category;
    }

    public void setCompareByFormattedValue(boolean b) {
        this.compareByFormattedValue = b;
    }

    public boolean getCompareByFormattedValue() {
        return this.compareByFormattedValue;
    }

    public Class getValueType() {
        Class result = String.class;
        if (this.string == null) {
            result = Double.TYPE;
        }
        return result;
    }

    public boolean isMissing() {
        return this.missingValue != null;
    }

    public Object getValue(boolean useFormattedValue, boolean isNumeric) {
        if (this.isMissing()) {
            return this.missingValue;
        }
        if (useFormattedValue) {
            return this.formattedValue;
        }
        if (isNumeric) {
            return new Double(this.number);
        }
        return this.string;
    }

    public void setFormattedValue(String formattedValue) {
        this.formattedValue = formattedValue;
    }

    public String getFormattedValue() {
        return this.formattedValue;
    }

    public void setValue(Object value) {
        if (value instanceof String) {
            this.setValue((String)value);
        } else if (value instanceof Number) {
            this.setValue(((Number)value).doubleValue());
        } else if (value instanceof MissingValues) {
            this.setValue((MissingValues)value);
        } else {
            throw new IllegalStateException("Unkown type.");
        }
    }

    public void setValue(double value) {
        this.number = value;
        this.missingValue = null;
        this.string = null;
    }

    public double getDoubleValue() {
        return this.number;
    }

    public void setValue(String value) {
        this.string = value;
        this.missingValue = null;
    }

    public String getStringValue() {
        return this.string;
    }

    public void setValue(MissingValues missingValue) {
        this.string = null;
        this.formattedValue = null;
        this.missingValue = missingValue;
    }

    public MissingValues getMissingValue() {
        return this.missingValue;
    }

    public void setCategory(int category) {
        this.category = category;
    }

    public int getCategory() {
        return this.category;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UniqueValue)) {
            return false;
        }
        UniqueValue uv = (UniqueValue)obj;
        boolean result = this.compareByFormattedValue ? this.formattedValue.equals(uv.formattedValue) : (this.missingValue != null ? this.missingValue == uv.missingValue : (this.string != null ? this.string.equals(uv.string) : this.number == uv.number));
        return result;
    }

    public int hashCode() {
        int hash;
        if (this.compareByFormattedValue) {
            hash = this.formattedValue.hashCode();
        } else if (this.string != null) {
            hash = this.string.hashCode();
        } else if (this.missingValue != null) {
            hash = this.missingValue.hashCode();
        } else {
            long bits = Double.doubleToLongBits(this.number);
            hash = (int)(bits ^ bits >> 32);
        }
        return hash;
    }

    public String toString() {
        return "number=" + this.number + " string=" + this.string + " missingValue=" + this.missingValue + " formattedValue=" + this.formattedValue + " category=" + this.category;
    }

    public int getFirstOccuringIndex() {
        return this.firstOccurringIndex;
    }

    static class UniqueValueComparator
    extends Sort.SortComparator {
        private boolean sortByFormattedValue;
        private boolean isNumeric;

        public UniqueValueComparator(boolean sortByFormattedValue, boolean isNumeric, int sortOrder, Locale locale, int sortStrategy) {
            super(sortOrder, locale, sortStrategy);
            this.sortByFormattedValue = sortByFormattedValue;
            this.isNumeric = isNumeric;
        }

        public int compare(Object o1, Object o2) {
            UniqueValue uv1 = (UniqueValue)o1;
            UniqueValue uv2 = (UniqueValue)o2;
            o1 = uv1.getValue(this.sortByFormattedValue, this.isNumeric);
            o2 = uv2.getValue(this.sortByFormattedValue, this.isNumeric);
            return Sort.compare(o1, o2, o1 instanceof Number, this);
        }
    }
}

