/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.Style;
import java.awt.Color;

public class TickMarkStyle
extends Style {
    public static final int INNER = 0;
    public static final int OUTER = 1;
    public static final int INNER_AND_OUTER = 2;
    private Color color;
    private int tickMarkJustification;
    private int lineWidth;
    private double length;
    private int minorTickCount;

    public TickMarkStyle() {
        this.color = Color.black;
        this.tickMarkJustification = 1;
        this.minorTickCount = 1;
        this.lineWidth = 1;
        this.length = 0.5;
    }

    public TickMarkStyle(TickMarkStyle style) {
        this.color = style.color;
        this.tickMarkJustification = style.tickMarkJustification;
        this.minorTickCount = style.minorTickCount;
        this.lineWidth = style.lineWidth;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public double getLength() {
        return this.length;
    }

    public void setColor(Color aColor) {
        if (aColor != null) {
            this.color = aColor;
        }
    }

    public void setTickMarkJustification(int tmj) {
        if (tmj >= 0 && tmj <= 2) {
            this.tickMarkJustification = tmj;
        }
    }

    public void setLineWidth(int width) {
        this.lineWidth = width;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setMinorTickCount(int num) {
        this.minorTickCount = num >= 0 ? num : 0;
    }

    public Color getColor() {
        return this.color;
    }

    public int getTickMarkJustification() {
        return this.tickMarkJustification;
    }

    public int getMinorTickCount() {
        return this.minorTickCount;
    }
}

