/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.Variable;
import com.sas.table.FormattedInterface;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

abstract class TableModelConnection
implements Pipe,
TableModelListener {
    protected TableModel data;
    protected int variableIndex;
    private int valueCount = 0;
    private String variableName = "";
    private String resultSetId = null;
    private GTKFormat format;
    private Variable variable;
    private static final String bqa_className = "com.sas.storage.iquery.BusinessQueryToTableModelAdapter";
    private boolean removeTotalValue = true;

    @Override
    public void init(AInitAction initAction) {
        initAction.setValueCount(this.valueCount);
        initAction.setLocale(this.variable.getLocale());
    }

    @Override
    public void reset(AResetAction resetAction) {
    }

    @Override
    public Formatter getFormatter() {
        return null;
    }

    public int getValueCount() {
        return this.valueCount;
    }

    String getResultSetId() {
        return this.resultSetId;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public GTKFormat getFormat() {
        return this.format;
    }

    public TableModelConnection(Variable variable) {
        this.variable = variable;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.variable.setModified(true);
    }

    public void connectFrom(TableModel data, int variableIndex) {
        if (data == null) {
            throw new RuntimeException("Attempt to connect a null data source.");
        }
        if (this.data != null) {
            this.data.removeTableModelListener(this);
        }
        data.addTableModelListener(this);
        this.data = data;
        this.variableIndex = variableIndex;
        this.variableName = data.getColumnName(variableIndex);
        this.resultSetId = TableModelConnection.findResultSetId(data, variableIndex);
        Locale locale = this.findLocale();
        this.variable.setLocale(locale);
        this.saveValueCount();
    }

    private Locale findLocale() {
        Locale result = Locale.getDefault();
        if (bqa_className.equals(this.data.getClass().getName())) {
            try {
                Method m = this.data.getClass().getMethod("getFormatLocale", null);
                Object l = m.invoke((Object)this.data, null);
                if (l instanceof Locale) {
                    result = (Locale)l;
                }
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return result;
    }

    static String findColumnName(TableModel data, String resultSetId) {
        String result = null;
        int n = data.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String id = TableModelConnection.findResultSetId(data, i);
            if (id == null || !id.equals(resultSetId)) continue;
            result = data.getColumnName(i);
            break;
        }
        return result;
    }

    private static String findResultSetId(TableModel data, int index) {
        String result = null;
        if (bqa_className.equals(data.getClass().getName())) {
            try {
                Method m = data.getClass().getMethod("getModel", null);
                Object businessQuery = m.invoke((Object)data, null);
                m = businessQuery.getClass().getMethod("getResultItems", null);
                List dataItems = (List)m.invoke(businessQuery, null);
                Object dataItem = dataItems.get(index);
                m = dataItem.getClass().getMethod("getResultSetID", null);
                result = (String)m.invoke(dataItem, null);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return result;
    }

    private boolean isTotalValuePresent() {
        boolean result = false;
        if (bqa_className.equals(this.data.getClass().getName())) {
            String roleClassName = "com.sas.iquery.metadata.business.Role";
            String BusinessQueryClassName = "com.sas.iquery.metadata.business.BusinessQuery";
            String getBusinessQuery = "getBusinessQuery";
            String getTotalType = "getTotalType";
            try {
                Method m = this.data.getClass().getMethod(getBusinessQuery, null);
                Object businessQuery = m.invoke((Object)this.data, null);
                Class<?> roleClass = Class.forName(roleClassName);
                Object roleDotColumn = roleClass.getField("COLUMN").get(null);
                m = businessQuery.getClass().getMethod(getTotalType, roleClass);
                String totalType = (String)m.invoke(businessQuery, roleDotColumn);
                String businessQueryDotTotalNone = (String)Class.forName(BusinessQueryClassName).getField("TOTAL_NONE").get(null);
                if (totalType != null && !businessQueryDotTotalNone.equals(totalType)) {
                    --this.valueCount;
                }
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return result;
    }

    public void connectFrom(TableModel data, String variableName) {
        if (data == null) {
            throw new RuntimeException("Attempt to connect a null data source.");
        }
        this.connectFrom(data, TableModelConnection.nameToIndex(data, variableName));
    }

    public Object getTableValue(int index) {
        Object value = null;
        value = this.data instanceof FormattedInterface ? ((FormattedInterface)this.data).getUnformattedValueAt(index, this.variableIndex) : this.data.getValueAt(index, this.variableIndex);
        return value;
    }

    public void disconnect() {
        if (this.data != null) {
            this.data.removeTableModelListener(this);
        }
        this.data = null;
        this.variableIndex = -1;
        this.valueCount = 0;
    }

    private void saveValueCount() {
        if (this.data != null) {
            this.valueCount = this.data.getRowCount();
            if (this.removeTotalValue && this.isTotalValuePresent()) {
                --this.valueCount;
            }
        } else {
            this.valueCount = 0;
        }
    }

    public void setModified() {
        this.saveValueCount();
    }

    public static int nameToIndex(TableModel data, String name) {
        int result = -1;
        if (data != null) {
            for (int i = 0; i < data.getColumnCount(); ++i) {
                if (!name.equals(data.getColumnName(i))) continue;
                result = i;
                break;
            }
        }
        return result;
    }

    public void setRemoveTotalValue(boolean trueOrFalse) {
        this.removeTotalValue = trueOrFalse;
    }

    public boolean isRemoveTotalValue() {
        return this.removeTotalValue;
    }
}

