/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.MissingValues;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericTableModelConnection;
import com.sas.graphics.util.gtk.NumericVariable;
import javax.swing.table.TableModel;

public class SummarizedDataTableModelVariable
extends NumericVariable {
    private SummarizedDataConnection connection = new SummarizedDataConnection();

    @Override
    protected int getRawValueCount() {
        return this.connection.getValueCount();
    }

    public void connectFrom(TableModel data, int sumVariableIndex, int freqVariableIndex) {
        this.connection.connectFrom(data, sumVariableIndex, freqVariableIndex);
        this.connectFrom();
    }

    public void connectFrom(TableModel data, String sumVariableLabel, String freqVariableIndex) {
        this.connection.connectFrom(data, sumVariableLabel, freqVariableIndex);
        this.connectFrom();
    }

    @Override
    protected void connectFrom() {
        this.setRawValuePipe(this.connection, this.connection.getValueCount());
        if (this.getName().startsWith(defaultName)) {
            this.setName(this.connection.getVariableName());
        }
        super.connectFrom();
        if (this.connection.getFormat() != null) {
            this.setFormat(this.connection.getFormat());
        }
    }

    @Override
    public void disconnect() {
        this.connection.disconnect();
        super.disconnect();
    }

    @Override
    public boolean isRawValueMissing(int index) {
        return this.connection.isMissing(index);
    }

    @Override
    public void setModified(boolean modified) {
        super.setModified(modified);
        if (modified && this.connection != null) {
            this.connection.setModified();
        }
    }

    public void setStatisticType(int statisticType) {
        this.connection.setStatisticType(statisticType);
        this.setModified(true);
    }

    public int getStatisticType() {
        return this.connection.getStatisticType();
    }

    private class SummarizedDataConnection
    implements NumericPipe {
        private NumericTableModelConnection sumConnection;
        private NumericTableModelConnection freqConnection;
        private int statisticType;

        private SummarizedDataConnection() {
            this.sumConnection = new NumericTableModelConnection(SummarizedDataTableModelVariable.this);
            this.freqConnection = new NumericTableModelConnection(SummarizedDataTableModelVariable.this);
            this.statisticType = 6;
        }

        public int getValueCount() {
            int sumVC = this.sumConnection.getValueCount();
            int freqVC = this.freqConnection.getValueCount();
            return Math.max(sumVC, freqVC);
        }

        public GTKFormat getFormat() {
            return this.sumConnection.getFormat();
        }

        public String getVariableName() {
            return this.sumConnection.getVariableName() + "_" + this.freqConnection.getVariableName();
        }

        public void setModified() {
            this.sumConnection.setModified();
            this.freqConnection.setModified();
        }

        public boolean isMissing(int index) {
            return this.sumConnection.isMissing(index) | this.freqConnection.isMissing(index);
        }

        public void disconnect() {
            this.sumConnection.disconnect();
            this.freqConnection.disconnect();
        }

        public void connectFrom(TableModel data, String sumVariableLabel, String freqVariableLabel) {
            this.sumConnection.connectFrom(data, sumVariableLabel);
            this.freqConnection.connectFrom(data, freqVariableLabel);
        }

        public void connectFrom(TableModel data, int sumVariableIndex, int freqVariableIndex) {
            this.sumConnection.connectFrom(data, sumVariableIndex);
            this.freqConnection.connectFrom(data, freqVariableIndex);
        }

        @Override
        public double getValue(int index) throws MissingValueException {
            switch (this.statisticType) {
                case 6: {
                    return this.sumConnection.getValue(index);
                }
                case 2: {
                    return this.freqConnection.getValue(index);
                }
                case 1: {
                    double s = this.sumConnection.getValue(index);
                    double f = this.freqConnection.getValue(index);
                    if (f > 0.0) {
                        return s / f;
                    }
                    MissingValueException mv = MissingValueException.getDefaultMissingValueExeption();
                    mv.setMissingValue(MissingValues.Dot);
                    throw mv;
                }
            }
            MissingValueException mv = MissingValueException.getDefaultMissingValueExeption();
            mv.setMissingValue(MissingValues.Dot);
            throw mv;
        }

        @Override
        public void init(AInitAction initAction) {
            this.sumConnection.init(initAction);
            this.freqConnection.init(initAction);
        }

        @Override
        public void reset(AResetAction resetAction) {
            this.sumConnection.reset(resetAction);
            this.freqConnection.reset(resetAction);
        }

        @Override
        public Formatter getFormatter() {
            return null;
        }

        public int getStatisticType() {
            return this.statisticType;
        }

        public void setStatisticType(int statisticType) {
            switch (statisticType) {
                case 1: 
                case 2: 
                case 6: {
                    this.statisticType = statisticType;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal statistic.  Legal statistics are: SUM, FREQ, MEAN");
                }
            }
            this.statisticType = statisticType;
        }
    }
}

