/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.IntegerPipeSwitcher;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringProperty;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.ValueMap;

public class StringToNumericMapper
extends NumericMapper {
    private StringToNumericMap map;
    private IntegerPipeSwitcher categorySwitcher = new IntegerPipeSwitcher();
    public final StringProperty input = new StringProperty(this, true);
    public final IntegerPipe category = this.categorySwitcher;

    public StringToNumericMapper() {
        StringToNumericMap m = new StringToNumericMap();
        m.addStringPipe(this.input);
        this.setMap(m);
    }

    public void setMap(StringToNumericMap map) {
        if (map == null) {
            throw new RuntimeException("null map");
        }
        this.map = map;
        map.setOwner(this);
        this.uniqueValueSwitcher.connectFrom(map.uniqueValue);
        this.labelSwitcher.connectFrom(map.label);
        this.categorySwitcher.connectFrom(map.category);
        super.setMap(map);
    }

    public void shareMap(StringToNumericMapper mapper) {
        this.setMap(mapper.map);
    }

    @Override
    protected ValueMap getValueMap() {
        return this.map;
    }

    @Override
    public double getValue(int i) throws MissingValueException {
        double d;
        try {
            String s = this.input.getValue(i);
            d = this.map.getValue(s, false);
        }
        catch (MissingValueException e) {
            if (this.isLabelMissingValues(e.getMissingValue())) {
                d = this.map.getValue(e.getMissingValue(), false);
            }
            throw e;
        }
        return d;
    }

    public double getValue(Object o) throws MissingValueException {
        this.init(new AInitAction());
        return this.map.getValue(o, false);
    }

    public String[] getInverseValues(double lowerBound, double upperBound) {
        return this.map.getInverseValues(lowerBound, upperBound);
    }

    @Override
    public double getOutputMin() {
        return this.map.getOutputMin();
    }

    @Override
    public double getOutputMax() {
        return this.map.getOutputMax();
    }

    public double getStrideValue() {
        return this.map.getStrideValue();
    }

    public double getStartValue() {
        return this.map.getStartValue();
    }

    public void setStrideValue(double value) {
        this.map.setStrideValue(value);
    }

    public void setStartValue(double value) {
        this.map.setStartValue(value);
    }

    public void addStringPipe(StringPipe pipe) {
        this.map.addStringPipe(pipe);
    }

    public void removeAllStringPipes() {
        this.map.removeAllStringPipes();
    }

    public void removeStringPipe(StringPipe pipe) {
        this.map.removeStringPipe(pipe);
    }

    public int getStringPipeCount() {
        return this.map.getStringPipeCount();
    }

    public StringPipe getStringPipe(int i) {
        return this.map.getStringPipe(i);
    }

    public void setSortType(int sortType) {
        this.map.setSortType(sortType);
    }

    public int getSortType() {
        return this.map.getSortType();
    }

    public int getUniqueValueCount() {
        return this.map.getUniqueValueCount();
    }
}

