/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.MissingValues;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.AnimationConnection;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.Variable;
import java.util.List;

public class StringAnimationVariable
extends StringVariable {
    private Variable connectionVariable;
    private StringAnimationConnection connection = new StringAnimationConnection(this);

    @Override
    public void connectFrom(StringVariable sv) {
        this.connectionVariable = sv;
        super.connectFrom(sv);
        this.connectFrom();
    }

    @Override
    public void connectFrom(NumericVariable nv) {
        this.connectionVariable = nv;
        super.connectFrom(nv);
        this.connectFrom();
    }

    @Override
    protected void connectFrom() {
        this.setRawValuePipe(this.connection, -1);
        this.connection.setConnection(this.connectionVariable);
        super.connectFrom();
        if (this.connectionVariable instanceof StringVariable) {
            this.getUniqueValueSwitcher().connectFrom(((StringVariable)this.connectionVariable).uniqueValue);
            this.getFormattedUniqueValueSwitcher().connectFrom(((StringVariable)this.connectionVariable).formattedUniqueValue);
        } else {
            this.getUniqueValueSwitcher().connectFrom(((NumericVariable)this.connectionVariable).formattedValue);
            this.getFormattedUniqueValueSwitcher().connectFrom(((NumericVariable)this.connectionVariable).formattedUniqueValue);
        }
    }

    @Override
    public void setUniqueValueSort(int sortType) {
        super.setUniqueValueSort(sortType);
        if (this.connectionVariable != null) {
            this.connectionVariable.setUniqueValueCount(sortType);
        }
    }

    @Override
    public int getUniqueValueCount() {
        AInitAction ia = new AInitAction();
        ia.setAnimationInitRequired(true);
        this.uniqueValue.init(ia);
        ia.setAnimationInitRequired(false);
        return ia.getValueCount();
    }

    void setFrame(List valueIndexToByGroupPair, int pairCount, double interploationPercentage) {
        this.connection.setFrame(valueIndexToByGroupPair, pairCount, interploationPercentage);
    }

    void setAnimationIdVariable(Variable v) {
        this.connection.setAnimationIdVariable(v);
    }

    @Override
    protected int getRawValueCount() {
        return this.connectionVariable.getValueCount();
    }

    @Override
    public boolean isModified() {
        return this.connection.isModified();
    }

    private static class StringAnimationConnection
    extends AnimationConnection
    implements StringPipe {
        @Override
        public String getValue(int i) throws MissingValueException {
            int[] pair = this.getKeyFramePair(i);
            if (pair == null) {
                MissingValueException mve = MissingValueException.getDefaultMissingValueExeption();
                mve.setMissingValue(MissingValues._BLANK_);
                throw mve;
            }
            String s = this.getStringConnection().value.getValue(pair[0]);
            return s;
        }

        public StringAnimationConnection(Variable v) {
            super(v);
        }

        public boolean isMissing(int i) {
            try {
                this.getStringConnection().value.getValue(i);
                return false;
            }
            catch (MissingValueException e) {
                return true;
            }
        }

        @Override
        public void reset(AResetAction resetAction) {
        }
    }
}

