/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.Debug;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.Variable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;

public abstract class SocketConnection
implements Pipe {
    private int valueCount = 0;
    private String variableLabel = new String();
    private GTKFormat format;
    private boolean done = false;
    private Socket dataSocket;
    private Thread socketThread = null;
    private Variable container;
    protected int bufferSize;
    protected int origin = 0;
    protected DataInputStream inputStream;

    @Override
    public void init(AInitAction initAction) {
        initAction.setValueCount(this.valueCount);
    }

    @Override
    public void reset(AResetAction resetAction) {
    }

    @Override
    public Formatter getFormatter() {
        return null;
    }

    public String getVariableLabel() {
        return this.variableLabel;
    }

    public GTKFormat getFormat() {
        return this.format;
    }

    public SocketConnection(Variable v, int aBufferSize) {
        this.container = v;
        this.bufferSize = aBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getValueCount() {
        int vc;
        SocketConnection socketConnection = this;
        synchronized (socketConnection) {
            vc = this.valueCount;
        }
        return vc;
    }

    public void connectFrom(String host, int port) {
        if (this.socketThread != null) {
            this.disconnect();
        }
        try {
            this.dataSocket = new Socket(host, port);
            this.startReader();
        }
        catch (UnknownHostException uhe) {
            Debug.println((String)("Server connection failure: " + uhe.toString()));
        }
        catch (IOException ioe) {
            Debug.println((String)("Server connection failure: " + ioe.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.done = true;
        this.socketThread = null;
        SocketConnection socketConnection = this;
        synchronized (socketConnection) {
            this.valueCount = 0;
        }
    }

    protected abstract void readIntoBuffer(int var1) throws IOException;

    private void startReader() {
        if (this.socketThread == null) {
            this.socketThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        SocketConnection.this.inputStream = new DataInputStream(SocketConnection.this.dataSocket.getInputStream());
                        PrintWriter out = new PrintWriter(SocketConnection.this.dataSocket.getOutputStream(), true);
                        while (!SocketConnection.this.done) {
                            SocketConnection socketConnection = SocketConnection.this;
                            synchronized (socketConnection) {
                                int index = (SocketConnection.this.origin + SocketConnection.this.valueCount) % SocketConnection.this.bufferSize;
                                SocketConnection.this.readIntoBuffer(index);
                                SocketConnection.this.container.setModified(true);
                                if (SocketConnection.this.valueCount < SocketConnection.this.bufferSize) {
                                    ++SocketConnection.this.valueCount;
                                } else if (++SocketConnection.this.origin == SocketConnection.this.bufferSize) {
                                    SocketConnection.this.origin = 0;
                                }
                            }
                        }
                        out.println("eot");
                        SocketConnection.this.dataSocket.close();
                        SocketConnection.this.dataSocket = null;
                    }
                    catch (IOException ioe) {
                        Debug.println((String)ioe.toString());
                        SocketConnection.this.dataSocket = null;
                    }
                }
            });
            this.socketThread.setDaemon(true);
            this.socketThread.start();
        }
    }
}

