/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import javax.swing.ListSelectionModel;

public class RelationalListSelectionVariable
extends NumericVariable {
    private RelationalListSelectionConnection connection = new RelationalListSelectionConnection(this);

    @Override
    protected int getRawValueCount() {
        return this.connection.getValueCount();
    }

    public void connectFrom(ListSelectionModel selectionModel) {
        this.connection.connectFrom(selectionModel);
        this.connectFrom();
    }

    @Override
    protected void connectFrom() {
        this.setRawValuePipe(this.connection, this.connection.getValueCount());
        if (this.getName().startsWith(defaultName)) {
            this.setName(this.connection.getVariableName());
            this.setLabel(this.connection.getVariableLabel());
        }
        super.connectFrom();
        if (this.connection.getFormat() != null) {
            this.setFormat(this.connection.getFormat());
        }
    }

    @Override
    public void disconnect() {
        this.connection.disconnect();
        super.disconnect();
    }

    @Override
    public boolean isRawValueMissing(int index) {
        return this.connection.isMissing(index);
    }

    @Override
    public void setModified(boolean modified) {
        super.setModified(modified);
        if (modified && this.connection != null) {
            this.connection.setModified();
        }
    }

    public int getValueIndexPriorToProcessing(int valueIndex) {
        return valueIndex;
    }

    private static class RelationalListSelectionConnection
    implements NumericPipe {
        private ListSelectionModel selectionModel;
        private String label = null;
        private String name;

        @Override
        public void init(AInitAction initAction) {
        }

        @Override
        public void reset(AResetAction resetAction) {
        }

        @Override
        public Formatter getFormatter() {
            return null;
        }

        public void setModified() {
        }

        public int getValueCount() {
            return -1;
        }

        public GTKFormat getFormat() {
            return null;
        }

        public void disconnect() {
        }

        public RelationalListSelectionConnection(NumericVariable variable) {
        }

        public String getVariableLabel() {
            return this.label;
        }

        public String getVariableName() {
            return this.name;
        }

        public void connectFrom(ListSelectionModel selectionModel) {
            this.selectionModel = selectionModel;
            this.label = "relationalListSelectionVariable";
            this.name = "relationalListSelectionVariable";
        }

        @Override
        public double getValue(int valueIndex) throws MissingValueException {
            boolean isSelected = this.selectionModel.isSelectedIndex(valueIndex);
            return isSelected ? 1.0 : 0.0;
        }

        public boolean isMissing(int index) {
            return false;
        }
    }
}

