/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.PropertyContainer;

public abstract class Property
implements Pipe {
    private PropertyContainer container;

    public Property() {
        this.container = null;
    }

    public Property(PropertyContainer aContainer, boolean initByContainer) {
        if (aContainer != null) {
            this.container = aContainer;
            if (initByContainer) {
                this.container.addProperty(this);
            }
        }
    }

    public void setInitByContainer(boolean initByContainer) {
        if (initByContainer) {
            if (!this.container.containsProperty(this)) {
                this.container.addProperty(this);
            }
        } else {
            this.container.removeProperty(this);
        }
    }

    public boolean isConnected() {
        return this.getPipe() != null;
    }

    public abstract void disconnect();

    protected void setModified() {
        if (this.container != null) {
            this.container.setModified();
        }
    }

    protected abstract Pipe getPipe();

    @Override
    public void reset(AResetAction resetAction) {
        Pipe pipe = this.getPipe();
        if (pipe != null) {
            pipe.reset(resetAction);
        }
    }

    @Override
    public void init(AInitAction initAction) {
        Pipe pipe = this.getPipe();
        if (pipe != null) {
            pipe.init(initAction);
        }
    }

    @Override
    public Formatter getFormatter() {
        Pipe pipe = this.getPipe();
        if (pipe != null) {
            return pipe.getFormatter();
        }
        return Formatter.defaultFormatter;
    }
}

