/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.MissingValues;
import com.sas.graphics.util.Debug;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.BooleanPipe;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.LineConnectorDetail;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.PropertyContainer;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringProperty;
import com.sas.graphics.util.gtk.ValueMap;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Probe
extends PropertyContainer {
    public final StringProperty title = new StringProperty(this, false);
    private Font font = FontManager.getDefaultFont();
    private Color backgroundColor = new Color(0.85f, 0.85f, 0.75f);
    private Color foregroundColor = Color.black;
    private Rectangle viewport;
    private String connectionString;
    private String leftPad;
    private String rightPad;
    private Insets insets;
    private Integer textBuffer;
    private static final String DEFAULT_CONNECTION_STRING = " = ";
    private static final String DEFAULT_LEFT_PAD = " ";
    private static final String DEFAULT_RIGHT_PAD = " ";
    private static Insets DEFAULT_INSETS = new Insets(2, 2, 2, 2);
    private static Integer DEFAULT_TEXT_BUFFER = new Integer(2);
    private static final char[] NEWLINE = new char[]{' ', '\n'};
    private static final String INVALID_PIPE = " Invalid pipe ";
    private static final int SEARCH_BY_NAME = 0;
    private static final int SEARCH_BY_STRING = 1;
    private static final int SEARCH_BY_PIPE = 2;
    private Vector entries = new Vector();
    private String missingReplacement = null;
    private Hashtable missingReplacementTable = null;
    private int pointerOffset = 30;
    private boolean trimOn = false;
    private AInitAction initAction = new AInitAction();
    private final MultiLineStringMetrics multiLineStringMetrics = new MultiLineStringMetrics();
    private final BreakIndexInfo breakIndexInfo = new BreakIndexInfo();
    private StringBuffer scratchStringBuffer = new StringBuffer(300);
    private LineConnectorDetail lineConnectorDetail;
    private static final String[] breakStrings = new String[]{"\n", "\r", "&#13", "&#10", "^[n]^"};

    public void setPointerOffset(int pointerOffset) {
        this.pointerOffset = pointerOffset;
    }

    public int getPointerOffset() {
        return this.pointerOffset;
    }

    public void setFont(Font aFont) {
        this.font = aFont;
    }

    public Font getFont() {
        return this.font;
    }

    public boolean isTrimOn() {
        return this.trimOn;
    }

    public void setTrimOn(boolean trimOn) {
        this.trimOn = trimOn;
    }

    public void setMissingReplacement(String string) {
        this.missingReplacement = string;
    }

    public String getMissingReplacement() {
        return this.missingReplacement;
    }

    public void setMissingReplacement(String string, MissingValues missingValue) {
        if (this.missingReplacementTable == null) {
            this.missingReplacementTable = new Hashtable();
        }
        this.missingReplacementTable.put(missingValue, string);
    }

    public String getMissingReplacement(MissingValues missingValue) {
        Object value;
        String result = this.missingReplacement;
        if (this.missingReplacementTable != null && (value = this.missingReplacementTable.get(missingValue)) != null) {
            result = (String)value;
        }
        if (result == null) {
            result = this.missingReplacement;
        }
        if (result == null) {
            result = ValueMap.getDefaultMissingValueLabel(missingValue);
        }
        return result;
    }

    public void setViewport(int x, int y, Dimension dimension) {
        this.setViewport(x, y, dimension.width, dimension.height);
    }

    public void setViewport(int width, int height, Insets insets) {
        this.setViewport(insets.left, insets.top, width - insets.left - insets.right, height - insets.top - insets.bottom);
    }

    public void setViewport(int x, int y, int width, int height) {
        if (this.viewport == null) {
            this.viewport = new Rectangle();
        }
        this.viewport.x = x;
        this.viewport.y = y;
        this.viewport.width = width;
        this.viewport.height = height;
    }

    public Rectangle getViewport() {
        return this.viewport;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setForegroundColor(Color color) {
        this.foregroundColor = color;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setConnectionString(String s) {
        this.connectionString = s == null ? DEFAULT_CONNECTION_STRING : s;
    }

    public String getconnectionString() {
        return this.connectionString == null ? DEFAULT_CONNECTION_STRING : this.connectionString;
    }

    public void setLeftPad(String s) {
        this.leftPad = s == null ? " " : s;
    }

    public String getLeftPad() {
        return this.leftPad == null ? " " : this.leftPad;
    }

    public void setRightPad(String s) {
        this.rightPad = s == null ? " " : s;
    }

    public String getRightPad() {
        return this.rightPad == null ? " " : this.rightPad;
    }

    public void setInsets(Insets i) {
        this.insets = i == null ? DEFAULT_INSETS : i;
    }

    public Insets getInsets() {
        return this.insets == null ? DEFAULT_INSETS : this.insets;
    }

    public void setTextBuffer(int i) {
        this.textBuffer = i > 0 ? new Integer(i) : DEFAULT_TEXT_BUFFER;
    }

    public int getTextBuffer() {
        return this.textBuffer == null ? DEFAULT_TEXT_BUFFER.intValue() : this.textBuffer.intValue();
    }

    public void addPipe(String name, Pipe pipe) {
        this.entries.addElement(new ProbeEntry(name, pipe));
    }

    public void addString(String name, String string) {
        StringProperty sp = new StringProperty();
        sp.setValue(string);
        this.entries.addElement(new ProbeEntry(name, sp));
    }

    public ProbeEntry getProbeEntry(String aName) {
        Lookup lu = this.lookup(aName, null, null, 0);
        return lu.probeEntry;
    }

    public ProbeEntry getProbeEntry(Pipe aPipe) {
        Lookup lu = this.lookup(null, aPipe, null, 2);
        return lu.probeEntry;
    }

    public void removePipe(Pipe aPipe) {
        Lookup lu = this.lookup(null, aPipe, null, 2);
        if (lu.i >= 0) {
            this.entries.removeElementAt(lu.i);
        }
    }

    public void removeName(String aName) {
        Lookup lu = this.lookup(aName, null, null, 0);
        if (lu.i >= 0) {
            this.entries.removeElementAt(lu.i);
        }
    }

    public void removeString(String aString) {
        Lookup lu = this.lookup(null, null, aString, 1);
        if (lu.i >= 0) {
            this.entries.removeElementAt(lu.i);
        }
    }

    private Lookup lookup(String aName, Pipe aPipe, String aString, int searchType) {
        Lookup lu = new Lookup();
        int n = this.entries.size();
        block5: for (int i = 0; i < n; ++i) {
            ProbeEntry pe = (ProbeEntry)this.entries.elementAt(i);
            switch (searchType) {
                case 0: {
                    if (!pe.getName().equals(aName)) continue block5;
                    lu.i = i;
                    lu.probeEntry = pe;
                    return lu;
                }
                case 2: {
                    if (pe.getPipe() != aPipe) continue block5;
                    lu.i = i;
                    lu.probeEntry = pe;
                    return lu;
                }
                case 1: {
                    if (!pe.getString().equals(aString)) continue block5;
                    lu.i = i;
                    lu.probeEntry = pe;
                    return lu;
                }
            }
        }
        return lu;
    }

    public void removeAll() {
        this.entries.removeAllElements();
    }

    public String getString(int valueIndex) {
        if (this.leftPad == null) {
            this.leftPad = " ";
        }
        if (this.connectionString == null) {
            this.connectionString = DEFAULT_CONNECTION_STRING;
        }
        this.scratchStringBuffer.setLength(0);
        int n = this.entries.size();
        for (int i = 0; i < n; ++i) {
            ProbeEntry probeEntry = (ProbeEntry)this.entries.elementAt(i);
            this.scratchStringBuffer.append(this.leftPad + probeEntry.getName() + this.connectionString);
            Pipe p = probeEntry.getPipe();
            String s = this.getValue(p, valueIndex);
            this.scratchStringBuffer.append(s);
            this.scratchStringBuffer.append(NEWLINE);
        }
        return this.scratchStringBuffer.toString();
    }

    public String[] getLabels() {
        int size = this.entries.size();
        String[] labels = new String[size];
        if (this.leftPad == null) {
            this.leftPad = " ";
        }
        for (int ii = 0; ii < size; ++ii) {
            String label = ((ProbeEntry)this.entries.elementAt(ii)).getName();
            labels[ii] = label != null ? this.leftPad + ((ProbeEntry)this.entries.elementAt(ii)).getName() : "";
        }
        return labels;
    }

    private String getValue(Pipe p, int valueIndex) {
        String s = "";
        Formatter format = p.getFormatter();
        if (p != null) {
            try {
                if (p instanceof StringPipe) {
                    StringPipe sp = (StringPipe)p;
                    s = format.format(sp.getValue(valueIndex));
                    if (this.isTrimOn()) {
                        s = s.trim();
                    }
                } else if (p instanceof NumericPipe) {
                    Double d;
                    boolean interpolate;
                    NumericPipe np = (NumericPipe)p;
                    boolean bl = interpolate = this.lineConnectorDetail != null && this.lineConnectorDetail.isInterpolationAvailable() && this.lineConnectorDetail.getGroupValueIndexCount() == 2;
                    if (interpolate) {
                        this.lineConnectorDetail.getGroupValueIndexCount();
                        int valueIndex1 = this.lineConnectorDetail.getGroupValueIndexAt(0);
                        int valueIndex2 = this.lineConnectorDetail.getGroupValueIndexAt(1);
                        double interpolated = this.lerp(np.getValue(valueIndex1), np.getValue(valueIndex2), this.lineConnectorDetail.getInterpolationPercent());
                        d = new Double(interpolated);
                    } else {
                        d = new Double(np.getValue(valueIndex));
                    }
                    s = format.format(d);
                    if (this.isTrimOn()) {
                        s = s.trim();
                    }
                } else if (p instanceof ColorPipe) {
                    ColorPipe cp = (ColorPipe)p;
                    Color color = cp.getValue(valueIndex);
                    s = color.toString();
                } else if (p instanceof BooleanPipe) {
                    BooleanPipe bp = (BooleanPipe)p;
                    s = Boolean.toString(bp.getValue(valueIndex));
                } else if (p instanceof IntegerPipe) {
                    IntegerPipe ip = (IntegerPipe)p;
                    s = Integer.toString(ip.getValue(valueIndex));
                } else {
                    Debug.println((String)("ProbeEntry has a bad pipe: " + p));
                    this.scratchStringBuffer.append(INVALID_PIPE);
                }
            }
            catch (MissingValueException mve) {
                this.scratchStringBuffer.append(this.getMissingReplacement(mve.getMissingValue()));
            }
        }
        return s;
    }

    public void setLineConnectorDetail(LineConnectorDetail lineConnectorDetail) {
        this.lineConnectorDetail = lineConnectorDetail;
    }

    private double lerp(double data1, double data2, double alpha) {
        return data1 + (data2 - data1) * alpha;
    }

    public String[] getValues(int valueIndex) {
        int size = this.entries.size();
        String[] values = new String[size];
        if (this.rightPad == null) {
            this.rightPad = " ";
        }
        for (int ii = 0; ii < size; ++ii) {
            ProbeEntry probeEntry = (ProbeEntry)this.entries.elementAt(ii);
            this.scratchStringBuffer.setLength(0);
            Pipe p = probeEntry.getPipe();
            p.init(this.initAction);
            String s = this.getValue(p, valueIndex);
            this.scratchStringBuffer.append(s);
            values[ii] = this.scratchStringBuffer.append(this.rightPad).toString();
        }
        return values;
    }

    public Dimension getPreferredSize(Graphics gc, int valueIndex) {
        Info info = this.calcPreferredSize(gc, valueIndex);
        return new Dimension(info.width + 3, info.height + 1);
    }

    public Info calcPreferredSize(Graphics gc, int valueIndex) {
        Info info = new Info();
        Info.access$602(info, this.getLabels());
        Info.access$702(info, this.getValues(valueIndex));
        info.size = Math.min(info.labels.length, info.values.length);
        info.maxLabelWidth = 0;
        info.maxValueWidth = 0;
        if (this.insets == null) {
            this.insets = DEFAULT_INSETS;
        }
        gc.setFont(this.font);
        FontMetrics fontMetrics = this.font == null ? gc.getFontMetrics() : gc.getFontMetrics(this.font);
        info.textHeight = fontMetrics.getHeight();
        info.ascent = fontMetrics.getAscent();
        int textBuff = this.getTextBuffer();
        info.height = this.insets.top + (info.textHeight + textBuff) * info.size - textBuff + this.insets.bottom;
        int lineCount = 0;
        for (int ii = 0; ii < info.size; ++ii) {
            info.width = fontMetrics.stringWidth(info.labels[ii]);
            if (info.width > info.maxLabelWidth) {
                info.maxLabelWidth = info.width;
            }
            this.measureAndDrawString(gc, fontMetrics, info.values[ii], 0, 0, info.textHeight, false, true, this.multiLineStringMetrics);
            info.width = this.multiLineStringMetrics.maxLineWidth;
            lineCount += this.multiLineStringMetrics.lineCount;
            if (info.width <= info.maxValueWidth) continue;
            info.maxValueWidth = info.width;
        }
        info.height = this.insets.top + (info.textHeight + textBuff) * lineCount - textBuff + this.insets.bottom;
        if (this.connectionString == null) {
            this.connectionString = DEFAULT_CONNECTION_STRING;
        }
        info.connectionStringWidth = fontMetrics.stringWidth(this.connectionString);
        info.width = this.insets.left + info.maxLabelWidth + info.connectionStringWidth + info.maxValueWidth + this.insets.right;
        return info;
    }

    public void draw(Graphics gc, int x, int y, int valueIndex) {
        Info info = this.calcPreferredSize(gc, valueIndex);
        if (info.size == 0) {
            return;
        }
        int ulx = x - info.width / 2;
        int uly = y - this.pointerOffset - info.height;
        if (this.viewport != null) {
            if (x < info.width / 2) {
                ulx = 2;
            } else if (this.viewport.x + this.viewport.width - x < info.width / 2 - 2) {
                ulx = this.viewport.x + this.viewport.width - info.width - 2;
            }
            if (y < this.pointerOffset + info.height) {
                if (info.height <= y) {
                    uly = y - this.pointerOffset - info.height;
                    if (uly <= 0) {
                        uly = 1;
                    }
                } else {
                    uly = y + this.pointerOffset;
                    if (uly + info.height > this.viewport.height && (uly = this.viewport.height - info.height - 1) < y) {
                        uly = y;
                    }
                }
            }
        }
        gc.setColor(this.backgroundColor);
        gc.fillRect(ulx, uly, info.width, info.height);
        gc.setColor(this.foregroundColor);
        gc.drawRect(ulx, uly, info.width, info.height);
        int yy = uly + info.ascent + this.insets.top;
        for (int ii = 0; ii < info.size; ++ii) {
            int lineCount = 1;
            if (info.values[ii].length() == 0) {
                gc.drawString(info.labels[ii], ulx + this.insets.left, yy);
            } else if (info.labels[ii].length() == 0) {
                this.measureAndDrawString(gc, null, info.values[ii], ulx + this.insets.left, yy, info.textHeight, true, false, this.multiLineStringMetrics);
                lineCount = this.multiLineStringMetrics.lineCount;
            } else {
                gc.drawString(info.labels[ii], ulx + this.insets.left, yy);
                gc.drawString(this.connectionString, ulx + this.insets.left + info.maxLabelWidth, yy);
                this.measureAndDrawString(gc, null, info.values[ii], ulx + this.insets.left + info.maxLabelWidth + info.connectionStringWidth, yy, info.textHeight, true, false, this.multiLineStringMetrics);
                lineCount = this.multiLineStringMetrics.lineCount;
            }
            yy += (info.textHeight + this.getTextBuffer()) * lineCount;
        }
    }

    private void measureAndDrawString(Graphics g, FontMetrics fm, String s, int x, int y, int textHeight, boolean draw, boolean computeWidth, MultiLineStringMetrics mlsm) {
        this.indexOfBreak(s, this.breakIndexInfo);
        if (this.breakIndexInfo.index < 0) {
            if (draw) {
                g.drawString(s, x, y);
            }
            if (computeWidth) {
                mlsm.maxLineWidth = fm.stringWidth(s);
                mlsm.lineCount = 1;
            }
        } else {
            int width;
            mlsm.lineCount = 0;
            mlsm.maxLineWidth = 0;
            while (this.breakIndexInfo.index >= 0) {
                String l = s.substring(0, this.breakIndexInfo.index);
                if (draw) {
                    g.drawString(l, x, y);
                }
                if (computeWidth && (width = fm.stringWidth(l)) > mlsm.maxLineWidth) {
                    mlsm.maxLineWidth = width;
                }
                y += textHeight + this.getTextBuffer();
                s = s.substring(this.breakIndexInfo.index + this.breakIndexInfo.breakLength, s.length() - 1);
                this.indexOfBreak(s, this.breakIndexInfo);
                ++mlsm.lineCount;
            }
            if (s.length() > 0) {
                if (draw) {
                    g.drawString(s, x, y);
                }
                if (computeWidth && (width = fm.stringWidth(s)) > mlsm.maxLineWidth) {
                    mlsm.maxLineWidth = width;
                }
                ++mlsm.lineCount;
            }
        }
    }

    private void indexOfBreak(String s, BreakIndexInfo bii) {
        int[] indices = new int[breakStrings.length];
        int leastIndexGreaterThanZero = -1;
        int breakLength = 0;
        for (int i = 0; i < breakStrings.length; ++i) {
            int breakIndex;
            indices[i] = breakIndex = s.indexOf(breakStrings[i]);
            if (breakIndex < 0 || leastIndexGreaterThanZero != -1 && breakIndex >= leastIndexGreaterThanZero) continue;
            leastIndexGreaterThanZero = breakIndex;
            breakLength = breakStrings[i].length();
        }
        bii.index = leastIndexGreaterThanZero;
        bii.breakLength = breakLength;
    }

    public int getProbeEntryCount() {
        return this.entries.size();
    }

    public ProbeEntry getProbeEntry(int i) {
        return (ProbeEntry)this.entries.elementAt(i);
    }

    public ProbeEntryEnumerator enumerate() {
        return new ProbeEntryEnumerator();
    }

    private static class MultiLineStringMetrics {
        public int lineCount;
        public int maxLineWidth;

        private MultiLineStringMetrics() {
        }
    }

    private static class BreakIndexInfo {
        public int index;
        public int breakLength;

        private BreakIndexInfo() {
        }
    }

    public class ProbeEntry {
        private String name;
        private Pipe pipe = null;

        ProbeEntry(String aName, Pipe aPipe) {
            this.name = aName;
            this.pipe = aPipe;
        }

        public void setName(String aName) {
            this.name = aName;
        }

        public String getName() {
            return this.name;
        }

        public void setPipe(ColorPipe aPipe) {
            this.pipe = aPipe;
        }

        public void setPipe(StringPipe aPipe) {
            this.pipe = aPipe;
        }

        public void setPipe(NumericPipe aPipe) {
            this.pipe = aPipe;
        }

        public Pipe getPipe() {
            return this.pipe;
        }

        public String getString() {
            String result = null;
            if (this.pipe instanceof StringProperty) {
                result = ((StringProperty)this.pipe).getValue();
            }
            return result;
        }
    }

    private class Lookup {
        public int i = -1;
        public ProbeEntry probeEntry = null;

        private Lookup() {
        }
    }

    private static class Info {
        private int height;
        private int width;
        private String[] labels;
        private String[] values;
        private int size;
        private int textHeight;
        private int ascent;
        private int maxLabelWidth;
        private int maxValueWidth;
        private int connectionStringWidth;

        private Info() {
        }

        static /* synthetic */ String[] access$602(Info x0, String[] x1) {
            x0.labels = x1;
            return x1;
        }

        static /* synthetic */ String[] access$702(Info x0, String[] x1) {
            x0.values = x1;
            return x1;
        }
    }

    public class ProbeEntryEnumerator
    implements Enumeration {
        private int i = 0;

        @Override
        public boolean hasMoreElements() {
            return this.i < Probe.this.entries.size();
        }

        public Object nextElement() {
            ProbeEntry pe = (ProbeEntry)Probe.this.entries.elementAt(this.i);
            ++this.i;
            return pe;
        }
    }
}

