/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.MissingValues;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.PipedVector;
import java.util.Vector;

public abstract class PrimitiveVector
extends PipedVector {
    protected double[] values;
    protected Vector missingValues;
    protected int count;
    protected int capacityIncrement;

    protected PrimitiveVector(int initialCapacity, int capacityIncrement) {
        this.values = new double[initialCapacity];
        this.capacityIncrement = capacityIncrement;
        this.count = 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public void removeAllValues() {
        this.count = 0;
        if (this.missingValues != null) {
            this.missingValues.removeAllElements();
        }
    }

    @Override
    public void removeValueAt(int index) {
        int j;
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (this.values[index] != this.values[index]) {
            for (j = 0; j < this.missingValues.size(); ++j) {
                MissingValueEntry me = (MissingValueEntry)this.missingValues.elementAt(j);
                if (me.index != index) continue;
                this.missingValues.removeElementAt(j);
            }
        }
        if ((j = this.count - index - 1) > 0) {
            System.arraycopy(this.values, index + 1, this.values, index, j);
        }
        --this.count;
    }

    @Override
    public void setSize(int newSize) {
        if (newSize > this.count && newSize > this.values.length) {
            this.ensureCapacityHelper(newSize);
        } else {
            for (int i = newSize; i < this.count; ++i) {
                this.values[i] = Double.NaN;
            }
        }
        this.count = newSize;
    }

    @Override
    public void insertValueAt(MissingValues value, int index) {
        this.insert(Double.NaN, index);
        if (this.missingValues == null) {
            this.missingValues = new Vector();
        }
        this.missingValues.addElement(new MissingValueEntry(index, value));
    }

    @Override
    public void addValue(MissingValues value) {
        this.add(Double.NaN);
        if (this.missingValues == null) {
            this.missingValues = new Vector();
        }
        this.missingValues.addElement(new MissingValueEntry(this.count - 1, value));
    }

    @Override
    public void setValueAt(MissingValues value, int index) {
        this.set(Double.NaN, index);
        if (this.missingValues == null) {
            this.missingValues = new Vector();
        }
        boolean entryExists = false;
        int missingIndex = -1;
        for (int i = 0; i < this.missingValues.size(); ++i) {
            MissingValueEntry e = (MissingValueEntry)this.missingValues.elementAt(i);
            if (e.index != index) continue;
            missingIndex = i;
            break;
        }
        if (missingIndex == -1) {
            this.missingValues.addElement(new MissingValueEntry(index, value));
        } else {
            this.missingValues.setElementAt(new MissingValueEntry(index, value), missingIndex);
        }
    }

    @Override
    public int capacity() {
        return this.values.length;
    }

    @Override
    public final boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public int getValueCount() {
        return this.size();
    }

    @Override
    public void trimToSize() {
        int capacity = this.capacity();
        if (this.count < capacity) {
            double[] oldValues = this.values;
            this.values = new double[this.count];
            System.arraycopy(oldValues, 0, this.values, 0, this.count);
        }
    }

    @Override
    public boolean isMissing(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index + " < 0");
        }
        return this.values[index] != this.values[index];
    }

    protected void ensureCapacityHelper(int minCapacity) {
        int capacity = this.capacity();
        double[] oldValues = this.values;
        int newCapacity = this.capacityIncrement > 0 ? capacity + this.capacityIncrement : capacity * 2;
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        this.values = new double[newCapacity];
        System.arraycopy(oldValues, 0, this.values, 0, this.count);
    }

    protected void insert(double value, int index) {
        int newcount = this.count + 1;
        if (index >= newcount) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this.count);
        }
        if (newcount > this.values.length) {
            this.ensureCapacityHelper(newcount);
        }
        System.arraycopy(this.values, index, this.values, index + 1, this.count - index);
        this.values[index] = value;
        ++this.count;
    }

    protected int add(double value) {
        int newcount = this.count + 1;
        if (newcount > this.values.length) {
            this.ensureCapacityHelper(newcount);
        }
        this.values[this.count++] = value;
        return this.count - 1;
    }

    protected void set(double value, int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.count);
        }
        this.values[index] = value;
    }

    protected boolean remove(double value) {
        boolean result = false;
        int i = this.indexOf(value, 0);
        if (i >= 0) {
            this.removeValueAt(i);
            result = true;
        }
        return result;
    }

    protected int indexOf(double value, int index) {
        for (int i = index; i < this.count; ++i) {
            if (value != this.values[i]) continue;
            return i;
        }
        return -1;
    }

    protected boolean contains(double value) {
        int i = this.indexOf(value, 0);
        return i >= 0;
    }

    protected int lastIndexOf(double value, int index) {
        for (int i = index; i >= 0; --i) {
            if (value != this.values[i]) continue;
            return i;
        }
        return -1;
    }

    protected double get(int index) throws MissingValueException {
        double value;
        if (index >= 0 && index < this.size()) {
            value = this.values[index];
            if (value != value) {
                MissingValueEntry entry = null;
                for (int i = 0; i < this.missingValues.size(); ++i) {
                    entry = (MissingValueEntry)this.missingValues.elementAt(i);
                    if (entry.index == index) break;
                }
                MissingValueException e = MissingValueException.getDefaultMissingValueExeption();
                e.setMissingValue(entry.missingValue);
                throw e;
            }
        } else {
            throw new MissingValueException("Index out of Range");
        }
        return value;
    }

    @Override
    public boolean containsMissing() {
        for (int i = 0; i < this.count; ++i) {
            double d = this.values[i];
            if (d == d) continue;
            return true;
        }
        return false;
    }

    private static class MissingValueEntry {
        public int index;
        public MissingValues missingValue;

        public MissingValueEntry(int index, MissingValues missingValue) {
            this.index = index;
            this.missingValue = missingValue;
        }
    }
}

