/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.OLAPLevelVariable;
import com.sas.graphics.util.gtk.OLAPListSelectionVariable;
import com.sas.graphics.util.gtk.OLAPMeasureVariable;
import com.sas.graphics.util.gtk.OLAPStringMeasureVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.datatree.DataTreeInfo;
import com.sas.graphics.util.gtk.datatree.DataTreeResponseNode;
import com.sas.graphics.util.gtk.datatree.DataTreeUtil;
import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.storage.iquery.BusinessQueryToOLAPDataSetAdapter;
import com.sas.storage.iquery.IQUeryUtil;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.ResultSetInterface;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import com.sas.text.SASFormat;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class OLAPVariableFactory {
    private ResultSetInterface resultSet;
    private ResultSetMetadataInterface resultSetMetadata;
    private HashMap dataItemToSortAxis;
    private int measureAxisNumber;
    private List categoryList = new ArrayList();
    private List numericMeasureList = new ArrayList();
    private List stringMeasureList = new ArrayList();
    private Map categoryByAxisMap = new HashMap();
    private Map uniqueNameToDataItemInfo = new HashMap();
    private int cellCount;
    private int[] minTupleDepthByAxisIndex;
    private DefaultMutableTreeNode[] leafNodeArray;
    private DataTreeGroupNode masterTreeRoot = null;
    private TupleElementInterface[][][] tupleElementCache;
    private TupleInterface[][] tupleCache;
    private AxisInterface[] axisCache;
    private StringBuffer aggregateStringBuffer = new StringBuffer();
    private List aggregateNodeList = new ArrayList();
    private HashMap hierarchyNameToIndex = new HashMap();
    private Locale locale = Locale.getDefault();

    public OLAPVariableFactory(ResultSetInterface olapDataSet) throws OLAPException {
        this.resultSet = olapDataSet;
        this.resultSetMetadata = olapDataSet.getResultSetMetadata();
        this.locale = this.findLocale();
        this.cacheData();
        if (this.cellCount > 0) {
            this.buildMasterTree();
        }
        this.freeData();
    }

    public Locale getLocale() {
        return this.locale;
    }

    private Locale findLocale() {
        Locale result = Locale.getDefault();
        if (this.resultSet instanceof BusinessQueryToOLAPDataSetAdapter) {
            BusinessQueryToOLAPDataSetAdapter a = (BusinessQueryToOLAPDataSetAdapter)this.resultSet;
            try {
                result = a.getLocale();
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return result;
    }

    public int getMeasureAxis() {
        return this.measureAxisNumber;
    }

    public int[][] getPerCellTupleCoordinates() {
        int[][] coords = new int[this.cellCount][];
        try {
            for (int i = 0; i < this.cellCount; ++i) {
                coords[i] = OLAPUtil.calculateTupleCoordinates((ResultSetMetadataInterface)this.resultSetMetadata, (int)i);
            }
        }
        catch (OLAPException e) {
            e.printStackTrace();
        }
        return coords;
    }

    public int getCellIndex(int valueIndex, String measureName) {
        DataItemInfo dio = (DataItemInfo)this.uniqueNameToDataItemInfo.get(measureName);
        if (dio == null || !dio.isMeasure()) {
            throw new IllegalArgumentException("Measure not found: " + measureName);
        }
        int measureIndex = dio.getMeasureIndex();
        OLAPDataTreeResponseNode rn = (OLAPDataTreeResponseNode)this.leafNodeArray[valueIndex];
        long[] cellIndices = (long[])rn.getUserObject();
        int result = (int)cellIndices[measureIndex];
        return result;
    }

    public int getCellIndex(int measureIndex, int valueIndex) {
        OLAPDataTreeResponseNode rn = (OLAPDataTreeResponseNode)this.leafNodeArray[valueIndex];
        long[] cellIndices = (long[])rn.getUserObject();
        long cellIndex = cellIndices[measureIndex];
        return (int)cellIndex;
    }

    public OLAPLevelVariable newLevelVariable(String levelOrHierarchyName) {
        OLAPLevelVariable v = new OLAPLevelVariable();
        v.connectFrom(this, levelOrHierarchyName);
        return v;
    }

    public OLAPMeasureVariable newMeasureVariable(String measureName) {
        OLAPMeasureVariable v = new OLAPMeasureVariable();
        v.connectFrom(this, measureName);
        return v;
    }

    public OLAPStringMeasureVariable newStringMeasureVariable(String measureName) {
        OLAPStringMeasureVariable v = new OLAPStringMeasureVariable();
        v.connectFrom(this, measureName);
        return v;
    }

    public OLAPListSelectionVariable newListSelectionVariable(ListSelectionModel listSelectionModel, String measureName) {
        OLAPListSelectionVariable v = new OLAPListSelectionVariable();
        v.connectFrom(this, listSelectionModel, measureName);
        return v;
    }

    public List getMeasureNames() {
        return this.getNumericMeasureNames();
    }

    public List getNumericMeasureNames() {
        ArrayList<String> result = new ArrayList<String>();
        int n = this.numericMeasureList.size();
        for (int i = 0; i < n; ++i) {
            DataItemInfo dio = (DataItemInfo)this.numericMeasureList.get(i);
            result.add(dio.getName());
        }
        return result;
    }

    public List getStringMeasureNames() {
        ArrayList<String> result = new ArrayList<String>();
        int n = this.stringMeasureList.size();
        for (int i = 0; i < n; ++i) {
            DataItemInfo dio = (DataItemInfo)this.stringMeasureList.get(i);
            result.add(dio.getName());
        }
        return result;
    }

    public List getLevelNames(int axisNumber) {
        List l = (List)this.categoryByAxisMap.get(new Integer(axisNumber));
        ArrayList<String> result = new ArrayList<String>();
        if (l != null) {
            int n = l.size();
            for (int i = 0; i < n; ++i) {
                DataItemInfo dio = (DataItemInfo)l.get(i);
                result.add(dio.getName());
            }
        }
        return result;
    }

    public List getHeirarchyNames(int axisNumber) {
        List l = (List)this.categoryByAxisMap.get(new Integer(axisNumber));
        LinkedList<String> list = new LinkedList<String>();
        if (l != null) {
            for (int i = 0; i < l.size(); ++i) {
                DataItemInfo dio = (DataItemInfo)l.get(i);
                String n = dio.getHierarchyName();
                if (list.contains(n)) continue;
                list.add(n);
            }
        }
        return list;
    }

    public String getHierachyName(String uniqueLevelName) {
        Object o = this.uniqueNameToDataItemInfo.get(uniqueLevelName);
        if (o instanceof DataItemInfo) {
            DataItemInfo dio = (DataItemInfo)o;
            return dio.getHierarchyName();
        }
        if (o instanceof List) {
            List l = (List)o;
            DataItemInfo dio = (DataItemInfo)l.get(0);
            return dio.getHierarchyName();
        }
        throw new IllegalArgumentException("Unknown uniqueLevelName: " + uniqueLevelName);
    }

    public int getDimensionType(String uniqueName) {
        Object o = this.uniqueNameToDataItemInfo.get(uniqueName);
        if (o instanceof DataItemInfo) {
            DataItemInfo dio = (DataItemInfo)o;
            return dio.getDimensionType();
        }
        if (o instanceof List) {
            List l = (List)o;
            DataItemInfo dio = (DataItemInfo)l.get(0);
            return dio.getDimensionType();
        }
        throw new IllegalArgumentException("Unknown uniqueLevelName: " + uniqueName);
    }

    public String getHierachyLabel(String uniqueLevelName) {
        Object o = this.uniqueNameToDataItemInfo.get(uniqueLevelName);
        if (o instanceof DataItemInfo) {
            DataItemInfo dio = (DataItemInfo)o;
            return dio.getHierarchyLabel();
        }
        if (o instanceof List) {
            List l = (List)o;
            DataItemInfo dio = (DataItemInfo)l.get(0);
            return dio.getHierarchyLabel();
        }
        throw new IllegalArgumentException("Unknown uniqueLevelName: " + uniqueLevelName);
    }

    public String getResultSetId(String uniqueLevelName) {
        DataItemInfo dio = (DataItemInfo)this.uniqueNameToDataItemInfo.get(uniqueLevelName);
        if (dio != null) {
            return dio.getResultSetId();
        }
        throw new IllegalArgumentException("Unknown uniqueLevelName: " + uniqueLevelName);
    }

    public String getUniqueLevelName(String resultSetId) {
        Collection values = this.uniqueNameToDataItemInfo.values();
        for (Object o : values) {
            DataItemInfo dio;
            String id;
            if (!(o instanceof DataItemInfo) || (id = (dio = (DataItemInfo)o).getResultSetId()) == null || !id.equals(resultSetId)) continue;
            return dio.getName();
        }
        return null;
    }

    public String getHierarchyNameFromResultId(String resultSetId) {
        Collection values = this.uniqueNameToDataItemInfo.values();
        for (Object o : values) {
            DataItemInfo dio;
            String id;
            if (!(o instanceof DataItemInfo) || (id = (dio = (DataItemInfo)o).getResultSetId()) == null || !id.equals(resultSetId)) continue;
            return dio.getHierarchyName();
        }
        return null;
    }

    public List getLevelNamesForHeirarchy(String heirarchyName) {
        ArrayList<String> list = null;
        List l = (List)this.uniqueNameToDataItemInfo.get(heirarchyName);
        if (l != null) {
            list = new ArrayList<String>();
            for (int i = 0; i < l.size(); ++i) {
                DataItemInfo dio = (DataItemInfo)l.get(i);
                list.add(dio.getName());
            }
        }
        return list;
    }

    public List getLevelLabelsForHierarchy(String heirarchyName) {
        ArrayList<String> list = null;
        List l = (List)this.uniqueNameToDataItemInfo.get(heirarchyName);
        if (l != null) {
            list = new ArrayList<String>();
            for (int i = 0; i < l.size(); ++i) {
                DataItemInfo dio = (DataItemInfo)l.get(i);
                list.add(dio.getLabel());
            }
        }
        return list;
    }

    public boolean isRaggedOrUnbalanced(int axisNumber) {
        return true;
    }

    public String getLabel(String uniqueName) {
        String result = null;
        Object o = this.uniqueNameToDataItemInfo.get(uniqueName);
        boolean isHierarchy = o instanceof List;
        if (isHierarchy) {
            List l = (List)o;
            DataItemInfo dio = (DataItemInfo)l.get(0);
            result = dio.getHierarchyLabel();
        } else {
            DataItemInfo dio = (DataItemInfo)o;
            if (dio != null) {
                result = dio.getLabel();
            }
        }
        return result;
    }

    public int getValueCount() {
        return this.leafNodeArray.length;
    }

    public String getFormat(String uniqueLevelName) {
        Object o = this.uniqueNameToDataItemInfo.get(uniqueLevelName);
        if (o instanceof DataItemInfo) {
            DataItemInfo dio = (DataItemInfo)o;
            return dio.getFormatName();
        }
        if (o instanceof List) {
            List l = (List)o;
            DataItemInfo dio = (DataItemInfo)l.get(0);
            return dio.getFormatName();
        }
        throw new IllegalArgumentException("Unknown uniqueLevelName: " + uniqueLevelName);
    }

    public Format getFormatInstance(String uniqueLevelName) {
        Object o = this.uniqueNameToDataItemInfo.get(uniqueLevelName);
        if (o instanceof DataItemInfo) {
            DataItemInfo dio = (DataItemInfo)o;
            return dio.getFormat();
        }
        if (o instanceof List) {
            List l = (List)o;
            DataItemInfo dio = (DataItemInfo)l.get(0);
            return dio.getFormat();
        }
        throw new IllegalArgumentException("Unknown uniqueLevelName: " + uniqueLevelName);
    }

    public int getAxisNumber(String uniqueLevelName) {
        Object o = this.uniqueNameToDataItemInfo.get(uniqueLevelName);
        if (o instanceof DataItemInfo) {
            DataItemInfo dio = (DataItemInfo)o;
            return dio.getAxisNumber();
        }
        if (o instanceof List) {
            List l = (List)o;
            DataItemInfo dio = (DataItemInfo)l.get(0);
            return dio.getAxisNumber();
        }
        throw new IllegalArgumentException("Unknown uniqueLevelName: " + uniqueLevelName);
    }

    public ResultSetInterface getResultSet() {
        return this.resultSet;
    }

    public ResultSetMetadataInterface getResultSetMetadata() {
        return this.resultSetMetadata;
    }

    private void computeMinTupleDepthByAxisIndex(AxisInterface[] axes) throws OLAPException {
        this.minTupleDepthByAxisIndex = new int[axes.length];
        for (int i = 0; i < axes.length; ++i) {
            if (axes[i].getAxisNumber() == -1) continue;
            this.minTupleDepthByAxisIndex[i] = this.getMinTupleDepth(axes[i]);
        }
    }

    private void createUniqueNameToDataItemInfo(AxisInterface[] axes, TupleElementInterface[][][] tupleElements) throws OLAPException {
        AxisInterface slicersAxis = null;
        for (int i = 0; i < axes.length; ++i) {
            AxisInterface axis = axes[i];
            if (axis.getAxisNumber() != -1) {
                String[] h = axis.getAxisHeaders();
                String[] uln = axis.getUniqueLevelNames();
                for (int j = 0; j < h.length; ++j) {
                    DataItemInfo dio;
                    if (this.isMeasureLevel(axis, uln[j]) || (dio = (DataItemInfo)this.uniqueNameToDataItemInfo.get(uln[j])) != null) continue;
                    this.updateCategoryBooks(uln[j], h[j], axis);
                }
                continue;
            }
            slicersAxis = axis;
        }
        if (this.categoryList.size() == 0 && slicersAxis != null) {
            String[] nameLabel = this.getSlicersNameLabel(slicersAxis);
            this.updateCategoryBooks(nameLabel[0], nameLabel[1], slicersAxis);
        }
        this.computeMeasureIndices(tupleElements);
    }

    private void updateCategoryBooks(String uniqueLevelName, String label, AxisInterface axis) throws OLAPException {
        Integer key;
        DataItemInfo dio = new DataItemInfo(axis, uniqueLevelName, label, null);
        dio.setCategoryLevel(this.categoryList.size());
        this.uniqueNameToDataItemInfo.put(uniqueLevelName, dio);
        this.uniqueNameToDataItemInfo.put(Variable.convertToNameString(uniqueLevelName), dio);
        String hName = dio.getHierarchyName();
        List<DataItemInfo> l = (ArrayList<DataItemInfo>)this.uniqueNameToDataItemInfo.get(hName);
        if (l == null) {
            l = new ArrayList<DataItemInfo>();
            this.uniqueNameToDataItemInfo.put(hName, l);
            this.uniqueNameToDataItemInfo.put(Variable.convertToNameString(hName), l);
        }
        l.add(dio);
        int axisNumber = axis.getAxisNumber();
        if (axisNumber == -1) {
            axisNumber = 0;
        }
        if ((l = (List)this.categoryByAxisMap.get(key = new Integer(axis.getAxisNumber()))) == null) {
            l = new ArrayList();
            this.categoryByAxisMap.put(key, l);
        }
        dio.setPerAxisCategoryLevel(l.size());
        l.add(dio);
        this.categoryList.add(dio);
    }

    private DataItemInfo computeMeasureIndices(TupleElementInterface[][][] tupleElements2) throws OLAPException {
        TupleElementInterface tupleElement;
        AxisInterface axis;
        int tupleElementIndex = -1;
        String name = null;
        DataItemInfo dio = null;
        ArrayList<DataItemInfo> measures = new ArrayList<DataItemInfo>();
        this.measureAxisNumber = this.calculateAxisNumberWhereMeasuresLive();
        this.computeMinTupleDepthByAxisIndex(this.axisCache);
        if (this.measureAxisNumber == -1) {
            axis = this.axisCache[this.axisCache.length - 1];
            this.computeMinTupleDepthByAxisIndex(this.axisCache);
            TupleInterface[] tuples = axis.getTuples(0, -1);
            tupleElement = this.findMeasureElement(tuples);
            if (tupleElement != null) {
                dio = new DataItemInfo(axis, tupleElement.getName(), tupleElement.getLabel(), tupleElement);
                dio.setMeasureIndex(0);
                dio.setTupleElement(tupleElement);
                name = tupleElement.getName();
                this.uniqueNameToDataItemInfo.put(name, dio);
                this.uniqueNameToDataItemInfo.put(Variable.convertToNameString(name), dio);
                measures.add(dio);
            }
        } else {
            for (int cellIndex = 0; cellIndex < this.cellCount; ++cellIndex) {
                int[] coords = OLAPUtil.calculateTupleCoordinates((ResultSetMetadataInterface)this.resultSetMetadata, (int)cellIndex);
                axis = this.axisCache[this.measureAxisNumber];
                int tupleIndex = coords[this.measureAxisNumber];
                TupleElementInterface[] tupleElements = tupleElements2[axis.getAxisNumber()][tupleIndex];
                for (tupleElementIndex = 0; tupleElementIndex < tupleElements.length; ++tupleElementIndex) {
                    tupleElement = tupleElements[tupleElementIndex];
                    name = tupleElement.getName();
                    if (!this.isMeasure(tupleElement) || (dio = (DataItemInfo)this.uniqueNameToDataItemInfo.get(name)) != null) continue;
                    dio = new DataItemInfo(axis, tupleElement.getName(), tupleElement.getLabel(), tupleElement);
                    dio.setMeasureIndex(measures.size());
                    this.uniqueNameToDataItemInfo.put(name, dio);
                    this.uniqueNameToDataItemInfo.put(Variable.convertToNameString(name), dio);
                    measures.add(dio);
                }
            }
        }
        for (int i = 0; i < measures.size(); ++i) {
            dio = (DataItemInfo)measures.get(i);
            if (dio.getMeasureType() == String.class) {
                this.stringMeasureList.add(0, dio);
                continue;
            }
            this.numericMeasureList.add(0, dio);
        }
        return dio;
    }

    public String getLevelLabel(TupleInterface tuple, String uniqueLevelName) throws OLAPException {
        String label = null;
        for (int i = 0; i < tuple.getTupleDepth(); ++i) {
            TupleElementInterface tupleElement = tuple.getElement(i);
            if (!tupleElement.getUniqueLevelName().equals(uniqueLevelName)) continue;
            label = tupleElement.getLabel();
            break;
        }
        if (label == null) {
            label = "";
        }
        return label.trim();
    }

    private int getHierarchyCount() {
        int rowCount = this.getHeirarchyNames(1).size();
        int columnCount = this.getHeirarchyNames(0).size();
        int slicerCount = this.getHeirarchyNames(-1).size();
        return rowCount + columnCount + slicerCount;
    }

    public String getLevelLabel(String uniqueName, int valueIndex) {
        String label = "";
        Object o = this.uniqueNameToDataItemInfo.get(uniqueName);
        boolean isHierarchy = o instanceof List;
        if (isHierarchy) {
            label = this.aggregateHierarchyLevelNames((OLAPDataTreeResponseNode)this.leafNodeArray[valueIndex], uniqueName);
        } else {
            DataItemInfo dio = (DataItemInfo)o;
            DataTreeGroupNode gn = DataTreeUtil.findGroupAtLevel((OLAPDataTreeResponseNode)this.leafNodeArray[valueIndex], dio.getCategoryLevel());
            if (gn != null) {
                label = gn.getFormattedValue();
            }
        }
        return label;
    }

    public String getLevelName(String hierarchyName, int valueIndex) {
        String result = null;
        Object o = this.uniqueNameToDataItemInfo.get(hierarchyName);
        boolean isHierarchy = o instanceof List;
        if (isHierarchy) {
            result = this.findLevelName((OLAPDataTreeResponseNode)this.leafNodeArray[valueIndex], hierarchyName);
        }
        return result;
    }

    public String getLowestLevelLabel(String hierarchyName, int valueIndex) {
        String result = null;
        Object o = this.uniqueNameToDataItemInfo.get(hierarchyName);
        boolean isHierarchy = o instanceof List;
        if (isHierarchy) {
            result = this.findLevelLabel((OLAPDataTreeResponseNode)this.leafNodeArray[valueIndex], hierarchyName);
        }
        return result;
    }

    private String findLevelLabel(OLAPDataTreeResponseNode leaf, String hierarchyName) {
        DataTreeGroupNode current = (DataTreeGroupNode)leaf.getParent();
        while (current.getParent() != null && !hierarchyName.equals(this.getHiercharyName(current))) {
            current = (DataTreeGroupNode)current.getParent();
        }
        return current.getFormattedValue();
    }

    private String findLevelName(OLAPDataTreeResponseNode leaf, String hierarchyName) {
        Object result = null;
        DataTreeGroupNode current = (DataTreeGroupNode)leaf.getParent();
        while (current.getParent() != null && !hierarchyName.equals(this.getHiercharyName(current))) {
            current = (DataTreeGroupNode)current.getParent();
        }
        int levelIndex = current.getLevelIndex();
        DataTreeInfo info = (DataTreeInfo)this.masterTreeRoot.getValue();
        OLAPLevelVariable var = (OLAPLevelVariable)info.getGroupVariableAt(levelIndex);
        return var.getLabel();
    }

    private String aggregateHierarchyLevelNames(OLAPDataTreeResponseNode leaf, String hierarchyName) {
        String value = leaf.getHierarchyValue(hierarchyName);
        if (value != null) {
            return value;
        }
        this.aggregateNodeList.clear();
        DataTreeGroupNode current = (DataTreeGroupNode)leaf.getParent();
        while (current.getParent() != null) {
            if (hierarchyName.equals(this.getHiercharyName(current))) {
                this.aggregateNodeList.add(current);
            }
            current = (DataTreeGroupNode)current.getParent();
        }
        int n = this.aggregateNodeList.size();
        this.aggregateStringBuffer.setLength(0);
        for (int i = n - 1; i >= 0; --i) {
            DataTreeGroupNode g = (DataTreeGroupNode)this.aggregateNodeList.get(i);
            if (this.aggregateStringBuffer.length() > 0) {
                this.aggregateStringBuffer.append(", ");
            }
            this.aggregateStringBuffer.append(g.getFormattedValue());
        }
        String an = this.aggregateStringBuffer.toString();
        leaf.setHierarchyValue(an, hierarchyName);
        return an;
    }

    private TupleElementInterface findMeasureElement(TupleInterface[] tuples) throws OLAPException {
        TupleInterface tuple = null;
        TupleElementInterface tupleElement = null;
        for (int i = 0; i < tuples.length; ++i) {
            tuple = tuples[i];
            TupleElementInterface[] tupleElements = tuple.getElements(0, -1);
            for (int j = 0; j < tupleElements.length; ++j) {
                tupleElement = tupleElements[j];
                if (!this.isMeasure(tupleElement)) continue;
                return tupleElement;
            }
        }
        return null;
    }

    public double getNumericValue(int measureIndex, int valueIndex) throws MissingValueException {
        OLAPDataTreeResponseNode rn = (OLAPDataTreeResponseNode)this.leafNodeArray[valueIndex];
        return rn.getDoubleValue(measureIndex);
    }

    public String getStringValue(int measureIndex, int valueIndex) throws MissingValueException {
        OLAPDataTreeResponseNode rn = (OLAPDataTreeResponseNode)this.leafNodeArray[valueIndex];
        return rn.getStringValue(measureIndex);
    }

    private boolean isMeasure(TupleElementInterface te) throws OLAPException {
        return te.getType() == TupleElementType.MEASURE;
    }

    private int calculateAxisNumberWhereMeasuresLive() throws OLAPException {
        for (int axisIndex = 0; axisIndex < this.axisCache.length; ++axisIndex) {
            AxisInterface axis = this.axisCache[axisIndex];
            String[] uniqueLevelNames = axis.getUniqueLevelNames();
            for (int i = 0; i < uniqueLevelNames.length; ++i) {
                if (!this.isMeasureLevel(axis, uniqueLevelNames[i])) continue;
                return axis.getAxisNumber();
            }
        }
        throw new RuntimeException("Can't find measures.");
    }

    private boolean isMeasureLevel(AxisInterface axis, String uniqueLevelName) throws OLAPException {
        boolean result = false;
        int axisIndex = this.getAxisCacheIndex(axis);
        for (int i = 0; i < this.tupleElementCache[axisIndex].length; ++i) {
            TupleElementInterface[] tes = this.tupleElementCache[axisIndex][i];
            for (int j = 0; j < tes.length; ++j) {
                TupleElementInterface te = tes[j];
                if (!te.getUniqueLevelName().equals(uniqueLevelName)) continue;
                return this.isMeasure(te);
            }
        }
        return result;
    }

    public int getMaxTupleDepth(AxisInterface axis) throws OLAPException {
        return OLAPUtil.getMaximumTupleDepth((TupleInterface[])axis.getTuples(0, -1));
    }

    public int getMinTupleDepth(AxisInterface axis) throws OLAPException {
        int minimumTupleDepth = Integer.MAX_VALUE;
        TupleInterface[] tuples = this.getTuples(axis);
        for (int i = 0; i < tuples.length; ++i) {
            if (tuples[i].getTupleDepth() >= minimumTupleDepth) continue;
            minimumTupleDepth = tuples[i].getTupleDepth();
        }
        return minimumTupleDepth;
    }

    private int getAxisCacheIndex(AxisInterface axis) throws OLAPException {
        for (int i = 0; i < this.axisCache.length; ++i) {
            if (axis.getAxisNumber() != this.axisCache[i].getAxisNumber()) continue;
            return i;
        }
        throw new RuntimeException("Can't find axis.");
    }

    private TupleInterface[] getTuples(AxisInterface axis) throws OLAPException {
        return this.tupleCache[this.getAxisCacheIndex(axis)];
    }

    private String[] getLevelNames(AxisInterface axis) throws OLAPException {
        String[] names = axis.getUniqueLevelNames();
        if (names.length <= 0 || names.length != axis.getDimensionNames().length || names[0] == null || names[0].length() == 0) {
            names = axis.getAxisHeaders();
        }
        return names;
    }

    public DataTreeGroupNode getTree() {
        DataTreeGroupNode copy = DataTreeUtil.copyTree(this.leafNodeArray);
        return copy;
    }

    public DataTreeGroupNode createSubTree(List uniqueLevelOrHierarchyNames) {
        int i;
        ArrayList path = new ArrayList();
        uniqueLevelOrHierarchyNames = this.expandHierarchies(uniqueLevelOrHierarchyNames);
        OLAPDataTreeGroupNode subTreeRoot = new OLAPDataTreeGroupNode();
        DataTreeInfo masterInfo = (DataTreeInfo)this.masterTreeRoot.getValue();
        for (i = 0; i < this.leafNodeArray.length; ++i) {
            OLAPDataTreeResponseNode rn = (OLAPDataTreeResponseNode)this.leafNodeArray[i];
            this.makePath(uniqueLevelOrHierarchyNames, rn, masterInfo, path);
            DataTreeUtil.addGroupPath(subTreeRoot, path, true);
        }
        ArrayList<DataItemInfo> dioList = new ArrayList<DataItemInfo>();
        int[] levelToLevel = new int[masterInfo.getGroupVariableCount()];
        this.clearLevelToLevel(levelToLevel);
        i = 0;
        while (i < uniqueLevelOrHierarchyNames.size()) {
            DataItemInfo dio = (DataItemInfo)this.uniqueNameToDataItemInfo.get(uniqueLevelOrHierarchyNames.get(i));
            levelToLevel[this.getMasterLevelIndex((String)dio.getName())] = i++;
            dioList.add(dio);
        }
        masterInfo = this.newDataTreeInfo(dioList, null);
        subTreeRoot.setValue(masterInfo);
        this.convertLevelIndices(subTreeRoot, levelToLevel);
        return subTreeRoot;
    }

    public DataTreeGroupNode[] createRowColumnTrees(List rowNames, List columnNames) throws OLAPException {
        DataTreeGroupNode[] roots = new DataTreeGroupNode[]{this.createSubTree(rowNames), this.createSubTree(columnNames)};
        return roots;
    }

    private void makePath(List columnNames, OLAPDataTreeResponseNode rn, DataTreeInfo info, List path) {
        path.clear();
        for (int j = 0; j < columnNames.size(); ++j) {
            String n = (String)columnNames.get(j);
            for (DataTreeGroupNode gn = (DataTreeGroupNode)rn.getParent(); gn != null && gn.getParent() != null; gn = (DataTreeGroupNode)gn.getParent()) {
                int levelIndex = gn.getLevelIndex();
                String levelName = info.getGroupVariableAt(levelIndex).getColumnName();
                if (!n.equals(levelName)) continue;
                path.add(gn);
            }
        }
    }

    private List expandHierarchies(List uniqueNames) {
        if (uniqueNames != null) {
            ArrayList<String> tempList = new ArrayList<String>();
            for (int i = 0; i < uniqueNames.size(); ++i) {
                String n = (String)uniqueNames.get(i);
                boolean isHierarchy = this.uniqueNameToDataItemInfo.get(n) instanceof List;
                if (isHierarchy) {
                    List l = this.getLevelNamesForHeirarchy(n);
                    tempList.addAll(l);
                    continue;
                }
                tempList.add(n);
            }
            return tempList;
        }
        return uniqueNames;
    }

    private void clearLevelToLevel(int[] levelToLevel) {
        for (int i = 0; i < levelToLevel.length; ++i) {
            levelToLevel[i] = -1;
        }
    }

    private int getMasterLevelIndex(String levelName) {
        int result = -1;
        DataTreeInfo mainInfo = (DataTreeInfo)this.masterTreeRoot.getValue();
        for (int i = 0; i < mainInfo.getGroupVariableCount(); ++i) {
            if (!levelName.equals(mainInfo.getGroupVariableAt(i).getColumnName())) continue;
            result = i;
            break;
        }
        return result;
    }

    private void convertLevelIndices(DataTreeGroupNode r, int[] levelToLevel) {
        Enumeration<TreeNode> e = r.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            DataTreeGroupNode gn = (DataTreeGroupNode)e.nextElement();
            if (gn.getParent() == null) continue;
            gn.setLevelIndex(levelToLevel[gn.getLevelIndex()]);
        }
    }

    private DataTreeInfo newDataTreeInfo(List categoryDataItemInfoList, List measureDataItemInfo) {
        DataItemInfo dio;
        int i;
        int n;
        DataTreeInfo info = null;
        ArrayList<OLAPLevelVariable> gv = new ArrayList<OLAPLevelVariable>();
        ArrayList<Variable> rv = new ArrayList<Variable>();
        if (categoryDataItemInfoList != null) {
            n = categoryDataItemInfoList.size();
            for (i = 0; i < n; ++i) {
                dio = (DataItemInfo)categoryDataItemInfoList.get(i);
                gv.add(this.newLevelVariable(dio.uniqueLevelName));
            }
        }
        if (measureDataItemInfo != null) {
            n = measureDataItemInfo.size();
            for (i = 0; i < n; ++i) {
                dio = (DataItemInfo)measureDataItemInfo.get(i);
                if (dio.getMeasureType() == String.class) {
                    rv.add(this.newStringMeasureVariable(dio.uniqueLevelName));
                    continue;
                }
                rv.add(this.newMeasureVariable(dio.uniqueLevelName));
            }
        }
        info = new DataTreeInfo(gv, rv);
        return info;
    }

    private void freeData() {
        this.tupleElementCache = null;
        this.tupleCache = null;
        this.axisCache = null;
    }

    private void cacheData() throws OLAPException {
        this.cellCount = (int)this.resultSet.getCellCount();
        this.axisCache = this.resultSetMetadata.getAxes(0, -1);
        this.tupleElementCache = new TupleElementInterface[this.axisCache.length][][];
        this.tupleCache = new TupleInterface[this.axisCache.length][];
        for (int a = 0; a < this.axisCache.length; ++a) {
            AxisInterface axis = this.axisCache[a];
            this.tupleCache[a] = axis.getTuples(0, -1);
            int tupleCount = this.tupleCache[a].length;
            this.tupleElementCache[a] = new TupleElementInterface[tupleCount][];
            for (int t = 0; t < tupleCount; ++t) {
                TupleInterface tuple = this.tupleCache[a][t];
                this.tupleElementCache[a][t] = tuple.getElements(0, -1);
            }
        }
    }

    private void buildMasterTree() throws OLAPException {
        int i;
        ArrayList<OLAPDataTreeGroupNode> path = new ArrayList<OLAPDataTreeGroupNode>();
        this.masterTreeRoot = new OLAPDataTreeGroupNode();
        this.createUniqueNameToDataItemInfo(this.axisCache, this.tupleElementCache);
        int measureCount = this.getMeasureNames().size();
        for (int cell = 0; cell < this.cellCount; ++cell) {
            long[] cellIndices;
            DataItemInfo dio;
            TupleElementInterface tupleElement;
            AxisInterface axis;
            boolean cellAssociatedWithTotal = false;
            path.clear();
            int measureIndex = -1;
            int[] tupleCoords = OLAPUtil.calculateTupleCoordinates((ResultSetMetadataInterface)this.resultSetMetadata, (int)cell);
            if (this.axisCache.length == 1) {
                axis = this.axisCache[0];
                String[] nameLabel = this.getSlicersNameLabel(axis);
                tupleElement = this.getSlicersMeasure(axis);
                dio = (DataItemInfo)this.uniqueNameToDataItemInfo.get(nameLabel[0]);
                path.add(new OLAPDataTreeGroupNode(dio.getCategoryLevel(), tupleElement, 0, nameLabel[1], tupleElement.getName(), tupleElement.getSpan(), tupleElement.getSpanDepth(), this.locale));
                measureIndex = 0;
            } else {
                for (int a = 0; a < tupleCoords.length; ++a) {
                    axis = this.axisCache[a];
                    if (axis.getAxisNumber() == -1) continue;
                    TupleElementInterface[] tupleElements = this.tupleElementCache[a][tupleCoords[a]];
                    for (int t = 0; t < tupleElements.length && !cellAssociatedWithTotal; ++t) {
                        tupleElement = tupleElements[t];
                        if (!this.isMeasure(tupleElement)) {
                            TupleElementInterface value = tupleElement;
                            String formattedValue = "";
                            if (this.isTotalTupleElement(tupleElement)) {
                                cellAssociatedWithTotal = true;
                                continue;
                            }
                            formattedValue = tupleElement.getLabel().trim();
                            dio = (DataItemInfo)this.uniqueNameToDataItemInfo.get(tupleElement.getUniqueLevelName());
                            if (dio == null) {
                                dio = this.findDataItemByPosition(tupleElement);
                            }
                            OLAPDataTreeGroupNode pe = new OLAPDataTreeGroupNode(dio.getCategoryLevel(), value, -1, formattedValue, tupleElement.getName(), tupleElement.getSpan(), tupleElement.getSpanDepth(), this.locale);
                            pe.clearValueIndices();
                            path.add(pe);
                            continue;
                        }
                        dio = (DataItemInfo)this.uniqueNameToDataItemInfo.get(tupleElement.getName());
                        measureIndex = dio.getMeasureIndex();
                    }
                }
            }
            if (cellAssociatedWithTotal) continue;
            DataTreeGroupNode lastGroup = DataTreeUtil.addGroupPath(this.masterTreeRoot, path, false);
            if (measureIndex == -1) {
                AxisInterface slicer = this.resultSetMetadata.getAxes(-1, 1)[0];
                TupleInterface[] tuples = slicer.getTuples(0, -1);
                tupleElement = this.findMeasureElement(tuples);
                String measureName = tupleElement.getName();
                dio = (DataItemInfo)this.uniqueNameToDataItemInfo.get(measureName);
                measureIndex = dio.getMeasureIndex();
            }
            OLAPDataTreeResponseNode rn = (OLAPDataTreeResponseNode)lastGroup.findResponseNodeChild();
            int hierarchyCount = this.getHierarchyCount();
            if (rn == null) {
                rn = new OLAPDataTreeResponseNode(measureCount, hierarchyCount);
                lastGroup.add(rn);
                cellIndices = new long[measureCount];
                for (i = 0; i < measureCount; ++i) {
                    cellIndices[i] = -1L;
                }
                rn.setUserObject(cellIndices);
            }
            Object v = this.resultSet.getCells((long)cell, (long)cell)[0];
            rn.setValue(v, measureIndex);
            cellIndices = (long[])rn.getUserObject();
            cellIndices[measureIndex] = cell;
        }
        this.removeParentResponseData(this.masterTreeRoot);
        this.leafNodeArray = DataTreeUtil.createLeafNodeArray(this.masterTreeRoot);
        ArrayList allMeasures = new ArrayList();
        allMeasures.addAll(this.numericMeasureList);
        allMeasures.addAll(this.stringMeasureList);
        DataTreeInfo info = this.newDataTreeInfo(this.categoryList, allMeasures);
        for (i = 0; i < this.leafNodeArray.length; ++i) {
            OLAPDataTreeResponseNode rn = (OLAPDataTreeResponseNode)this.leafNodeArray[i];
            for (DataTreeGroupNode gn = (DataTreeGroupNode)rn.getParent(); gn != null; gn = (DataTreeGroupNode)gn.getParent()) {
                gn.addValueIndex(i);
            }
        }
        this.masterTreeRoot.setValue(info);
    }

    private void removeParentResponseData(DataTreeGroupNode masterTreeRoot) {
        if (masterTreeRoot != null && masterTreeRoot.getChildCount() > 0) {
            ArrayList scratchList = new ArrayList();
            this.removeParentResponseDataBreadthFirst(masterTreeRoot, scratchList);
        }
    }

    private void removeParentResponseDataBreadthFirst(DataTreeGroupNode node, List scratchRemoveIndexList) {
        DefaultMutableTreeNode c;
        int i;
        scratchRemoveIndexList.clear();
        int n = node.getChildCount();
        for (i = 0; i < n; ++i) {
            c = (DefaultMutableTreeNode)node.getChildAt(i);
            if (!(c instanceof DataTreeGroupNode) || !this.isParentOfOtherMember((DataTreeGroupNode)c, node)) continue;
            scratchRemoveIndexList.add(c);
        }
        if (scratchRemoveIndexList.size() > 0) {
            int n2 = scratchRemoveIndexList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                int index = node.getIndex((DataTreeGroupNode)scratchRemoveIndexList.get(i2));
                node.remove(index);
            }
        }
        n = node.getChildCount();
        for (i = 0; i < n; ++i) {
            c = (DefaultMutableTreeNode)node.getChildAt(i);
            if (!(c instanceof DataTreeGroupNode)) continue;
            DataTreeGroupNode child = (DataTreeGroupNode)c;
            this.removeParentResponseDataBreadthFirst(child, scratchRemoveIndexList);
        }
    }

    private boolean isParentOfOtherMember(DataTreeGroupNode node, DataTreeGroupNode parent) {
        boolean result = false;
        int siblingCount = parent.getChildCount();
        if (siblingCount > 1) {
            for (int i = 0; i < siblingCount; ++i) {
                DataTreeGroupNode s;
                DefaultMutableTreeNode sibling = (DefaultMutableTreeNode)parent.getChildAt(i);
                if (sibling == node || !(sibling instanceof DataTreeGroupNode) || !(s = (DataTreeGroupNode)sibling).getTupleElementName().equals(node.getTupleElementName()) || node.getTupleElementSpan() <= s.getTupleElementSpan()) continue;
                return true;
            }
        }
        return result;
    }

    private boolean isTotalTupleElement(TupleElementInterface te) throws OLAPException {
        boolean result = false;
        if (te.getType() == TupleElementType.SUBTOTAL || te.getType() == TupleElementType.TOTAL) {
            result = true;
        }
        return result;
    }

    private DataItemInfo findDataItemByPosition(TupleElementInterface tupleElement) throws OLAPException {
        int li = OLAPVariableFactory.getAxisLevelIndex(tupleElement);
        String[] uln = tupleElement.getTuple().getAxis().getUniqueLevelNames();
        DataItemInfo dio = (DataItemInfo)this.uniqueNameToDataItemInfo.get(uln[li]);
        return dio;
    }

    private String[] getSlicersNameLabel(AxisInterface slicersAxis) throws OLAPException {
        StringBuffer name = new StringBuffer();
        StringBuffer label = new StringBuffer();
        String[] uln = this.getLevelNames(slicersAxis);
        String[] h = slicersAxis.getAxisHeaders();
        for (int tupleDepth = 0; tupleDepth < uln.length; ++tupleDepth) {
            if (this.isMeasureLevel(slicersAxis, uln[tupleDepth])) continue;
            if (name.length() != 0) {
                name.append(",");
                label.append(",");
            }
            name.append(uln[tupleDepth]);
            label.append(h[tupleDepth].trim());
        }
        return new String[]{name.toString(), label.toString()};
    }

    private TupleElementInterface getSlicersMeasure(AxisInterface slicersAxis) throws OLAPException {
        TupleElementInterface result = null;
        TupleInterface[] tuples = slicersAxis.getTuples(0, -1);
        block0: for (int i = 0; i < tuples.length; ++i) {
            TupleInterface tuple = tuples[i];
            TupleElementInterface[] tupleElements = tuple.getElements(0, -1);
            for (int j = 0; j < tupleElements.length; ++j) {
                TupleElementInterface tupleElement = tupleElements[j];
                if (!this.isMeasure(tupleElement)) continue;
                result = tupleElement;
                continue block0;
            }
        }
        return result;
    }

    public int getMeasureIndex(String uniqueLevelName) {
        DataItemInfo dio = (DataItemInfo)this.uniqueNameToDataItemInfo.get(uniqueLevelName);
        if (dio == null) {
            throw new IllegalArgumentException("Measure not found: " + uniqueLevelName);
        }
        return dio.getMeasureIndex();
    }

    public Map getLabelToTupleElementMap(String uniqueLevelName) {
        DataItemInfo dio;
        Object o = this.uniqueNameToDataItemInfo.get(uniqueLevelName);
        if (o instanceof DataItemInfo) {
            dio = (DataItemInfo)o;
        } else if (o instanceof List) {
            List l = (List)o;
            dio = (DataItemInfo)l.get(0);
        } else {
            throw new IllegalArgumentException("Unknown uniqueLevelName: " + uniqueLevelName);
        }
        if (dio.isMeasure()) {
            throw new IllegalArgumentException("Tuple element maps do not exist for measures.");
        }
        if (dio.getLabelToTupleElement() == null) {
            this.computeValueToTupleElementMap(dio);
        }
        HashMap map = new HashMap();
        map.putAll(dio.getLabelToTupleElement());
        return map;
    }

    private void computeValueToTupleElementMap(DataItemInfo dio) {
        if (dio.isMeasure()) {
            throw new IllegalStateException("Illegal operation on a measure.");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < this.leafNodeArray.length; ++i) {
            String v = this.aggregateHierarchyLevelNames((OLAPDataTreeResponseNode)this.leafNodeArray[i], dio.getHierarchyName());
            DataTreeGroupNode gn = this.findMostExpandedNodeOfHierachy((OLAPDataTreeResponseNode)this.leafNodeArray[i], dio.getHierarchyName());
            if (gn == null) continue;
            map.put(v, gn.getValue());
        }
        dio.setLabelToTupleElement(map);
    }

    private String getHiercharyName(DataTreeGroupNode n) {
        String result = null;
        if (n.getValue() instanceof TupleElementInterface) {
            int levelIndex = n.getLevelIndex();
            DataTreeInfo tti = (DataTreeInfo)this.masterTreeRoot.getValue();
            Variable v = tti.getGroupVariableAt(levelIndex);
            DataItemInfo dio = (DataItemInfo)this.uniqueNameToDataItemInfo.get(v.getName());
            result = dio.getHierarchyName();
        }
        return result;
    }

    private DataTreeGroupNode findMostExpandedNodeOfHierachy(OLAPDataTreeResponseNode leafNode, String hierarchyName) {
        DataTreeGroupNode result = null;
        for (DataTreeGroupNode current = (DataTreeGroupNode)leafNode.getParent(); current != null; current = (DataTreeGroupNode)current.getParent()) {
            if (!hierarchyName.equals(this.getHiercharyName(current))) continue;
            return current;
        }
        return result;
    }

    public static boolean nodeTupleElementsMatch(DataTreeGroupNode n1, DataTreeGroupNode n2) {
        boolean result = true;
        Object o1 = n1.getValue();
        Object o2 = n2.getValue();
        if (o1 instanceof TupleElementInterface && o2 instanceof TupleElementInterface) {
            TupleElementInterface te1 = (TupleElementInterface)o1;
            TupleElementInterface te2 = (TupleElementInterface)o2;
            try {
                result = te1.getUniqueLevelName().equals(te2.getUniqueLevelName()) && te1.getSpan() == te2.getSpan() && te1.getSpanDepth() == te2.getSpanDepth();
            }
            catch (OLAPException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static void showTree(String name, DataTreeGroupNode root) {
        root = DataTreeUtil.copyTree(DataTreeUtil.createLeafNodeArray(root));
        try {
            OLAPVariableFactory.putLabelsInUserObjects(root);
            JFrame frame = new JFrame(name);
            frame.getContentPane().setLayout(new BorderLayout());
            frame.setDefaultCloseOperation(2);
            JTree jtree = new JTree(root);
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.getViewport().add(jtree);
            frame.getContentPane().add((Component)scrollPane, "Center");
            frame.pack();
            frame.setVisible(true);
        }
        catch (OLAPException e) {
            e.printStackTrace();
        }
    }

    private static void putLabelsInUserObjects(DataTreeGroupNode root) throws OLAPException {
        Enumeration<TreeNode> e = root.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (!(o instanceof DataTreeGroupNode)) continue;
            DataTreeGroupNode n = (DataTreeGroupNode)o;
            if (n == root) {
                o = root.getValue();
                if (!(o instanceof DataTreeInfo)) continue;
                DataTreeInfo info = (DataTreeInfo)root.getValue();
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < info.getGroupVariableCount(); ++i) {
                    Variable v = info.getGroupVariableAt(i);
                    sb.append("(");
                    sb.append("name=" + v.getName());
                    sb.append(", label=" + v.getLabel());
                    if (v instanceof OLAPLevelVariable) {
                        OLAPLevelVariable ov = (OLAPLevelVariable)v;
                        sb.append(", hierarchyName=" + ov.getHierachyName());
                        sb.append(", hierarchyLabel=" + ov.getHierachyLabel());
                    }
                    sb.append(")");
                    if (i >= info.getGroupVariableCount() - 1) continue;
                    sb.append(", ");
                }
                root.setUserObject(sb.toString());
                continue;
            }
            if (!(n.getValue() instanceof TupleElementInterface)) continue;
            TupleElementInterface te = (TupleElementInterface)n.getValue();
            StringBuffer sb = new StringBuffer();
            sb.append(te.getLabel());
            Iterator iter = n.getValueIndexIterator();
            if (iter.hasNext()) {
                sb.append(", valueIndices=");
                while (iter.hasNext()) {
                    sb.append(iter.next());
                    if (!iter.hasNext()) continue;
                    sb.append(",");
                }
            }
            n.setUserObject(sb.toString());
        }
    }

    private static int getAxisLevelIndex(TupleElementInterface tupleElement) throws OLAPException {
        TupleInterface t = tupleElement.getTuple();
        int n = tupleElement.getTupleElementIndex();
        int result = tupleElement.getSpanDepth() - 1;
        for (int i = 0; i < n; ++i) {
            tupleElement = t.getElement(i);
            result += tupleElement.getSpan();
        }
        return result;
    }

    TupleElementInterface getTupleElement(String value, String uniqueLevelOrHierarchyName) {
        TupleElementInterface result = null;
        if (value != null && uniqueLevelOrHierarchyName != null) {
            DataItemInfo dio;
            Object o = this.uniqueNameToDataItemInfo.get(uniqueLevelOrHierarchyName);
            if (o instanceof DataItemInfo) {
                dio = (DataItemInfo)o;
            } else if (o instanceof List) {
                List l = (List)o;
                dio = (DataItemInfo)l.get(0);
            } else {
                throw new IllegalArgumentException("Unknown uniqueLevelOrHierarchyName: " + uniqueLevelOrHierarchyName);
            }
            if (dio.isMeasure()) {
                throw new IllegalArgumentException("Illegal operation on measure: " + uniqueLevelOrHierarchyName);
            }
            for (int i = 0; i < this.leafNodeArray.length; ++i) {
                DataTreeGroupNode gn;
                String v = this.aggregateHierarchyLevelNames((OLAPDataTreeResponseNode)this.leafNodeArray[i], dio.getHierarchyName());
                if (!value.equals(v) || (gn = this.findMostExpandedNodeOfHierachy((OLAPDataTreeResponseNode)this.leafNodeArray[i], dio.getHierarchyName())) == null) continue;
                result = (TupleElementInterface)gn.getValue();
                return result;
            }
        }
        return result;
    }

    public AxisInterface getSortAxis(TupleElementInterface tupleElement) {
        AxisInterface result = null;
        try {
            BusinessQueryToOLAPDataSetAdapter bqtodsa;
            DataItem di;
            if (tupleElement != null && this.resultSet instanceof BusinessQueryToOLAPDataSetAdapter && (di = BusinessQueryToOLAPDataSetAdapter.findDataItem((BusinessQuery)(bqtodsa = (BusinessQueryToOLAPDataSetAdapter)this.resultSet).getBusinessQuery(), null, (Object)tupleElement, (int)1)) != null && (result = this.getSortAxis(di)) == null) {
                OLAPDataSetInterface ods = null;
                try {
                    ods = IQUeryUtil.getLegendMembers((DataItem)di);
                    ResultSetMetadataInterface md = ods.getResultSetMetadata();
                    AxisInterface[] axes = md.getAxes(0, -1);
                    result = axes[0];
                    this.putSortAxis(di, result);
                }
                catch (MetadataException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
                catch (DataRetrievalException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (OLAPException e) {
            e.printStackTrace();
        }
        return result;
    }

    private AxisInterface getSortAxis(DataItem dataItem) {
        AxisInterface result = null;
        if (this.dataItemToSortAxis != null) {
            result = (AxisInterface)this.dataItemToSortAxis.get(dataItem);
        }
        return result;
    }

    private void putSortAxis(DataItem dataItem, AxisInterface axis) {
        if (this.dataItemToSortAxis == null) {
            this.dataItemToSortAxis = new HashMap();
        }
        this.dataItemToSortAxis.put(dataItem, axis);
    }

    public boolean isQuerySortRequired(String uniqueLevelOrHierarchyName) {
        DataItemInfo dio;
        Object o = this.uniqueNameToDataItemInfo.get(uniqueLevelOrHierarchyName);
        if (o instanceof DataItemInfo) {
            dio = (DataItemInfo)o;
        } else if (o instanceof List) {
            List l = (List)o;
            dio = (DataItemInfo)l.get(0);
        } else {
            throw new IllegalArgumentException("Unknown uniqueLevelName: " + uniqueLevelOrHierarchyName);
        }
        return dio.isQuerySortRequired();
    }

    private class DataItemInfo {
        private AxisInterface axis;
        private String uniqueLevelName;
        private String label;
        private String formatName;
        private SASFormat format;
        private TupleElementInterface tupleElement;
        private Class measureType = Double.class;
        private int categoryLevel = -1;
        private int perAxisCategoryLevel = -1;
        private int measureIndex = -1;
        private Map labelToTupleElement = null;
        private String dimensionName;
        private String hierarchyName;
        private String hierarchyLabel;
        private String resultSetId;
        private int dimensionType = 4;
        private TupleElementInterface categoryTupleElement = null;

        public DataItemInfo(AxisInterface axis, String uniqueLevelName, String label, TupleElementInterface tupleElement) {
            this.axis = axis;
            this.uniqueLevelName = uniqueLevelName;
            this.label = label;
            this.tupleElement = tupleElement;
            this.formatName = this.findFormat(tupleElement);
            this.findDimensionAndHierachyNames();
            this.dimensionType = this.findDimensionType();
        }

        public Class getMeasureType() {
            return this.measureType;
        }

        public String getHierarchyName() {
            return this.hierarchyName;
        }

        public String getHierarchyLabel() {
            return this.hierarchyLabel;
        }

        public boolean isFromSameHierarchy(DataItemInfo dio) {
            boolean result = false;
            String hierarchyName1 = this.getHierarchyName();
            String hierarchyName2 = dio.getHierarchyName();
            if (hierarchyName1 != null && hierarchyName2 != null && hierarchyName1.equals(hierarchyName2)) {
                result = true;
            }
            return result;
        }

        public void setLabelToTupleElement(Map map) {
            this.labelToTupleElement = map;
        }

        public Map getLabelToTupleElement() {
            return this.labelToTupleElement;
        }

        public boolean isMeasure() {
            return this.measureIndex >= 0;
        }

        public boolean isTotal(String name) {
            return name.indexOf("[Total]") >= 0;
        }

        public String getFormatName() {
            return this.formatName;
        }

        public Format getFormat() {
            if (this.format == null && this.formatName != null) {
                try {
                    SASFormat sf = SASFormat.getInstance((String)this.formatName);
                    if (sf != null && !sf.isCharacterFormat()) {
                        this.format = sf;
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return this.format;
        }

        public String getLabel() {
            return this.label;
        }

        public String getName() {
            return this.uniqueLevelName;
        }

        public int getAxisNumber() {
            int result = 0;
            try {
                result = this.axis.getAxisNumber();
            }
            catch (OLAPException e) {
                e.printStackTrace();
            }
            return result;
        }

        public TupleElementInterface getTupleElement() {
            return this.tupleElement;
        }

        public List getMemberProperties() {
            List props = null;
            return props;
        }

        public String getResultSetId() {
            if (this.resultSetId == null) {
                this.resultSetId = this.findResultSetId();
            }
            return this.resultSetId;
        }

        private void findDimensionAndHierachyNames() {
            try {
                int axisIndex = OLAPVariableFactory.this.getAxisCacheIndex(this.axis);
                for (int i = 0; i < OLAPVariableFactory.this.tupleElementCache[axisIndex].length; ++i) {
                    TupleElementInterface[] tes = OLAPVariableFactory.this.tupleElementCache[axisIndex][i];
                    for (int j = 0; j < tes.length; ++j) {
                        TupleElementInterface te = tes[j];
                        if (!te.getUniqueLevelName().equals(this.uniqueLevelName)) continue;
                        int li = OLAPVariableFactory.getAxisLevelIndex(te);
                        String[] dimensionNames = this.axis.getDimensionNames();
                        this.dimensionName = dimensionNames[li];
                        String[] hierachyNames = this.axis.getHierarchyNames();
                        this.hierarchyName = hierachyNames[li];
                        this.hierarchyLabel = this.dimensionName;
                        this.categoryTupleElement = te;
                        return;
                    }
                }
            }
            catch (OLAPException e) {
                e.printStackTrace();
            }
        }

        private int findDimensionType() {
            int result = 4;
            try {
                OLAPDataSetInterface olapDataSet = (OLAPDataSetInterface)OLAPVariableFactory.this.resultSet;
                if (this.tupleElement != null && this.tupleElement.getType() == TupleElementType.MEASURE) {
                    result = 2;
                } else {
                    Filter filter = new Filter();
                    filter.setDimensionName(this.dimensionName);
                    String cubeName = ((OLAPDataSetInterface)OLAPVariableFactory.this.resultSet).getCubeName();
                    filter.setCubeName(cubeName);
                    MetadataInterface olapMetadata = olapDataSet.getDatabaseMetadata();
                    DimensionInterface[] dimension = olapMetadata.getDimensions(filter);
                    if (dimension.length > 0) {
                        result = dimension[0].getType();
                    }
                }
            }
            catch (OLAPException e) {
                e.printStackTrace();
            }
            return result;
        }

        public void setTupleElement(TupleElementInterface tupleElement) {
            this.tupleElement = tupleElement;
        }

        private String findResultSetId() {
            String result = null;
            try {
                BusinessQueryToOLAPDataSetAdapter bqtodsa;
                DataItem di;
                TupleElementInterface te;
                TupleElementInterface tupleElementInterface = te = this.tupleElement != null ? this.tupleElement : this.categoryTupleElement;
                if (te != null && OLAPVariableFactory.this.resultSet instanceof BusinessQueryToOLAPDataSetAdapter && (di = BusinessQueryToOLAPDataSetAdapter.findDataItem((BusinessQuery)(bqtodsa = (BusinessQueryToOLAPDataSetAdapter)OLAPVariableFactory.this.resultSet).getBusinessQuery(), null, (Object)te, (int)1)) != null) {
                    result = di.getResultSetID();
                }
            }
            catch (OLAPException e) {
                e.printStackTrace();
            }
            return result;
        }

        public int getCategoryLevel() {
            return this.categoryLevel;
        }

        public void setCategoryLevel(int categoryLevel) {
            this.categoryLevel = categoryLevel;
        }

        public void setPerAxisCategoryLevel(int perAxisCategoryLevel) {
            this.perAxisCategoryLevel = perAxisCategoryLevel;
        }

        public int getPerAxisCategoryLevel() {
            return this.perAxisCategoryLevel;
        }

        public int getMeasureIndex() {
            return this.measureIndex;
        }

        public void setMeasureIndex(int measureIndex) {
            this.measureIndex = measureIndex;
        }

        public int getDimensionType() {
            return this.dimensionType;
        }

        private String findFormat(TupleElementInterface tei) {
            ResultSetInterface rs;
            String fn = null;
            if (tei != null && (rs = OLAPVariableFactory.this.resultSet) instanceof BusinessQueryToOLAPDataSetAdapter) {
                BusinessQueryToOLAPDataSetAdapter bqtodsa = (BusinessQueryToOLAPDataSetAdapter)rs;
                try {
                    fn = BusinessQueryToOLAPDataSetAdapter.getFormat((BusinessQuery)bqtodsa.getBusinessQuery(), (TupleElementInterface)tei);
                }
                catch (OLAPException e) {
                    e.printStackTrace();
                }
            }
            return fn;
        }

        public boolean isQuerySortRequired() {
            return this.dimensionType == 1;
        }
    }

    private class OLAPDataTreeResponseNode
    extends DataTreeResponseNode {
        private static final long serialVersionUID = 1L;
        private String[] categoryValueByHierarchy;

        public OLAPDataTreeResponseNode(int responseArrayLength, int hierarchyCount) {
            super(responseArrayLength);
            this.categoryValueByHierarchy = new String[hierarchyCount];
        }

        public OLAPDataTreeResponseNode(DataTreeResponseNode rn) {
            super(rn);
        }

        public void setHierarchyCount(int n) {
            this.categoryValueByHierarchy = new String[n];
        }

        public void setHierarchyValue(String value, String hierarchyName) {
            this.categoryValueByHierarchy[this.getHierarchyIndex((String)hierarchyName)] = value;
        }

        public String getHierarchyValue(String hierarchyName) {
            return this.categoryValueByHierarchy[this.getHierarchyIndex(hierarchyName)];
        }

        private int getHierarchyIndex(String hierarchyName) {
            Object o = OLAPVariableFactory.this.hierarchyNameToIndex.get(hierarchyName);
            if (o == null) {
                o = new Integer(OLAPVariableFactory.this.hierarchyNameToIndex.size());
                OLAPVariableFactory.this.hierarchyNameToIndex.put(hierarchyName, o);
            }
            int i = (Integer)o;
            return i;
        }
    }

    private static class OLAPDataTreeGroupNode
    extends DataTreeGroupNode {
        private static final long serialVersionUID = 1L;

        public OLAPDataTreeGroupNode() {
        }

        public OLAPDataTreeGroupNode(int levelIndex, Object value, int valueIndex, String formattedValue, Locale locale) {
            super(levelIndex, value, valueIndex, formattedValue, locale);
        }

        public OLAPDataTreeGroupNode(int levelIndex, Object value, int valueIndex, String formattedValue, String tupleElementName, int tupleElementSpan, int tupleElementSpanDepth, Locale locale) {
            super(levelIndex, value, valueIndex, formattedValue, tupleElementName, tupleElementSpan, tupleElementSpanDepth, locale);
        }

        protected OLAPDataTreeGroupNode(OLAPDataTreeGroupNode gn) {
            super(gn);
        }

        @Override
        public DataTreeGroupNode copy() {
            return new OLAPDataTreeGroupNode(this);
        }

        private boolean isOLAPQuerySortRequired() {
            boolean result = false;
            Variable v = this.getFirstVariable();
            if (v instanceof OLAPLevelVariable) {
                result = ((OLAPLevelVariable)v).isQuerySortRequired();
            }
            return result;
        }

        @Override
        public void sortChildren(int sortOrder, boolean compareByFormattedValue, boolean isNumeric, List scratchList) {
            if (sortOrder == 0) {
                return;
            }
            int n = this.getChildCount();
            if (n <= 1) {
                return;
            }
            if (this.isOLAPQuerySortRequired()) {
                this.sortChildrenUsingOLAPQuery(sortOrder, compareByFormattedValue, isNumeric, scratchList);
            } else {
                this.sortChildrenUsingNodeData(sortOrder, compareByFormattedValue, isNumeric, scratchList);
            }
        }

        private void sortChildrenUsingOLAPQuery(int sortOrder, boolean compareByFormattedValue, boolean isNumeric, List scratchList) {
            AxisInterface sortAxis = this.getSortAxis();
            if (sortAxis != null) {
                KeyedNode kn;
                int i;
                int n = this.getChildCount();
                if (scratchList == null) {
                    scratchList = new ArrayList<KeyedNode>();
                }
                scratchList.clear();
                for (i = 0; i < n; ++i) {
                    OLAPDataTreeGroupNode child = (OLAPDataTreeGroupNode)this.getChildAt(i);
                    kn = new KeyedNode(child, this.getKey(sortAxis, child));
                    scratchList.add(kn);
                }
                KeyedComparator comparator = new KeyedComparator(sortOrder);
                Collections.sort(scratchList, comparator);
                this.removeAllChildren();
                for (i = 0; i < n; ++i) {
                    kn = (KeyedNode)scratchList.get(i);
                    this.add(kn.getNode());
                }
            }
        }

        private AxisInterface getSortAxis() {
            DataTreeGroupNode firstChild = (DataTreeGroupNode)this.getChildAt(0);
            TupleElementInterface te = (TupleElementInterface)firstChild.getValue();
            DataTreeInfo info = (DataTreeInfo)((OLAPDataTreeGroupNode)this.getRoot()).getValue();
            OLAPLevelVariable v = (OLAPLevelVariable)info.getGroupVariableAt(0);
            OLAPVariableFactory factory = v.getFactory();
            return factory.getSortAxis(te);
        }

        private int getKey(AxisInterface axis, OLAPDataTreeGroupNode node) {
            int result = -1;
            try {
                int tupleCount = axis.getTupleCount();
                for (int i = 0; i < tupleCount; ++i) {
                    TupleElementInterface te = axis.getTuple(i).getElement(0);
                    if (!this.tupleElementsMatch(node, te)) continue;
                    return i;
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
            return result;
        }

        private boolean tupleElementsMatch(OLAPDataTreeGroupNode n, TupleElementInterface te) throws OLAPException {
            return n.getTupleElementName().equals(te.getName()) && n.getTupleElementSpan() == te.getSpan() && n.getTupleElementSpanDepth() == te.getSpanDepth();
        }

        private static class KeyedNode {
            private int key;
            private OLAPDataTreeGroupNode node;

            public KeyedNode(OLAPDataTreeGroupNode node, int key) {
                this.node = node;
                this.key = key;
            }

            public int getKey() {
                return this.key;
            }

            public OLAPDataTreeGroupNode getNode() {
                return this.node;
            }
        }

        private static class KeyedComparator
        implements Comparator {
            private int sortOrder;

            public KeyedComparator(int sortOrder) {
                this.sortOrder = sortOrder;
            }

            public int compare(Object o1, Object o2) {
                int result;
                KeyedNode n1 = (KeyedNode)o1;
                KeyedNode n2 = (KeyedNode)o2;
                int n = n1.getKey() < n2.getKey() ? -1 : (result = n1.getKey() == n2.getKey() ? 0 : 1);
                if (this.sortOrder == 2) {
                    if (result > 0) {
                        result = -1;
                    } else if (result < 0) {
                        result = 1;
                    }
                }
                return result;
            }
        }
    }
}

