/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.MissingValues;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.OLAPVariableFactory;
import java.text.Format;

public class OLAPMeasureVariable
extends NumericVariable {
    private MeasureConnection connection = new MeasureConnection();

    public OLAPVariableFactory getFactory() {
        return this.connection.getFactory();
    }

    @Override
    protected int getRawValueCount() {
        return this.connection.getValueCount();
    }

    public void connectFrom(OLAPVariableFactory olapVariableFactory, String measureName) {
        this.connection.connectFrom(olapVariableFactory, measureName);
        this.connectFrom();
    }

    @Override
    protected void connectFrom() {
        this.setRawValuePipe(this.connection, this.connection.getValueCount());
        this.setColumnName(this.connection.getName());
        if (this.getName().startsWith(defaultName)) {
            this.setName(this.connection.getName());
            this.setLabel(this.connection.getLabel());
        }
        super.connectFrom();
        if (this.connection.getFormat() != null) {
            this.setFormat(this.connection.getFormat());
        }
    }

    @Override
    public void disconnect() {
        this.connection.disconnect();
        super.disconnect();
    }

    @Override
    public boolean isRawValueMissing(int index) {
        return this.connection.isMissing(index);
    }

    public String getResultSetId() {
        return this.connection.getFactory().getResultSetId(this.connection.getName());
    }

    public int getCellIndex(int valueIndex) {
        return this.connection.getCellIndex(valueIndex);
    }

    @Override
    public void setModified(boolean modified) {
        super.setModified(modified);
        if (modified && this.connection != null) {
            this.connection.setModified();
        }
    }

    public double getValue(Object o) throws MissingValueException {
        return this.connection.getValue(o);
    }

    public String getFormattedValue(Object o) {
        try {
            return this.getFormatter().format(new Double(this.connection.getValue(o)));
        }
        catch (MissingValueException e) {
            return this.getFormatter().format(e.getMissingValue());
        }
    }

    private class MeasureConnection
    implements NumericPipe {
        private int valueCount = 0;
        private int measureIndex;
        private String label = null;
        private String name;
        private OLAPVariableFactory factory;
        private GTKFormat format = null;

        private MeasureConnection() {
        }

        @Override
        public void init(AInitAction initAction) {
            initAction.setValueCount(this.valueCount);
            initAction.setLocale(this.factory.getLocale());
        }

        @Override
        public void reset(AResetAction resetAction) {
        }

        @Override
        public Formatter getFormatter() {
            return null;
        }

        public void connectFrom(OLAPVariableFactory aFactory, String measureName) {
            this.factory = aFactory;
            this.label = aFactory.getLabel(measureName);
            this.measureIndex = aFactory.getMeasureIndex(measureName);
            this.name = measureName;
            Format f = aFactory.getFormatInstance(measureName);
            if (f != null) {
                this.format = new GTKFormat(f);
            }
            this.valueCount = aFactory.getValueCount();
        }

        public void disconnect() {
            this.factory = null;
            this.valueCount = 0;
            this.format = null;
        }

        public String getLabel() {
            return this.label;
        }

        public String getName() {
            return this.name;
        }

        public GTKFormat getFormat() {
            return this.format;
        }

        public boolean isMissing(int valueIndex) {
            boolean result = false;
            try {
                this.getValue(valueIndex);
            }
            catch (MissingValueException e) {
                result = true;
            }
            return result;
        }

        @Override
        public double getValue(int valueIndex) throws MissingValueException {
            double d;
            if (OLAPMeasureVariable.this.isFreqVariable()) {
                try {
                    d = this.factory.getNumericValue(this.measureIndex, valueIndex);
                }
                catch (MissingValueException mve) {
                    d = 0.0;
                }
                d = OLAPMeasureVariable.this.transformFrequencyValue(d);
            } else {
                d = this.factory.getNumericValue(this.measureIndex, valueIndex);
            }
            return d;
        }

        public double getValue(Object o) throws MissingValueException {
            double d = Double.NaN;
            if (OLAPMeasureVariable.this.isFreqVariable()) {
                if (o instanceof Number) {
                    d = ((Number)o).doubleValue();
                }
                d = OLAPMeasureVariable.this.transformFrequencyValue(d);
            } else if (o instanceof Number) {
                d = ((Number)o).doubleValue();
            } else if (o instanceof MissingValues) {
                MissingValueException e = MissingValueException.getDefaultMissingValueExeption();
                e.setMissingValue((MissingValues)o);
                throw e;
            }
            return d;
        }

        public void setModified() {
        }

        public int getValueCount() {
            return this.valueCount;
        }

        public int getCellIndex(int valueIndex) {
            int result = this.factory.getCellIndex(this.measureIndex, valueIndex);
            return result;
        }

        public OLAPVariableFactory getFactory() {
            return this.factory;
        }
    }
}

