/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.OLAPVariableFactory;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import java.util.List;

public class OLAPLevelVariable
extends StringVariable {
    private LevelConnection connection = new LevelConnection();

    public OLAPVariableFactory getFactory() {
        return this.connection.getFactory();
    }

    @Override
    protected int getRawValueCount() {
        return this.connection.getValueCount();
    }

    public void connectFrom(OLAPVariableFactory factory, String levelName) {
        this.connection.connectFrom(factory, levelName);
        this.connectFrom();
    }

    @Override
    protected void connectFrom() {
        this.setRawValuePipe(this.connection, this.connection.getValueCount());
        this.setColumnName(this.connection.getName());
        if (this.getName().startsWith(defaultName)) {
            this.setName(this.connection.getName());
            this.setLabel(this.connection.getLabel());
        }
        super.connectFrom();
        if (this.connection.getFormat() != null) {
            this.setFormat(this.connection.getFormat());
        }
    }

    @Override
    public void disconnect() {
        this.connection.disconnect();
        super.disconnect();
    }

    @Override
    public boolean isRawValueMissing(int index) {
        return this.connection.isMissing(index);
    }

    @Override
    public void setModified(boolean modified) {
        super.setModified(modified);
        if (modified && this.connection != null) {
            this.connection.setModified();
        }
    }

    public String getHierachyName() {
        return this.connection.getFactory().getHierachyName(this.connection.getName());
    }

    public int getDimensionType() {
        return this.connection.getFactory().getDimensionType(this.connection.getName());
    }

    public String getHierachyLabel() {
        return this.connection.getFactory().getHierachyLabel(this.connection.getName());
    }

    public List getLevelNames() {
        return this.connection.getFactory().getLevelLabelsForHierarchy(this.getHierachyName());
    }

    public String getLevelName(int valueIndex) {
        return this.connection.getLevelName(valueIndex);
    }

    public String getLowestLevelLabel(int valueIndex) {
        return this.connection.getLowestLevelLabel(valueIndex);
    }

    public String getValue(String memberName) {
        String result = null;
        int n = this.getValueCount();
        for (int i = 0; i < n; ++i) {
            try {
                String s = this.value.getValue(i);
                TupleElementInterface te = this.getTupleElement(s);
                if (te == null || !te.getName().equals(memberName)) continue;
                result = s;
                break;
            }
            catch (MissingValueException missingValueException) {
                continue;
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return result;
    }

    public TupleElementInterface getTupleElement(String value) {
        return this.connection.getTupleElement(value);
    }

    public boolean isQuerySortRequired() {
        return this.connection.isQuerySortRequired();
    }

    private static class LevelConnection
    implements StringPipe {
        private String uniqueLevelOrHierarchyName;
        private int valueCount = 0;
        private String label;
        private OLAPVariableFactory factory;

        private LevelConnection() {
        }

        @Override
        public void init(AInitAction initAction) {
            initAction.setValueCount(this.valueCount);
            initAction.setLocale(this.factory.getLocale());
        }

        public boolean isQuerySortRequired() {
            return this.factory.isQuerySortRequired(this.uniqueLevelOrHierarchyName);
        }

        @Override
        public void reset(AResetAction resetAction) {
        }

        @Override
        public Formatter getFormatter() {
            return null;
        }

        public void connectFrom(OLAPVariableFactory factory, String uniqueLevelName) {
            this.factory = factory;
            this.uniqueLevelOrHierarchyName = uniqueLevelName;
            this.label = factory.getLabel(uniqueLevelName);
            this.valueCount = factory.getValueCount();
        }

        public void disconnect() {
            this.factory = null;
            this.valueCount = 0;
        }

        public String getName() {
            return this.uniqueLevelOrHierarchyName;
        }

        public String getLabel() {
            return this.label;
        }

        public GTKFormat getFormat() {
            return null;
        }

        public boolean isMissing(int index) {
            return false;
        }

        public void setModified() {
        }

        @Override
        public String getValue(int valueIndex) throws MissingValueException {
            return this.factory.getLevelLabel(this.uniqueLevelOrHierarchyName, valueIndex);
        }

        public String getLevelName(int valueIndex) {
            return this.factory.getLevelName(this.uniqueLevelOrHierarchyName, valueIndex);
        }

        public String getLowestLevelLabel(int valueIndex) {
            return this.factory.getLowestLevelLabel(this.uniqueLevelOrHierarchyName, valueIndex);
        }

        public int getValueCount() {
            return this.valueCount;
        }

        public OLAPVariableFactory getFactory() {
            return this.factory;
        }

        public TupleElementInterface getTupleElement(String value) {
            return this.factory.getTupleElement(value, this.uniqueLevelOrHierarchyName);
        }
    }
}

